/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: selfdispatcher.cxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 01:21:34 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_UTIL_XURLTRANSFORMER_HPP_
#include <com/sun/star/util/XURLTransformer.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_XDISPATCHPROVIDER_HPP_
#include <com/sun/star/frame/XDispatchProvider.hpp>
#endif

#ifndef _COM_SUN_STAR_UTIL_XCLOSEABLE_HPP_
#include <com/sun/star/util/XCloseable.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_XCONTROLLER_HPP_
#include <com/sun/star/frame/XController.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_XMODEL_HPP_
#include <com/sun/star/frame/XModel.hpp>
#endif

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________

#ifndef __FRAMEWORK_DISPATCH_SELFDISPATCHER_HXX_
#include <dispatch/selfdispatcher.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_TRANSACTIONGUARD_HXX_
#include <threadhelp/transactionguard.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_READGUARD_HXX_
#include <threadhelp/readguard.hxx>
#endif

#ifndef __FRAMEWORK_CLASSES_ARGUMENTANALYZER_HXX_
#include <classes/argumentanalyzer.hxx>
#endif

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	includes of other projects
//_________________________________________________________________________________________________________________

#include <toolkit/helper/vclunohelper.hxx>
#include <vcl/window.hxx>
#include <vcl/wrkwin.hxx>
#include <vcl/svapp.hxx>

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework{

//_________________________________________________________________________________________________________________
//	non exported const
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	non exported definitions
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	declarations
//_________________________________________________________________________________________________________________

/*-************************************************************************************************************//**
    @short      standard ctor
    @descr      These initialize a new instance of this class with needed informations for work.

    @seealso    using at owner

    @param      "xFactory", reference to servicemanager for creation of new services
    @param      "xTarget" , reference to our owner frame
    @return     -

    @onerror    -
*//*-*************************************************************************************************************/
SelfDispatcher::SelfDispatcher( const css::uno::Reference< css::lang::XMultiServiceFactory >& xFactory   ,
                                const css::uno::Reference< css::frame::XFrame >&              xTarget    )
		//	Init baseclasses first
        :   BaseDispatcher( xFactory, xTarget  )
{
}

/*-************************************************************************************************************//**
    @interface  XDispatch
    @short      try to handle(!) or load URL with arguments into our owner frame
    @descr      We try to handle it first. If this will fail - we start loading of it into
                our owner frame. Some started proccesses are asynchron. So we are listener for different callbacks.
                In "reactForLoadingState()" we can react for state of our dispatch operation ... e.g. reactivation of
                suspended controller.

    @attention  These listener mechanism is implemented by our base class "BaseDispatcher"! So we don't must look at it ...
                Overwrite dispatch() and reactForLoadingState() only. Base class call this one.

    @seealso    baseclass BaseDispatcher
    @seealso    method reactForLoadingState()

    @param      "aURL"      , URL to dispatch.
    @param      "lArguments", list of optional arguments.
    @return     -

    @onerror    -
    @threadsafe yes
*//*-*************************************************************************************************************/
void SAL_CALL SelfDispatcher::dispatch( const css::util::URL&                                  aURL       ,
                                        const css::uno::Sequence< css::beans::PropertyValue >& lArguments ) throw( css::uno::RuntimeException )
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( m_aTransactionManager, E_HARDEXCEPTIONS );

    /* SAFE AREA ----------------------------------------------------------------------------------------------- */
    // Make snapshot of neccessary member.
    ReadGuard aReadLock( m_aLock );
    // Warn programmer. If our owner is dead ... something will be wrong then.
    // We are listener for dispose() on it!
    css::uno::Reference< css::frame::XFrame > xTarget( m_xOwner.get(), css::uno::UNO_QUERY );
    LOG_ASSERT2( xTarget.is()==sal_False, "SelfDispatcher::dispatch()", "Couldn't get owner reference! Algorithm error?" )
    aReadLock.unlock();
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */

    sal_Bool                                        bDispatched = sal_False   ;
    css::uno::Sequence< css::beans::PropertyValue > lDescriptor ( lArguments );

    //-------------------------------------------------------------------------------------------------------------
    // I)   Check for relative URL's first. They couldn't be detected or handled!
    //      They must be loaded into the same frame directly.
    //      Declare bool to suppress detection and handling.
    sal_Bool bRelativeURL = sal_False;
    if( aURL.Complete.indexOf( '#', 0 ) == 0 )
    {
        bRelativeURL = sal_True;
    }

    //-------------------------------------------------------------------------------------------------------------
    // II)  Otherwise we must know type of dispatch URL. It's neccessary to find registered handler or loader.
    //      But we must copy given argument descriptor. Because; detection, handling or loading of URL
    //      will change this descriptor. And it's not a good idea to do that on a const parameter!
    ::rtl::OUString sTypeName = implts_detectType( aURL, lDescriptor, sal_True ); // last parameter allow deep detection!

    //-------------------------------------------------------------------------------------------------------------
    // II)  Try to handle it. In this case we doesn't need our target realy!
    //      We forward it to a special registered handler service and wait for his callbacks.
    //      Check type name before! If automatic detection failed AND user don't select any filter
    //      in our filter dialog (implts_askTyp()!) ... this case will occure. So we should do nothing.
    if( sTypeName.getLength() > 0 )
    {
        bDispatched = implts_handleIt( aURL, lDescriptor, sTypeName );
    }

    //-------------------------------------------------------------------------------------------------------------
    // III) If handling failed ... try to load it.
    if(
        ( bDispatched           == sal_False )   &&
        ( xTarget.is()          == sal_True  )   &&
        ( sTypeName.getLength() >  0         )
      )
    {
        //-------------------------------------------------------------------------------------------------------------
        // III.a)   We try to load a new component into our target frame. If an controller already exist - we must supsend it.
        //          If loading failed - we can reactivate it. But if deactivation failed - we must break this dispatch call!
        //          (You mustn't check controller reference ... impl-method do that for you.)
        css::uno::Reference< css::frame::XController > xController = xTarget->getController();
        if( implts_deactivateController( xController ) == sal_True )
        {
            bDispatched = implts_loadIt( aURL, lDescriptor, sTypeName, xTarget );
            // Attention: DON'T reactivate controller here!
            // bDispatched isn't a state of finished loading operation. It is a state of successfully started loading proccesses!
            // And if it fail - we will call our own reactForLoadingState() method at the end of this method!!!
            // Please reactivate controller there.
        }
    }

    // Normal our base class handle sending of status events to our listener ...
    // But if this method failed (e.g. target not exist, neccessary services couldn't be getted ...)
    // we must send our own event!
    if( bDispatched == sal_False )
    {
        implts_sendResultEvent( xTarget, aURL.Complete, sal_False );
    }
}

/*-************************************************************************************************************//**
    @short          react for return state of dispatch call
    @descr          If we started our dispatch call ... our baseclass call us back to give us some informations about it.
                    So we can react for it. e.g. If dispatch failed we must reactivate a suspended controller - if anyone exist!

                    We are called back in: a) "reactForLoadingState()" , if URL was loaded into our owner frame
                                           b) "reactForHandlingState()", if URL was handled by a registered content handler without using of our owner frame!

    @attention      Base class call us back without any set lock or mutex. So we must do it by ourself!
                    BUT ... We don't need any lock here yet ... we don't work on internal member!
                    If YOU change it ... you should think about it again ...

    @seealso        base class BaseDispatcher

    @param          "aURL"       , dispatched URL
    @param          "lDescriptor", optional arguments of original dispatch call
    @param          "xTarget"    , target of dispatch (should be our owner)
    @param          "bState"     , state of loading proccess (ok or failed)
    @return         -

    @onerror        -
    @threadsafe     yes
*//*-*************************************************************************************************************/
void SAL_CALL SelfDispatcher::reactForLoadingState( const css::util::URL&                                   aURL        ,
                                                    const css::uno::Sequence< css::beans::PropertyValue >&  lDescriptor ,
                                                    const css::uno::Reference< css::frame::XFrame >&        xTarget     ,
                                                          sal_Bool                                          bState      ,
                                                    const css::uno::Any&                                    aAsyncInfo  )
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( m_aTransactionManager, E_HARDEXCEPTIONS );

    if( bState == sal_True )
    {
        implts_enableFrame( xTarget, lDescriptor );
    }
    else
    {
        css::uno::Reference< css::frame::XController > xController = xTarget->getController();
        if( implts_reactivateController( xController ) == sal_False )
        {
            implts_disableFrame( xTarget );
        }
    }
}

//*****************************************************************************************************************
void SAL_CALL SelfDispatcher::reactForHandlingState( const css::util::URL&                                  aURL        ,
                                                     const css::uno::Sequence< css::beans::PropertyValue >& lDescriptor ,
                                                           sal_Bool                                         bState      ,
                                                     const css::uno::Any&                                   aAsyncInfo  )
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
    // Register transaction and reject wrong calls.
    // TransactionGuard aTransaction( m_aTransactionManager, E_HARDEXCEPTIONS );

    /* TODO?!

        I don't know, what I can do here ... URL was handled without using of our owner frame.
        There is nothing to do. Listener are informaed by our baseclass automaticly - frame mustn't be
        initialized or deinitialized.
     */
}

}		//	namespace framework
