/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: app.hxx,v $
 *
 *  $Revision: 1.43 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 16:43:29 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SFXAPP_HXX
#define _SFXAPP_HXX

#ifndef TD_NEWDESKTOP
#define TF_NEWDESKTOP 1
#endif

#ifndef _SAL_CONFIG_H_
#include "sal/config.h"
#endif

#ifndef INCLUDED_SFX2_DLLAPI_H
#include "sfx2/dllapi.h"
#endif

#ifndef _SAL_TYPES_H_
#include "sal/types.h"
#endif
#ifndef _SOLAR_H
#include <tools/solar.h>
#endif

#if _SOLAR__PRIVATE
#ifndef _TIME_HXX //autogen
#include <tools/time.hxx>
#endif
#ifndef _SV_ACCEL_HXX //autogen
#include <vcl/accel.hxx>
#endif
#ifndef _TIMER_HXX //autogen
#include <vcl/timer.hxx>
#endif
#endif

#include <vcl/svapp.hxx>
#ifndef _SFXSMPLHINT_HXX //autogen
#include <svtools/smplhint.hxx>
#endif
#ifndef _SFXPOOLITEM_HXX //autogen
#include <svtools/poolitem.hxx>
#endif
#ifndef _ERRCODE_HXX //autogen
#include <tools/errcode.hxx>
#endif
#ifndef _REF_HXX //autogen
#include <tools/ref.hxx>
#endif
#ifdef ENABLE_INIMANAGER//MUSTINI
#include <svtools/iniman.hxx>
#endif

#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif
#ifndef _COM_SUN_STAR_SCRIPT_XLIBRARYCONTAINER_HPP_
#include <com/sun/star/script/XLibraryContainer.hpp>
#endif
#ifndef _COM_SUN_STAR_TASK_XSTATUSINDICATOR_HPP_
#include <com/sun/star/task/XStatusIndicator.hpp>
#endif

// whatwever will be today's name for explorer/frameset-docs
#define SFX_DESKTOP_HELPFILE_NAME "desktop"

#include "shell.hxx"

#define PLUG_BROWSEHACK     42

#define SFX_DEMOKIND_FULL      1
#define SFX_DEMOKIND_COMPACT   2
#define SFX_DEMOKIND_TRYBUY    3
#define SFX_DEMOKIND_DEMO      4
#define SFX_DEMOKIND_INVALID   5
#define SFX_DEMOKIND_OLDTRYBUY 6
#define SFX_DEMOKIND_RUNTIME   7

enum SfxDBNameConvert {INI2NATIONAL, NATIONAL2INI };

#define SFX_BASICLIB_ADDMODE_NORMAL 	0
#define SFX_BASICLIB_ADDMODE_REFERENCE 	1
#define SFX_BASICLIB_ADDMODE_EXTERNAL 	2

class ISfxTemplateCommon;
class TaskBar;
class BasicManager;
class DdeService;
class GenLink;
class IntroWindow_Impl;
class ModalDialog;
class PrinterDialog;
class SfxHelpPI;
class DropEvent;
class OutputDevice;
class KeyEvent;
class Point;
class Rectangle;
class AppSettings;

struct SfxChildWinContextFactory;
class SfxAcceleratorManager;
class SfxAppData_Impl;
class SfxApplication;
class SfxBasicTestWin;
class SfxBindings;
class SfxCancelManager;
class SfxChildWinFactArr_Impl;
class SfxChildWindow;
class SfxConfigManager;
class SfxDispatcher;
class SfxEventConfiguration;
class SfxEventHint;
class SfxFilter;
class SfxHint;
class SfxInterface;
class SfxItemHandle;
class SfxItemSet;
class SfxMacroConfig;
class SfxMedium;
class SfxMediumList;
class SfxMenuBarManager;
class SfxMenuCtrlFactArr_Impl;
class SfxNewFileDialog;
class SfxObjectFactory;
class SfxObjectFactoryArr_Impl;
class SfxObjectShell;
class SfxObjectShellArr_Impl;
class SfxOptions;
class SfxProgress;
class SfxResourceManager;
class SfxShellObject;
class SfxSlot;
class SfxSlotPool;
class SfxStatusBarManager;
class SfxStbCtrlFactArr_Impl;
class SfxTabDialog;
class SfxTbxCtrlFactArr_Impl;
class SfxTemplateDialog;
class SfxToolBoxConfig;
class SfxViewFrame;
class SfxViewFrameArr_Impl;
class SfxViewShell;
class SfxViewShellArr_Impl;
class StarBASIC;
class SvData;
class SvPseudoObject;
class HelpPI;
class SfxWorkWindow;
class SfxFilterMatcher;
class SfxFrame;
class Menu;
class SvUShorts;
class SfxModule;
class SfxModuleArr_Impl;
class ISfxModule;
class SfxObjectShellLock;
class Window;
class Config;
class TaskStatusBar;
class INetURLObject;
class SvStringsDtor;
class SfxMiscCfg;
struct SfxConstant;
struct SfxChildWinFactory;
struct SfxMenuCtrlFactory;
struct SfxStbCtrlFactory;
struct SfxTbxCtrlFactory;
class SfxApplicationWindow;
class SimpleResMgr;

namespace sfx2
{
	class SvLinkSource;
};

#define STARAPP_VERB "STARAPP"
#define PRESENTATION_LIVEMODE       ((USHORT)0x1000)
#define DYNAMIC_USERID_OFFSET	1000

//--------------------------------------------------------------------

/* [Beschreibung]

   Beim html Filter steht mit der Auswahl des Filter noch nicht die
   ObjectFactory fest. Daher wird zunaechst eine Writer Shell angelegt
   (bzw. die FilterDetection ist derart anzupassen, dass dies
   geschieht).  Das im ConvertFrom uebergebene Medium enthaelt im
   ItemSet unter SID_LOADENVIRONMENT ein SfxRefItem, welches ein
   SfxLoadEnvironment enthaelt. Dort ist dann ein DataAvailableLink zu
   setzen, ueber den der Import vom Vorliegen weiterer Daten Kenntnis
   erhaelt.

   Gelangt das ConvertFrom zu einer Entscheidung ueber die vorliegende
   Objectshell und ist dies eine FramesetObjectshell, so wird das
   Frameset asynchron bis zum Ende durchgeparsed anschliessend
   DocumentDetected mit der ObjectShell, bzw. mit einem Fehlercode und
   pObjSh = 0, falls zu diesem Zeitpunkt bereits eine Fehler
   aufgetreten ist, aufgerufen. Liegt ein Writer HTML Doc vor, wird direkt
   DocumentDetected gerufen.

   Daraufhin erzeugt der Sfx eine View auf das uebergebene Dokument
   und nimmt seine Referenz auf die WriterObjectShell fort, falls eine
   FramesetObjectshell uebergeben wurde (Der Parser muss also selbst
   eine halten, falls er sie noch braucht). Ausserdem wird das Item
   SID_LOADENVIRONMENT aus dem Itemset genommen (Also auch hier eine
   eigene Referenz halten, damit der DataAvailableLink weiter gerufen
   werden kann!)

*/

// class SfxSysChangeHint --------------------------------------------

class SfxSysChangeHint : public SfxHint
{
    USHORT              _nType;
    AppSettings&        _rAppSettings;
public:
                        TYPEINFO();
                        SfxSysChangeHint(USHORT nType, const AppSettings &rSet )
                        : _nType(nType), _rAppSettings((AppSettings&) rSet) {}
    USHORT              GetChangeType() const { return _nType; }
    const AppSettings&  GetAppSettings() const { return _rAppSettings; }
};

//--------------------------------------------------------------------

/*  [Beschreibung]

    Kurzschreibweise f"ur SfxGetpApp(). Liefert den Pointer auf die
    SfxApplication Instanz.
*/

#define SFX_APP() SfxGetpApp()
#define OFF_APP() SfxGetpApp()

//====================================================================

class SfxLinkItem : public SfxPoolItem
{
    Link aLink;
public:
    virtual SfxPoolItem*     Clone( SfxItemPool *pPool = 0 ) const
    {   return new SfxLinkItem( *this ); }
    virtual int              operator==( const SfxPoolItem& rL) const
    {   return ((SfxLinkItem&)rL).aLink == aLink; }
    SfxLinkItem( USHORT nWhich, const Link& rValue ) : SfxPoolItem( nWhich )
    {   aLink = rValue; }
    const Link&              GetValue() const { return aLink; }
};

DECL_OBJHINT( SfxStringHint, String );

typedef SfxPoolItem* (*SfxItemCreateFunc)();

class SfxItemFactory_Impl;
class SfxItemFactoryList
{
    List aList;
public:
    ~SfxItemFactoryList();

    SfxItemFactory_Impl* GetFactory_Impl( const SvGlobalName& rName ) const;
    SfxItemFactory_Impl* GetFactory_Impl( TypeId ) const;
    const SvGlobalName* GetGlobalName( const SfxPoolItem* pItem ) const;
    SfxPoolItem* Create(
        const SvGlobalName& rName, USHORT nId, SvStream* pStrm = 0) const;
    void         RegisterItemFactory(
        const SvGlobalName& rName, SfxItemCreateFunc );
};

#define REGISTER_ITEM( ItemClass, aGlobName )                                 \
RegisterItemFactory( aGlobName, ( SfxItemCreateFunc) ItemClass::StaticType() );


#ifndef SFX_DECL_OBJECTSHELL_DEFINED
#define SFX_DECL_OBJECTSHELL_DEFINED
SV_DECL_REF(SfxObjectShell)
SV_DECL_LOCK(SfxObjectShell)
#endif

void RegisterServices();

struct SfxApplication_Impl;
class SFX2_DLLPUBLIC SfxApplication: public SfxShell

/*  [Beschreibung]

    Die Klasse SfxApplication bietet eine erweiterte Funktionalit"at
    der StarView-Klasse MDIApplication und muss als Basisklasse fuer
    Applikationen, die das StarFramework verwenden wollen,
    eingesetzt werden.

    Sie bietet verschiedene Factories und Hooks in Form von
    virtuellen Methoden, um das default-Verhalten zu modifizieren.


    [Anmerkung]
    Von dieser Klasse muss jede StarFramework-Applikation genau
    eine Instanz anlegen.
*/

{
    SAL_DLLPRIVATE static ::osl::Mutex gMutex;
	SAL_DLLPRIVATE static SfxApplication* pApp;
	struct SfxApplication_Impl* pImp;

    ULONG                       _nFeatures;
    SfxViewFrame*               pViewFrame;
    SfxSlotPool*                pSlotPool;
    SfxResourceManager*         pResMgr;
    SfxDispatcher*              pAppDispat;     // Dispatcher falls kein Doc
    SfxMenuBarManager*          pMenuMgr;
    SfxAcceleratorManager*      pAcceleratorMgr;
    SfxStatusBarManager*        pStatusBarMgr;
    SfxConfigManager*           pCfgMgr;    	// bin"are Config, "ubergreifend
    SfxOptions*                 pOptions;
    SfxAppData_Impl*            pAppData_Impl;

    USHORT                      nInterfaces;
    SfxInterface**              pInterfaces;

    BOOL                        bDispatcherLocked:1;    // nichts ausf"uhren
    BOOL                        bInInit:1;    // TRUE solange in Initialisierung
    BOOL                        bInExit:1;    // TRUE solange in Deinit.
    BOOL                        bDowning:1;   // TRUE ab Exit und danach
	BOOL						bCreatedExternal : 1;

#if _SOLAR__PRIVATE
	DECL_DLLPRIVATE_LINK(		AutoStart_Impl, void* );
	DECL_DLLPRIVATE_LINK(		SpecialService_Impl, void* );
    SAL_DLLPRIVATE void         HandleConfigError_Impl(USHORT nErrId) const;
    DECL_DLLPRIVATE_LINK(		AutoSaveHdl_Impl, Timer* );
    SAL_DLLPRIVATE BOOL         SaveAll_Impl(BOOL bPrompt = FALSE, BOOL bAutoSave = FALSE);
    SAL_DLLPRIVATE short        QuerySave_Impl(SfxObjectShell &, BOOL bAutoSave = FALSE);
    SAL_DLLPRIVATE void         TestFreeResources_Impl();
	SAL_DLLPRIVATE void			InitializeDisplayName_Impl();
#endif

    SAL_DLLPRIVATE static SfxApplication* Create();

protected:
    void                		SettingsChange( USHORT, const AppSettings & );
    FASTBOOL            		IsDemo();

    virtual void                Init();
    virtual void                Exit();

	static void					SetApp( SfxApplication *pDerived );

public:
    void                		OpenClients();
                                TYPEINFO();
                                SFX_DECL_INTERFACE(SFX_INTERFACE_SFXAPP);

								SfxApplication();
                                ~SfxApplication();

    virtual void                Main( );

    void                		PreInit( );
	static SfxApplication*		GetOrCreate();
    void                		Quit();
	bool						InitLabelResMgr( const char* _pLabelPrefix, bool _bException = false );
	void						HandleAppEvent( const ApplicationEvent& rAppEvent );
	void						FocusChanged();

    ULONG                       LoadTemplate( SfxObjectShellLock& xDoc, const String& rFileName, BOOL bCopy=TRUE, SfxItemSet* pArgs = 0 );

    String&                     GetSaveAsTargetURLHack();
    SfxFilterMatcher&           GetFilterMatcher();

    SfxViewFrame*       		CreateViewFrame( SfxObjectShell& rDoc,
                                                 USHORT nViewId=0,
												 BOOL bHidden=FALSE );
/*
    ULONG                       DetectFilter( const String &rFileName,
                                              const SfxFilter **pFilter,
                                              USHORT nFilterClass=USHRT_MAX );
*/
    virtual void            	FillStatusBar( StatusBar& );

    PrinterDialog*      		CreatePrinterDialog();
    ModalDialog*        		CreateAboutDialog();
    SfxNewFileDialog*   		CreateNewDialog();
/*
    ULONG               		DetectFilter( SfxMedium& rMedium,
                            	                  const SfxFilter **pFilter,
                            	                  USHORT nFilterClass=USHRT_MAX );
*/
    SfxMedium*          		InsertDocumentDialog( ULONG nFlags, const String& rFact);
    SfxMedium*          		InsertDocumentDialog( ULONG nFlags, const String& rFact, ULONG nHelpId);
    SfxMediumList*          	InsertDocumentsDialog( ULONG nFlags, const String& rFact);
    SfxMediumList*          	InsertDocumentsDialog( ULONG nFlags, const String& rFact, ULONG nHelpId);
    long                		DdeExecute( const String& rCmd );
	long						DdeGetData( const String& rItem,
											const String& rMimeType,
										::com::sun::star::uno::Any & rValue );
	long						DdeSetData( const String& rItem,
											const String& rMimeType,
								const ::com::sun::star::uno::Any & rValue );
    ::sfx2::SvLinkSource*       DdeCreateLinkSource( const String& rItem );

    BOOL                        InitializeDde();
    const DdeService*           GetDdeService() const;
    DdeService*                 GetDdeService();
    void                        AddDdeTopic( SfxObjectShell* );
    void                        RemoveDdeTopic( SfxObjectShell* );
    BOOL                        RestoreWorkingSet();

    ISfxTemplateCommon*         GetCurrentTemplateCommon();
    ISfxTemplateCommon*         GetCurrentTemplateCommon( SfxBindings& );

    void                        SetViewFrame(SfxViewFrame *pViewFrame);
    SfxViewFrame*               GetViewFrame();

    SfxSlotPool&                GetSlotPool( SfxViewFrame *pFrame=NULL ) const;
    SfxResourceManager&         GetResourceManager() const
                                { return *pResMgr; }

    BOOL                        IsInException() const;

    BasicManager*               GetBasicManager();
	com::sun::star::uno::Reference< com::sun::star::script::XLibraryContainer >
								GetDialogContainer();
	com::sun::star::uno::Reference< com::sun::star::script::XLibraryContainer >
								GetBasicContainer();
    StarBASIC*                  GetBasic();
    USHORT                      SaveBasicManager() const;
    USHORT                      SaveBasicContainer() const;
    USHORT                      SaveDialogContainer() const;
    void                        EnterBasicCall();
    FASTBOOL                    IsInBasicCall() const;
    void                        LeaveBasicCall();
    void                        RegisterBasicConstants( const char *pPrefix,
                                                        const SfxConstant *pConsts,
                                                        USHORT nCount );
    SfxCancelManager*           GetCancelManager() const;

    void                        IntroSlide();
    BOOL                        IsInInit() const { return bInInit; }
    BOOL                        IsInExit() const { return bInExit; }
    BOOL                        IsDowning() const { return bDowning; }

    SfxObjectShell*             GetActiveObjectShell() const;
    SfxModule*                  GetActiveModule( SfxViewFrame* pFrame=NULL ) const;
    Window*                     GetWindowAtScreenPosPixel( const Point& rPos ) const;

    SfxStatusBarManager*        GetStatusBarManager() const;
    SfxMenuBarManager*          GetMenuBarManager() const;
    SfxAcceleratorManager*      GetAcceleratorManager() const;
    SfxAcceleratorManager*      GetGlobalAcceleratorManager() const;

    ::com::sun::star::uno::Reference< ::com::sun::star::task::XStatusIndicator > GetStatusIndicator() const;

    SfxMacroConfig*             GetMacroConfig() const;

	static ResMgr*              CreateResManager( const char *pPrefix );
    ResMgr*                     GetSfxResManager();
    ResMgr*                     GetLabelResManager() const;
	SimpleResMgr*				CreateSimpleResManager();
	SimpleResMgr*				GetSimpleResManager();

    void                        RegisterToolBoxControl( SfxModule*, SfxTbxCtrlFactory*);
    void                        RegisterChildWindow(SfxModule*, SfxChildWinFactory*);
    void                        RegisterChildWindowContext(SfxModule*, USHORT, SfxChildWinContextFactory*);
    void                        RegisterStatusBarControl(SfxModule*, SfxStbCtrlFactory*);
    void                        RegisterMenuControl(SfxModule*, SfxMenuCtrlFactory*);

    SfxProgress*                GetProgress() const;
    BOOL                        IsSecureURL( const INetURLObject &rURL, const String *pReferer ) const;

    SfxTemplateDialog*          GetTemplateDialog();
    SfxHelpPI*                  GetHelpPI();
    const String&               GetLastSaveDirectory() const;

    SAL_DLLPRIVATE SfxInterface* GetInterfaceByIdImpl( SfxInterfaceId eId ) const
                                { return pInterfaces[ USHORT(eId) ]; }
    void						SetInterfaceByIdImpl( SfxInterfaceId eId, SfxInterface* pIF );
    SfxOptions&                 GetOptions() { return *pOptions; }
    const USHORT*               GetOptionsRanges() const;
    const SfxOptions&           GetOptions() const { return *pOptions; }
    BOOL                        GetOptions(SfxItemSet &);
    void                        SetOptions(const SfxItemSet &);

    ResId                       GetCurrentObjectBar( USHORT nPosId ) const;

    void                        SetDefFocusWindow( Window *pWin );
    void                        GrabFocus( Window *pAlternate );

    Window*                     GetTopWindow() const;
    void                        SetTopWindow(WorkWindow *);
    USHORT                      GetFreeIndex();
    void                        ReleaseIndex(USHORT i);

    static SfxObjectShellRef    DocAlreadyLoaded( const String &rName,
                                                  BOOL bSilent,
                                                  BOOL bActivate,
                                                  BOOL bForbidVisible = FALSE,
                                                  const String* pPostStr = 0);

    void                        NotifyEvent(const SfxEventHint& rEvent, FASTBOOL bSynchron = TRUE );
    SfxEventConfiguration*      GetEventConfig() const;

    void                        SaveConfiguration() const;
    USHORT                      GetDemoKind() const;
    void                        SpoilDemoOutput(OutputDevice &, const Rectangle &) const;
    void                        InsertLateInitHdl(const Link&);
    String                      LocalizeDBName( SfxDBNameConvert eConvert, const String& rList, char aDel=';' ) const;
	void						SetUserEMailAddress( const String &rEMail );

	static sal_Bool				IsPlugin();
    Config*                     GetFilterIni();
	SfxMiscCfg*					GetMiscConfig();
    USHORT                		Exception( USHORT nError );
	void						StartupScreen( const char* );
    void                        Deinitialize();
//    const SfxObjectFactory&     GetDefaultFactory() const;

    virtual void                Invalidate(USHORT nId = 0);

    static sal_Bool				IsXScriptURL( const String& rScriptURL );
    static ::rtl::OUString		ChooseScript();

    static ::rtl::OUString		ChooseMacro( BOOL bExecute = TRUE, BOOL bChooseOnly = FALSE, const ::rtl::OUString& rMacroDesc = ::rtl::OUString() );
    static void         		MacroOrganizer( INT16 nTabId );

#if _SOLAR__PRIVATE
	SAL_DLLPRIVATE static SfxApplication* Is_Impl() { return pApp;}
                            	DECL_DLLPRIVATE_LINK( GlobalBasicErrorHdl_Impl, StarBASIC* );
    SAL_DLLPRIVATE SfxConfigManager* GetConfigManager_Impl() const { return pCfgMgr; }
    SAL_DLLPRIVATE SfxDispatcher* GetAppDispatcher_Impl()
                                { return pAppDispat; }
    SAL_DLLPRIVATE SfxDispatcher* GetDispatcher_Impl();
    SAL_DLLPRIVATE USHORT       ParseCommandLine_Impl();
	SAL_DLLPRIVATE UniqueIndex* GetEventHandler_Impl();
	DECL_DLLPRIVATE_LINK(		StartWelcomeScreenHdl_Impl, void* );

    SAL_DLLPRIVATE SfxAcceleratorManager* GetAppAccel_Impl() const
								{ return pAcceleratorMgr; }

    SAL_DLLPRIVATE SfxObjectShellLock NewDoc_Impl( const String& rFactory, const SfxItemSet* pSet = NULL );
    SAL_DLLPRIVATE BOOL    		QueryExit_Impl();
    SAL_DLLPRIVATE SfxFrame*    GetTargetFrame_Impl( const SfxItemSet* pSet, BOOL& rOwnsFrame );

    SAL_DLLPRIVATE void         SetOptions_Impl(const SfxItemSet &);
    SAL_DLLPRIVATE BOOL         CheckTryBuy_Impl();
    SAL_DLLPRIVATE void         ForcePendingInitFactories();

    SAL_DLLPRIVATE void         LoadEa_Impl(SfxMedium &, SfxObjectShell &rObj);
    SAL_DLLPRIVATE Timer*       GetAutoSaveTimer_Impl();

    SAL_DLLPRIVATE BOOL         IsReadOnly_Impl(const String &rFile) const;
    SAL_DLLPRIVATE FASTBOOL     Initialize_Impl();

    SAL_DLLPRIVATE const Accelerator& GetAccelerator_Impl() const;
    SAL_DLLPRIVATE SfxAppData_Impl* Get_Impl() const { return pAppData_Impl; }

    // Object-Factories
    SAL_DLLPRIVATE SfxTbxCtrlFactArr_Impl& GetTbxCtrlFactories_Impl() const;
    SAL_DLLPRIVATE SfxStbCtrlFactArr_Impl& GetStbCtrlFactories_Impl() const;
    SAL_DLLPRIVATE SfxMenuCtrlFactArr_Impl& GetMenuCtrlFactories_Impl() const;
    SAL_DLLPRIVATE SfxChildWinFactArr_Impl& GetChildWinFactories_Impl() const;
    SAL_DLLPRIVATE SfxViewFrameArr_Impl& GetViewFrames_Impl() const;
    SAL_DLLPRIVATE SfxViewShellArr_Impl& GetViewShells_Impl() const;
    SAL_DLLPRIVATE SfxObjectShellArr_Impl& GetObjectShells_Impl() const;
    SAL_DLLPRIVATE void         SetProgress_Impl(SfxProgress *);
    SAL_DLLPRIVATE const String& GetLastDir_Impl() const;
    SAL_DLLPRIVATE void         SetLastDir_Impl( const String & );
    SAL_DLLPRIVATE const String& GetLastFilter_Impl() const;
    SAL_DLLPRIVATE void         SetLastFilter_Impl( const String & );
    SAL_DLLPRIVATE void         BuildBasicData_Impl();
    SAL_DLLPRIVATE void         PlayMacro_Impl( SfxRequest &rReq,
                                                StarBASIC *pBas );
	SAL_DLLPRIVATE StarBASIC*	GetBasic_Impl() const;
    SAL_DLLPRIVATE void         MiscExec_Impl(SfxRequest &);
    SAL_DLLPRIVATE void         MiscState_Impl(SfxItemSet &);
    SAL_DLLPRIVATE void         MailExec_Impl(SfxRequest &);
    SAL_DLLPRIVATE void         MailState_Impl(SfxItemSet &);
    SAL_DLLPRIVATE void         PropExec_Impl(SfxRequest &);
    SAL_DLLPRIVATE void         PropState_Impl(SfxItemSet &);
    SAL_DLLPRIVATE void         MacroExec_Impl(SfxRequest &);
    SAL_DLLPRIVATE void         MacroState_Impl(SfxItemSet &);
    SAL_DLLPRIVATE void         NewDocExec_Impl(SfxRequest &);
    SAL_DLLPRIVATE void         NewFramesetExec_Impl(SfxRequest &);
    SAL_DLLPRIVATE void         NewDocDirectExec_Impl(SfxRequest &);
    SAL_DLLPRIVATE const SfxPoolItem* NewDocDirectExec_ImplOld(SfxRequest &); // used by FrameLoader to work with the old behaviour ...
    SAL_DLLPRIVATE void         OpenDocExec_Impl(SfxRequest &);
    SAL_DLLPRIVATE void         DocManagerExec_Impl(SfxRequest &);
    SAL_DLLPRIVATE void         INetExecute_Impl(SfxRequest &);
    SAL_DLLPRIVATE void         INetState_Impl(SfxItemSet &);
    SAL_DLLPRIVATE void         ExplorerExec_Impl(SfxRequest & );
    SAL_DLLPRIVATE void         ExplorerState_Impl(SfxItemSet & );

    SAL_DLLPRIVATE SfxViewFrame* CreateView_Impl( SfxRequest&,
                                                 SfxObjectShell *pDoc,
                                                 FASTBOOL bForceNewView = FALSE,
                                                 FASTBOOL bHidden = FALSE );
    SAL_DLLPRIVATE SfxViewFrame* CreateView_Impl( const SfxItemSet* pArgs,
                                                 SfxObjectShell *pDoc,
                                                 FASTBOOL bForceNewView = FALSE,
                                                 FASTBOOL bHidden = FALSE );
    SAL_DLLPRIVATE void         CreateDocState_Impl(SfxItemSet &);

    SAL_DLLPRIVATE void         BasicExec_Impl(SfxRequest &);
    SAL_DLLPRIVATE void         BasicState_Impl(SfxItemSet &);

    SAL_DLLPRIVATE void         ToolboxExec_Impl(SfxRequest &);
    SAL_DLLPRIVATE void         ToolboxState_Impl(SfxItemSet &);

    SAL_DLLPRIVATE void         EventExec_Impl(SfxRequest &, SfxObjectShell*);
    SAL_DLLPRIVATE void         EventState_Impl(USHORT,SfxItemSet &, SfxObjectShell*);

    SAL_DLLPRIVATE void         EnterAsynchronCall_Impl();
    SAL_DLLPRIVATE FASTBOOL     IsInAsynchronCall_Impl() const;
    SAL_DLLPRIVATE void         LeaveAsynchronCall_Impl();
    SAL_DLLPRIVATE void         Registrations_Impl();
    SAL_DLLPRIVATE void         InvalidateWinSlots_Impl();
    SAL_DLLPRIVATE SfxWorkWindow* GetWorkWindow_Impl(const SfxViewFrame *pFrame=0) const;
    DECL_DLLPRIVATE_LINK        (LateInitTimerHdl_Impl, void*);
    DECL_DLLPRIVATE_LINK        (LateInitNewMenu_Impl, void*);
    DECL_DLLPRIVATE_LINK        (LateInitBmkMenu_Impl, void*);
    DECL_DLLPRIVATE_LINK        (LateInitWizMenu_Impl, void*);
    DECL_DLLPRIVATE_LINK        (LateInitOLEReg_Impl, void*);
    DECL_DLLPRIVATE_LINK        (LateInitCHAOSReg_Impl, void*);

    SAL_DLLPRIVATE SvUShorts*   GetDisabledSlotList_Impl();
    SAL_DLLPRIVATE static SfxObjectShellLock CreateObject_Impl( SfxMedium* pMedium, const String& rUrl );
    SAL_DLLPRIVATE SfxSlotPool& GetAppSlotPool_Impl() const
                                { return *pSlotPool; }
    DECL_DLLPRIVATE_STATIC_LINK( SfxApplication, CookieAlertHdl_Impl, void* );
//REMOVE		void						BasicLibExec_Impl( SfxRequest& rReq, BasicManager* pMgr );
    SAL_DLLPRIVATE SfxModule*   GetModule_Impl();
    SAL_DLLPRIVATE void         OfaExec_Impl(SfxRequest &);
    SAL_DLLPRIVATE void         OfaState_Impl(SfxItemSet &);
	SAL_DLLPRIVATE ResMgr*		GetOffResManager_Impl();
#endif
};

//--------------------------------------------------------------------

inline SfxApplication* SfxGetpApp()
{
    return SfxApplication::GetOrCreate();
}

//--------------------------------------------------------------------

//! Dummies f"ur zu implementierende Items
#define SfxApplicationItem SfxVoidItem
#define SfxDocumentListItem SfxVoidItem

#endif


