/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: urltrans.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 19:30:56 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include <tools/urlobj.hxx>
#include <svtools/urihelper.hxx>

#pragma hdrstop

#include "urltrans.hxx"

SFX_IMPL_XINTERFACE_1( SfxURLTransformer, OWeakObject, ::com::sun::star::util::XURLTransformer )
SFX_IMPL_XTYPEPROVIDER_1( SfxURLTransformer, ::com::sun::star::util::XURLTransformer )
SFX_IMPL_XSERVICEINFO( SfxURLTransformer, "com.sun.star.util.URLTransformer", "com.sun.star.comp.sfx2.URLTransformer")
SFX_IMPL_SINGLEFACTORY( SfxURLTransformer )

SfxURLTransformer::SfxURLTransformer( const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& xFactory )
{}

SfxURLTransformer::~SfxURLTransformer()
{}

sal_Bool SAL_CALL SfxURLTransformer::parseStrict( ::com::sun::star::util::URL& aURL ) throw ( ::com::sun::star::uno::RuntimeException )
{
	INetURLObject aObj( aURL.Complete );
	aURL.Protocol = INetURLObject::GetScheme( aObj.GetProtocol() );
	aURL.User = aObj.GetUser( INetURLObject::NO_DECODE );
	aURL.Password = aObj.GetPass( INetURLObject::NO_DECODE );
	aURL.Server = aObj.GetHost( INetURLObject::NO_DECODE );
	aURL.Port = aObj.GetPort();
	aURL.Path = aObj.GetURLPath( INetURLObject::NO_DECODE );
//	aURL.Name = StringToOUString( aObj.GetName(), CHARSET_SYSTEM );
	aURL.Arguments = aObj.GetParam( INetURLObject::NO_DECODE );
	aURL.Mark = aObj.GetMark( INetURLObject::NO_DECODE );
	aObj.SetMark( String() );
	aObj.SetParam( String() );
	aURL.Main = aObj.GetMainURL( INetURLObject::NO_DECODE );
	return sal_True;
}

sal_Bool SfxURLTransformer::parseSmart( ::com::sun::star::util::URL& aURL, const ::rtl::OUString& aSmartProt ) throw ( ::com::sun::star::uno::RuntimeException )
{
	String aProt( aSmartProt );
    String aSmartURL = URIHelper::SmartRelToAbs( aURL.Complete );
	INetURLObject aObj;
	aObj.SetSmartProtocol( INetURLObject::CompareProtocolScheme( aProt ) );
	aObj.SetSmartURL( aSmartURL );

	aURL.Protocol = INetURLObject::GetScheme( aObj.GetProtocol() );
	aURL.User = aObj.GetUser( INetURLObject::NO_DECODE );
	aURL.Password = aObj.GetPass( INetURLObject::NO_DECODE );
	aURL.Server = aObj.GetHost( INetURLObject::NO_DECODE );
	aURL.Port = aObj.GetPort();
	aURL.Path = aObj.GetURLPath( INetURLObject::NO_DECODE );
//	aURL.Name = StringToOUString( aObj.GetName(), CHARSET_SYSTEM );
	aURL.Arguments = aObj.GetParam( INetURLObject::NO_DECODE );
	aURL.Mark = aObj.GetMark( INetURLObject::NO_DECODE );
	aObj.SetMark( String() );
	aObj.SetParam( String() );
	aURL.Main = aObj.GetMainURL( INetURLObject::NO_DECODE );
	return sal_True;
}

sal_Bool SfxURLTransformer::assemble( ::com::sun::star::util::URL& aURL ) throw ( ::com::sun::star::uno::RuntimeException )
{
	INetURLObject aObj;

	aObj.ConcatData( INetURLObject::CompareProtocolScheme( aURL.Protocol ),
					 aURL.User, aURL.Password, aURL.Server,
					 aURL.Port, aURL.Path );

	// Zun"achst URL ohne Parameter und Mark
	aURL.Main = aObj.GetMainURL( INetURLObject::NO_DECODE );

	// Dann Parameter und Mark dazu
	aObj.SetParam( aURL.Arguments );
	aObj.SetMark( aURL.Mark );
	aURL.Complete = aObj.GetMainURL( INetURLObject::NO_DECODE );

	return sal_True;
}

::rtl::OUString SfxURLTransformer::getPresentation( const ::com::sun::star::util::URL& aURL, sal_Bool bWithPass) throw ( ::com::sun::star::uno::RuntimeException )
{
	return aURL.Complete;
}

