/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sch_fupoor.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 22:31:05 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


//svdraw.hxx
#define _SDR_NOITEMS
#define _SDR_NOTOUCH
#define _SDR_NOTRANSFORM
#define _SI_NOSBXCONTROLS
#define _SI_NOOTHERFORMS
#define _SI_NOCONTROL
#define _SI_NOSBXCONTROLS

// auto strip #include "datarow.hxx"
// auto strip #ifndef _CTRLTOOL_HXX //autogen
// auto strip #include <svtools/ctrltool.hxx>
// auto strip #endif
#ifndef _SV_SELENG_HXX //autogen
#include <vcl/seleng.hxx>
#endif
// auto strip #ifndef _SFXSTBMGR_HXX //autogen
// auto strip #include <bf_sfx2/stbmgr.hxx>
// auto strip #endif
// auto strip #ifndef _SFXAPP_HXX //autogen
// auto strip #include <bf_sfx2/app.hxx>
// auto strip #endif
// auto strip #ifndef _SFXVIEWFRM_HXX //autogen
// auto strip #include <bf_sfx2/viewfrm.hxx>
// auto strip #endif

#ifndef _AEITEM_HXX //autogen
#include <svtools/aeitem.hxx>
#endif

// auto strip #include <bf_svx/flstitem.hxx>

#pragma hdrstop

// Fuer SvxChooseControlEnum
//#define _BASIDESH_HXX
//#define _TBXCTL_HXX
//#include <basicsh.hxx>
//#include <svxids.hrc>

#include "schview.hxx"
// auto strip #include "viewshel.hxx"
#include "chwindow.hxx"
// auto strip #ifndef _CHTMODEL_HXX
// auto strip #include "chtmodel.hxx"
// auto strip #endif
// auto strip #include "docshell.hxx"
// auto strip #include "fusel.hxx"
#include "fupoor.hxx"
namespace binfilter {

//STRIP001 TYPEINIT0(SchFuPoor);


/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

/*N*/ SchFuPoor::SchFuPoor(SchViewShell* pViewSh, SchWindow* pWin, SchView* pView,
/*N*/ 					 ChartModel* pDoc, SfxRequest& rReq) :
/*N*/ 	pViewShell(pViewSh),
/*N*/ 	pWindow(pWin),
/*N*/ 	pView(pView),
/*N*/ 	pChDoc(pDoc),
/*N*/ 	nSlotId(rReq.GetSlot()),
/*N*/ 	pDialog(NULL),
/*N*/ 	bIsInDragMode(FALSE),
/*N*/ 	bFirstMouseMove(FALSE)
/*N*/ {
/*N*/ 	nSlotValue   = 0;
/*N*/ 	pMarkedObj   = 0;
/*N*/ 	pMarkedObjId = 0;
/*N*/ 	nMarkedID    = 0;
/*N*/ 
/*N*/ 	const SfxItemSet* pSet = rReq.GetArgs();
/*N*/ 	if (pSet)
/*N*/ 	{
/*N*/ 		if (pSet->GetItemState(nSlotId) == SFX_ITEM_SET)
/*N*/ 		{
/*?*/ 			const SfxPoolItem& rItem = pSet->Get(nSlotId);
/*?*/ 			if( rItem.ISA(SfxAllEnumItem))
/*?*/ 				nSlotValue = ((const SfxAllEnumItem&)rItem).GetValue();
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	aDragTimer.SetTimeoutHdl(LINK(this, SchFuPoor, DragHdl));
/*N*/ 	aDragTimer.SetTimeout(SELENG_DRAGDROP_TIMEOUT);
/*N*/ 
/*N*/ 	if (pView->GetMarkList().GetMarkCount() >= 1)
/*N*/ 	{
/*?*/ 		pMarkedObj   = pView->GetMarkList().GetMark(0)->GetObj();
/*?*/ 		pMarkedObjId = GetObjectId(*pMarkedObj);
/*?*/ 		if (pMarkedObjId) nMarkedID = pMarkedObjId->GetObjId();
/*?*/ 
/*?*/ 		if (nMarkedID == CHOBJID_DIAGRAM) nMarkedID = CHOBJID_DIAGRAM_WALL;
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

/*N*/ SchFuPoor::~SchFuPoor()
/*N*/ {
/*N*/ 	aDragTimer.Stop();
/*N*/ 
/*N*/ 	delete pDialog;
/*N*/ }

/*************************************************************************
|*
|* Function aktivieren
|*
\************************************************************************/

/*N*/ void SchFuPoor::Activate()
/*N*/ {
/*N*/ 	if (pDialog)
/*?*/ 		pDialog->Show();
/*N*/ }

/*************************************************************************
|*
|* Function deaktivieren
|*
\************************************************************************/

/*N*/ void SchFuPoor::Deactivate()
/*N*/ {
/*N*/ 	aDragTimer.Stop();
/*N*/ 
/*N*/ 	if (pDialog)
/*?*/ 		pDialog->Hide();
/*N*/ 
/*N*/ 	if (pWindow)
/*N*/ 		pWindow->ReleaseMouse();
/*N*/ }

//	SFX_APP()->SetHelpText(aStr);


/*************************************************************************
|*
|* Tastaturereignisse bearbeiten
|*
|* Wird ein KeyEvent bearbeitet, so ist der Return-Wert TRUE, andernfalls
|* FALSE.
|*
\************************************************************************/

//STRIP001 BOOL SchFuPoor::KeyInput(const KeyEvent& rKEvt)
//STRIP001 {
//STRIP001 	BOOL bReturn = FALSE;
//STRIP001 
//STRIP001 	switch (rKEvt.GetKeyCode().GetCode())
//STRIP001 	{
//STRIP001 		case KEY_ESCAPE:
//STRIP001 		{
//STRIP001 			// InPlace-Modus abbrechen
//STRIP001 			SchChartDocShell* pDocSh = (SchChartDocShell*) pViewShell->
//STRIP001 															GetViewFrame()->
//STRIP001 																GetObjectShell();
//STRIP001 			if ( pDocSh )
//STRIP001 			{
//STRIP001 				pDocSh->DoInPlaceActivate( FALSE );
//STRIP001 				bReturn = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bReturn;
//STRIP001 }

/*************************************************************************
|*
|* Cut object to clipboard
|*
\************************************************************************/

//STRIP001 BOOL SchFuPoor::DoCut()
//STRIP001 {
//STRIP001 	return pView && pView->DoCut(pWindow);
//STRIP001 }

/*************************************************************************
|*
|* Copy object to clipboard
|*
\************************************************************************/

//STRIP001 void SchFuPoor::DoCopy()
//STRIP001 {
//STRIP001 	if (pView)
//STRIP001 		pView->DoCopy(pWindow);
//STRIP001 }

/*************************************************************************
|*
|* Paste object from clipboard
|*
\************************************************************************/

//STRIP001 void SchFuPoor::DoPaste()
//STRIP001 {
//STRIP001 	if (pView)
//STRIP001 		pView->DoPaste(pWindow);
//STRIP001 }

/*************************************************************************
|*
|* Timer-Handler fuer Drag&Drop
|*
\************************************************************************/

/*N*/ IMPL_LINK( SchFuPoor, DragHdl, Timer *, pTimer )
/*N*/ {
//STRIP001 	USHORT nHitLog = (USHORT)pWindow->PixelToLogic(Size(HITPIX,0)).Width();
//STRIP001 	SdrHdl* pHdl = pView->HitHandle(aMDPos, *pWindow);
//STRIP001 
//STRIP001 	if (pHdl==NULL && pView->IsMarkedHit(aMDPos, nHitLog))
//STRIP001 	{
//STRIP001 		pWindow->ReleaseMouse();
//STRIP001 		bIsInDragMode = TRUE;
//STRIP001 
//STRIP001 		pView->BeginDrag(pWindow, aMDPos);
//STRIP001 	}
/*N*/ 	return 0;
/*N*/ }

/*************************************************************************
|*
|* Command-event
|*
\************************************************************************/

//STRIP001 BOOL SchFuPoor::Command(const CommandEvent& rCEvt)
//STRIP001 {
//STRIP001 	return pView->Command(rCEvt, pWindow);
//STRIP001 }

/*************************************************************************
|*
|* Handler fuer Mausbewegung
|*
\************************************************************************/

//STRIP001 BOOL SchFuPoor::MouseMove(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	return FALSE;
//STRIP001 }

/*************************************************************************
|*
|* Handler fuer Maustaste
|*
\************************************************************************/

//STRIP001 BOOL SchFuPoor::MouseButtonDown(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	return FALSE;
//STRIP001 }

/*************************************************************************
|*
|* Handler fuer Maustaste
|*
\************************************************************************/

//STRIP001 BOOL SchFuPoor::MouseButtonUp(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	return FALSE;
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void SchFuPoor::Paint(const Rectangle& rRect, SchWindow* pWin)
//STRIP001 {
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void SchFuPoor::SelectionHasChanged()
//STRIP001 {
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void SchFuPoor::RemarkObject()
//STRIP001 {
//STRIP001 	if (nMarkedID)
//STRIP001 	{
//STRIP001 		SdrPage *pPage = pChDoc->GetPage(0);
//STRIP001 
//STRIP001 		if (pPage)
//STRIP001 		{
//STRIP001 			SdrObject *pObj = GetObjWithId (nMarkedID, *pPage, 0, IM_DEEPWITHGROUPS);
//STRIP001 
//STRIP001 			if (pObj)
//STRIP001 			{
//STRIP001 				SdrPageView* pPV = pView->GetPageViewPvNum (0);
//STRIP001 
//STRIP001 				pView->UnmarkAll ();
//STRIP001 				pView->LeaveAllGroup ();
//STRIP001 				pView->SetMarkHdlHidden(TRUE);
//STRIP001 
//STRIP001                 // #102217# enter group if required
//STRIP001                 SdrObject* pUpGroup = pObj->GetUpGroup();
//STRIP001                 if( pUpGroup != 0 )
//STRIP001                 {
//STRIP001                     pView->MarkObj( pUpGroup, pPV );
//STRIP001                     pView->EnterMarkedGroup();
//STRIP001                 }
//STRIP001 
//STRIP001                 pView->MarkObj (pObj, pPV);
//STRIP001 				pView->SetMarkHdlHidden(FALSE);
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Alle 3DCubes einzeln selektieren:
|*
\************************************************************************/

//STRIP001 void SchFuPoor::Select3DGroupMembers( SdrObject *  pObj, SdrPageView *  pPV )
//STRIP001 {
//STRIP001     // this currently does not work correctly, so it is disabled to be
//STRIP001     // consistent (it would otherwise work from time to time)
//STRIP001     return;
//STRIP001 
//STRIP001 #if 0
//STRIP001  	pView->EnterMarkedGroup();
//STRIP001     pView->UnmarkAll();
//STRIP001 
//STRIP001     SdrObjListIter aIter( * pObj->GetSubList(), IM_FLAT );
//STRIP001     while( aIter.IsMore() )
//STRIP001     {
//STRIP001         SdrObject * pNextObj = aIter.Next();
//STRIP001         pView->MarkObj( pNextObj, pPV );
//STRIP001     }
//STRIP001 #endif
//STRIP001 }
}
