/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_topfrm.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:53:53 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

#include "topfrm.hxx"

// auto strip #ifndef _COM_SUN_STAR_UTIL_XURLTRANSFORMER_HPP_
// auto strip #include <com/sun/star/util/XURLTransformer.hpp>
// auto strip #endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif
// auto strip #ifndef _COM_SUN_STAR_FRAME_XFRAME_HPP_
// auto strip #include <com/sun/star/frame/XFrame.hpp>
// auto strip #endif
// auto strip #ifndef _UNOTOOLS_PROCESSFACTORY_HXX
// auto strip #include <comphelper/processfactory.hxx>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_FRAME_XFRAMESSUPPLIER_HPP_
// auto strip #include <com/sun/star/frame/XFramesSupplier.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_UTIL_XCLOSEABLE_HPP_
// auto strip #include <com/sun/star/util/XCloseable.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_UTIL_CLOSEVETOEXCEPTION_HPP_
// auto strip #include <com/sun/star/util/CloseVetoException.hpp>
// auto strip #endif
#ifndef _TOOLKIT_UNOHLP_HXX
#include <toolkit/helper/vclunohelper.hxx>
#endif
// auto strip #ifndef _UNO_COM_SUN_STAR_AWT_POSSIZE_HPP_
// auto strip #include <com/sun/star/awt/PosSize.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_CONTAINER_XINDEXACCESS_HPP_
// auto strip #include <com/sun/star/container/XIndexAccess.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_CONTAINER_XPROPERTYSET_HPP_
// auto strip #include <com/sun/star/beans/XPropertySet.hpp>
// auto strip #endif

#ifndef _SV_MENU_HXX
#include <vcl/menu.hxx>
#endif
#ifndef _SFXRECTITEM_HXX //autogen
#include <svtools/rectitem.hxx>
#endif
#ifndef _SFXINTITEM_HXX //autogen
#include <svtools/intitem.hxx>
#endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
#ifndef   SVTOOLS_ASYNCLINK_HXX
#include <svtools/asynclink.hxx>
#endif
// auto strip #ifndef _IPENV_HXX //autogen
// auto strip #include <so3/ipenv.hxx>
// auto strip #endif
// auto strip #ifndef _SFXECODE_HXX
// auto strip #include <svtools/sfxecode.hxx>
// auto strip #endif
// auto strip #include <vcl/dialog.hxx>
// auto strip #include <svtools/urihelper.hxx>
// auto strip #include <svtools/moduleoptions.hxx>

#include "sfx.hrc"
// auto strip #include "objsh.hxx"
#include "docfile.hxx"
#include "viewsh.hxx"
// auto strip #include "bindings.hxx"
#include "dispatch.hxx"
#include "request.hxx"
// auto strip #include "sfxdir.hxx"
#include "fsetobsh.hxx"
// auto strip #include "objitem.hxx"
// auto strip #include "objface.hxx"
// auto strip #include "msg.hxx"
#include "interno.hxx"
#include "objshimp.hxx"
#include "workwin.hxx"
// auto strip #include "sfxtypes.hxx"
// auto strip #include "splitwin.hxx"
// auto strip #include "appdata.hxx"
// auto strip #include "arrdecl.hxx"
#include "sfxhelp.hxx"
#include "fcontnr.hxx"
// auto strip #include "docfac.hxx"
// auto strip #include "statcach.hxx"

// auto strip #ifndef _LEGACYBINFILTERMGR_HXX
// auto strip #include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
// auto strip #endif

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::frame;
//using namespace ::com::sun::star::util;
using namespace ::com::sun::star::container;
using namespace ::com::sun::star::beans;

//------------------------------------------------------------------------

#define SfxTopViewFrame
namespace binfilter {
#include "sfxslots.hxx"

/*N*/ DBG_NAME(SfxTopViewFrame)

class SfxTopFrame_Impl
{
public:
    Window*             pWindow;        // maybe external
    BOOL                bHidden;
    BOOL                bLockResize;
    BOOL                bMenuBarOn;
};

class SfxTopWindow_Impl : public Window
{
public:
	SfxTopFrame*   		pFrame;

    SfxTopWindow_Impl( SfxTopFrame* pF );
//        : Window( pF->pImp->pWindow, WB_CLIPCHILDREN | WB_NODIALOGCONTROL | WB_3DLOOK )
//        , pFrame( pF )
//    { SetBackground(); }
    ~SfxTopWindow_Impl( );

//STRIP001     virtual void        DataChanged( const DataChangedEvent& rDCEvt );
	virtual void		StateChanged( StateChangedType nStateChange );
	virtual long 		PreNotify( NotifyEvent& rNEvt );
	virtual long		Notify( NotifyEvent& rEvt );
	virtual void        Resize();
    virtual void        GetFocus();
	void				DoResize();
	DECL_LINK(			CloserHdl, void* );
};

/*N*/ SfxTopWindow_Impl::SfxTopWindow_Impl( SfxTopFrame* pF )
/*N*/         : Window( pF->pImp->pWindow, WB_BORDER | WB_CLIPCHILDREN | WB_NODIALOGCONTROL | WB_3DLOOK )
/*N*/         , pFrame( pF )
/*N*/ {
/*N*/     SetBackground(Wallpaper( Color( COL_WHITE ) ) );
/*N*/ }

/*N*/ SfxTopWindow_Impl::~SfxTopWindow_Impl( )
/*N*/ {
/*N*/ }

//STRIP001 void SfxTopWindow_Impl::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001     Window::DataChanged( rDCEvt );
//STRIP001     SfxWorkWindow *pWorkWin = pFrame->GetWorkWindow_Impl();
//STRIP001     if ( pWorkWin )
//STRIP001         pWorkWin->DataChanged_Impl( rDCEvt );
//STRIP001 }

/*N*/ long SfxTopWindow_Impl::Notify( NotifyEvent& rNEvt )
/*N*/ {
/*N*/ 	if ( pFrame->IsClosing_Impl() || !pFrame->GetFrameInterface().is() )
/*N*/ 		return sal_False;
/*N*/ 
/*N*/     SfxViewFrame* pView = pFrame->GetCurrentViewFrame();
/*N*/     if ( !pView || !pView->GetObjectShell() || pView->GetObjectShell()->IsHandsOff() )
/*N*/         return Window::Notify( rNEvt );
/*N*/ 
/*N*/     if ( rNEvt.GetType() == EVENT_GETFOCUS )
/*N*/ 	{
/*N*/         SfxViewFrame* pCurrent = SfxViewFrame::Current();
/*N*/         SfxViewFrame* pContainer = pCurrent ? pCurrent->GetParentViewFrame_Impl() : NULL;
/*N*/         if ( !pContainer )
/*N*/             pContainer = pCurrent;
/*N*/         if ( pView && pView != pContainer )
/*?*/             pView->MakeActive_Impl( FALSE );
/*N*/         Window* pWindow = rNEvt.GetWindow();
/*N*/         ULONG nHelpId  = 0;
/*N*/         while ( !nHelpId && pWindow )
/*N*/         {
/*N*/             nHelpId = pWindow->GetHelpId();
/*N*/             pWindow = pWindow->GetParent();
/*N*/         }
/*N*/ 
/*N*/         if ( nHelpId )
/*N*/             SfxHelp::OpenHelpAgent( pFrame, nHelpId );
/*N*/ 	}
/*N*/     else if( rNEvt.GetType() == EVENT_KEYINPUT )
/*N*/ 	{
/*?*/         DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( pView->GetViewShell()->KeyInput( *rNEvt.GetKeyEvent() ) )
//STRIP001 /*?*/             return TRUE;
/*N*/ 	}
/*N*/     else if ( rNEvt.GetType() == EVENT_EXECUTEDIALOG /*|| rNEvt.GetType() == EVENT_INPUTDISABLE*/ )
/*N*/ 	{DBG_BF_ASSERT(0, "STRIP");//STRIP001 
//STRIP001 /*?*/         pView->SetModalMode( sal_True );
//STRIP001 /*?*/ 		return sal_True;
/*N*/ 	}
/*N*/ 	else if ( rNEvt.GetType() == EVENT_ENDEXECUTEDIALOG /*|| rNEvt.GetType() == EVENT_INPUTENABLE*/ )
/*N*/ 	{DBG_BF_ASSERT(0, "STRIP");//STRIP001 
//STRIP001 /*?*/ 		//EnableInput( sal_True, sal_True );
//STRIP001 /*?*/         pView->SetModalMode( sal_False );
//STRIP001 /*?*/ 		return sal_True;
/*N*/ 	}
/*N*/ 
/*N*/     return Window::Notify( rNEvt );
/*N*/ }

/*N*/ long SfxTopWindow_Impl::PreNotify( NotifyEvent& rNEvt )
/*N*/ {
/*N*/ 	USHORT nType = rNEvt.GetType();
/*N*/ 	if ( nType == EVENT_KEYINPUT || nType == EVENT_KEYUP )
/*N*/     {DBG_BF_ASSERT(0, "STRIP");//STRIP001 
//STRIP001 /*?*/ 		SfxViewFrame* pView = pFrame->GetCurrentViewFrame();
//STRIP001 /*?*/ 		SfxViewShell* pShell = pView ? pView->GetViewShell() : NULL;
//STRIP001 /*?*/ 		if ( pShell && pShell->HasKeyListeners_Impl() && pShell->HandleNotifyEvent_Impl( rNEvt ) )
//STRIP001 /*?*/ 			return sal_True;
/*N*/ 	}
/*N*/ 	else if ( nType == EVENT_MOUSEBUTTONUP || nType == EVENT_MOUSEBUTTONDOWN )
/*N*/     {DBG_BF_ASSERT(0, "STRIP");//STRIP001 
//STRIP001 /*?*/ 		Window* pWindow = rNEvt.GetWindow();
//STRIP001 /*?*/ 		SfxViewFrame* pView = pFrame->GetCurrentViewFrame();
//STRIP001 /*?*/ 		SfxViewShell* pShell = pView ? pView->GetViewShell() : NULL;
//STRIP001 /*?*/ 		if ( pShell )
//STRIP001 /*?*/ 			if ( pWindow == pShell->GetWindow() || pShell->GetWindow()->IsChild( pWindow ) )
//STRIP001 /*?*/ 				if ( pShell->HasMouseClickListeners_Impl() && pShell->HandleNotifyEvent_Impl( rNEvt ) )
//STRIP001 /*?*/ 					return sal_True;
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( nType == EVENT_MOUSEBUTTONDOWN )
/*N*/     {
/*N*/         Window* pWindow = rNEvt.GetWindow();
/*N*/         const MouseEvent* pMEvent = rNEvt.GetMouseEvent();
/*N*/         Point aPos = pWindow->OutputToScreenPixel( pMEvent->GetPosPixel() );
/*N*/         SfxWorkWindow *pWorkWin = pFrame->GetWorkWindow_Impl();
/*N*/         if ( pWorkWin )
/*N*/             pWorkWin->EndAutoShow_Impl( aPos );
/*N*/     }
/*N*/ 
/*N*/ 	return Window::PreNotify( rNEvt );
/*N*/ }

/*N*/ void SfxTopWindow_Impl::GetFocus()
/*N*/ {
/*N*/     if ( pFrame && !pFrame->IsClosing_Impl() && pFrame->GetCurrentViewFrame() && pFrame->GetFrameInterface().is() )
/*?*/         pFrame->GetCurrentViewFrame()->MakeActive_Impl( TRUE );
/*N*/ }

/*N*/ void SfxTopWindow_Impl::Resize()
/*N*/ {
/*N*/     if ( IsReallyVisible() || IsReallyShown() || GetOutputSizePixel().Width() )
/*N*/ 		DoResize();
/*N*/ }

/*N*/ void SfxTopWindow_Impl::StateChanged( StateChangedType nStateChange )
/*N*/ {
/*N*/ 	if ( nStateChange == STATE_CHANGE_INITSHOW )
/*N*/ 	{
/*N*/         SetSizePixel( GetParent()->GetOutputSizePixel() );
/*N*/ 		DoResize();
/*N*/         if ( pFrame->GetCurrentViewFrame() )
/*N*/             pFrame->GetCurrentViewFrame()->GetBindings().GetWorkWindow_Impl()->ShowChilds_Impl();
/*N*/ 	}
/*N*/ 	else
/*N*/         Window::StateChanged( nStateChange );
/*N*/ }

/*N*/ void SfxTopWindow_Impl::DoResize()
/*N*/ {
/*N*/     if ( !pFrame->pImp->bLockResize )
/*N*/         pFrame->Resize();
/*N*/ }

class StopButtonTimer_Impl : public Timer
{
	BOOL bState;
    SfxViewFrame* pFrame;
protected:
	virtual void Timeout();
public:
    StopButtonTimer_Impl( SfxViewFrame*);
	void SetButtonState( BOOL bStateP );
	BOOL GetButtonState() const { return bState; }
};

/*N*/ StopButtonTimer_Impl::StopButtonTimer_Impl( SfxViewFrame*p)
/*N*/ 	: bState( FALSE )
/*N*/     , pFrame( p )
/*N*/ {
/*N*/ 	SetTimeout( 200 );
/*N*/ }

/*N*/ void StopButtonTimer_Impl::SetButtonState( BOOL bStateP )
/*N*/ {
/*N*/ 	if( bStateP )
/*N*/ 	{
/*N*/ 		bState = TRUE;
/*N*/ 		Stop();
/*N*/ 	}
/*N*/ 	else if( bState )
/*N*/ 		Start();
/*N*/ }

/*N*/ void StopButtonTimer_Impl::Timeout()
/*N*/ {
/*N*/ 	bState = FALSE;
/*N*/     pFrame->GetBindings().Invalidate( SID_BROWSE_STOP );
/*N*/ }

class SfxTopViewWin_Impl : public Window
{
friend class SfxInternalFrame;

	BOOL				bActive;
    SfxTopViewFrame*    pFrame;

public:
                        SfxTopViewWin_Impl( SfxTopViewFrame* p,
								Window *pParent, WinBits nBits=0 ) :
							Window( pParent, nBits | WB_BORDER | WB_CLIPCHILDREN ),
							pFrame( p ),
							bActive( FALSE )
						{
                            p->GetFrame()->GetWindow().SetBorderStyle( WINDOW_BORDER_NOBORDER );
						}

	virtual void		Resize();
	virtual void		StateChanged( StateChangedType nStateChange );
};

//--------------------------------------------------------------------
/*N*/ void SfxTopViewWin_Impl::StateChanged( StateChangedType nStateChange )
/*N*/ {
/*N*/ 	if ( nStateChange == STATE_CHANGE_INITSHOW )
/*N*/         pFrame->Resize();
/*N*/ 	else
/*N*/         Window::StateChanged( nStateChange );
/*N*/ }

/*N*/ void SfxTopViewWin_Impl::Resize()
/*N*/ {
/*N*/     if ( IsReallyVisible() || IsReallyShown() || GetOutputSizePixel().Width() )
/*N*/         pFrame->Resize();
/*N*/ }

class SfxTopViewFrame_Impl
{
public:
    sal_Bool            bActive;
    Window*             pWindow;
    String          	aFactoryName;
    StopButtonTimer_Impl* pStopButtonTimer;

						SfxTopViewFrame_Impl()
							: bActive( sal_False )
                            , pWindow( 0 )
                            , pStopButtonTimer( 0 )
                        {}
};

static svtools::AsynchronLink* pPendingCloser = 0;

//STRIP001 SfxTopFrame* SfxTopFrame::Create( SfxObjectShell* pDoc, USHORT nViewId, BOOL bHidden, const SfxItemSet* pSet )
//STRIP001 {
//STRIP001     Reference < XFrame > xDesktop ( ::legacy_binfilters::getLegacyProcessServiceFactory()->createInstance( DEFINE_CONST_UNICODE("com.sun.star.frame.Desktop") ), UNO_QUERY );
//STRIP001 	SfxTopFrame *pFrame = NULL;
//STRIP001 	BOOL bNewView = FALSE;
//STRIP001 	if ( pSet )
//STRIP001 	{
//STRIP001     	SFX_ITEMSET_ARG( pSet, pItem, SfxBoolItem, SID_OPEN_NEW_VIEW, sal_False );
//STRIP001 		bNewView = pItem && pItem->GetValue();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pDoc && !bHidden && !bNewView )
//STRIP001 	{
//STRIP001 	    URL aTargetURL;
//STRIP001 	    aTargetURL.Complete = pDoc->GetMedium()->GetURLObject().GetMainURL( INetURLObject::NO_DECODE );
//STRIP001 
//STRIP001         BOOL bIsBasic = FALSE;
//STRIP001 		if ( !aTargetURL.Complete.getLength() )
//STRIP001 		{
//STRIP001             String sFactory = String::CreateFromAscii(pDoc->GetFactory().GetShortName());
//STRIP001             bIsBasic = (sFactory.CompareIgnoreCaseToAscii("sbasic")==COMPARE_EQUAL);
//STRIP001 
//STRIP001             if (!bIsBasic)
//STRIP001             {
//STRIP001                 String aURL = String::CreateFromAscii("private:factory/");
//STRIP001                 aURL += sFactory;
//STRIP001                 aTargetURL.Complete = aURL;
//STRIP001             }
//STRIP001 		}
//STRIP001 
//STRIP001         if (bIsBasic)
//STRIP001         {
//STRIP001             Reference < XFramesSupplier > xSupplier( xDesktop, UNO_QUERY );
//STRIP001             if (xSupplier.is())
//STRIP001             {
//STRIP001                 Reference < XIndexAccess > xContainer(xSupplier->getFrames(), UNO_QUERY);
//STRIP001                 if (xContainer.is())
//STRIP001                 {
//STRIP001                     sal_Int32 nCount = xContainer->getCount();
//STRIP001                     for (sal_Int32 i=0; i<nCount; ++i)
//STRIP001                     {
//STRIP001                         Reference < XFrame > xFrame;
//STRIP001                         if (!(xContainer->getByIndex(i) >>= xFrame) || !xFrame.is())
//STRIP001                             continue;
//STRIP001                         Reference < XPropertySet > xSet(xFrame, UNO_QUERY);
//STRIP001                         sal_Bool bIsBacking;
//STRIP001                         if (
//STRIP001                             (xSet.is()) &&
//STRIP001                             (xSet->getPropertyValue(::rtl::OUString::createFromAscii("IsBackingMode"))>>=bIsBacking) &&
//STRIP001                             (bIsBacking)
//STRIP001                            )
//STRIP001                         {
//STRIP001                             pFrame = Create(xFrame);
//STRIP001                             break;
//STRIP001                         }
//STRIP001                     }
//STRIP001                 }
//STRIP001             }
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             Reference < XURLTransformer > xTrans( ::legacy_binfilters::getLegacyProcessServiceFactory()->createInstance( ::rtl::OUString::createFromAscii("com.sun.star.util.URLTransformer" )), UNO_QUERY );
//STRIP001             xTrans->parseStrict( aTargetURL );
//STRIP001 
//STRIP001             Reference < ::com::sun::star::frame::XDispatchProvider > xProv( xDesktop, UNO_QUERY );
//STRIP001             Reference < ::com::sun::star::frame::XDispatch > xDisp;
//STRIP001             if ( xProv.is() )
//STRIP001             {
//STRIP001                 Sequence < ::com::sun::star::beans::PropertyValue > aSeq(1);
//STRIP001                 aSeq[0].Name = ::rtl::OUString::createFromAscii("Model");
//STRIP001                 aSeq[0].Value <<= pDoc->GetModel();
//STRIP001                 ::rtl::OUString aTargetFrame( ::rtl::OUString::createFromAscii("_default") );
//STRIP001                 xDisp = xProv->queryDispatch( aTargetURL, aTargetFrame , 0 );
//STRIP001                 if ( xDisp.is() )
//STRIP001                     xDisp->dispatch( aTargetURL, aSeq );
//STRIP001             }
//STRIP001 
//STRIP001             SfxFrameArr_Impl& rArr = *SFX_APP()->Get_Impl()->pTopFrames;
//STRIP001             for( USHORT nPos = rArr.Count(); nPos--; )
//STRIP001             {
//STRIP001                 SfxTopFrame *pF = (SfxTopFrame*) rArr[ nPos ];
//STRIP001                 if ( pF->GetCurrentDocument() == pDoc )
//STRIP001                 {
//STRIP001                     pFrame = pF;
//STRIP001                     break;
//STRIP001                 }
//STRIP001             }
//STRIP001         }
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( !pFrame  )
//STRIP001 	{
//STRIP001 	    Reference < XFrame > xFrame = xDesktop->findFrame( DEFINE_CONST_UNICODE("_blank"), 0 );
//STRIP001 	    pFrame = Create( xFrame );
//STRIP001 	}
//STRIP001 
//STRIP001     pFrame->pImp->bHidden = bHidden;
//STRIP001     Window* pWindow = pFrame->GetTopWindow_Impl();
//STRIP001     if ( pWindow && pDoc )
//STRIP001     {
//STRIP001         String aTitle = pDoc->GetTitle( SFX_TITLE_DETECT );
//STRIP001         aTitle += String::CreateFromAscii( " - " );
//STRIP001         aTitle += Application::GetDisplayName();
//STRIP001         pWindow->SetText( aTitle );
//STRIP001         if( pWindow->GetType() == WINDOW_WORKWINDOW )
//STRIP001         {
//STRIP001             SvtModuleOptions::EFactory eFactory;
//STRIP001             if( SvtModuleOptions::ClassifyFactoryByName( pDoc->GetFactory().GetDocumentServiceName(), eFactory ) )
//STRIP001             {
//STRIP001                 WorkWindow* pWorkWindow = (WorkWindow*)pWindow;
//STRIP001                 pWorkWindow->SetIcon( (sal_uInt16) SvtModuleOptions().GetFactoryIcon( eFactory ) );
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     pFrame->SetItemSet_Impl( pSet );
//STRIP001     if ( pDoc && pDoc != pFrame->GetCurrentDocument() )
//STRIP001     {
//STRIP001         if ( nViewId )
//STRIP001             pDoc->GetMedium()->GetItemSet()->Put( SfxUInt16Item( SID_VIEW_ID, nViewId ) );
//STRIP001         pFrame->InsertDocument( pDoc );
//STRIP001     }
//STRIP001 
//STRIP001     return pFrame;
//STRIP001 }

//STRIP001 SfxTopFrame* SfxTopFrame::Create( SfxObjectShell* pDoc, Window* pWindow, USHORT nViewId, BOOL bHidden, const SfxItemSet* pSet )
//STRIP001 {
//STRIP001     Reference < ::com::sun::star::lang::XMultiServiceFactory > xFact( ::legacy_binfilters::getLegacyProcessServiceFactory() );
//STRIP001     Reference < XFramesSupplier > xDesktop ( xFact->createInstance( DEFINE_CONST_UNICODE("com.sun.star.frame.Desktop") ), UNO_QUERY );
//STRIP001     Reference < XFrame > xFrame( xFact->createInstance( DEFINE_CONST_UNICODE("com.sun.star.frame.Frame") ), UNO_QUERY );
//STRIP001 
//STRIP001     xFrame->initialize( VCLUnoHelper::GetInterface ( pWindow ) );
//STRIP001     if ( xDesktop.is() )
//STRIP001         xDesktop->getFrames()->append( xFrame );
//STRIP001 
//STRIP001     SfxTopFrame* pFrame = new SfxTopFrame( pWindow );
//STRIP001     pFrame->SetFrameInterface_Impl( xFrame );
//STRIP001     pFrame->pImp->bHidden = bHidden;
//STRIP001 
//STRIP001     pFrame->SetItemSet_Impl( pSet );
//STRIP001     if ( pDoc )
//STRIP001     {
//STRIP001         if ( nViewId )
//STRIP001             pDoc->GetMedium()->GetItemSet()->Put( SfxUInt16Item( SID_VIEW_ID, nViewId ) );
//STRIP001         pFrame->InsertDocument( pDoc );
//STRIP001     }
//STRIP001 
//STRIP001     return pFrame;
//STRIP001 }

/*N*/ SfxTopFrame* SfxTopFrame::Create( Reference < XFrame > xFrame )
/*N*/ {
/*N*/     // create a new TopFrame to an external XFrame object ( wrap controller )
/*N*/     if ( !xFrame.is() )
/*N*/         DBG_ERROR( "Wrong parameter!" );
/*N*/ 
/*N*/     Window* pWindow = VCLUnoHelper::GetWindow( xFrame->getContainerWindow() );
/*N*/     SfxTopFrame* pFrame = new SfxTopFrame( pWindow );
/*N*/     pFrame->SetFrameInterface_Impl( xFrame );
/*N*/     return pFrame;
/*N*/ }

/*N*/ SfxTopFrame::SfxTopFrame( Window* pExternal, sal_Bool bHidden )
/*N*/ 	: SfxFrame( NULL )
/*N*/ 	, pWindow( NULL )
/*N*/ {
/*N*/     pImp = new SfxTopFrame_Impl;
/*N*/     pImp->bHidden = bHidden;
/*N*/     pImp->bLockResize = FALSE;
/*N*/     pImp->bMenuBarOn = TRUE;
/*N*/ 	InsertTopFrame_Impl( this );
/*N*/     if ( pExternal )
/*N*/     {
/*N*/         pImp->pWindow = pExternal;
/*N*/     }
/*N*/     else
/*N*/     {
/*N*/         DBG_ERROR( "TopFrame without window created!" );
/*
        pImp->pWindow = new SfxTopFrameWindow_Impl( this );
        pImp->pWindow->SetActivateMode( ACTIVATE_MODE_GRABFOCUS );
        pImp->pWindow->SetPosSizePixel( Point( 20,20 ), Size( 800,600 ) );
        if ( GetFrameInterface().is() )
            GetFrameInterface()->initialize( VCLUnoHelper::GetInterface( pImp->pWindow ) );
        pImp->pWindow->Show();
 */
/*N*/     }
/*N*/ 
/*N*/     pWindow = new SfxTopWindow_Impl( this );
/** AS:
    Hide this window till the component was realy loaded. Otherwhise it overpaint e.g. the old component hardly
    and produce repaint errors.
    pWindow->Show();
  */
/*N*/ }

/*N*/ SfxTopFrame::~SfxTopFrame()
/*N*/ {
/*N*/ 	RemoveTopFrame_Impl( this );
/*N*/     DELETEZ( pWindow );
/*N*/     delete pImp;
/*N*/ }

//STRIP001 void SfxTopFrame::SetPresentationMode( BOOL bSet )
//STRIP001 {
//STRIP001     if ( GetCurrentViewFrame() )
//STRIP001         GetCurrentViewFrame()->GetWindow().SetBorderStyle( bSet ? WINDOW_BORDER_NOBORDER : WINDOW_BORDER_NORMAL );
//STRIP001 
//STRIP001     SetMenuBarOn_Impl( !bSet );
//STRIP001     if ( GetWorkWindow_Impl() )
//STRIP001         GetWorkWindow_Impl()->SetDockingAllowed( !bSet );
//STRIP001     if ( GetCurrentViewFrame() )
//STRIP001         GetCurrentViewFrame()->GetDispatcher()->Update_Impl( TRUE );
//STRIP001 }

/*N*/ SystemWindow* SfxTopFrame::GetTopWindow_Impl() const
/*N*/ {
/*N*/     if ( pImp->pWindow->IsSystemWindow() )
/*N*/         return (SystemWindow*) pImp->pWindow;
/*N*/     else
/*N*/         return NULL;
/*N*/ }

/*N*/ Window& SfxTopFrame::GetWindow() const
/*N*/ {
/*N*/     return *pWindow;
/*N*/ }

/*N*/ sal_Bool SfxTopFrame::Close()
/*N*/ {
/*N*/ 	delete this;
/*N*/ 	return sal_True;
/*N*/ }

/*N*/ void SfxTopFrame::LockResize_Impl( BOOL bLock )
/*N*/ {
/*N*/     pImp->bLockResize = bLock;
/*N*/ }

/*N*/ void SfxTopFrame::SetMenuBar_Impl( MenuBar *pMenu )
/*N*/ {
/*N*/     if ( pMenu && !pImp->bMenuBarOn )
/*N*/         return;
/*N*/ 
/*N*/     SystemWindow *pWin = GetTopWindow_Impl();
/*N*/     if ( pWin && pWin->GetMenuBar() != pMenu )
/*N*/     {
/*N*/         pWin->SetMenuBar( pMenu );
/*N*/ 		if ( pMenu )
/*N*/ 		{
/*N*/ 			CheckMenuCloser_Impl( pMenu );
/*N*/ 			pMenu->SetCloserHdl( LINK( pWindow, SfxTopWindow_Impl, CloserHdl ) );
/*N*/ 		}
/*N*/     }
/*N*/ }

/*N*/ IMPL_LINK( SfxTopWindow_Impl, CloserHdl, void*, pVoid )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	if ( pFrame && !pFrame->PrepareClose_Impl( TRUE ) )
//STRIP001 		return 0L;
//STRIP001 
//STRIP001 	if ( pFrame )
//STRIP001 		pFrame->GetCurrentViewFrame()->GetBindings().Execute( SID_CLOSEWIN, 0, 0, SFX_CALLMODE_ASYNCHRON );
/*N*/ 	return 0L;
/*N*/ }

//STRIP001 void SfxTopFrame::SetMenuBarOn_Impl( BOOL bOn )
//STRIP001 {
//STRIP001     pImp->bMenuBarOn = bOn;
//STRIP001     if ( !bOn )
//STRIP001         SetMenuBar_Impl( 0 );
//STRIP001 }

//STRIP001 BOOL SfxTopFrame::IsMenuBarOn_Impl() const
//STRIP001 {
//STRIP001     return pImp->bMenuBarOn;
//STRIP001 }

/*N*/ MenuBar* SfxTopFrame::GetMenuBar_Impl() const
/*N*/ {
/*N*/     SystemWindow *pWin = GetTopWindow_Impl();
/*N*/     return pWin ? pWin->GetMenuBar() : NULL;
/*N*/ }

//STRIP001 String SfxTopFrame::GetWindowData()
//STRIP001 {
//STRIP001 	String aActWinData;
//STRIP001 #if SUPD<613//MUSTINI
//STRIP001 	char cToken = SfxIniManager::GetToken();
//STRIP001 #else
//STRIP001 	char cToken = ',';
//STRIP001 #endif
//STRIP001 
//STRIP001 	SfxViewFrame *pActFrame = SfxViewFrame::Current();
//STRIP001 	SfxViewFrame *pFrame = GetCurrentViewFrame();
//STRIP001 	const sal_Bool bActWin = ( pActFrame->GetTopViewFrame() == pFrame );
//STRIP001 
//STRIP001 	// ::com::sun::star::sdbcx::User-Daten der ViewShell
//STRIP001 	String aUserData;
//STRIP001 	pFrame->GetViewShell()->WriteUserData(aUserData);
//STRIP001 
//STRIP001 	// assemble ini-data
//STRIP001 	String aWinData;
//STRIP001 	aWinData += String::CreateFromInt32( pFrame->GetCurViewId() );
//STRIP001 	aWinData += cToken;
//STRIP001 
//STRIP001     aWinData += '1';                    // former attribute "isfloating"
//STRIP001 	aWinData += cToken;
//STRIP001 #if SUPD<613//MUSTINI
//STRIP001     aWinData += SfxIniManager::GetString( pImp->pWindow->GetPosPixel(), pImp->pWindow->GetSizePixel() );
//STRIP001 #endif
//STRIP001 
//STRIP001 	// aktives kennzeichnen
//STRIP001 	aWinData += cToken;
//STRIP001 	aWinData += bActWin ? '1' : '0';
//STRIP001 
//STRIP001 	aWinData += cToken;
//STRIP001 	aWinData += aUserData;
//STRIP001 
//STRIP001 	return aWinData;
//STRIP001 }

/*N*/ sal_Bool SfxTopFrame::InsertDocument( SfxObjectShell* pDoc )
/* [Beschreibung]
 */
/*N*/ {
/*N*/ 	// Spezielle Bedingungen testen: nicht im ModalMode!
/*N*/ 	if ( !SfxFrame::InsertDocument( pDoc ) )
/*N*/ 		return sal_False;
/*N*/ 
/*N*/ 	SfxObjectShell *pOld = GetCurrentDocument();
/*N*/ 
/*N*/ 	// Position und Groesse testen
/*N*/ 	// Wenn diese schon gesetzt sind, soll offensichtlich nicht noch
/*N*/ 	// LoadWindows_Impl aufgerufen werden ( z.B. weil dieses ein CreateFrame()
/*N*/ 	// an einer Task aufgerufen hat! )
/*N*/ 	const SfxItemSet* pSet = GetItemSet_Impl();
/*N*/ 	if ( !pSet )
/*N*/ 		pSet = pDoc->GetMedium()->GetItemSet();
/*N*/ 	SetItemSet_Impl(0);
/*N*/ 
/*N*/     // Position und Gr"o\se
/*N*/ 	SFX_ITEMSET_ARG(
/*N*/ 		pSet, pAreaItem, SfxRectangleItem, SID_VIEW_POS_SIZE, sal_False );
/*N*/ 	// ::com::sun::star::sdbcx::View-Id
/*N*/ 	SFX_ITEMSET_ARG(
/*N*/ 		pSet, pViewIdItem, SfxUInt16Item, SID_VIEW_ID, sal_False );
/*N*/ 	// Zoom
/*N*/ 	SFX_ITEMSET_ARG(
/*N*/ 		pSet, pModeItem, SfxUInt16Item, SID_VIEW_ZOOM_MODE, sal_False );
/*N*/ 	// Hidden
/*N*/ 	SFX_ITEMSET_ARG(
/*N*/ 		pSet, pHidItem, SfxBoolItem,	SID_HIDDEN, sal_False);
/*N*/ 	// ViewDaten
/*N*/ 	SFX_ITEMSET_ARG(
/*N*/ 		pSet, pViewDataItem, SfxStringItem, SID_USER_DATA, sal_False );
/*N*/ 	// ViewOnly
/*N*/ 	SFX_ITEMSET_ARG(
/*N*/ 		pSet, pEditItem, SfxBoolItem, SID_VIEWONLY, sal_False);
/*N*/ 
/*N*/ 	if ( pEditItem  && pEditItem->GetValue() )
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");}//STRIP001 SetMenuBarOn_Impl( FALSE );
/*N*/ 
/*N*/     if ( pHidItem )
/*N*/         pImp->bHidden = pHidItem->GetValue();
/*N*/ 
/*N*/     if( !pImp->bHidden )
/*N*/ 		pDoc->OwnerLock( sal_True );
/*N*/ 
/*N*/ 	// Wenn z.B. eine Fenstergr"o\se gesetzt wurde, soll keine Fensterinformation
/*N*/ 	// aus den Dokument geladen werden, z.B. weil InsertDocument seinerseits
/*N*/ 	// aus LoadWindows_Impl aufgerufen wurde!
/*N*/     if ( pDoc && !pAreaItem && !pViewIdItem && !pModeItem &&
/*N*/             !pImp->bHidden && pDoc->LoadWindows_Impl( this ) )
/*N*/ 	{
/*?*/ 		pDoc->OwnerLock( sal_False );
/*?*/ 		return sal_True;
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( pDoc )
/*N*/ 	{
/*N*/ 		UpdateHistory( pDoc );
/*N*/ 		UpdateDescriptor( pDoc );
/*N*/ 	}
/*N*/ 
/*N*/ 	SfxFrameSetObjectShell *pFDoc = PTR_CAST( SfxFrameSetObjectShell, pDoc );
/*N*/ 	if ( pFDoc )
/*?*/ 		SetFrameType_Impl( GetFrameType() | SFXFRAME_FRAMESET );
/*N*/ 	else
/*N*/ 		SetFrameType_Impl( GetFrameType() & ~SFXFRAME_FRAMESET );
/*N*/ 
/*N*/ 	sal_Bool bBrowsing = sal_True;
/*N*/     BOOL bSetFocus = GetWindow().HasChildPathFocus( TRUE );
/*N*/ 	SfxViewFrame *pFrame = GetCurrentViewFrame();
/*N*/ 	if ( pFrame )
/*N*/ 	{
/*?*/         DBG_BF_ASSERT(0, "STRIP"); //STRIP001 sal_Bool bChildActivated = sal_False;
//STRIP001 /*?*/ 		if ( pFrame->GetActiveChildFrame_Impl() && pFrame->GetActiveChildFrame_Impl() == SfxViewFrame::Current() )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ //            ::com::sun::star::uno::Reference< ::com::sun::star::frame::XFramesSupplier >  xFrames( GetFrameInterface(), ::com::sun::star::uno::UNO_QUERY );
//STRIP001 /*?*/ //            if ( xFrames.is() )
//STRIP001 /*?*/ //                xFrames->setActiveFrame( ::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame > () );
//STRIP001 /*?*/             pFrame->SetActiveChildFrame_Impl(0);
//STRIP001 /*?*/             SFX_APP()->SetViewFrame( pFrame );
//STRIP001 /*?*/             bChildActivated = sal_True;
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		if ( pFrame->GetObjectShell() )
//STRIP001 /*?*/ 			pFrame->ReleaseObjectShell_Impl( sal_False );
//STRIP001 /*?*/ 		if ( pViewIdItem )
//STRIP001 /*?*/ 			pFrame->SetViewData_Impl( pViewIdItem->GetValue(), String() );
//STRIP001 /*?*/ 		if ( pDoc )
//STRIP001 /*?*/ 			pFrame->SetObjectShell_Impl( *pDoc );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		bBrowsing = sal_False;
/*N*/ 		pFrame = new SfxTopViewFrame( this, pDoc, pViewIdItem ? pViewIdItem->GetValue() : 0 );
/*N*/ 	}
/*N*/ 
/*N*/     if ( pViewDataItem )
/*N*/ 	{
/*?*/ 		if ( pDoc->Get_Impl()->nLoadedFlags & SFX_LOADED_MAINDOCUMENT )
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pFrame->GetViewShell()->ReadUserData( pViewDataItem->GetValue(), sal_True );
/*?*/ 		else
/*?*/ 		{
/*?*/ 			// Daten setzen, die in FinishedLoading ausgewertet werden
/*?*/ 			MarkData_Impl*& rpMark = pDoc->Get_Impl()->pMarkData;
/*?*/ 			if (!rpMark)
/*?*/ 				rpMark = new MarkData_Impl;
/*?*/ 			rpMark->pFrame = pFrame;
/*?*/ 			rpMark->aUserData = pViewDataItem->GetValue();
/*?*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	// Position und Groesse setzen
/*N*/ 	sal_uInt16 nWinMode = pModeItem ? pModeItem->GetValue() : 1;
/*N*/ 	if ( pAreaItem && !pOld )
/*N*/ 	{
/*?*/         Window *pWin = pImp->pWindow;
/*?*/ 
/*?*/ 		// Groesse setzen
/*?*/ 		const Rectangle aWinRect( pAreaItem->GetValue() );
/*?*/         const Size aAppWindow( pImp->pWindow->GetDesktopRectPixel().GetSize() );
/*?*/ 		Point aPos( aWinRect.TopLeft() );
/*?*/ 		Size aSz(aWinRect.GetSize());
/*?*/ 		if ( aSz.Width() && aSz.Height() )
/*?*/ 		{
/*?*/ 			aPos.X() = Min(aPos.X(),
/*?*/ 							long(aAppWindow.Width() - aSz.Width() + aSz.Width() / 2) );
/*?*/ 			aPos.Y() = Min(aPos.Y(),
/*?*/ 							long( aAppWindow.Height() - aSz.Height() + aSz.Height() / 2) );
/*?*/ 			if ( aPos.X() + aSz.Width() <
/*?*/ 					aAppWindow.Width() + aSz.Width() / 2 &&
/*?*/ 					aPos.Y() + aSz.Height() <
/*?*/ 					aAppWindow.Height() + aSz.Height() / 2 )
/*?*/ 			{
/*?*/ 				pWin->SetPosPixel( aPos );
/*?*/ 				pWin->SetOutputSizePixel( aSz );
/*?*/ 			}
/*?*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/     if ( !pImp->bHidden )
/*N*/ 	{
/*N*/ #if SUPD>638
/*N*/         if ( pDoc->IsHelpDocument() )
/*?*/             pFrame->GetDispatcher()->HideUI( TRUE );
/*N*/         else
/*N*/             pFrame->GetDispatcher()->HideUI( FALSE );
/*N*/ #endif
/*N*/ 		pFrame->Show();
/*N*/         GetWindow().Show();
/*N*/         pFrame->MakeActive_Impl( TRUE );
/*N*/ 		pDoc->OwnerLock( sal_False );
/*N*/         GetFrameInterface()->getContainerWindow()->setVisible( sal_True );
/*N*/         if( GetTopWindow_Impl()->HasFocus() )
/*?*/             pFrame->MakeActive_Impl( TRUE );
/*N*/ 	}
/*N*/ 
/*N*/     if ( bSetFocus )
/*?*/         // if the old component had the focus when it was destroyed, the focus has been transferred to
/*?*/         // the ViewFrameWindow
/*?*/         GrabFocusOnComponent_Impl();
/*N*/ 
/*N*/ 	// Jetzt UpdateTitle, hidden TopFrames haben sonst keinen Namen!
/*N*/ 	pFrame->UpdateTitle();
/*N*/ 
/*N*/ 	if ( pFrame->GetViewShell()->UseObjectSize() )
/*N*/ 	{
/*N*/ 		GetCurrentViewFrame()->UnlockAdjustPosSizePixel();
/*N*/ 		GetCurrentViewFrame()->Resize(TRUE);
/*N*/ 		GetCurrentViewFrame()->ForceInnerResize_Impl( FALSE );
/*N*/ 		GetCurrentViewFrame()->Resize(TRUE);
/*N*/ 	}
/*N*/ 
/*N*/ 	return sal_True;
/*N*/ }


//========================================================================

//STRIP001 long SfxViewFrameClose_Impl( void* pObj, void* pArg )
//STRIP001 {
//STRIP001 	((SfxViewFrame*)pArg)->GetFrame()->DoClose();
//STRIP001 	return 0;
//STRIP001 }

/*N*/ TYPEINIT1(SfxTopFrame, SfxFrame);
/*N*/ TYPEINIT1(SfxTopViewFrame, SfxViewFrame);

//--------------------------------------------------------------------
/*N*/ SFX_IMPL_INTERFACE(SfxTopViewFrame,SfxViewFrame,ResId(0,0))
/*N*/ {
/*N*/ }

//--------------------------------------------------------------------
/*N*/ String SfxTopViewFrame::UpdateTitle()

/*	[Beschreibung]

	Mit dieser Methode kann der SfxTopViewFrame gezwungen werden, sich sofort
	den neuen Titel vom der <SfxObjectShell> zu besorgen.

	[Anmerkung]

	Dies ist z.B. dann notwendig, wenn man der SfxObjectShell als SfxListener
	zuh"ort und dort auf den <SfxSimpleHint> SFX_HINT_TITLECHANGED reagieren
	m"ochte, um dann die Titel seiner Views abzufragen. Diese Views (SfxTopViewFrames)
	jedoch sind ebenfalls SfxListener und da die Reihenfolge der Benachrichtigung
	nicht feststeht, mu\s deren Titel-Update vorab erzwungen werden.


	[Beispiel]

	void SwDocShell::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
	{
		if ( rHint.IsA(TYPE(SfxSimpleHint)) )
		{
			switch( ( (SfxSimpleHint&) rHint ).GetId() )
			{
				case SFX_HINT_TITLECHANGED:
					for ( SfxTopViewFrame *pTop = (SfxTopViewFrame*)
								SfxViewFrame::GetFirst(this, TYPE(SfxTopViewFrame));
						  pTop;
						  pTop = (SfxTopViewFrame*)
								SfxViewFrame::GetNext(this, TYPE(SfxTopViewFrame));
					{
						pTop->UpdateTitle();
						... pTop->GetName() ...
					}
					break;
				...
			}
		}
	}
*/

/*N*/ {
/*N*/ 	DBG_CHKTHIS(SfxTopViewFrame, 0);
/*N*/ 
/*N*/     const SfxObjectFactory &rFact = GetObjectShell()->GetFactory();
/*N*/     if ( rFact.GetFilterContainer()->GetFilterCount() )
/*N*/ 	{
/*N*/         pImp->aFactoryName = String::CreateFromAscii( rFact.GetShortName() );
/*N*/ 		USHORT nSlotId = rFact.GetCreateNewSlotId();
/*N*/ 		if ( nSlotId )
/*N*/ 		{
/*N*/ 			pImp->aFactoryName += String::CreateFromAscii("?slot=");
/*N*/ 			pImp->aFactoryName += String::CreateFromInt32( (sal_Int32) nSlotId );
/*N*/ 		}
/*N*/ 	}
/*N*/     else
/*?*/         pImp->aFactoryName = String::CreateFromAscii( SfxObjectFactory::GetDefaultFactory().GetShortName() );
/*N*/ 
/*N*/     String aTitle = SfxViewFrame::UpdateTitle();
/*N*/ 	aTitle += String::CreateFromAscii( " - " );
/*N*/ 	aTitle += Application::GetDisplayName();
/*N*/ 
/*N*/     GetBindings().Invalidate( SID_NEWDOCDIRECT );
/*N*/ 
/*N*/     Window* pWindow = GetTopFrame_Impl()->GetTopWindow_Impl();
/*N*/     if ( pWindow && pWindow->GetText() != aTitle )
/*N*/         pWindow->SetText( aTitle );
/*N*/ 	return aTitle;
/*N*/ }

//--------------------------------------------------------------------
/*N*/ void SfxTopViewFrame::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
/*N*/ {
/*N*/ 	{DBG_CHKTHIS(SfxTopViewFrame, 0);}
/*N*/ 
/*N*/ 	if( IsDowning_Impl())
/*N*/ 		return;
/*N*/ 	// we know only SimpleHints
/*N*/ 	if ( rHint.IsA(TYPE(SfxSimpleHint)) )
/*N*/ 	{
/*N*/ 		switch( ( (SfxSimpleHint&) rHint ).GetId() )
/*N*/ 		{
/*N*/ 			case SFX_HINT_MODECHANGED:
/*N*/ 			case SFX_HINT_TITLECHANGED:
/*N*/ 				// when the document changes its title, change views too
/*N*/ 				UpdateTitle();
/*N*/ 				break;
/*N*/ 
/*N*/             case SFX_HINT_DEINITIALIZING:
/*N*/ 				// on all other changes force repaint
/*N*/ 				GetFrame()->DoClose();
/*N*/ 				return;
/*N*/ 				break;
/*N*/ 
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	SfxViewFrame::SFX_NOTIFY( rBC, rBCType, rHint, rHintType );
/*N*/ }

//--------------------------------------------------------------------
/*N*/ sal_Bool SfxTopViewFrame::Close()
/*N*/ {
/*N*/ 	{DBG_CHKTHIS(SfxTopViewFrame, 0);}
/*N*/ 
/*N*/ 	// Modaler Dialog oben ??
/*N*/ //	if ( pImp->GetModalDialog() )
/*N*/ //		return sal_False;
/*N*/ 
/*N*/ 	// eigentliches Schlie\sen
/*N*/ 	if ( SfxViewFrame::Close() )
/*N*/ 	{
/*N*/         SfxApplication *pSfxApp = SFX_APP();
/*N*/         if (pSfxApp->GetViewFrame() == this)
/*N*/             pSfxApp->SetViewFrame(0);
/*N*/ 
/*N*/ 		// Da der Dispatcher leer ger"aumt wird, kann man ihn auch nicht mehr
/*N*/ 		// vern"unftig verwenden - also besser still legen
/*N*/ 		GetDispatcher()->Lock(sal_True);
/*N*/ 		delete this;
/*N*/ 
/*N*/ 		return sal_True;
/*N*/ 	}
/*N*/ 
/*N*/ 	return sal_False;
/*N*/ }

/*N*/ SfxTopViewFrame::SfxTopViewFrame
/*N*/ (
/*N*/ 	SfxFrame*			pFrame,
/*N*/ 	SfxObjectShell* 	pObjShell,
/*N*/ 	sal_uInt16				nViewId
/*N*/ )

/*	[Beschreibung]

	Ctor des SfxTopViewFrame f"ur eine <SfxObjectShell> aus der Ressource.
	Die 'nViewId' der zu erzeugenden <SfxViewShell> kann angegeben werden
	(default ist die zuerst registrierte SfxViewShell-Subklasse).
*/

/*N*/     : SfxViewFrame( *(new SfxBindings), pFrame, pObjShell, SFXFRAME_HASTITLE )
/*N*/ {
/*N*/ 	DBG_CTOR(SfxTopViewFrame, 0);
/*N*/ 
/*N*/ 	pCloser = 0;
/*N*/ 	pImp = new SfxTopViewFrame_Impl;
/*N*/     pImp->pStopButtonTimer = new StopButtonTimer_Impl(this);
/*N*/ 
/*N*/ //(mba)/task    if ( !pFrame->GetTask() )
/*N*/     {
/*N*/         pImp->pWindow = new SfxTopViewWin_Impl( this, &pFrame->GetWindow() );
/*N*/         pImp->pWindow->SetSizePixel( pFrame->GetWindow().GetOutputSizePixel() );
/*N*/         SetWindow_Impl( pImp->pWindow );
/*N*/ 		pFrame->SetOwnsBindings_Impl( sal_True );
/*N*/         pFrame->CreateWorkWindow_Impl();
/*N*/     }
/*N*/ 
/*N*/ 	sal_uInt32 nType = SFXFRAME_OWNSDOCUMENT | SFXFRAME_HASTITLE;
/*N*/ 	if ( pObjShell && pObjShell->GetCreateMode() == SFX_CREATE_MODE_EMBEDDED )
/*N*/ 		nType |= SFXFRAME_EXTERNAL;
/*N*/ 	GetFrame()->SetFrameType_Impl( GetFrame()->GetFrameType() | nType );
/*N*/ 
/*N*/ 	// ViewShell erzeugen
/*N*/ 	if ( pObjShell )
/*N*/ 		SwitchToViewShell_Impl( nViewId );
/*N*/ 
/*N*/ 	// initiale Gr"o\se festlegen
/*N*/ 	if ( GetViewShell()->UseObjectSize() )
/*N*/ 	{
/*?*/ 		// Zuerst die logischen Koordinaten von IP-Objekt und EditWindow
/*?*/ 		// ber"ucksichtigen
/*N*/ 		LockAdjustPosSizePixel();
/*N*/ 		ForceInnerResize_Impl( TRUE );
/*?*/ 		SfxInPlaceObject *pIPObj = GetObjectShell()->GetInPlaceObject();
/*?*/ 		DBG_ASSERT( pIPObj, "UseObjectSize aber kein IP-Object" );
/*?*/ 		Window *pWindow = GetViewShell()->GetWindow();
/*?*/ 
/*?*/ 		// Da in den Applikationen bei der R"ucktransformation immer die
/*?*/ 		// Eckpunkte tranformiert werden und nicht die Size (um die Ecken
/*?*/ 		// alignen zu k"onnen), transformieren wir hier auch die Punkte, um
/*?*/ 		// m"oglichst wenig Rundungsfehler zu erhalten.
	/*
		Rectangle aRect = pWindow->LogicToLogic( pIPObj->GetVisArea(),
										pIPObj->GetMapUnit(),
										pWindow->GetMapMode() );
		aRect = pWindow->LogicToPixel( aRect );
	*/
/*?*/ 		Rectangle aRect = pWindow->LogicToPixel( pIPObj->GetVisArea() );
/*?*/ 		Size aSize = aRect.GetSize();
/*?*/ 		GetViewShell()->GetWindow()->SetSizePixel( aSize );
/*?*/ 		DoAdjustPosSizePixel(GetViewShell(), Point(), aSize );
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------
/*N*/ SfxTopViewFrame::~SfxTopViewFrame()
/*N*/ {
/*N*/ 	DBG_DTOR(SfxTopViewFrame, 0);
/*N*/ 
/*N*/ 	SetDowning_Impl();
/*N*/ 
/*N*/ 	SfxApplication *pApp = SFX_APP();
/*N*/ 	if ( pApp->GetViewFrame() == this )
/*?*/ 		pApp->SetViewFrame(NULL);
/*N*/ 
/*N*/ 	ReleaseObjectShell_Impl();
/*N*/ 	if ( pPendingCloser == pCloser )
/*N*/ 		pPendingCloser = 0;
/*N*/ 	delete pCloser;
/*N*/ 	if ( GetFrame()->OwnsBindings_Impl() )
/*N*/ 		// Die Bindings l"oscht der Frame!
/*N*/ 		KillDispatcher_Impl();
/*N*/ 
/*N*/     delete pImp->pWindow;
/*N*/     delete pImp->pStopButtonTimer;
/*N*/     delete pImp;
/*N*/ }

//------------------------------------------------------------------------
/*N*/ void SfxTopViewFrame::InvalidateBorderImpl
/*N*/ (
/*N*/ 	const SfxViewShell*
/*N*/ )
/*N*/ {
/*N*/ 	if ( GetViewShell() && GetWindow().IsVisible() )
/*N*/ 	{
/*?*/ 		if ( GetViewShell()->UseObjectSize() )
/*?*/ 		{
/*?*/ 			// Zun"achst die Gr"o\se des MDI-Fensters berechnen
/*?*/ 
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 DoAdjustPosSizePixel( GetViewShell(), Point(),
//STRIP001 /*?*/ 							  GetViewShell()->GetWindow()->GetSizePixel() );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			// Da nach einem InnerResize die Position des EditFensters und
//STRIP001 /*?*/ 			// damit auch der Tools nocht stimmt, mu\s nun noch einmal von
//STRIP001 /*?*/ 			// au\sen resized werden !
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			ForceOuterResize_Impl(sal_True);
/*?*/ 		}
/*?*/ 
/*?*/ 		DoAdjustPosSizePixel( (SfxViewShell *) GetViewShell(), Point(),
/*?*/ 										GetWindow().GetOutputSizePixel() );
/*?*/ 		if ( GetViewShell()->UseObjectSize() )
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 ForceOuterResize_Impl(sal_False);
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------
/*N*/ sal_Bool SfxTopViewFrame::SetBorderPixelImpl( const SfxViewShell *pVSh, const SvBorder &rBorder )
/*N*/ {
/*N*/ 	if( SfxViewFrame::SetBorderPixelImpl( GetViewShell(), rBorder ) )
/*N*/ 	{
/*N*/ 		if ( IsResizeInToOut_Impl() )
/*N*/ 		{
/*?*/ 			Size aSize = pVSh->GetWindow()->GetOutputSizePixel();
/*?*/ 			if ( aSize.Width() && aSize.Height() )
/*?*/ 			{
/*?*/ 				aSize.Width() += rBorder.Left() + rBorder.Right();
/*?*/ 				aSize.Height() += rBorder.Top() + rBorder.Bottom();
/*?*/ 
/*?*/ 				Size aOldSize = GetWindow().GetOutputSizePixel();
/*?*/ 				GetWindow().SetOutputSizePixel( aSize );
/*?*/ 				Window* pParent = &GetWindow();
/*?*/ 				while ( pParent->GetParent() )
/*?*/ 					pParent = pParent->GetParent();
/*?*/ 				Size aOuterSize = pParent->GetOutputSizePixel();
/*?*/ 				aOuterSize.Width() += ( aSize.Width() - aOldSize.Width() );
/*?*/ 				aOuterSize.Height() += ( aSize.Height() - aOldSize.Height() );
/*?*/ 				pParent->SetOutputSizePixel( aOuterSize );
/*?*/ 			}
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
/*N*/ 			Point aPoint;
/*N*/ 			Rectangle aEditArea( aPoint, GetWindow().GetOutputSizePixel() );
/*N*/ 			aEditArea.Left() += rBorder.Left();
/*N*/ 			aEditArea.Right() -= rBorder.Right();
/*N*/ 			aEditArea.Top() += rBorder.Top();
/*N*/ 			aEditArea.Bottom() -= rBorder.Bottom();
/*N*/ 			pVSh->GetWindow()->SetPosSizePixel( aEditArea.TopLeft(), aEditArea.GetSize() );
/*N*/ 		}
/*N*/ 		return sal_True;
/*N*/ 
/*N*/ 	}
/*N*/ 	return sal_False;
/*N*/ }

/*N*/ void SfxTopViewFrame::Exec_Impl(SfxRequest &rReq )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	// Wenn gerade die Shells ausgetauscht werden...
//STRIP001 	if ( !GetObjectShell() || !GetViewShell() )
//STRIP001 		return;
//STRIP001 
//STRIP001 	switch ( rReq.GetSlot() )
//STRIP001 	{
//STRIP001         case SID_SHOWPOPUPS :
//STRIP001         {
//STRIP001 			SFX_REQUEST_ARG(rReq, pShowItem, SfxBoolItem, SID_SHOWPOPUPS, FALSE);
//STRIP001 			BOOL bShow = pShowItem ? pShowItem->GetValue() : TRUE;
//STRIP001 			SFX_REQUEST_ARG(rReq, pIdItem, SfxUInt16Item, SID_CONFIGITEMID, FALSE);
//STRIP001 			USHORT nId = pIdItem ? pIdItem->GetValue() : 0;
//STRIP001 
//STRIP001 			// ausfuehren
//STRIP001             SfxWorkWindow *pWorkWin = GetFrame()->GetWorkWindow_Impl();
//STRIP001 			if ( bShow )
//STRIP001 			{
//STRIP001 				// Zuerst die Floats auch anzeigbar machen
//STRIP001 				pWorkWin->MakeChildsVisible_Impl( bShow );
//STRIP001                 GetDispatcher()->Update_Impl( TRUE );
//STRIP001 
//STRIP001 				// Dann anzeigen
//STRIP001                 GetBindings().HidePopups( !bShow );
//STRIP001 			}
//STRIP001             else
//STRIP001 			{
//STRIP001 				// Alles hiden
//STRIP001 				SfxBindings *pBind = &GetBindings();
//STRIP001 				while ( pBind )
//STRIP001 				{
//STRIP001 					pBind->HidePopupCtrls_Impl( !bShow );
//STRIP001 					pBind = pBind->GetSubBindings_Impl();
//STRIP001 				}
//STRIP001 
//STRIP001 				pWorkWin->HidePopups_Impl( !bShow, TRUE, nId );
//STRIP001 				pWorkWin->MakeChildsVisible_Impl( bShow );
//STRIP001 			}
//STRIP001 
//STRIP001             Invalidate( rReq.GetSlot() );
//STRIP001             rReq.Done();
//STRIP001 			break;
//STRIP001         }
//STRIP001 
//STRIP001 		case SID_ACTIVATE:
//STRIP001 		{
//STRIP001             MakeActive_Impl( TRUE );
//STRIP001             rReq.SetReturnValue( SfxObjectItem( 0, this ) );
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case SID_WIN_POSSIZE:
//STRIP001 			break;
//STRIP001 
//STRIP001         case SID_NEWDOCDIRECT :
//STRIP001         {
//STRIP001             SFX_REQUEST_ARG( rReq, pFactoryItem, SfxStringItem, SID_NEWDOCDIRECT, FALSE);
//STRIP001             String aFactName;
//STRIP001             if ( pFactoryItem )
//STRIP001                 aFactName = pFactoryItem->GetValue();
//STRIP001             else if ( pImp->aFactoryName.Len() )
//STRIP001 				aFactName = pImp->aFactoryName;
//STRIP001 			else
//STRIP001             {
//STRIP001                 DBG_ERROR("Missing argument!");
//STRIP001                 break;
//STRIP001             }
//STRIP001 
//STRIP001             SfxRequest aReq( SID_OPENDOC, SFX_CALLMODE_SYNCHRON, GetPool() );
//STRIP001             String aFact = String::CreateFromAscii("private:factory/");
//STRIP001             aFact += aFactName;
//STRIP001             aReq.AppendItem( SfxStringItem( SID_FILE_NAME, aFact ) );
//STRIP001             aReq.AppendItem( SfxFrameItem( SID_DOCFRAME, GetFrame() ) );
//STRIP001             aReq.AppendItem( SfxStringItem( SID_TARGETNAME, String::CreateFromAscii( "_blank" ) ) );
//STRIP001             SFX_APP()->ExecuteSlot( aReq );
//STRIP001             const SfxViewFrameItem* pItem = PTR_CAST( SfxViewFrameItem, aReq.GetReturnValue() );
//STRIP001             if ( pItem )
//STRIP001                 rReq.SetReturnValue( SfxFrameItem( 0, pItem->GetFrame() ) );
//STRIP001             break;
//STRIP001         }
//STRIP001 
//STRIP001         case SID_CLOSEWIN:
//STRIP001 		{
//STRIP001 			// disable CloseWin, if frame is not a task
//STRIP001             Reference < XCloseable > xTask( GetFrame()->GetFrameInterface(),  UNO_QUERY );
//STRIP001 			if ( !xTask.is() )
//STRIP001 				break;
//STRIP001 
//STRIP001 			if ( GetViewShell()->PrepareClose() )
//STRIP001 			{
//STRIP001                 // weitere Views auf dasselbe Doc?
//STRIP001 				SfxObjectShell *pDocSh = GetObjectShell();
//STRIP001 				int bOther = sal_False;
//STRIP001 				for ( const SfxTopViewFrame *pFrame =
//STRIP001 						  (SfxTopViewFrame *)SfxViewFrame::GetFirst( pDocSh, TYPE(SfxTopViewFrame) );
//STRIP001 					  !bOther && pFrame;
//STRIP001 					  pFrame = (SfxTopViewFrame *)SfxViewFrame::GetNext( *pFrame, pDocSh, TYPE(SfxTopViewFrame) ) )
//STRIP001 					bOther = (pFrame != this);
//STRIP001 
//STRIP001 				// Doc braucht nur gefragt zu werden, wenn keine weitere ::com::sun::star::sdbcx::View
//STRIP001 				sal_Bool bClosed = sal_False;
//STRIP001                 sal_Bool bUI = TRUE;
//STRIP001                 if ( SfxApplication::IsPlugin() && rReq.GetSlot() == SID_BACKTOWEBTOP )
//STRIP001                     bUI = 2;
//STRIP001                 if ( ( bOther || pDocSh->PrepareClose( bUI ) ) )
//STRIP001 				{
//STRIP001 					if ( !bOther )
//STRIP001                     	pDocSh->SetModified( FALSE );
//STRIP001 					rReq.Done(); // unbedingt vor Close() rufen!
//STRIP001                     bClosed = sal_False;
//STRIP001 /*
//STRIP001 					::com::sun::star::uno::Reference < ::com::sun::star::frame::XFramesSupplier >
//STRIP001 					        xDesktop( ::legacy_binfilters::getLegacyProcessServiceFactory()->createInstance( ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("com.sun.star.frame.Desktop")) ),
//STRIP001 					        ::com::sun::star::uno::UNO_QUERY );
//STRIP001 					::com::sun::star::uno::Reference < ::com::sun::star::container::XIndexAccess > xList ( xDesktop->getFrames(), ::com::sun::star::uno::UNO_QUERY );
//STRIP001 					sal_Int32 nCount = xList->getCount();
//STRIP001 					if ( nCount == 1 )
//STRIP001 					{
//STRIP001 						GetFrame()->CloseDocument_Impl();
//STRIP001                     	bClosed = sal_True;
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001  */
//STRIP001 	                try
//STRIP001 	                {
//STRIP001 	                    xTask->close(sal_True);
//STRIP001 	                    bClosed = sal_True;
//STRIP001 	                }
//STRIP001 	                catch( CloseVetoException& )
//STRIP001 	                {
//STRIP001 	                    bClosed = sal_False;
//STRIP001 	                }
//STRIP001    //					}
//STRIP001 				}
//STRIP001 
//STRIP001 				rReq.SetReturnValue( SfxBoolItem( rReq.GetSlot(), bClosed ));
//STRIP001 			}
//STRIP001 			return;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	rReq.Done();
/*N*/ }

/*N*/ void SfxTopViewFrame::GetState_Impl( SfxItemSet &rSet )
/*N*/ {
/*N*/ 	SfxObjectShell *pDocSh = GetObjectShell();
/*N*/ 
/*N*/ 	if ( !pDocSh )
/*N*/ 		return;
/*N*/ 
/*N*/ 	const sal_uInt16 *pRanges = rSet.GetRanges();
/*N*/ 	DBG_ASSERT(pRanges, "Set ohne Bereich");
/*N*/ 	while ( *pRanges )
/*N*/ 	{
/*N*/ 		for ( sal_uInt16 nWhich = *pRanges++; nWhich <= *pRanges; ++nWhich )
/*N*/ 		{
/*N*/ 			switch(nWhich)
/*N*/ 			{
/*N*/             case SID_NEWDOCDIRECT :
/*N*/             {
/*N*/ 				if ( pImp->aFactoryName.Len() )
/*N*/ 				{
/*N*/ 	                String aFact = String::CreateFromAscii("private:factory/");
/*N*/ 		            aFact += pImp->aFactoryName;
/*N*/ 	                rSet.Put( SfxStringItem( nWhich, aFact ) );
/*N*/ 				}
/*N*/                 break;
/*N*/             }
/*N*/ 
/*N*/ 			case SID_NEWWINDOW:
/*?*/ 				rSet.DisableItem(nWhich);
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SID_CLOSEWIN:
/*?*/ 			{
/*?*/ 				// disable CloseWin, if frame is not a task
/*?*/                 Reference < ::com::sun::star::util::XCloseable > xTask( GetFrame()->GetFrameInterface(),  UNO_QUERY );
/*?*/ 				if ( !xTask.is() )
/*?*/ 					rSet.DisableItem(nWhich);
/*?*/ 				break;
/*?*/ 			}
/*?*/ 
/*?*/             case SID_SHOWPOPUPS :
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SID_WIN_POSSIZE:
/*?*/ 			{
/*?*/ 				rSet.Put( SfxRectangleItem( nWhich, Rectangle(
/*?*/ 						GetWindow().GetPosPixel(), GetWindow().GetSizePixel() ) ) );
/*?*/ 				break;
/*?*/ 			}
/*N*/ 
/*N*/ 			default:
/*N*/ 				DBG_ERROR( "invalid message-id" );
/*N*/ 			}
/*N*/ 		}
/*N*/ 		++pRanges;
/*N*/ 	}
/*N*/ }

/*N*/ void SfxTopViewFrame::INetExecute_Impl( SfxRequest &rRequest )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	sal_uInt16 nSlotId = rRequest.GetSlot();
//STRIP001 	switch( nSlotId )
//STRIP001 	{
//STRIP001 		case SID_BROWSE_FORWARD:
//STRIP001 		case SID_BROWSE_BACKWARD:
//STRIP001 		{
//STRIP001 			// Anzeige der n"achsten oder vorherigen Seite aus der History
//STRIP001 			SFX_REQUEST_ARG( rRequest, pSteps, SfxUInt16Item, nSlotId, sal_False );
//STRIP001 			GetFrame()->Browse( nSlotId == SID_BROWSE_FORWARD, pSteps ? pSteps->GetValue() : 1,
//STRIP001 				(rRequest.GetModifier() & KEY_MOD1) != 0 );
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case SID_CREATELINK:
//STRIP001 		{
//STRIP001 /*! (pb) we need new implementation to create a link
//STRIP001 */
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case SID_BROWSE_STOP:
//STRIP001 		{
//STRIP001             if ( GetCancelManager() )
//STRIP001                 GetCancelManager()->Cancel( TRUE );
//STRIP001 
//STRIP001             // cancel jobs in hidden tasks
//STRIP001             SfxFrameArr_Impl& rArr = *SFX_APP()->Get_Impl()->pTopFrames;
//STRIP001             for( USHORT nPos = rArr.Count(); nPos--; )
//STRIP001             {
//STRIP001                 SfxFrame *pFrame = rArr[ nPos ];
//STRIP001                 if ( !pFrame->GetCurrentViewFrame() )
//STRIP001                     pFrame->GetCancelManager()->Cancel( TRUE );
//STRIP001             }
//STRIP001 
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case SID_FOCUSURLBOX:
//STRIP001 		{
//STRIP001             SfxStateCache *pCache = GetBindings().GetAnyStateCache_Impl( SID_OPENURL );
//STRIP001 			if( pCache )
//STRIP001 			{
//STRIP001 				SfxControllerItem* pCtrl = pCache->GetItemLink();
//STRIP001 				while( pCtrl )
//STRIP001 				{
//STRIP001                     pCtrl->StateChanged( SID_FOCUSURLBOX, SFX_ITEM_UNKNOWN, 0 );
//STRIP001 					pCtrl = pCtrl->GetItemLink();
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Recording
//STRIP001 	rRequest.Done();
/*N*/ }

/*N*/ void SfxTopViewFrame::INetState_Impl( SfxItemSet &rItemSet )
/*N*/ {
/*N*/ 	if ( !GetFrame()->CanBrowseForward() )
/*N*/ 		rItemSet.DisableItem( SID_BROWSE_FORWARD );
/*N*/ 
/*N*/ 	if ( !GetFrame()->CanBrowseBackward() )
/*N*/ 		rItemSet.DisableItem( SID_BROWSE_BACKWARD );
/*N*/ 
/*N*/     // Add/SaveToBookmark bei BASIC-IDE, QUERY-EDITOR etc. disablen
/*N*/ 	SfxObjectShell *pDocSh = GetObjectShell();
/*N*/     sal_Bool bPseudo = pDocSh && !( pDocSh->GetFactory().GetFlags() & SFXOBJECTSHELL_HASOPENDOC );
/*N*/     sal_Bool bEmbedded = pDocSh && pDocSh->GetCreateMode() == SFX_CREATE_MODE_EMBEDDED;
/*N*/ 	if ( !pDocSh || bPseudo || bEmbedded || !pDocSh->HasName() )
/*N*/ 		rItemSet.DisableItem( SID_CREATELINK );
/*N*/ 
/*N*/     pImp->pStopButtonTimer->SetButtonState( GetCancelManager()->CanCancel() );
/*N*/     if ( !pImp->pStopButtonTimer->GetButtonState() )
/*N*/ 		rItemSet.DisableItem( SID_BROWSE_STOP );
/*N*/ }

/*N*/ void SfxTopViewFrame::SetZoomFactor( const Fraction &rZoomX, const Fraction &rZoomY )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	GetViewShell()->SetZoomFactor( rZoomX, rZoomY );
/*N*/ }

/*N*/ void SfxTopViewFrame::Activate( sal_Bool bMDI )
/*N*/ {
/*N*/ 	DBG_ASSERT(GetViewShell(), "Keine Shell");
/*N*/ 	if ( bMDI && !pImp->bActive )
/*N*/     {
/*N*/         pImp->bActive = sal_True;
/*N*/         SfxWorkWindow *pWorkWin = GetFrame()->GetWorkWindow_Impl();
/*N*/         SfxBindings *pBind = &GetBindings();
/*N*/         while ( pBind )
/*N*/         {
/*N*/             pBind->HidePopupCtrls_Impl( FALSE );
/*N*/             pBind = pBind->GetSubBindings_Impl();
/*N*/         }
/*N*/ 
/*N*/         pWorkWin->HidePopups_Impl( FALSE, FALSE, 1 );
/*N*/     }
/*N*/ //(mba): hier evtl. wie in Beanframe NotifyEvent ?!
/*N*/ }

/*N*/ void SfxTopViewFrame::Deactivate( sal_Bool bMDI )
/*N*/ {
/*N*/ 	DBG_ASSERT(GetViewShell(), "Keine Shell");
/*N*/ 	if ( bMDI && pImp->bActive )
/*N*/     {
/*N*/ 		pImp->bActive = sal_False;
/*N*/         SfxWorkWindow *pWorkWin = GetFrame()->GetWorkWindow_Impl();
/*N*/         SfxBindings *pBind = &GetBindings();
/*N*/         while ( pBind )
/*N*/         {
/*N*/             pBind->HidePopupCtrls_Impl( TRUE );
/*N*/             pBind = pBind->GetSubBindings_Impl();
/*N*/         }
/*N*/ 
/*N*/         pWorkWin->HidePopups_Impl( TRUE, FALSE, 1 );
/*N*/     }
/*N*/ //(mba): hier evtl. wie in Beanframe NotifyEvent ?!
/*N*/ }

/*N*/ void SfxTopFrame::CheckMenuCloser_Impl( MenuBar* pMenuBar )
/*N*/ {
/*N*/ 	Reference < ::com::sun::star::frame::XFrame > xFrame = GetFrameInterface();
/*N*/ 
/*N*/ 	// checks if there is more than one "real" (not help) task window
/*N*/ 	// in this case a close button is inserted into the menubar
/*N*/ 
/*N*/ 	if ( !xFrame->getController().is() )
/*N*/ 		// dummy component
/*N*/ 		return;
/*N*/ 
/*N*/     Reference < ::com::sun::star::frame::XFramesSupplier > xDesktop( xFrame->getCreator(), UNO_QUERY );
/*N*/ 	if ( !xDesktop.is() )
/*N*/ 		// test only for task windows
/*N*/ 		return;
/*N*/ 
/*N*/ 	sal_Bool bLastTask = sal_False;
/*N*/     Reference < ::com::sun::star::container::XIndexAccess >
/*N*/ 			xList ( xDesktop->getFrames(), ::com::sun::star::uno::UNO_QUERY );
/*N*/     sal_Int32 nCount = xList->getCount();
/*N*/ 	if ( nCount<=1 )
/*N*/ 		// only one task
/*N*/ 		bLastTask = sal_True;
/*N*/ 	else if ( nCount==2 )
/*N*/ 	{
/*N*/ 		// if we have to tasks, one can be the help task, that should be ignored
/*N*/     	for( sal_Int32 i=0; i<nCount; ++i )
/*N*/     	{
/*N*/ 			Reference < ::com::sun::star::frame::XFrame > xTask;
/*N*/         	::com::sun::star::uno::Any aVal = xList->getByIndex(i);
/*N*/         	if ( (aVal>>=xTask) && xTask.is() && xTask->getName().compareToAscii("OFFICE_HELP_TASK") == COMPARE_EQUAL )
/*N*/ 			{
/*N*/ 				// one of the two open tasks was the help task -> ignored
/*N*/ 				bLastTask = sal_True;
/*N*/ 				break;
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	pMenuBar->ShowCloser(bLastTask);
/*N*/ }
}
