/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_colmgr.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 05:12:51 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
namespace binfilter {


//STRIP001 #pragma hdrstop
//STRIP001 
//STRIP001 #include "hintids.hxx"
//STRIP001 
//STRIP001 #ifndef _SVX_LRSPITEM_HXX //autogen
//STRIP001 #include <bf_svx/lrspitem.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #include "frmmgr.hxx"
//STRIP001 #include "frmfmt.hxx"
//STRIP001 #include "colmgr.hxx"
//STRIP001 
//STRIP001 
//STRIP001 // PRIVATE METHODES ------------------------------------------------------
//STRIP001 /*------------------------------------------------------------------------
//STRIP001  Beschreibung:	Spaltenbreite auf aktuelle Breite einstellen
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 void FitToActualSize(SwFmtCol& rCol, USHORT nWidth)
//STRIP001 {
//STRIP001 	const USHORT nCount = rCol.GetColumns().Count();
//STRIP001 	for(USHORT i = 0; i < nCount; ++i)
//STRIP001 	{
//STRIP001 		const USHORT nTmp = rCol.CalcColWidth(i, nWidth);
//STRIP001 		rCol.GetColumns()[i]->SetWishWidth(nTmp);
//STRIP001 	}
//STRIP001 	rCol.SetWishWidth(nWidth);
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // PUBLIC METHODES -------------------------------------------------------
//STRIP001 /*------------------------------------------------------------------------
//STRIP001  Beschreibung:	Setzen Spaltenanzahl und Gutterwidth
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 void SwColMgr::SetCount(USHORT nCount, USHORT  nGutterWidth)
//STRIP001 {
//STRIP001 	aFmtCol.Init(nCount, nGutterWidth, nWidth);
//STRIP001 	aFmtCol.SetWishWidth(nWidth);
//STRIP001 	aFmtCol.SetGutterWidth(nGutterWidth, nWidth);
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 USHORT SwColMgr::GetGutterWidth( USHORT nPos ) const
//STRIP001 {
//STRIP001 	USHORT nRet;
//STRIP001 	if(nPos == USHRT_MAX )
//STRIP001 		nRet = GetCount() > 1 ? aFmtCol.GetGutterWidth() : DEF_GUTTER_WIDTH;
//STRIP001 	else
//STRIP001 	{
//STRIP001 		DBG_ASSERT(nPos < GetCount() - 1, "Spalte ueberindiziert" )
//STRIP001 		const SwColumns& rCols = aFmtCol.GetColumns();
//STRIP001 		nRet = rCols.GetObject(nPos)->GetRight() + rCols.GetObject(nPos + 1)->GetLeft();
//STRIP001 	}
//STRIP001 	return nRet;
//STRIP001 }
//STRIP001 
//STRIP001 /*-----------------22.10.96 14.28-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void SwColMgr::SetGutterWidth(USHORT nGutterWidth, USHORT nPos )
//STRIP001 {
//STRIP001 	if(nPos == USHRT_MAX)
//STRIP001 		aFmtCol.SetGutterWidth(nGutterWidth, nWidth);
//STRIP001 	else
//STRIP001 	{
//STRIP001 		DBG_ASSERT(nPos < GetCount() - 1, "Spalte ueberindiziert" )
//STRIP001 		SwColumns& rCols = aFmtCol.GetColumns();
//STRIP001 		USHORT nGutterWidth2 = nGutterWidth / 2;
//STRIP001 		rCols.GetObject(nPos)->SetRight(nGutterWidth2);
//STRIP001 		rCols.GetObject(nPos + 1)->SetLeft(nGutterWidth2);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*------------------------------------------------------------------------
//STRIP001  Beschreibung:	Hoehe Trennlinie
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 short SwColMgr::GetLineHeightPercent() const
//STRIP001 {
//STRIP001 	return (short)aFmtCol.GetLineHeight();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 void SwColMgr::SetLineHeightPercent(short nPercent)
//STRIP001 {
//STRIP001 	ASSERT(nPercent <= 100, LineHeight darf nur bis 100 % gross  sein);
//STRIP001 	aFmtCol.SetLineHeight((BYTE)nPercent);
//STRIP001 }
//STRIP001 /*------------------------------------------------------------------------
//STRIP001  Beschreibung:	Spaltenbreite
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 USHORT SwColMgr::GetColWidth(USHORT nIdx) const
//STRIP001 {
//STRIP001 	ASSERT(nIdx < GetCount(), Spaltenarray ueberindiziert.);
//STRIP001 	return aFmtCol.CalcPrtColWidth(nIdx, nWidth);
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 void SwColMgr::SetColWidth(USHORT nIdx, USHORT nWd)
//STRIP001 {
//STRIP001 	ASSERT(nIdx < GetCount(), Spaltenarray ueberindiziert.);
//STRIP001 	aFmtCol.GetColumns()[nIdx]->SetWishWidth(nWd);
//STRIP001 
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung: 	Groesse neu setzen
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 void SwColMgr::SetActualWidth(USHORT nW)
//STRIP001 {
//STRIP001 	nWidth = nW;
//STRIP001 	::FitToActualSize(aFmtCol, nW);
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung: ctor
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 SwColMgr::SwColMgr(const SfxItemSet& rSet, USHORT nActWidth) :
//STRIP001 	aFmtCol((const SwFmtCol&)rSet.Get(RES_COL)),
//STRIP001 	nWidth(nActWidth)
//STRIP001 {
//STRIP001 	if(nWidth == USHRT_MAX)
//STRIP001 	{
//STRIP001 		nWidth = (USHORT)((const SwFmtFrmSize&)rSet.Get(RES_FRM_SIZE)).GetWidth();
//STRIP001 		if (nWidth < MINLAY)
//STRIP001 			nWidth = USHRT_MAX;
//STRIP001 		const SvxLRSpaceItem &rLR = (const SvxLRSpaceItem&)rSet.Get(RES_LR_SPACE);
//STRIP001 		nWidth -= (USHORT)rLR.GetLeft();
//STRIP001 		nWidth -= (USHORT)rLR.GetRight();
//STRIP001 	}
//STRIP001 	::FitToActualSize(aFmtCol, nWidth);
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 SwColMgr::~SwColMgr() {}






}
