/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_outline.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 06:21:31 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
namespace binfilter {


//STRIP001 #pragma hdrstop
//STRIP001 
//STRIP001 #ifndef _HINTIDS_HXX
//STRIP001 #include <hintids.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _SHL_HXX //autogen
//STRIP001 #include <tools/shl.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _MENU_HXX //autogen
//STRIP001 #include <vcl/menu.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _MSGBOX_HXX //autogen
//STRIP001 #include <vcl/msgbox.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SFXTABDLG_HXX //autogen
//STRIP001 #include <bf_sfx2/tabdlg.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVX_BRSHITEM_HXX //autogen
//STRIP001 #include <bf_svx/brshitem.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _UTL_CONFIGMGR_HXX_
//STRIP001 #include <unotools/configmgr.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SWSTYLENAMEMAPPER_HXX
//STRIP001 #include <SwStyleNameMapper.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _NUM_HXX //autogen
//STRIP001 #define USE_NUMTABPAGES
//STRIP001 #include <num.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _VIEW_HXX
//STRIP001 #include <view.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _DOCSH_HXX
//STRIP001 #include <docsh.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _UITOOL_HXX
//STRIP001 #include <uitool.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _ERRHDL_HXX
//STRIP001 #include <errhdl.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _WRTSH_HXX
//STRIP001 #include <wrtsh.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SWMODULE_HXX
//STRIP001 #include <swmodule.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _NUMRULE_HXX
//STRIP001 #include <numrule.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _FMTCOL_HXX
//STRIP001 #include <fmtcol.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _OUTLINE_HXX
//STRIP001 #include <outline.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _UINUMS_HXX
//STRIP001 #include <uinums.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _POOLFMT_HXX
//STRIP001 #include <poolfmt.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SHELLRES_HXX //autogen
//STRIP001 #include <shellres.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SFXSTYLE_HXX //autogen
//STRIP001 #include <svtools/style.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _CHARFMT_HXX //autogen
//STRIP001 #include <charfmt.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _DOCSTYLE_HXX //autogen
//STRIP001 #include <docstyle.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _VIEWOPT_HXX
//STRIP001 #include <viewopt.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _HELPID_H
//STRIP001 #include <helpid.h>
//STRIP001 #endif
//STRIP001 #ifndef _GLOBALS_HRC
//STRIP001 #include <globals.hrc>		// fuer Vorlagenname 'keins'
//STRIP001 #endif
//STRIP001 #ifndef _MISC_HRC
//STRIP001 #include <misc.hrc>
//STRIP001 #endif
//STRIP001 #ifndef _OUTLINE_HRC
//STRIP001 #include <outline.hrc>
//STRIP001 #endif
//STRIP001 
//STRIP001 #define C2S(cChar) UniString::CreateFromAscii(cChar)
//STRIP001 /* -----------------------------31.01.01 10:23--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 DBG_NAME(outlinehdl)
//STRIP001 
//STRIP001 USHORT lcl_AdjustToPos(SvxAdjust eAdjust)
//STRIP001 {
//STRIP001 	USHORT nRet = 0;
//STRIP001 	switch( eAdjust )
//STRIP001 	{
//STRIP001 		case SVX_ADJUST_CENTER: nRet = 1;break;
//STRIP001 		case SVX_ADJUST_RIGHT: nRet = 2; break;
//STRIP001 	}
//STRIP001 	return nRet;
//STRIP001 }
//STRIP001 /*---------------------------------------------------------------------
//STRIP001 
//STRIP001 ---------------------------------------------------------------------*/
//STRIP001 
//STRIP001 class SwNumNamesDlg: public ModalDialog
//STRIP001 {
//STRIP001 	Edit         aFormEdit;
//STRIP001 	ListBox      aFormBox;
//STRIP001     FixedLine    aFormFL;
//STRIP001 	OKButton     aOKBtn;
//STRIP001 	CancelButton aCancelBtn;
//STRIP001 	HelpButton   aHelpBtn;
//STRIP001 
//STRIP001 	DECL_LINK( ModifyHdl, Edit * );
//STRIP001 	DECL_LINK( SelectHdl, ListBox * );
//STRIP001 	DECL_LINK( DoubleClickHdl, ListBox * );
//STRIP001 
//STRIP001 public:
//STRIP001 	SwNumNamesDlg(Window *pParent);
//STRIP001 	~SwNumNamesDlg();
//STRIP001 	void SetUserNames(const String *pList[]);
//STRIP001 	String GetName() const { return aFormEdit.GetText(); }
//STRIP001 	USHORT GetCurEntryPos() const { return aFormBox.GetSelectEntryPos(); }
//STRIP001 };
//STRIP001 
//STRIP001 /*------------------------------------------------------------------------
//STRIP001  Beschreibung:  selektierten Eintrag merken
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 IMPL_LINK_INLINE_START( SwNumNamesDlg, SelectHdl, ListBox *, pBox )
//STRIP001 {
//STRIP001 	aFormEdit.SetText(pBox->GetSelectEntry());
//STRIP001 	aFormEdit.SetSelection(Selection(0, SELECTION_MAX));
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SwNumNamesDlg, SelectHdl, ListBox *, pBox )
//STRIP001 
//STRIP001 /*------------------------------------------------------------------------
//STRIP001  Beschreibung:  Setzen der vom Benutzer vergebenen Namen
//STRIP001  Parameter:     Liste der vom Benutzer vergebenen Namen;
//STRIP001 				nicht vom Benutzer benannte Positionen sind 0.
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void SwNumNamesDlg::SetUserNames(const String *pList[])
//STRIP001 {
//STRIP001 	USHORT nSelect = 0;
//STRIP001 	for(USHORT i = 0; i < SwBaseNumRules::nMaxRules; ++i)
//STRIP001 	{
//STRIP001 		if(pList[i])
//STRIP001 		{
//STRIP001 			aFormBox.RemoveEntry(i);
//STRIP001 			aFormBox.InsertEntry(*pList[i], i);
//STRIP001 			if(i == nSelect && nSelect < SwBaseNumRules::nMaxRules)
//STRIP001 				nSelect++;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	aFormBox.SelectEntryPos(nSelect);
//STRIP001 	SelectHdl(&aFormBox);
//STRIP001 }
//STRIP001 /*------------------------------------------------------------------------
//STRIP001  Beschreibung:  OK-Button freischalten, wenn Text im Edit steht.
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 IMPL_LINK_INLINE_START( SwNumNamesDlg, ModifyHdl, Edit *, pBox )
//STRIP001 {
//STRIP001 	aOKBtn.Enable(0 != pBox->GetText().Len());
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SwNumNamesDlg, ModifyHdl, Edit *, pBox )
//STRIP001 /*------------------------------------------------------------------------
//STRIP001  Beschreibung:  DoubleClickHdl
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 IMPL_LINK_INLINE_START( SwNumNamesDlg, DoubleClickHdl, ListBox *, EMPTYARG )
//STRIP001 {
//STRIP001 	EndDialog(RET_OK);
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SwNumNamesDlg, DoubleClickHdl, ListBox *, EMPTYARG )
//STRIP001 
//STRIP001 /*--------------------------------------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 
//STRIP001 SwNumNamesDlg::SwNumNamesDlg(Window *pParent)
//STRIP001 	: ModalDialog(pParent, SW_RES(DLG_NUM_NAMES)),
//STRIP001 	aFormEdit(this, SW_RES(ED_FORM)),
//STRIP001 	aFormBox(this, SW_RES(LB_FORM)),
//STRIP001     aFormFL(this, SW_RES(FL_FORM)),
//STRIP001 	aOKBtn(this, SW_RES(BT_OK)),
//STRIP001 	aCancelBtn(this, SW_RES(BT_CANCEL)),
//STRIP001 	aHelpBtn(this, SW_RES(BT_HELP))
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 	aFormEdit.SetModifyHdl(LINK(this, SwNumNamesDlg, ModifyHdl));
//STRIP001 	aFormBox.SetSelectHdl(LINK(this, SwNumNamesDlg, SelectHdl));
//STRIP001 	aFormBox.SetDoubleClickHdl(LINK(this, SwNumNamesDlg, DoubleClickHdl));
//STRIP001 	SelectHdl(&aFormBox);
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 
//STRIP001 __EXPORT SwNumNamesDlg::~SwNumNamesDlg() {}
//STRIP001 
//STRIP001 
//STRIP001 /* -----------------08.07.98 08:46-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 USHORT lcl_BitToLevel(USHORT nActLevel)
//STRIP001 {
//STRIP001 	USHORT nTmp = nActLevel;
//STRIP001 	USHORT nTmpLevel = 0;
//STRIP001 	while( 0 != (nTmp >>= 1) )
//STRIP001 		nTmpLevel++;
//STRIP001 	return nTmpLevel;
//STRIP001 }
//STRIP001 
//STRIP001 /* -----------------07.07.98 14:13-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 SwOutlineTabDialog::SwOutlineTabDialog(Window* pParent,
//STRIP001 					const SfxItemSet* pSwItemSet,
//STRIP001 					SwWrtShell &rSh) :
//STRIP001 									//der UserString wird danach richtig gesetzt
//STRIP001 		SfxTabDialog(pParent, SW_RES(DLG_TAB_OUTLINE), pSwItemSet, FALSE, &aEmptyStr),
//STRIP001 		aFormMenu(SW_RES(MN_FORM)),
//STRIP001 		bModified(rWrtSh.IsModified()),
//STRIP001 		aNullStr(C2S("____")),
//STRIP001 		nNumLevel(1),
//STRIP001 		pChapterNumRules(SW_MOD()->GetChapterNumRules()),
//STRIP001 		rWrtSh(rSh)
//STRIP001 {
//STRIP001 	PushButton* pUserBtn = GetUserButton();
//STRIP001 	pUserBtn->SetText(SW_RES(ST_FORM));
//STRIP001 	pUserBtn->SetHelpId(HID_OUTLINE_FORM);
//STRIP001 	pUserBtn->SetClickHdl(LINK(this, SwOutlineTabDialog, FormHdl));
//STRIP001 
//STRIP001 	FreeResource();
//STRIP001 	pNumRule = new SwNumRule( *rSh.GetOutlineNumRule() );
//STRIP001 	GetCancelButton().SetClickHdl(LINK(this, SwOutlineTabDialog, CancelHdl));
//STRIP001 
//STRIP001 	AddTabPage(TP_NUM_POSITION	 , &SwNumPositionTabPage::Create, 0);
//STRIP001 	AddTabPage(TP_OUTLINE_NUM	 , &SwOutlineSettingsTabPage::Create, 0);
//STRIP001 
//STRIP001 	String sHeadline;
//STRIP001 	for(USHORT i = 0; i < MAXLEVEL; ++i )
//STRIP001 	{
//STRIP001 		// wurde die Vorlage noch nicht angelegt, dann ist sie noch an dieserPosition
//STRIP001 		if( !rWrtSh.GetParaStyle( sHeadline =
//STRIP001 			SwStyleNameMapper::GetUIName( RES_POOLCOLL_HEADLINE1 + i,
//STRIP001 													sHeadline )) )
//STRIP001 			aCollNames[i] = sHeadline;
//STRIP001 	}
//STRIP001 
//STRIP001 	// Erfragen der Gliederungsebenen der Textvorlagen
//STRIP001 	const USHORT nCount = rWrtSh.GetTxtFmtCollCount();
//STRIP001 	for(i = 0; i < nCount; ++i )
//STRIP001 	{
//STRIP001 		SwTxtFmtColl &rTxtColl = rWrtSh.GetTxtFmtColl(i);
//STRIP001 		if(!rTxtColl.IsDefault())
//STRIP001 		{
//STRIP001 			BYTE nOutLevel = rTxtColl.GetOutlineLevel();
//STRIP001 			if(nOutLevel != NO_NUMBERING)
//STRIP001 				aCollNames[ nOutLevel ] = rTxtColl.GetName();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /* -----------------07.07.98 14:13-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 SwOutlineTabDialog::~SwOutlineTabDialog()
//STRIP001 {
//STRIP001 	delete pNumRule;
//STRIP001 }
//STRIP001 
//STRIP001 /* -----------------07.07.98 14:13-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 void 	SwOutlineTabDialog::PageCreated(USHORT nPageId, SfxTabPage& rPage)
//STRIP001 {
//STRIP001 	switch ( nPageId )
//STRIP001 	{
//STRIP001 		case TP_NUM_POSITION:
//STRIP001 				((SwNumPositionTabPage&)rPage).SetWrtShell(&rWrtSh);
//STRIP001 				((SwNumPositionTabPage&)rPage).SetOutlineTabDialog(this);
//STRIP001 		break;
//STRIP001 		case TP_OUTLINE_NUM:
//STRIP001 				((SwOutlineSettingsTabPage&)rPage).SetWrtShell(&rWrtSh);
//STRIP001 		break;
//STRIP001 	}
//STRIP001 }
//STRIP001 /* -----------------07.07.98 14:19-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 IMPL_LINK( SwOutlineTabDialog, CancelHdl, Button *, pBtn )
//STRIP001 {
//STRIP001 	if (!bModified)
//STRIP001 		rWrtSh.ResetModified();
//STRIP001 	EndDialog(RET_CANCEL);
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 /* -----------------08.07.98 12:14-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 IMPL_LINK( SwOutlineTabDialog, FormHdl, Button *, pBtn )
//STRIP001 {
//STRIP001 	//PopupMenu auffuellen
//STRIP001 	for( USHORT i = 0; i < SwChapterNumRules::nMaxRules; ++i )
//STRIP001 	{
//STRIP001 		const SwNumRulesWithName *pRules = pChapterNumRules->GetRules(i);
//STRIP001 		if( pRules )
//STRIP001 			aFormMenu.SetItemText(i + MN_FORMBASE, pRules->GetName());
//STRIP001 	}
//STRIP001 	aFormMenu.SetSelectHdl(LINK(this, SwOutlineTabDialog, MenuSelectHdl));
//STRIP001 	aFormMenu.Execute(pBtn, Rectangle(Point(0,0), pBtn->GetSizePixel()), POPUPMENU_EXECUTE_DOWN);
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 /* -----------------08.07.98 12:14-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 IMPL_LINK( SwOutlineTabDialog, MenuSelectHdl, Menu *, pMenu )
//STRIP001 {
//STRIP001 	BYTE nLevelNo = 0;
//STRIP001 	switch(pMenu->GetCurItemId())
//STRIP001 	{
//STRIP001 		case MN_FORM1: nLevelNo = 1;	break;
//STRIP001 		case MN_FORM2: nLevelNo = 2;	break;
//STRIP001 		case MN_FORM3: nLevelNo = 3;	break;
//STRIP001 		case MN_FORM4: nLevelNo = 4;	break;
//STRIP001 		case MN_FORM5: nLevelNo = 5;	break;
//STRIP001 		case MN_FORM6: nLevelNo = 6;	break;
//STRIP001 		case MN_FORM7: nLevelNo = 7;	break;
//STRIP001 		case MN_FORM8: nLevelNo = 8;	break;
//STRIP001 		case MN_FORM9: nLevelNo = 9;	break;
//STRIP001 
//STRIP001 		case MN_SAVE:
//STRIP001 		{
//STRIP001 			SwNumNamesDlg *pDlg = new SwNumNamesDlg(this);
//STRIP001 			const String *aStrArr[SwChapterNumRules::nMaxRules];
//STRIP001 			for(USHORT i = 0; i < SwChapterNumRules::nMaxRules; ++i)
//STRIP001 			{
//STRIP001 				const SwNumRulesWithName *pRules = pChapterNumRules->GetRules(i);
//STRIP001 				if(pRules)
//STRIP001 					aStrArr[i] = &pRules->GetName();
//STRIP001 				else
//STRIP001 					aStrArr[i] = 0;
//STRIP001 			}
//STRIP001 			pDlg->SetUserNames(aStrArr);
//STRIP001 			if(RET_OK == pDlg->Execute())
//STRIP001 			{
//STRIP001 				const String aName(pDlg->GetName());
//STRIP001 				pChapterNumRules->ApplyNumRules( SwNumRulesWithName(
//STRIP001 						*pNumRule, aName ), pDlg->GetCurEntryPos() );
//STRIP001 				pMenu->SetItemText(
//STRIP001 						pDlg->GetCurEntryPos() + MN_FORMBASE, aName);
//STRIP001 			}
//STRIP001 			delete pDlg;
//STRIP001 			return 0;
//STRIP001 
//STRIP001 		}
//STRIP001 
//STRIP001 	}
//STRIP001 	if( nLevelNo-- )
//STRIP001 	{
//STRIP001 		const SwNumRulesWithName *pRules = pChapterNumRules->GetRules( nLevelNo );
//STRIP001 		if( pRules )
//STRIP001 		{
//STRIP001 			pRules->MakeNumRule( rWrtSh, *pNumRule );
//STRIP001 			pNumRule->SetRuleType( OUTLINE_RULE );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			*pNumRule = *rWrtSh.GetOutlineNumRule();
//STRIP001 	}
//STRIP001 
//STRIP001 	USHORT	nPageId = GetCurPageId();
//STRIP001 	SfxTabPage*	pPage = GetTabPage( nPageId );
//STRIP001 	pPage->Reset(*GetOutputItemSet());
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 /* -----------------07.07.98 14:19-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 USHORT 	SwOutlineTabDialog::GetLevel(const String &rFmtName) const
//STRIP001 {
//STRIP001 	for(USHORT i = 0; i < MAXLEVEL; ++i)
//STRIP001 	{
//STRIP001 		if(aCollNames[i] == rFmtName)
//STRIP001 			return i;
//STRIP001 	}
//STRIP001 	return NO_NUMBERING;
//STRIP001 }
//STRIP001 /* -----------------07.07.98 16:30-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 short SwOutlineTabDialog::Ok()
//STRIP001 {
//STRIP001 	short nRet = SfxTabDialog::Ok();
//STRIP001 	// bei allen erzeugten Vorlagen die Ebenen setzen, muss
//STRIP001 	// geschehen, um evtl. aufgehobene Zuordnungen
//STRIP001 	// auch wieder zu loeschen
//STRIP001 	USHORT i, nCount = rWrtSh.GetTxtFmtCollCount();
//STRIP001 	for( i = 0; i < nCount; ++i )
//STRIP001 	{
//STRIP001 		SwTxtFmtColl &rTxtColl = rWrtSh.GetTxtFmtColl(i);
//STRIP001 		if( !rTxtColl.IsDefault() )
//STRIP001 			rTxtColl.SetOutlineLevel( (BYTE)GetLevel(rTxtColl.GetName()));
//STRIP001 	}
//STRIP001 
//STRIP001 	for( i = 0; i < MAXLEVEL; ++i )
//STRIP001     {
//STRIP001         String sHeadline;
//STRIP001         ::SwStyleNameMapper::FillUIName( RES_POOLCOLL_HEADLINE1 + i, sHeadline );
//STRIP001         SwTxtFmtColl* pColl = rWrtSh.FindTxtFmtCollByName( sHeadline );
//STRIP001         if( !pColl )
//STRIP001         {
//STRIP001             if( !aCollNames[i].Len() )
//STRIP001             {
//STRIP001                 SwTxtFmtColl* pTxtColl = rWrtSh.GetTxtCollFromPool(
//STRIP001                                                     RES_POOLCOLL_HEADLINE1 + i );
//STRIP001                 pTxtColl->SetOutlineLevel( NO_NUMBERING );
//STRIP001             }
//STRIP001             else if(aCollNames[i] != sHeadline)
//STRIP001             {
//STRIP001                 SwTxtFmtColl* pTxtColl = rWrtSh.GetParaStyle(
//STRIP001                                 aCollNames[i], SwWrtShell::GETSTYLE_CREATESOME);
//STRIP001                 if(pTxtColl)
//STRIP001                     pTxtColl->SetOutlineLevel( (BYTE)i );
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001 	rWrtSh.SetOutlineNumRule( *pNumRule );
//STRIP001 	return RET_OK;
//STRIP001 }
//STRIP001 
//STRIP001 /* -----------------07.07.98 14:19-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 SwOutlineSettingsTabPage::SwOutlineSettingsTabPage(Window* pParent, const SfxItemSet& rSet) :
//STRIP001 	SfxTabPage(pParent, SW_RES(TP_OUTLINE_NUM), rSet),
//STRIP001     aLevelFL(       this, ResId(FL_LEVEL    )),
//STRIP001 	aLevelLB(		this, ResId(LB_LEVEL	)),
//STRIP001 	aPreviewWIN(	this, ResId(WIN_PREVIEW	)),
//STRIP001 	aCollLbl(this, SW_RES(FT_COLL)),
//STRIP001 	aCollBox(this, SW_RES(LB_COLL)),
//STRIP001 	aNumberLbl(this, SW_RES(FT_NUMBER)),
//STRIP001     aNumberBox(this, SW_RES(LB_NUMBER), INSERT_NUM_TYPE_NO_NUMBERING|INSERT_NUM_EXTENDED_TYPES),
//STRIP001 	aCharFmtFT(this, SW_RES(FT_CHARFMT)),
//STRIP001 	aCharFmtLB(this, SW_RES(LB_CHARFMT)),
//STRIP001 	aAllLevelFT(	this, ResId(FT_ALL_LEVEL)),
//STRIP001 	aAllLevelNF(	this, ResId(NF_ALL_LEVEL)),
//STRIP001 	aDelim(this, SW_RES(FT_DELIM)),
//STRIP001 	aPrefixFT(this, SW_RES(FT_PREFIX)),
//STRIP001 	aPrefixED(this, SW_RES(ED_PREFIX)),
//STRIP001 	aSuffixFT(this, SW_RES(FT_SUFFIX)),
//STRIP001 	aSuffixED(this, SW_RES(ED_SUFFIX)),
//STRIP001 	aStartLbl(this, SW_RES(FT_START)),
//STRIP001 	aStartEdit(this, SW_RES(ED_START)),
//STRIP001     aNumberFL(this, SW_RES(FL_NUMBER)),
//STRIP001 	aNoFmtName(SW_RES(ST_NO_COLL)),
//STRIP001 	nActLevel(1),
//STRIP001 	pCollNames(0),
//STRIP001 	pSh(0)
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 	SetExchangeSupport();
//STRIP001 
//STRIP001 	aCollBox.InsertEntry(aNoFmtName);
//STRIP001 	aLevelLB.SetSelectHdl(LINK(this, 	SwOutlineSettingsTabPage, LevelHdl));
//STRIP001 	aAllLevelNF.SetModifyHdl(LINK(this, SwOutlineSettingsTabPage, ToggleComplete));
//STRIP001 	aCollBox.SetSelectHdl(LINK(this, 	SwOutlineSettingsTabPage, CollSelect));
//STRIP001 	aCollBox.SetGetFocusHdl(LINK(this, 	SwOutlineSettingsTabPage, CollSelectGetFocus));
//STRIP001 	aNumberBox.SetSelectHdl(LINK(this, 	SwOutlineSettingsTabPage, NumberSelect));
//STRIP001 	aPrefixED.SetModifyHdl(LINK(this, 	SwOutlineSettingsTabPage, DelimModify));
//STRIP001 	aSuffixED.SetModifyHdl(LINK(this, 	SwOutlineSettingsTabPage, DelimModify));
//STRIP001 	aStartEdit.SetModifyHdl(LINK(this, 	SwOutlineSettingsTabPage, StartModified));
//STRIP001 	aCharFmtLB.SetSelectHdl(LINK(this, 	SwOutlineSettingsTabPage, CharFmtHdl));
//STRIP001 
//STRIP001 }
//STRIP001 /* -----------------07.07.98 14:19-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 void   	SwOutlineSettingsTabPage::Update()
//STRIP001 {
//STRIP001 		// falls eine Vorlage fuer diese Ebene bereits selektiert wurde,
//STRIP001 		// diese in der ListBox auswaehlean
//STRIP001 	aCollBox.Enable(USHRT_MAX != nActLevel);
//STRIP001 	if(USHRT_MAX == nActLevel)
//STRIP001 	{
//STRIP001 		BOOL bSamePrefix = TRUE;
//STRIP001 		BOOL bSameSuffix = TRUE;
//STRIP001 		BOOL bSameType = TRUE;
//STRIP001 		BOOL bSameComplete = TRUE;
//STRIP001 		BOOL bSameStart = TRUE;
//STRIP001 		BOOL bSameCharFmt = TRUE;
//STRIP001 
//STRIP001 		const SwNumFmt* aNumFmtArr[MAXLEVEL];
//STRIP001 		const SwCharFmt* pFirstFmt = 0;
//STRIP001 
//STRIP001 		for(USHORT i = 0; i < MAXLEVEL; i++)
//STRIP001 		{
//STRIP001 
//STRIP001 			aNumFmtArr[ i ] = &pNumRule->Get(i);
//STRIP001 			if(i == 0)
//STRIP001 				pFirstFmt = aNumFmtArr[i]->GetCharFmt();
//STRIP001 			else
//STRIP001 			{
//STRIP001 				bSameType 	&= aNumFmtArr[i]->GetNumberingType() == aNumFmtArr[0]->GetNumberingType();
//STRIP001 				bSameStart	&= aNumFmtArr[i]->GetStart() == aNumFmtArr[0]->GetStart();
//STRIP001 				bSamePrefix &= aNumFmtArr[i]->GetPrefix() == aNumFmtArr[0]->GetPrefix();
//STRIP001 				bSameSuffix &= aNumFmtArr[i]->GetSuffix() == aNumFmtArr[0]->GetSuffix();
//STRIP001 				bSameComplete &= aNumFmtArr[i]->GetIncludeUpperLevels() == aNumFmtArr[0]->GetIncludeUpperLevels();
//STRIP001 				const SwCharFmt* pFmt = aNumFmtArr[i]->GetCharFmt();
//STRIP001 				bSameCharFmt &= 	!pFirstFmt && !pFmt
//STRIP001 									|| pFirstFmt && pFmt && pFmt->GetName() == pFirstFmt->GetName();
//STRIP001 			}
//STRIP001 		}
//STRIP001         CheckForStartValue_Impl(aNumFmtArr[0]->GetNumberingType());
//STRIP001         if(bSameType)
//STRIP001 			aNumberBox.SelectNumberingType( aNumFmtArr[0]->GetNumberingType() );
//STRIP001 		else
//STRIP001 			aNumberBox.SetNoSelection();
//STRIP001 		if(bSameStart)
//STRIP001 			aStartEdit.SetValue(aNumFmtArr[0]->GetStart());
//STRIP001 		else
//STRIP001 			aStartEdit.SetText(aEmptyStr);
//STRIP001 		if(bSamePrefix)
//STRIP001 			aPrefixED.SetText(aNumFmtArr[0]->GetPrefix());
//STRIP001 		else
//STRIP001 			aPrefixED.SetText(aEmptyStr);
//STRIP001 		if(bSameSuffix)
//STRIP001 			aSuffixED.SetText(aNumFmtArr[0]->GetSuffix());
//STRIP001 		else
//STRIP001 			aSuffixED.SetText(aEmptyStr);
//STRIP001 
//STRIP001 		if(bSameCharFmt)
//STRIP001 		{
//STRIP001 			if(pFirstFmt)
//STRIP001 				aCharFmtLB.SelectEntry(pFirstFmt->GetName());
//STRIP001 			else
//STRIP001 				aCharFmtLB.SelectEntry( ViewShell::GetShellRes()->aStrNone );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aCharFmtLB.SetNoSelection();
//STRIP001 
//STRIP001 		aAllLevelFT.Enable(TRUE);
//STRIP001 		aAllLevelNF.Enable(TRUE);
//STRIP001 		aAllLevelNF.SetMax(MAXLEVEL);
//STRIP001 		if(bSameComplete)
//STRIP001 		{
//STRIP001 			aAllLevelNF.SetValue(aNumFmtArr[0]->GetIncludeUpperLevels());
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aAllLevelNF.SetText(aEmptyStr);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		USHORT nTmpLevel = lcl_BitToLevel(nActLevel);
//STRIP001 		String aColl(pCollNames[nTmpLevel]);
//STRIP001 		if(aColl.Len())
//STRIP001 			aCollBox.SelectEntry(aColl);
//STRIP001 		else
//STRIP001 			aCollBox.SelectEntry(aNoFmtName);
//STRIP001 		const SwNumFmt &rFmt = pNumRule->Get(nTmpLevel);
//STRIP001 
//STRIP001 		aNumberBox.SelectNumberingType( rFmt.GetNumberingType() );
//STRIP001 		aPrefixED.SetText(rFmt.GetPrefix());
//STRIP001 		aSuffixED.SetText(rFmt.GetSuffix());
//STRIP001 		const SwCharFmt* pFmt = rFmt.GetCharFmt();
//STRIP001 		if(pFmt)
//STRIP001 			aCharFmtLB.SelectEntry(pFmt->GetName());
//STRIP001 		else
//STRIP001 			aCharFmtLB.SelectEntry( ViewShell::GetShellRes()->aStrNone );
//STRIP001 
//STRIP001 		if(nTmpLevel)
//STRIP001 		{
//STRIP001 			aAllLevelFT.Enable(TRUE);
//STRIP001 			aAllLevelNF.Enable(TRUE);
//STRIP001 			aAllLevelNF.SetMax(nTmpLevel + 1);
//STRIP001 			aAllLevelNF.SetValue(rFmt.GetIncludeUpperLevels());
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aAllLevelNF.SetText(aEmptyStr);
//STRIP001 			aAllLevelNF.Enable(FALSE);
//STRIP001 			aAllLevelFT.Enable(FALSE);
//STRIP001 		}
//STRIP001         CheckForStartValue_Impl(rFmt.GetNumberingType());
//STRIP001 		aStartEdit.SetValue( rFmt.GetStart() );
//STRIP001 	}
//STRIP001 	SetModified();
//STRIP001 }
//STRIP001 
//STRIP001 /* -----------------07.07.98 14:19-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 IMPL_LINK( SwOutlineSettingsTabPage, LevelHdl, ListBox *, pBox )
//STRIP001 {
//STRIP001 	nActLevel = 0;
//STRIP001 	if(pBox->IsEntryPosSelected( MAXLEVEL ))
//STRIP001 	{
//STRIP001 		nActLevel = 0xFFFF;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		USHORT nMask = 1;
//STRIP001 		for( USHORT i = 0; i < MAXLEVEL; i++ )
//STRIP001 		{
//STRIP001 			if(pBox->IsEntryPosSelected( i ))
//STRIP001 				nActLevel |= nMask;
//STRIP001 			nMask <<= 1;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	Update();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 /* -----------------07.07.98 14:19-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 IMPL_LINK( SwOutlineSettingsTabPage, ToggleComplete, NumericField *, pFld )
//STRIP001 {
//STRIP001 	USHORT nStart = 0;
//STRIP001 	USHORT nEnd = MAXLEVEL;
//STRIP001 	USHORT nMask = 1;
//STRIP001 	for(USHORT i = 0; i < MAXLEVEL; i++)
//STRIP001 	{
//STRIP001 		if(nActLevel & nMask)
//STRIP001 		{
//STRIP001 			SwNumFmt aNumFmt(pNumRule->Get(i));
//STRIP001 			aNumFmt.SetIncludeUpperLevels( Min( (BYTE)pFld->GetValue(),
//STRIP001 												(BYTE)(i + 1)) );
//STRIP001 			pNumRule->Set(i, aNumFmt);
//STRIP001 		}
//STRIP001 		nMask <<= 1;
//STRIP001 	}
//STRIP001 	SetModified();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 /* -----------------07.07.98 14:19-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 IMPL_LINK( SwOutlineSettingsTabPage, CollSelect, ListBox *, pBox )
//STRIP001 {
//STRIP001 	BYTE i;
//STRIP001 
//STRIP001 	const String aCollName(pBox->GetSelectEntry());
//STRIP001 	//0xFFFF darf hier nicht sein (disable)
//STRIP001 	USHORT nTmp = nActLevel;
//STRIP001 	USHORT nTmpLevel = lcl_BitToLevel(nActLevel);
//STRIP001 	String sOldName( pCollNames[nTmpLevel] );
//STRIP001 
//STRIP001 	for( i = 0; i < MAXLEVEL; ++i)
//STRIP001 		pCollNames[i] = aSaveCollNames[i];
//STRIP001 
//STRIP001 	if(aCollName == aNoFmtName)
//STRIP001 		pCollNames[nTmpLevel] = aEmptyStr;
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pCollNames[nTmpLevel] = aCollName;
//STRIP001 				// wird die Vorlage bereits verwendet ?
//STRIP001 		for( i = 0; i < MAXLEVEL; ++i)
//STRIP001 			if(i != nTmpLevel && pCollNames[i] == aCollName )
//STRIP001 				pCollNames[i] = aEmptyStr;
//STRIP001 	}
//STRIP001 
//STRIP001 	// search the oldname and put it into the current entries
//STRIP001 	if( sOldName.Len() )
//STRIP001 		for( i = 0; i < MAXLEVEL; ++i)
//STRIP001 			if( aSaveCollNames[ i ] == sOldName && i != nTmpLevel &&
//STRIP001 				!pCollNames[ i ].Len() )
//STRIP001 			{
//STRIP001 				BYTE n;
//STRIP001 				for( n = 0; n < MAXLEVEL; ++n )
//STRIP001 					if( pCollNames[ n ] == sOldName )
//STRIP001 						break;
//STRIP001 
//STRIP001 				if( MAXLEVEL == n )
//STRIP001 					// it was a outline leveld name and the current entries is zero.
//STRIP001 					pCollNames[ i ] = sOldName;
//STRIP001 			}
//STRIP001 
//STRIP001 	SetModified();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK( SwOutlineSettingsTabPage, CollSelectGetFocus, ListBox *, pBox )
//STRIP001 {
//STRIP001 	for( BYTE i = 0; i < MAXLEVEL; ++i)
//STRIP001 		aSaveCollNames[i] =  pCollNames[i];
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 /* -----------------07.07.98 14:19-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 IMPL_LINK( SwOutlineSettingsTabPage, NumberSelect, SwNumberingTypeListBox *, pBox )
//STRIP001 {
//STRIP001 	USHORT nStart = 0;
//STRIP001 	USHORT nEnd = MAXLEVEL;
//STRIP001 	USHORT nMask = 1;
//STRIP001 	sal_Int16 nNumberType = pBox->GetSelectedNumberingType();//(sal_Int16)(ULONG)pBox->GetEntryData(pBox->GetSelectEntryPos());
//STRIP001 	for(USHORT i = 0; i < MAXLEVEL; i++)
//STRIP001 	{
//STRIP001 		if(nActLevel & nMask)
//STRIP001 		{
//STRIP001 			SwNumFmt aNumFmt(pNumRule->Get(i));
//STRIP001 			aNumFmt.SetNumberingType(nNumberType);
//STRIP001 			pNumRule->Set(i, aNumFmt);
//STRIP001             CheckForStartValue_Impl(nNumberType);
//STRIP001         }
//STRIP001 		nMask <<= 1;
//STRIP001 	}
//STRIP001 	SetModified();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 /* -----------------07.07.98 14:19-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 IMPL_LINK( SwOutlineSettingsTabPage, DelimModify, Edit *, pEdt )
//STRIP001 {
//STRIP001 	USHORT nStart = 0;
//STRIP001 	USHORT nEnd = MAXLEVEL;
//STRIP001 	USHORT nMask = 1;
//STRIP001 	for(USHORT i = 0; i < MAXLEVEL; i++)
//STRIP001 	{
//STRIP001 		if(nActLevel & nMask)
//STRIP001 		{
//STRIP001 			SwNumFmt aNumFmt(pNumRule->Get(i));
//STRIP001 			aNumFmt.SetPrefix( aPrefixED.GetText() );
//STRIP001 			aNumFmt.SetSuffix( aSuffixED.GetText() );
//STRIP001 			pNumRule->Set(i, aNumFmt);
//STRIP001 		}
//STRIP001 		nMask <<= 1;
//STRIP001 	}
//STRIP001 	SetModified();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 /* -----------------07.07.98 14:19-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 IMPL_LINK( SwOutlineSettingsTabPage, StartModified, NumericField *, pFld )
//STRIP001 {
//STRIP001 	USHORT nStart = 0;
//STRIP001 	USHORT nEnd = MAXLEVEL;
//STRIP001 	USHORT nMask = 1;
//STRIP001 	for(USHORT i = 0; i < MAXLEVEL; i++)
//STRIP001 	{
//STRIP001 		if(nActLevel & nMask)
//STRIP001 		{
//STRIP001 			SwNumFmt aNumFmt(pNumRule->Get(i));
//STRIP001 			aNumFmt.SetStart( (USHORT)pFld->GetValue() );
//STRIP001 			pNumRule->Set(i, aNumFmt);
//STRIP001 		}
//STRIP001 		nMask <<= 1;
//STRIP001 	}
//STRIP001     SetModified();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 /* -----------------21.09.98 12:21-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 IMPL_LINK( SwOutlineSettingsTabPage, CharFmtHdl, ListBox *, EMPTYARG )
//STRIP001 {
//STRIP001 //	bAutomaticCharStyles = FALSE;
//STRIP001 	String sEntry = aCharFmtLB.GetSelectEntry();
//STRIP001 	USHORT nMask = 1;
//STRIP001 	BOOL bFormatNone = sEntry == ViewShell::GetShellRes()->aStrNone;
//STRIP001 	SwCharFmt* pFmt = 0;
//STRIP001 	if(!bFormatNone)
//STRIP001 	{
//STRIP001 		USHORT nChCount = pSh->GetCharFmtCount();
//STRIP001 		for(USHORT i = 0; i < nChCount; i++)
//STRIP001 		{
//STRIP001 			SwCharFmt& rChFmt = pSh->GetCharFmt(i);
//STRIP001 			if(rChFmt.GetName() == sEntry)
//STRIP001 			{
//STRIP001 				pFmt = &rChFmt;
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		if(!pFmt)
//STRIP001 		{
//STRIP001 			SfxStyleSheetBasePool* pPool = pSh->GetView().GetDocShell()->GetStyleSheetPool();
//STRIP001 			SfxStyleSheetBase* pBase;
//STRIP001 			pBase = pPool->Find(sEntry, SFX_STYLE_FAMILY_CHAR);
//STRIP001 			if(!pBase)
//STRIP001 				pBase = &pPool->Make(sEntry, SFX_STYLE_FAMILY_PAGE);
//STRIP001 			pFmt = ((SwDocStyleSheet*)pBase)->GetCharFmt();
//STRIP001 
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	for(USHORT i = 0; i < MAXLEVEL; i++)
//STRIP001 	{
//STRIP001 		if(nActLevel & nMask)
//STRIP001 		{
//STRIP001 			SwNumFmt aNumFmt(pNumRule->Get(i));
//STRIP001 			if(bFormatNone)
//STRIP001 				aNumFmt.SetCharFmt(0);
//STRIP001 			else
//STRIP001 				aNumFmt.SetCharFmt(pFmt);
//STRIP001 			pNumRule->Set(i, aNumFmt);
//STRIP001 		}
//STRIP001 		nMask <<= 1;
//STRIP001 	}
//STRIP001 	return RET_OK;
//STRIP001 }
//STRIP001 /* -----------------07.07.98 14:19-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 SwOutlineSettingsTabPage::~SwOutlineSettingsTabPage()
//STRIP001 {
//STRIP001 }
//STRIP001 /* -----------------07.07.98 16:27-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 void SwOutlineSettingsTabPage::SetWrtShell(SwWrtShell* pShell)
//STRIP001 {
//STRIP001 	pSh = pShell;
//STRIP001 	// Erfragen der NumRules dieses Dokumentes
//STRIP001 	pNumRule = ((SwOutlineTabDialog*)GetTabDialog())->GetNumRule();
//STRIP001 	pCollNames = ((SwOutlineTabDialog*)GetTabDialog())->GetCollNames();
//STRIP001 
//STRIP001 	//pNumRule = new SwNumRule( *rSh.GetOutlineNumRule() );
//STRIP001 
//STRIP001 	aPreviewWIN.SetNumRule(pNumRule);
//STRIP001 	aPreviewWIN.SetOutlineNames(pCollNames);
//STRIP001 	// Startwert setzen - nActLevel muss hier 1 sein
//STRIP001 	USHORT nTmpLevel = lcl_BitToLevel(nActLevel);
//STRIP001 	const SwNumFmt& rNumFmt = pNumRule->Get( nTmpLevel );
//STRIP001 	aStartEdit.SetValue( rNumFmt.GetStart() );
//STRIP001 
//STRIP001 	// Poolformate fuer Ueberschriften anlegen
//STRIP001 	String sStr;
//STRIP001 	USHORT i;
//STRIP001 	for( i = 0; i < MAXLEVEL; ++i )
//STRIP001 	{
//STRIP001 		aCollBox.InsertEntry( SwStyleNameMapper::GetUIName(
//STRIP001 									RES_POOLCOLL_HEADLINE1 + i, aEmptyStr ));
//STRIP001 		aLevelLB.InsertEntry( String::CreateFromInt32(i + 1) );
//STRIP001 	}
//STRIP001 	sStr.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "1 - " ));
//STRIP001 	sStr += String::CreateFromInt32(MAXLEVEL);
//STRIP001 	aLevelLB.InsertEntry( sStr );
//STRIP001 
//STRIP001 	// Erfragen der Gliederungsebenen der Textvorlagen
//STRIP001 	const USHORT nCount = pSh->GetTxtFmtCollCount();
//STRIP001 	for( i = 0; i < nCount; ++i )
//STRIP001 	{
//STRIP001 		SwTxtFmtColl &rTxtColl = pSh->GetTxtFmtColl(i);
//STRIP001 		if(!rTxtColl.IsDefault())
//STRIP001 		{
//STRIP001 			BYTE nOutLevel = rTxtColl.GetOutlineLevel();
//STRIP001 			sStr = rTxtColl.GetName();
//STRIP001 			if(LISTBOX_ENTRY_NOTFOUND == aCollBox.GetEntryPos( sStr ))
//STRIP001 				aCollBox.InsertEntry( sStr );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	aNumberBox.SelectNumberingType(rNumFmt.GetNumberingType());
//STRIP001 	USHORT nOutlinePos = pSh->GetOutlinePos(MAXLEVEL);
//STRIP001 	USHORT nTmp = 0;
//STRIP001 	if(nOutlinePos != USHRT_MAX)
//STRIP001 	{
//STRIP001 		nTmp = pSh->GetOutlineLevel(nOutlinePos);
//STRIP001 	}
//STRIP001 	aLevelLB.SelectEntryPos(nTmp);
//STRIP001 
//STRIP001 	// Zeichenvorlagen sammeln
//STRIP001 	aCharFmtLB.Clear();
//STRIP001 	aCharFmtLB.InsertEntry( ViewShell::GetShellRes()->aStrNone );
//STRIP001 
//STRIP001 	// Zeichenvorlagen
//STRIP001 	::FillCharStyleListBox(aCharFmtLB,
//STRIP001 						pSh->GetView().GetDocShell());
//STRIP001 	Update();
//STRIP001 }
//STRIP001 /* -----------------07.07.98 14:19-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 void 	SwOutlineSettingsTabPage::ActivatePage(const SfxItemSet& rSet)
//STRIP001 {
//STRIP001 	nActLevel = ((SwOutlineTabDialog*)GetTabDialog())->GetActNumLevel();
//STRIP001 	if(nActLevel != USHRT_MAX)
//STRIP001 		aLevelLB.SelectEntryPos(lcl_BitToLevel(nActLevel));
//STRIP001 	else
//STRIP001 		aLevelLB.SelectEntryPos(MAXLEVEL);
//STRIP001 	LevelHdl(&aLevelLB);
//STRIP001 }
//STRIP001 /* -----------------07.07.98 14:19-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 int 	SwOutlineSettingsTabPage::DeactivatePage(SfxItemSet *pSet)
//STRIP001 {
//STRIP001 	((SwOutlineTabDialog*)GetTabDialog())->SetActNumLevel(nActLevel);
//STRIP001 	return LEAVE_PAGE;
//STRIP001 }
//STRIP001 /* -----------------07.07.98 14:19-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 BOOL 	SwOutlineSettingsTabPage::FillItemSet( SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 /* -----------------07.07.98 14:19-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 void 	SwOutlineSettingsTabPage::Reset( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	ActivatePage(rSet);
//STRIP001 }
//STRIP001 /* -----------------07.07.98 14:19-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 SfxTabPage*	SwOutlineSettingsTabPage::Create( Window* pParent,
//STRIP001 								const SfxItemSet& rAttrSet)
//STRIP001 {
//STRIP001 	return new SwOutlineSettingsTabPage(pParent, rAttrSet);
//STRIP001 }
//STRIP001 /* -----------------07.11.2002 15:13-----------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 void SwOutlineSettingsTabPage::CheckForStartValue_Impl(sal_uInt16 nNumberingType)
//STRIP001 {
//STRIP001     BOOL bIsNull = aStartEdit.GetValue() == 0;
//STRIP001     BOOL bNoZeroAllowed = nNumberingType < SVX_NUM_ARABIC ||
//STRIP001                         SVX_NUM_CHARS_UPPER_LETTER_N == nNumberingType ||
//STRIP001                         SVX_NUM_CHARS_LOWER_LETTER_N == nNumberingType;
//STRIP001     aStartEdit.SetMin(bNoZeroAllowed ? 1 : 0);
//STRIP001     if(bIsNull && bNoZeroAllowed)
//STRIP001         aStartEdit.GetModifyHdl().Call(&aStartEdit);
//STRIP001 }
//STRIP001 /*-----------------09.12.97 11:54-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 USHORT lcl_DrawBullet(VirtualDevice* pVDev,
//STRIP001 			const SwNumFmt& rFmt, USHORT nXStart,
//STRIP001 			USHORT nYStart, const Size& rSize)
//STRIP001 {
//STRIP001 	Font aTmpFont(pVDev->GetFont());
//STRIP001 
//STRIP001 	Font aFont(*rFmt.GetBulletFont());
//STRIP001 	aFont.SetSize(rSize);
//STRIP001 	aFont.SetTransparent(TRUE);
//STRIP001 	pVDev->SetFont( aFont );
//STRIP001 	String aText(rFmt.GetBulletChar());
//STRIP001 	pVDev->DrawText( Point(nXStart, nYStart), aText );
//STRIP001 	USHORT nRet = (USHORT)pVDev->GetTextWidth(aText);
//STRIP001 
//STRIP001 	pVDev->SetFont(aTmpFont);
//STRIP001 	return nRet;
//STRIP001 }
//STRIP001 /*-----------------09.12.97 11:49-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 USHORT lcl_DrawGraphic(VirtualDevice* pVDev, const SwNumFmt &rFmt, USHORT nXStart,
//STRIP001 						USHORT nYStart, USHORT nDivision)
//STRIP001 {
//STRIP001 	const SvxBrushItem* pBrushItem = rFmt.GetBrush();
//STRIP001 	USHORT nRet = 0;
//STRIP001 	if(pBrushItem)
//STRIP001 	{
//STRIP001 		const Graphic* pGrf = pBrushItem->GetGraphic();
//STRIP001 		if(pGrf)
//STRIP001 		{
//STRIP001 			Size aGSize( rFmt.GetGraphicSize());
//STRIP001 			aGSize.Width() /= nDivision;
//STRIP001 			nRet = (USHORT)aGSize.Width();
//STRIP001 			aGSize.Height() /= nDivision;
//STRIP001 			pGrf->Draw( pVDev, Point(nXStart,nYStart),
//STRIP001 					pVDev->PixelToLogic( aGSize ) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return nRet;
//STRIP001 
//STRIP001 }
//STRIP001 /*-----------------02.12.97 10:34-------------------
//STRIP001 	Vorschau der Numerierung painten
//STRIP001 --------------------------------------------------*/
//STRIP001 void	NumberingPreview::Paint( const Rectangle& rRect )
//STRIP001 {
//STRIP001 	Size aSize(PixelToLogic(GetOutputSizePixel()));
//STRIP001 	Rectangle aRect(Point(0,0), aSize);
//STRIP001 
//STRIP001 	VirtualDevice* pVDev = new VirtualDevice(*this);
//STRIP001 	pVDev->SetMapMode(GetMapMode());
//STRIP001 	pVDev->SetOutputSize( aSize );
//STRIP001 
//STRIP001 	// #101524# OJ
//STRIP001 	pVDev->SetFillColor( GetSettings().GetStyleSettings().GetWindowColor() );
//STRIP001 	pVDev->SetLineColor( GetSettings().GetStyleSettings().GetButtonTextColor() );
//STRIP001 	pVDev->DrawRect(aRect);
//STRIP001 
//STRIP001 	if(pActNum)
//STRIP001 	{
//STRIP001 		USHORT nWidthRelation;
//STRIP001 		if(nPageWidth)
//STRIP001 		{
//STRIP001 			nWidthRelation = USHORT (nPageWidth / aSize.Width());
//STRIP001 			if(bPosition)
//STRIP001 				nWidthRelation = nWidthRelation * 2 / 3;
//STRIP001 			else
//STRIP001 				nWidthRelation = nWidthRelation / 4;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			nWidthRelation = 30; // Kapiteldialog
//STRIP001 
//STRIP001 		//Hoehe pro Ebene
//STRIP001 		USHORT nXStep = aSize.Width() / (3 * MAXLEVEL);
//STRIP001 		if(MAXLEVEL < 10)
//STRIP001 			nXStep /= 2;
//STRIP001 		USHORT nYStart = 4;
//STRIP001 		USHORT nYStep = (aSize.Height() - 6)/ MAXLEVEL;
//STRIP001         aStdFont = OutputDevice::GetDefaultFont(
//STRIP001 					                DEFAULTFONT_UI_SANS, GetAppLanguage(),
//STRIP001 									DEFAULTFONT_FLAGS_ONLYONE, this );
//STRIP001 		// #101524# OJ
//STRIP001         aStdFont.SetColor( SwViewOption::GetFontColor() );
//STRIP001 
//STRIP001 		//
//STRIP001 		USHORT nFontHeight = nYStep * 6 / 10;
//STRIP001 		if(bPosition)
//STRIP001 			nFontHeight = nYStep * 15 / 10;
//STRIP001 		aStdFont.SetSize(Size( 0, nFontHeight ));
//STRIP001 
//STRIP001 		SwNodeNum aNum( (BYTE)0 );
//STRIP001 		USHORT nPreNum = pActNum->Get(0).GetStart();
//STRIP001 
//STRIP001 		if(bPosition)
//STRIP001 		{
//STRIP001 			USHORT nLineHeight = nFontHeight * 8 / 7;
//STRIP001 			BYTE nStart = 0;
//STRIP001 			while( !(nActLevel & (1<<nStart)) )
//STRIP001 			{
//STRIP001 				nStart++;
//STRIP001 			}
//STRIP001 			if(nStart) // damit moeglichs Vorgaenger und Nachfolger gezeigt werden
//STRIP001 				nStart--;
//STRIP001 			BYTE nEnd = Min( (BYTE)(nStart + 3), MAXLEVEL );
//STRIP001 			for( BYTE nLevel = nStart; nLevel < nEnd; ++nLevel )
//STRIP001 			{
//STRIP001 				const SwNumFmt &rFmt = pActNum->Get(nLevel);
//STRIP001 				aNum.GetLevelVal()[ nLevel ] = rFmt.GetStart();
//STRIP001 				USHORT nXStart = rFmt.GetAbsLSpace() / nWidthRelation;
//STRIP001 				USHORT nTextOffset = rFmt.GetCharTextDistance() / nWidthRelation;
//STRIP001 				USHORT nNumberXPos = nXStart;
//STRIP001 				USHORT nFirstLineOffset = (-rFmt.GetFirstLineOffset()) / nWidthRelation;
//STRIP001 
//STRIP001 				if(nFirstLineOffset <= nNumberXPos)
//STRIP001 					nNumberXPos -= nFirstLineOffset;
//STRIP001 				else
//STRIP001 					nNumberXPos = 0;
//STRIP001 
//STRIP001 				USHORT nBulletWidth = 0;
//STRIP001 				if( SVX_NUM_BITMAP == rFmt.GetNumberingType() )
//STRIP001 				{
//STRIP001 					nBulletWidth = lcl_DrawGraphic(pVDev, rFmt,
//STRIP001 										nNumberXPos,
//STRIP001 											nYStart, nWidthRelation);
//STRIP001 				}
//STRIP001 				else if( SVX_NUM_CHAR_SPECIAL == rFmt.GetNumberingType() )
//STRIP001 				{
//STRIP001 					nBulletWidth =  lcl_DrawBullet(pVDev, rFmt, nNumberXPos, nYStart, aStdFont.GetSize());
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					pVDev->SetFont(aStdFont);
//STRIP001 					aNum.SetLevel( nLevel );
//STRIP001 					if(pActNum->IsContinusNum())
//STRIP001 						aNum.GetLevelVal()[nLevel] = nPreNum;
//STRIP001 					String aText(pActNum->MakeNumString( aNum ));
//STRIP001 					pVDev->DrawText( Point(nNumberXPos, nYStart), aText );
//STRIP001 					nBulletWidth = (USHORT)pVDev->GetTextWidth(aText);
//STRIP001 					nPreNum++;
//STRIP001 				}
//STRIP001 				USHORT nTextXPos = nXStart;
//STRIP001 				if(nNumberXPos + nBulletWidth + nTextOffset > nTextXPos )
//STRIP001 					nTextXPos = nNumberXPos + nBulletWidth + nTextOffset;
//STRIP001 				Rectangle aRect1(Point(nTextXPos, nYStart + nFontHeight / 2), Size(aSize.Width() / 2, 2));
//STRIP001 				pVDev->SetFillColor( GetSettings().GetStyleSettings().GetWindowColor() ); // Color( COL_BLACK ) );
//STRIP001 				pVDev->DrawRect( aRect1 );
//STRIP001 
//STRIP001 				Rectangle aRect2(Point(nXStart, nYStart + nLineHeight + nFontHeight / 2 ), Size(aSize.Width() / 2, 2));
//STRIP001 				pVDev->DrawRect( aRect2 );
//STRIP001 				nYStart += 2 * nLineHeight;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			USHORT nLineHeight = nFontHeight * 3 / 2;
//STRIP001 			for( BYTE nLevel = 0; nLevel < MAXLEVEL;
//STRIP001 							++nLevel, nYStart += nYStep )
//STRIP001 			{
//STRIP001 				const SwNumFmt &rFmt = pActNum->Get(nLevel);
//STRIP001 				aNum.GetLevelVal()[ nLevel ] = rFmt.GetStart();
//STRIP001 				USHORT nXStart = (rFmt.GetAbsLSpace() / nWidthRelation) / 2 + 2;
//STRIP001 				USHORT nTextOffset = 2 * nXStep;
//STRIP001 				if( SVX_NUM_BITMAP == rFmt.GetNumberingType() )
//STRIP001 				{
//STRIP001 					lcl_DrawGraphic(pVDev, rFmt, nXStart, nYStart, nWidthRelation);
//STRIP001 					nTextOffset = nLineHeight + nXStep;
//STRIP001 				}
//STRIP001 				else if( SVX_NUM_CHAR_SPECIAL == rFmt.GetNumberingType() )
//STRIP001 				{
//STRIP001 					nTextOffset =  lcl_DrawBullet(pVDev, rFmt, nXStart, nYStart, aStdFont.GetSize());
//STRIP001 					nTextOffset += nXStep;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					pVDev->SetFont(aStdFont);
//STRIP001 					aNum.SetLevel( nLevel );
//STRIP001 					if(pActNum->IsContinusNum())
//STRIP001 						aNum.GetLevelVal()[nLevel] = nPreNum;
//STRIP001 					String aText(pActNum->MakeNumString( aNum ));
//STRIP001 					pVDev->DrawText( Point(nXStart, nYStart), aText );
//STRIP001 					nTextOffset = (USHORT)pVDev->GetTextWidth(aText);
//STRIP001 					nTextOffset += nXStep;
//STRIP001 					nPreNum++;
//STRIP001 				}
//STRIP001 				pVDev->SetFont(aStdFont);
//STRIP001 
//STRIP001 				// Changed as per BugID 79541 Branding/Configuration
//STRIP001 				::utl::ConfigManager* pMgr = ::utl::ConfigManager::GetConfigManager();
//STRIP001 				UNOANY MyAny = pMgr->GetDirectConfigProperty( ::utl::ConfigManager::PRODUCTNAME );
//STRIP001 				UNOOUSTRING aProductName;
//STRIP001 
//STRIP001 				MyAny >>= aProductName;
//STRIP001 				String sMsg(C2S("%PRODUCTNAME"));
//STRIP001 				sMsg.SearchAndReplaceAscii( "%PRODUCTNAME" , aProductName );
//STRIP001 
//STRIP001 				if(pOutlineNames)
//STRIP001 					sMsg = pOutlineNames[nLevel];
//STRIP001 				pVDev->DrawText( Point(nXStart + nTextOffset, nYStart), sMsg );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	DrawOutDev(	Point(0,0), aSize,
//STRIP001 				Point(0,0), aSize,
//STRIP001 						*pVDev );
//STRIP001 	delete pVDev;
//STRIP001 
//STRIP001 }
//STRIP001 
//STRIP001 /*-----------------02.12.97 10:34-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 NumberingPreview::~NumberingPreview()
//STRIP001 {
//STRIP001 }


}
