/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_tabview2.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:35:37 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

// auto strip #include "scitems.hxx"
// auto strip #include <bf_svx/eeitem.hxx>
#define ITEMID_FIELD EE_FEATURE_FIELD

// auto strip #include <vcl/timer.hxx>
// auto strip #include <vcl/msgbox.hxx>
// auto strip #include <bf_sfx2/app.hxx>
// auto strip #include <bf_sfx2/bindings.hxx>
#include <bf_sfx2/childwin.hxx>

// auto strip #include "pagedata.hxx"
// auto strip #include "tabview.hxx"
#include "tabvwsh.hxx"
// auto strip #include "printfun.hxx"
// auto strip #include "stlpool.hxx"
#include "docsh.hxx"
#include "gridwin.hxx"
// auto strip #include "olinewin.hxx"
// auto strip #include "uiitems.hxx"
#include "bf_sc.hrc"
// auto strip #include "viewutil.hxx"
#include "colrowba.hxx"
// auto strip #include "waitoff.hxx"
#include "globstr.hrc"
namespace binfilter {

#define SC_BLOCKMODE_NONE		0
#define SC_BLOCKMODE_NORMAL		1
#define SC_BLOCKMODE_OWN		2



//
//          Markier - Funktionen
//

//STRIP001 void ScTabView::PaintMarks(USHORT nStartCol, USHORT nStartRow, USHORT nEndCol, USHORT nEndRow )
//STRIP001 {
//STRIP001 	if (nStartCol > MAXCOL) nStartCol = MAXCOL;
//STRIP001 	if (nStartRow > MAXROW) nStartRow = MAXROW;
//STRIP001 	if (nEndCol > MAXCOL) nEndCol = MAXCOL;
//STRIP001 	if (nEndRow > MAXROW) nEndRow = MAXROW;
//STRIP001 
//STRIP001 	BOOL bLeft = (nStartCol==0 && nEndCol==MAXCOL);
//STRIP001 	BOOL bTop = (nStartRow==0 && nEndRow==MAXROW);
//STRIP001 
//STRIP001 	if (bLeft)
//STRIP001 		PaintLeftArea( nStartRow, nEndRow );
//STRIP001 	if (bTop)
//STRIP001 		PaintTopArea( nStartCol, nEndCol );
//STRIP001 
//STRIP001 	aViewData.GetDocument()->ExtendMerge( nStartCol, nStartRow, nEndCol, nEndRow,
//STRIP001 											aViewData.GetTabNo() );
//STRIP001 	PaintArea( nStartCol, nStartRow, nEndCol, nEndRow, SC_UPDATE_MARKS );
//STRIP001 }

//STRIP001 BOOL ScTabView::IsMarking( USHORT nCol, USHORT nRow, USHORT nTab ) const
//STRIP001 {
//STRIP001 	return bIsBlockMode
//STRIP001 		&& nBlockStartX == nCol
//STRIP001 		&& nBlockStartY == nRow
//STRIP001 		&& nBlockStartZ == nTab;
//STRIP001 }

/*N*/ void ScTabView::InitOwnBlockMode()
/*N*/ {
/*N*/ 	if (!bIsBlockMode)
/*N*/ 	{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*N*/ 		//	Wenn keine (alte) Markierung mehr da ist, Anker in SelectionEngine loeschen:
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 		ScMarkData& rMark = aViewData.GetMarkData();
//STRIP001 /*N*/ 		if (!rMark.IsMarked() && !rMark.IsMultiMarked())
//STRIP001 /*N*/ 			GetSelEngine()->CursorPosChanging( FALSE, FALSE );
//STRIP001 /*N*/ 
//STRIP001 /*N*/ //		bIsBlockMode = TRUE;
//STRIP001 /*N*/ 		bIsBlockMode = SC_BLOCKMODE_OWN;			//! Variable umbenennen!
//STRIP001 /*N*/ 		nBlockStartX = 0;
//STRIP001 /*N*/ 		nBlockStartY = 0;
//STRIP001 /*N*/ 		nBlockStartZ = 0;
//STRIP001 /*N*/ 		nBlockEndX = 0;
//STRIP001 /*N*/ 		nBlockEndY = 0;
//STRIP001 /*N*/ 		nBlockEndZ = 0;
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 		SelectionChanged();		// Status wird mit gesetzer Markierung abgefragt
/*N*/ 	}
/*N*/ }

//STRIP001 void ScTabView::InitBlockMode( USHORT nCurX, USHORT nCurY, USHORT nCurZ,
//STRIP001 								BOOL bTestNeg, BOOL bCols, BOOL bRows )
//STRIP001 {
//STRIP001 	if (!bIsBlockMode)
//STRIP001 	{
//STRIP001 		if (nCurX > MAXCOL) nCurX = MAXCOL;
//STRIP001 		if (nCurY > MAXROW) nCurY = MAXROW;
//STRIP001 
//STRIP001 		ScMarkData& rMark = aViewData.GetMarkData();
//STRIP001 		USHORT nTab = aViewData.GetTabNo();
//STRIP001 
//STRIP001 		//	Teil von Markierung aufheben?
//STRIP001 		if (bTestNeg)
//STRIP001 		{
//STRIP001 			if ( bCols )
//STRIP001 				bBlockNeg = rMark.IsColumnMarked( nCurX );
//STRIP001 			else if ( bRows )
//STRIP001 				bBlockNeg = rMark.IsRowMarked( nCurY );
//STRIP001 			else
//STRIP001 				bBlockNeg = rMark.IsCellMarked( nCurX, nCurY );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			bBlockNeg = FALSE;
//STRIP001 		rMark.SetMarkNegative(bBlockNeg);
//STRIP001 
//STRIP001 //		bIsBlockMode = TRUE;
//STRIP001 		bIsBlockMode = SC_BLOCKMODE_NORMAL;			//! Variable umbenennen!
//STRIP001 		bBlockCols = bCols;
//STRIP001 		bBlockRows = bRows;
//STRIP001 		nBlockStartX = nCurX;
//STRIP001 		nBlockStartY = nCurY;
//STRIP001 		nBlockStartZ = nCurZ;
//STRIP001 		nBlockEndX = nBlockStartX;
//STRIP001 		nBlockEndY = nBlockStartY;
//STRIP001 		nBlockEndZ = nBlockStartZ;
//STRIP001 		if (bBlockCols)
//STRIP001 		{
//STRIP001 			nBlockStartY = 0;
//STRIP001 			nBlockEndY = MAXROW;
//STRIP001 		}
//STRIP001 		if (bBlockRows)
//STRIP001 		{
//STRIP001 			nBlockStartX = 0;
//STRIP001 			nBlockEndX = MAXCOL;
//STRIP001 		}
//STRIP001 		rMark.SetMarkArea( ScRange( nBlockStartX,nBlockStartY, nTab, nBlockEndX,nBlockEndY, nTab ) );
//STRIP001 		InvertBlockMark( nBlockStartX,nBlockStartY,nBlockEndX,nBlockEndY );
//STRIP001 
//STRIP001 		bNewStartIfMarking = FALSE;		// use only once
//STRIP001 	}
//STRIP001 }

/*M*/ void ScTabView::SetNewStartIfMarking()
/*M*/ {
/*M*/ 	bNewStartIfMarking = TRUE;
/*M*/ }

/*N*/ void ScTabView::DoneBlockMode( BOOL bContinue )            // Default FALSE
/*N*/ {
/*N*/ 	//	Wenn zwischen Tabellen- und Header SelectionEngine gewechselt wird,
/*N*/ 	//	wird evtl. DeselectAll gerufen, weil die andere Engine keinen Anker hat.
/*N*/ 	//	Mit bMoveIsShift wird verhindert, dass dann die Selektion aufgehoben wird.
/*N*/ 
/*N*/ 	if (bIsBlockMode && !bMoveIsShift)
/*N*/ 	{
/*N*/ 		ScMarkData& rMark = aViewData.GetMarkData();
/*N*/ 		BOOL bFlag = rMark.GetMarkingFlag();
/*N*/ 		rMark.SetMarking(FALSE);
/*N*/ 
/*N*/ 		if (bBlockNeg && !bContinue)
/*N*/ 			rMark.MarkToMulti();
/*N*/ 
/*N*/ 		if (bContinue)
/*N*/ 			rMark.MarkToMulti();
/*N*/ 		else
/*N*/ 		{
/*N*/ 			//	Die Tabelle kann an dieser Stelle ungueltig sein, weil DoneBlockMode
/*N*/ 			//	aus SetTabNo aufgerufen wird
/*N*/ 			//	(z.B. wenn die aktuelle Tabelle von einer anderen View aus geloescht wird)
/*N*/ 
/*N*/ 			USHORT nTab = aViewData.GetTabNo();
/*N*/ 			ScDocument* pDoc = aViewData.GetDocument();
/*N*/ 			if ( pDoc->HasTable(nTab) )
					{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*N*/ 				PaintBlock( TRUE );								// TRUE -> Block loeschen
/*N*/ 			else
/*N*/ 				rMark.ResetMark();
/*N*/ 		}
/*N*/ //		bIsBlockMode = FALSE;
/*N*/ 		bIsBlockMode = SC_BLOCKMODE_NONE;			//! Variable umbenennen!
/*N*/ 
/*N*/ 		rMark.SetMarking(bFlag);
/*N*/ 		rMark.SetMarkNegative(FALSE);
/*N*/ 	}
/*N*/ }

//STRIP001 void ScTabView::MarkCursor( USHORT nCurX, USHORT nCurY, USHORT nCurZ, BOOL bCols, BOOL bRows )
//STRIP001 {
//STRIP001 	if (nCurX > MAXCOL) nCurX = MAXCOL;
//STRIP001 	if (nCurY > MAXROW) nCurY = MAXROW;
//STRIP001 
//STRIP001 	if (!bIsBlockMode)
//STRIP001 	{
//STRIP001 		DBG_ERROR( "MarkCursor nicht im BlockMode" );
//STRIP001 		InitBlockMode( nCurX, nCurY, nCurZ, FALSE, bCols, bRows );
//STRIP001 	}
//STRIP001 
//STRIP001 	if (bCols)
//STRIP001 		nCurY = MAXROW;
//STRIP001 	if (bRows)
//STRIP001 		nCurX = MAXCOL;
//STRIP001 
//STRIP001 	ScMarkData& rMark = aViewData.GetMarkData();
//STRIP001 	DBG_ASSERT(rMark.IsMarked() || rMark.IsMultiMarked(), "MarkCursor, !IsMarked()");
//STRIP001 	ScRange aMarkRange;
//STRIP001 	rMark.GetMarkArea(aMarkRange);
//STRIP001 	if (( aMarkRange.aStart.Col() != nBlockStartX && aMarkRange.aEnd.Col() != nBlockStartX ) ||
//STRIP001 		( aMarkRange.aStart.Row() != nBlockStartY && aMarkRange.aEnd.Row() != nBlockStartY ) ||
//STRIP001 		( bIsBlockMode == SC_BLOCKMODE_OWN ))
//STRIP001 	{
//STRIP001 		//	Markierung ist veraendert worden
//STRIP001 		//	(z.B. MarkToSimple, wenn per negativ alles bis auf ein Rechteck geloescht wurde)
//STRIP001 		//	oder nach InitOwnBlockMode wird mit Shift-Klick weitermarkiert...
//STRIP001 
//STRIP001 		BOOL bOldShift = bMoveIsShift;
//STRIP001 		bMoveIsShift = FALSE;				//	wirklich umsetzen
//STRIP001 		DoneBlockMode(FALSE);				//!	direkt Variablen setzen? (-> kein Geflacker)
//STRIP001 		bMoveIsShift = bOldShift;
//STRIP001 
//STRIP001 		InitBlockMode( aMarkRange.aStart.Col(), aMarkRange.aStart.Row(),
//STRIP001 						nBlockStartZ, rMark.IsMarkNegative(), bCols, bRows );
//STRIP001 	}
//STRIP001 
//STRIP001 	USHORT nOldCurX = nBlockEndX;
//STRIP001 	USHORT nOldCurY = nBlockEndY;
//STRIP001 
//STRIP001 	if ( nCurX != nOldCurX || nCurY != nOldCurY )
//STRIP001 	{
//STRIP001 		USHORT		nTab = nCurZ;
//STRIP001 
//STRIP001 		USHORT		nDrawStartCol;
//STRIP001 		USHORT		nDrawStartRow;
//STRIP001 		USHORT		nDrawEndCol;
//STRIP001 		USHORT		nDrawEndRow;
//STRIP001 
//STRIP001 		ScUpdateRect aRect( nBlockStartX, nBlockStartY, nOldCurX, nOldCurY );
//STRIP001 		aRect.SetNew( nBlockStartX, nBlockStartY, nCurX, nCurY );
//STRIP001 
//STRIP001 		BOOL bCont;
//STRIP001 		BOOL bDraw = aRect.GetXorDiff( nDrawStartCol, nDrawStartRow,
//STRIP001 										nDrawEndCol, nDrawEndRow, bCont );
//STRIP001 		nBlockEndX = nCurX;
//STRIP001 		nBlockEndY = nCurY;
//STRIP001 		rMark.SetMarkArea( ScRange( nBlockStartX, nBlockStartY, nTab, nBlockEndX, nBlockEndY, nTab ) );
//STRIP001 
//STRIP001 		if ( bDraw )
//STRIP001 		{
//STRIP001 //?			PutInOrder( nDrawStartCol, nDrawEndCol );
//STRIP001 //?			PutInOrder( nDrawStartRow, nDrawEndRow );
//STRIP001 
//STRIP001 			HideAllCursors();
//STRIP001 			InvertBlockMark( nDrawStartCol, nDrawStartRow, nDrawEndCol, nDrawEndRow );
//STRIP001 			if (bCont)
//STRIP001 			{
//STRIP001 				aRect.GetContDiff( nDrawStartCol, nDrawStartRow, nDrawEndCol, nDrawEndRow );
//STRIP001 				InvertBlockMark( nDrawStartCol, nDrawStartRow, nDrawEndCol, nDrawEndRow );
//STRIP001 			}
//STRIP001 			ShowAllCursors();
//STRIP001 		}
//STRIP001 
//STRIP001 		aViewData.GetViewShell()->UpdateInputHandler();
//STRIP001 //		InvalidateAttribs();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( !bCols && !bRows )
//STRIP001 		aHdrFunc.SetAnchorFlag( FALSE );
//STRIP001 }

//!
//!	PaintBlock in zwei Methoden aufteilen: RepaintBlock und RemoveBlock o.ae.
//!

//STRIP001 void ScTabView::PaintBlock( BOOL bReset )
//STRIP001 {
//STRIP001 	ScDocument* pDoc = aViewData.GetDocument();
//STRIP001 	ScMarkData& rMark = aViewData.GetMarkData();
//STRIP001 	USHORT nTab = aViewData.GetTabNo();
//STRIP001 	BOOL bMark = rMark.IsMarked();
//STRIP001 	BOOL bMulti = rMark.IsMultiMarked();
//STRIP001 	if (bMark || bMulti)
//STRIP001 	{
//STRIP001 		ScRange aMarkRange;
//STRIP001 		HideAllCursors();
//STRIP001 		BOOL bWasMulti = bMulti;
//STRIP001 		if (bMulti)
//STRIP001 		{
//STRIP001 			BOOL bFlag = rMark.GetMarkingFlag();
//STRIP001 			rMark.SetMarking(FALSE);
//STRIP001 			rMark.MarkToMulti();
//STRIP001 			rMark.GetMultiMarkArea(aMarkRange);
//STRIP001 			rMark.MarkToSimple();
//STRIP001 			rMark.SetMarking(bFlag);
//STRIP001 
//STRIP001 			bMark = rMark.IsMarked();
//STRIP001 			bMulti = rMark.IsMultiMarked();
//STRIP001 		}
//STRIP001 		else
//STRIP001 			rMark.GetMarkArea(aMarkRange);
//STRIP001 
//STRIP001 		nBlockStartX = aMarkRange.aStart.Col();
//STRIP001 		nBlockStartY = aMarkRange.aStart.Row();
//STRIP001 		nBlockStartZ = aMarkRange.aStart.Tab();
//STRIP001 		nBlockEndX = aMarkRange.aEnd.Col();
//STRIP001 		nBlockEndY = aMarkRange.aEnd.Row();
//STRIP001 		nBlockEndZ = aMarkRange.aEnd.Tab();
//STRIP001 
//STRIP001 		BOOL bDidReset = FALSE;
//STRIP001 
//STRIP001 		if ( nTab>=nBlockStartZ && nTab<=nBlockEndZ )
//STRIP001 		{
//STRIP001 			if ( bReset )
//STRIP001 			{
//STRIP001 				// Invertieren beim Loeschen nur auf aktiver View
//STRIP001 				if ( aViewData.IsActive() )
//STRIP001 				{
//STRIP001 					USHORT i;
//STRIP001 					if ( bMulti )
//STRIP001 					{
//STRIP001 						for (i=0; i<4; i++)
//STRIP001 							if (pGridWin[i] && pGridWin[i]->IsVisible())
//STRIP001 								pGridWin[i]->InvertSimple( nBlockStartX, nBlockStartY,
//STRIP001 															nBlockEndX, nBlockEndY,
//STRIP001 															TRUE, TRUE );
//STRIP001 						rMark.ResetMark();
//STRIP001 						bDidReset = TRUE;
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						// (mis)use InvertBlockMark to remove all of the selection
//STRIP001 						// -> set bBlockNeg (like when removing parts of a selection)
//STRIP001 						//	  and convert everything to Multi
//STRIP001 
//STRIP001 						rMark.MarkToMulti();
//STRIP001 						BOOL bOld = bBlockNeg;
//STRIP001 						bBlockNeg = TRUE;
//STRIP001 						// #73130# (negative) MarkArea must be set in case of repaint
//STRIP001 						rMark.SetMarkArea( ScRange( nBlockStartX,nBlockStartY, nTab,
//STRIP001 													nBlockEndX,nBlockEndY, nTab ) );
//STRIP001 
//STRIP001 						InvertBlockMark( nBlockStartX, nBlockStartY, nBlockEndX, nBlockEndY );
//STRIP001 
//STRIP001 						bBlockNeg = bOld;
//STRIP001 						rMark.ResetMark();
//STRIP001 
//STRIP001 						bDidReset = TRUE;
//STRIP001 					}
//STRIP001 
//STRIP001 					//	repaint if controls are touched (#69680# in both cases)
//STRIP001 
//STRIP001 					Rectangle aMMRect = pDoc->GetMMRect(nBlockStartX,nBlockStartY,nBlockEndX,nBlockEndY, nTab);
//STRIP001 					if (pDoc->HasControl( nTab, aMMRect ))
//STRIP001 					{
//STRIP001 						for (i=0; i<4; i++)
//STRIP001 							if (pGridWin[i] && pGridWin[i]->IsVisible())
//STRIP001 							{
//STRIP001 								//	MapMode muss logischer (1/100mm) sein !!!
//STRIP001 								pDoc->InvalidateControls( pGridWin[i], nTab, aMMRect );
//STRIP001 								pGridWin[i]->Update();
//STRIP001 							}
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 				PaintMarks( nBlockStartX, nBlockStartY, nBlockEndX, nBlockEndY );
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( bReset && !bDidReset )
//STRIP001 			rMark.ResetMark();
//STRIP001 
//STRIP001 		ShowAllCursors();
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScTabView::SelectAll( BOOL bContinue )
//STRIP001 {
//STRIP001 	ScMarkData& rMark = aViewData.GetMarkData();
//STRIP001 	USHORT nTab = aViewData.GetTabNo();
//STRIP001 
//STRIP001 	if (rMark.IsMarked())
//STRIP001 	{
//STRIP001 		ScRange aMarkRange;
//STRIP001 		rMark.GetMarkArea( aMarkRange );
//STRIP001 		if ( aMarkRange == ScRange( 0,0,nTab, MAXCOL,MAXROW,nTab ) )
//STRIP001 			return;
//STRIP001 	}
//STRIP001 
//STRIP001 	DoneBlockMode( bContinue );
//STRIP001 	InitBlockMode( 0,0,nTab );
//STRIP001 	MarkCursor( MAXCOL,MAXROW,nTab );
//STRIP001 
//STRIP001 	SelectionChanged();
//STRIP001 }

//STRIP001 void ScTabView::SelectAllTables()
//STRIP001 {
//STRIP001 	ScDocument* pDoc = aViewData.GetDocument();
//STRIP001 	ScMarkData& rMark = aViewData.GetMarkData();
//STRIP001 	USHORT nTab = aViewData.GetTabNo();
//STRIP001 	USHORT nCount = pDoc->GetTableCount();
//STRIP001 
//STRIP001 	if (nCount>1)
//STRIP001 	{
//STRIP001 		for (USHORT i=0; i<nCount; i++)
//STRIP001 			rMark.SelectTable( i, TRUE );
//STRIP001 
//STRIP001 		//		Markierungen werden per Default nicht pro Tabelle gehalten
//STRIP001 //		pDoc->ExtendMarksFromTable( nTab );
//STRIP001 
//STRIP001 		aViewData.GetDocShell()->PostPaintExtras();
//STRIP001 		aViewData.GetBindings().Invalidate( FID_FILL_TAB );
//STRIP001 	}
//STRIP001 }

//STRIP001 BOOL lcl_FitsInWindow( double fScaleX, double fScaleY, USHORT nZoom,
//STRIP001 						long nWindowX, long nWindowY, ScDocument* pDoc, USHORT nTab,
//STRIP001 						USHORT nStartCol, USHORT nStartRow, USHORT nEndCol, USHORT nEndRow,
//STRIP001 						USHORT nFixPosX, USHORT nFixPosY )
//STRIP001 {
//STRIP001 	double fZoomFactor = (double)Fraction(nZoom,100);
//STRIP001 	fScaleX *= fZoomFactor;
//STRIP001 	fScaleY *= fZoomFactor;
//STRIP001 
//STRIP001 	long nBlockX = 0;
//STRIP001 	USHORT nCol;
//STRIP001 	for (nCol=0; nCol<nFixPosX; nCol++)
//STRIP001 	{
//STRIP001 		//	for frozen panes, add both parts
//STRIP001 		USHORT nColTwips = pDoc->GetColWidth( nCol, nTab );
//STRIP001 		if (nColTwips)
//STRIP001 		{
//STRIP001 			nBlockX += (long)(nColTwips * fScaleX);
//STRIP001 			if (nBlockX > nWindowX)
//STRIP001 				return FALSE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	for (nCol=nStartCol; nCol<=nEndCol; nCol++)
//STRIP001 	{
//STRIP001 		USHORT nColTwips = pDoc->GetColWidth( nCol, nTab );
//STRIP001 		if (nColTwips)
//STRIP001 		{
//STRIP001 			nBlockX += (long)(nColTwips * fScaleX);
//STRIP001 			if (nBlockX > nWindowX)
//STRIP001 				return FALSE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	long nBlockY = 0;
//STRIP001 	USHORT nRow;
//STRIP001 	for (nRow=0; nRow<nFixPosY; nRow++)
//STRIP001 	{
//STRIP001 		//	for frozen panes, add both parts
//STRIP001 		USHORT nRowTwips = pDoc->GetRowHeight( nRow, nTab );
//STRIP001 		if (nRowTwips)
//STRIP001 		{
//STRIP001 			nBlockY += (long)(nRowTwips * fScaleY);
//STRIP001 			if (nBlockY > nWindowY)
//STRIP001 				return FALSE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	for (nRow=nStartRow; nRow<=nEndRow; nRow++)
//STRIP001 	{
//STRIP001 		USHORT nRowTwips = pDoc->GetRowHeight( nRow, nTab );
//STRIP001 		if (nRowTwips)
//STRIP001 		{
//STRIP001 			nBlockY += (long)(nRowTwips * fScaleY);
//STRIP001 			if (nBlockY > nWindowY)
//STRIP001 				return FALSE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }

//STRIP001 USHORT ScTabView::CalcZoom( SvxZoomType eType, USHORT nOldZoom )
//STRIP001 {
//STRIP001 	USHORT nZoom = 0; // Ergebnis
//STRIP001 
//STRIP001 	switch ( eType )
//STRIP001 	{
//STRIP001 		case SVX_ZOOM_PERCENT: // rZoom ist kein besonderer prozentualer Wert
//STRIP001 			nZoom = nOldZoom;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SVX_ZOOM_OPTIMAL:	// nZoom entspricht der optimalen Gr"o\se
//STRIP001 			{
//STRIP001 				ScMarkData& rMark = aViewData.GetMarkData();
//STRIP001 				ScDocument* pDoc = aViewData.GetDocument();
//STRIP001 
//STRIP001 				if (!rMark.IsMarked() && !rMark.IsMultiMarked())
//STRIP001 					nZoom = 100;				// nothing selected
//STRIP001 				else
//STRIP001 				{
//STRIP001 					USHORT	nTab = aViewData.GetTabNo();
//STRIP001 					ScRange aMarkRange;
//STRIP001 					if ( !aViewData.GetSimpleArea( aMarkRange ) )
//STRIP001 						rMark.GetMultiMarkArea( aMarkRange );
//STRIP001 
//STRIP001 					USHORT	nStartCol = aMarkRange.aStart.Col();
//STRIP001 					USHORT	nStartRow = aMarkRange.aStart.Row();
//STRIP001 					USHORT	nStartTab = aMarkRange.aStart.Tab();
//STRIP001 					USHORT	nEndCol = aMarkRange.aEnd.Col();
//STRIP001 					USHORT	nEndRow = aMarkRange.aEnd.Row();
//STRIP001 					USHORT	nEndTab = aMarkRange.aEnd.Tab();
//STRIP001 
//STRIP001 					if ( nTab < nStartTab && nTab > nEndTab )
//STRIP001 						nTab = nStartTab;
//STRIP001 
//STRIP001 					ScSplitPos eUsedPart = aViewData.GetActivePart();
//STRIP001 
//STRIP001 					USHORT nFixPosX = 0;
//STRIP001 					USHORT nFixPosY = 0;
//STRIP001 					if ( aViewData.GetHSplitMode() == SC_SPLIT_FIX )
//STRIP001 					{
//STRIP001 						//	use right part
//STRIP001 						eUsedPart = (WhichV(eUsedPart)==SC_SPLIT_TOP) ? SC_SPLIT_TOPRIGHT : SC_SPLIT_BOTTOMRIGHT;
//STRIP001 						nFixPosX = aViewData.GetFixPosX();
//STRIP001 						if ( nStartCol < nFixPosX )
//STRIP001 							nStartCol = nFixPosX;
//STRIP001 					}
//STRIP001 					if ( aViewData.GetVSplitMode() == SC_SPLIT_FIX )
//STRIP001 					{
//STRIP001 						//	use bottom part
//STRIP001 						eUsedPart = (WhichH(eUsedPart)==SC_SPLIT_LEFT) ? SC_SPLIT_BOTTOMLEFT : SC_SPLIT_BOTTOMRIGHT;
//STRIP001 						nFixPosY = aViewData.GetFixPosY();
//STRIP001 						if ( nStartRow < nFixPosY )
//STRIP001 							nStartRow = nFixPosY;
//STRIP001 					}
//STRIP001 
//STRIP001 					if (pGridWin[eUsedPart])
//STRIP001 					{
//STRIP001 						//	Because scale is rounded to pixels, the only reliable way to find
//STRIP001 						//	the right scale is to check if a zoom fits
//STRIP001 
//STRIP001 						Size aWinSize = pGridWin[eUsedPart]->GetOutputSizePixel();
//STRIP001 
//STRIP001 						//	for frozen panes, use sum of both parts for calculation
//STRIP001 
//STRIP001 						if ( nFixPosX )
//STRIP001 							aWinSize.Width() += GetGridWidth( SC_SPLIT_LEFT );
//STRIP001 						if ( nFixPosY )
//STRIP001 							aWinSize.Height() += GetGridHeight( SC_SPLIT_TOP );
//STRIP001 
//STRIP001 						ScDocShell* pDocSh = aViewData.GetDocShell();
//STRIP001 						double nPPTX = ScGlobal::nScreenPPTX / pDocSh->GetOutputFactor();
//STRIP001 						double nPPTY = ScGlobal::nScreenPPTY;
//STRIP001 
//STRIP001 						USHORT nMin = MINZOOM;
//STRIP001 						USHORT nMax = MAXZOOM;
//STRIP001 						while ( nMax > nMin )
//STRIP001 						{
//STRIP001 							USHORT nTest = (nMin+nMax+1)/2;
//STRIP001 							if ( lcl_FitsInWindow(
//STRIP001 										nPPTX, nPPTY, nTest, aWinSize.Width(), aWinSize.Height(),
//STRIP001 										pDoc, nTab, nStartCol, nStartRow, nEndCol, nEndRow,
//STRIP001 										nFixPosX, nFixPosY ) )
//STRIP001 								nMin = nTest;
//STRIP001 							else
//STRIP001 								nMax = nTest-1;
//STRIP001 						}
//STRIP001 						DBG_ASSERT( nMin == nMax, "Schachtelung ist falsch" );
//STRIP001 						nZoom = nMin;
//STRIP001 
//STRIP001 						if ( nZoom != nOldZoom )
//STRIP001 						{
//STRIP001 							// scroll to block only in active split part
//STRIP001 							// (the part for which the size was calculated)
//STRIP001 
//STRIP001 							if ( nStartCol <= nEndCol )
//STRIP001 								aViewData.SetPosX( WhichH(eUsedPart), nStartCol );
//STRIP001 							if ( nStartRow <= nEndRow )
//STRIP001 								aViewData.SetPosY( WhichV(eUsedPart), nStartRow );
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case SVX_ZOOM_WHOLEPAGE:	// nZoom entspricht der ganzen Seite oder
//STRIP001 			case SVX_ZOOM_PAGEWIDTH:	// nZoom entspricht der Seitenbreite
//STRIP001 				{
//STRIP001 					USHORT				nCurTab		= aViewData.GetTabNo();
//STRIP001 					ScDocument*			pDoc		= aViewData.GetDocument();
//STRIP001 					ScStyleSheetPool*	pStylePool  = pDoc->GetStyleSheetPool();
//STRIP001 					SfxStyleSheetBase*	pStyleSheet =
//STRIP001 											pStylePool->Find( pDoc->GetPageStyle( nCurTab ),
//STRIP001 															  SFX_STYLE_FAMILY_PAGE );
//STRIP001 
//STRIP001 					DBG_ASSERT( pStyleSheet, "PageStyle not found :-/" );
//STRIP001 
//STRIP001 					if ( pStyleSheet )
//STRIP001 					{
//STRIP001 						ScPrintFunc aPrintFunc( aViewData.GetDocShell(),
//STRIP001 												aViewData.GetViewShell()->GetPrinter(),
//STRIP001 												nCurTab );
//STRIP001 
//STRIP001 						Size aPageSize = aPrintFunc.GetDataSize();
//STRIP001 
//STRIP001 						//	use the size of the largest GridWin for normal split,
//STRIP001 						//	or both combined for frozen panes, with the (document) size
//STRIP001 						//	of the frozen part added to the page size
//STRIP001 						//	(with frozen panes, the size of the individual parts
//STRIP001 						//	depends on the scale that is to be calculated)
//STRIP001 
//STRIP001 						if ( !pGridWin[SC_SPLIT_BOTTOMLEFT] ) return 0;
//STRIP001 						Size aWinSize = pGridWin[SC_SPLIT_BOTTOMLEFT]->GetOutputSizePixel();
//STRIP001 						ScSplitMode eHMode = aViewData.GetHSplitMode();
//STRIP001 						if ( eHMode != SC_SPLIT_NONE && pGridWin[SC_SPLIT_BOTTOMRIGHT] )
//STRIP001 						{
//STRIP001 							long nOtherWidth = pGridWin[SC_SPLIT_BOTTOMRIGHT]->
//STRIP001 														GetOutputSizePixel().Width();
//STRIP001 							if ( eHMode == SC_SPLIT_FIX )
//STRIP001 							{
//STRIP001 								aWinSize.Width() += nOtherWidth;
//STRIP001 								for ( USHORT nCol = aViewData.GetPosX(SC_SPLIT_LEFT);
//STRIP001 										nCol < aViewData.GetFixPosX(); nCol++ )
//STRIP001 									aPageSize.Width() += pDoc->GetColWidth( nCol, nCurTab );
//STRIP001 							}
//STRIP001 							else if ( nOtherWidth > aWinSize.Width() )
//STRIP001 								aWinSize.Width() = nOtherWidth;
//STRIP001 						}
//STRIP001 						ScSplitMode eVMode = aViewData.GetVSplitMode();
//STRIP001 						if ( eVMode != SC_SPLIT_NONE && pGridWin[SC_SPLIT_TOPLEFT] )
//STRIP001 						{
//STRIP001 							long nOtherHeight = pGridWin[SC_SPLIT_TOPLEFT]->
//STRIP001 														GetOutputSizePixel().Height();
//STRIP001 							if ( eVMode == SC_SPLIT_FIX )
//STRIP001 							{
//STRIP001 								aWinSize.Height() += nOtherHeight;
//STRIP001 								for ( USHORT nRow = aViewData.GetPosY(SC_SPLIT_TOP);
//STRIP001 										nRow < aViewData.GetFixPosY(); nRow++ )
//STRIP001 									aPageSize.Height() += pDoc->GetRowHeight( nRow, nCurTab );
//STRIP001 							}
//STRIP001 							else if ( nOtherHeight > aWinSize.Height() )
//STRIP001 								aWinSize.Height() = nOtherHeight;
//STRIP001 						}
//STRIP001 
//STRIP001 						double nPPTX = ScGlobal::nScreenPPTX / aViewData.GetDocShell()->GetOutputFactor();
//STRIP001 						double nPPTY = ScGlobal::nScreenPPTY;
//STRIP001 
//STRIP001 						long nZoomX = (long) ( aWinSize.Width() * 100 /
//STRIP001 											   ( aPageSize.Width() * nPPTX ) );
//STRIP001 						long nZoomY = (long) ( aWinSize.Height() * 100 /
//STRIP001 											   ( aPageSize.Height() * nPPTY ) );
//STRIP001 						long nNew = nZoomX;
//STRIP001 
//STRIP001 						if (eType == SVX_ZOOM_WHOLEPAGE && nZoomY < nNew)
//STRIP001 							nNew = nZoomY;
//STRIP001 
//STRIP001 						nZoom = (USHORT) nNew;
//STRIP001 					}
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 		default:
//STRIP001 			DBG_ERROR("Unknown Zoom-Revision");
//STRIP001 			nZoom = 0;
//STRIP001 	}
//STRIP001 
//STRIP001 	return nZoom;
//STRIP001 }

//	wird z.B. gerufen, wenn sich das View-Fenster verschiebt:

/*N*/ void ScTabView::StopMarking()
/*N*/ {
/*N*/ 	ScSplitPos eActive = aViewData.GetActivePart();
/*N*/ 	if (pGridWin[eActive])
/*N*/ 		pGridWin[eActive]->StopMarking();
/*N*/ 
/*N*/ 	ScHSplitPos eH = WhichH(eActive);
/*N*/ 	if (pColBar[eH])
/*N*/ 		pColBar[eH]->StopMarking();
/*N*/ 
/*N*/ 	ScVSplitPos eV = WhichV(eActive);
/*N*/ 	if (pRowBar[eV])
/*N*/ 		pRowBar[eV]->StopMarking();
/*N*/ }

/*N*/ void ScTabView::HideNoteMarker()
/*N*/ {
/*N*/ 	for (USHORT i=0; i<4; i++)
/*N*/ 		if (pGridWin[i] && pGridWin[i]->IsVisible())
/*N*/ 			pGridWin[i]->HideNoteMarker();
/*N*/ }

//STRIP001 void ScTabView::MakeDrawLayer()
//STRIP001 {
//STRIP001 	if (!pDrawView)
//STRIP001 	{
//STRIP001 		aViewData.GetDocShell()->MakeDrawLayer();
//STRIP001 
//STRIP001 		//	pDrawView wird per Notify gesetzt
//STRIP001 		DBG_ASSERT(pDrawView,"ScTabView::MakeDrawLayer funktioniert nicht");
//STRIP001 	}
//STRIP001 }

/*N*/ void ScTabView::ErrorMessage( USHORT nGlobStrId )
/*N*/ {
/*?*/ 	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 StopMarking();		// falls per Focus aus MouseButtonDown aufgerufen
/*?*/ 
//STRIP001 /*?*/ 	Window* pParent = aViewData.GetDialogParent();
//STRIP001 /*?*/ 	ScWaitCursorOff aWaitOff( pParent );
//STRIP001 /*?*/ 	BOOL bFocus = pParent && pParent->HasFocus();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 	if(nGlobStrId==STR_PROTECTIONERR)
//STRIP001 /*?*/ 	{
//STRIP001 /*?*/ 		if(aViewData.GetDocShell()->IsReadOnly())
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			nGlobStrId=STR_READONLYERR;
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 	}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 	InfoBox aBox( pParent, ScGlobal::GetRscString( nGlobStrId ) );
//STRIP001 /*?*/ 	aBox.Execute();
//STRIP001 /*?*/ 	if (bFocus)
//STRIP001 /*?*/ 		pParent->GrabFocus();
/*N*/ }

//STRIP001 Window* ScTabView::GetParentOrChild( USHORT nChildId )
//STRIP001 {
//STRIP001 	SfxViewFrame* pViewFrm = aViewData.GetViewShell()->GetViewFrame();
//STRIP001 
//STRIP001 	if ( pViewFrm->HasChildWindow(nChildId) )
//STRIP001 	{
//STRIP001 		SfxChildWindow* pChild = pViewFrm->GetChildWindow(nChildId);
//STRIP001 		if (pChild)
//STRIP001 		{
//STRIP001 			Window* pWin = pChild->GetWindow();
//STRIP001 			if (pWin && pWin->IsVisible())
//STRIP001 				return pWin;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return aViewData.GetDialogParent();
//STRIP001 }

//STRIP001 void ScTabView::UpdatePageBreakData( BOOL bForcePaint )
//STRIP001 {
//STRIP001 	ScPageBreakData* pNewData = NULL;
//STRIP001 
//STRIP001 	if (aViewData.IsPagebreakMode())
//STRIP001 	{
//STRIP001 		ScDocShell* pDocSh = aViewData.GetDocShell();
//STRIP001 		ScDocument* pDoc = pDocSh->GetDocument();
//STRIP001 		USHORT nTab = aViewData.GetTabNo();
//STRIP001 
//STRIP001 		USHORT nCount = pDoc->GetPrintRangeCount(nTab);
//STRIP001 		if (!nCount)
//STRIP001 			nCount = 1;
//STRIP001 		pNewData = new ScPageBreakData(nCount);
//STRIP001 
//STRIP001 		ScPrintFunc aPrintFunc( pDocSh, pDocSh->GetPrinter(), nTab, 0,0,NULL, NULL, pNewData );
//STRIP001 		//	ScPrintFunc fuellt im ctor die PageBreakData
//STRIP001 		if ( nCount > 1 )
//STRIP001 		{
//STRIP001 			aPrintFunc.ResetBreaks(nTab);
//STRIP001 			pNewData->AddPages();
//STRIP001 		}
//STRIP001 
//STRIP001 		//	Druckbereiche veraendert?
//STRIP001 		if ( bForcePaint || ( pPageBreakData && !pPageBreakData->IsEqual( *pNewData ) ) )
//STRIP001 			PaintGrid();
//STRIP001 	}
//STRIP001 
//STRIP001 	delete pPageBreakData;
//STRIP001 	pPageBreakData = pNewData;
//STRIP001 }



}
