/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_frame.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:49:59 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif
// auto strip #ifndef _COM_SUN_STAR_AWT_XWINDOW_HPP_
// auto strip #include <com/sun/star/awt/XWindow.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_UTIL_XURLTRANSFORMER_HPP_
// auto strip #include <com/sun/star/util/XURLTransformer.hpp>
// auto strip #endif
#ifndef _COM_SUN_STAR_UTIL_XCLOSEABLE_HPP_
#include <com/sun/star/util/XCloseable.hpp>
#endif
// auto strip #ifndef _COM_SUN_STAR_UTIL_CLOSEVETOEXCEPTION_HPP_
// auto strip #include <com/sun/star/util/CloseVetoException.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HPP_
// auto strip #include <com/sun/star/lang/XComponent.hpp>
// auto strip #endif
#ifndef _COM_SUN_STAR_LANG_DISPOSEDEXCEPTION_HPP_
#include <com/sun/star/lang/DisposedException.hpp>
#endif

// auto strip #ifndef _MENU_HXX //autogen
// auto strip #include <vcl/menu.hxx>
// auto strip #endif
// auto strip #ifndef _SFXINTITEM_HXX //autogen
// auto strip #include <svtools/intitem.hxx>
// auto strip #endif
// auto strip #ifndef _SPLITWIN_HXX //autogen
// auto strip #include <vcl/splitwin.hxx>
// auto strip #endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
// auto strip #ifndef _TOOLKIT_UNOHLP_HXX
// auto strip #include <toolkit/helper/vclunohelper.hxx>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_AWT_POSSIZE_HPP_
// auto strip #include <com/sun/star/awt/PosSize.hpp>
// auto strip #endif
// auto strip #ifndef _UNOTOOLS_PROCESSFACTORY_HXX
// auto strip #include <comphelper/processfactory.hxx>
// auto strip #endif
#include <vcl/msgbox.hxx>

#pragma hdrstop

#ifndef _COM_SUN_STAR_LANG_XTYPEPROVIDER_HPP_
#include <com/sun/star/lang/XTypeProvider.hpp>
#endif

// auto strip #include "unoctitm.hxx"
// auto strip #include "frame.hxx"
#include "arrdecl.hxx"
// auto strip #include "objsh.hxx"
#include "dispatch.hxx"
#include "docfile.hxx"
// auto strip #include "docfilt.hxx"
// auto strip #include "frmdescr.hxx"
#include "appdata.hxx"
// auto strip #include "openflag.hxx"
#include "urlframe.hxx"
// auto strip #include "viewsh.hxx"
// auto strip #include "viewfrm.hxx"
#include "request.hxx"
#include "fcontnr.hxx"
#include "impframe.hxx"
// auto strip #include "appuno.hxx"
#include "topfrm.hxx"
#include "workwin.hxx"
// auto strip #include "fsetvwsh.hxx"
// auto strip #include "sfxuno.hxx"
// auto strip #include "msgpool.hxx"
#include "objshimp.hxx"

#ifdef DBG_UTIL
// auto strip #include "frmhtmlw.hxx"
#endif
// auto strip #ifndef _LEGACYBINFILTERMGR_HXX
// auto strip #include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
// auto strip #endif
namespace binfilter {

static SfxFrameArr_Impl* pFramesArr_Impl=0;

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::util;
using namespace ::com::sun::star::frame;

/*N*/ TYPEINIT1(SfxFrame, SfxListener);
/*N*/ TYPEINIT1(SfxFrameItem, SfxPoolItem);
/*N*/ TYPEINIT1(SfxUsrAnyItem, SfxPoolItem);

/*N*/ void SfxFrame::SetLoadCancelable_Impl( SfxCancellable* pCbl )
/*N*/ {
/*N*/ 	delete pImp->pLoadCancellable;
/*N*/ 	pImp->pLoadCancellable = pCbl;
/*N*/ }

/*N*/ SfxFrame::SfxFrame(SfxFrame* pParent):
/*N*/ 	pParentFrame( pParent ),
/*N*/     pChildArr(0),
/*N*/     pUnoImp(0)
/*N*/ {
/*N*/ 	pImp = new SfxFrame_Impl( this );
/*N*/     if ( pParent )
/*?*/         {DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pParent->InsertChildFrame_Impl( this );
/*N*/     if ( !pFramesArr_Impl )
/*N*/         pFramesArr_Impl = new SfxFrameArr_Impl;
/*N*/     pFramesArr_Impl->Insert( this, pFramesArr_Impl->Count() );
/*N*/ }

/*N*/ SvCompatWeakHdl* SfxFrame::GetHdl()
/*N*/ {
/*N*/ 	return pImp->GetHdl();
/*N*/ }

/*N*/ SfxCancelManager* SfxFrame::GetCancelManager() const
/*N*/ {
/*N*/ 	SfxFrame *pFrame = GetTopFrame();
/*N*/ 	SfxCancelManager*& rpMgr = pFrame->pImp->pCancelMgr;
/*N*/ 	if ( !rpMgr )
/*N*/ 	{
/*N*/ 		rpMgr = new SfxCancelManager( SFX_APP()->GetCancelManager() );
/*N*/ 		pFrame->pImp->StartListening( *rpMgr );
/*N*/ 	}
/*N*/ 	return rpMgr;
/*N*/ }

//--------------------------------------------------------------------

/*N*/ SfxFrame::~SfxFrame()
/*N*/ {
/*N*/     pFramesArr_Impl->Remove( pFramesArr_Impl->GetPos( this ) );
/*N*/ 
/*N*/     if ( pParentFrame )
/*N*/     {
/*?*/         DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pParentFrame->RemoveChildFrame_Impl( this );
//STRIP001 /*?*/         pParentFrame = 0;
/*N*/     }
/*N*/ 
/*N*/ 	// Nur TopLevel-Frames verwalten ihren Descriptor selbst, bei den anderen
/*N*/ 	// tut es das Frameset
/*N*/ 	if ( pImp->pDescr && !pImp->pDescr->GetParent() )
/*N*/ 		delete pImp->pDescr;
/*N*/ 
/*N*/ 	if ( pChildArr )
/*N*/ 	{
/*?*/ 		DBG_ASSERT( !pChildArr->Count(), "Childs nicht entfernt!" );
/*?*/ 		delete pChildArr;
/*N*/ 	}
/*N*/ 
/*N*/ 	delete pImp;
/*N*/ }

/*N*/ sal_Bool SfxFrame::DoClose()
/*N*/ {
/*N*/ 	// Eigentlich wird noch ein PrepareClose gebraucht !!!
/*N*/     BOOL bRet = FALSE;
/*N*/ 	if ( !pImp->bClosing )
/*N*/ 	{
/*N*/ 		pImp->bClosing = sal_True;
/*N*/ 		CancelTransfers();
/*N*/ 
/*N*/         // now close frame; it will be deleted if this call is successful, so don't use any members after that!
/*N*/         bRet = TRUE;
/*N*/         try
/*N*/         {
/*N*/             Reference< XCloseable > xCloseable  ( pImp->xFrame, UNO_QUERY );
/*N*/             if ( (!GetCurrentDocument() || !GetCurrentDocument()->Get_Impl()->bDisposing ) && xCloseable.is())
/*?*/                 xCloseable->close(sal_True);
/*N*/             else if ( pImp->xFrame.is() )
/*N*/ 			{
/*N*/ 				Reference < XFrame > xFrame = pImp->xFrame;
/*N*/ 				xFrame->setComponent( Reference < ::com::sun::star::awt::XWindow >(), Reference < XController >() );
/*N*/                 xFrame->dispose();
/*N*/ 			}
/*N*/             else
/*?*/                 bRet = DoClose_Impl();
/*N*/         }
/*N*/         catch( ::com::sun::star::util::CloseVetoException& )
/*N*/         {
/*N*/             pImp->bClosing = sal_False;
/*N*/             bRet = FALSE;
/*N*/         }
/*N*/         catch( ::com::sun::star::lang::DisposedException& )
/*N*/         {
/*N*/         }
/*N*/     }
/*N*/ 
/*N*/     return bRet;
/*N*/ }

/*N*/ sal_Bool SfxFrame::DoClose_Impl()
/*N*/ {
/*N*/     sal_Bool bRet = sal_True;
/*N*/     SfxBindings* pBindings = NULL;
/*N*/     if ( pImp->pCurrentViewFrame )
/*N*/         pBindings = &pImp->pCurrentViewFrame->GetBindings();
/*N*/ 
/*N*/     // Bei internen Tasks m"ussen Controller und Tools abger"aumt werden
/*N*/     if ( pImp->pWorkWin )
/*N*/         pImp->pWorkWin->DeleteControllers_Impl();
/*N*/ 
/*N*/     if ( pImp->pCurrentViewFrame )
/*N*/         bRet = pImp->pCurrentViewFrame->Close();
/*N*/ 
/*N*/     if ( pImp->bOwnsBindings )
/*N*/         DELETEZ( pBindings );
/*N*/ 
/*N*/     bRet = Close();
/*N*/     DBG_ASSERT( bRet, "Impossible state: frame closes, but controller refuses!");
/*N*/     return bRet;
/*N*/ }

//STRIP001 void SfxFrame::Clear_Impl()
//STRIP001 {
//STRIP001 	CancelTransfers();
//STRIP001 
//STRIP001 	// Bei FrameSets verhindern, da\s das Closen der Childs zu st"andigen
//STRIP001 	// ReCalcs im SplitWindow f"uhrt; SetUpdateMode am FrameWindow wirkt
//STRIP001 	// leider nicht auf dem MAC
//STRIP001 	Window *pWin = NULL;
//STRIP001 	SfxViewShell *pViewSh;
//STRIP001 	if ( pImp->pCurrentViewFrame &&
//STRIP001 			0 != ( pViewSh = pImp->pCurrentViewFrame->GetViewShell() ) )
//STRIP001 	{
//STRIP001 		pWin = pViewSh->GetWindow();
//STRIP001 		if ( pWin )
//STRIP001 		{
//STRIP001 			if ( pWin->GetType() ==  RSC_SPLITWINDOW )
//STRIP001 				((SplitWindow*)pWin)->SetUpdateMode( sal_False );
//STRIP001 			pWin->Hide();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	sal_Bool bRet = sal_True;
//STRIP001 	SfxBindings* pBindings = NULL;
//STRIP001 	if ( pImp->pCurrentViewFrame )
//STRIP001 	{
//STRIP001 		pBindings = &pImp->pCurrentViewFrame->GetBindings();
//STRIP001 		pImp->bClosing = sal_True;
//STRIP001 		bRet = pImp->pCurrentViewFrame->Close();
//STRIP001 		pImp->bClosing = sal_False;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bRet )
//STRIP001 	{
//STRIP001 		// Bei internen Tasks m"ussen Controller und Tools abger"aumt werden
//STRIP001 		if ( pImp->pWorkWin )
//STRIP001 		{
//STRIP001 			pImp->pWorkWin->DeleteControllers_Impl();
//STRIP001 			DELETEZ( pImp->pWorkWin );
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( pImp->bOwnsBindings )
//STRIP001 			delete pBindings;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if ( pWin )
//STRIP001 		{
//STRIP001 			if ( pWin->GetType() ==  RSC_SPLITWINDOW )
//STRIP001 			{
//STRIP001 				((SplitWindow*)pWin)->SetUpdateMode( sal_True );
//STRIP001 				((SplitWindow*)pWin)->Show();
//STRIP001 			}
//STRIP001 			else
//STRIP001 				pWin->Show();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }


//STRIP001 sal_Bool SfxFrame::DocIsModified_Impl()
//STRIP001 {
//STRIP001 	if ( pImp->pCurrentViewFrame && pImp->pCurrentViewFrame->GetObjectShell() &&
//STRIP001 			pImp->pCurrentViewFrame->GetObjectShell()->IsModified() )
//STRIP001 		return sal_True;
//STRIP001 	for( sal_uInt16 nPos = GetChildFrameCount(); nPos--; )
//STRIP001 		if( pChildArr->GetObject( nPos )->DocIsModified_Impl() )
//STRIP001 			return sal_True;
//STRIP001 	return sal_False;
//STRIP001 }

/*N*/ sal_uInt16 SfxFrame::PrepareClose_Impl( sal_Bool bUI, sal_Bool bForBrowsing )
/*N*/ {
/*N*/ 	sal_uInt16 nRet = RET_OK;
/*N*/ 
/*N*/     // prevent recursive calls
/*N*/ 	if( !pImp->bPrepClosing )
/*N*/ 	{
/*N*/ 		pImp->bPrepClosing = sal_True;
/*N*/ 
/*N*/         SfxObjectShell* pCur = GetCurrentDocument() ;
/*N*/         if( pCur )
/*N*/         {
/*N*/             // SFX components have a known behaviour
/*N*/             // First check if this frame is the only view to its current document
/*N*/             int bOther = sal_False;
/*N*/             for ( const SfxViewFrame *pFrame = SfxViewFrame::GetFirst( pCur );
/*N*/                     !bOther && pFrame; pFrame = SfxViewFrame::GetNext( *pFrame, pCur ) )
/*N*/             {
/*N*/                 bOther = ( pFrame->GetFrame() != this );
/*N*/             }
/*N*/ 
/*N*/             if ( bOther )
/*N*/                 // if there are other views only the current view of this frame must be asked
/*?*/                 nRet = GetCurrentViewFrame()->GetViewShell()->PrepareClose( bUI, bForBrowsing );
/*N*/             else
/*N*/                 // otherwise ask the document
/*N*/                 nRet = pCur->PrepareClose( bUI, bForBrowsing );
/*N*/         }
/*N*/ 
/*N*/         if ( nRet == RET_OK )
/*N*/         {
/*N*/             // if this frame has child frames, ask them too
/*N*/             for( USHORT nPos = GetChildFrameCount(); nRet == RET_OK && nPos--; )
/*?*/                 nRet = pChildArr->GetObject( nPos )->PrepareClose_Impl( bUI, bForBrowsing );
/*N*/         }
/*N*/ 
/*N*/ 		pImp->bPrepClosing = sal_False;
/*N*/ 	}
/*N*/ 
/*N*/     if ( nRet == RET_OK && pImp->pWorkWin )
/*N*/         // if closing was accepted by the component the UI subframes must be asked also
/*N*/         nRet = pImp->pWorkWin->PrepareClose_Impl();
/*N*/ 
/*N*/     return nRet;
/*N*/ }

//--------------------------------------------------------------------

//STRIP001 SfxFrame* SfxFrame::GetChildFrame( sal_uInt16 nPos ) const
//STRIP001 {
//STRIP001 	if ( pChildArr && pChildArr->Count() > nPos )
//STRIP001 	{
//STRIP001 		DBG_ASSERT( nPos < pChildArr->Count(), "Falscher Index!")
//STRIP001 		return (*pChildArr)[nPos];
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }

//STRIP001 void SfxFrame::InsertChildFrame_Impl( SfxFrame* pFrame, sal_uInt16 nPos )
//STRIP001 {
//STRIP001 	if ( !pChildArr )
//STRIP001 		pChildArr = new SfxFrameArr_Impl;
//STRIP001 	pChildArr->Insert( pFrame, nPos );
//STRIP001 	pFrame->pParentFrame = this;
//STRIP001 }

//STRIP001 void SfxFrame::RemoveChildFrame_Impl( sal_uInt16 nPos )
//STRIP001 {
//STRIP001 	DBG_ASSERT( pChildArr, "Unbekannter Frame!");
//STRIP001 	pChildArr->Remove( nPos );
//STRIP001 };

//STRIP001 void SfxFrame::RemoveChildFrame_Impl( SfxFrame* pFrame )
//STRIP001 {
//STRIP001 	DBG_ASSERT( pChildArr, "Unbekannter Frame!");
//STRIP001 	sal_uInt16 nPos = pChildArr->GetPos(pFrame);
//STRIP001 	RemoveChildFrame_Impl( nPos );
//STRIP001 };

//STRIP001 sal_Bool SfxFrame::CloseChildFrames()
//STRIP001 {
//STRIP001 	sal_Bool bRet = sal_True;
//STRIP001 	if ( pChildArr )
//STRIP001 	{
//STRIP001 		// Childs closen
//STRIP001 		sal_uInt16 nCount = pChildArr->Count();
//STRIP001 		for ( sal_uInt16 n=nCount; n>0; n--)
//STRIP001 		{
//STRIP001 			SfxFrame* pFrame = (*pChildArr)[n-1];
//STRIP001 			// pFrame removed sich selbst
//STRIP001 			bRet = pFrame->DoClose();
//STRIP001 			if ( !bRet )
//STRIP001 				break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }

//STRIP001 SfxFrame* SfxFrame::SearchChildrenForName_Impl( const String& rName, sal_Bool bDeep ) const
//STRIP001 {
//STRIP001 	if ( pChildArr )
//STRIP001 	{
//STRIP001 		sal_uInt16 nCount = pChildArr->Count();
//STRIP001 		for ( sal_uInt16 n=nCount; n>0; n--)
//STRIP001 		{
//STRIP001 			SfxFrame* pFrame = (*pChildArr)[n-1];
//STRIP001 			if ( rName.CompareIgnoreCaseToAscii( pFrame->GetFrameName() ) == COMPARE_EQUAL )
//STRIP001 				return pFrame;
//STRIP001 			if( bDeep )
//STRIP001 			{
//STRIP001 				pFrame = pFrame->SearchChildrenForName_Impl( rName );
//STRIP001 				if ( pFrame )
//STRIP001 					return pFrame;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return NULL;
//STRIP001 }

/*N*/ SfxFrame* SfxFrame::GetTopFrame() const
/*N*/ {
/*N*/ 	SfxFrame *pParent = (SfxFrame*) this;
/*N*/ 	while ( pParent->pParentFrame )
/*N*/ 		pParent = pParent->pParentFrame;
/*N*/ 	return pParent;
/*N*/ }

//STRIP001 SfxFrame* SfxFrame::SearchFrame( const String& rName, SfxMedium* pMedium )
//STRIP001 {
//STRIP001 	// Weil Netscape f"uhrende BLANKS "uberliest, m"ussen wir das wohl auch
//STRIP001 	// Sollte besser auch bei den FrameNames gemacht werden!
//STRIP001 	String aName( rName );
//STRIP001 	aName.EraseLeadingChars();
//STRIP001 
//STRIP001 	SfxFrame *pFrame = this;
//STRIP001 	if( !aName.Len() || aName.CompareIgnoreCaseToAscii("_self") == COMPARE_EQUAL )
//STRIP001 	{
//STRIP001 		return pFrame;
//STRIP001 	}
//STRIP001 	else if (  aName.CompareIgnoreCaseToAscii("_smartself") == COMPARE_EQUAL )
//STRIP001 	{
//STRIP001         DBG_ERROR("Not supported!");
//STRIP001         return pFrame;
//STRIP001 	}
//STRIP001 	else if ( aName.CompareIgnoreCaseToAscii( GetFrameName() ) == COMPARE_EQUAL)
//STRIP001 	{
//STRIP001 		// Eigener Name, kein Name oder Selbstbezug
//STRIP001 		return pFrame;
//STRIP001 	}
//STRIP001 	else if ( aName.CompareIgnoreCaseToAscii("_parent") == COMPARE_EQUAL )
//STRIP001 	{
//STRIP001 		// Gesucht ist das Parent Frameset
//STRIP001 		return pParentFrame ? pParentFrame : this;
//STRIP001 	}
//STRIP001 	else if ( aName.CompareIgnoreCaseToAscii("_blank") == COMPARE_EQUAL )
//STRIP001 	{
//STRIP001 		return NULL;
//STRIP001 	}
//STRIP001 	else if ( aName.CompareIgnoreCaseToAscii("_top") == COMPARE_EQUAL )
//STRIP001 	{
//STRIP001 		while ( pFrame->GetParentFrame() )
//STRIP001 			pFrame = pFrame->GetParentFrame();
//STRIP001 		return pFrame;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// Zuerst unterhalb dieses Frames absuchen
//STRIP001 		pFrame = SearchChildrenForName_Impl( aName );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( !pFrame && GetParentFrame() )
//STRIP001 	{
//STRIP001 		// Noch nichts gefunden, nach oben weitergehen
//STRIP001 		// Eigentlich m"u\sten Frames, die schon abgesucht wurden, aus
//STRIP001 		// Performance-Gr"unden markiert werden
//STRIP001 		SfxFrame *pParent = GetParentFrame();
//STRIP001 		do
//STRIP001 		{
//STRIP001 			// Ist es der Parent ?
//STRIP001 			if ( aName.CompareIgnoreCaseToAscii( pParent->GetFrameName() ) == COMPARE_EQUAL )
//STRIP001 				return pParent;
//STRIP001 
//STRIP001 			if ( pParent->pImp->pDescr->GetFrameSet() )
//STRIP001 			{
//STRIP001 				// Wenn es ein Parent Frameset gibt, dort suchen
//STRIP001 				pFrame = pParent->SearchChildrenForName_Impl( aName );
//STRIP001 				if ( pFrame )
//STRIP001 					return pFrame;
//STRIP001 			}
//STRIP001 
//STRIP001 			// Weiter nach oben
//STRIP001 			pParent = pParent->GetParentFrame();
//STRIP001 		}
//STRIP001 		while ( pParent );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( !pFrame )
//STRIP001 	{
//STRIP001 		SfxFrameArr_Impl& rArr = *SFX_APP()->Get_Impl()->pTopFrames;
//STRIP001 		// keinen Frame im MDI-Fenster gefunden. Jetzt die anderen
//STRIP001 		// Toplevel Frames checken.
//STRIP001 		SfxFrame *pTop = GetTopFrame();
//STRIP001 		for( sal_uInt16 nPos = rArr.Count(); nPos--; )
//STRIP001 		{
//STRIP001 			 // Unser Topframe wurde bereits durchsucht
//STRIP001 			SfxFrame* pCurFrame = rArr[ nPos ];
//STRIP001 			if(  pCurFrame != pTop )
//STRIP001 			{
//STRIP001 				if( aName.CompareIgnoreCaseToAscii( pCurFrame->GetFrameName() ) ==
//STRIP001 					COMPARE_EQUAL )
//STRIP001 					return pCurFrame;
//STRIP001 				else
//STRIP001 				{
//STRIP001 					if( pFrame =
//STRIP001 						pCurFrame->SearchChildrenForName_Impl( aName ) )
//STRIP001 						return pFrame;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return pFrame;
//STRIP001 }

/*N*/ sal_Bool SfxFrame::IsClosing_Impl() const
/*N*/ {
/*N*/ 	return pImp->bClosing;
/*N*/ }

/*?*/ void SfxFrame::SetIsClosing_Impl()
/*?*/ {
/*?*/ 	pImp->bClosing = TRUE;
/*?*/ }

/*N*/ void SfxFrame::DocumentInserted( SfxObjectShell* pDoc )
/*N*/ {
/*N*/ }

/*N*/ sal_uInt16 SfxFrame::GetChildFrameCount() const
/*N*/ {
/*N*/ 	return pChildArr ? pChildArr->Count() : 0;
/*N*/ }

/*N*/ sal_Bool SfxFrame::InsertDocument( SfxObjectShell *pDoc )
/*N*/ {
/*N*/ 	DocumentInserted( pDoc );
/*N*/ 	return sal_True;
/*N*/ }

/*N*/ void SfxFrame::SetLoadEnvironment_Impl( LoadEnvironment_Impl* pEnv )
/*N*/ {
/*N*/ 	if ( pImp->pLoadEnv )
/*N*/ 		pImp->pLoadEnv->EndListening( *pImp );
/*N*/ 
/*N*/ 	pImp->pLoadEnv = pEnv;
/*N*/ 
/*N*/ 	if ( pImp->pLoadEnv && !pImp->pLoadEnv->IsListening( *pImp ) )
/*N*/ 		pImp->pLoadEnv->StartListening( *pImp );
/*N*/ }

/*N*/ LoadEnvironment_Impl* SfxFrame::GetLoadEnvironment_Impl() const
/*N*/ {
/*N*/ 	return pImp->pLoadEnv;
/*N*/ }

/*N*/ void SfxFrame::CancelTransfers( sal_Bool bCancelLoadEnv )
/*N*/ {
/*N*/ 	if( !pImp->bInCancelTransfers )
/*N*/ 	{
/*N*/ 		pImp->bInCancelTransfers = sal_True;
/*N*/ 		SfxObjectShell* pObj = GetCurrentDocument();
/*N*/ 		if( pObj ) //&& !( pObj->Get_Impl()->nLoadedFlags & SFX_LOADED_ALL ))
/*N*/ 		{
/*N*/ 			SfxViewFrame* pFrm;
/*N*/ 			for( pFrm = SfxViewFrame::GetFirst( pObj );
/*N*/ 				 pFrm && pFrm->GetFrame() == this;
/*N*/ 				 pFrm = SfxViewFrame::GetNext( *pFrm, pObj ) );
/*N*/ 			// Keine anderer Frame mehr auf Doc -> Cancel
/*N*/ 			if( !pFrm )
/*N*/ 			{
/*N*/ 				pObj->CancelTransfers();
/*N*/                 GetCurrentDocument()->Broadcast( SfxSimpleHint(SFX_HINT_TITLECHANGED) );
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		// zuerst Nachladende Frames stoppen
/*N*/ 		SfxURLFrame* pURLFrame = PTR_CAST( SfxURLFrame, this );
/*N*/ 		if( pURLFrame )
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pURLFrame->CancelActivate_Impl();
/*N*/ 		sal_uInt16 nCount = GetChildFrameCount();
/*N*/ 		for( sal_uInt16 n = 0; n<nCount; n++ )
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 GetChildFrame( n )->CancelTransfers();
/*N*/ 
/*N*/ 		//  ggf. StarOne-Loader canceln
/*N*/ 		SfxFrameWeak wFrame( this );
/*N*/         if( wFrame.Is() && pImp->pLoadEnv && bCancelLoadEnv )
/*?*/ 			pImp->pLoadEnv->CancelTransfers();
/*N*/ 
/*N*/ 		if (wFrame.Is())
/*N*/ 			pImp->bInCancelTransfers = sal_False;
/*N*/ 	}
/*N*/ }

/*N*/ SfxViewFrame* SfxFrame::GetCurrentViewFrame() const
/*N*/ {
/*N*/ 	return pImp->pCurrentViewFrame;
/*N*/ }

//STRIP001 SfxDispatcher* SfxFrame::GetDispatcher_Impl() const
//STRIP001 {
//STRIP001 	if ( pImp->pCurrentViewFrame )
//STRIP001 		return pImp->pCurrentViewFrame->GetDispatcher();
//STRIP001 	return GetParentFrame()->GetDispatcher_Impl();
//STRIP001 }

/*N*/ SfxObjectShell* SfxFrame::GetCurrentDocument() const
/*N*/ {
/*N*/ 	return pImp->pCurrentViewFrame ?
/*N*/ 			pImp->pCurrentViewFrame->GetObjectShell() :
/*N*/ 			pImp->pCurrentObjectShell;
/*N*/ }

//STRIP001 void SfxFrame::SetCurrentDocument_Impl( SfxObjectShell *pDoc )
//STRIP001 {
//STRIP001 	pImp->pCurrentObjectShell = pDoc;
//STRIP001 }

/*N*/ void SfxFrame::SetCurrentViewFrame_Impl( SfxViewFrame *pFrame )
/*N*/ {
/*N*/ 	pImp->pCurrentViewFrame = pFrame;
/*N*/ }

/*N*/ sal_uInt32 SfxFrame::GetFrameType() const
/*N*/ {
/*N*/ 	return pImp->nType;
/*N*/ }

/*N*/ void SfxFrame::SetFrameType_Impl( sal_uInt32 n )
/*N*/ {
/*N*/ 	pImp->nType = n;
/*N*/ }

//STRIP001 void SfxFrame::CopyHistory_Impl( SfxFrame *pFrame ) const
//STRIP001 {
//STRIP001 }


//STRIP001 void SfxFrame::ClearHistory()
//STRIP001 {
//STRIP001 }

//STRIP001 sal_Bool SfxFrame::ExecuteHistoryMenu_Impl( sal_uInt16 nWhich, const Rectangle& rRect, sal_uInt16 nFlags )
//STRIP001 {
//STRIP001 	return sal_True;
//STRIP001 }

//STRIP001 sal_Bool SfxFrame::Browse( sal_Bool bForward, sal_uInt16 nSteps, sal_Bool bNewFrame )
//STRIP001 {
//STRIP001     return FALSE;
//STRIP001 }

//STRIP001 void SfxFrame::UpdatePickEntries()
//STRIP001 {
//STRIP001 }

//STRIP001 void SfxFrame::UpdatePickEntries( const ::com::sun::star::uno::Any& rValue )
//STRIP001 {
//STRIP001 }

//STRIP001 void SfxFrame::UpdateUndoHistory_Impl( SfxObjectShell *pDocSh, const String* pNew, const String* pTitle )
//STRIP001 {
//STRIP001 }

//STRIP001 void SfxFrame::UpdateCurrentHistory_Impl( SfxObjectShell *pDocSh, const String* pNew  )
//STRIP001 {
//STRIP001 }

/*N*/ void SfxFrame::UpdateHistory( SfxObjectShell *pDocSh, const String* pNew  )
/*N*/ {
/*N*/ }

//STRIP001 void SfxFrame::UpdateHistory( const ::rtl::OUString& aURL, const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& aArgs, const ::rtl::OUString& rTitle  )
//STRIP001 {
//STRIP001 }

//STRIP001 void SfxFrame::GetViewData_Impl()
//STRIP001 {
//STRIP001 	// Alle zwischen Laden und Entfernen "anderbaren Daten aktualisieren; die
//STRIP001 	// festen Daten werden nur einmal ( nach InsertDocument in UpdateDescriptor )
//STRIP001 	// geholt, um Zeit zu sparen.
//STRIP001 	SfxViewFrame* pViewFrame = GetCurrentViewFrame();
//STRIP001 	if( pViewFrame && pViewFrame->GetViewShell() )
//STRIP001 	{
//STRIP001 		const SfxMedium *pMed = GetCurrentDocument()->GetMedium();
//STRIP001 		sal_Bool bReadOnly = pMed->GetOpenMode() == SFX_STREAM_READONLY;
//STRIP001 		GetDescriptor()->SetReadOnly( bReadOnly );
//STRIP001 
//STRIP001 		String aUserData;
//STRIP001 		pViewFrame->GetViewShell()->WriteUserData( aUserData, sal_True );
//STRIP001 		SfxItemSet *pSet = GetDescriptor()->GetArgs();
//STRIP001 		pSet->Put( SfxStringItem( SID_USER_DATA, aUserData ));
//STRIP001 		sal_Bool bGetViewData = sal_False;
//STRIP001 		if ( GetController().is() && pSet->GetItemState( SID_VIEW_DATA ) != SFX_ITEM_SET )
//STRIP001 		{
//STRIP001 			::com::sun::star::uno::Any aData = GetController()->getViewData();
//STRIP001             pSet->Put( SfxUsrAnyItem( SID_VIEW_DATA, aData ) );
//STRIP001 			bGetViewData = sal_True;
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( pViewFrame->GetCurViewId() )
//STRIP001 			pSet->Put( SfxUInt16Item( SID_VIEW_ID, pViewFrame->GetCurViewId() ) );
//STRIP001 		if ( pChildArr )
//STRIP001 		{
//STRIP001 			// Bei Framesets m"ussen auch die Daten der ChildViews geholt werden
//STRIP001 			sal_uInt16 nCount = pChildArr->Count();
//STRIP001 			for ( sal_uInt16 n=nCount; n>0; n--)
//STRIP001 			{
//STRIP001 				SfxFrame* pFrame = (*pChildArr)[n-1];
//STRIP001 				if ( bGetViewData )
//STRIP001 					pFrame->GetDescriptor()->GetArgs()->ClearItem( SID_VIEW_DATA );
//STRIP001 				pFrame->GetViewData_Impl();
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*N*/ void SfxFrame::UpdateDescriptor( SfxObjectShell *pDoc )
/*N*/ {
/*N*/ 	// Beim InsertDocument wird der Descriptor des Frames aktualisiert
/*N*/ 	// und sein ItemSet neu initialisiert. Alle Daten, die f"ur ein sp"ateres
/*N*/ 	// Restaurieren der ::com::sun::star::sdbcx::View n"otig sind, sind damit festgehalten.
/*N*/ 	// Soll das Dokument ersetzt werden, wird durch GetViewData_Impl (s.o.)
/*N*/ 	// die neueste Information hinzugef"ugt. Alles zusammen wird dann in der
/*N*/ 	// Browse-History gesichert. Beim Aktivieren eines solchen FramePickEntry
/*N*/ 	// wird das komplette ItemSet und der Descriptor im OpenDoc mitgeschickt.
/*N*/ 	// Hier werden nur die festen Eigenschaften gesichert; die "anderbaren werden
/*N*/ 	// durch GetViewData geholt ( spart Zeit ).
/*N*/ 	DBG_ASSERT( pDoc, "NULL-Document inserted ?!" );
/*N*/ 
/*N*/ 	SfxFrame *pParent = GetParentFrame();
/*N*/ 	const SfxMedium *pMed = pDoc->GetMedium();
/*N*/ 	GetDescriptor()->SetActualURL( pMed->GetOrigURL() );
/*N*/ 
/*N*/ 	SFX_ITEMSET_ARG( pMed->GetItemSet(), pItem, SfxBoolItem, SID_EDITDOC, sal_False );
/*N*/ 	sal_Bool bEditable = ( !pItem || pItem->GetValue() );
/*N*/ 
/*N*/ 	GetDescriptor()->SetEditable( bEditable );
/*N*/ 
/*N*/ 	// FileOpen-Parameter merken
/*N*/ 	SfxItemSet* pItemSet = pMed->GetItemSet();
/*N*/ 	String aName( pMed->GetName() );
/*N*/ 
/*N*/ 	const SfxFilter* pFilter = pMed->GetOrigFilter();
/*N*/ 	String aFilter;
/*N*/ 	if ( pFilter )
/*N*/         aFilter = pFilter->GetFilterName();
/*N*/ 
/*N*/ 	SFX_ITEMSET_ARG( pItemSet, pRefererItem, SfxStringItem, SID_REFERER, sal_False);
/*N*/ 	SFX_ITEMSET_ARG( pItemSet, pOptionsItem, SfxStringItem, SID_FILE_FILTEROPTIONS, sal_False);
/*N*/ 	SFX_ITEMSET_ARG( pItemSet, pTitle1Item, SfxStringItem, SID_DOCINFO_TITLE, sal_False);
/*N*/ 
/*N*/ 	SfxItemSet *pSet = GetDescriptor()->GetArgs();
/*N*/ 
/*N*/ 	// Alle alten Items l"oschen
/*N*/ 	pSet->ClearItem();
/*N*/ 
/*N*/ 	if ( pRefererItem )
/*N*/ 		pSet->Put( *pRefererItem );
/*N*/ 	else
/*N*/ 		pSet->Put( SfxStringItem( SID_REFERER, String() ) );
/*N*/ 
/*N*/ 	if ( pOptionsItem )
/*?*/ 		pSet->Put( *pOptionsItem );
/*N*/ 
/*N*/ 	if ( pTitle1Item )
/*?*/ 		pSet->Put( *pTitle1Item );
/*N*/ 
/*N*/ 	pSet->Put( SfxStringItem( SID_FILTER_NAME, aFilter ));
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ sal_Bool SfxFrame::CanBrowseBackward() const
/*N*/ {
/*N*/     return FALSE;
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ sal_Bool SfxFrame::CanBrowseForward() const
/*N*/ {
/*N*/     return FALSE;
/*N*/ }

//-------------------------------------------------------------------------

//STRIP001 void SfxFrame::SetDescriptor( SfxFrameDescriptor *pD )
//STRIP001 {
//STRIP001 	DBG_ASSERT( pD, "Kein Descriptor!" );
//STRIP001 	DBG_ASSERT( pD != pImp->pDescr, "Descriptor ist schon gesetzt!" );
//STRIP001 
//STRIP001 	if ( pImp->pDescr )
//STRIP001 	{
//STRIP001 		sal_uInt16 nPos = pImp->pDescr->GetItemPos();
//STRIP001 		SfxFrameSetDescriptor *pSet = pImp->pDescr->GetParent();
//STRIP001 
//STRIP001 		// Nur TopLevel-Frames verwalten ihren Descriptor selbst, bei den
//STRIP001 		// anderen tut es das Frameset
//STRIP001 		if ( !pParentFrame )
//STRIP001 			delete pImp->pDescr;
//STRIP001 		if ( pSet && !pD->GetParent() )
//STRIP001 		{
//STRIP001 			pSet->RemoveFrame( pImp->pDescr );
//STRIP001 			pSet->InsertFrame( pD, nPos );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	pImp->pDescr = pD;
//STRIP001 }

//-------------------------------------------------------------------------

/*N*/ SfxFrameDescriptor* SfxFrame::GetDescriptor() const
/*N*/ {
/*N*/ 	// On Demand einen FrameDescriptor anlegen; wenn es kein TopLevel-Frame
/*N*/ 	// ist, f"uhrt es zu Fehlern, da keine g"ulige Verkettung hergestellt wird
/*N*/ 
/*N*/ 	if ( !pImp->pDescr )
/*N*/ 	{
/*N*/ 		DBG_ASSERT( !GetParentFrame(), "Kein TopLevel-Frame, aber kein Descriptor!" );
/*N*/ 		pImp->pDescr = new SfxFrameDescriptor( NULL );
/*N*/ 		if ( GetCurrentDocument() )
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pImp->pDescr->SetURL( GetCurrentDocument()->GetMedium()->GetOrigURL() );
/*N*/ 	}
/*N*/ 	return pImp->pDescr;
/*N*/ }

//STRIP001 sal_Bool SfxFrame::TransferForReplaceInProgress() const
//STRIP001 {
//STRIP001     return pImp->pLoadEnv && pImp->pLoadEnv->GetObjectShell() != GetCurrentDocument();
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 void SfxFrame::GetTargetList( TargetList& rList ) const
//STRIP001 {
//STRIP001 	if ( !GetParentFrame() )
//STRIP001 	{
//STRIP001 		// Einen Leerstring f"ur 'Kein Target'
//STRIP001 		rList.Insert( new String() );
//STRIP001 		rList.Insert( new String( DEFINE_CONST_UNICODE( "_top" ) ) );
//STRIP001 		rList.Insert( new String( DEFINE_CONST_UNICODE( "_parent" ) ) );
//STRIP001 		rList.Insert( new String( DEFINE_CONST_UNICODE( "_blank" ) ) );
//STRIP001 		rList.Insert( new String( DEFINE_CONST_UNICODE( "_self" ) ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	SfxViewFrame* pView = GetCurrentViewFrame();
//STRIP001 	if( pView && pView->GetViewShell() && !pView->GetViewShell()->IsImplementedAsFrameset_Impl() && pChildArr )
//STRIP001 	{
//STRIP001 		sal_uInt16 nCount = pChildArr->Count();
//STRIP001 		for ( sal_uInt16 n=0; n<nCount; n++)
//STRIP001 		{
//STRIP001 			SfxFrame* pFrame = (*pChildArr)[n];
//STRIP001 			if ( pFrame->GetFrameName().Len() )
//STRIP001 				rList.Insert( new String (pFrame->GetFrameName()) );
//STRIP001 			pFrame->GetTargetList( rList );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 void SfxFrame::SetFrameId_Impl( sal_uInt16 nId )
//STRIP001 {
//STRIP001 	pImp->nFrameId = nId;
//STRIP001 	if ( GetCurrentViewFrame() )
//STRIP001 		GetCurrentViewFrame()->UpdateTitle();
//STRIP001 }

//STRIP001 sal_uInt16 SfxFrame::GetFrameId_Impl() const
//STRIP001 {
//STRIP001 	return pImp->nFrameId;
//STRIP001 }

//STRIP001 void SfxFrame::SetFrameIdName_Impl( const String& rName )
//STRIP001 {
//STRIP001 	pImp->aFrameIdName = rName;
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 SfxFrame* SfxFrame::SearchFrame_Impl( sal_uInt16 nId, sal_Bool bDeep )
//STRIP001 {
//STRIP001 	if ( pImp->nFrameId == nId )
//STRIP001 		return this;
//STRIP001 
//STRIP001 	if ( pChildArr )
//STRIP001 	{
//STRIP001 		sal_uInt16 nCount = pChildArr->Count();
//STRIP001 		for ( sal_uInt16 n=0; n<nCount; n++)
//STRIP001 		{
//STRIP001 			SfxFrame* pFrame = (*pChildArr)[n];
//STRIP001 			if ( pFrame->pImp->nFrameId == nId )
//STRIP001 				return pFrame;
//STRIP001 			if ( bDeep )
//STRIP001 			{
//STRIP001 				pFrame = pFrame->SearchFrame_Impl( nId, sal_True );
//STRIP001 				if ( pFrame )
//STRIP001 					return pFrame;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return NULL;
//STRIP001 }

//STRIP001 SfxFrame* SfxFrame::SearchFrame_Impl( const String& rName, sal_Bool bDeep )
//STRIP001 {
//STRIP001 	if ( pImp->aFrameIdName == rName )
//STRIP001 		return this;
//STRIP001 
//STRIP001 	if ( pChildArr )
//STRIP001 	{
//STRIP001 		sal_uInt16 nCount = pChildArr->Count();
//STRIP001 		for ( sal_uInt16 n=0; n<nCount; n++)
//STRIP001 		{
//STRIP001 			SfxFrame* pFrame = (*pChildArr)[n];
//STRIP001 			if ( pFrame->pImp->aFrameIdName == rName )
//STRIP001 				return pFrame;
//STRIP001 			if ( bDeep )
//STRIP001 			{
//STRIP001 				pFrame = pFrame->SearchFrame_Impl( rName );
//STRIP001 				if ( pFrame )
//STRIP001 					return pFrame;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return NULL;
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 SfxViewFrame* SfxFrame::ActivateChildFrame_Impl()
//STRIP001 {
//STRIP001 	// Irgendeinen ChildFrame suchen, der aktiviert werden kann
//STRIP001     BOOL bSetFocus = GetCurrentViewFrame() && GetCurrentViewFrame()->GetViewShell()->GetWindow()->HasChildPathFocus( TRUE );
//STRIP001 	for ( sal_uInt16 n=0; n<GetChildFrameCount(); n++ )
//STRIP001 	{
//STRIP001 		// Wenn es ein ViewFrame ohne FrameSet ist, aktivieren
//STRIP001 		SfxFrame *pAct = GetChildFrame(n);
//STRIP001 		SfxViewFrame *pViewFrm = pAct->GetCurrentViewFrame();
//STRIP001 		if ( pViewFrm && !( pAct->GetFrameType() & SFXFRAME_FRAMESET ) &&
//STRIP001 								pViewFrm->GetObjectShell() )
//STRIP001                 pViewFrm->MakeActive_Impl( bSetFocus );
//STRIP001 		else
//STRIP001 			pViewFrm = pAct->ActivateChildFrame_Impl();
//STRIP001 		if ( pViewFrm )
//STRIP001 			return pViewFrm;
//STRIP001 	}
//STRIP001 
//STRIP001 	return NULL;
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 void SfxFrame::Activate_Impl( sal_Bool bBeamerOn )

/*  [Description]

	Internal Activate-Handler, called from derived classes which supports
	Activate-Handling.
*/

//STRIP001 {
//STRIP001     if ( GetParentFrame() )
//STRIP001         GetParentFrame()->Activate_Impl( bBeamerOn );
//STRIP001 }

/*N*/ SfxBroadcaster& SfxFrame::GetBroadcaster() const
/*N*/ {
/*N*/ 	return *pImp;
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxFrame::Deactivate_Impl()

/*  [Description]

	Internal Deactivate-Handler, called from derived classes which supports
	Activate-Handling.
*/

/*N*/ {
/*N*/     if( GetParentFrame() )
/*?*/         GetParentFrame()->Deactivate_Impl();
/*N*/ }

//STRIP001 String SfxFrame::GetContent() const
//STRIP001 {
//STRIP001 	SfxObjectShell *pObj = GetCurrentDocument();
//STRIP001 	if ( !pObj || !pObj->GetMedium() )
//STRIP001 		return String();
//STRIP001 	else
//STRIP001 		return pObj->GetMedium()->GetName();
//STRIP001 }

//STRIP001 sal_Bool SfxFrame::CheckContentForLoad_Impl()
//STRIP001 {
//STRIP001 	if ( GetCurrentDocument() )
//STRIP001 	{
//STRIP001 		SfxMedium* pMedium = GetCurrentDocument()->GetMedium();
//STRIP001 		SfxItemSet* pSet = pMedium->GetItemSet();
//STRIP001 		SfxItemSet* pNew = GetDescriptor()->GetArgs();
//STRIP001 
//STRIP001 		// Falls URLs nicht uebereinstimmen
//STRIP001         if ( INetURLObject( GetDescriptor()->GetActualURL() ) != INetURLObject( pMedium->GetOrigURL() ) )
//STRIP001 			return sal_True;
//STRIP001 
//STRIP001 		// Falls die Filter nicht uebereinstimmen
//STRIP001 		SFX_ITEMSET_ARG( pNew, pFilterItem, SfxStringItem, SID_FILTER_NAME, sal_False );
//STRIP001         if( pMedium->GetOrigFilter() && pFilterItem && pFilterItem->GetValue() != pMedium->GetOrigFilter()->GetFilterName() )
//STRIP001 			return sal_True;
//STRIP001 
//STRIP001 		return sal_False;
//STRIP001 	}
//STRIP001 
//STRIP001 	return (GetDescriptor()->GetActualURL().GetMainURL( INetURLObject::NO_DECODE ).Len() != 0);
//STRIP001 }

/*N*/ sal_Bool SfxFrame::IsParent( SfxFrame *pFrame ) const
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	SfxFrame *pParent = pParentFrame;
//STRIP001 	while ( pParent )
//STRIP001 	{
//STRIP001 		if ( pParent == pFrame )
//STRIP001 			return sal_True;
//STRIP001 		pParent = pParent->pParentFrame;
//STRIP001 	}
//STRIP001 
/*N*/ 	return sal_False;
/*N*/ }

/*N*/ void SfxFrame::InsertTopFrame_Impl( SfxFrame* pFrame )
/*N*/ {
/*N*/ 	SfxFrameArr_Impl& rArr = *SFX_APP()->Get_Impl()->pTopFrames;
/*N*/ 	rArr.Insert( pFrame, rArr.Count() );
/*N*/ }

/*N*/ void SfxFrame::RemoveTopFrame_Impl( SfxFrame* pFrame )
/*N*/ {
/*N*/ 	SfxFrameArr_Impl& rArr = *SFX_APP()->Get_Impl()->pTopFrames;
/*N*/ 	rArr.Remove( rArr.GetPos( pFrame ) );
/*N*/ }

//STRIP001 SfxFrameItem::SfxFrameItem( sal_uInt16 nWhich, SfxViewFrame *p )
//STRIP001 	: SfxPoolItem( nWhich ), pFrame( p ? p->GetFrame() : NULL )
//STRIP001 {
//STRIP001 	wFrame = pFrame;
//STRIP001 }

/*N*/ int SfxFrameItem::operator==( const SfxPoolItem &rItem ) const
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); return 0; //STRIP001 
//STRIP001 	 return ((SfxFrameItem&)rItem).pFrame == pFrame &&
//STRIP001 		 ((SfxFrameItem&)rItem).wFrame == wFrame;
/*N*/ }

//--------------------------------------------------------------------

//STRIP001 String SfxFrameItem::GetValueText() const
//STRIP001 {
//STRIP001 	return String();
//STRIP001 }

/*N*/ SfxPoolItem* SfxFrameItem::Clone( SfxItemPool *) const
/*N*/ {
/*N*/ 	SfxFrameItem* pNew = new SfxFrameItem( wFrame);
/*N*/ 	pNew->SetFramePtr_Impl( pFrame );
/*N*/ 	return pNew;
/*N*/ }

/*N*/ SfxUsrAnyItem::SfxUsrAnyItem( sal_uInt16 nWhich, const ::com::sun::star::uno::Any& rAny )
/*N*/ 	: SfxPoolItem( nWhich )
/*N*/ {
/*N*/ 	aValue = rAny;
/*N*/ }

/*N*/ int SfxUsrAnyItem::operator==( const SfxPoolItem &rItem ) const
/*N*/ {
/*N*/ //   return rItem.ISA( SfxUsrAnyItem ) && ((SfxUsrAnyItem&)rItem).aValue == aValue;
/*N*/ 	return sal_False;
/*N*/ }

//STRIP001 String SfxUsrAnyItem::GetValueText() const
//STRIP001 {
//STRIP001 	return String();
//STRIP001 }

/*N*/ SfxPoolItem* SfxUsrAnyItem::Clone( SfxItemPool *) const
/*N*/ {
/*N*/     return new SfxUsrAnyItem( Which(), aValue );
/*N*/ }

//STRIP001 sal_Bool SfxFrame::BrowseInFrame( int nDelta )
//STRIP001 {
//STRIP001 	return sal_False;
//STRIP001 }

//STRIP001 SfxFrameIterator::SfxFrameIterator( const SfxFrame& rFrame, sal_Bool bRecur )
//STRIP001 	: pFrame( &rFrame )
//STRIP001 	, bRecursive( bRecur )
//STRIP001 {}

//STRIP001 SfxFrame* SfxFrameIterator::FirstFrame()
//STRIP001 {
//STRIP001 	// GetFirst beginnt die Iteration beim ersten ChildFrame
//STRIP001 	return pFrame->GetChildFrame( 0 );
//STRIP001 }

//STRIP001 SfxFrame* SfxFrameIterator::NextFrame( SfxFrame& rPrev )
//STRIP001 {
//STRIP001 	// Zuerst auf Kinder testen, wenn Rekursion erw"unscht
//STRIP001 	SfxFrame *pRet = NULL;
//STRIP001 	if ( bRecursive )
//STRIP001 		pRet = rPrev.GetChildFrame( 0 );
//STRIP001 	if ( !pRet )
//STRIP001 	{
//STRIP001 		// Anderenfalls mit den Geschwistern von rPrev weitermachen
//STRIP001 		pRet = NextSibling_Impl( rPrev );
//STRIP001 	}
//STRIP001 
//STRIP001 	return pRet;
//STRIP001 }


//STRIP001 SfxFrame* SfxFrameIterator::NextSibling_Impl( SfxFrame& rPrev )
//STRIP001 {
//STRIP001 	SfxFrame *pRet = NULL;
//STRIP001 	if ( &rPrev != pFrame )
//STRIP001 	{
//STRIP001 		SfxFrameArr_Impl& rArr = *rPrev.pParentFrame->pChildArr;
//STRIP001 		sal_uInt16 nPos = rArr.GetPos( &rPrev );
//STRIP001 		if ( nPos+1 < rArr.Count() )
//STRIP001 			pRet = rArr[nPos+1];
//STRIP001 
//STRIP001 		if ( !pRet && rPrev.pParentFrame->pParentFrame )
//STRIP001 			pRet = NextSibling_Impl( *rPrev.pParentFrame );
//STRIP001 	}
//STRIP001 
//STRIP001 	return pRet;
//STRIP001 }

//STRIP001 void SfxFrame::SetFrameName( const String& rName )
//STRIP001 {
//STRIP001 	if ( pImp->pDescr )
//STRIP001 		pImp->pDescr->SetName( rName );
//STRIP001 	aName = rName;
//STRIP001 	if ( pImp->pCurrentViewFrame )
//STRIP001 		pImp->pCurrentViewFrame->UpdateTitle();
//STRIP001     if ( GetFrameInterface().is() )
//STRIP001         GetFrameInterface()->setName( rName );
//STRIP001 }

//STRIP001 void SfxFrame::BeamerSwitched_Impl( sal_Bool bOn )
//STRIP001 {
//STRIP001 }

//STRIP001 void SfxFrame::BeamerSet_Impl()
//STRIP001 {
//STRIP001 }

//STRIP001 void SfxFrame::LoadFinished_Impl()
//STRIP001 {
//STRIP001 	SfxURLFrame *pURL = PTR_CAST( SfxURLFrame, this );
//STRIP001 	if ( pURL )
//STRIP001 		pURL->LoadFinished_Impl();
//STRIP001 }

//STRIP001 SfxFrame* SfxFrame::findFrame(const ::rtl::OUString& aTargetframename, sal_Int32 nSearchFlags)
//STRIP001 {
//STRIP001 	// Weil Netscape f"uhrende BLANKS "uberliest, m"ussen wir das wohl auch
//STRIP001 	// Sollte besser auch bei den FrameNames gemacht werden!
//STRIP001 	String aName( aTargetframename );
//STRIP001 	aName.EraseLeadingChars();
//STRIP001 
//STRIP001 	SfxFrame *pFrame = this;
//STRIP001 
//STRIP001 	if ( !aName.Len() && GetParentFrame() && GetParentFrame()->GetCurrentViewFrame()->GetViewShell()->IsImplementedAsFrameset_Impl() )
//STRIP001 		return GetParentFrame();
//STRIP001 
//STRIP001 	if( !aName.Len() || aName.CompareIgnoreCaseToAscii("_self") == COMPARE_EQUAL )
//STRIP001 		return pFrame;
//STRIP001 
//STRIP001 	if (  aName.CompareIgnoreCaseToAscii("_smartself") == COMPARE_EQUAL )
//STRIP001 	{
//STRIP001         DBG_ERROR("Not supported!");
//STRIP001         return pFrame;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( aName.CompareIgnoreCaseToAscii("_parent") == COMPARE_EQUAL )
//STRIP001 	{
//STRIP001 		// Gesucht ist das Parent Frameset
//STRIP001 		return pFrame->GetParentFrame();
//STRIP001 	}
//STRIP001 	else if ( aName.CompareIgnoreCaseToAscii("_blank") == COMPARE_EQUAL )
//STRIP001 	{
//STRIP001 		return NULL;
//STRIP001 
//STRIP001 	}
//STRIP001 	else if ( aName.CompareIgnoreCaseToAscii("_top") == COMPARE_EQUAL )
//STRIP001 	{
//STRIP001 		while ( pFrame->GetParentFrame() )
//STRIP001 			pFrame = pFrame->GetParentFrame();
//STRIP001 		return pFrame;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( ( nSearchFlags & FRAME_SEARCH_SELF ) && aName.CompareIgnoreCaseToAscii( GetFrameName() ) == COMPARE_EQUAL )
//STRIP001 	{
//STRIP001 		// Eigener Name
//STRIP001 		return pFrame;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( nSearchFlags & FRAME_SEARCH_CHILDREN )
//STRIP001 	{
//STRIP001 		// Zuerst unterhalb dieses Frames absuchen
//STRIP001 		pFrame = SearchChildrenForName_Impl( aName );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( ( nSearchFlags & FRAME_SEARCH_CHILDREN ) && !pFrame && GetParentFrame() )
//STRIP001 	{
//STRIP001 		// Noch nichts gefunden, nach oben weitergehen
//STRIP001 		// Eigentlich m"u\sten Frames, die schon abgesucht wurden, aus
//STRIP001 		// Performance-Gr"unden markiert werden
//STRIP001 		SfxFrame *pParent = GetParentFrame();
//STRIP001 		do
//STRIP001 		{
//STRIP001 			// Ist es der Parent ?
//STRIP001 			if ( aName.CompareIgnoreCaseToAscii( pParent->GetFrameName() ) == COMPARE_EQUAL )
//STRIP001 				return pParent;
//STRIP001 
//STRIP001 			if ( pParent->pImp->pDescr->GetFrameSet() )
//STRIP001 			{
//STRIP001 				// Wenn es ein Parent Frameset gibt, dort suchen
//STRIP001 				pFrame = pParent->SearchChildrenForName_Impl( aName );
//STRIP001 				if ( pFrame )
//STRIP001 					return pFrame;
//STRIP001 			}
//STRIP001 
//STRIP001 			// Weiter nach oben
//STRIP001 			pParent = pParent->GetParentFrame();
//STRIP001 		}
//STRIP001 		while ( pParent );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( !pFrame )
//STRIP001 	{
//STRIP001 		SfxFrameArr_Impl& rArr = *SFX_APP()->Get_Impl()->pTopFrames;
//STRIP001 		// keinen Frame im MDI-Fenster gefunden. Jetzt die anderen
//STRIP001 		// Toplevel Frames checken.
//STRIP001 		SfxFrame *pTop = GetTopFrame();
//STRIP001 		for( sal_uInt16 nPos = rArr.Count(); nPos--; )
//STRIP001 		{
//STRIP001 			 // Unser Topframe wurde bereits durchsucht
//STRIP001 			SfxFrame* pCurFrame = rArr[ nPos ];
//STRIP001 			if(  pCurFrame != pTop )
//STRIP001 			{
//STRIP001 				if( aName.CompareIgnoreCaseToAscii( pCurFrame->GetFrameName() ) == COMPARE_EQUAL )
//STRIP001 					return pCurFrame;
//STRIP001 				else
//STRIP001 				{
//STRIP001 					if( pFrame =
//STRIP001 						pCurFrame->SearchChildrenForName_Impl( aName ) )
//STRIP001 						return pFrame;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return pFrame;
//STRIP001 }

/*N*/ sal_Bool SfxFrame::IsTop() const
/*N*/ {
/*N*/     return GetFrameInterface().is() ? GetFrameInterface()->isTop() : sal_False;
/*N*/ }

/*N*/ sal_Bool SfxFrame::HasComponent() const
/*N*/ {
/*N*/     return sal_False;
/*N*/ }

/*N*/ ::com::sun::star::uno::Reference< ::com::sun::star::frame::XController > SfxFrame::GetController() const
/*N*/ {
/*N*/     if ( pImp->pCurrentViewFrame && pImp->pCurrentViewFrame->GetViewShell() )
/*N*/         return pImp->pCurrentViewFrame->GetViewShell()->GetController();
/*N*/     else
/*N*/         return ::com::sun::star::uno::Reference< ::com::sun::star::frame::XController > ();
/*N*/ }

/*N*/ ::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame >  SfxFrame::GetFrameInterface() const
/*N*/ {
/*N*/     return pImp->xFrame;
/*N*/ }

/*N*/ void SfxFrame::SetFrameInterface_Impl( ::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame >& rFrame )
/*N*/ {
/*N*/     pImp->xFrame = rFrame;
/*N*/     ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchRecorder > xRecorder;
/*N*/ 	if ( !rFrame.is() && GetCurrentViewFrame() )
/*N*/ 		GetCurrentViewFrame()->GetBindings().SetRecorder_Impl( xRecorder );
/*N*/ }

/*N*/ void SfxFrame::SetItemSet_Impl( const SfxItemSet* pSet )
/*N*/ {
/*N*/ 	pImp->pSet = pSet;
/*N*/ }

/*N*/ const SfxItemSet* SfxFrame::GetItemSet_Impl()
/*N*/ {
/*N*/ 	return pImp->pSet;
/*N*/ }

//STRIP001 void SfxFrame::Appear()
//STRIP001 {
//STRIP001 	if ( GetCurrentViewFrame() )
//STRIP001 	{
//STRIP001 		GetCurrentViewFrame()->Show();
//STRIP001         GetWindow().Show();
//STRIP001         pImp->xFrame->getContainerWindow()->setVisible( sal_True );
//STRIP001 		if ( pParentFrame )
//STRIP001 			pParentFrame->Appear();
//STRIP001         Reference < ::com::sun::star::awt::XTopWindow > xTopWindow( pImp->xFrame->getContainerWindow(), UNO_QUERY );
//STRIP001         if ( xTopWindow.is() )
//STRIP001             xTopWindow->toFront();
//STRIP001 	}
//STRIP001 }

//STRIP001 sal_uInt16 SfxFrame::GetBeamerState_Impl() const
//STRIP001 {
//STRIP001 	return pImp->nHasBrowser;
//STRIP001 }

/*N*/ void SfxFrame::SetOwnsBindings_Impl( sal_Bool bSet )
/*N*/ {
/*N*/ 	pImp->bOwnsBindings = bSet;
/*N*/ }

/*N*/ sal_Bool SfxFrame::OwnsBindings_Impl() const
/*N*/ {
/*N*/ 	return pImp->bOwnsBindings;
/*N*/ }

/*N*/ void SfxFrame::SetToolSpaceBorderPixel_Impl( const SvBorder& rBorder )
/*N*/ {
/*N*/     pImp->aBorder = rBorder;
/*N*/     SfxViewFrame *pF = GetCurrentViewFrame();
/*N*/     if ( pF )
/*N*/     {
/*N*/         Point aPos ( rBorder.Left(), rBorder.Top() );
/*N*/         Size aSize( GetWindow().GetOutputSizePixel() );
/*N*/         long nDeltaX = rBorder.Left() + rBorder.Right();
/*N*/         if ( aSize.Width() > nDeltaX )
/*N*/             aSize.Width() -= nDeltaX;
/*N*/         else
/*N*/             aSize.Width() = 0;
/*N*/ 
/*N*/         long nDeltaY = rBorder.Top() + rBorder.Bottom();
/*N*/         if ( aSize.Height() > nDeltaY )
/*N*/             aSize.Height() -= nDeltaY;
/*N*/         else
/*N*/             aSize.Height() = 0;
/*N*/ 
/*N*/         if ( GetParentFrame() )
/*N*/         {
/*?*/             sal_Bool bHasTools = rBorder.Left() != rBorder.Right() || rBorder.Top() != rBorder.Bottom();
/*?*/             pF->GetWindow().SetBorderStyle( bHasTools ? WINDOW_BORDER_NORMAL : WINDOW_BORDER_NOBORDER );
/*N*/         }
/*N*/ 
/*N*/         pF->GetWindow().SetPosSizePixel( aPos, aSize );
/*N*/     }
/*N*/ }

/*N*/ Rectangle SfxFrame::GetTopOuterRectPixel_Impl() const
/*N*/ {
/*N*/ 	Size aSize( GetWindow().GetOutputSizePixel() );
/*N*/ 	Point aPoint;
/*N*/ 	return ( Rectangle ( aPoint, aSize ) );
/*N*/ }

/*N*/ SfxWorkWindow* SfxFrame::GetWorkWindow_Impl() const
/*N*/ {
/*N*/ 	if ( pImp->pWorkWin )
/*N*/ 		return pImp->pWorkWin;
/*N*/ 	else if ( pParentFrame )
/*?*/ 		return pParentFrame->GetWorkWindow_Impl();
/*N*/     else
/*N*/         return NULL;
/*N*/ }

//STRIP001 void SfxFrame::SetWorkWindow_Impl( SfxWorkWindow* pWorkwin )
//STRIP001 {
//STRIP001     pImp->pWorkWin = pWorkwin;
//STRIP001 }

/*N*/ void SfxFrame::CreateWorkWindow_Impl()
/*N*/ {
/*N*/ 	pImp->pWorkWin = new SfxFrameWorkWin_Impl( &GetWindow(), this );
/*N*/ }

//STRIP001 const SvBorder& SfxFrame::GetBorder_Impl() const
//STRIP001 {
//STRIP001 	return pImp->aBorder;
//STRIP001 }

/*N*/ void SfxFrame::GrabFocusOnComponent_Impl()
/*N*/ {
/*N*/ 	if ( pImp->bReleasingComponent )
/*N*/ 	{
/*?*/ 		GetWindow().GrabFocus();
/*?*/ 		return;
/*N*/ 	}
/*N*/ 
/*N*/     Window* pWindow = &GetWindow();
/*N*/     if ( GetCurrentViewFrame() && GetCurrentViewFrame()->GetViewShell() && GetCurrentViewFrame()->GetViewShell()->GetWindow() )
/*N*/         pWindow = GetCurrentViewFrame()->GetViewShell()->GetWindow();
/*N*/ 
/*N*/     if( !pWindow->HasChildPathFocus() )
/*N*/         pWindow->GrabFocus();
/*N*/ }

//STRIP001 void SfxFrame::ReFill_Impl( const SfxFrameSetDescriptor* pSet )
//STRIP001 {
//STRIP001 	SfxFrameSetViewShell *pView = PTR_CAST( SfxFrameSetViewShell, GetCurrentViewFrame()->GetViewShell() );
//STRIP001 	if ( pView )
//STRIP001 		pView->ReFill( pSet );
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SfxFrameSetDescriptor *pOld = pImp->pDescr->GetFrameSet();
//STRIP001 		SfxFrameSetDescriptor *pNew = pSet->Clone();
//STRIP001 		pImp->pDescr->SetFrameSet( pNew );
//STRIP001 		for ( sal_uInt16 n=0; n<pSet->GetFrameCount(); n++ )
//STRIP001 		{
//STRIP001 			SfxFrameDescriptor* pD = pNew->GetFrame(n);
//STRIP001 			SfxURLFrame* pFrame = PTR_CAST( SfxURLFrame, SearchChildrenForName_Impl( pD->GetName() ) );
//STRIP001 			if ( pFrame )
//STRIP001 				pFrame->Update( pD );
//STRIP001 			if ( pD->GetFrameSet() )
//STRIP001 				pFrame->ReFill_Impl( pD->GetFrameSet() );
//STRIP001 		}
//STRIP001 
//STRIP001 		delete pOld;
//STRIP001 	}
//STRIP001 }

//STRIP001 const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchProviderInterceptor >  SfxFrame::GetInterceptor_Impl()
//STRIP001 {
//STRIP001 //(mba)/compview: hier fehlt der Zugriff auf den Interceptor !!!!!
//STRIP001     return ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchProviderInterceptor > ();
//STRIP001 }

/*N*/ void SfxFrame::ReleasingComponent_Impl( sal_Bool bSet )
/*N*/ {
/*N*/ 	pImp->bReleasingComponent = bSet;
/*N*/ }

//STRIP001 sal_Bool SfxFrame::LoadSfxComponent( const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame > & aFrame, const ::rtl::OUString& aURL, const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& aArgs, const SfxObjectFactory *pFact )
//STRIP001 {
//STRIP001 	// get Implementation of xComponents ...
//STRIP001     DBG_ERROR( "Should not be called anymore!" );
//STRIP001     return sal_False;
//STRIP001 }

//STRIP001 void SfxFrame::LockFocus_Impl( sal_Bool bLock )
//STRIP001 {
//STRIP001 	if ( pChildArr && pChildArr->Count() )
//STRIP001 	{
//STRIP001 		sal_uInt16 nCount = pChildArr->Count();
//STRIP001 		for ( sal_uInt16 n=0; n<nCount; n++ )
//STRIP001 		{
//STRIP001 			SfxFrame* pFrame = (*pChildArr)[n];
//STRIP001 			pFrame->pImp->bFocusLocked = bLock;
//STRIP001 			pFrame->LockFocus_Impl( bLock );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 sal_Bool SfxFrame::IsFocusLocked_Impl() const
//STRIP001 {
//STRIP001 	return pImp->bFocusLocked;
//STRIP001 }

/*N*/ void SfxFrame::Resize()
/*N*/ {
/*N*/     if ( IsClosing_Impl() )
/*N*/         return;
/*N*/ 
/*N*/     if ( OwnsBindings_Impl() )
/*N*/ 	{
/*N*/         SfxWorkWindow *pWork = GetWorkWindow_Impl();
/*N*/         if ( pWork )
/*N*/         {
/*N*/             pWork->ArrangeChilds_Impl();
/*N*/             pWork->ShowChilds_Impl();
/*N*/         }
/*N*/ 
/*N*/         // problem in presence of UIActive object: when the window is resized, but the toolspace border
/*N*/         // remains the same, setting the toolspace border at the ContainerEnvironment doesn't force a
/*N*/         // resize on the IPEnvironment; without that no resize is called for the SfxViewFrame. So always
/*N*/         // set the window size of the SfxViewFrame explicit.
/*N*/         SetToolSpaceBorderPixel_Impl( pImp->aBorder );
/*N*/ 	}
/*N*/     else if ( pImp->pCurrentViewFrame )
/*N*/     {
/*?*/         pImp->pCurrentViewFrame->GetWindow().SetSizePixel( GetWindow().GetOutputSizePixel() );
/*N*/     }
/*N*/ 
/*N*/ }

/*N*/ SfxFrame* SfxFrame::GetFirst()
/*N*/ {
/*N*/     if ( !pFramesArr_Impl )
/*N*/         return 0;
/*N*/     return pFramesArr_Impl->Count() ? pFramesArr_Impl->GetObject(0) : 0;
/*N*/ }

/*N*/ SfxFrame* SfxFrame::GetNext( SfxFrame& rFrame )
/*N*/ {
/*N*/     USHORT nPos = pFramesArr_Impl->GetPos( &rFrame );
/*N*/     if ( nPos+1 < pFramesArr_Impl->Count() )
/*?*/         return pFramesArr_Impl->GetObject(nPos+1);
/*N*/     else
/*N*/         return NULL;
/*N*/ }

//STRIP001 const SfxPoolItem* SfxFrame::LoadDocumentSynchron( SfxItemSet& aSet )
//STRIP001 {
//STRIP001     aSet.Put( SfxFrameItem( SID_DOCFRAME, this ) );
//STRIP001     aSet.ClearItem( SID_TARGETNAME );
//STRIP001     return SFX_APP()->GetDispatcher_Impl()->Execute( SID_OPENDOC, SFX_CALLMODE_SYNCHRON, aSet );
//STRIP001 }

//STRIP001 void SfxFrame::CloseDocument_Impl()
//STRIP001 {
//STRIP001 	Reference < XFrame > xFrame( pImp->xFrame );
//STRIP001 	Window* pContainer = VCLUnoHelper::GetWindow( xFrame->getContainerWindow() );
//STRIP001 	pContainer->SetText( Application::GetDisplayName() );
//STRIP001 
//STRIP001 	Window* pWindow = new Window( pContainer, WB_BORDER );
//STRIP001 	pWindow->Show();
//STRIP001 	pWindow->SetBackground( Wallpaper( pWindow->GetSettings().GetStyleSettings().GetFaceColor() ) );
//STRIP001 	xFrame->setComponent(  VCLUnoHelper::GetInterface( pWindow ), Reference < XController >() );
//STRIP001 	String aMenuRes( RTL_CONSTASCII_USTRINGPARAM( "private:resource/" ));
//STRIP001 	aMenuRes += String::CreateFromInt32(RID_DEFAULTMENU);
//STRIP001 
//STRIP001 	URL aURL;
//STRIP001 	aURL.Complete = aMenuRes;
//STRIP001 
//STRIP001 	Reference< XURLTransformer >  xTrans ( ::legacy_binfilters::getLegacyProcessServiceFactory()->createInstance(
//STRIP001 						::rtl::OUString::createFromAscii("com.sun.star.util.URLTransformer") ), UNO_QUERY );
//STRIP001 	if( xTrans.is() )
//STRIP001 	{
//STRIP001 		// Datei laden
//STRIP001 		xTrans->parseStrict( aURL );
//STRIP001 
//STRIP001 		Reference < XDispatchProvider > xProv( xFrame, UNO_QUERY );
//STRIP001 		if ( xProv.is() )
//STRIP001 		{
//STRIP001 			Reference< XDispatch >  aDisp = xProv->queryDispatch( aURL,  ::rtl::OUString::createFromAscii("_menubar"), 12 );
//STRIP001 			if ( aDisp.is() )
//STRIP001 				aDisp->dispatch( aURL, Sequence< ::com::sun::star::beans::PropertyValue>() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

}
