/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_tpgradnt.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:10:42 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#pragma hdrstop

#ifndef _SV_WRKWIN_HXX
#include <vcl/wrkwin.hxx>
#endif
#ifndef _SHL_HXX
#include <tools/shl.hxx>
#endif
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include <svtools/pathoptions.hxx>
#endif
#ifndef _SFXAPP_HXX
#include <bf_sfx2/app.hxx>
#endif
#ifndef _FILEDLGHELPER_HXX
#include <bf_sfx2/filedlghelper.hxx>
#endif

#define _SVX_TPGRADNT_CXX
#define ITEMID_COLOR_TABLE		SID_COLOR_TABLE
#define ITEMID_GRADIENT_LIST	SID_GRADIENT_LIST

#include "dialogs.hrc"
#include "helpid.hrc"

#include "xattr.hxx"
#include "xtable.hxx"
#include "xpool.hxx"
#include "drawitem.hxx"
#include "tabarea.hxx"
#include "tabarea.hrc"
#include "dlgname.hxx"
#include "dlgname.hrc"
#include "dialmgr.hxx"
namespace binfilter {

//STRIP001 #define DLGWIN this->GetParent()->GetParent()

//STRIP001 #define BITMAP_WIDTH  32
//STRIP001 #define BITMAP_HEIGHT 12

/*************************************************************************
|*
|*	Dialog zum Aendern und Definieren der Farbverlaeufe
|*
\************************************************************************/

//STRIP001 SvxGradientTabPage::SvxGradientTabPage
//STRIP001 (
//STRIP001 	Window* pParent,
//STRIP001 	const SfxItemSet& rInAttrs
//STRIP001 ) :
//STRIP001 	SfxTabPage			( pParent, SVX_RES( RID_SVXPAGE_GRADIENT ), rInAttrs ),
//STRIP001 
//STRIP001 	pXPool				( (XOutdevItemPool*) rInAttrs.GetPool() ),
//STRIP001 	//XOut				( &aCtlPreview, pXPool ),
//STRIP001 	XOut				( &aCtlPreview ),
//STRIP001 	aXFillAttr			( pXPool ),
//STRIP001 	rXFSet				( aXFillAttr.GetItemSet() ),
//STRIP001 
//STRIP001 	aXFStyleItem		( XFILL_GRADIENT ),
//STRIP001 	aXGradientItem		( String(), XGradient( COL_BLACK, COL_WHITE ) ),
//STRIP001 
//STRIP001 	aFtType				( this, ResId( FT_TYPE ) ),
//STRIP001 	aLbGradientType		( this, ResId( LB_GRADIENT_TYPES ) ),
//STRIP001 	aFtCenterX			( this, ResId( FT_CENTER_X ) ),
//STRIP001 	aMtrCenterX			( this, ResId( MTR_CENTER_X ) ),
//STRIP001 	aFtCenterY			( this, ResId( FT_CENTER_Y ) ),
//STRIP001 	aMtrCenterY			( this, ResId( MTR_CENTER_Y ) ),
//STRIP001 	aFtAngle			( this, ResId( FT_ANGLE ) ),
//STRIP001 	aMtrAngle			( this, ResId( MTR_ANGLE ) ),
//STRIP001 	aFtBorder			( this, ResId( FT_BORDER ) ),
//STRIP001 	aMtrBorder			( this, ResId( MTR_BORDER ) ),
//STRIP001 	aFtColorFrom		( this, ResId( FT_COLOR_FROM ) ),
//STRIP001 	aMtrColorFrom		( this, ResId( MTR_COLOR_FROM ) ),
//STRIP001 	aLbColorFrom		( this, ResId( LB_COLOR_FROM ) ),
//STRIP001 	aFtColorTo			( this, ResId( FT_COLOR_TO ) ),
//STRIP001 	aMtrColorTo			( this, ResId( MTR_COLOR_TO ) ),
//STRIP001 	aLbColorTo			( this, ResId( LB_COLOR_TO ) ),
//STRIP001 	aLbGradients		( this, ResId( LB_GRADIENTS ) ),
//STRIP001     aFlProp             ( this, ResId( FL_PROP ) ),
//STRIP001 	aCtlPreview			( this, ResId( CTL_PREVIEW ), &XOut ),
//STRIP001 	aBtnAdd				( this, ResId( BTN_ADD ) ),
//STRIP001 	aBtnModify			( this, ResId( BTN_MODIFY ) ),
//STRIP001 	aBtnDelete			( this, ResId( BTN_DELETE ) ),
//STRIP001 	aBtnLoad			( this, ResId( BTN_LOAD ) ),
//STRIP001 	aBtnSave			( this, ResId( BTN_SAVE ) ),
//STRIP001 	rOutAttrs			( rInAttrs )
//STRIP001 
//STRIP001 {
//STRIP001 	aBtnLoad.SetModeImage( Image( ResId( RID_SVXIMG_LOAD_H ) ), BMP_COLOR_HIGHCONTRAST );
//STRIP001 	aBtnSave.SetModeImage( Image( ResId( RID_SVXIMG_SAVE_H ) ), BMP_COLOR_HIGHCONTRAST );
//STRIP001 
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	// diese Page braucht ExchangeSupport
//STRIP001 	SetExchangeSupport();
//STRIP001 
//STRIP001 	// Solange NICHT vom Item unterstuetzt
//STRIP001 
//STRIP001 	//aMtrColorTo.Disable();
//STRIP001 	aMtrColorTo.SetValue( 100 );
//STRIP001 	//aMtrColorFrom.Disable();
//STRIP001 	aMtrColorFrom.SetValue( 100 );
//STRIP001 
//STRIP001 	// Setzen des Output-Devices
//STRIP001 	rXFSet.Put( aXFStyleItem );
//STRIP001 	rXFSet.Put( aXGradientItem );
//STRIP001 	XOut.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 
//STRIP001     // Set line at the OutputDevice
//STRIP001 	XLineAttrSetItem aXLineAttr( pXPool );
//STRIP001     aXLineAttr.GetItemSet().Put( XLineStyleItem( XLINE_SOLID ) );
//STRIP001     aXLineAttr.GetItemSet().Put( XLineWidthItem( 1 ));
//STRIP001 	XOut.SetLineAttr( aXLineAttr.GetItemSet() );
//STRIP001 
//STRIP001     // Handler ueberladen
//STRIP001 	aLbGradients.SetSelectHdl(
//STRIP001 		LINK( this, SvxGradientTabPage, ChangeGradientHdl_Impl ) );
//STRIP001 	aBtnAdd.SetClickHdl( LINK( this, SvxGradientTabPage, ClickAddHdl_Impl ) );
//STRIP001 	aBtnModify.SetClickHdl(
//STRIP001 		LINK( this, SvxGradientTabPage, ClickModifyHdl_Impl ) );
//STRIP001 	aBtnDelete.SetClickHdl(
//STRIP001 		LINK( this, SvxGradientTabPage, ClickDeleteHdl_Impl ) );
//STRIP001 
//STRIP001 	Link aLink = LINK( this, SvxGradientTabPage, ModifiedHdl_Impl );
//STRIP001 	aLbGradientType.SetSelectHdl( aLink );
//STRIP001 	aMtrCenterX.SetModifyHdl( aLink );
//STRIP001 	aMtrCenterY.SetModifyHdl( aLink );
//STRIP001 	aMtrAngle.SetModifyHdl( aLink );
//STRIP001 	aMtrBorder.SetModifyHdl( aLink );
//STRIP001 	aMtrColorFrom.SetModifyHdl( aLink );
//STRIP001 	aLbColorFrom.SetSelectHdl( aLink );
//STRIP001 	aMtrColorTo.SetModifyHdl( aLink );
//STRIP001 	aLbColorTo.SetSelectHdl( aLink );
//STRIP001 
//STRIP001 	aBtnLoad.SetClickHdl(
//STRIP001 		LINK( this, SvxGradientTabPage, ClickLoadHdl_Impl ) );
//STRIP001 	aBtnSave.SetClickHdl(
//STRIP001 		LINK( this, SvxGradientTabPage, ClickSaveHdl_Impl ) );
//STRIP001 
//STRIP001 	pColorTab = NULL;
//STRIP001 	pGradientList = NULL;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxGradientTabPage::Construct()
//STRIP001 {
//STRIP001 	// Farbtabelle
//STRIP001 	aLbColorFrom.Fill( pColorTab );
//STRIP001 	aLbColorTo.CopyEntries( aLbColorFrom );
//STRIP001 
//STRIP001 	// Farbverlauftabelle
//STRIP001 	aLbGradients.Fill( pGradientList );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxGradientTabPage::ActivatePage( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	int nPos;
//STRIP001 	int nCount;
//STRIP001 
//STRIP001 	if( *pDlgType == 0 ) // Flaechen-Dialog
//STRIP001 	{
//STRIP001 		*pbAreaTP = FALSE;
//STRIP001 
//STRIP001 		if( pColorTab )
//STRIP001 		{
//STRIP001 			// ColorTable
//STRIP001 			if( *pnColorTableState & CT_CHANGED ||
//STRIP001 				*pnColorTableState & CT_MODIFIED )
//STRIP001 			{
//STRIP001 				if( *pnColorTableState & CT_CHANGED )
//STRIP001 					pColorTab = ( (SvxAreaTabDialog*) DLGWIN )->GetNewColorTable();
//STRIP001 
//STRIP001 				// LbColorFrom
//STRIP001 				nPos = aLbColorFrom.GetSelectEntryPos();
//STRIP001 				aLbColorFrom.Clear();
//STRIP001 				aLbColorFrom.Fill( pColorTab );
//STRIP001 				nCount = aLbColorFrom.GetEntryCount();
//STRIP001 				if( nCount == 0 )
//STRIP001 					; // Dieser Fall sollte nicht auftreten
//STRIP001 				else if( nCount <= nPos )
//STRIP001 					aLbColorFrom.SelectEntryPos( 0 );
//STRIP001 				else
//STRIP001 					aLbColorFrom.SelectEntryPos( nPos );
//STRIP001 
//STRIP001 				// LbColorTo
//STRIP001 				nPos = aLbColorTo.GetSelectEntryPos();
//STRIP001 				aLbColorTo.Clear();
//STRIP001 				aLbColorTo.CopyEntries( aLbColorFrom );
//STRIP001 				nCount = aLbColorTo.GetEntryCount();
//STRIP001 				if( nCount == 0 )
//STRIP001 					; // Dieser Fall sollte nicht auftreten
//STRIP001 				else if( nCount <= nPos )
//STRIP001 					aLbColorTo.SelectEntryPos( 0 );
//STRIP001 				else
//STRIP001 					aLbColorTo.SelectEntryPos( nPos );
//STRIP001 
//STRIP001 				ModifiedHdl_Impl( this );
//STRIP001 			}
//STRIP001 
//STRIP001 			// Ermitteln (evtl. abschneiden) des Namens und in
//STRIP001 			// der GroupBox darstellen
//STRIP001 			String			aString( SVX_RES( RID_SVXSTR_TABLE ) ); aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( ": " ) );
//STRIP001 			INetURLObject	aURL( pGradientList->GetPath() );
//STRIP001 
//STRIP001 			aURL.Append( pGradientList->GetName() );
//STRIP001 			DBG_ASSERT( aURL.GetProtocol() != INET_PROT_NOT_VALID, "invalid URL" );
//STRIP001 
//STRIP001 			if ( aURL.getBase().Len() > 18 )
//STRIP001 			{
//STRIP001 				aString += aURL.getBase().Copy( 0, 15 );
//STRIP001 				aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "..." ) );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				aString += aURL.getBase();
//STRIP001 
//STRIP001 			if ( *pPageType == PT_GRADIENT && *pPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 			{
//STRIP001 				aLbGradients.SelectEntryPos( *pPos );
//STRIP001 			}
//STRIP001 			// Farben koennten geloescht worden sein
//STRIP001 			ChangeGradientHdl_Impl( this );
//STRIP001 
//STRIP001 			*pPageType = PT_GRADIENT;
//STRIP001 			*pPos = LISTBOX_ENTRY_NOTFOUND;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 int SvxGradientTabPage::DeactivatePage( SfxItemSet* pSet )
//STRIP001 {
//STRIP001 	if( CheckChanges_Impl() == -1L )
//STRIP001 		return KEEP_PAGE;
//STRIP001 
//STRIP001 	if( pSet )
//STRIP001 		FillItemSet( *pSet );
//STRIP001 
//STRIP001 	return LEAVE_PAGE;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 long SvxGradientTabPage::CheckChanges_Impl()
//STRIP001 {
//STRIP001 	// wird hier benutzt, um Aenderungen NICHT zu verlieren
//STRIP001 	XGradient aTmpGradient( aLbColorFrom.GetSelectEntryColor(),
//STRIP001 						  aLbColorTo.GetSelectEntryColor(),
//STRIP001 						  (XGradientStyle) aLbGradientType.GetSelectEntryPos(),
//STRIP001 						  aMtrAngle.GetValue() * 10, // sollte in Resource geaendert werden
//STRIP001 						  (USHORT) aMtrCenterX.GetValue(),
//STRIP001 						  (USHORT) aMtrCenterY.GetValue(),
//STRIP001 						  (USHORT) aMtrBorder.GetValue(),
//STRIP001 						  (USHORT) aMtrColorFrom.GetValue(),
//STRIP001 						  (USHORT) aMtrColorTo.GetValue() );
//STRIP001 
//STRIP001 	USHORT nPos = aLbGradients.GetSelectEntryPos();
//STRIP001 	if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		XGradient aGradient = pGradientList->Get( nPos )->GetGradient();
//STRIP001 		String aString = aLbGradients.GetSelectEntry();
//STRIP001 
//STRIP001 		if( !( aTmpGradient == aGradient ) )
//STRIP001 		{
//STRIP001 			ResMgr* pMgr = DIALOG_MGR();
//STRIP001             Image aWarningBoxImage = WarningBox::GetStandardImage();
//STRIP001 			SvxMessDialog aMessDlg( DLGWIN,
//STRIP001 				String( ResId( RID_SVXSTR_GRADIENT, pMgr ) ),
//STRIP001 				String( ResId( RID_SVXSTR_ASK_CHANGE_GRADIENT, pMgr ) ),
//STRIP001 				&aWarningBoxImage );
//STRIP001 
//STRIP001 			aMessDlg.SetButtonText( MESS_BTN_1,
//STRIP001 									String( ResId( RID_SVXSTR_CHANGE, pMgr ) ) );
//STRIP001 			aMessDlg.SetButtonText( MESS_BTN_2,
//STRIP001 									String( ResId( RID_SVXSTR_ADD, pMgr ) ) );
//STRIP001 
//STRIP001 			short nRet = aMessDlg.Execute();
//STRIP001 
//STRIP001 			switch( nRet )
//STRIP001 			{
//STRIP001 				case RET_BTN_1: // Aendern
//STRIP001 				{
//STRIP001 					ClickModifyHdl_Impl( this );
//STRIP001 					aGradient = pGradientList->Get( nPos )->GetGradient();
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 				case RET_BTN_2: // Hinzufuegen
//STRIP001 				{
//STRIP001 					ClickAddHdl_Impl( this );
//STRIP001 					nPos = aLbGradients.GetSelectEntryPos();
//STRIP001 					aGradient = pGradientList->Get( nPos )->GetGradient();
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 				case RET_CANCEL:
//STRIP001 					// return( -1L ); <-- wuerde die Seite nicht verlassen
//STRIP001 				break;
//STRIP001 				// return( TRUE ); // Abbruch
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	nPos = aLbGradients.GetSelectEntryPos();
//STRIP001 	if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		*pPos = nPos;
//STRIP001 	}
//STRIP001 	return 0L;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 BOOL SvxGradientTabPage::FillItemSet( SfxItemSet& rOutAttrs )
//STRIP001 {
//STRIP001 	if( *pDlgType == 0 && *pPageType == PT_GRADIENT && *pbAreaTP == FALSE )
//STRIP001 	{
//STRIP001 		// CheckChanges(); <-- doppelte Abfrage ?
//STRIP001 
//STRIP001 		XGradient*	pXGradient = NULL;
//STRIP001 		String	  	aString;
//STRIP001 		USHORT	  	nPos = aLbGradients.GetSelectEntryPos();
//STRIP001 		if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 		{
//STRIP001 			pXGradient = new XGradient( pGradientList->Get( nPos )->GetGradient() );
//STRIP001 			aString = aLbGradients.GetSelectEntry();
//STRIP001 
//STRIP001 		}
//STRIP001 		else
//STRIP001 		// Farbverlauf wurde (unbekannt) uebergeben
//STRIP001 		{
//STRIP001 			pXGradient = new XGradient( aLbColorFrom.GetSelectEntryColor(),
//STRIP001 						aLbColorTo.GetSelectEntryColor(),
//STRIP001 						(XGradientStyle) aLbGradientType.GetSelectEntryPos(),
//STRIP001 						aMtrAngle.GetValue() * 10, // sollte in Resource geaendert werden
//STRIP001 						(USHORT) aMtrCenterX.GetValue(),
//STRIP001 						(USHORT) aMtrCenterY.GetValue(),
//STRIP001 						(USHORT) aMtrBorder.GetValue(),
//STRIP001 						(USHORT) aMtrColorFrom.GetValue(),
//STRIP001 						(USHORT) aMtrColorTo.GetValue() );
//STRIP001 		}
//STRIP001 		DBG_ASSERT( pXGradient, "XGradient konnte nicht erzeugt werden" );
//STRIP001 		rOutAttrs.Put( XFillStyleItem( XFILL_GRADIENT ) );
//STRIP001 		rOutAttrs.Put( XFillGradientItem( aString, *pXGradient ) );
//STRIP001 
//STRIP001 		delete pXGradient;
//STRIP001 	}
//STRIP001 	return TRUE;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxGradientTabPage::Reset( const SfxItemSet& rOutAttrs )
//STRIP001 {
//STRIP001 	// aLbGradients.SelectEntryPos( 0 );
//STRIP001 	ChangeGradientHdl_Impl( this );
//STRIP001 
//STRIP001 	// Status der Buttons ermitteln
//STRIP001 	if( pGradientList->Count() )
//STRIP001 	{
//STRIP001 		aBtnModify.Enable();
//STRIP001 		aBtnDelete.Enable();
//STRIP001 		aBtnSave.Enable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aBtnModify.Disable();
//STRIP001 		aBtnDelete.Disable();
//STRIP001 		aBtnSave.Disable();
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SfxTabPage* SvxGradientTabPage::Create( Window* pWindow,
//STRIP001 				const SfxItemSet& rOutAttrs )
//STRIP001 {
//STRIP001 	return new SvxGradientTabPage( pWindow, rOutAttrs );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxGradientTabPage, ModifiedHdl_Impl, void *, pControl )
//STRIP001 {
//STRIP001 	XGradientStyle eXGS = (XGradientStyle) aLbGradientType.GetSelectEntryPos();
//STRIP001 
//STRIP001 	XGradient aXGradient( aLbColorFrom.GetSelectEntryColor(),
//STRIP001 						  aLbColorTo.GetSelectEntryColor(),
//STRIP001 						  eXGS,
//STRIP001 						  aMtrAngle.GetValue() * 10, // sollte in Resource geaendert werden
//STRIP001 						  (USHORT) aMtrCenterX.GetValue(),
//STRIP001 						  (USHORT) aMtrCenterY.GetValue(),
//STRIP001 						  (USHORT) aMtrBorder.GetValue(),
//STRIP001 						  (USHORT) aMtrColorFrom.GetValue(),
//STRIP001 						  (USHORT) aMtrColorTo.GetValue() );
//STRIP001 
//STRIP001 	// Enablen/Disablen von Controls
//STRIP001 	if( pControl == &aLbGradientType || pControl == this )
//STRIP001 		SetControlState_Impl( eXGS );
//STRIP001 
//STRIP001 	// Anzeigen im XOutDev
//STRIP001 	rXFSet.Put( XFillGradientItem( String(), aXGradient ) );
//STRIP001 	XOut.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 
//STRIP001 	aCtlPreview.Invalidate();
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxGradientTabPage, ClickAddHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	ResMgr* pMgr = DIALOG_MGR();
//STRIP001 	String aNewName( ResId( RID_SVXSTR_GRADIENT, pMgr ) );
//STRIP001 	String aDesc( ResId( RID_SVXSTR_DESC_GRADIENT, pMgr ) );
//STRIP001 	String aName;
//STRIP001 
//STRIP001 	long nCount = pGradientList->Count();
//STRIP001 	long j = 1;
//STRIP001 	BOOL bDifferent = FALSE;
//STRIP001 
//STRIP001 	while( !bDifferent )
//STRIP001 	{
//STRIP001 		aName  = aNewName;
//STRIP001 		aName += sal_Unicode(' ');
//STRIP001 		aName += UniString::CreateFromInt32( j++ );
//STRIP001 		bDifferent = TRUE;
//STRIP001 
//STRIP001 		for( long i = 0; i < nCount && bDifferent; i++ )
//STRIP001 			if( aName == pGradientList->Get( i )->GetName() )
//STRIP001 				bDifferent = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	SvxNameDialog* pDlg     = new SvxNameDialog( DLGWIN, aName, aDesc );
//STRIP001 	WarningBox*    pWarnBox = NULL;
//STRIP001 	USHORT         nError   = RID_SVXSTR_WARN_NAME_DUPLICATE;
//STRIP001 
//STRIP001 	while( pDlg->Execute() == RET_OK )
//STRIP001 	{
//STRIP001 		pDlg->GetName( aName );
//STRIP001 
//STRIP001 		bDifferent = TRUE;
//STRIP001 
//STRIP001 		for( long i = 0; i < nCount && bDifferent; i++ )
//STRIP001 			if( aName == pGradientList->Get( i )->GetName() )
//STRIP001 				bDifferent = FALSE;
//STRIP001 
//STRIP001 		if( bDifferent )
//STRIP001 		{
//STRIP001 			nError = 0;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		if( !pWarnBox )
//STRIP001 		{
//STRIP001 			pWarnBox = new WarningBox( DLGWIN,
//STRIP001 									   WinBits( WB_OK_CANCEL ),
//STRIP001 									   String( ResId( nError, pMgr ) ) );
//STRIP001 			pWarnBox->SetHelpId( HID_WARN_NAME_DUPLICATE );
//STRIP001 		}
//STRIP001 
//STRIP001 		if( pWarnBox->Execute() != RET_OK )
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	//Rectangle aDlgRect( pDlg->GetPosPixel(), pDlg->GetSizePixel() );
//STRIP001 	delete pDlg;
//STRIP001 	delete pWarnBox;
//STRIP001 
//STRIP001 	if( !nError )
//STRIP001 	{
//STRIP001 		XGradient aXGradient( aLbColorFrom.GetSelectEntryColor(),
//STRIP001 							  aLbColorTo.GetSelectEntryColor(),
//STRIP001 							  (XGradientStyle) aLbGradientType.GetSelectEntryPos(),
//STRIP001 							  aMtrAngle.GetValue() * 10, // sollte in Resource geaendert werden
//STRIP001 							  (USHORT) aMtrCenterX.GetValue(),
//STRIP001 							  (USHORT) aMtrCenterY.GetValue(),
//STRIP001 							  (USHORT) aMtrBorder.GetValue(),
//STRIP001 							  (USHORT) aMtrColorFrom.GetValue(),
//STRIP001 							  (USHORT) aMtrColorTo.GetValue() );
//STRIP001 		XGradientEntry* pEntry = new XGradientEntry( aXGradient, aName );
//STRIP001 
//STRIP001 		pGradientList->Insert( pEntry, nCount );
//STRIP001 
//STRIP001 		aLbGradients.Append( pEntry );
//STRIP001 
//STRIP001 		aLbGradients.SelectEntryPos( aLbGradients.GetEntryCount() - 1 );
//STRIP001 
//STRIP001 #ifdef WNT
//STRIP001 		// hack: #31355# W.P.
//STRIP001 		Rectangle aRect( aLbGradients.GetPosPixel(), aLbGradients.GetSizePixel() );
//STRIP001 		if( TRUE ) {				// ??? overlapped with pDlg
//STRIP001 									// and srolling
//STRIP001 			Invalidate( aRect );
//STRIP001 			//aLbGradients.Invalidate();
//STRIP001 		}
//STRIP001 #endif
//STRIP001 
//STRIP001 		// Flag fuer modifiziert setzen
//STRIP001 		*pnGradientListState |= CT_MODIFIED;
//STRIP001 
//STRIP001 		ChangeGradientHdl_Impl( this );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Status der Buttons ermitteln
//STRIP001 	if( pGradientList->Count() )
//STRIP001 	{
//STRIP001 		aBtnModify.Enable();
//STRIP001 		aBtnDelete.Enable();
//STRIP001 		aBtnSave.Enable();
//STRIP001 	}
//STRIP001 	return 0L;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxGradientTabPage, ClickModifyHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	int nPos = aLbGradients.GetSelectEntryPos();
//STRIP001 
//STRIP001 	if ( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		ResMgr* pMgr = DIALOG_MGR();
//STRIP001 		String aNewName( ResId( RID_SVXSTR_GRADIENT, pMgr ) );
//STRIP001 		String aDesc( ResId( RID_SVXSTR_DESC_GRADIENT, pMgr ) );
//STRIP001 		String aName( pGradientList->Get( nPos )->GetName() );
//STRIP001 		String aOldName = aName;
//STRIP001 
//STRIP001 		SvxNameDialog* pDlg = new SvxNameDialog( DLGWIN, aName, aDesc );
//STRIP001 
//STRIP001 		long nCount = pGradientList->Count();
//STRIP001 		BOOL bDifferent = FALSE;
//STRIP001 		BOOL bLoop = TRUE;
//STRIP001 
//STRIP001 		while( bLoop && pDlg->Execute() == RET_OK )
//STRIP001 		{
//STRIP001 			pDlg->GetName( aName );
//STRIP001 			bDifferent = TRUE;
//STRIP001 
//STRIP001 			for( long i = 0; i < nCount && bDifferent; i++ )
//STRIP001 			{
//STRIP001 				if( aName == pGradientList->Get( i )->GetName() &&
//STRIP001 					aName != aOldName )
//STRIP001 					bDifferent = FALSE;
//STRIP001 			}
//STRIP001 
//STRIP001 			if( bDifferent )
//STRIP001 			{
//STRIP001 				bLoop = FALSE;
//STRIP001 				XGradient aXGradient( aLbColorFrom.GetSelectEntryColor(),
//STRIP001 									  aLbColorTo.GetSelectEntryColor(),
//STRIP001 									  (XGradientStyle) aLbGradientType.GetSelectEntryPos(),
//STRIP001 									  aMtrAngle.GetValue() * 10, // sollte in Resource geaendert werden
//STRIP001 									  (USHORT) aMtrCenterX.GetValue(),
//STRIP001 									  (USHORT) aMtrCenterY.GetValue(),
//STRIP001 									  (USHORT) aMtrBorder.GetValue(),
//STRIP001 									  (USHORT) aMtrColorFrom.GetValue(),
//STRIP001 									  (USHORT) aMtrColorTo.GetValue() );
//STRIP001 
//STRIP001 				XGradientEntry* pEntry = new XGradientEntry( aXGradient, aName );
//STRIP001 
//STRIP001 				delete pGradientList->Replace( pEntry, nPos );
//STRIP001 
//STRIP001 				aLbGradients.Modify( pEntry, nPos );
//STRIP001 
//STRIP001 				aLbGradients.SelectEntryPos( nPos );
//STRIP001 
//STRIP001 				// Flag fuer modifiziert setzen
//STRIP001 				*pnGradientListState |= CT_MODIFIED;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				WarningBox aBox( DLGWIN, WinBits( WB_OK ),String( ResId( RID_SVXSTR_WARN_NAME_DUPLICATE, pMgr ) ) );
//STRIP001 				aBox.SetHelpId( HID_WARN_NAME_DUPLICATE );
//STRIP001 				aBox.Execute();
//STRIP001 			}
//STRIP001 
//STRIP001 		}
//STRIP001 		delete pDlg;
//STRIP001 	}
//STRIP001 	return 0L;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxGradientTabPage, ClickDeleteHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	int nPos = aLbGradients.GetSelectEntryPos();
//STRIP001 
//STRIP001 	if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		QueryBox aQueryBox( DLGWIN, WinBits( WB_YES_NO | WB_DEF_NO ),
//STRIP001 //!			SVX_RES( RID_SVXSTR_DEL_GRADIENT ),
//STRIP001 			String( SVX_RES( RID_SVXSTR_ASK_DEL_GRADIENT ) ) );
//STRIP001 
//STRIP001 		if ( aQueryBox.Execute() == RET_YES )
//STRIP001 		{
//STRIP001 			delete pGradientList->Remove( nPos );
//STRIP001 			aLbGradients.RemoveEntry( nPos );
//STRIP001 			aLbGradients.SelectEntryPos( 0 );
//STRIP001 
//STRIP001 			aCtlPreview.Invalidate();
//STRIP001 
//STRIP001 			ChangeGradientHdl_Impl( this );
//STRIP001 
//STRIP001 			// Flag fuer modifiziert setzen
//STRIP001 			*pnGradientListState |= CT_MODIFIED;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	// Status der Buttons ermitteln
//STRIP001 	if( !pGradientList->Count() )
//STRIP001 	{
//STRIP001 		aBtnModify.Disable();
//STRIP001 		aBtnDelete.Disable();
//STRIP001 		aBtnSave.Disable();
//STRIP001 	}
//STRIP001 	return 0L;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxGradientTabPage, ClickLoadHdl_Impl, void *, p )
//STRIP001 {
//STRIP001 	ResMgr* pMgr = DIALOG_MGR();
//STRIP001 	USHORT nReturn = RET_YES;
//STRIP001 
//STRIP001 	if ( *pnGradientListState & CT_MODIFIED )
//STRIP001 	{
//STRIP001 		nReturn = WarningBox( DLGWIN, WinBits( WB_YES_NO_CANCEL ),
//STRIP001 			String( ResId( RID_SVXSTR_WARN_TABLE_OVERWRITE, pMgr ) ) ).Execute();
//STRIP001 
//STRIP001 		if ( nReturn == RET_YES )
//STRIP001 			pGradientList->Save();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( nReturn != RET_CANCEL )
//STRIP001 	{
//STRIP001     	::sfx2::FileDialogHelper aDlg( ::sfx2::FILEOPEN_SIMPLE, 0 );
//STRIP001 		String aStrFilterType( RTL_CONSTASCII_USTRINGPARAM( "*.sog" ) );
//STRIP001 		aDlg.AddFilter( aStrFilterType, aStrFilterType );
//STRIP001 		INetURLObject aFile( SvtPathOptions().GetPalettePath() );
//STRIP001 		aDlg.SetDisplayDirectory( aFile.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 
//STRIP001 		if( aDlg.Execute() == ERRCODE_NONE )
//STRIP001 		{
//STRIP001 			EnterWait();
//STRIP001 
//STRIP001 			INetURLObject aURL( aDlg.GetPath() );
//STRIP001 			INetURLObject aPathURL( aURL );
//STRIP001 
//STRIP001 			aPathURL.removeSegment();
//STRIP001 			aPathURL.removeFinalSlash();
//STRIP001 
//STRIP001 			// Liste speichern
//STRIP001 			XGradientList* pGrdList = new XGradientList( aPathURL.GetMainURL( INetURLObject::NO_DECODE ), pXPool );
//STRIP001 			pGrdList->SetName( aURL.getName() );
//STRIP001 
//STRIP001 			if ( pGrdList->Load() )
//STRIP001 			{
//STRIP001 				if ( pGrdList )
//STRIP001 				{
//STRIP001 					// Pruefen, ob Tabelle geloescht werden darf:
//STRIP001 					if ( pGradientList !=
//STRIP001 						 ( (SvxAreaTabDialog*) DLGWIN )->GetGradientList() )
//STRIP001 						delete pGradientList;
//STRIP001 
//STRIP001 					pGradientList = pGrdList;
//STRIP001 					( (SvxAreaTabDialog*) DLGWIN )->
//STRIP001 						SetNewGradientList( pGradientList );
//STRIP001 
//STRIP001 					aLbGradients.Clear();
//STRIP001 					aLbGradients.Fill( pGradientList );
//STRIP001 					Reset( rOutAttrs );
//STRIP001 
//STRIP001 					pGradientList->SetName( aURL.getName() );
//STRIP001 
//STRIP001 					// Ermitteln (evtl. abschneiden) des Namens und in
//STRIP001 					// der GroupBox darstellen
//STRIP001 					String aString( ResId( RID_SVXSTR_TABLE, pMgr ) );
//STRIP001 					aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( ": " ) );
//STRIP001 
//STRIP001 					if ( aURL.getBase().Len() > 18 )
//STRIP001 					{
//STRIP001 						aString += aURL.getBase().Copy( 0, 15 );
//STRIP001 						aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "..." ) );
//STRIP001 					}
//STRIP001 					else
//STRIP001 						aString += aURL.getBase();
//STRIP001 
//STRIP001 					// Flag fuer gewechselt setzen
//STRIP001 					*pnGradientListState |= CT_CHANGED;
//STRIP001 					// Flag fuer modifiziert entfernen
//STRIP001 					*pnGradientListState &= ~CT_MODIFIED;
//STRIP001 				}
//STRIP001 				LeaveWait();
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				LeaveWait();
//STRIP001 				//aIStream.Close();
//STRIP001 				ErrorBox( DLGWIN, WinBits( WB_OK ),
//STRIP001 					String( ResId( RID_SVXSTR_READ_DATA_ERROR, pMgr ) ) ).Execute();
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Status der Buttons ermitteln
//STRIP001 	if( pGradientList->Count() )
//STRIP001 	{
//STRIP001 		aBtnModify.Enable();
//STRIP001 		aBtnDelete.Enable();
//STRIP001 		aBtnSave.Enable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aBtnModify.Disable();
//STRIP001 		aBtnDelete.Disable();
//STRIP001 		aBtnSave.Disable();
//STRIP001 	}
//STRIP001 	return 0L;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxGradientTabPage, ClickSaveHdl_Impl, void *, p )
//STRIP001 {
//STRIP001    	::sfx2::FileDialogHelper aDlg( ::sfx2::FILESAVE_SIMPLE, 0 );
//STRIP001 	String aStrFilterType( RTL_CONSTASCII_USTRINGPARAM( "*.sog" ) );
//STRIP001 	aDlg.AddFilter( aStrFilterType, aStrFilterType );
//STRIP001 
//STRIP001 	INetURLObject aFile( SvtPathOptions().GetPalettePath() );
//STRIP001 	DBG_ASSERT( aFile.GetProtocol() != INET_PROT_NOT_VALID, "invalid URL" );
//STRIP001 
//STRIP001 	if( pGradientList->GetName().Len() )
//STRIP001 	{
//STRIP001 		aFile.Append( pGradientList->GetName() );
//STRIP001 
//STRIP001 		if( !aFile.getExtension().Len() )
//STRIP001 			aFile.SetExtension( UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "sog" ) ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	aDlg.SetDisplayDirectory( aFile.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 	if ( aDlg.Execute() == ERRCODE_NONE )
//STRIP001 	{
//STRIP001 		INetURLObject	aURL( aDlg.GetPath() );
//STRIP001 		INetURLObject	aPathURL( aURL );
//STRIP001 
//STRIP001 		aPathURL.removeSegment();
//STRIP001 		aPathURL.removeFinalSlash();
//STRIP001 
//STRIP001 		pGradientList->SetName( aURL.getName() );
//STRIP001 		pGradientList->SetPath( aPathURL.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 
//STRIP001 		if( pGradientList->Save() )
//STRIP001 		{
//STRIP001 			// Ermitteln (evtl. abschneiden) des Namens und in
//STRIP001 			// der GroupBox darstellen
//STRIP001 			String aString( SVX_RES( RID_SVXSTR_TABLE ) );
//STRIP001 			aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( ": " ) );
//STRIP001 
//STRIP001 			if ( aURL.getBase().Len() > 18 )
//STRIP001 			{
//STRIP001 				aString += aURL.getBase().Copy( 0, 15 );
//STRIP001 				aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "..." ) );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				aString += aURL.getBase();
//STRIP001 
//STRIP001 			// Flag fuer gespeichert setzen
//STRIP001 			*pnGradientListState |= CT_SAVED;
//STRIP001 			// Flag fuer modifiziert entfernen
//STRIP001 			*pnGradientListState &= ~CT_MODIFIED;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			ErrorBox( DLGWIN, WinBits( WB_OK ),
//STRIP001 				String( SVX_RES( RID_SVXSTR_WRITE_DATA_ERROR ) ) ).Execute();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxGradientTabPage, ChangeGradientHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	XGradient* pGradient = NULL;
//STRIP001 	int nPos = aLbGradients.GetSelectEntryPos();
//STRIP001 
//STRIP001 	if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 		pGradient = new XGradient( ( (XGradientEntry*) pGradientList->Get( nPos ) )->GetGradient() );
//STRIP001 	else
//STRIP001 	{
//STRIP001 		const SfxPoolItem* pPoolItem = NULL;
//STRIP001 		if( SFX_ITEM_SET == rOutAttrs.GetItemState( GetWhich( XATTR_FILLSTYLE ), TRUE, &pPoolItem ) )
//STRIP001 		{
//STRIP001 			if( ( XFILL_GRADIENT == (XFillStyle) ( ( const XFillStyleItem* ) pPoolItem )->GetValue() ) &&
//STRIP001 				( SFX_ITEM_SET == rOutAttrs.GetItemState( GetWhich( XATTR_FILLGRADIENT ), TRUE, &pPoolItem ) ) )
//STRIP001 			{
//STRIP001 				pGradient = new XGradient( ( ( const XFillGradientItem* ) pPoolItem )->GetValue() );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		if( !pGradient )
//STRIP001 		{
//STRIP001 			aLbGradients.SelectEntryPos( 0 );
//STRIP001 			nPos = aLbGradients.GetSelectEntryPos();
//STRIP001 			if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 				pGradient = new XGradient( ( (XGradientEntry*) pGradientList->Get( nPos ) )->GetGradient() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if( pGradient )
//STRIP001 	{
//STRIP001 		XGradientStyle eXGS = pGradient->GetGradientStyle();
//STRIP001 
//STRIP001 		aLbGradientType.SelectEntryPos( eXGS );
//STRIP001 		// Wenn der EIntrag nicht in der Listbox ist, werden die Farben
//STRIP001 		// temporaer hinzugenommen
//STRIP001 		aLbColorFrom.SetNoSelection();
//STRIP001 		aLbColorFrom.SelectEntry( pGradient->GetStartColor() );
//STRIP001 
//STRIP001 		if ( aLbColorFrom.GetSelectEntryCount() == 0 )
//STRIP001 		{
//STRIP001 			aLbColorFrom.InsertEntry( pGradient->GetStartColor(),
//STRIP001 									  String() );
//STRIP001 			aLbColorFrom.SelectEntry( pGradient->GetStartColor() );
//STRIP001 		}
//STRIP001 		aLbColorTo.SetNoSelection();
//STRIP001 		aLbColorTo.SelectEntry( pGradient->GetEndColor() );
//STRIP001 
//STRIP001 		if ( aLbColorTo.GetSelectEntryCount() == 0 )
//STRIP001 		{
//STRIP001 			aLbColorTo.InsertEntry( pGradient->GetEndColor(), String() );
//STRIP001 			aLbColorTo.SelectEntry( pGradient->GetEndColor() );
//STRIP001 		}
//STRIP001 
//STRIP001 		aMtrAngle.SetValue( pGradient->GetAngle() / 10 ); // sollte in Resource geaendert werden
//STRIP001 		aMtrBorder.SetValue( pGradient->GetBorder() );
//STRIP001 		aMtrCenterX.SetValue( pGradient->GetXOffset() );
//STRIP001 		aMtrCenterY.SetValue( pGradient->GetYOffset() );
//STRIP001 		aMtrColorFrom.SetValue( pGradient->GetStartIntens() );
//STRIP001 		aMtrColorTo.SetValue( pGradient->GetEndIntens() );
//STRIP001 
//STRIP001 		// Controls Disablen/Enablen
//STRIP001 		SetControlState_Impl( eXGS );
//STRIP001 
//STRIP001 		// ItemSet fuellen und an XOut weiterleiten
//STRIP001 		rXFSet.Put( XFillGradientItem( String(), *pGradient ) );
//STRIP001 		XOut.SetFillAttr( aXFillAttr.GetItemSet() );
//STRIP001 
//STRIP001 		aCtlPreview.Invalidate();
//STRIP001 		delete pGradient;
//STRIP001 	}
//STRIP001 	return 0L;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void SvxGradientTabPage::SetControlState_Impl( XGradientStyle eXGS )
//STRIP001 {
//STRIP001 	switch( eXGS )
//STRIP001 	{
//STRIP001 		case XGRAD_LINEAR:
//STRIP001 		case XGRAD_AXIAL:
//STRIP001 			aFtCenterX.Disable();
//STRIP001 			aMtrCenterX.Disable();
//STRIP001 			aFtCenterY.Disable();
//STRIP001 			aMtrCenterY.Disable();
//STRIP001 			aFtAngle.Enable();
//STRIP001 			aMtrAngle.Enable();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case XGRAD_RADIAL:
//STRIP001 			aFtCenterX.Enable();
//STRIP001 			aMtrCenterX.Enable();
//STRIP001 			aFtCenterY.Enable();
//STRIP001 			aMtrCenterY.Enable();
//STRIP001 			aFtAngle.Disable();
//STRIP001 			aMtrAngle.Disable();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case XGRAD_ELLIPTICAL:
//STRIP001 			aFtCenterX.Enable();
//STRIP001 			aMtrCenterX.Enable();
//STRIP001 			aFtCenterY.Enable();
//STRIP001 			aMtrCenterY.Enable();
//STRIP001 			aFtAngle.Enable();
//STRIP001 			aMtrAngle.Enable();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case XGRAD_SQUARE:
//STRIP001 		case XGRAD_RECT:
//STRIP001 			aFtCenterX.Enable();
//STRIP001 			aMtrCenterX.Enable();
//STRIP001 			aFtCenterY.Enable();
//STRIP001 			aMtrCenterY.Enable();
//STRIP001 			aFtAngle.Enable();
//STRIP001 			aMtrAngle.Enable();
//STRIP001 			break;
//STRIP001 	}
//STRIP001 }


}
