/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_fmvwimp.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:47:48 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#pragma hdrstop

#ifndef _COM_SUN_STAR_AWT_XFOCUSLISTENER_HPP_
#include <com/sun/star/awt/XFocusListener.hpp>
#endif

#ifndef _COM_SUN_STAR_SDBC_XROWSETLISTENER_HPP_
#include <com/sun/star/sdbc/XRowSetListener.hpp>
#endif

#ifndef _COM_SUN_STAR_SDB_XSQLQUERYCOMPOSERFACTORY_HPP_
#include <com/sun/star/sdb/XSQLQueryComposerFactory.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif

#ifndef _COM_SUN_STAR_CONTAINER_XCONTAINER_HPP_
#include <com/sun/star/container/XContainer.hpp>
#endif

#ifndef _SVX_FMCTRLER_HXX
#include <fmctrler.hxx>
#endif

#ifndef _SVX_FMVWIMP_HXX
#include "fmvwimp.hxx"
#endif
// auto strip #ifndef _SVX_FMGLOB_HXX
// auto strip #include "fmglob.hxx"
// auto strip #endif
// auto strip #ifndef _SVX_DIALMGR_HXX //autogen
// auto strip #include "dialmgr.hxx"
// auto strip #endif
#ifndef _SVX_FMRESIDS_HRC
#include "fmresids.hrc"
#endif
// auto strip #ifndef _SVX_FMOBJ_HXX
// auto strip #include "fmobj.hxx"
// auto strip #endif
// auto strip #ifndef _SVDOGRP_HXX 
// auto strip #include "svdogrp.hxx"
// auto strip #endif
#ifndef _SVDITER_HXX
#include "svditer.hxx"
#endif

// auto strip #ifndef _COM_SUN_STAR_SDBC_XROWSET_HPP_
// auto strip #include <com/sun/star/sdbc/XRowSet.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_FORM_XLOADABLE_HPP_
// auto strip #include <com/sun/star/form/XLoadable.hpp>
// auto strip #endif

// auto strip #ifndef _COM_SUN_STAR_UTIL_XNUMBERFORMATSSUPPLIER_HPP_
// auto strip #include <com/sun/star/util/XNumberFormatsSupplier.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_UTIL_XNUMBERFORMATS_HPP_
// auto strip #include <com/sun/star/util/XNumberFormats.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_SDB_COMMANDTYPE_HPP_
// auto strip #include <com/sun/star/sdb/CommandType.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_SDBC_DATATYPE_HPP_
// auto strip #include <com/sun/star/sdbc/DataType.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_SDBC_COLUMNVALUE_HPP_
// auto strip #include <com/sun/star/sdbc/ColumnValue.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_FORM_FORMCOMPONENTTYPE_HPP_
// auto strip #include <com/sun/star/form/FormComponentType.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_FORM_XRESET_HPP_
// auto strip #include <com/sun/star/form/XReset.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_AWT_XTABCONTROLLERMODEL_HPP_
// auto strip #include <com/sun/star/awt/XTabControllerModel.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_AWT_XCONTROLCONTAINER_HPP_
// auto strip #include <com/sun/star/awt/XControlContainer.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_AWT_XTABCONTROLLER_HPP_
// auto strip #include <com/sun/star/awt/XTabController.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_CONTAINER_XINDEXACCESS_HPP_
// auto strip #include <com/sun/star/container/XIndexAccess.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_AWT_XCONTROL_HPP_
// auto strip #include <com/sun/star/awt/XControl.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_LANG_XUNOTUNNEL_HPP_
// auto strip #include <com/sun/star/lang/XUnoTunnel.hpp>
// auto strip #endif
#ifndef _COM_SUN_STAR_SDBCX_XTABLESSUPPLIER_HPP_ 
#include <com/sun/star/sdbcx/XTablesSupplier.hpp>
#endif
// auto strip #ifndef _COM_SUN_STAR_SDBC_XPREPAREDSTATEMENT_HPP_
// auto strip #include <com/sun/star/sdbc/XPreparedStatement.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_SDB_XQUERIESSUPPLIER_HPP_
// auto strip #include <com/sun/star/sdb/XQueriesSupplier.hpp>
// auto strip #endif
#ifndef _SVX_FMMODEL_HXX
#include <fmmodel.hxx>
#endif

// auto strip #ifndef _SVX_FMUNDO_HXX
// auto strip #include "fmundo.hxx"
// auto strip #endif

#ifndef _SVX_FMPAGE_HXX
#include "fmpage.hxx"
#endif
#ifndef _SVX_FMUNOPGE_HXX
#include "fmpgeimp.hxx"
#endif
// auto strip #ifndef _SVX_FMVIEW_HXX
// auto strip #include "fmview.hxx"
// auto strip #endif
#ifndef _SVX_FMSHELL_HXX
#include "fmshell.hxx"
#endif
#ifndef _SVX_FMSHIMP_HXX
#include "fmshimp.hxx"
#endif
// auto strip #ifndef _SVX_FMTOOLS_HXX
// auto strip #include "fmtools.hxx"
// auto strip #endif
#ifndef _SVX_FMPROP_HRC
#include "fmprop.hrc"
#endif
// auto strip #ifndef _SV_MSGBOX_HXX
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
#ifndef _SVDPAGV_HXX
#include "svdpagv.hxx"
#endif
// auto strip #ifndef _SVX_DATACCESSDESCRIPTOR_HXX_ 
// auto strip #include "dataaccessdescriptor.hxx"
// auto strip #endif
// auto strip #ifndef _COMPHELPER_EXTRACT_HXX_
// auto strip #include <comphelper/extract.hxx>
// auto strip #endif
#ifndef _COMPHELPER_ENUMHELPER_HXX_
#include <comphelper/enumhelper.hxx>
#endif
// auto strip #ifndef _COMPHELPER_PROPERTY_HXX_
// auto strip #include <comphelper/property.hxx>
// auto strip #endif
// auto strip #ifndef _COMPHELPER_NUMBERS_HXX_
// auto strip #include <comphelper/numbers.hxx>
// auto strip #endif

#include <algorithm>
namespace binfilter {

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::sdbcx;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::sdb;
using namespace ::com::sun::star::container;
using namespace ::com::sun::star::form;
using namespace ::com::sun::star::awt;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::util;
using namespace ::comphelper;
using namespace ::binfilter::svxform;//STRIP008 using namespace ::svxform;
using namespace ::binfilter ::svx;

namespace svxform
{
	//========================================================================
//STRIP001 	class OAutoDispose
//STRIP001 	{
//STRIP001 	protected:
//STRIP001 		Reference< XComponent >	m_xComp;
//STRIP001 
//STRIP001 	public:
//STRIP001 		OAutoDispose( const Reference< XInterface > _rxObject );
//STRIP001 		~OAutoDispose();
//STRIP001 	};

	//------------------------------------------------------------------------
//STRIP001 	OAutoDispose::OAutoDispose( const Reference< XInterface > _rxObject )
//STRIP001 		:m_xComp(_rxObject, UNO_QUERY)
//STRIP001 	{
//STRIP001 	}

	//------------------------------------------------------------------------
//STRIP001 	OAutoDispose::~OAutoDispose()
//STRIP001 	{
//STRIP001 		if (m_xComp.is())
//STRIP001 			m_xComp->dispose();
//STRIP001 	}
}

//------------------------------------------------------------------------------
class FmXFormView::ObjectRemoveListener : public SfxListener
{
	FmXFormView* m_pParent;
public:
	ObjectRemoveListener( FmXFormView* pParent );
	virtual void Notify( SfxBroadcaster& rBC, const SfxHint& rHint );
};

//========================================================================
/*N*/ DBG_NAME(FmXPageViewWinRec)
//------------------------------------------------------------------------
/*N*/ FmXPageViewWinRec::FmXPageViewWinRec(const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >&	_xORB,
/*N*/ 									 const SdrPageViewWinRec* pWinRec,
/*N*/ 								   FmXFormView* _pViewImpl)
/*N*/ 				 :m_pViewImpl(_pViewImpl)
/*N*/ 				 ,m_pWindow( (Window*)pWinRec->GetOutputDevice() )
/*N*/ 				 ,m_xORB(_xORB)
/*N*/ {
/*N*/ 	DBG_CTOR(FmXPageViewWinRec,NULL);
/*N*/ 
/*N*/ 	// legt fuer jede ::com::sun::star::form ein FormController an
/*N*/ 	FmFormPage* pP = NULL;
/*N*/ 	if (m_pViewImpl)
/*N*/ 		pP = PTR_CAST(FmFormPage,m_pViewImpl->getView()->GetPageViewPvNum(0)->GetPage());
/*N*/ 
/*N*/ 	DBG_ASSERT(pP,"kein Page gefunden");
/*N*/ 
/*N*/ 	if (pP)
/*N*/ 	{
/*N*/ 		Reference< XIndexAccess >  xForms(pP->GetForms(), UNO_QUERY);
/*N*/ 		sal_uInt32 nLength = xForms->getCount();
/*N*/ 		Any aElement;
/*N*/ 		Reference< XForm >  xForm;
/*N*/ 		for (sal_uInt32 i = 0; i < nLength; i++)
/*N*/ 		{
/*N*/ 			xForms->getByIndex(i) >>= xForm;
/*N*/ 			setController(xForm, pWinRec->GetControlContainerRef() );
/*N*/ 		}
/*N*/ 	}
/*N*/ }
// -----------------------------------------------------------------------------
/*N*/ FmXPageViewWinRec::~FmXPageViewWinRec()
/*N*/ {
/*N*/ 	DBG_DTOR(FmXPageViewWinRec,NULL);
/*N*/ }

//------------------------------------------------------------------
/*N*/ void FmXPageViewWinRec::dispose()
/*N*/ {
/*N*/ 	for (vector< ::com::sun::star::uno::Reference< ::com::sun::star::form::XFormController > >::const_iterator i = m_aControllerList.begin();
/*N*/ 			i != m_aControllerList.end(); i++)
/*N*/ 	{
/*N*/ 		// detaching the events
/*N*/ 		::com::sun::star::uno::Reference< ::com::sun::star::container::XChild >  xChild((*i)->getModel(), ::com::sun::star::uno::UNO_QUERY);
/*N*/ 		if (xChild.is())
/*N*/ 		{
/*N*/ 			::com::sun::star::uno::Reference< ::com::sun::star::script::XEventAttacherManager >  xEventManager(xChild->getParent(), ::com::sun::star::uno::UNO_QUERY);
/*N*/ 			::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >  xIfc(*i, ::com::sun::star::uno::UNO_QUERY);
/*N*/ 			xEventManager->detach( i - m_aControllerList.begin(), xIfc );
/*N*/ 		}
/*N*/ 
/*N*/ 		// dispose the formcontroller
/*N*/ 		::com::sun::star::uno::Reference< ::com::sun::star::lang::XComponent >  xComp(*i, ::com::sun::star::uno::UNO_QUERY);
/*N*/ 		xComp->dispose();
/*N*/ 	}
/*N*/ 	m_aControllerList.clear(); // this call deletes the formcontrollers
/*N*/ 	m_xORB = NULL;
/*N*/ }


//------------------------------------------------------------------------------
/*N*/ sal_Bool SAL_CALL FmXPageViewWinRec::hasElements(void) throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/ 	return getCount() != 0;
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ ::com::sun::star::uno::Type SAL_CALL  FmXPageViewWinRec::getElementType(void) throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/ 	return ::getCppuType((const ::com::sun::star::uno::Reference< ::com::sun::star::form::XFormController>*)0);
/*N*/ }

// ::com::sun::star::container::XEnumerationAccess			
//------------------------------------------------------------------------------
/*N*/ ::com::sun::star::uno::Reference< ::com::sun::star::container::XEnumeration >  SAL_CALL FmXPageViewWinRec::createEnumeration(void) throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/ 	return new ::comphelper::OEnumerationByIndex(this);
/*N*/ }

// ::com::sun::star::container::XIndexAccess
//------------------------------------------------------------------------------
/*N*/ sal_Int32 SAL_CALL FmXPageViewWinRec::getCount(void) throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/ 	return m_aControllerList.size();
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ ::com::sun::star::uno::Any SAL_CALL FmXPageViewWinRec::getByIndex(sal_Int32 nIndex) throw( ::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::lang::WrappedTargetException, ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/ 	if (nIndex < 0 ||
/*N*/ 		nIndex >= getCount())
/*N*/ 		throw ::com::sun::star::lang::IndexOutOfBoundsException();
/*N*/ 
/*N*/ 	::com::sun::star::uno::Any aElement;
/*N*/ 	aElement <<= m_aControllerList[nIndex];
/*N*/ 	return aElement;
/*N*/ }

//------------------------------------------------------------------------
//STRIP001 ::com::sun::star::uno::Reference< ::com::sun::star::form::XFormController >  getControllerSearchChilds( const ::com::sun::star::uno::Reference< ::com::sun::star::container::XIndexAccess > & xIndex, const ::com::sun::star::uno::Reference< ::com::sun::star::awt::XTabControllerModel > & xModel)
//STRIP001 {
//STRIP001 	if (xIndex.is() && xIndex->getCount())
//STRIP001 	{
//STRIP001 		::com::sun::star::uno::Reference< ::com::sun::star::form::XFormController >  xController;
//STRIP001 		
//STRIP001 		for (sal_Int32 n = xIndex->getCount(); n-- && !xController.is(); )
//STRIP001 		{
//STRIP001 			xIndex->getByIndex(n) >>= xController;
//STRIP001 			if ((::com::sun::star::awt::XTabControllerModel*)xModel.get() == (::com::sun::star::awt::XTabControllerModel*)xController->getModel().get())
//STRIP001 				return xController;
//STRIP001 			else
//STRIP001 			{
//STRIP001 				xController = getControllerSearchChilds(::com::sun::star::uno::Reference< ::com::sun::star::container::XIndexAccess > (xController, ::com::sun::star::uno::UNO_QUERY), xModel);
//STRIP001 				if ( xController.is() )
//STRIP001 					return xController;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return ::com::sun::star::uno::Reference< ::com::sun::star::form::XFormController > ();
//STRIP001 }

// Search the according controller
//------------------------------------------------------------------------
//STRIP001 ::com::sun::star::uno::Reference< ::com::sun::star::form::XFormController >  FmXPageViewWinRec::getController( const ::com::sun::star::uno::Reference< ::com::sun::star::form::XForm > & xForm )
//STRIP001 {
//STRIP001 	::com::sun::star::uno::Reference< ::com::sun::star::awt::XTabControllerModel >  xModel(xForm, ::com::sun::star::uno::UNO_QUERY);
//STRIP001 	for (::std::vector< ::com::sun::star::uno::Reference< ::com::sun::star::form::XFormController > >::const_iterator i = m_aControllerList.begin();
//STRIP001 		 i != m_aControllerList.end(); i++)
//STRIP001 	{
//STRIP001 		if ((::com::sun::star::awt::XTabControllerModel*)(*i)->getModel().get() == (::com::sun::star::awt::XTabControllerModel*)xModel.get())
//STRIP001 			return *i;
//STRIP001 
//STRIP001 		// the current-round controller isn't the right one. perhaps one of it's children ?
//STRIP001 		::com::sun::star::uno::Reference< ::com::sun::star::form::XFormController >  xChildSearch = getControllerSearchChilds(::com::sun::star::uno::Reference< ::com::sun::star::container::XIndexAccess > (*i, ::com::sun::star::uno::UNO_QUERY), xModel);
//STRIP001 		if (xChildSearch.is())
//STRIP001 			return xChildSearch;
//STRIP001 	}
//STRIP001 	return ::com::sun::star::uno::Reference< ::com::sun::star::form::XFormController > ();
//STRIP001 }

//------------------------------------------------------------------------
/*N*/ void FmXPageViewWinRec::setController(const ::com::sun::star::uno::Reference< ::com::sun::star::form::XForm > & xForm,
/*N*/ 									 const ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlContainer > & xCC,
/*N*/ 									 FmXFormController* pParent)
/*N*/ {
/*N*/ 	DBG_ASSERT(xForm.is(), "Kein Formular angegeben");
/*N*/ 	::com::sun::star::uno::Reference< ::com::sun::star::container::XIndexAccess >  xFormCps(xForm, ::com::sun::star::uno::UNO_QUERY);
/*N*/ 	if (!xFormCps.is())
/*N*/ 		return;
/*N*/ 
/*N*/ 	::com::sun::star::uno::Reference< ::com::sun::star::awt::XTabControllerModel >  xTabOrder(xForm, ::com::sun::star::uno::UNO_QUERY);
/*N*/ 
/*N*/ 	FmFormPage* pCurrentPage = PTR_CAST(FmFormPage, m_pViewImpl->getView()->GetPageViewPvNum(0)->GetPage());
/*N*/ 	DBG_ASSERT(pCurrentPage, "FmXPageViewWinRec::setController: could not retrieve my page !");
/*N*/ 	String sPageId = pCurrentPage ? pCurrentPage->GetImpl()->GetPageId() : String::CreateFromAscii("no page");
/*N*/ 		// this "no page" should result in a empty ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatch >  provided by the controller's external dispatcher
/*N*/ 
/*N*/ 	// Anlegen des Tabcontrollers
/*N*/ 	FmXFormController* pController = new FmXFormController(m_xORB,m_pViewImpl->getView(), m_pWindow, sPageId);
/*N*/ 	::com::sun::star::uno::Reference< ::com::sun::star::form::XFormController >  xController(pController);
/*N*/ 
/*N*/ 	pController->setModel(xTabOrder);
/*N*/ 	pController->setContainer(xCC);
/*N*/ 	pController->activateTabOrder();
/*N*/ 	pController->addActivateListener(m_pViewImpl);
/*N*/ 
/*N*/ 	if (pParent)
/*?*/		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 		pParent->addChild(pController);
/*N*/ 	else
/*N*/ 	{
/*N*/ 		//	::com::sun::star::uno::Reference< ::com::sun::star::form::XFormController >  xController(pController);
/*N*/ 		m_aControllerList.push_back(xController);
/*N*/ 
/*N*/ 		pController->setParent(*this);
/*N*/ 
/*N*/ 		// attaching the events
/*N*/ 		::com::sun::star::uno::Reference< ::com::sun::star::script::XEventAttacherManager >  xEventManager(xForm->getParent(), ::com::sun::star::uno::UNO_QUERY);
/*N*/ 		::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >  xIfc(xController, ::com::sun::star::uno::UNO_QUERY);
/*N*/ 		xEventManager->attach(m_aControllerList.size() - 1, xIfc, ::com::sun::star::uno::makeAny(xController) );
/*N*/ 	}
/*N*/ 
/*N*/ 
/*N*/ 
/*N*/ 	// jetzt die Subforms durchgehen
/*N*/ 	sal_uInt32 nLength = xFormCps->getCount();
/*N*/ 	::com::sun::star::uno::Reference< ::com::sun::star::form::XForm >  xSubForm;
/*N*/ 	for (sal_uInt32 i = 0; i < nLength; i++)
/*N*/ 	{
/*N*/ 		xFormCps->getByIndex(i) >>= xSubForm;
/*N*/ 		if (xSubForm.is())
/*?*/ 			setController(xSubForm, xCC, pController);
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------
//STRIP001 void FmXPageViewWinRec::updateTabOrder( const ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControl > & xControl,
//STRIP001 									   const ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlContainer > & xCC )
//STRIP001 {
//STRIP001 	// Das TabControllerModel der ::com::sun::star::form ermitteln, in der das Control
//STRIP001 	// enthalten ist ...
//STRIP001 	::com::sun::star::uno::Reference< ::com::sun::star::form::XFormComponent >  xFormComp(xControl->getModel(), ::com::sun::star::uno::UNO_QUERY);
//STRIP001 	if (!xFormComp.is())
//STRIP001 		return;
//STRIP001 
//STRIP001 	::com::sun::star::uno::Reference< ::com::sun::star::form::XForm >  xForm(xFormComp->getParent(), ::com::sun::star::uno::UNO_QUERY);
//STRIP001 	if (!xForm.is())
//STRIP001 		return;
//STRIP001 
//STRIP001 	::com::sun::star::uno::Reference< ::com::sun::star::awt::XTabController >  xTabCtrl(getController( xForm ), ::com::sun::star::uno::UNO_QUERY);
//STRIP001 	// Wenn es fuer dieses Formular noch keinen Tabcontroller gibt,
//STRIP001 	// dann einen neuen anlegen
//STRIP001 	if (!xTabCtrl.is())
//STRIP001 	{
//STRIP001 		// ist es ein Unterformular?
//STRIP001 		// dann muss ein Tabcontroller fuer den Parent existieren
//STRIP001 		// wichtig da ein hierarchischer Aufbau vorliegt
//STRIP001 		::com::sun::star::uno::Reference< ::com::sun::star::form::XForm >  xParentForm(::com::sun::star::uno::Reference< ::com::sun::star::container::XChild > (xForm, ::com::sun::star::uno::UNO_QUERY)->getParent(), ::com::sun::star::uno::UNO_QUERY);
//STRIP001 		FmXFormController* pFormController = NULL;
//STRIP001 		// zugehoerigen controller suchen
//STRIP001 		if (xParentForm.is())
//STRIP001 			xTabCtrl = ::com::sun::star::uno::Reference< ::com::sun::star::awt::XTabController >(getController(xParentForm), ::com::sun::star::uno::UNO_QUERY);
//STRIP001 
//STRIP001 		if (xTabCtrl.is())
//STRIP001 		{
//STRIP001 			::com::sun::star::uno::Reference< ::com::sun::star::lang::XUnoTunnel > xTunnel(xTabCtrl,::com::sun::star::uno::UNO_QUERY);
//STRIP001 			DBG_ASSERT(xTunnel.is(), "FmPropController::ChangeFormatProperty : xTunnel is invalid!");
//STRIP001 			if(xTunnel.is())
//STRIP001 			{
//STRIP001 				pFormController = reinterpret_cast<FmXFormController*>(xTunnel->getSomething(FmXFormController::getUnoTunnelImplementationId()));
//STRIP001 			}
//STRIP001 			//	::comphelper::getImplementation(pFormController, xTunnel);
//STRIP001 		}
//STRIP001 
//STRIP001 		// Es gibt noch keinen TabController fuer das Formular, also muss
//STRIP001 		// ein neuer angelegt werden.
//STRIP001 		setController(xForm, xCC, pFormController);
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------
/*N*/ ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlContainer >  FmXPageViewWinRec::getControlContainer() const
/*N*/ {
/*N*/ 	::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlContainer >  xCC;
/*N*/ 	if (m_aControllerList.size())
/*N*/ 		xCC = m_aControllerList[0]->getContainer();
/*N*/ 	return xCC;
/*N*/ }

//------------------------------------------------------------------------
/*N*/ FmXFormView::FmXFormView(const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >&	_xORB,
/*N*/ 			FmFormView* _pView)
/*N*/ 	:m_pView(_pView)
/*N*/ 	,m_xORB( _xORB )
/*N*/ 	,m_nActivationEvent(0)
/*N*/ 	,m_nErrorMessageEvent( 0 )
/*N*/ 	,m_nAutoFocusEvent( 0 )
/*N*/ 	,m_pWatchStoredList( NULL )
/*N*/ 	,m_bFirstActivation( sal_True )
/*N*/ 	,m_pMarkedGrid(NULL)
/*N*/ {
/*N*/ }

//------------------------------------------------------------------------
/*N*/ void FmXFormView::cancelEvents()
/*N*/ {
/*N*/ 	if ( m_nActivationEvent )
/*N*/ 	{
/*?*/ 		Application::RemoveUserEvent( m_nActivationEvent );
/*?*/ 		m_nActivationEvent = 0;
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( m_nErrorMessageEvent )
/*N*/ 	{
/*?*/ 		Application::RemoveUserEvent( m_nErrorMessageEvent );
/*?*/ 		m_nErrorMessageEvent = 0;
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( m_nAutoFocusEvent )
/*N*/ 	{
/*?*/         Application::RemoveUserEvent( m_nAutoFocusEvent );
/*?*/ 		m_nAutoFocusEvent = 0;
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------
/*N*/ void FmXFormView::notifyViewDying( )
/*N*/ {
/*N*/ 	DBG_ASSERT( m_pView, "FmXFormView::notifyViewDying: my view already died!" );
/*N*/ 	m_pView = NULL;
/*N*/ 	cancelEvents();
/*N*/ }

//------------------------------------------------------------------------
/*N*/ FmXFormView::~FmXFormView()
/*N*/ {
/*N*/ 	DBG_ASSERT(m_aWinList.size() == 0, "Liste nicht leer");
/*N*/ 
/*N*/ 	cancelEvents();
/*N*/ 
/*N*/ 	delete m_pWatchStoredList;
/*N*/ 	m_pWatchStoredList = NULL;
/*N*/ }

//      EventListener
//------------------------------------------------------------------------------
/*N*/ void SAL_CALL FmXFormView::disposing(const ::com::sun::star::lang::EventObject& Source) throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/ 	if ( m_xWindow.is() && Source.Source == m_xWindow )
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");}//STRIP001 removeGridWindowListening();
/*N*/ }

// ::com::sun::star::form::XFormControllerListener
//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormView::formActivated(const ::com::sun::star::lang::EventObject& rEvent) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	::com::sun::star::uno::Reference< ::com::sun::star::form::XFormController >  xController(rEvent.Source, ::com::sun::star::uno::UNO_QUERY);
//STRIP001 	// benachrichtigung der Shell
//STRIP001 	if (m_pView && m_pView->GetFormShell())
//STRIP001 	{
//STRIP001 		FmXFormShell* pShImpl =  m_pView->GetFormShell()->GetImpl();
//STRIP001 		if (pShImpl)
//STRIP001 			pShImpl->setActiveController(xController);
//STRIP001 	}
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormView::formDeactivated(const ::com::sun::star::lang::EventObject& rEvent) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ 	// deaktivierung wird nicht registriert
/*?*/ }

// ::com::sun::star::container::XContainerListener
//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormView::elementInserted(const ::com::sun::star::container::ContainerEvent& evt) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlContainer >  xCC(evt.Source, ::com::sun::star::uno::UNO_QUERY);
//STRIP001 	if( xCC.is() )
//STRIP001 	{
//STRIP001 		FmWinRecList::iterator i = findWindow( xCC );
//STRIP001 		
//STRIP001 		if ( i != m_aWinList.end() )
//STRIP001 		{
//STRIP001 			::com::sun::star::uno::Reference< ::com::sun::star::awt::XControl >  xControl;
//STRIP001 			evt.Element >>= xControl;
//STRIP001 			if( xControl.is() )
//STRIP001 				(*i)->updateTabOrder( xControl, xCC );
//STRIP001 		}
//STRIP001 	}
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormView::elementReplaced(const ::com::sun::star::container::ContainerEvent& evt) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	elementInserted(evt);
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormView::elementRemoved(const ::com::sun::star::container::ContainerEvent& evt) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ }

//------------------------------------------------------------------------------
//STRIP001 FmWinRecList::const_iterator FmXFormView::findWindow( const ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlContainer > & rCC )  const
//STRIP001 {
//STRIP001 	for (FmWinRecList::const_iterator i = m_aWinList.begin();
//STRIP001 			i != m_aWinList.end(); i++)
//STRIP001 	{
//STRIP001 		if (rCC == (*i)->getControlContainer())
//STRIP001 			return i;
//STRIP001 	}
//STRIP001 	return m_aWinList.end();
//STRIP001 }

//------------------------------------------------------------------------------
/*N*/ FmWinRecList::iterator FmXFormView::findWindow( const ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlContainer > & rCC )
/*N*/ {
/*N*/ 	for (FmWinRecList::iterator i = m_aWinList.begin();
/*N*/ 			i != m_aWinList.end(); i++)
/*N*/ 	{
/*N*/ 		if (rCC == (*i)->getControlContainer())
/*N*/ 			return i;
/*N*/ 	}
/*N*/ 	return m_aWinList.end();
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormView::addWindow(const SdrPageViewWinRec* pRec)
/*N*/ {
/*N*/ 	// Wird gerufen, wenn
/*N*/ 	// - in den aktiven Modus geschaltet wird
/*N*/ 	// - ein Window hinzugefuegt wird, waehrend man im Design-Modus ist
/*N*/ 	// - der Control-Container fuer ein Window angelegt wird, waehrend
/*N*/ 	//   der aktive Modus eingeschaltet ist.
/*N*/ 
/*N*/ 	// Wenn es noch keinen Control-Container gibt oder am Control-Container
/*N*/ 	// noch keine Peer Erzeugt wurde, dann ist es noch zu frueh, um die
/*N*/ 	// Tab-Order einzustellen ...
/*N*/ 	if( pRec->GetOutputDevice()->GetOutDevType() == OUTDEV_WINDOW  )
/*N*/ 	{
/*N*/ 		const ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlContainer > & rCC = pRec->GetControlContainerRef();
/*N*/ 		if ( rCC.is() && findWindow( rCC ) == m_aWinList.end())
/*N*/ 		{
/*N*/ 			FmXPageViewWinRec *pFmRec = new FmXPageViewWinRec(m_xORB,pRec, this);
/*N*/ 			pFmRec->acquire();
/*N*/ 
/*N*/ 			m_aWinList.push_back(pFmRec);
/*N*/ 
/*N*/ 			// Am ControlContainer horchen um Aenderungen mitzbekommen
/*N*/ 			::com::sun::star::uno::Reference< ::com::sun::star::container::XContainer >  xContainer(rCC, ::com::sun::star::uno::UNO_QUERY);
/*N*/ 			if (xContainer.is())
/*N*/ 				xContainer->addContainerListener(this);
/*N*/ 		}
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormView::removeWindow( const ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlContainer > & rCC )
/*N*/ {
/*N*/ 	// Wird gerufen, wenn
/*N*/ 	// - in den Design-Modus geschaltet wird
/*N*/ 	// - ein Window geloescht wird, waehrend man im Design-Modus ist
/*N*/ 	// - der Control-Container fuer ein Window entfernt wird, waehrend
/*N*/ 	//   der aktive Modus eingeschaltet ist.
/*N*/ 	FmWinRecList::iterator i = findWindow( rCC );
/*N*/ 	if (i != m_aWinList.end())
/*N*/ 	{
/*N*/ 		// Am ControlContainer horchen um Aenderungen mitzbekommen
/*N*/ 		::com::sun::star::uno::Reference< ::com::sun::star::container::XContainer >  xContainer(rCC, ::com::sun::star::uno::UNO_QUERY);
/*N*/ 		if (xContainer.is())
/*N*/ 			xContainer->removeContainerListener(this);
/*N*/ 
/*N*/ 		(*i)->dispose();
/*N*/ 		(*i)->release();
/*N*/ 		m_aWinList.erase(i);
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormView::displayAsyncErrorMessage( const SQLErrorEvent& _rEvent )
//STRIP001 {
//STRIP001 	DBG_ASSERT( 0 == m_nErrorMessageEvent, "FmXFormView::displayAsyncErrorMessage: not too fast, please!" );
//STRIP001 		// This should not happen - usually, the PostUserEvent is faster than any possible user
//STRIP001 		// interaction which could trigger a new error. If it happens, we need a queue for the events.
//STRIP001 	m_aAsyncError = _rEvent;
//STRIP001 	m_nErrorMessageEvent = Application::PostUserEvent( LINK( this, FmXFormView, OnDelayedErrorMessage ) );
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 IMPL_LINK(FmXFormView, OnDelayedErrorMessage, void*, EMPTYTAG)
//STRIP001 {
//STRIP001 	m_nErrorMessageEvent = 0;
//STRIP001 	displayException( m_aAsyncError );
//STRIP001 	return 0L;
//STRIP001 }

//------------------------------------------------------------------------------
/*N*/ void FmXFormView::onFirstViewActivation( const FmFormModel* _pDocModel )
/*N*/ {
/*N*/ 	if ( _pDocModel && _pDocModel->GetAutoControlFocus() )
/*N*/ 		Application::PostUserEvent( LINK( this, FmXFormView, OnAutoFocus ) );
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ IMPL_LINK(FmXFormView, OnActivate, void*, EMPTYTAG)
/*N*/ {
/*N*/ 	m_nActivationEvent = 0;
/*N*/ 
/*N*/ 	if ( !m_pView )
/*N*/ 	{
/*N*/ 		DBG_ERROR( "FmXFormView::OnActivate: well .... seems we have a timing problem (the view already died)!" );
/*N*/ 		return 0;
/*N*/ 	}
/*N*/ 
/*N*/ 	// setting the controller to activate
/*N*/ 	if (m_pView->GetFormShell() && m_pView->GetActualOutDev() && m_pView->GetActualOutDev()->GetOutDevType() == OUTDEV_WINDOW)
/*N*/ 	{
/*N*/ 		Window* pWindow = const_cast<Window*>(static_cast<const Window*>(m_pView->GetActualOutDev()));
/*N*/ 		FmXPageViewWinRec* pFmRec = m_aWinList.size() ? m_aWinList[0] : NULL;
/*N*/ 		for (FmWinRecList::const_iterator i = m_aWinList.begin();
/*N*/ 			i != m_aWinList.end(); i++)
/*N*/ 		{
/*?*/ 			if (pWindow == (*i)->getWindow())
/*?*/ 				pFmRec =*i;
/*N*/ 		}
/*N*/ 
/*N*/ 		if (pFmRec)
/*N*/ 		{
/*?*/ 			for (vector< Reference< XFormController > >::const_iterator i = pFmRec->GetList().begin();
/*?*/ 				i != pFmRec->GetList().end(); i++)
/*?*/ 			{
/*?*/ 				const Reference< XFormController > & xController = *i;
/*?*/ 				if (xController.is())
/*?*/ 				{
/*?*/					DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 					// Nur bei Datenbankformularen erfolgt eine aktivierung
//STRIP001 /*?*/ 					Reference< XRowSet >  xForm(xController->getModel(), UNO_QUERY);
//STRIP001 /*?*/ 					if (xForm.is() && OStaticDataAccessTools().getRowSetConnection(xForm).is())
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						Reference< XPropertySet >  xFormSet(xForm, UNO_QUERY);
//STRIP001 /*?*/ 						if (xFormSet.is())
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							// wenn es eine Datenquelle gibt, dann als aktive ::com::sun::star::form setzen
//STRIP001 /*?*/ 							::rtl::OUString aSource = ::comphelper::getString(xFormSet->getPropertyValue(FM_PROP_COMMAND));
//STRIP001 /*?*/ 							if (aSource.getLength())
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								// benachrichtigung der Shell
//STRIP001 /*?*/ 								FmXFormShell* pShImpl =  m_pView->GetFormShell()->GetImpl();
//STRIP001 /*?*/ 								if (pShImpl)
//STRIP001 /*?*/ 									pShImpl->setActiveController(xController);
//STRIP001 /*?*/ 								break;
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 					}
/*?*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 	return 0;
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormView::Activate(sal_Bool bSync)
/*N*/ {
/*N*/ 	if (m_nActivationEvent)
/*N*/ 	{
/*?*/ 		Application::RemoveUserEvent(m_nActivationEvent);
/*?*/ 		m_nActivationEvent = 0;
/*N*/ 	}
/*N*/ 
/*N*/ 	if (bSync)
/*N*/ 	{
/*?*/ 		LINK(this,FmXFormView,OnActivate).Call(NULL);
/*N*/ 	}
/*N*/ 	else
/*N*/ 		m_nActivationEvent = Application::PostUserEvent(LINK(this,FmXFormView,OnActivate));
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormView::Deactivate(BOOL bDeactivateController)
/*N*/ {
/*N*/ 	if (m_nActivationEvent)
/*N*/ 	{
/*N*/ 		Application::RemoveUserEvent(m_nActivationEvent);
/*N*/ 		m_nActivationEvent = 0;
/*N*/ 	}
/*N*/ 
/*N*/ 	FmXFormShell* pShImpl =  m_pView->GetFormShell() ? m_pView->GetFormShell()->GetImpl() : NULL;
/*N*/ 	if (pShImpl && bDeactivateController)
/*N*/ 		pShImpl->setActiveController( NULL );
/*N*/ }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormView::AttachControl( const ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControl > & rControl, sal_Bool bDetach )
//STRIP001 {
//STRIP001 	/* wird im fmctrler gemacht */
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormView::AttachControls( const ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlContainer > & rCtrlContainer,
//STRIP001 								  sal_Bool bDetach )
//STRIP001 {
//STRIP001 }

//------------------------------------------------------------------------------
/*N*/ FmFormShell* FmXFormView::GetFormShell() const
/*N*/ {
/*N*/ 	return m_pView ? m_pView->GetFormShell() : NULL;
/*N*/ }
// -----------------------------------------------------------------------------
//STRIP001 void FmXFormView::AutoFocus( sal_Bool _bSync )
//STRIP001 {
//STRIP001 	if (m_nAutoFocusEvent)
//STRIP001 		  Application::RemoveUserEvent(m_nAutoFocusEvent);
//STRIP001 
//STRIP001 	if ( _bSync )
//STRIP001 		OnAutoFocus( NULL );
//STRIP001 	else
//STRIP001 		m_nAutoFocusEvent = Application::PostUserEvent(LINK(this, FmXFormView, OnAutoFocus));
//STRIP001 }
// -----------------------------------------------------------------------------
//STRIP001 static Reference< XControl > lcl_firstFocussableControl( const Sequence< Reference< XControl > >& _rControls )
//STRIP001 {
//STRIP001 	Reference< XControl > xReturn;
//STRIP001 
//STRIP001 	// loop through all the controls
//STRIP001 	const Reference< XControl >* pControls = _rControls.getConstArray();
//STRIP001 	const Reference< XControl >* pControlsEnd = _rControls.getConstArray() + _rControls.getLength();
//STRIP001 	for ( ; pControls != pControlsEnd; ++pControls )
//STRIP001 	{
//STRIP001 		try
//STRIP001 		{
//STRIP001 			// check the class id of the control model
//STRIP001 			sal_Int16 nClassId = FormComponentType::CONTROL;
//STRIP001 
//STRIP001 			Reference< XPropertySet > xModelProps;
//STRIP001 			if ( pControls->is() )
//STRIP001 				xModelProps = xModelProps.query( (*pControls)->getModel() );
//STRIP001 			if ( xModelProps.is() )
//STRIP001 				xModelProps->getPropertyValue( FM_PROP_CLASSID ) >>= nClassId;
//STRIP001 
//STRIP001 			// controls which are not focussable
//STRIP001 			if	(	( FormComponentType::CONTROL != nClassId )
//STRIP001 				&&	( FormComponentType::IMAGEBUTTON != nClassId )
//STRIP001 				&&	( FormComponentType::GROUPBOX != nClassId )
//STRIP001 				&&	( FormComponentType::FIXEDTEXT != nClassId )
//STRIP001 				&&	( FormComponentType::HIDDENCONTROL != nClassId )
//STRIP001 				&&	( FormComponentType::IMAGECONTROL != nClassId )
//STRIP001 				)
//STRIP001 			{
//STRIP001 				xReturn = *pControls;
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		catch( const Exception& e )
//STRIP001 		{
//STRIP001 			e;	// make compiler happy
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( !xReturn.is() && _rControls.getLength() )
//STRIP001 			xReturn = _rControls[0];
//STRIP001 	}
//STRIP001 
//STRIP001 	return xReturn;
//STRIP001 }

// -----------------------------------------------------------------------------
/*N*/ IMPL_LINK(FmXFormView, OnAutoFocus, void*, EMPTYTAG)
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	m_nAutoFocusEvent = 0;
//STRIP001 
//STRIP001 	// go to the first form of our page, examine it's TabController, go to it's first (in terms of the tab order)
//STRIP001 	// control, give it the focus
//STRIP001 
//STRIP001 	// get the forms collection of the page we belong to
//STRIP001 	FmFormPage* pPage = m_pView ? PTR_CAST(FmFormPage, m_pView->GetPageViewPvNum(0)->GetPage()) : NULL;
//STRIP001 	Reference< XIndexAccess > xForms;
//STRIP001 	if (pPage)
//STRIP001 		xForms = Reference< XIndexAccess >(pPage->GetForms(), UNO_QUERY);
//STRIP001 	FmXPageViewWinRec* pViewWinRec = m_aWinList.size() ? m_aWinList[0] : NULL;
//STRIP001 	if (pViewWinRec)
//STRIP001 	{
//STRIP001 		try
//STRIP001 		{
//STRIP001 			// go for the tab controller of the first form
//STRIP001 			sal_Int32 nObjects = xForms->getCount();
//STRIP001 			::com::sun::star::uno::Reference< XForm > xForm;
//STRIP001 			if (nObjects)
//STRIP001 				::cppu::extractInterface(xForm, xForms->getByIndex(0));
//STRIP001 
//STRIP001 			Reference< XTabController > xTabControllerModel(pViewWinRec->getController( xForm ), UNO_QUERY);
//STRIP001 			// go for the first control of the controller
//STRIP001 			Sequence< Reference< XControl > > aControls;
//STRIP001 			if (xTabControllerModel.is())
//STRIP001 				aControls = xTabControllerModel->getControls();
//STRIP001 
//STRIP001 			// set the focus to this first control
//STRIP001 			Reference< XWindow > xControlWindow( lcl_firstFocussableControl( aControls ), UNO_QUERY );
//STRIP001 			if (xControlWindow.is())
//STRIP001 				xControlWindow->setFocus();
//STRIP001 
//STRIP001 			// ensure that the control is visible
//STRIP001 			// 80210 - 12/07/00 - FS
//STRIP001 			if (xControlWindow.is() && m_pView->GetActualOutDev() && (OUTDEV_WINDOW == m_pView->GetActualOutDev()->GetOutDevType()))
//STRIP001 			{
//STRIP001 				const Window* pWindow = static_cast<const Window*>(m_pView->GetActualOutDev());
//STRIP001 				::com::sun::star::awt::Rectangle aRect = xControlWindow->getPosSize();
//STRIP001 				::Rectangle aNonUnoRect(aRect.X, aRect.Y, aRect.X + aRect.Width, aRect.Y + aRect.Height);
//STRIP001 				m_pView->MakeVisible(pWindow->PixelToLogic(aNonUnoRect), *const_cast<Window*>(pWindow));
//STRIP001 			}
//STRIP001 		}
//STRIP001 		catch(Exception&)
//STRIP001 		{
//STRIP001 			DBG_ERROR("FmXFormView::OnAutoFocus: could not activate the first control!");
//STRIP001 		}
//STRIP001 	}
/*N*/ 	return 0L;
/*N*/ }

// -----------------------------------------------------------------------------
//STRIP001 SdrObject* FmXFormView::implCreateFieldControl( const ::svx::ODataAccessDescriptor& _rColumnDescriptor )
//STRIP001 {
//STRIP001 	// not if we're in design mode
//STRIP001 	if ( !m_pView->IsDesignMode() )
//STRIP001 		return NULL;
//STRIP001 
//STRIP001 	// the very basic information
//STRIP001 	::rtl::OUString sDataSource, sCommand, sFieldName;
//STRIP001 	sal_Int32 nCommandType = CommandType::COMMAND;
//STRIP001 
//STRIP001 	_rColumnDescriptor[ daDataSource ]	>>= sDataSource;
//STRIP001 	_rColumnDescriptor[ daCommand ]		>>= sCommand;
//STRIP001 	_rColumnDescriptor[ daColumnName ]	>>= sFieldName;
//STRIP001 	_rColumnDescriptor[ daCommandType ]	>>= nCommandType;
//STRIP001 
//STRIP001 	if ( !sDataSource.getLength() || !sCommand.getLength() || !sFieldName.getLength() )
//STRIP001 		return NULL;
//STRIP001 
//STRIP001 	// additional (and optional) information
//STRIP001 	Reference< XConnection > xConnection;
//STRIP001 	if ( _rColumnDescriptor.has( daConnection ) )
//STRIP001 		_rColumnDescriptor[ daConnection ]  >>= xConnection;
//STRIP001 
//STRIP001 	// did we get the connection from outside (no need to dispose it then)?
//STRIP001 	sal_Bool bForeignConnection = xConnection.is();
//STRIP001 
//STRIP001 	// obtain the data source
//STRIP001 	Reference< XDataSource > xDataSource;
//STRIP001 	SQLErrorEvent aError;
//STRIP001 	try
//STRIP001 	{
//STRIP001 		xDataSource = OStaticDataAccessTools().getDataSource(sDataSource, getORB());
//STRIP001 		// and the connection, if necessary
//STRIP001 		if ( !bForeignConnection )
//STRIP001 			xConnection = OStaticDataAccessTools().getConnection_withFeedback(sDataSource,::rtl::OUString(),::rtl::OUString(), getORB());
//STRIP001 	}
//STRIP001 	catch(const SQLContext& e) { aError.Reason <<= e; }
//STRIP001 	catch(const SQLWarning& e) { aError.Reason <<= e; }
//STRIP001 	catch(const SQLException& e) { aError.Reason <<= e; }
//STRIP001 	if (aError.Reason.hasValue())
//STRIP001 	{
//STRIP001 		displayAsyncErrorMessage( aError );
//STRIP001 		return NULL;
//STRIP001 	}
//STRIP001 
//STRIP001 	// need a data source and a connection here
//STRIP001 	if (!xDataSource.is() || !xConnection.is())
//STRIP001 	{
//STRIP001 		DBG_ERROR("FmXFormView::implCreateFieldControl : could not retrieve the data source or the connection!");
//STRIP001 		return NULL;
//STRIP001 	}
//STRIP001 
//STRIP001 	// from now on, if something goes wrong, automatically dispose the connection
//STRIP001 	Reference< XInterface > xAutoDisposee;
//STRIP001 	if ( !bForeignConnection )
//STRIP001 		xAutoDisposee = xConnection.get();
//STRIP001 	OAutoDispose aDisposeConnection( xAutoDisposee );
//STRIP001 
//STRIP001 
//STRIP001 	OStaticDataAccessTools aDBATools;
//STRIP001 	Reference< XComponent > xKeepFieldsAlive;
//STRIP001 	// go
//STRIP001 	try
//STRIP001 	{
//STRIP001 		FmFormPage& rPage = *static_cast<FmFormPage*>(m_pView->GetPageViewPvNum(0)->GetPage());
//STRIP001 
//STRIP001 		// determine the table/query field which we should create a control for
//STRIP001 		Reference< XPropertySet >	xField;
//STRIP001 
//STRIP001 		Reference< XNameAccess >	xFields = aDBATools.getFieldsByCommandDescriptor(
//STRIP001 			xConnection, nCommandType, sCommand, xKeepFieldsAlive );
//STRIP001 
//STRIP001 		if (xFields.is() && xFields->hasByName(sFieldName))
//STRIP001 			xFields->getByName(sFieldName) >>= xField;
//STRIP001 
//STRIP001 		Reference< XNumberFormatsSupplier >  xSupplier = aDBATools.getNumberFormats(xConnection, sal_False);
//STRIP001 		if (!xSupplier.is() || !xField.is())
//STRIP001 			return NULL;
//STRIP001 
//STRIP001 		Reference< XNumberFormats >  xNumberFormats(xSupplier->getNumberFormats());
//STRIP001 		if (!xNumberFormats.is())
//STRIP001 			return NULL;
//STRIP001 
//STRIP001 		// Vom Feld werden nun zwei Informationen benoetigt:
//STRIP001 		// a.) Name des Feldes fuer Label und ControlSource
//STRIP001 		// b.) FormatKey, um festzustellen, welches Feld erzeugt werden soll
//STRIP001 		sal_Int32 nDataType = ::comphelper::getINT32(xField->getPropertyValue(FM_PROP_FIELDTYPE));
//STRIP001 		sal_Int32 nFormatKey = ::comphelper::getINT32(xField->getPropertyValue(FM_PROP_FORMATKEY));
//STRIP001 
//STRIP001 		::rtl::OUString sLabelPostfix;
//STRIP001 
//STRIP001 		////////////////////////////////////////////////////////////////
//STRIP001 		// nur fuer Textgroesse
//STRIP001 		OutputDevice* _pOutDev = NULL;
//STRIP001 		if (m_pView->GetActualOutDev() && m_pView->GetActualOutDev()->GetOutDevType() == OUTDEV_WINDOW)
//STRIP001 			_pOutDev = const_cast<OutputDevice*>(m_pView->GetActualOutDev());
//STRIP001 		else
//STRIP001 		{// OutDev suchen
//STRIP001 			SdrPageView* pPageView = m_pView->GetPageViewPvNum(0);
//STRIP001 			if( pPageView && !_pOutDev )
//STRIP001 			{
//STRIP001 				const SdrPageViewWinList& rWinList = pPageView->GetWinList();
//STRIP001 				for( sal_uInt16 i = 0; i < rWinList.GetCount(); i++ )
//STRIP001 				{
//STRIP001 					if( rWinList[i].GetOutputDevice()->GetOutDevType() == OUTDEV_WINDOW)
//STRIP001 					{
//STRIP001 						_pOutDev = rWinList[i].GetOutputDevice();
//STRIP001 						break;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if (!_pOutDev)
//STRIP001 			return NULL;
//STRIP001 
//STRIP001 		if ((DataType::BINARY == nDataType) || (DataType::VARBINARY == nDataType))
//STRIP001 			return NULL;
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// Anhand des FormatKeys wird festgestellt, welches Feld benoetigt wird
//STRIP001 		sal_uInt16 nOBJID = 0;
//STRIP001 		sal_Bool bDateNTimeField = sal_False;
//STRIP001 
//STRIP001 		sal_Bool bIsCurrency = sal_False;
//STRIP001 		if (::comphelper::hasProperty(FM_PROP_ISCURRENCY, xField))
//STRIP001 			bIsCurrency = ::comphelper::getBOOL(xField->getPropertyValue(FM_PROP_ISCURRENCY));
//STRIP001 
//STRIP001 		if (bIsCurrency)
//STRIP001 			nOBJID = OBJ_FM_CURRENCYFIELD;
//STRIP001 		else
//STRIP001 			switch (nDataType)
//STRIP001 			{
//STRIP001 				case DataType::LONGVARBINARY:
//STRIP001 					nOBJID = OBJ_FM_IMAGECONTROL;
//STRIP001 					break;
//STRIP001 				case DataType::LONGVARCHAR:
//STRIP001 					nOBJID = OBJ_FM_EDIT;
//STRIP001 					break;
//STRIP001 				case DataType::BINARY:
//STRIP001 				case DataType::VARBINARY:
//STRIP001 					return NULL;
//STRIP001 				case DataType::BIT:
//STRIP001 					nOBJID = OBJ_FM_CHECKBOX;
//STRIP001 					break;
//STRIP001 				case DataType::TINYINT:
//STRIP001 				case DataType::SMALLINT:
//STRIP001 				case DataType::INTEGER:
//STRIP001 					nOBJID = OBJ_FM_NUMERICFIELD;
//STRIP001 					break;
//STRIP001 				case DataType::REAL:
//STRIP001 				case DataType::DOUBLE:
//STRIP001 				case DataType::NUMERIC:
//STRIP001 				case DataType::DECIMAL:
//STRIP001 					nOBJID = OBJ_FM_FORMATTEDFIELD;
//STRIP001 					break;
//STRIP001 				case DataType::TIMESTAMP:
//STRIP001 					bDateNTimeField = sal_True;
//STRIP001 					sLabelPostfix = UniString(SVX_RES(RID_STR_DATETIME_LABELPOSTFIX)).GetToken(0, ';');
//STRIP001 					// DON'T break !
//STRIP001 				case DataType::DATE:
//STRIP001 					nOBJID = OBJ_FM_DATEFIELD;
//STRIP001 					break;
//STRIP001 				case DataType::TIME:
//STRIP001 					nOBJID = OBJ_FM_TIMEFIELD;
//STRIP001 					break;
//STRIP001 				case DataType::CHAR:
//STRIP001 				case DataType::VARCHAR:
//STRIP001 				default:
//STRIP001 					nOBJID = OBJ_FM_EDIT;
//STRIP001 					break;
//STRIP001 			}
//STRIP001 		if (!nOBJID)
//STRIP001 			return NULL;
//STRIP001 
//STRIP001 		FmFormObj* pLabel;
//STRIP001 		FmFormObj* pControl;
//STRIP001 		createControlLabelPair(_pOutDev, 0, xField, xNumberFormats, nOBJID, sLabelPostfix, pLabel, pControl);
//STRIP001 		if (!pLabel || !pControl)
//STRIP001 		{
//STRIP001 			delete pLabel;
//STRIP001 			delete pControl;
//STRIP001 			return NULL;
//STRIP001 		}
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// Feststellen ob eine ::com::sun::star::form erzeugt werden muss
//STRIP001 		// Dieses erledigt die Page fuer uns bzw. die PageImpl
//STRIP001 		Reference< XFormComponent >  xContent(pLabel->GetUnoControlModel(), UNO_QUERY);
//STRIP001 		Reference< XIndexContainer >  xContainer(rPage.GetImpl()->SetDefaults(xContent, xDataSource, sDataSource, sCommand, nCommandType), UNO_QUERY);
//STRIP001 		if (xContainer.is())
//STRIP001 			xContainer->insertByIndex(xContainer->getCount(), makeAny(xContent));
//STRIP001 
//STRIP001 		xContent = Reference< XFormComponent > (pControl->GetUnoControlModel(), UNO_QUERY);
//STRIP001 		xContainer = Reference< XIndexContainer > (rPage.GetImpl()->SetDefaults(xContent, xDataSource, 
//STRIP001 			sDataSource, sCommand, nCommandType), UNO_QUERY);
//STRIP001 		if (xContainer.is())
//STRIP001 			xContainer->insertByIndex(xContainer->getCount(), makeAny(xContent));
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// Objekte gruppieren
//STRIP001 		SdrObjGroup* pGroup  = new SdrObjGroup();
//STRIP001 		SdrObjList* pObjList = pGroup->GetSubList();
//STRIP001 		pObjList->InsertObject(pLabel);
//STRIP001 		pObjList->InsertObject(pControl);
//STRIP001 
//STRIP001 
//STRIP001 		if (bDateNTimeField)
//STRIP001 		{	// wir haben bis jetzt nur ein Datums-Feld eingefuegt, brauchen aber noch ein extra Feld fuer
//STRIP001 			// die Zeit-Komponente
//STRIP001 			pLabel = pControl = NULL;
//STRIP001 			createControlLabelPair(_pOutDev, 1000, xField, xNumberFormats, OBJ_FM_TIMEFIELD,
//STRIP001 				UniString(SVX_RES(RID_STR_DATETIME_LABELPOSTFIX)).GetToken(1, ';'),
//STRIP001 				pLabel, pControl);
//STRIP001 
//STRIP001 			if (pLabel && pControl)
//STRIP001 			{
//STRIP001 				pObjList->InsertObject(pLabel);
//STRIP001 				pObjList->InsertObject(pControl);
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				delete pLabel;
//STRIP001 				delete pControl;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		return pGroup; // und fertig
//STRIP001 	}
//STRIP001 	catch(const Exception&)
//STRIP001 	{
//STRIP001 		DBG_ERROR("FmXFormView::implCreateFieldControl: caught an exception while creating the control !");
//STRIP001 	}
//STRIP001 	
//STRIP001 
//STRIP001 	return NULL;
//STRIP001 }

//------------------------------------------------------------------------
//STRIP001 void FmXFormView::createControlLabelPair(OutputDevice* _pOutDev, sal_Int32 _nYOffsetMM,
//STRIP001 	const Reference< XPropertySet >& _rxField, const Reference< XNumberFormats >& _rxNumberFormats,
//STRIP001 	sal_uInt16 _nObjID, const ::rtl::OUString& _rFieldPostfix,
//STRIP001 	FmFormObj*& _rpLabel, FmFormObj*& _rpControl) const
//STRIP001 {
//STRIP001 	sal_Int32 nDataType = ::comphelper::getINT32(_rxField->getPropertyValue(FM_PROP_FIELDTYPE));
//STRIP001 	sal_Int32 nFormatKey = ::comphelper::getINT32(_rxField->getPropertyValue(FM_PROP_FORMATKEY));
//STRIP001 
//STRIP001 	Any aFieldName(_rxField->getPropertyValue(FM_PROP_NAME));
//STRIP001 	::rtl::OUString sFieldName;
//STRIP001 	aFieldName >>= sFieldName;
//STRIP001 
//STRIP001 	// das Label
//STRIP001 	_rpLabel = (FmFormObj*)SdrObjFactory::MakeNewObject( FmFormInventor, OBJ_FM_FIXEDTEXT, NULL, NULL );
//STRIP001 	Reference< ::com::sun::star::beans::XPropertySet >  xLabelSet(_rpLabel->GetUnoControlModel(), UNO_QUERY);
//STRIP001 	xLabelSet->setPropertyValue(FM_PROP_LABEL, makeAny(sFieldName + _rFieldPostfix));
//STRIP001 
//STRIP001 	// positionieren unter Beachtung der Einstellungen des Ziel-Output-Devices
//STRIP001 	::Size aTextSize(_pOutDev->GetTextWidth(sFieldName + _rFieldPostfix), _pOutDev->GetTextHeight());
//STRIP001 
//STRIP001 	SdrModel* pModel	= m_pView->GetModel();
//STRIP001 	MapMode   eTargetMode(_pOutDev->GetMapMode()),
//STRIP001 			  eSourceMode(MAP_100TH_MM);
//STRIP001 
//STRIP001 	// Textbreite ist mindestens 5cm
//STRIP001 	// Texthoehe immer halber cm
//STRIP001 	::Size aDefTxtSize(3000, 500);
//STRIP001 	::Size aDefSize(4000, 500);
//STRIP001 	::Size aDefImageSize(4000, 4000);
//STRIP001 	// Abstand zwischen Text und Control
//STRIP001 	::Size aDelta(500, 0);
//STRIP001 
//STRIP001 	::Size aRealSize = _pOutDev->LogicToLogic(aTextSize, eTargetMode, eSourceMode);
//STRIP001 	aRealSize.Width() = std::max(aRealSize.Width(), aDefTxtSize.Width()) + aDelta.Width();
//STRIP001 	aRealSize.Height()= aDefSize.Height();
//STRIP001 
//STRIP001 	// je nach Skalierung des Zieldevices muss die Groesse noch normiert werden (#53523#)
//STRIP001 	aRealSize.Width() = sal_Int32(Fraction(aRealSize.Width(), 1) * eTargetMode.GetScaleX());
//STRIP001 	aRealSize.Height() = sal_Int32(Fraction(aRealSize.Height(), 1) * eTargetMode.GetScaleY());
//STRIP001 	_rpLabel->SetLogicRect(
//STRIP001 		::Rectangle(	_pOutDev->LogicToLogic(Point(0, _nYOffsetMM), eSourceMode, eTargetMode),
//STRIP001 					_pOutDev->LogicToLogic(aRealSize, eSourceMode, eTargetMode)
//STRIP001 		));
//STRIP001 
//STRIP001 	// jetzt das Control
//STRIP001 	_rpControl = static_cast<FmFormObj*>(SdrObjFactory::MakeNewObject( FmFormInventor, _nObjID, NULL, NULL ));
//STRIP001 
//STRIP001 	// positionieren
//STRIP001 	::Size szControlSize;
//STRIP001 	if (DataType::BIT == nDataType)
//STRIP001 		szControlSize = aDefSize;
//STRIP001 	else if (OBJ_FM_IMAGECONTROL == _nObjID || DataType::LONGVARCHAR == nDataType)
//STRIP001 		szControlSize = aDefImageSize;
//STRIP001 	else
//STRIP001 		szControlSize = aDefSize;
//STRIP001 
//STRIP001 	// normieren wie oben
//STRIP001 	szControlSize.Width() = sal_Int32(Fraction(szControlSize.Width(), 1) * eTargetMode.GetScaleX());
//STRIP001 	szControlSize.Height() = sal_Int32(Fraction(szControlSize.Height(), 1) * eTargetMode.GetScaleY());
//STRIP001 	_rpControl->SetLogicRect(
//STRIP001 		::Rectangle(	_pOutDev->LogicToLogic(Point(aRealSize.Width(), _nYOffsetMM), eSourceMode, eTargetMode),
//STRIP001 					_pOutDev->LogicToLogic(szControlSize, eSourceMode, eTargetMode)
//STRIP001 		));
//STRIP001 
//STRIP001 	// ein paar initiale Einstellungen am ControlModel
//STRIP001 	Reference< ::com::sun::star::beans::XPropertySet >  xControlSet = Reference< ::com::sun::star::beans::XPropertySet > (_rpControl->GetUnoControlModel(), UNO_QUERY);
//STRIP001 	if (xControlSet.is())
//STRIP001 	{
//STRIP001 		// ein paar numersiche Eigenschaften durchschleifen
//STRIP001 		if (::comphelper::hasProperty(FM_PROP_DECIMAL_ACCURACY, xControlSet))
//STRIP001 		{
//STRIP001 			// Number braucht eine Scale
//STRIP001 			Any aScaleVal(::comphelper::getNumberFormatDecimals(_rxNumberFormats, nFormatKey));
//STRIP001 			xControlSet->setPropertyValue(FM_PROP_DECIMAL_ACCURACY, aScaleVal);
//STRIP001 		}
//STRIP001 		if (::comphelper::hasProperty(FM_PROP_VALUEMIN, xControlSet) && ::comphelper::hasProperty(FM_PROP_VALUEMAX, xControlSet))
//STRIP001 		{
//STRIP001 			// die minimale/maximale Zahl in diesem Feld
//STRIP001 			sal_Int32 nMinValue = -1000000000, nMaxValue = 1000000000;
//STRIP001 			switch (nDataType)
//STRIP001 			{
//STRIP001 				case DataType::TINYINT	: nMinValue = 0; nMaxValue = 255; break;
//STRIP001 				case DataType::SMALLINT	: nMinValue = -32768; nMaxValue = 32767; break;
//STRIP001 				case DataType::INTEGER	: nMinValue = 0x80000000; nMaxValue = 0x7FFFFFFF; break;
//STRIP001 					// um die doubles/singles kuemmere ich mich nicht, da es ein wenig sinnlos ist
//STRIP001 			}
//STRIP001 
//STRIP001 			Reference< XPropertySetInfo > xControlPropInfo = xControlSet->getPropertySetInfo();
//STRIP001 			Any aVal;
//STRIP001 
//STRIP001 			Property aMinProp = xControlPropInfo->getPropertyByName(FM_PROP_VALUEMIN);
//STRIP001 			if (aMinProp.Type.getTypeClass() == TypeClass_DOUBLE)
//STRIP001 				aVal <<= (double)nMinValue;
//STRIP001 			else if (aMinProp.Type.getTypeClass() == TypeClass_LONG)
//STRIP001 				aVal <<= (sal_Int32)nMinValue;
//STRIP001 			else
//STRIP001 				DBG_ERROR("FmXFormView::createControlLabelPair: unexpected property type (MinValue)!");
//STRIP001 			xControlSet->setPropertyValue(FM_PROP_VALUEMIN,aVal);
//STRIP001 
//STRIP001 			Property aMaxProp = xControlPropInfo->getPropertyByName(FM_PROP_VALUEMAX);
//STRIP001 			if (aMaxProp.Type.getTypeClass() == TypeClass_DOUBLE)
//STRIP001 				aVal <<= (double)nMaxValue;
//STRIP001 			else if (aMaxProp.Type.getTypeClass() == TypeClass_LONG)
//STRIP001 				aVal <<= (sal_Int32)nMaxValue;
//STRIP001 			else
//STRIP001 				DBG_ERROR("FmXFormView::createControlLabelPair: unexpected property type (MaxValue)!");
//STRIP001 			xControlSet->setPropertyValue(FM_PROP_VALUEMAX,aVal);
//STRIP001 		}
//STRIP001 
//STRIP001 		if (::comphelper::hasProperty(FM_PROP_STRICTFORMAT, xControlSet))
//STRIP001 		{	// Formatueberpruefung fue numeric fields standardmaessig sal_True
//STRIP001 			sal_Bool bB(sal_True);
//STRIP001 			Any aVal(&bB,getBooleanCppuType());
//STRIP001 			xControlSet->setPropertyValue(FM_PROP_STRICTFORMAT, aVal);
//STRIP001 		}
//STRIP001 
//STRIP001 		xControlSet->setPropertyValue(FM_PROP_CONTROLSOURCE, aFieldName);
//STRIP001 		xControlSet->setPropertyValue(FM_PROP_NAME, aFieldName);
//STRIP001 
//STRIP001 		if (nDataType == DataType::LONGVARCHAR)
//STRIP001 		{
//STRIP001 			sal_Bool bB(sal_True);
//STRIP001 			xControlSet->setPropertyValue(FM_PROP_MULTILINE,Any(&bB,getBooleanCppuType()));
//STRIP001 		}
//STRIP001 
//STRIP001 		if (_nObjID == OBJ_FM_CHECKBOX)
//STRIP001 		{
//STRIP001 			sal_Int32 nNullable = ColumnValue::NULLABLE_UNKNOWN;
//STRIP001 			_rxField->getPropertyValue( FM_PROP_ISNULLABLE ) >>= nNullable;
//STRIP001 			xControlSet->setPropertyValue( FM_PROP_TRISTATE, makeAny( sal_Bool( ColumnValue::NULLABLE == nNullable ) ) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// announce the label to the control
//STRIP001 	if (::comphelper::hasProperty(FM_PROP_CONTROLLABEL, xControlSet))
//STRIP001 	{
//STRIP001 		// (try-catch as the control may refuse a model without the right service name - which we don't know
//STRIP001 		// usually a fixed text we use as label should be accepted, but to be sure ....)
//STRIP001 		try
//STRIP001 		{
//STRIP001 			xControlSet->setPropertyValue(FM_PROP_CONTROLLABEL, makeAny(xLabelSet));
//STRIP001 		}
//STRIP001 		catch(Exception&)
//STRIP001 		{
//STRIP001 			DBG_ERROR("FmXFormView::createControlLabelPair : could not marry the control and the label !");
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------------
/*N*/ FmXFormView::ObjectRemoveListener::ObjectRemoveListener( FmXFormView* pParent )
/*N*/ 	:m_pParent( pParent )
/*N*/ {
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormView::ObjectRemoveListener::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
/*N*/ {
/*N*/ 	if (rHint.ISA(SdrHint) && (((SdrHint&)rHint).GetKind() == HINT_OBJREMOVED))
/*N*/ 		m_pParent->ObjectRemovedInAliveMode(((SdrHint&)rHint).GetObject());
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormView::ObjectRemovedInAliveMode( const SdrObject* pObject )
/*N*/ {
/*N*/ 	// wenn das entfernte Objekt in meiner MarkList, die ich mir beim Umschalten in den Alive-Mode gemerkt habe, steht,
/*N*/ 	// muss ich es jetzt da rausnehmen, da ich sonst beim Zurueckschalten versuche, die Markierung wieder zu setzen
/*N*/ 	// (interesanterweise geht das nur bei gruppierten Objekten schief (beim Zugriff auf deren ObjList GPF), nicht bei einzelnen)
/*N*/ 
/*N*/ 	sal_uInt32 nCount = m_aMark.GetMarkCount();
/*N*/ 	for (sal_uInt32 i = 0; i < nCount; ++i)
/*N*/ 	{
/*?*/ 		SdrMark* pMark = m_aMark.GetMark(i);
/*?*/ 		SdrObject* pCurrent = pMark->GetObj();
/*?*/ 		if (pObject == pCurrent)
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 			m_aMark.DeleteMark(i);
/*?*/ 			return;
/*?*/ 		}
/*?*/ 		// ich brauche nicht in GroupObjects absteigen : wenn dort unten ein Objekt geloescht wird, dann bleibt der
/*N*/ 		// Zeiger auf das GroupObject, den ich habe, trotzdem weiter gueltig bleibt ...
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormView::stopMarkListWatching()
/*N*/ {
/*N*/ 	if ( m_pWatchStoredList )
/*N*/ 	{
/*N*/ 		m_pWatchStoredList->EndListeningAll();
/*N*/ 		delete m_pWatchStoredList;
/*N*/ 		m_pWatchStoredList = NULL;
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormView::startMarkListWatching()
/*N*/ {
/*N*/ 	if ( !m_pWatchStoredList )
/*N*/ 	{
/*N*/ 		m_pWatchStoredList = new ObjectRemoveListener( this );
/*N*/ 		FmFormModel* pModel = GetFormShell() ? GetFormShell()->GetFormModel() : NULL;
/*N*/ 		DBG_ASSERT( pModel != NULL, "FmXFormView::startMarkListWatching: shell has no model!" );
/*N*/ 		m_pWatchStoredList->StartListening( *static_cast< SfxBroadcaster* >( pModel ) );
/*N*/ 	}
/*N*/ 	else
/*N*/ 		DBG_ERROR( "FmXFormView::startMarkListWatching: already listening!" );
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormView::saveMarkList( sal_Bool _bSmartUnmark )
/*N*/ {
/*N*/ 	if ( m_pView )
/*N*/ 	{
/*N*/ 		m_aMark = m_pView->GetMarkList();
/*N*/ 		if ( _bSmartUnmark )
/*N*/ 		{
/*N*/ 			sal_uInt32 nCount = m_aMark.GetMarkCount( );
/*N*/ 			for ( sal_uInt32 i = 0; i < nCount; ++i )
/*N*/ 			{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 				SdrMark*   pMark = m_aMark.GetMark(i);
//STRIP001 /*?*/ 				SdrObject* pObj  = pMark->GetObj();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				if ( m_pView->IsObjMarked( pObj ) )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					if ( pObj->IsGroupObject() )
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						SdrObjListIter aIter( *pObj->GetSubList() );
//STRIP001 /*?*/ 						sal_Bool bMixed = sal_False;
//STRIP001 /*?*/ 						while ( aIter.IsMore() && !bMixed )
//STRIP001 /*?*/ 							bMixed = ( aIter.Next()->GetObjInventor() != FmFormInventor );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						if ( !bMixed )
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							// all objects in the group are form objects
//STRIP001 /*?*/ 							m_pView->MarkObj( pMark->GetObj(), pMark->GetPageView(), sal_True /* unmark! */ );
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					else
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						if ( pObj->GetObjInventor() == FmFormInventor )
//STRIP001 /*?*/ 						{	// this is a form layer object
//STRIP001 /*?*/ 							m_pView->MarkObj( pMark->GetObj(), pMark->GetPageView(), sal_True /* unmark! */ );
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*?*/ 		DBG_ERROR( "FmXFormView::saveMarkList: invalid view!" );
/*?*/ 		m_aMark = SdrMarkList();
/*N*/ 	}
/*N*/ }

//--------------------------------------------------------------------------
//STRIP001 static sal_Bool lcl_hasObject( SdrObjListIter& rIter, SdrObject* pObj )
//STRIP001 {
//STRIP001 	sal_Bool bFound = sal_False;
//STRIP001 	while (rIter.IsMore() && !bFound)
//STRIP001 		bFound = pObj == rIter.Next();
//STRIP001 
//STRIP001 	rIter.Reset();
//STRIP001 	return bFound;
//STRIP001 }

//------------------------------------------------------------------------------
/*N*/ void FmXFormView::restoreMarkList( SdrMarkList& _rRestoredMarkList )
/*N*/ {
/*N*/ 	if ( !m_pView )
/*N*/ 		return;
/*N*/ 
/*N*/ 	_rRestoredMarkList.Clear();
/*N*/ 
/*N*/ 	const SdrMarkList& rCurrentList = m_pView->GetMarkList();
/*N*/ 	FmFormPage* pPage = GetFormShell() ? GetFormShell()->GetCurPage() : NULL;
/*N*/ 	if (pPage)
/*N*/ 	{
/*N*/ 		if (rCurrentList.GetMarkCount())
/*N*/ 		{	// there is a current mark ... hmm. Is it a subset of the mark we remembered in saveMarkList?
/*?*/ 			sal_Bool bMisMatch = sal_False;
/*?*/ 
/*?*/ 			// loop through all current marks
/*?*/ 			sal_uInt32 nCurrentCount = rCurrentList.GetMarkCount();
/*?*/ 			for ( sal_uInt32 i=0; i<nCurrentCount&& !bMisMatch; ++i )
/*?*/ 			{
/*?*/ 				const SdrObject* pCurrentMarked = rCurrentList.GetMark( i )->GetObj();
/*?*/ 
/*?*/ 				// loop through all saved marks, check for equality
/*?*/ 				sal_Bool bFound = sal_False;
/*?*/ 				sal_uInt32 nSavedCount = m_aMark.GetMarkCount();
/*?*/ 				for ( sal_uInt32 j=0; j<nSavedCount && !bFound; ++j )
/*?*/ 				{
/*?*/ 					if ( m_aMark.GetMark( j )->GetObj() == pCurrentMarked )
/*?*/ 						bFound = sal_True;
/*?*/ 				}
/*?*/ 
/*?*/ 				// did not find a current mark in the saved marks
/*?*/ 				if ( !bFound )
/*?*/ 					bMisMatch = sal_True;
/*?*/ 			}
/*?*/ 
/*?*/ 			if ( bMisMatch )
/*?*/ 			{
/*?*/ 				m_aMark.Clear();
/*?*/ 				_rRestoredMarkList = rCurrentList;
/*?*/ 				return;
/*N*/ 			}
/*N*/ 		}
/*N*/ 		// wichtig ist das auf die Objecte der markliste nicht zugegriffen wird
/*N*/ 		// da diese bereits zerstoert sein koennen
/*N*/ 		SdrPageView* pCurPageView = m_pView->GetPageViewPvNum(0);
/*N*/ 		SdrObjListIter aPageIter( *pPage );
/*N*/ 		sal_Bool bFound = sal_True;
/*N*/ 
/*N*/ 		// gibt es noch alle Objecte
/*N*/ 		sal_uInt32 nCount = m_aMark.GetMarkCount();
/*N*/ 		for (sal_uInt32 i = 0; i < nCount && bFound; i++)
/*N*/ 		{
/*?*/			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 			SdrMark*   pMark = m_aMark.GetMark(i);
//STRIP001 /*?*/ 			SdrObject* pObj  = pMark->GetObj();
//STRIP001 /*?*/ 			if (pObj->IsGroupObject())
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				SdrObjListIter aIter(*pObj->GetSubList());
//STRIP001 /*?*/ 				while (aIter.IsMore() && bFound)
//STRIP001 /*?*/ 					bFound = lcl_hasObject(aPageIter, aIter.Next());
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			else
//STRIP001 /*?*/ 				bFound = lcl_hasObject(aPageIter, pObj);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			bFound = bFound && pCurPageView == pMark->GetPageView();
/*N*/ 		}
/*N*/ 
/*N*/ 		if (bFound)
/*N*/ 		{
/*N*/ 			// Das LastObject auswerten
/*N*/ 			if (nCount) // Objecte jetzt Markieren
/*N*/ 			{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 				for (sal_uInt32 i = 0; i < nCount; i++)
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					SdrMark* pMark = m_aMark.GetMark(i);
//STRIP001 /*?*/ 					SdrObject* pObj = pMark->GetObj();
//STRIP001 /*?*/ 					if ( pObj->GetObjInventor() == FmFormInventor )
//STRIP001 /*?*/ 						if ( !m_pView->IsObjMarked( pObj ) )
//STRIP001 /*?*/ 							m_pView->MarkObj( pObj, pMark->GetPageView() );
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				_rRestoredMarkList = m_aMark;
/*N*/ 			}
/*N*/ 			// This one is from the times where the code was part of the FmXFormShell instead of the FmXFormView.
/*N*/ 			// I do not see the deeper sense - it's not fully clear what it does, and everything works as
/*N*/ 			// expected without it. Fine, so I omit it :).
/*N*/ 			// 02.05.2002 - fs@openoffice.org
/*N*/ //			else
/*N*/ //			{
/*N*/ //				Reference< XIndexAccess> xCont(pPage->GetForms(), UNO_QUERY);
/*N*/ //
/*N*/ //				// Ist das aktuelle Object ein Element eines SelectionSuppliers?
/*N*/ //				Reference< XChild> xChild(m_xCurControl,UNO_QUERY);
/*N*/ //				Reference< ::com::sun::star::view::XSelectionSupplier> xSelectionSupplier;
/*N*/ //				if (xChild.is())
/*N*/ //					xSelectionSupplier = Reference< ::com::sun::star::view::XSelectionSupplier>(xChild->getParent(), UNO_QUERY);
/*N*/ //				if (xSelectionSupplier.is())
/*N*/ //				{
/*N*/ //					// suchen der Zugehoreigen Form
/*N*/ //					Reference< XForm> xForm(GetForm(m_xCurControl));
/*N*/ //					Reference< XInterface> xIface(xForm, UNO_QUERY);
/*N*/ //					if (xForm.is() && searchElement(xCont, xIface))
/*N*/ //					{
/*N*/ //						setCurForm(xForm);
/*N*/ //						setCurControl(m_xCurControl);
/*N*/ //
/*N*/ //						// jetzt noch die Selection vornehmen
/*N*/ //						xSelectionSupplier->select(makeAny(m_xCurControl));
/*N*/ //					}
/*N*/ //				}
/*N*/ //				else
/*N*/ //				{
/*N*/ //					// Auswerten des letzen Objects
/*N*/ //					Reference< XForm> xForm(m_xCurForm, UNO_QUERY);
/*N*/ //					Reference< XInterface> xIface(xForm, UNO_QUERY);
/*N*/ //					if (xForm.is() && searchElement(xCont, xIface))
/*N*/ //					{
/*N*/ //						setCurForm(xForm);
/*N*/ //					}
/*N*/ //					else
/*N*/ //					{
/*N*/ //						if (pPage->GetImpl()->getCurForm().is())
/*N*/ //							xForm = pPage->GetImpl()->getCurForm();
/*N*/ //						else if (xCont.is() && xCont->getCount())
/*N*/ //							xForm = pPage->GetImpl()->getDefaultForm();
/*N*/ //
/*N*/ //						if (xForm.is())
/*N*/ //							setCurForm(xForm);
/*N*/ //					}
/*N*/ //				}
/*N*/ //
/*N*/ //				Reference< XInterface> xPreviousObject(getSelObject());
/*N*/ //
/*N*/ //				// wurde vorher Form angezeigt, dann wieder die Form anzeigen
/*N*/ //				Reference< XForm> xOldForm(xPreviousObject, UNO_QUERY);
/*N*/ //				if (xOldForm.is())
/*N*/ //					setSelObject(m_xCurForm);
/*N*/ //				else
/*N*/ //					setSelObject(m_xCurControl);
/*N*/ //
/*N*/ //				if (IsPropBrwOpen() && m_xSelObject != xPreviousObject)
/*N*/ //					ShowProperties(m_xSelObject, sal_True);
/*N*/ //			}
/*N*/ 		}
/*N*/ 		m_aMark.Clear();
/*N*/ 	}
/*N*/ }
// -----------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormView::focusGained( const ::com::sun::star::awt::FocusEvent& e ) throw (::com::sun::star::uno::RuntimeException)
/*?*/ {DBG_BF_ASSERT(0, "STRIP");//STRIP001 
//STRIP001 	if ( m_xWindow.is() && m_pView )
//STRIP001 	{
//STRIP001 		m_pView->SetMoveOutside(TRUE);
//STRIP001 		m_pView->RefreshAllIAOManagers();
//STRIP001 	}
/*?*/ }
// -----------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormView::focusLost( const ::com::sun::star::awt::FocusEvent& e ) throw (::com::sun::star::uno::RuntimeException)
/*?*/ {DBG_BF_ASSERT(0, "STRIP");//STRIP001 
//STRIP001 	// when switch the focus outside the office the mark didn't change
//STRIP001 	// so we can not remove us as focus listener
//STRIP001 	if ( m_xWindow.is() && m_pView )
//STRIP001 	{
//STRIP001 		m_pView->SetMoveOutside(FALSE);
//STRIP001 		m_pView->RefreshAllIAOManagers();
//STRIP001 	}
/*?*/ }											    
// -----------------------------------------------------------------------------
//STRIP001 void FmXFormView::removeGridWindowListening()
//STRIP001 {
//STRIP001 	if ( m_xWindow.is() )
//STRIP001 	{
//STRIP001 		m_xWindow->removeFocusListener(this);
//STRIP001 		if ( m_pView )
//STRIP001 		{
//STRIP001 			m_pView->SetMoveOutside(FALSE);
//STRIP001 			m_pView->RefreshAllIAOManagers();
//STRIP001 		}
//STRIP001 		m_xWindow = NULL;
//STRIP001 	}
//STRIP001 }
// -----------------------------------------------------------------------------


}
