/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: widthfolding_data.h,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:42:30 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef INCLUDED_I18NUTIL_CASEFOLDING_DATA_H
#define INCLUDED_I18NUTIL_CASEFOLDING_DATA_H

#include <i18nutil/oneToOneMapping.hxx>

namespace com { namespace sun { namespace star { namespace i18n {

/*
  Unicode Normalization Forms
  http://www.unicode.org/unicode/reports/tr15/index.html
  http://www.w3.org/International/charlint/
*/

typedef struct {
  sal_Unicode decomposited_character_1;
  sal_Unicode decomposited_character_2;
} decomposition_table_entry_t;

const decomposition_table_entry_t decomposition_table[] = {
	{ 0x0000, 0x0000 },	// 0x3040
	{ 0x0000, 0x0000 },	// 0x3041 HIRAGANA LETTER SMALL A
	{ 0x0000, 0x0000 },	// 0x3042 HIRAGANA LETTER A
	{ 0x0000, 0x0000 },	// 0x3043 HIRAGANA LETTER SMALL I
	{ 0x0000, 0x0000 },	// 0x3044 HIRAGANA LETTER I
	{ 0x0000, 0x0000 },	// 0x3045 HIRAGANA LETTER SMALL U
	{ 0x0000, 0x0000 },	// 0x3046 HIRAGANA LETTER U
	{ 0x0000, 0x0000 },	// 0x3047 HIRAGANA LETTER SMALL E
	{ 0x0000, 0x0000 },	// 0x3048 HIRAGANA LETTER E
	{ 0x0000, 0x0000 },	// 0x3049 HIRAGANA LETTER SMALL O
	{ 0x0000, 0x0000 },	// 0x304a HIRAGANA LETTER O
	{ 0x0000, 0x0000 },	// 0x304b HIRAGANA LETTER KA
	{ 0x304b, 0x3099 },	// 0x304c HIRAGANA LETTER GA --> HIRAGANA LETTER KA + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x304d HIRAGANA LETTER KI
	{ 0x304d, 0x3099 },	// 0x304e HIRAGANA LETTER GI --> HIRAGANA LETTER KI + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x304f HIRAGANA LETTER KU
	{ 0x304f, 0x3099 },	// 0x3050 HIRAGANA LETTER GU --> HIRAGANA LETTER KU + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x3051 HIRAGANA LETTER KE
	{ 0x3051, 0x3099 },	// 0x3052 HIRAGANA LETTER GE --> HIRAGANA LETTER KE + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x3053 HIRAGANA LETTER KO
	{ 0x3053, 0x3099 },	// 0x3054 HIRAGANA LETTER GO --> HIRAGANA LETTER KO + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x3055 HIRAGANA LETTER SA
	{ 0x3055, 0x3099 },	// 0x3056 HIRAGANA LETTER ZA --> HIRAGANA LETTER SA + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x3057 HIRAGANA LETTER SI
	{ 0x3057, 0x3099 },	// 0x3058 HIRAGANA LETTER ZI --> HIRAGANA LETTER SI + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x3059 HIRAGANA LETTER SU
	{ 0x3059, 0x3099 },	// 0x305a HIRAGANA LETTER ZU --> HIRAGANA LETTER SU + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x305b HIRAGANA LETTER SE
	{ 0x305b, 0x3099 },	// 0x305c HIRAGANA LETTER ZE --> HIRAGANA LETTER SE + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x305d HIRAGANA LETTER SO
	{ 0x305d, 0x3099 },	// 0x305e HIRAGANA LETTER ZO --> HIRAGANA LETTER SO + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x305f HIRAGANA LETTER TA
	{ 0x305f, 0x3099 },	// 0x3060 HIRAGANA LETTER DA --> HIRAGANA LETTER TA + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x3061 HIRAGANA LETTER TI
	{ 0x3061, 0x3099 },	// 0x3062 HIRAGANA LETTER DI --> HIRAGANA LETTER TI + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x3063 HIRAGANA LETTER SMALL TU
	{ 0x0000, 0x0000 },	// 0x3064 HIRAGANA LETTER TU
	{ 0x3064, 0x3099 },	// 0x3065 HIRAGANA LETTER DU --> HIRAGANA LETTER TU + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x3066 HIRAGANA LETTER TE
	{ 0x3066, 0x3099 },	// 0x3067 HIRAGANA LETTER DE --> HIRAGANA LETTER TE + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x3068 HIRAGANA LETTER TO
	{ 0x3068, 0x3099 },	// 0x3069 HIRAGANA LETTER DO --> HIRAGANA LETTER TO + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x306a HIRAGANA LETTER NA
	{ 0x0000, 0x0000 },	// 0x306b HIRAGANA LETTER NI
	{ 0x0000, 0x0000 },	// 0x306c HIRAGANA LETTER NU
	{ 0x0000, 0x0000 },	// 0x306d HIRAGANA LETTER NE
	{ 0x0000, 0x0000 },	// 0x306e HIRAGANA LETTER NO
	{ 0x0000, 0x0000 },	// 0x306f HIRAGANA LETTER HA
	{ 0x306f, 0x3099 },	// 0x3070 HIRAGANA LETTER BA --> HIRAGANA LETTER HA + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x306f, 0x309a },	// 0x3071 HIRAGANA LETTER PA --> HIRAGANA LETTER HA + COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x3072 HIRAGANA LETTER HI
	{ 0x3072, 0x3099 },	// 0x3073 HIRAGANA LETTER BI --> HIRAGANA LETTER HI + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x3072, 0x309a },	// 0x3074 HIRAGANA LETTER PI --> HIRAGANA LETTER HI + COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x3075 HIRAGANA LETTER HU
	{ 0x3075, 0x3099 },	// 0x3076 HIRAGANA LETTER BU --> HIRAGANA LETTER HU + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x3075, 0x309a },	// 0x3077 HIRAGANA LETTER PU --> HIRAGANA LETTER HU + COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x3078 HIRAGANA LETTER HE
	{ 0x3078, 0x3099 },	// 0x3079 HIRAGANA LETTER BE --> HIRAGANA LETTER HE + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x3078, 0x309a },	// 0x307a HIRAGANA LETTER PE --> HIRAGANA LETTER HE + COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x307b HIRAGANA LETTER HO
	{ 0x307b, 0x3099 },	// 0x307c HIRAGANA LETTER BO --> HIRAGANA LETTER HO + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x307b, 0x309a },	// 0x307d HIRAGANA LETTER PO --> HIRAGANA LETTER HO + COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x307e HIRAGANA LETTER MA
	{ 0x0000, 0x0000 },	// 0x307f HIRAGANA LETTER MI
	{ 0x0000, 0x0000 },	// 0x3080 HIRAGANA LETTER MU
	{ 0x0000, 0x0000 },	// 0x3081 HIRAGANA LETTER ME
	{ 0x0000, 0x0000 },	// 0x3082 HIRAGANA LETTER MO
	{ 0x0000, 0x0000 },	// 0x3083 HIRAGANA LETTER SMALL YA
	{ 0x0000, 0x0000 },	// 0x3084 HIRAGANA LETTER YA
	{ 0x0000, 0x0000 },	// 0x3085 HIRAGANA LETTER SMALL YU
	{ 0x0000, 0x0000 },	// 0x3086 HIRAGANA LETTER YU
	{ 0x0000, 0x0000 },	// 0x3087 HIRAGANA LETTER SMALL YO
	{ 0x0000, 0x0000 },	// 0x3088 HIRAGANA LETTER YO
	{ 0x0000, 0x0000 },	// 0x3089 HIRAGANA LETTER RA
	{ 0x0000, 0x0000 },	// 0x308a HIRAGANA LETTER RI
	{ 0x0000, 0x0000 },	// 0x308b HIRAGANA LETTER RU
	{ 0x0000, 0x0000 },	// 0x308c HIRAGANA LETTER RE
	{ 0x0000, 0x0000 },	// 0x308d HIRAGANA LETTER RO
	{ 0x0000, 0x0000 },	// 0x308e HIRAGANA LETTER SMALL WA
	{ 0x0000, 0x0000 },	// 0x308f HIRAGANA LETTER WA
	{ 0x0000, 0x0000 },	// 0x3090 HIRAGANA LETTER WI
	{ 0x0000, 0x0000 },	// 0x3091 HIRAGANA LETTER WE
	{ 0x0000, 0x0000 },	// 0x3092 HIRAGANA LETTER WO
	{ 0x0000, 0x0000 },	// 0x3093 HIRAGANA LETTER N
	{ 0x3046, 0x3099 },	// 0x3094 HIRAGANA LETTER VU --> HIRAGANA LETTER U + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x3095
	{ 0x0000, 0x0000 },	// 0x3096
	{ 0x0000, 0x0000 },	// 0x3097
	{ 0x0000, 0x0000 },	// 0x3098
	{ 0x0000, 0x0000 },	// 0x3099 COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x309a COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x309b KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x309c KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x309d HIRAGANA ITERATION MARK
	{ 0x0000, 0x0000 },	// 0x309e HIRAGANA VOICED ITERATION MARK
	{ 0x0000, 0x0000 },	// 0x309f
	{ 0x0000, 0x0000 },	// 0x30a0
	{ 0x0000, 0x0000 },	// 0x30a1 KATAKANA LETTER SMALL A
	{ 0x0000, 0x0000 },	// 0x30a2 KATAKANA LETTER A
	{ 0x0000, 0x0000 },	// 0x30a3 KATAKANA LETTER SMALL I
	{ 0x0000, 0x0000 },	// 0x30a4 KATAKANA LETTER I
	{ 0x0000, 0x0000 },	// 0x30a5 KATAKANA LETTER SMALL U
	{ 0x0000, 0x0000 },	// 0x30a6 KATAKANA LETTER U
	{ 0x0000, 0x0000 },	// 0x30a7 KATAKANA LETTER SMALL E
	{ 0x0000, 0x0000 },	// 0x30a8 KATAKANA LETTER E
	{ 0x0000, 0x0000 },	// 0x30a9 KATAKANA LETTER SMALL O
	{ 0x0000, 0x0000 },	// 0x30aa KATAKANA LETTER O
	{ 0x0000, 0x0000 },	// 0x30ab KATAKANA LETTER KA
	{ 0x30ab, 0x3099 },	// 0x30ac KATAKANA LETTER GA --> KATAKANA LETTER KA + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30ad KATAKANA LETTER KI
	{ 0x30ad, 0x3099 },	// 0x30ae KATAKANA LETTER GI --> KATAKANA LETTER KI + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30af KATAKANA LETTER KU
	{ 0x30af, 0x3099 },	// 0x30b0 KATAKANA LETTER GU --> KATAKANA LETTER KU + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30b1 KATAKANA LETTER KE
	{ 0x30b1, 0x3099 },	// 0x30b2 KATAKANA LETTER GE --> KATAKANA LETTER KE + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30b3 KATAKANA LETTER KO
	{ 0x30b3, 0x3099 },	// 0x30b4 KATAKANA LETTER GO --> KATAKANA LETTER KO + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30b5 KATAKANA LETTER SA
	{ 0x30b5, 0x3099 },	// 0x30b6 KATAKANA LETTER ZA --> KATAKANA LETTER SA + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30b7 KATAKANA LETTER SI
	{ 0x30b7, 0x3099 },	// 0x30b8 KATAKANA LETTER ZI --> KATAKANA LETTER SI + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30b9 KATAKANA LETTER SU
	{ 0x30b9, 0x3099 },	// 0x30ba KATAKANA LETTER ZU --> KATAKANA LETTER SU + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30bb KATAKANA LETTER SE
	{ 0x30bb, 0x3099 },	// 0x30bc KATAKANA LETTER ZE --> KATAKANA LETTER SE + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30bd KATAKANA LETTER SO
	{ 0x30bd, 0x3099 },	// 0x30be KATAKANA LETTER ZO --> KATAKANA LETTER SO + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30bf KATAKANA LETTER TA
	{ 0x30bf, 0x3099 },	// 0x30c0 KATAKANA LETTER DA --> KATAKANA LETTER TA + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30c1 KATAKANA LETTER TI
	{ 0x30c1, 0x3099 },	// 0x30c2 KATAKANA LETTER DI --> KATAKANA LETTER TI + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30c3 KATAKANA LETTER SMALL TU
	{ 0x0000, 0x0000 },	// 0x30c4 KATAKANA LETTER TU
	{ 0x30c4, 0x3099 },	// 0x30c5 KATAKANA LETTER DU --> KATAKANA LETTER TU + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30c6 KATAKANA LETTER TE
	{ 0x30c6, 0x3099 },	// 0x30c7 KATAKANA LETTER DE --> KATAKANA LETTER TE + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30c8 KATAKANA LETTER TO
	{ 0x30c8, 0x3099 },	// 0x30c9 KATAKANA LETTER DO --> KATAKANA LETTER TO + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30ca KATAKANA LETTER NA
	{ 0x0000, 0x0000 },	// 0x30cb KATAKANA LETTER NI
	{ 0x0000, 0x0000 },	// 0x30cc KATAKANA LETTER NU
	{ 0x0000, 0x0000 },	// 0x30cd KATAKANA LETTER NE
	{ 0x0000, 0x0000 },	// 0x30ce KATAKANA LETTER NO
	{ 0x0000, 0x0000 },	// 0x30cf KATAKANA LETTER HA
	{ 0x30cf, 0x3099 },	// 0x30d0 KATAKANA LETTER BA --> KATAKANA LETTER HA + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x30cf, 0x309a },	// 0x30d1 KATAKANA LETTER PA --> KATAKANA LETTER HA + COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30d2 KATAKANA LETTER HI
	{ 0x30d2, 0x3099 },	// 0x30d3 KATAKANA LETTER BI --> KATAKANA LETTER HI + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x30d2, 0x309a },	// 0x30d4 KATAKANA LETTER PI --> KATAKANA LETTER HI + COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30d5 KATAKANA LETTER HU
	{ 0x30d5, 0x3099 },	// 0x30d6 KATAKANA LETTER BU --> KATAKANA LETTER HU + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x30d5, 0x309a },	// 0x30d7 KATAKANA LETTER PU --> KATAKANA LETTER HU + COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30d8 KATAKANA LETTER HE
	{ 0x30d8, 0x3099 },	// 0x30d9 KATAKANA LETTER BE --> KATAKANA LETTER HE + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x30d8, 0x309a },	// 0x30da KATAKANA LETTER PE --> KATAKANA LETTER HE + COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30db KATAKANA LETTER HO
	{ 0x30db, 0x3099 },	// 0x30dc KATAKANA LETTER BO --> KATAKANA LETTER HO + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x30db, 0x309a },	// 0x30dd KATAKANA LETTER PO --> KATAKANA LETTER HO + COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30de KATAKANA LETTER MA
	{ 0x0000, 0x0000 },	// 0x30df KATAKANA LETTER MI
	{ 0x0000, 0x0000 },	// 0x30e0 KATAKANA LETTER MU
	{ 0x0000, 0x0000 },	// 0x30e1 KATAKANA LETTER ME
	{ 0x0000, 0x0000 },	// 0x30e2 KATAKANA LETTER MO
	{ 0x0000, 0x0000 },	// 0x30e3 KATAKANA LETTER SMALL YA
	{ 0x0000, 0x0000 },	// 0x30e4 KATAKANA LETTER YA
	{ 0x0000, 0x0000 },	// 0x30e5 KATAKANA LETTER SMALL YU
	{ 0x0000, 0x0000 },	// 0x30e6 KATAKANA LETTER YU
	{ 0x0000, 0x0000 },	// 0x30e7 KATAKANA LETTER SMALL YO
	{ 0x0000, 0x0000 },	// 0x30e8 KATAKANA LETTER YO
	{ 0x0000, 0x0000 },	// 0x30e9 KATAKANA LETTER RA
	{ 0x0000, 0x0000 },	// 0x30ea KATAKANA LETTER RI
	{ 0x0000, 0x0000 },	// 0x30eb KATAKANA LETTER RU
	{ 0x0000, 0x0000 },	// 0x30ec KATAKANA LETTER RE
	{ 0x0000, 0x0000 },	// 0x30ed KATAKANA LETTER RO
	{ 0x0000, 0x0000 },	// 0x30ee KATAKANA LETTER SMALL WA
	{ 0x0000, 0x0000 },	// 0x30ef KATAKANA LETTER WA
	{ 0x0000, 0x0000 },	// 0x30f0 KATAKANA LETTER WI
	{ 0x0000, 0x0000 },	// 0x30f1 KATAKANA LETTER WE
	{ 0x0000, 0x0000 },	// 0x30f2 KATAKANA LETTER WO
	{ 0x0000, 0x0000 },	// 0x30f3 KATAKANA LETTER N
	{ 0x30a6, 0x3099 },	// 0x30f4 KATAKANA LETTER VU --> KATAKANA LETTER U + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30f5 KATAKANA LETTER SMALL KA
	{ 0x0000, 0x0000 },	// 0x30f6 KATAKANA LETTER SMALL KE
	{ 0x30ef, 0x3099 },	// 0x30f7 KATAKANA LETTER VA --> KATAKANA LETTER WA + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x30f0, 0x3099 },	// 0x30f8 KATAKANA LETTER VI --> KATAKANA LETTER WI + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x30f1, 0x3099 },	// 0x30f9 KATAKANA LETTER VE --> KATAKANA LETTER WE + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x30f2, 0x3099 },	// 0x30fa KATAKANA LETTER VO --> KATAKANA LETTER WO + COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30fb KATAKANA MIDDLE DOT
	{ 0x0000, 0x0000 },	// 0x30fc KATAKANA-HIRAGANA PROLONGED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30fd KATAKANA ITERATION MARK
	{ 0x0000, 0x0000 },	// 0x30fe KATAKANA VOICED ITERATION MARK
	{ 0x0000, 0x0000 }	// 0x30ff 
};


/*
  Halfwidth and Fullwidth Forms (U+FF00..U+FFEF)
  ftp://ftp.unicode.org/Public/3.0-Update/UnicodeData-3.0.0.txt
  ftp://ftp.unicode.org/Public/3.0-Update/UnicodeData-3.0.0.html
  http://charts.unicode.org/Web/UFF00.html 
*/

OneToOneMappingTable_t full2half[] = {	
  MAKE_PAIR( 0x2190, 0xFFE9 ),	// LEFTWARDS ARROW --> HALFWIDTH LEFTWARDS ARROW
  MAKE_PAIR( 0x2191, 0xFFEA ),	// UPWARDS ARROW --> HALFWIDTH UPWARDS ARROW
  MAKE_PAIR( 0x2192, 0xFFEB ),	// RIGHTWARDS ARROW --> HALFWIDTH RIGHTWARDS ARROW
  MAKE_PAIR( 0x2193, 0xFFEC ),	// DOWNWARDS ARROW --> HALFWIDTH DOWNWARDS ARROW

//MAKE_PAIR( 0x2212, 0x002D ),	// MINUS SIGN --> HYPHEN-MINUS

  MAKE_PAIR( 0x2502, 0xFFE8 ),	// BOX DRAWINGS LIGHT VERTICAL --> HALFWIDTH FORMS LIGHT VERTICAL
  MAKE_PAIR( 0x25A0, 0xFFED ),	// BLACK SQUARE --> HALFWIDTH BLACK SQUARE
  MAKE_PAIR( 0x25CB, 0xFFEE ),	// WHITE CIRCLE --> HALFWIDTH WHITE CIRCLE
  MAKE_PAIR( 0x3000, 0x0020 ),	// IDEOGRAPHIC SPACE --> SPACE
  MAKE_PAIR( 0x3001, 0xFF64 ),	// IDEOGRAPHIC COMMA --> HALFWIDTH IDEOGRAPHIC COMMA
  MAKE_PAIR( 0x3002, 0xFF61 ),	// IDEOGRAPHIC FULL STOP --> HALFWIDTH IDEOGRAPHIC FULL STOP
  MAKE_PAIR( 0x300C, 0xFF62 ),	// LEFT CORNER BRACKET --> HALFWIDTH LEFT CORNER BRACKET
  MAKE_PAIR( 0x300D, 0xFF63 ),	// RIGHT CORNER BRACKET --> HALFWIDTH RIGHT CORNER BRACKET
  MAKE_PAIR( 0x3099, 0xFF9E ),	// COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK --> HALFWIDTH KATAKANA VOICED SOUND MARK
  MAKE_PAIR( 0x309A, 0xFF9F ),	// COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK --> HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK
  MAKE_PAIR( 0x30A1, 0xFF67 ),	// KATAKANA LETTER SMALL A --> HALFWIDTH KATAKANA LETTER SMALL A
  MAKE_PAIR( 0x30A2, 0xFF71 ),	// KATAKANA LETTER A --> HALFWIDTH KATAKANA LETTER A
  MAKE_PAIR( 0x30A3, 0xFF68 ),	// KATAKANA LETTER SMALL I --> HALFWIDTH KATAKANA LETTER SMALL I
  MAKE_PAIR( 0x30A4, 0xFF72 ),	// KATAKANA LETTER I --> HALFWIDTH KATAKANA LETTER I
  MAKE_PAIR( 0x30A5, 0xFF69 ),	// KATAKANA LETTER SMALL U --> HALFWIDTH KATAKANA LETTER SMALL U
  MAKE_PAIR( 0x30A6, 0xFF73 ),	// KATAKANA LETTER U --> HALFWIDTH KATAKANA LETTER U
  MAKE_PAIR( 0x30A7, 0xFF6A ),	// KATAKANA LETTER SMALL E --> HALFWIDTH KATAKANA LETTER SMALL E
  MAKE_PAIR( 0x30A8, 0xFF74 ),	// KATAKANA LETTER E --> HALFWIDTH KATAKANA LETTER E
  MAKE_PAIR( 0x30A9, 0xFF6B ),	// KATAKANA LETTER SMALL O --> HALFWIDTH KATAKANA LETTER SMALL O
  MAKE_PAIR( 0x30AA, 0xFF75 ),	// KATAKANA LETTER O --> HALFWIDTH KATAKANA LETTER O
  MAKE_PAIR( 0x30AB, 0xFF76 ),	// KATAKANA LETTER KA --> HALFWIDTH KATAKANA LETTER KA
  MAKE_PAIR( 0x30AD, 0xFF77 ),	// KATAKANA LETTER KI --> HALFWIDTH KATAKANA LETTER KI
  MAKE_PAIR( 0x30AF, 0xFF78 ),	// KATAKANA LETTER KU --> HALFWIDTH KATAKANA LETTER KU
  MAKE_PAIR( 0x30B1, 0xFF79 ),	// KATAKANA LETTER KE --> HALFWIDTH KATAKANA LETTER KE
  MAKE_PAIR( 0x30B3, 0xFF7A ),	// KATAKANA LETTER KO --> HALFWIDTH KATAKANA LETTER KO
  MAKE_PAIR( 0x30B5, 0xFF7B ),	// KATAKANA LETTER SA --> HALFWIDTH KATAKANA LETTER SA
  MAKE_PAIR( 0x30B7, 0xFF7C ),	// KATAKANA LETTER SI --> HALFWIDTH KATAKANA LETTER SI
  MAKE_PAIR( 0x30B9, 0xFF7D ),	// KATAKANA LETTER SU --> HALFWIDTH KATAKANA LETTER SU
  MAKE_PAIR( 0x30BB, 0xFF7E ),	// KATAKANA LETTER SE --> HALFWIDTH KATAKANA LETTER SE
  MAKE_PAIR( 0x30BD, 0xFF7F ),	// KATAKANA LETTER SO --> HALFWIDTH KATAKANA LETTER SO
  MAKE_PAIR( 0x30BF, 0xFF80 ),	// KATAKANA LETTER TA --> HALFWIDTH KATAKANA LETTER TA
  MAKE_PAIR( 0x30C1, 0xFF81 ),	// KATAKANA LETTER TI --> HALFWIDTH KATAKANA LETTER TI
  MAKE_PAIR( 0x30C3, 0xFF6F ),	// KATAKANA LETTER SMALL TU --> HALFWIDTH KATAKANA LETTER SMALL TU
  MAKE_PAIR( 0x30C4, 0xFF82 ),	// KATAKANA LETTER TU --> HALFWIDTH KATAKANA LETTER TU
  MAKE_PAIR( 0x30C6, 0xFF83 ),	// KATAKANA LETTER TE --> HALFWIDTH KATAKANA LETTER TE
  MAKE_PAIR( 0x30C8, 0xFF84 ),	// KATAKANA LETTER TO --> HALFWIDTH KATAKANA LETTER TO
  MAKE_PAIR( 0x30CA, 0xFF85 ),	// KATAKANA LETTER NA --> HALFWIDTH KATAKANA LETTER NA
  MAKE_PAIR( 0x30CB, 0xFF86 ),	// KATAKANA LETTER NI --> HALFWIDTH KATAKANA LETTER NI
  MAKE_PAIR( 0x30CC, 0xFF87 ),	// KATAKANA LETTER NU --> HALFWIDTH KATAKANA LETTER NU
  MAKE_PAIR( 0x30CD, 0xFF88 ),	// KATAKANA LETTER NE --> HALFWIDTH KATAKANA LETTER NE
  MAKE_PAIR( 0x30CE, 0xFF89 ),	// KATAKANA LETTER NO --> HALFWIDTH KATAKANA LETTER NO
  MAKE_PAIR( 0x30CF, 0xFF8A ),	// KATAKANA LETTER HA --> HALFWIDTH KATAKANA LETTER HA
  MAKE_PAIR( 0x30D2, 0xFF8B ),	// KATAKANA LETTER HI --> HALFWIDTH KATAKANA LETTER HI
  MAKE_PAIR( 0x30D5, 0xFF8C ),	// KATAKANA LETTER HU --> HALFWIDTH KATAKANA LETTER HU
  MAKE_PAIR( 0x30D8, 0xFF8D ),	// KATAKANA LETTER HE --> HALFWIDTH KATAKANA LETTER HE
  MAKE_PAIR( 0x30DB, 0xFF8E ),	// KATAKANA LETTER HO --> HALFWIDTH KATAKANA LETTER HO
  MAKE_PAIR( 0x30DE, 0xFF8F ),	// KATAKANA LETTER MA --> HALFWIDTH KATAKANA LETTER MA
  MAKE_PAIR( 0x30DF, 0xFF90 ),	// KATAKANA LETTER MI --> HALFWIDTH KATAKANA LETTER MI
  MAKE_PAIR( 0x30E0, 0xFF91 ),	// KATAKANA LETTER MU --> HALFWIDTH KATAKANA LETTER MU
  MAKE_PAIR( 0x30E1, 0xFF92 ),	// KATAKANA LETTER ME --> HALFWIDTH KATAKANA LETTER ME
  MAKE_PAIR( 0x30E2, 0xFF93 ),	// KATAKANA LETTER MO --> HALFWIDTH KATAKANA LETTER MO
  MAKE_PAIR( 0x30E3, 0xFF6C ),	// KATAKANA LETTER SMALL YA --> HALFWIDTH KATAKANA LETTER SMALL YA
  MAKE_PAIR( 0x30E4, 0xFF94 ),	// KATAKANA LETTER YA --> HALFWIDTH KATAKANA LETTER YA
  MAKE_PAIR( 0x30E5, 0xFF6D ),	// KATAKANA LETTER SMALL YU --> HALFWIDTH KATAKANA LETTER SMALL YU
  MAKE_PAIR( 0x30E6, 0xFF95 ),	// KATAKANA LETTER YU --> HALFWIDTH KATAKANA LETTER YU
  MAKE_PAIR( 0x30E7, 0xFF6E ),	// KATAKANA LETTER SMALL YO --> HALFWIDTH KATAKANA LETTER SMALL YO
  MAKE_PAIR( 0x30E8, 0xFF96 ),	// KATAKANA LETTER YO --> HALFWIDTH KATAKANA LETTER YO
  MAKE_PAIR( 0x30E9, 0xFF97 ),	// KATAKANA LETTER RA --> HALFWIDTH KATAKANA LETTER RA
  MAKE_PAIR( 0x30EA, 0xFF98 ),	// KATAKANA LETTER RI --> HALFWIDTH KATAKANA LETTER RI
  MAKE_PAIR( 0x30EB, 0xFF99 ),	// KATAKANA LETTER RU --> HALFWIDTH KATAKANA LETTER RU
  MAKE_PAIR( 0x30EC, 0xFF9A ),	// KATAKANA LETTER RE --> HALFWIDTH KATAKANA LETTER RE
  MAKE_PAIR( 0x30ED, 0xFF9B ),	// KATAKANA LETTER RO --> HALFWIDTH KATAKANA LETTER RO
  MAKE_PAIR( 0x30EF, 0xFF9C ),	// KATAKANA LETTER WA --> HALFWIDTH KATAKANA LETTER WA
  MAKE_PAIR( 0x30F2, 0xFF66 ),	// KATAKANA LETTER WO --> HALFWIDTH KATAKANA LETTER WO
  MAKE_PAIR( 0x30F3, 0xFF9D ),	// KATAKANA LETTER N --> HALFWIDTH KATAKANA LETTER N
  MAKE_PAIR( 0x30FB, 0xFF65 ),	// KATAKANA MIDDLE DOT --> HALFWIDTH KATAKANA MIDDLE DOT
  MAKE_PAIR( 0x30FC, 0xFF70 ),	// KATAKANA-HIRAGANA PROLONGED SOUND MARK --> HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK
  MAKE_PAIR( 0x3131, 0xFFA1 ),	// HANGUL LETTER KIYEOK --> HALFWIDTH HANGUL LETTER KIYEOK
  MAKE_PAIR( 0x3132, 0xFFA2 ),	// HANGUL LETTER SSANGKIYEOK --> HALFWIDTH HANGUL LETTER SSANGKIYEOK
  MAKE_PAIR( 0x3133, 0xFFA3 ),	// HANGUL LETTER KIYEOK-SIOS --> HALFWIDTH HANGUL LETTER KIYEOK-SIOS
  MAKE_PAIR( 0x3134, 0xFFA4 ),	// HANGUL LETTER NIEUN --> HALFWIDTH HANGUL LETTER NIEUN
  MAKE_PAIR( 0x3135, 0xFFA5 ),	// HANGUL LETTER NIEUN-CIEUC --> HALFWIDTH HANGUL LETTER NIEUN-CIEUC
  MAKE_PAIR( 0x3136, 0xFFA6 ),	// HANGUL LETTER NIEUN-HIEUH --> HALFWIDTH HANGUL LETTER NIEUN-HIEUH
  MAKE_PAIR( 0x3137, 0xFFA7 ),	// HANGUL LETTER TIKEUT --> HALFWIDTH HANGUL LETTER TIKEUT
  MAKE_PAIR( 0x3138, 0xFFA8 ),	// HANGUL LETTER SSANGTIKEUT --> HALFWIDTH HANGUL LETTER SSANGTIKEUT
  MAKE_PAIR( 0x3139, 0xFFA9 ),	// HANGUL LETTER RIEUL --> HALFWIDTH HANGUL LETTER RIEUL
  MAKE_PAIR( 0x313A, 0xFFAA ),	// HANGUL LETTER RIEUL-KIYEOK --> HALFWIDTH HANGUL LETTER RIEUL-KIYEOK
  MAKE_PAIR( 0x313B, 0xFFAB ),	// HANGUL LETTER RIEUL-MIEUM --> HALFWIDTH HANGUL LETTER RIEUL-MIEUM
  MAKE_PAIR( 0x313C, 0xFFAC ),	// HANGUL LETTER RIEUL-PIEUP --> HALFWIDTH HANGUL LETTER RIEUL-PIEUP
  MAKE_PAIR( 0x313D, 0xFFAD ),	// HANGUL LETTER RIEUL-SIOS --> HALFWIDTH HANGUL LETTER RIEUL-SIOS
  MAKE_PAIR( 0x313E, 0xFFAE ),	// HANGUL LETTER RIEUL-THIEUTH --> HALFWIDTH HANGUL LETTER RIEUL-THIEUTH
  MAKE_PAIR( 0x313F, 0xFFAF ),	// HANGUL LETTER RIEUL-PHIEUPH --> HALFWIDTH HANGUL LETTER RIEUL-PHIEUPH
  MAKE_PAIR( 0x3140, 0xFFB0 ),	// HANGUL LETTER RIEUL-HIEUH --> HALFWIDTH HANGUL LETTER RIEUL-HIEUH
  MAKE_PAIR( 0x3141, 0xFFB1 ),	// HANGUL LETTER MIEUM --> HALFWIDTH HANGUL LETTER MIEUM
  MAKE_PAIR( 0x3142, 0xFFB2 ),	// HANGUL LETTER PIEUP --> HALFWIDTH HANGUL LETTER PIEUP
  MAKE_PAIR( 0x3143, 0xFFB3 ),	// HANGUL LETTER SSANGPIEUP --> HALFWIDTH HANGUL LETTER SSANGPIEUP
  MAKE_PAIR( 0x3144, 0xFFB4 ),	// HANGUL LETTER PIEUP-SIOS --> HALFWIDTH HANGUL LETTER PIEUP-SIOS
  MAKE_PAIR( 0x3145, 0xFFB5 ),	// HANGUL LETTER SIOS --> HALFWIDTH HANGUL LETTER SIOS
  MAKE_PAIR( 0x3146, 0xFFB6 ),	// HANGUL LETTER SSANGSIOS --> HALFWIDTH HANGUL LETTER SSANGSIOS
  MAKE_PAIR( 0x3147, 0xFFB7 ),	// HANGUL LETTER IEUNG --> HALFWIDTH HANGUL LETTER IEUNG
  MAKE_PAIR( 0x3148, 0xFFB8 ),	// HANGUL LETTER CIEUC --> HALFWIDTH HANGUL LETTER CIEUC
  MAKE_PAIR( 0x3149, 0xFFB9 ),	// HANGUL LETTER SSANGCIEUC --> HALFWIDTH HANGUL LETTER SSANGCIEUC
  MAKE_PAIR( 0x314A, 0xFFBA ),	// HANGUL LETTER CHIEUCH --> HALFWIDTH HANGUL LETTER CHIEUCH
  MAKE_PAIR( 0x314B, 0xFFBB ),	// HANGUL LETTER KHIEUKH --> HALFWIDTH HANGUL LETTER KHIEUKH
  MAKE_PAIR( 0x314C, 0xFFBC ),	// HANGUL LETTER THIEUTH --> HALFWIDTH HANGUL LETTER THIEUTH
  MAKE_PAIR( 0x314D, 0xFFBD ),	// HANGUL LETTER PHIEUPH --> HALFWIDTH HANGUL LETTER PHIEUPH
  MAKE_PAIR( 0x314E, 0xFFBE ),	// HANGUL LETTER HIEUH --> HALFWIDTH HANGUL LETTER HIEUH
  MAKE_PAIR( 0x314F, 0xFFC2 ),	// HANGUL LETTER A --> HALFWIDTH HANGUL LETTER A
  MAKE_PAIR( 0x3150, 0xFFC3 ),	// HANGUL LETTER AE --> HALFWIDTH HANGUL LETTER AE
  MAKE_PAIR( 0x3151, 0xFFC4 ),	// HANGUL LETTER YA --> HALFWIDTH HANGUL LETTER YA
  MAKE_PAIR( 0x3152, 0xFFC5 ),	// HANGUL LETTER YAE --> HALFWIDTH HANGUL LETTER YAE
  MAKE_PAIR( 0x3153, 0xFFC6 ),	// HANGUL LETTER EO --> HALFWIDTH HANGUL LETTER EO
  MAKE_PAIR( 0x3154, 0xFFC7 ),	// HANGUL LETTER E --> HALFWIDTH HANGUL LETTER E
  MAKE_PAIR( 0x3155, 0xFFCA ),	// HANGUL LETTER YEO --> HALFWIDTH HANGUL LETTER YEO
  MAKE_PAIR( 0x3156, 0xFFCB ),	// HANGUL LETTER YE --> HALFWIDTH HANGUL LETTER YE
  MAKE_PAIR( 0x3157, 0xFFCC ),	// HANGUL LETTER O --> HALFWIDTH HANGUL LETTER O
  MAKE_PAIR( 0x3158, 0xFFCD ),	// HANGUL LETTER WA --> HALFWIDTH HANGUL LETTER WA
  MAKE_PAIR( 0x3159, 0xFFCE ),	// HANGUL LETTER WAE --> HALFWIDTH HANGUL LETTER WAE
  MAKE_PAIR( 0x315A, 0xFFCF ),	// HANGUL LETTER OE --> HALFWIDTH HANGUL LETTER OE
  MAKE_PAIR( 0x315B, 0xFFD2 ),	// HANGUL LETTER YO --> HALFWIDTH HANGUL LETTER YO
  MAKE_PAIR( 0x315C, 0xFFD3 ),	// HANGUL LETTER U --> HALFWIDTH HANGUL LETTER U
  MAKE_PAIR( 0x315D, 0xFFD4 ),	// HANGUL LETTER WEO --> HALFWIDTH HANGUL LETTER WEO
  MAKE_PAIR( 0x315E, 0xFFD5 ),	// HANGUL LETTER WE --> HALFWIDTH HANGUL LETTER WE
  MAKE_PAIR( 0x315F, 0xFFD6 ),	// HANGUL LETTER WI --> HALFWIDTH HANGUL LETTER WI
  MAKE_PAIR( 0x3160, 0xFFD7 ),	// HANGUL LETTER YU --> HALFWIDTH HANGUL LETTER YU
  MAKE_PAIR( 0x3161, 0xFFDA ),	// HANGUL LETTER EU --> HALFWIDTH HANGUL LETTER EU
  MAKE_PAIR( 0x3162, 0xFFDB ),	// HANGUL LETTER YI --> HALFWIDTH HANGUL LETTER YI
  MAKE_PAIR( 0x3163, 0xFFDC ),	// HANGUL LETTER I --> HALFWIDTH HANGUL LETTER I
  MAKE_PAIR( 0x3164, 0xFFA0 ),	// HANGUL FILLER --> HALFWIDTH HANGUL FILLER
  MAKE_PAIR( 0xFF01, 0x0021 ),	// FULLWIDTH EXCLAMATION MARK --> EXCLAMATION MARK
  MAKE_PAIR( 0xFF02, 0x0022 ),	// FULLWIDTH QUOTATION MARK --> QUOTATION MARK
  MAKE_PAIR( 0xFF03, 0x0023 ),	// FULLWIDTH NUMBER SIGN --> NUMBER SIGN
  MAKE_PAIR( 0xFF04, 0x0024 ),	// FULLWIDTH DOLLAR SIGN --> DOLLAR SIGN
  MAKE_PAIR( 0xFF05, 0x0025 ),	// FULLWIDTH PERCENT SIGN --> PERCENT SIGN
  MAKE_PAIR( 0xFF06, 0x0026 ),	// FULLWIDTH AMPERSAND --> AMPERSAND
  MAKE_PAIR( 0xFF07, 0x0027 ),	// FULLWIDTH APOSTROPHE --> APOSTROPHE
  MAKE_PAIR( 0xFF08, 0x0028 ),	// FULLWIDTH LEFT PARENTHESIS --> LEFT PARENTHESIS
  MAKE_PAIR( 0xFF09, 0x0029 ),	// FULLWIDTH RIGHT PARENTHESIS --> RIGHT PARENTHESIS
  MAKE_PAIR( 0xFF0A, 0x002A ),	// FULLWIDTH ASTERISK --> ASTERISK
  MAKE_PAIR( 0xFF0B, 0x002B ),	// FULLWIDTH PLUS SIGN --> PLUS SIGN
  MAKE_PAIR( 0xFF0C, 0x002C ),	// FULLWIDTH COMMA --> COMMA

  MAKE_PAIR( 0xFF0D, 0x002D ),	// FULLWIDTH HYPHEN-MINUS --> HYPHEN-MINUS

  MAKE_PAIR( 0xFF0E, 0x002E ),	// FULLWIDTH FULL STOP --> FULL STOP
  MAKE_PAIR( 0xFF0F, 0x002F ),	// FULLWIDTH SOLIDUS --> SOLIDUS
  MAKE_PAIR( 0xFF10, 0x0030 ),	// FULLWIDTH DIGIT ZERO --> DIGIT ZERO
  MAKE_PAIR( 0xFF11, 0x0031 ),	// FULLWIDTH DIGIT ONE --> DIGIT ONE
  MAKE_PAIR( 0xFF12, 0x0032 ),	// FULLWIDTH DIGIT TWO --> DIGIT TWO
  MAKE_PAIR( 0xFF13, 0x0033 ),	// FULLWIDTH DIGIT THREE --> DIGIT THREE
  MAKE_PAIR( 0xFF14, 0x0034 ),	// FULLWIDTH DIGIT FOUR --> DIGIT FOUR
  MAKE_PAIR( 0xFF15, 0x0035 ),	// FULLWIDTH DIGIT FIVE --> DIGIT FIVE
  MAKE_PAIR( 0xFF16, 0x0036 ),	// FULLWIDTH DIGIT SIX --> DIGIT SIX
  MAKE_PAIR( 0xFF17, 0x0037 ),	// FULLWIDTH DIGIT SEVEN --> DIGIT SEVEN
  MAKE_PAIR( 0xFF18, 0x0038 ),	// FULLWIDTH DIGIT EIGHT --> DIGIT EIGHT
  MAKE_PAIR( 0xFF19, 0x0039 ),	// FULLWIDTH DIGIT NINE --> DIGIT NINE
  MAKE_PAIR( 0xFF1A, 0x003A ),	// FULLWIDTH COLON --> COLON
  MAKE_PAIR( 0xFF1B, 0x003B ),	// FULLWIDTH SEMICOLON --> SEMICOLON
  MAKE_PAIR( 0xFF1C, 0x003C ),	// FULLWIDTH LESS-THAN SIGN --> LESS-THAN SIGN
  MAKE_PAIR( 0xFF1D, 0x003D ),	// FULLWIDTH EQUALS SIGN --> EQUALS SIGN
  MAKE_PAIR( 0xFF1E, 0x003E ),	// FULLWIDTH GREATER-THAN SIGN --> GREATER-THAN SIGN
  MAKE_PAIR( 0xFF1F, 0x003F ),	// FULLWIDTH QUESTION MARK --> QUESTION MARK
  MAKE_PAIR( 0xFF20, 0x0040 ),	// FULLWIDTH COMMERCIAL AT --> COMMERCIAL AT
  MAKE_PAIR( 0xFF21, 0x0041 ),	// FULLWIDTH LATIN CAPITAL LETTER A --> LATIN CAPITAL LETTER A
  MAKE_PAIR( 0xFF22, 0x0042 ),	// FULLWIDTH LATIN CAPITAL LETTER B --> LATIN CAPITAL LETTER B
  MAKE_PAIR( 0xFF23, 0x0043 ),	// FULLWIDTH LATIN CAPITAL LETTER C --> LATIN CAPITAL LETTER C
  MAKE_PAIR( 0xFF24, 0x0044 ),	// FULLWIDTH LATIN CAPITAL LETTER D --> LATIN CAPITAL LETTER D
  MAKE_PAIR( 0xFF25, 0x0045 ),	// FULLWIDTH LATIN CAPITAL LETTER E --> LATIN CAPITAL LETTER E
  MAKE_PAIR( 0xFF26, 0x0046 ),	// FULLWIDTH LATIN CAPITAL LETTER F --> LATIN CAPITAL LETTER F
  MAKE_PAIR( 0xFF27, 0x0047 ),	// FULLWIDTH LATIN CAPITAL LETTER G --> LATIN CAPITAL LETTER G
  MAKE_PAIR( 0xFF28, 0x0048 ),	// FULLWIDTH LATIN CAPITAL LETTER H --> LATIN CAPITAL LETTER H
  MAKE_PAIR( 0xFF29, 0x0049 ),	// FULLWIDTH LATIN CAPITAL LETTER I --> LATIN CAPITAL LETTER I
  MAKE_PAIR( 0xFF2A, 0x004A ),	// FULLWIDTH LATIN CAPITAL LETTER J --> LATIN CAPITAL LETTER J
  MAKE_PAIR( 0xFF2B, 0x004B ),	// FULLWIDTH LATIN CAPITAL LETTER K --> LATIN CAPITAL LETTER K
  MAKE_PAIR( 0xFF2C, 0x004C ),	// FULLWIDTH LATIN CAPITAL LETTER L --> LATIN CAPITAL LETTER L
  MAKE_PAIR( 0xFF2D, 0x004D ),	// FULLWIDTH LATIN CAPITAL LETTER M --> LATIN CAPITAL LETTER M
  MAKE_PAIR( 0xFF2E, 0x004E ),	// FULLWIDTH LATIN CAPITAL LETTER N --> LATIN CAPITAL LETTER N
  MAKE_PAIR( 0xFF2F, 0x004F ),	// FULLWIDTH LATIN CAPITAL LETTER O --> LATIN CAPITAL LETTER O
  MAKE_PAIR( 0xFF30, 0x0050 ),	// FULLWIDTH LATIN CAPITAL LETTER P --> LATIN CAPITAL LETTER P
  MAKE_PAIR( 0xFF31, 0x0051 ),	// FULLWIDTH LATIN CAPITAL LETTER Q --> LATIN CAPITAL LETTER Q
  MAKE_PAIR( 0xFF32, 0x0052 ),	// FULLWIDTH LATIN CAPITAL LETTER R --> LATIN CAPITAL LETTER R
  MAKE_PAIR( 0xFF33, 0x0053 ),	// FULLWIDTH LATIN CAPITAL LETTER S --> LATIN CAPITAL LETTER S
  MAKE_PAIR( 0xFF34, 0x0054 ),	// FULLWIDTH LATIN CAPITAL LETTER T --> LATIN CAPITAL LETTER T
  MAKE_PAIR( 0xFF35, 0x0055 ),	// FULLWIDTH LATIN CAPITAL LETTER U --> LATIN CAPITAL LETTER U
  MAKE_PAIR( 0xFF36, 0x0056 ),	// FULLWIDTH LATIN CAPITAL LETTER V --> LATIN CAPITAL LETTER V
  MAKE_PAIR( 0xFF37, 0x0057 ),	// FULLWIDTH LATIN CAPITAL LETTER W --> LATIN CAPITAL LETTER W
  MAKE_PAIR( 0xFF38, 0x0058 ),	// FULLWIDTH LATIN CAPITAL LETTER X --> LATIN CAPITAL LETTER X
  MAKE_PAIR( 0xFF39, 0x0059 ),	// FULLWIDTH LATIN CAPITAL LETTER Y --> LATIN CAPITAL LETTER Y
  MAKE_PAIR( 0xFF3A, 0x005A ),	// FULLWIDTH LATIN CAPITAL LETTER Z --> LATIN CAPITAL LETTER Z
  MAKE_PAIR( 0xFF3B, 0x005B ),	// FULLWIDTH LEFT SQUARE BRACKET --> LEFT SQUARE BRACKET
  MAKE_PAIR( 0xFF3C, 0x005C ),	// FULLWIDTH REVERSE SOLIDUS --> REVERSE SOLIDUS
  MAKE_PAIR( 0xFF3D, 0x005D ),	// FULLWIDTH RIGHT SQUARE BRACKET --> RIGHT SQUARE BRACKET
  MAKE_PAIR( 0xFF3E, 0x005E ),	// FULLWIDTH CIRCUMFLEX ACCENT --> CIRCUMFLEX ACCENT
  MAKE_PAIR( 0xFF3F, 0x005F ),	// FULLWIDTH LOW LINE --> LOW LINE
  MAKE_PAIR( 0xFF40, 0x0060 ),	// FULLWIDTH GRAVE ACCENT --> GRAVE ACCENT
  MAKE_PAIR( 0xFF41, 0x0061 ),	// FULLWIDTH LATIN SMALL LETTER A --> LATIN SMALL LETTER A
  MAKE_PAIR( 0xFF42, 0x0062 ),	// FULLWIDTH LATIN SMALL LETTER B --> LATIN SMALL LETTER B
  MAKE_PAIR( 0xFF43, 0x0063 ),	// FULLWIDTH LATIN SMALL LETTER C --> LATIN SMALL LETTER C
  MAKE_PAIR( 0xFF44, 0x0064 ),	// FULLWIDTH LATIN SMALL LETTER D --> LATIN SMALL LETTER D
  MAKE_PAIR( 0xFF45, 0x0065 ),	// FULLWIDTH LATIN SMALL LETTER E --> LATIN SMALL LETTER E
  MAKE_PAIR( 0xFF46, 0x0066 ),	// FULLWIDTH LATIN SMALL LETTER F --> LATIN SMALL LETTER F
  MAKE_PAIR( 0xFF47, 0x0067 ),	// FULLWIDTH LATIN SMALL LETTER G --> LATIN SMALL LETTER G
  MAKE_PAIR( 0xFF48, 0x0068 ),	// FULLWIDTH LATIN SMALL LETTER H --> LATIN SMALL LETTER H
  MAKE_PAIR( 0xFF49, 0x0069 ),	// FULLWIDTH LATIN SMALL LETTER I --> LATIN SMALL LETTER I
  MAKE_PAIR( 0xFF4A, 0x006A ),	// FULLWIDTH LATIN SMALL LETTER J --> LATIN SMALL LETTER J
  MAKE_PAIR( 0xFF4B, 0x006B ),	// FULLWIDTH LATIN SMALL LETTER K --> LATIN SMALL LETTER K
  MAKE_PAIR( 0xFF4C, 0x006C ),	// FULLWIDTH LATIN SMALL LETTER L --> LATIN SMALL LETTER L
  MAKE_PAIR( 0xFF4D, 0x006D ),	// FULLWIDTH LATIN SMALL LETTER M --> LATIN SMALL LETTER M
  MAKE_PAIR( 0xFF4E, 0x006E ),	// FULLWIDTH LATIN SMALL LETTER N --> LATIN SMALL LETTER N
  MAKE_PAIR( 0xFF4F, 0x006F ),	// FULLWIDTH LATIN SMALL LETTER O --> LATIN SMALL LETTER O
  MAKE_PAIR( 0xFF50, 0x0070 ),	// FULLWIDTH LATIN SMALL LETTER P --> LATIN SMALL LETTER P
  MAKE_PAIR( 0xFF51, 0x0071 ),	// FULLWIDTH LATIN SMALL LETTER Q --> LATIN SMALL LETTER Q
  MAKE_PAIR( 0xFF52, 0x0072 ),	// FULLWIDTH LATIN SMALL LETTER R --> LATIN SMALL LETTER R
  MAKE_PAIR( 0xFF53, 0x0073 ),	// FULLWIDTH LATIN SMALL LETTER S --> LATIN SMALL LETTER S
  MAKE_PAIR( 0xFF54, 0x0074 ),	// FULLWIDTH LATIN SMALL LETTER T --> LATIN SMALL LETTER T
  MAKE_PAIR( 0xFF55, 0x0075 ),	// FULLWIDTH LATIN SMALL LETTER U --> LATIN SMALL LETTER U
  MAKE_PAIR( 0xFF56, 0x0076 ),	// FULLWIDTH LATIN SMALL LETTER V --> LATIN SMALL LETTER V
  MAKE_PAIR( 0xFF57, 0x0077 ),	// FULLWIDTH LATIN SMALL LETTER W --> LATIN SMALL LETTER W
  MAKE_PAIR( 0xFF58, 0x0078 ),	// FULLWIDTH LATIN SMALL LETTER X --> LATIN SMALL LETTER X
  MAKE_PAIR( 0xFF59, 0x0079 ),	// FULLWIDTH LATIN SMALL LETTER Y --> LATIN SMALL LETTER Y
  MAKE_PAIR( 0xFF5A, 0x007A ),	// FULLWIDTH LATIN SMALL LETTER Z --> LATIN SMALL LETTER Z
  MAKE_PAIR( 0xFF5B, 0x007B ),	// FULLWIDTH LEFT CURLY BRACKET --> LEFT CURLY BRACKET
  MAKE_PAIR( 0xFF5C, 0x007C ),	// FULLWIDTH VERTICAL LINE --> VERTICAL LINE
  MAKE_PAIR( 0xFF5D, 0x007D ),	// FULLWIDTH RIGHT CURLY BRACKET --> RIGHT CURLY BRACKET
  MAKE_PAIR( 0xFF5E, 0x007E ),	// FULLWIDTH TILDE --> TILDE
  MAKE_PAIR( 0xFFE0, 0x00A2 ),	// FULLWIDTH CENT SIGN --> CENT SIGN
  MAKE_PAIR( 0xFFE1, 0x00A3 ),	// FULLWIDTH POUND SIGN --> POUND SIGN
  MAKE_PAIR( 0xFFE2, 0x00AC ),	// FULLWIDTH NOT SIGN --> NOT SIGN
  MAKE_PAIR( 0xFFE3, 0x00AF ),	// FULLWIDTH MACRON --> MACRON
  MAKE_PAIR( 0xFFE4, 0x00A6 ),	// FULLWIDTH BROKEN BAR --> BROKEN BAR
  MAKE_PAIR( 0xFFE5, 0x00A5 ),	// FULLWIDTH YEN SIGN --> YEN SIGN
  MAKE_PAIR( 0xFFE6, 0x20A9 ) 	// FULLWIDTH WON SIGN --> WON SIGN
};

/*
  Unicode Normalization Forms
  http://www.unicode.org/unicode/reports/tr15/index.html
  http://www.w3.org/International/charlint/
*/

const sal_Unicode composition_table[][2] = {
	{ 0x0000, 0x0000 },	// 0x3040
	{ 0x0000, 0x0000 },	// 0x3041 HIRAGANA LETTER SMALL A
	{ 0x0000, 0x0000 },	// 0x3042 HIRAGANA LETTER A
	{ 0x0000, 0x0000 },	// 0x3043 HIRAGANA LETTER SMALL I
	{ 0x0000, 0x0000 },	// 0x3044 HIRAGANA LETTER I
	{ 0x0000, 0x0000 },	// 0x3045 HIRAGANA LETTER SMALL U
	{ 0x3094, 0x0000 },	// 0x3046 HIRAGANA LETTER U --> HIRAGANA LETTER VU
	{ 0x0000, 0x0000 },	// 0x3047 HIRAGANA LETTER SMALL E
	{ 0x0000, 0x0000 },	// 0x3048 HIRAGANA LETTER E
	{ 0x0000, 0x0000 },	// 0x3049 HIRAGANA LETTER SMALL O
	{ 0x0000, 0x0000 },	// 0x304a HIRAGANA LETTER O
	{ 0x304c, 0x0000 },	// 0x304b HIRAGANA LETTER KA --> HIRAGANA LETTER GA
	{ 0x0000, 0x0000 },	// 0x304c HIRAGANA LETTER GA
	{ 0x304e, 0x0000 },	// 0x304d HIRAGANA LETTER KI --> HIRAGANA LETTER GI
	{ 0x0000, 0x0000 },	// 0x304e HIRAGANA LETTER GI
	{ 0x3050, 0x0000 },	// 0x304f HIRAGANA LETTER KU --> HIRAGANA LETTER GU
	{ 0x0000, 0x0000 },	// 0x3050 HIRAGANA LETTER GU
	{ 0x3052, 0x0000 },	// 0x3051 HIRAGANA LETTER KE --> HIRAGANA LETTER GE
	{ 0x0000, 0x0000 },	// 0x3052 HIRAGANA LETTER GE
	{ 0x3054, 0x0000 },	// 0x3053 HIRAGANA LETTER KO --> HIRAGANA LETTER GO
	{ 0x0000, 0x0000 },	// 0x3054 HIRAGANA LETTER GO
	{ 0x3056, 0x0000 },	// 0x3055 HIRAGANA LETTER SA --> HIRAGANA LETTER ZA
	{ 0x0000, 0x0000 },	// 0x3056 HIRAGANA LETTER ZA
	{ 0x3058, 0x0000 },	// 0x3057 HIRAGANA LETTER SI --> HIRAGANA LETTER ZI
	{ 0x0000, 0x0000 },	// 0x3058 HIRAGANA LETTER ZI
	{ 0x305a, 0x0000 },	// 0x3059 HIRAGANA LETTER SU --> HIRAGANA LETTER ZU
	{ 0x0000, 0x0000 },	// 0x305a HIRAGANA LETTER ZU
	{ 0x305c, 0x0000 },	// 0x305b HIRAGANA LETTER SE --> HIRAGANA LETTER ZE
	{ 0x0000, 0x0000 },	// 0x305c HIRAGANA LETTER ZE
	{ 0x305e, 0x0000 },	// 0x305d HIRAGANA LETTER SO --> HIRAGANA LETTER ZO
	{ 0x0000, 0x0000 },	// 0x305e HIRAGANA LETTER ZO
	{ 0x3060, 0x0000 },	// 0x305f HIRAGANA LETTER TA --> HIRAGANA LETTER DA
	{ 0x0000, 0x0000 },	// 0x3060 HIRAGANA LETTER DA
	{ 0x3062, 0x0000 },	// 0x3061 HIRAGANA LETTER TI --> HIRAGANA LETTER DI
	{ 0x0000, 0x0000 },	// 0x3062 HIRAGANA LETTER DI
	{ 0x0000, 0x0000 },	// 0x3063 HIRAGANA LETTER SMALL TU
	{ 0x3065, 0x0000 },	// 0x3064 HIRAGANA LETTER TU --> HIRAGANA LETTER DU
	{ 0x0000, 0x0000 },	// 0x3065 HIRAGANA LETTER DU
	{ 0x3067, 0x0000 },	// 0x3066 HIRAGANA LETTER TE --> HIRAGANA LETTER DE
	{ 0x0000, 0x0000 },	// 0x3067 HIRAGANA LETTER DE
	{ 0x3069, 0x0000 },	// 0x3068 HIRAGANA LETTER TO --> HIRAGANA LETTER DO
	{ 0x0000, 0x0000 },	// 0x3069 HIRAGANA LETTER DO
	{ 0x0000, 0x0000 },	// 0x306a HIRAGANA LETTER NA
	{ 0x0000, 0x0000 },	// 0x306b HIRAGANA LETTER NI
	{ 0x0000, 0x0000 },	// 0x306c HIRAGANA LETTER NU
	{ 0x0000, 0x0000 },	// 0x306d HIRAGANA LETTER NE
	{ 0x0000, 0x0000 },	// 0x306e HIRAGANA LETTER NO
	{ 0x3070, 0x3071 },	// 0x306f HIRAGANA LETTER HA --> HIRAGANA LETTER BA or HIRAGANA LETTER PA
	{ 0x0000, 0x0000 },	// 0x3070 HIRAGANA LETTER BA
	{ 0x0000, 0x0000 },	// 0x3071 HIRAGANA LETTER PA
	{ 0x3073, 0x3074 },	// 0x3072 HIRAGANA LETTER HI --> HIRAGANA LETTER BI or HIRAGANA LETTER PI
	{ 0x0000, 0x0000 },	// 0x3073 HIRAGANA LETTER BI
	{ 0x0000, 0x0000 },	// 0x3074 HIRAGANA LETTER PI
	{ 0x3076, 0x3077 },	// 0x3075 HIRAGANA LETTER HU --> HIRAGANA LETTER BU or HIRAGANA LETTER PU
	{ 0x0000, 0x0000 },	// 0x3076 HIRAGANA LETTER BU
	{ 0x0000, 0x0000 },	// 0x3077 HIRAGANA LETTER PU
	{ 0x3079, 0x307a },	// 0x3078 HIRAGANA LETTER HE --> HIRAGANA LETTER BE or HIRAGANA LETTER PE
	{ 0x0000, 0x0000 },	// 0x3079 HIRAGANA LETTER BE
	{ 0x0000, 0x0000 },	// 0x307a HIRAGANA LETTER PE
	{ 0x307c, 0x307d },	// 0x307b HIRAGANA LETTER HO --> HIRAGANA LETTER BO or HIRAGANA LETTER PO
	{ 0x0000, 0x0000 },	// 0x307c HIRAGANA LETTER BO
	{ 0x0000, 0x0000 },	// 0x307d HIRAGANA LETTER PO
	{ 0x0000, 0x0000 },	// 0x307e HIRAGANA LETTER MA
	{ 0x0000, 0x0000 },	// 0x307f HIRAGANA LETTER MI
	{ 0x0000, 0x0000 },	// 0x3080 HIRAGANA LETTER MU
	{ 0x0000, 0x0000 },	// 0x3081 HIRAGANA LETTER ME
	{ 0x0000, 0x0000 },	// 0x3082 HIRAGANA LETTER MO
	{ 0x0000, 0x0000 },	// 0x3083 HIRAGANA LETTER SMALL YA
	{ 0x0000, 0x0000 },	// 0x3084 HIRAGANA LETTER YA
	{ 0x0000, 0x0000 },	// 0x3085 HIRAGANA LETTER SMALL YU
	{ 0x0000, 0x0000 },	// 0x3086 HIRAGANA LETTER YU
	{ 0x0000, 0x0000 },	// 0x3087 HIRAGANA LETTER SMALL YO
	{ 0x0000, 0x0000 },	// 0x3088 HIRAGANA LETTER YO
	{ 0x0000, 0x0000 },	// 0x3089 HIRAGANA LETTER RA
	{ 0x0000, 0x0000 },	// 0x308a HIRAGANA LETTER RI
	{ 0x0000, 0x0000 },	// 0x308b HIRAGANA LETTER RU
	{ 0x0000, 0x0000 },	// 0x308c HIRAGANA LETTER RE
	{ 0x0000, 0x0000 },	// 0x308d HIRAGANA LETTER RO
	{ 0x0000, 0x0000 },	// 0x308e HIRAGANA LETTER SMALL WA
	{ 0x0000, 0x0000 },	// 0x308f HIRAGANA LETTER WA
	{ 0x0000, 0x0000 },	// 0x3090 HIRAGANA LETTER WI
	{ 0x0000, 0x0000 },	// 0x3091 HIRAGANA LETTER WE
	{ 0x0000, 0x0000 },	// 0x3092 HIRAGANA LETTER WO
	{ 0x0000, 0x0000 },	// 0x3093 HIRAGANA LETTER N
	{ 0x0000, 0x0000 },	// 0x3094 HIRAGANA LETTER VU
	{ 0x0000, 0x0000 },	// 0x3095
	{ 0x0000, 0x0000 },	// 0x3096
	{ 0x0000, 0x0000 },	// 0x3097
	{ 0x0000, 0x0000 },	// 0x3098
	{ 0x0000, 0x0000 },	// 0x3099 COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x309a COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x309b KATAKANA-HIRAGANA VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x309c KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x309d HIRAGANA ITERATION MARK
	{ 0x0000, 0x0000 },	// 0x309e HIRAGANA VOICED ITERATION MARK
	{ 0x0000, 0x0000 },	// 0x309f
	{ 0x0000, 0x0000 },	// 0x30a0
	{ 0x0000, 0x0000 },	// 0x30a1 KATAKANA LETTER SMALL A
	{ 0x0000, 0x0000 },	// 0x30a2 KATAKANA LETTER A
	{ 0x0000, 0x0000 },	// 0x30a3 KATAKANA LETTER SMALL I
	{ 0x0000, 0x0000 },	// 0x30a4 KATAKANA LETTER I
	{ 0x0000, 0x0000 },	// 0x30a5 KATAKANA LETTER SMALL U
	{ 0x30f4, 0x0000 },	// 0x30a6 KATAKANA LETTER U --> KATAKANA LETTER VU
	{ 0x0000, 0x0000 },	// 0x30a7 KATAKANA LETTER SMALL E
	{ 0x0000, 0x0000 },	// 0x30a8 KATAKANA LETTER E
	{ 0x0000, 0x0000 },	// 0x30a9 KATAKANA LETTER SMALL O
	{ 0x0000, 0x0000 },	// 0x30aa KATAKANA LETTER O
	{ 0x30ac, 0x0000 },	// 0x30ab KATAKANA LETTER KA --> KATAKANA LETTER GA
	{ 0x0000, 0x0000 },	// 0x30ac KATAKANA LETTER GA
	{ 0x30ae, 0x0000 },	// 0x30ad KATAKANA LETTER KI --> KATAKANA LETTER GI
	{ 0x0000, 0x0000 },	// 0x30ae KATAKANA LETTER GI
	{ 0x30b0, 0x0000 },	// 0x30af KATAKANA LETTER KU --> KATAKANA LETTER GU
	{ 0x0000, 0x0000 },	// 0x30b0 KATAKANA LETTER GU
	{ 0x30b2, 0x0000 },	// 0x30b1 KATAKANA LETTER KE --> KATAKANA LETTER GE
	{ 0x0000, 0x0000 },	// 0x30b2 KATAKANA LETTER GE
	{ 0x30b4, 0x0000 },	// 0x30b3 KATAKANA LETTER KO --> KATAKANA LETTER GO
	{ 0x0000, 0x0000 },	// 0x30b4 KATAKANA LETTER GO
	{ 0x30b6, 0x0000 },	// 0x30b5 KATAKANA LETTER SA --> KATAKANA LETTER ZA
	{ 0x0000, 0x0000 },	// 0x30b6 KATAKANA LETTER ZA
	{ 0x30b8, 0x0000 },	// 0x30b7 KATAKANA LETTER SI --> KATAKANA LETTER ZI
	{ 0x0000, 0x0000 },	// 0x30b8 KATAKANA LETTER ZI
	{ 0x30ba, 0x0000 },	// 0x30b9 KATAKANA LETTER SU --> KATAKANA LETTER ZU
	{ 0x0000, 0x0000 },	// 0x30ba KATAKANA LETTER ZU
	{ 0x30bc, 0x0000 },	// 0x30bb KATAKANA LETTER SE --> KATAKANA LETTER ZE
	{ 0x0000, 0x0000 },	// 0x30bc KATAKANA LETTER ZE
	{ 0x30be, 0x0000 },	// 0x30bd KATAKANA LETTER SO --> KATAKANA LETTER ZO
	{ 0x0000, 0x0000 },	// 0x30be KATAKANA LETTER ZO
	{ 0x30c0, 0x0000 },	// 0x30bf KATAKANA LETTER TA --> KATAKANA LETTER DA
	{ 0x0000, 0x0000 },	// 0x30c0 KATAKANA LETTER DA
	{ 0x30c2, 0x0000 },	// 0x30c1 KATAKANA LETTER TI --> KATAKANA LETTER DI
	{ 0x0000, 0x0000 },	// 0x30c2 KATAKANA LETTER DI
	{ 0x0000, 0x0000 },	// 0x30c3 KATAKANA LETTER SMALL TU
	{ 0x30c5, 0x0000 },	// 0x30c4 KATAKANA LETTER TU --> KATAKANA LETTER DU
	{ 0x0000, 0x0000 },	// 0x30c5 KATAKANA LETTER DU
	{ 0x30c7, 0x0000 },	// 0x30c6 KATAKANA LETTER TE --> KATAKANA LETTER DE
	{ 0x0000, 0x0000 },	// 0x30c7 KATAKANA LETTER DE
	{ 0x30c9, 0x0000 },	// 0x30c8 KATAKANA LETTER TO --> KATAKANA LETTER DO
	{ 0x0000, 0x0000 },	// 0x30c9 KATAKANA LETTER DO
	{ 0x0000, 0x0000 },	// 0x30ca KATAKANA LETTER NA
	{ 0x0000, 0x0000 },	// 0x30cb KATAKANA LETTER NI
	{ 0x0000, 0x0000 },	// 0x30cc KATAKANA LETTER NU
	{ 0x0000, 0x0000 },	// 0x30cd KATAKANA LETTER NE
	{ 0x0000, 0x0000 },	// 0x30ce KATAKANA LETTER NO
	{ 0x30d0, 0x30d1 },	// 0x30cf KATAKANA LETTER HA --> KATAKANA LETTER BA or KATAKANA LETTER PA
	{ 0x0000, 0x0000 },	// 0x30d0 KATAKANA LETTER BA
	{ 0x0000, 0x0000 },	// 0x30d1 KATAKANA LETTER PA
	{ 0x30d3, 0x30d4 },	// 0x30d2 KATAKANA LETTER HI --> KATAKANA LETTER BI or KATAKANA LETTER PI
	{ 0x0000, 0x0000 },	// 0x30d3 KATAKANA LETTER BI
	{ 0x0000, 0x0000 },	// 0x30d4 KATAKANA LETTER PI
	{ 0x30d6, 0x30d7 },	// 0x30d5 KATAKANA LETTER HU --> KATAKANA LETTER BU or KATAKANA LETTER PU
	{ 0x0000, 0x0000 },	// 0x30d6 KATAKANA LETTER BU
	{ 0x0000, 0x0000 },	// 0x30d7 KATAKANA LETTER PU
	{ 0x30d9, 0x30da },	// 0x30d8 KATAKANA LETTER HE --> KATAKANA LETTER BE or KATAKANA LETTER PE
	{ 0x0000, 0x0000 },	// 0x30d9 KATAKANA LETTER BE
	{ 0x0000, 0x0000 },	// 0x30da KATAKANA LETTER PE
	{ 0x30dc, 0x30dd },	// 0x30db KATAKANA LETTER HO --> KATAKANA LETTER BO or KATAKANA LETTER PO
	{ 0x0000, 0x0000 },	// 0x30dc KATAKANA LETTER BO
	{ 0x0000, 0x0000 },	// 0x30dd KATAKANA LETTER PO
	{ 0x0000, 0x0000 },	// 0x30de KATAKANA LETTER MA
	{ 0x0000, 0x0000 },	// 0x30df KATAKANA LETTER MI
	{ 0x0000, 0x0000 },	// 0x30e0 KATAKANA LETTER MU
	{ 0x0000, 0x0000 },	// 0x30e1 KATAKANA LETTER ME
	{ 0x0000, 0x0000 },	// 0x30e2 KATAKANA LETTER MO
	{ 0x0000, 0x0000 },	// 0x30e3 KATAKANA LETTER SMALL YA
	{ 0x0000, 0x0000 },	// 0x30e4 KATAKANA LETTER YA
	{ 0x0000, 0x0000 },	// 0x30e5 KATAKANA LETTER SMALL YU
	{ 0x0000, 0x0000 },	// 0x30e6 KATAKANA LETTER YU
	{ 0x0000, 0x0000 },	// 0x30e7 KATAKANA LETTER SMALL YO
	{ 0x0000, 0x0000 },	// 0x30e8 KATAKANA LETTER YO
	{ 0x0000, 0x0000 },	// 0x30e9 KATAKANA LETTER RA
	{ 0x0000, 0x0000 },	// 0x30ea KATAKANA LETTER RI
	{ 0x0000, 0x0000 },	// 0x30eb KATAKANA LETTER RU
	{ 0x0000, 0x0000 },	// 0x30ec KATAKANA LETTER RE
	{ 0x0000, 0x0000 },	// 0x30ed KATAKANA LETTER RO
	{ 0x0000, 0x0000 },	// 0x30ee KATAKANA LETTER SMALL WA
	{ 0x30f7, 0x0000 },	// 0x30ef KATAKANA LETTER WA --> KATAKANA LETTER VA
	{ 0x30f8, 0x0000 },	// 0x30f0 KATAKANA LETTER WI --> KATAKANA LETTER VI
	{ 0x30f9, 0x0000 },	// 0x30f1 KATAKANA LETTER WE --> KATAKANA LETTER VE
	{ 0x30fa, 0x0000 },	// 0x30f2 KATAKANA LETTER WO --> KATAKANA LETTER VO
	{ 0x0000, 0x0000 },	// 0x30f3 KATAKANA LETTER N
	{ 0x0000, 0x0000 },	// 0x30f4 KATAKANA LETTER VU
	{ 0x0000, 0x0000 },	// 0x30f5 KATAKANA LETTER SMALL KA
	{ 0x0000, 0x0000 },	// 0x30f6 KATAKANA LETTER SMALL KE
	{ 0x0000, 0x0000 },	// 0x30f7 KATAKANA LETTER VA
	{ 0x0000, 0x0000 },	// 0x30f8 KATAKANA LETTER VI
	{ 0x0000, 0x0000 },	// 0x30f9 KATAKANA LETTER VE
	{ 0x0000, 0x0000 },	// 0x30fa KATAKANA LETTER VO
	{ 0x0000, 0x0000 },	// 0x30fb KATAKANA MIDDLE DOT
	{ 0x0000, 0x0000 },	// 0x30fc KATAKANA-HIRAGANA PROLONGED SOUND MARK
	{ 0x0000, 0x0000 },	// 0x30fd KATAKANA ITERATION MARK
	{ 0x0000, 0x0000 },	// 0x30fe KATAKANA VOICED ITERATION MARK
	{ 0x0000, 0x0000 }	// 0x30ff 
};


/*
  Halfwidth and Fullwidth Forms (U+FF00..U+FFEF)
  ftp://ftp.unicode.org/Public/3.0-Update/UnicodeData-3.0.0.txt
  ftp://ftp.unicode.org/Public/3.0-Update/UnicodeData-3.0.0.html
  http://charts.unicode.org/Web/UFF00.html 
*/

OneToOneMappingTable_t half2full[] = {	
  MAKE_PAIR( 0x0020, 0x3000 ),	// SPACE --> IDEOGRAPHIC SPACE
  MAKE_PAIR( 0x0021, 0xFF01 ),	// EXCLAMATION MARK --> FULLWIDTH EXCLAMATION MARK
  MAKE_PAIR( 0x0022, 0xFF02 ),	// QUOTATION MARK --> FULLWIDTH QUOTATION MARK
  MAKE_PAIR( 0x0023, 0xFF03 ),	// NUMBER SIGN --> FULLWIDTH NUMBER SIGN
  MAKE_PAIR( 0x0024, 0xFF04 ),	// DOLLAR SIGN --> FULLWIDTH DOLLAR SIGN
  MAKE_PAIR( 0x0025, 0xFF05 ),	// PERCENT SIGN --> FULLWIDTH PERCENT SIGN
  MAKE_PAIR( 0x0026, 0xFF06 ),	// AMPERSAND --> FULLWIDTH AMPERSAND
  MAKE_PAIR( 0x0027, 0xFF07 ),	// APOSTROPHE --> FULLWIDTH APOSTROPHE
  MAKE_PAIR( 0x0028, 0xFF08 ),	// LEFT PARENTHESIS --> FULLWIDTH LEFT PARENTHESIS
  MAKE_PAIR( 0x0029, 0xFF09 ),	// RIGHT PARENTHESIS --> FULLWIDTH RIGHT PARENTHESIS
  MAKE_PAIR( 0x002A, 0xFF0A ),	// ASTERISK --> FULLWIDTH ASTERISK
  MAKE_PAIR( 0x002B, 0xFF0B ),	// PLUS SIGN --> FULLWIDTH PLUS SIGN
  MAKE_PAIR( 0x002C, 0xFF0C ),	// COMMA --> FULLWIDTH COMMA

  MAKE_PAIR( 0x002D, 0xFF0D ),	// HYPHEN-MINUS --> FULLWIDTH HYPHEN-MINUS
//MAKE_PAIR( 0x002D, 0x2212 ),	// HYPHEN-MINUS --> MINUS SIGN

  MAKE_PAIR( 0x002E, 0xFF0E ),	// FULL STOP --> FULLWIDTH FULL STOP
  MAKE_PAIR( 0x002F, 0xFF0F ),	// SOLIDUS --> FULLWIDTH SOLIDUS
  MAKE_PAIR( 0x0030, 0xFF10 ),	// DIGIT ZERO --> FULLWIDTH DIGIT ZERO
  MAKE_PAIR( 0x0031, 0xFF11 ),	// DIGIT ONE --> FULLWIDTH DIGIT ONE
  MAKE_PAIR( 0x0032, 0xFF12 ),	// DIGIT TWO --> FULLWIDTH DIGIT TWO
  MAKE_PAIR( 0x0033, 0xFF13 ),	// DIGIT THREE --> FULLWIDTH DIGIT THREE
  MAKE_PAIR( 0x0034, 0xFF14 ),	// DIGIT FOUR --> FULLWIDTH DIGIT FOUR
  MAKE_PAIR( 0x0035, 0xFF15 ),	// DIGIT FIVE --> FULLWIDTH DIGIT FIVE
  MAKE_PAIR( 0x0036, 0xFF16 ),	// DIGIT SIX --> FULLWIDTH DIGIT SIX
  MAKE_PAIR( 0x0037, 0xFF17 ),	// DIGIT SEVEN --> FULLWIDTH DIGIT SEVEN
  MAKE_PAIR( 0x0038, 0xFF18 ),	// DIGIT EIGHT --> FULLWIDTH DIGIT EIGHT
  MAKE_PAIR( 0x0039, 0xFF19 ),	// DIGIT NINE --> FULLWIDTH DIGIT NINE
  MAKE_PAIR( 0x003A, 0xFF1A ),	// COLON --> FULLWIDTH COLON
  MAKE_PAIR( 0x003B, 0xFF1B ),	// SEMICOLON --> FULLWIDTH SEMICOLON
  MAKE_PAIR( 0x003C, 0xFF1C ),	// LESS-THAN SIGN --> FULLWIDTH LESS-THAN SIGN
  MAKE_PAIR( 0x003D, 0xFF1D ),	// EQUALS SIGN --> FULLWIDTH EQUALS SIGN
  MAKE_PAIR( 0x003E, 0xFF1E ),	// GREATER-THAN SIGN --> FULLWIDTH GREATER-THAN SIGN
  MAKE_PAIR( 0x003F, 0xFF1F ),	// QUESTION MARK --> FULLWIDTH QUESTION MARK
  MAKE_PAIR( 0x0040, 0xFF20 ),	// COMMERCIAL AT --> FULLWIDTH COMMERCIAL AT
  MAKE_PAIR( 0x0041, 0xFF21 ),	// LATIN CAPITAL LETTER A --> FULLWIDTH LATIN CAPITAL LETTER A
  MAKE_PAIR( 0x0042, 0xFF22 ),	// LATIN CAPITAL LETTER B --> FULLWIDTH LATIN CAPITAL LETTER B
  MAKE_PAIR( 0x0043, 0xFF23 ),	// LATIN CAPITAL LETTER C --> FULLWIDTH LATIN CAPITAL LETTER C
  MAKE_PAIR( 0x0044, 0xFF24 ),	// LATIN CAPITAL LETTER D --> FULLWIDTH LATIN CAPITAL LETTER D
  MAKE_PAIR( 0x0045, 0xFF25 ),	// LATIN CAPITAL LETTER E --> FULLWIDTH LATIN CAPITAL LETTER E
  MAKE_PAIR( 0x0046, 0xFF26 ),	// LATIN CAPITAL LETTER F --> FULLWIDTH LATIN CAPITAL LETTER F
  MAKE_PAIR( 0x0047, 0xFF27 ),	// LATIN CAPITAL LETTER G --> FULLWIDTH LATIN CAPITAL LETTER G
  MAKE_PAIR( 0x0048, 0xFF28 ),	// LATIN CAPITAL LETTER H --> FULLWIDTH LATIN CAPITAL LETTER H
  MAKE_PAIR( 0x0049, 0xFF29 ),	// LATIN CAPITAL LETTER I --> FULLWIDTH LATIN CAPITAL LETTER I
  MAKE_PAIR( 0x004A, 0xFF2A ),	// LATIN CAPITAL LETTER J --> FULLWIDTH LATIN CAPITAL LETTER J
  MAKE_PAIR( 0x004B, 0xFF2B ),	// LATIN CAPITAL LETTER K --> FULLWIDTH LATIN CAPITAL LETTER K
  MAKE_PAIR( 0x004C, 0xFF2C ),	// LATIN CAPITAL LETTER L --> FULLWIDTH LATIN CAPITAL LETTER L
  MAKE_PAIR( 0x004D, 0xFF2D ),	// LATIN CAPITAL LETTER M --> FULLWIDTH LATIN CAPITAL LETTER M
  MAKE_PAIR( 0x004E, 0xFF2E ),	// LATIN CAPITAL LETTER N --> FULLWIDTH LATIN CAPITAL LETTER N
  MAKE_PAIR( 0x004F, 0xFF2F ),	// LATIN CAPITAL LETTER O --> FULLWIDTH LATIN CAPITAL LETTER O
  MAKE_PAIR( 0x0050, 0xFF30 ),	// LATIN CAPITAL LETTER P --> FULLWIDTH LATIN CAPITAL LETTER P
  MAKE_PAIR( 0x0051, 0xFF31 ),	// LATIN CAPITAL LETTER Q --> FULLWIDTH LATIN CAPITAL LETTER Q
  MAKE_PAIR( 0x0052, 0xFF32 ),	// LATIN CAPITAL LETTER R --> FULLWIDTH LATIN CAPITAL LETTER R
  MAKE_PAIR( 0x0053, 0xFF33 ),	// LATIN CAPITAL LETTER S --> FULLWIDTH LATIN CAPITAL LETTER S
  MAKE_PAIR( 0x0054, 0xFF34 ),	// LATIN CAPITAL LETTER T --> FULLWIDTH LATIN CAPITAL LETTER T
  MAKE_PAIR( 0x0055, 0xFF35 ),	// LATIN CAPITAL LETTER U --> FULLWIDTH LATIN CAPITAL LETTER U
  MAKE_PAIR( 0x0056, 0xFF36 ),	// LATIN CAPITAL LETTER V --> FULLWIDTH LATIN CAPITAL LETTER V
  MAKE_PAIR( 0x0057, 0xFF37 ),	// LATIN CAPITAL LETTER W --> FULLWIDTH LATIN CAPITAL LETTER W
  MAKE_PAIR( 0x0058, 0xFF38 ),	// LATIN CAPITAL LETTER X --> FULLWIDTH LATIN CAPITAL LETTER X
  MAKE_PAIR( 0x0059, 0xFF39 ),	// LATIN CAPITAL LETTER Y --> FULLWIDTH LATIN CAPITAL LETTER Y
  MAKE_PAIR( 0x005A, 0xFF3A ),	// LATIN CAPITAL LETTER Z --> FULLWIDTH LATIN CAPITAL LETTER Z
  MAKE_PAIR( 0x005B, 0xFF3B ),	// LEFT SQUARE BRACKET --> FULLWIDTH LEFT SQUARE BRACKET
  MAKE_PAIR( 0x005C, 0xFF3C ),	// REVERSE SOLIDUS --> FULLWIDTH REVERSE SOLIDUS
  MAKE_PAIR( 0x005D, 0xFF3D ),	// RIGHT SQUARE BRACKET --> FULLWIDTH RIGHT SQUARE BRACKET
  MAKE_PAIR( 0x005E, 0xFF3E ),	// CIRCUMFLEX ACCENT --> FULLWIDTH CIRCUMFLEX ACCENT
  MAKE_PAIR( 0x005F, 0xFF3F ),	// LOW LINE --> FULLWIDTH LOW LINE
  MAKE_PAIR( 0x0060, 0xFF40 ),	// GRAVE ACCENT --> FULLWIDTH GRAVE ACCENT
  MAKE_PAIR( 0x0061, 0xFF41 ),	// LATIN SMALL LETTER A --> FULLWIDTH LATIN SMALL LETTER A
  MAKE_PAIR( 0x0062, 0xFF42 ),	// LATIN SMALL LETTER B --> FULLWIDTH LATIN SMALL LETTER B
  MAKE_PAIR( 0x0063, 0xFF43 ),	// LATIN SMALL LETTER C --> FULLWIDTH LATIN SMALL LETTER C
  MAKE_PAIR( 0x0064, 0xFF44 ),	// LATIN SMALL LETTER D --> FULLWIDTH LATIN SMALL LETTER D
  MAKE_PAIR( 0x0065, 0xFF45 ),	// LATIN SMALL LETTER E --> FULLWIDTH LATIN SMALL LETTER E
  MAKE_PAIR( 0x0066, 0xFF46 ),	// LATIN SMALL LETTER F --> FULLWIDTH LATIN SMALL LETTER F
  MAKE_PAIR( 0x0067, 0xFF47 ),	// LATIN SMALL LETTER G --> FULLWIDTH LATIN SMALL LETTER G
  MAKE_PAIR( 0x0068, 0xFF48 ),	// LATIN SMALL LETTER H --> FULLWIDTH LATIN SMALL LETTER H
  MAKE_PAIR( 0x0069, 0xFF49 ),	// LATIN SMALL LETTER I --> FULLWIDTH LATIN SMALL LETTER I
  MAKE_PAIR( 0x006A, 0xFF4A ),	// LATIN SMALL LETTER J --> FULLWIDTH LATIN SMALL LETTER J
  MAKE_PAIR( 0x006B, 0xFF4B ),	// LATIN SMALL LETTER K --> FULLWIDTH LATIN SMALL LETTER K
  MAKE_PAIR( 0x006C, 0xFF4C ),	// LATIN SMALL LETTER L --> FULLWIDTH LATIN SMALL LETTER L
  MAKE_PAIR( 0x006D, 0xFF4D ),	// LATIN SMALL LETTER M --> FULLWIDTH LATIN SMALL LETTER M
  MAKE_PAIR( 0x006E, 0xFF4E ),	// LATIN SMALL LETTER N --> FULLWIDTH LATIN SMALL LETTER N
  MAKE_PAIR( 0x006F, 0xFF4F ),	// LATIN SMALL LETTER O --> FULLWIDTH LATIN SMALL LETTER O
  MAKE_PAIR( 0x0070, 0xFF50 ),	// LATIN SMALL LETTER P --> FULLWIDTH LATIN SMALL LETTER P
  MAKE_PAIR( 0x0071, 0xFF51 ),	// LATIN SMALL LETTER Q --> FULLWIDTH LATIN SMALL LETTER Q
  MAKE_PAIR( 0x0072, 0xFF52 ),	// LATIN SMALL LETTER R --> FULLWIDTH LATIN SMALL LETTER R
  MAKE_PAIR( 0x0073, 0xFF53 ),	// LATIN SMALL LETTER S --> FULLWIDTH LATIN SMALL LETTER S
  MAKE_PAIR( 0x0074, 0xFF54 ),	// LATIN SMALL LETTER T --> FULLWIDTH LATIN SMALL LETTER T
  MAKE_PAIR( 0x0075, 0xFF55 ),	// LATIN SMALL LETTER U --> FULLWIDTH LATIN SMALL LETTER U
  MAKE_PAIR( 0x0076, 0xFF56 ),	// LATIN SMALL LETTER V --> FULLWIDTH LATIN SMALL LETTER V
  MAKE_PAIR( 0x0077, 0xFF57 ),	// LATIN SMALL LETTER W --> FULLWIDTH LATIN SMALL LETTER W
  MAKE_PAIR( 0x0078, 0xFF58 ),	// LATIN SMALL LETTER X --> FULLWIDTH LATIN SMALL LETTER X
  MAKE_PAIR( 0x0079, 0xFF59 ),	// LATIN SMALL LETTER Y --> FULLWIDTH LATIN SMALL LETTER Y
  MAKE_PAIR( 0x007A, 0xFF5A ),	// LATIN SMALL LETTER Z --> FULLWIDTH LATIN SMALL LETTER Z
  MAKE_PAIR( 0x007B, 0xFF5B ),	// LEFT CURLY BRACKET --> FULLWIDTH LEFT CURLY BRACKET
  MAKE_PAIR( 0x007C, 0xFF5C ),	// VERTICAL LINE --> FULLWIDTH VERTICAL LINE
  MAKE_PAIR( 0x007D, 0xFF5D ),	// RIGHT CURLY BRACKET --> FULLWIDTH RIGHT CURLY BRACKET
  MAKE_PAIR( 0x007E, 0xFF5E ),	// TILDE --> FULLWIDTH TILDE
  MAKE_PAIR( 0x00A2, 0xFFE0 ),	// CENT SIGN --> FULLWIDTH CENT SIGN
  MAKE_PAIR( 0x00A3, 0xFFE1 ),	// POUND SIGN --> FULLWIDTH POUND SIGN
  MAKE_PAIR( 0x00A5, 0xFFE5 ),	// YEN SIGN --> FULLWIDTH YEN SIGN
  MAKE_PAIR( 0x00A6, 0xFFE4 ),	// BROKEN BAR --> FULLWIDTH BROKEN BAR
  MAKE_PAIR( 0x00AC, 0xFFE2 ),	// NOT SIGN --> FULLWIDTH NOT SIGN
  MAKE_PAIR( 0x00AF, 0xFFE3 ),	// MACRON --> FULLWIDTH MACRON
  MAKE_PAIR( 0x20A9, 0xFFE6 ),	// WON SIGN --> FULLWIDTH WON SIGN
  MAKE_PAIR( 0xFF61, 0x3002 ),	// HALFWIDTH IDEOGRAPHIC FULL STOP --> IDEOGRAPHIC FULL STOP
  MAKE_PAIR( 0xFF62, 0x300C ),	// HALFWIDTH LEFT CORNER BRACKET --> LEFT CORNER BRACKET
  MAKE_PAIR( 0xFF63, 0x300D ),	// HALFWIDTH RIGHT CORNER BRACKET --> RIGHT CORNER BRACKET
  MAKE_PAIR( 0xFF64, 0x3001 ),	// HALFWIDTH IDEOGRAPHIC COMMA --> IDEOGRAPHIC COMMA
  MAKE_PAIR( 0xFF65, 0x30FB ),	// HALFWIDTH KATAKANA MIDDLE DOT --> KATAKANA MIDDLE DOT
  MAKE_PAIR( 0xFF66, 0x30F2 ),	// HALFWIDTH KATAKANA LETTER WO --> KATAKANA LETTER WO
  MAKE_PAIR( 0xFF67, 0x30A1 ),	// HALFWIDTH KATAKANA LETTER SMALL A --> KATAKANA LETTER SMALL A
  MAKE_PAIR( 0xFF68, 0x30A3 ),	// HALFWIDTH KATAKANA LETTER SMALL I --> KATAKANA LETTER SMALL I
  MAKE_PAIR( 0xFF69, 0x30A5 ),	// HALFWIDTH KATAKANA LETTER SMALL U --> KATAKANA LETTER SMALL U
  MAKE_PAIR( 0xFF6A, 0x30A7 ),	// HALFWIDTH KATAKANA LETTER SMALL E --> KATAKANA LETTER SMALL E
  MAKE_PAIR( 0xFF6B, 0x30A9 ),	// HALFWIDTH KATAKANA LETTER SMALL O --> KATAKANA LETTER SMALL O
  MAKE_PAIR( 0xFF6C, 0x30E3 ),	// HALFWIDTH KATAKANA LETTER SMALL YA --> KATAKANA LETTER SMALL YA
  MAKE_PAIR( 0xFF6D, 0x30E5 ),	// HALFWIDTH KATAKANA LETTER SMALL YU --> KATAKANA LETTER SMALL YU
  MAKE_PAIR( 0xFF6E, 0x30E7 ),	// HALFWIDTH KATAKANA LETTER SMALL YO --> KATAKANA LETTER SMALL YO
  MAKE_PAIR( 0xFF6F, 0x30C3 ),	// HALFWIDTH KATAKANA LETTER SMALL TU --> KATAKANA LETTER SMALL TU
  MAKE_PAIR( 0xFF70, 0x30FC ),	// HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK --> KATAKANA-HIRAGANA PROLONGED SOUND MARK
  MAKE_PAIR( 0xFF71, 0x30A2 ),	// HALFWIDTH KATAKANA LETTER A --> KATAKANA LETTER A
  MAKE_PAIR( 0xFF72, 0x30A4 ),	// HALFWIDTH KATAKANA LETTER I --> KATAKANA LETTER I
  MAKE_PAIR( 0xFF73, 0x30A6 ),	// HALFWIDTH KATAKANA LETTER U --> KATAKANA LETTER U
  MAKE_PAIR( 0xFF74, 0x30A8 ),	// HALFWIDTH KATAKANA LETTER E --> KATAKANA LETTER E
  MAKE_PAIR( 0xFF75, 0x30AA ),	// HALFWIDTH KATAKANA LETTER O --> KATAKANA LETTER O
  MAKE_PAIR( 0xFF76, 0x30AB ),	// HALFWIDTH KATAKANA LETTER KA --> KATAKANA LETTER KA
  MAKE_PAIR( 0xFF77, 0x30AD ),	// HALFWIDTH KATAKANA LETTER KI --> KATAKANA LETTER KI
  MAKE_PAIR( 0xFF78, 0x30AF ),	// HALFWIDTH KATAKANA LETTER KU --> KATAKANA LETTER KU
  MAKE_PAIR( 0xFF79, 0x30B1 ),	// HALFWIDTH KATAKANA LETTER KE --> KATAKANA LETTER KE
  MAKE_PAIR( 0xFF7A, 0x30B3 ),	// HALFWIDTH KATAKANA LETTER KO --> KATAKANA LETTER KO
  MAKE_PAIR( 0xFF7B, 0x30B5 ),	// HALFWIDTH KATAKANA LETTER SA --> KATAKANA LETTER SA
  MAKE_PAIR( 0xFF7C, 0x30B7 ),	// HALFWIDTH KATAKANA LETTER SI --> KATAKANA LETTER SI
  MAKE_PAIR( 0xFF7D, 0x30B9 ),	// HALFWIDTH KATAKANA LETTER SU --> KATAKANA LETTER SU
  MAKE_PAIR( 0xFF7E, 0x30BB ),	// HALFWIDTH KATAKANA LETTER SE --> KATAKANA LETTER SE
  MAKE_PAIR( 0xFF7F, 0x30BD ),	// HALFWIDTH KATAKANA LETTER SO --> KATAKANA LETTER SO
  MAKE_PAIR( 0xFF80, 0x30BF ),	// HALFWIDTH KATAKANA LETTER TA --> KATAKANA LETTER TA
  MAKE_PAIR( 0xFF81, 0x30C1 ),	// HALFWIDTH KATAKANA LETTER TI --> KATAKANA LETTER TI
  MAKE_PAIR( 0xFF82, 0x30C4 ),	// HALFWIDTH KATAKANA LETTER TU --> KATAKANA LETTER TU
  MAKE_PAIR( 0xFF83, 0x30C6 ),	// HALFWIDTH KATAKANA LETTER TE --> KATAKANA LETTER TE
  MAKE_PAIR( 0xFF84, 0x30C8 ),	// HALFWIDTH KATAKANA LETTER TO --> KATAKANA LETTER TO
  MAKE_PAIR( 0xFF85, 0x30CA ),	// HALFWIDTH KATAKANA LETTER NA --> KATAKANA LETTER NA
  MAKE_PAIR( 0xFF86, 0x30CB ),	// HALFWIDTH KATAKANA LETTER NI --> KATAKANA LETTER NI
  MAKE_PAIR( 0xFF87, 0x30CC ),	// HALFWIDTH KATAKANA LETTER NU --> KATAKANA LETTER NU
  MAKE_PAIR( 0xFF88, 0x30CD ),	// HALFWIDTH KATAKANA LETTER NE --> KATAKANA LETTER NE
  MAKE_PAIR( 0xFF89, 0x30CE ),	// HALFWIDTH KATAKANA LETTER NO --> KATAKANA LETTER NO
  MAKE_PAIR( 0xFF8A, 0x30CF ),	// HALFWIDTH KATAKANA LETTER HA --> KATAKANA LETTER HA
  MAKE_PAIR( 0xFF8B, 0x30D2 ),	// HALFWIDTH KATAKANA LETTER HI --> KATAKANA LETTER HI
  MAKE_PAIR( 0xFF8C, 0x30D5 ),	// HALFWIDTH KATAKANA LETTER HU --> KATAKANA LETTER HU
  MAKE_PAIR( 0xFF8D, 0x30D8 ),	// HALFWIDTH KATAKANA LETTER HE --> KATAKANA LETTER HE
  MAKE_PAIR( 0xFF8E, 0x30DB ),	// HALFWIDTH KATAKANA LETTER HO --> KATAKANA LETTER HO
  MAKE_PAIR( 0xFF8F, 0x30DE ),	// HALFWIDTH KATAKANA LETTER MA --> KATAKANA LETTER MA
  MAKE_PAIR( 0xFF90, 0x30DF ),	// HALFWIDTH KATAKANA LETTER MI --> KATAKANA LETTER MI
  MAKE_PAIR( 0xFF91, 0x30E0 ),	// HALFWIDTH KATAKANA LETTER MU --> KATAKANA LETTER MU
  MAKE_PAIR( 0xFF92, 0x30E1 ),	// HALFWIDTH KATAKANA LETTER ME --> KATAKANA LETTER ME
  MAKE_PAIR( 0xFF93, 0x30E2 ),	// HALFWIDTH KATAKANA LETTER MO --> KATAKANA LETTER MO
  MAKE_PAIR( 0xFF94, 0x30E4 ),	// HALFWIDTH KATAKANA LETTER YA --> KATAKANA LETTER YA
  MAKE_PAIR( 0xFF95, 0x30E6 ),	// HALFWIDTH KATAKANA LETTER YU --> KATAKANA LETTER YU
  MAKE_PAIR( 0xFF96, 0x30E8 ),	// HALFWIDTH KATAKANA LETTER YO --> KATAKANA LETTER YO
  MAKE_PAIR( 0xFF97, 0x30E9 ),	// HALFWIDTH KATAKANA LETTER RA --> KATAKANA LETTER RA
  MAKE_PAIR( 0xFF98, 0x30EA ),	// HALFWIDTH KATAKANA LETTER RI --> KATAKANA LETTER RI
  MAKE_PAIR( 0xFF99, 0x30EB ),	// HALFWIDTH KATAKANA LETTER RU --> KATAKANA LETTER RU
  MAKE_PAIR( 0xFF9A, 0x30EC ),	// HALFWIDTH KATAKANA LETTER RE --> KATAKANA LETTER RE
  MAKE_PAIR( 0xFF9B, 0x30ED ),	// HALFWIDTH KATAKANA LETTER RO --> KATAKANA LETTER RO
  MAKE_PAIR( 0xFF9C, 0x30EF ),	// HALFWIDTH KATAKANA LETTER WA --> KATAKANA LETTER WA
  MAKE_PAIR( 0xFF9D, 0x30F3 ),	// HALFWIDTH KATAKANA LETTER N --> KATAKANA LETTER N
  MAKE_PAIR( 0xFF9E, 0x3099 ),	// HALFWIDTH KATAKANA VOICED SOUND MARK --> COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
  MAKE_PAIR( 0xFF9F, 0x309A ),	// HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK --> COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
  MAKE_PAIR( 0xFFA0, 0x3164 ),	// HALFWIDTH HANGUL FILLER --> HANGUL FILLER
  MAKE_PAIR( 0xFFA1, 0x3131 ),	// HALFWIDTH HANGUL LETTER KIYEOK --> HANGUL LETTER KIYEOK
  MAKE_PAIR( 0xFFA2, 0x3132 ),	// HALFWIDTH HANGUL LETTER SSANGKIYEOK --> HANGUL LETTER SSANGKIYEOK
  MAKE_PAIR( 0xFFA3, 0x3133 ),	// HALFWIDTH HANGUL LETTER KIYEOK-SIOS --> HANGUL LETTER KIYEOK-SIOS
  MAKE_PAIR( 0xFFA4, 0x3134 ),	// HALFWIDTH HANGUL LETTER NIEUN --> HANGUL LETTER NIEUN
  MAKE_PAIR( 0xFFA5, 0x3135 ),	// HALFWIDTH HANGUL LETTER NIEUN-CIEUC --> HANGUL LETTER NIEUN-CIEUC
  MAKE_PAIR( 0xFFA6, 0x3136 ),	// HALFWIDTH HANGUL LETTER NIEUN-HIEUH --> HANGUL LETTER NIEUN-HIEUH
  MAKE_PAIR( 0xFFA7, 0x3137 ),	// HALFWIDTH HANGUL LETTER TIKEUT --> HANGUL LETTER TIKEUT
  MAKE_PAIR( 0xFFA8, 0x3138 ),	// HALFWIDTH HANGUL LETTER SSANGTIKEUT --> HANGUL LETTER SSANGTIKEUT
  MAKE_PAIR( 0xFFA9, 0x3139 ),	// HALFWIDTH HANGUL LETTER RIEUL --> HANGUL LETTER RIEUL
  MAKE_PAIR( 0xFFAA, 0x313A ),	// HALFWIDTH HANGUL LETTER RIEUL-KIYEOK --> HANGUL LETTER RIEUL-KIYEOK
  MAKE_PAIR( 0xFFAB, 0x313B ),	// HALFWIDTH HANGUL LETTER RIEUL-MIEUM --> HANGUL LETTER RIEUL-MIEUM
  MAKE_PAIR( 0xFFAC, 0x313C ),	// HALFWIDTH HANGUL LETTER RIEUL-PIEUP --> HANGUL LETTER RIEUL-PIEUP
  MAKE_PAIR( 0xFFAD, 0x313D ),	// HALFWIDTH HANGUL LETTER RIEUL-SIOS --> HANGUL LETTER RIEUL-SIOS
  MAKE_PAIR( 0xFFAE, 0x313E ),	// HALFWIDTH HANGUL LETTER RIEUL-THIEUTH --> HANGUL LETTER RIEUL-THIEUTH
  MAKE_PAIR( 0xFFAF, 0x313F ),	// HALFWIDTH HANGUL LETTER RIEUL-PHIEUPH --> HANGUL LETTER RIEUL-PHIEUPH
  MAKE_PAIR( 0xFFB0, 0x3140 ),	// HALFWIDTH HANGUL LETTER RIEUL-HIEUH --> HANGUL LETTER RIEUL-HIEUH
  MAKE_PAIR( 0xFFB1, 0x3141 ),	// HALFWIDTH HANGUL LETTER MIEUM --> HANGUL LETTER MIEUM
  MAKE_PAIR( 0xFFB2, 0x3142 ),	// HALFWIDTH HANGUL LETTER PIEUP --> HANGUL LETTER PIEUP
  MAKE_PAIR( 0xFFB3, 0x3143 ),	// HALFWIDTH HANGUL LETTER SSANGPIEUP --> HANGUL LETTER SSANGPIEUP
  MAKE_PAIR( 0xFFB4, 0x3144 ),	// HALFWIDTH HANGUL LETTER PIEUP-SIOS --> HANGUL LETTER PIEUP-SIOS
  MAKE_PAIR( 0xFFB5, 0x3145 ),	// HALFWIDTH HANGUL LETTER SIOS --> HANGUL LETTER SIOS
  MAKE_PAIR( 0xFFB6, 0x3146 ),	// HALFWIDTH HANGUL LETTER SSANGSIOS --> HANGUL LETTER SSANGSIOS
  MAKE_PAIR( 0xFFB7, 0x3147 ),	// HALFWIDTH HANGUL LETTER IEUNG --> HANGUL LETTER IEUNG
  MAKE_PAIR( 0xFFB8, 0x3148 ),	// HALFWIDTH HANGUL LETTER CIEUC --> HANGUL LETTER CIEUC
  MAKE_PAIR( 0xFFB9, 0x3149 ),	// HALFWIDTH HANGUL LETTER SSANGCIEUC --> HANGUL LETTER SSANGCIEUC
  MAKE_PAIR( 0xFFBA, 0x314A ),	// HALFWIDTH HANGUL LETTER CHIEUCH --> HANGUL LETTER CHIEUCH
  MAKE_PAIR( 0xFFBB, 0x314B ),	// HALFWIDTH HANGUL LETTER KHIEUKH --> HANGUL LETTER KHIEUKH
  MAKE_PAIR( 0xFFBC, 0x314C ),	// HALFWIDTH HANGUL LETTER THIEUTH --> HANGUL LETTER THIEUTH
  MAKE_PAIR( 0xFFBD, 0x314D ),	// HALFWIDTH HANGUL LETTER PHIEUPH --> HANGUL LETTER PHIEUPH
  MAKE_PAIR( 0xFFBE, 0x314E ),	// HALFWIDTH HANGUL LETTER HIEUH --> HANGUL LETTER HIEUH
  MAKE_PAIR( 0xFFC2, 0x314F ),	// HALFWIDTH HANGUL LETTER A --> HANGUL LETTER A
  MAKE_PAIR( 0xFFC3, 0x3150 ),	// HALFWIDTH HANGUL LETTER AE --> HANGUL LETTER AE
  MAKE_PAIR( 0xFFC4, 0x3151 ),	// HALFWIDTH HANGUL LETTER YA --> HANGUL LETTER YA
  MAKE_PAIR( 0xFFC5, 0x3152 ),	// HALFWIDTH HANGUL LETTER YAE --> HANGUL LETTER YAE
  MAKE_PAIR( 0xFFC6, 0x3153 ),	// HALFWIDTH HANGUL LETTER EO --> HANGUL LETTER EO
  MAKE_PAIR( 0xFFC7, 0x3154 ),	// HALFWIDTH HANGUL LETTER E --> HANGUL LETTER E
  MAKE_PAIR( 0xFFCA, 0x3155 ),	// HALFWIDTH HANGUL LETTER YEO --> HANGUL LETTER YEO
  MAKE_PAIR( 0xFFCB, 0x3156 ),	// HALFWIDTH HANGUL LETTER YE --> HANGUL LETTER YE
  MAKE_PAIR( 0xFFCC, 0x3157 ),	// HALFWIDTH HANGUL LETTER O --> HANGUL LETTER O
  MAKE_PAIR( 0xFFCD, 0x3158 ),	// HALFWIDTH HANGUL LETTER WA --> HANGUL LETTER WA
  MAKE_PAIR( 0xFFCE, 0x3159 ),	// HALFWIDTH HANGUL LETTER WAE --> HANGUL LETTER WAE
  MAKE_PAIR( 0xFFCF, 0x315A ),	// HALFWIDTH HANGUL LETTER OE --> HANGUL LETTER OE
  MAKE_PAIR( 0xFFD2, 0x315B ),	// HALFWIDTH HANGUL LETTER YO --> HANGUL LETTER YO
  MAKE_PAIR( 0xFFD3, 0x315C ),	// HALFWIDTH HANGUL LETTER U --> HANGUL LETTER U
  MAKE_PAIR( 0xFFD4, 0x315D ),	// HALFWIDTH HANGUL LETTER WEO --> HANGUL LETTER WEO
  MAKE_PAIR( 0xFFD5, 0x315E ),	// HALFWIDTH HANGUL LETTER WE --> HANGUL LETTER WE
  MAKE_PAIR( 0xFFD6, 0x315F ),	// HALFWIDTH HANGUL LETTER WI --> HANGUL LETTER WI
  MAKE_PAIR( 0xFFD7, 0x3160 ),	// HALFWIDTH HANGUL LETTER YU --> HANGUL LETTER YU
  MAKE_PAIR( 0xFFDA, 0x3161 ),	// HALFWIDTH HANGUL LETTER EU --> HANGUL LETTER EU
  MAKE_PAIR( 0xFFDB, 0x3162 ),	// HALFWIDTH HANGUL LETTER YI --> HANGUL LETTER YI
  MAKE_PAIR( 0xFFDC, 0x3163 ),	// HALFWIDTH HANGUL LETTER I --> HANGUL LETTER I
  MAKE_PAIR( 0xFFE8, 0x2502 ),	// HALFWIDTH FORMS LIGHT VERTICAL --> BOX DRAWINGS LIGHT VERTICAL
  MAKE_PAIR( 0xFFE9, 0x2190 ),	// HALFWIDTH LEFTWARDS ARROW --> LEFTWARDS ARROW
  MAKE_PAIR( 0xFFEA, 0x2191 ),	// HALFWIDTH UPWARDS ARROW --> UPWARDS ARROW
  MAKE_PAIR( 0xFFEB, 0x2192 ),	// HALFWIDTH RIGHTWARDS ARROW --> RIGHTWARDS ARROW
  MAKE_PAIR( 0xFFEC, 0x2193 ),	// HALFWIDTH DOWNWARDS ARROW --> DOWNWARDS ARROW
  MAKE_PAIR( 0xFFED, 0x25A0 ),	// HALFWIDTH BLACK SQUARE --> BLACK SQUARE
  MAKE_PAIR( 0xFFEE, 0x25CB ) 	// HALFWIDTH WHITE CIRCLE --> WHITE CIRCLE
};

} } } }

#endif
