/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: tempauto.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 03:30:54 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>		// fuers SV_IMPL_OP
#endif
#ifndef _UNOTOOLS_COLLATORWRAPPER_HXX
#include <unotools/collatorwrapper.hxx>
#endif

#ifndef _SWTYPES_HXX
#include <swtypes.hxx>
#endif
#ifndef _TEMPAUTO_HXX
#include <tempauto.hxx>
#endif

SwTempAuto *pTempAuto = NULL;

SV_IMPL_OP_PTRARR_SORT( SwTempList, SwCorrectionPtr )

StringCompare SwCorrection::_Compare( const SwCorrection& rCorr ) const
{
	return (StringCompare)GetAppCollator().compareString( aWrong, rCorr.aWrong );
}


const SwCorrection* SwTempAuto::Replaceable( const String& rCheck ) const
{
	const SwCorrection* pRet = 0;
	if( aList.Count() )
	{
		USHORT nPos;
		SwCorrection aTmp( rCheck );
		if( aList.Seek_Entry( &aTmp, &nPos ) )
			pRet = aList[ nPos ];
	}
	return pRet;
}



void SwTempAuto::Delete( const String& rCheck )
{
	if( aList.Count() )
	{
		USHORT nPos;
		SwCorrection aTmp( rCheck );
		if( aList.Seek_Entry( &aTmp, &nPos ) )
			aList.DeleteAndDestroy( nPos );
	}
}



void SwTempAuto::Insert( SwCorrection* pCorr )
{
	USHORT nPos;
	if( !aList.Insert( pCorr, nPos ) )
	{
		// ist schon vorhanden, also ggfs. das vorhandene ersetzen
		if( pCorr->Correct() != aList[ nPos ]->Correct() )
		{
			if( pCorr->Identical() )
				// den vorhanden loeschen
				aList.DeleteAndDestroy( nPos );
			else
				// den vorhanden ersetzen
				*aList[ nPos ] = *pCorr;
		}
		delete pCorr;
	}
	else if( pCorr->Identical() )
		// dann ist eine unnuetze Ersetzung, also entferne sie gleich wieder
		// kommt aber nicht so oft vor
		aList.DeleteAndDestroy( nPos );
}




