/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: Entry.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:24:06 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
package com.sun.xmlsearch.db;

final class Entry {
  public byte[] key;
  public int    id;
  public int    block = -1;
  
  public Entry(byte[] key, int length, int id) {
    this.key = new byte[length + 1];
    System.arraycopy(key, 0, this.key, 0, length);
    this.key[length] = 0;
    this.id = id;
  }
  
  public byte[] getKey() {
    return key;
  }

  public int getID() {
    return id;
  }

  public boolean smallerThan(Entry other) {
    for (int i = 0; i < Math.min(key.length, other.key.length); i++)
      if (key[i] != other.key[i])
	return (key[i]&0xFF) - (other.key[i]&0xFF) < 0;
    return false;
  }
}
