/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: DataSource.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 13:11:01 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_chart2.hxx"
#include "DataSource.hxx"
#include "CachedDataSequence.hxx"
#include "algohelper.hxx"

#ifndef _COM_SUN_STAR_BEANS_PROPERTYATTRIBUTE_HPP_
#include <com/sun/star/beans/PropertyAttribute.hpp>
#endif

#include <algorithm>

using ::rtl::OUString;
using ::osl::MutexGuard;
using ::com::sun::star::uno::Sequence;
using ::com::sun::star::uno::Reference;
using ::com::sun::star::uno::RuntimeException;
using ::com::sun::star::uno::Any;

using namespace ::com::sun::star;

// necessary for MS compiler
using ::comphelper::OPropertyContainer;
using ::chart::impl::DataSource_Base;

namespace
{
static const ::rtl::OUString lcl_aServiceName(
    RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.comp.chart.DataSource" ));

enum
{
    PROP_SERVER_COMPONENT,
    PROP_SERVER_LOCATOR
};
}  // anonymous namespace

namespace chart
{

DataSource::DataSource( const ::std::vector< uno::Reference< chart2::XDataSequence > > & rSequences )
        : OPropertyContainer( GetBroadcastHelper()),
          DataSource_Base( GetMutex())
{
    registerProperty( C2U( "ServerComponent" ),
                      PROP_SERVER_COMPONENT,
                      beans::PropertyAttribute::READONLY,
                      & m_sServerComponent,
                      ::getCppuType( & m_sServerComponent ) );

    registerProperty( C2U( "ServerLocator" ),
                      PROP_SERVER_LOCATOR,
                      0,   // PropertyAttributes
                      & m_sServerLocator,
                      ::getCppuType( & m_sServerLocator ) );

    m_aData = helper::VectorToSequence( rSequences );
}

DataSource::~DataSource()
{}

// ================================================================================

Sequence< OUString > DataSource::getSupportedServiceNames_Static()
{
    Sequence< OUString > aServices( 2 );
    aServices[ 0 ] = lcl_aServiceName;
    aServices[ 1 ] = C2U( "com.sun.star.chart2.DataSource" );
    return aServices;
}

IMPLEMENT_FORWARD_XINTERFACE2( DataSource, DataSource_Base, OPropertyContainer )
IMPLEMENT_FORWARD_XTYPEPROVIDER2( DataSource, DataSource_Base, OPropertyContainer )

// ____ XPropertySet ____
Reference< beans::XPropertySetInfo > SAL_CALL DataSource::getPropertySetInfo()
    throw(uno::RuntimeException)
{
    return Reference< beans::XPropertySetInfo >( createPropertySetInfo( getInfoHelper() ) );
}

// ____ ::comphelper::OPropertySetHelper ____
// __________________________________________
::cppu::IPropertyArrayHelper& DataSource::getInfoHelper()
{
	return *getArrayHelper();
}

// ____ ::comphelper::OPropertyArrayHelper ____
// ____________________________________________
::cppu::IPropertyArrayHelper* DataSource::createArrayHelper() const
{
	Sequence< beans::Property > aProps;
    // describes all properties which have been registered in the ctor
	describeProperties( aProps );

	return new ::cppu::OPropertyArrayHelper( aProps );
}

// implement XServiceInfo methods basing upon getSupportedServiceNames_Static
APPHELPER_XSERVICEINFO_IMPL( DataSource, lcl_aServiceName )

// ================================================================================

// ____ XDataSource ____
Sequence< Reference< chart2::XDataSequence > > SAL_CALL DataSource::getDataSequences()
    throw (RuntimeException)
{
    return m_aData;
}

} // namespace chart
