/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: Grid.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 13:12:10 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_chart2.hxx"
#include "Grid.hxx"
#include "macros.hxx"
#include "algohelper.hxx"
#include "Increment.hxx"
#include "LineProperties.hxx"
#include "UserDefinedProperties.hxx"
#include "SubGrid.hxx"

#ifndef CHART_PROPERTYHELPER_HXX
#include "PropertyHelper.hxx"
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYATTRIBUTE_HPP_
#include <com/sun/star/beans/PropertyAttribute.hpp>
#endif

#ifndef _COM_SUN_STAR_LAYOUT_ALIGNMENT_HPP_
#include <com/sun/star/layout/Alignment.hpp>
#endif
#ifndef _COM_SUN_STAR_LAYOUT_STRETCHMODE_HPP_
#include <com/sun/star/layout/StretchMode.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_LINESTYLE_HPP_
#include <com/sun/star/drawing/LineStyle.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_LINEDASH_HPP_
#include <com/sun/star/drawing/LineDash.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_LINEJOINT_HPP_
#include <com/sun/star/drawing/LineJoint.hpp>
#endif

#ifndef _RTL_UUID_H_
#include <rtl/uuid.h>
#endif
#ifndef _CPPUHELPER_QUERYINTERFACE_HXX_
#include <cppuhelper/queryinterface.hxx>
#endif

#include <vector>
#include <algorithm>

using namespace ::com::sun::star;
using namespace ::com::sun::star::beans::PropertyAttribute;

using ::com::sun::star::beans::Property;
using ::osl::MutexGuard;

namespace
{

static const ::rtl::OUString lcl_aServiceName(
    RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.comp.chart2.Grid" ));

enum
{
    PROP_GRID_SHOW
};

void lcl_AddPropertiesToVector(
    ::std::vector< Property > & rOutProperties )
{
    rOutProperties.push_back(
        Property( C2U( "Show" ),
                  PROP_GRID_SHOW,
                  ::getBooleanCppuType(),
                  beans::PropertyAttribute::BOUND
                  | beans::PropertyAttribute::MAYBEDEFAULT ));
}

void lcl_AddDefaultsToMap(
    ::chart::helper::tPropertyValueMap & rOutMap )
{
    OSL_ASSERT( rOutMap.end() == rOutMap.find( PROP_GRID_SHOW ));
    rOutMap[ PROP_GRID_SHOW ] =
        uno::makeAny( sal_True );

    // override other defaults
    rOutMap[ ::chart::LineProperties::PROP_LINE_COLOR ] =
        uno::makeAny( sal_Int32( 0xb3b3b3) ); // gray30
}

const uno::Sequence< Property > & lcl_GetPropertySequence()
{
    static uno::Sequence< Property > aPropSeq;

    // /--
    MutexGuard aGuard( ::osl::Mutex::getGlobalMutex() );
    if( 0 == aPropSeq.getLength() )
    {
        // get properties
        ::std::vector< ::com::sun::star::beans::Property > aProperties;
        lcl_AddPropertiesToVector( aProperties );
        ::chart::LineProperties::AddPropertiesToVector(
            aProperties, /* bIncludeStyleProperties = */ true );
        ::chart::UserDefinedProperties::AddPropertiesToVector( aProperties );

        // and sort them for access via bsearch
        ::std::sort( aProperties.begin(), aProperties.end(),
                     ::chart::helper::PropertyNameLess() );

        // transfer result to static Sequence
        aPropSeq = ::chart::helper::VectorToSequence( aProperties );
    }

    return aPropSeq;
}

::cppu::IPropertyArrayHelper & lcl_getInfoHelper()
{
    static ::cppu::OPropertyArrayHelper aArrayHelper(
        lcl_GetPropertySequence(),
        /* bSorted = */ sal_True );

    return aArrayHelper;
}

} // anonymous namespace

// ================================================================================

namespace chart
{

Grid::Grid( uno::Reference< uno::XComponentContext > const & xContext ) :
        ::property::OPropertySet( m_aMutex ),
        m_xContext( xContext ),
        m_nRepresentedDimension( -1 )
{
    m_xIncrement = new Increment();

    if( ! ( xContext->getValueByName( C2U( "Identifier" )) >>= m_aIdentifier ))
    {
        OSL_ENSURE( false, "Missing Grid identifier" );
    }

    AllocateSubGrids();
}

Grid::~Grid()
{}

void Grid::AllocateSubGrids()
{
    if( m_xIncrement.is())
    {
        sal_Int32 nNewSubIncCount = m_xIncrement->getSubIncrements().getLength();
        sal_Int32 nOldSubIncCount = m_aSubGridProperties.getLength();

        if( nOldSubIncCount != nNewSubIncCount )
        {
            // if we have less entries than before, the remaining entries are
            // freed by releasing the reference to them.
            m_aSubGridProperties.realloc( nNewSubIncCount );

            // allocate new entries
            for( sal_Int32 i = nOldSubIncCount; i < nNewSubIncCount; ++i )
            {
                m_aSubGridProperties[ i ] = new SubGrid( GetMutex(), this );
            }
        }
    }
}

// --------------------------------------------------------------------------------

// ____ XGrid ____
uno::Sequence<
        uno::Reference<
        beans::XPropertySet > > SAL_CALL Grid::getSubGridProperties()
    throw (uno::RuntimeException)
{
    return m_aSubGridProperties;
}

// ____ XMeter ____
void SAL_CALL Grid::attachCoordinateSystem(
    const uno::Reference< chart2::XBoundedCoordinateSystem >& xCoordSys,
    sal_Int32 nRepresentedDimension )
    throw (lang::IndexOutOfBoundsException,
           uno::RuntimeException)
{
    // /--
    MutexGuard aGuard( GetMutex());
    if( nRepresentedDimension >= xCoordSys->getDimension())
        throw lang::IndexOutOfBoundsException();

    m_xCoordinateSystem = xCoordSys;
    m_nRepresentedDimension = nRepresentedDimension;
    // \--
}

uno::Reference< chart2::XBoundedCoordinateSystem > SAL_CALL Grid::getCoordinateSystem()
    throw (uno::RuntimeException)
{
    // /--
    MutexGuard aGuard( GetMutex());
    return m_xCoordinateSystem;
    // \--
}

sal_Int32 SAL_CALL Grid::getRepresentedDimension()
    throw (uno::RuntimeException)
{
    // /--
    MutexGuard aGuard( GetMutex());
    return m_nRepresentedDimension;
    // \--
}

void SAL_CALL Grid::setIncrement( const uno::Reference< chart2::XIncrement >& aIncrement )
    throw (uno::RuntimeException)
{
    // /--
    MutexGuard aGuard( GetMutex());
    m_xIncrement = aIncrement;
    AllocateSubGrids();
    // todo: add as listener at XIncrement to get notice if the
    // SubIncrement-Sequence changes and call AllocateSubGrids() in that case
    // \--
}

uno::Reference< chart2::XIncrement > SAL_CALL Grid::getIncrement()
    throw (uno::RuntimeException)
{
    // /--
    MutexGuard aGuard( GetMutex());
    return m_xIncrement;
    // \--
}

// ____ XIdentifiable ____
::rtl::OUString SAL_CALL Grid::getIdentifier()
    throw (uno::RuntimeException)
{
    return m_aIdentifier;
}

// ================================================================================

// ____ OPropertySet ____
uno::Any Grid::GetDefaultValue( sal_Int32 nHandle ) const
    throw(beans::UnknownPropertyException)
{
    static helper::tPropertyValueMap aStaticDefaults;

    // /--
    ::osl::MutexGuard aGuard( ::osl::Mutex::getGlobalMutex() );
    if( 0 == aStaticDefaults.size() )
    {
        // initialize defaults
        LineProperties::AddDefaultsToMap(
            aStaticDefaults,
            /* bIncludeStyleProperties = */ true );

        // overrides a line property
        lcl_AddDefaultsToMap( aStaticDefaults );
    }

    helper::tPropertyValueMap::const_iterator aFound(
        aStaticDefaults.find( nHandle ));

    if( aFound == aStaticDefaults.end())
        return uno::Any();

    return (*aFound).second;
    // \--
}

::cppu::IPropertyArrayHelper & SAL_CALL Grid::getInfoHelper()
{
    return lcl_getInfoHelper();
}


// ____ XPropertySet ____
uno::Reference< beans::XPropertySetInfo > SAL_CALL
    Grid::getPropertySetInfo()
    throw (uno::RuntimeException)
{
    static uno::Reference< beans::XPropertySetInfo > xInfo;

    // /--
    MutexGuard aGuard( ::osl::Mutex::getGlobalMutex() );
    if( !xInfo.is())
    {
        xInfo = ::cppu::OPropertySetHelper::createPropertySetInfo(
            getInfoHelper());
    }

    return xInfo;
    // \--
}

// ================================================================================

uno::Sequence< ::rtl::OUString > Grid::getSupportedServiceNames_Static()
{
    uno::Sequence< ::rtl::OUString > aServices( 2 );
    aServices[ 0 ] = C2U( "com.sun.star.chart2.Grid" );
    aServices[ 1 ] = C2U( "com.sun.star.beans.PropertySet" );
    return aServices;
}

// implement XServiceInfo methods basing upon getSupportedServiceNames_Static
APPHELPER_XSERVICEINFO_IMPL( Grid, lcl_aServiceName );

// needed by MSC compiler
using impl::Grid_Base;

IMPLEMENT_FORWARD_XINTERFACE2( Grid, Grid_Base, OPropertySet )
IMPLEMENT_FORWARD_XTYPEPROVIDER2( Grid, Grid_Base, OPropertySet )

} //  namespace chart
