/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: propertybag.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: hr $ $Date: 2006/10/24 15:14:36 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_dbaccess.hxx"

#ifndef DBACCESS_SOURCE_CORE_MISC_PROPERTYBAG_HXX
#include "propertybag.hxx"
#endif

#ifndef _DBA_REGHELPER_HXX_
#include "dba_reghelper.hxx"
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYATTRIBUTE_HPP_
#include <com/sun/star/beans/PropertyAttribute.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_NAMEDVALUE_HPP_
#include <com/sun/star/beans/NamedValue.hpp>
#endif

#ifndef _OSL_THREAD_H_
#include <osl/thread.h>
#endif

#include <algorithm>
#include <functional>

//--------------------------------------------------------------------------
extern "C" void SAL_CALL createRegistryInfo_OPropertyBag()
{
    static ::dbaccess::OMultiInstanceAutoRegistration< ::dba::OPropertyBag > aAutoRegistration;
}

//........................................................................
namespace dba
{
//........................................................................

    using namespace ::com::sun::star::uno;
    using namespace ::com::sun::star::lang;
    using namespace ::com::sun::star::beans;

	//====================================================================
	//= OPropertyBag
	//====================================================================
    //--------------------------------------------------------------------
    OPropertyBag::OPropertyBag( const Reference< XMultiServiceFactory >& _rxORB )
        :OPropertyBag_CBase( GetBroadcastHelper() )
        ,m_xORB( _rxORB )
        ,m_bArrayHelperDirty( true )
        ,m_bAutoAddProperties( false )
    {
    }

    //--------------------------------------------------------------------
    OPropertyBag::~OPropertyBag()
    {
    }

    //--------------------------------------------------------------------
    IMPLEMENT_FORWARD_XINTERFACE2( OPropertyBag, OPropertyBag_Base, OPropertyBag_CBase )
    IMPLEMENT_FORWARD_XTYPEPROVIDER2( OPropertyBag, OPropertyBag_Base, OPropertyBag_CBase )

    //--------------------------------------------------------------------
	Sequence< ::rtl::OUString > OPropertyBag::getSupportedServiceNames_Static() throw( RuntimeException )
    {
        Sequence< ::rtl::OUString > aServices(1);
        aServices[0] = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.beans.PropertyBag" ) );
        return aServices;
    }

    //--------------------------------------------------------------------
    namespace
    {
        template < typename BAG >
        struct BagInserter : public ::std::unary_function< typename BAG::key_type, void >
        {
            BAG& m_rBag;

            BagInserter( BAG& _rBag )
                :m_rBag( _rBag )
            {
            }

            void operator()( const typename BAG::key_type& _rType )
            {
                m_rBag.insert( _rType );
            }
        };
    }
    //--------------------------------------------------------------------
    void SAL_CALL OPropertyBag::initialize( const Sequence< Any >& _rArguments ) throw (Exception, RuntimeException)
    {
        NamedValue aValue;
        const Any* pArguments = _rArguments.getConstArray();
        const Any* pArgumentsEnd = _rArguments.getConstArray() + _rArguments.getLength();
        for ( ; pArguments != pArgumentsEnd; ++pArguments )
        {
            if ( !( *pArguments >>= aValue ) )
                throw IllegalArgumentException( ::rtl::OUString(), *this, sal::static_int_cast< sal_Int16 >( pArguments - _rArguments.getConstArray() ) );
            if ( aValue.Name.equalsAscii( "AllowedTypes" ) )
            {
                Sequence< Type > aTypes;
                if ( !( aValue.Value >>= aTypes ) )
                    throw IllegalArgumentException( ::rtl::OUString(), *this, sal::static_int_cast< sal_Int16 >( pArguments - _rArguments.getConstArray() ) );

                ::std::for_each( 
                    aTypes.getConstArray(),
                    aTypes.getConstArray() + aTypes.getLength(),
                    BagInserter< TypeBag >( m_aAllowedTypes )
                );
                continue;
            }
            if ( aValue.Name.equalsAscii( "AutomaticAddition" ) )
            {
                if ( !( aValue.Value >>= m_bAutoAddProperties ) )
                    throw IllegalArgumentException( ::rtl::OUString(), *this, sal::static_int_cast< sal_Int16 >( pArguments - _rArguments.getConstArray() ) );
                continue;
            }

#if OSL_DEBUG_LEVEL > 0
            ::rtl::OString sName( aValue.Name.getStr(), aValue.Name.getLength(), osl_getThreadTextEncoding() );
            ::rtl::OString sMessage( "OPropertyBag::initialize: don't know what to do with an argument named '" );
            sMessage += sName;
            sMessage += ::rtl::OString( "'!" );
            OSL_ENSURE( sal_False, sMessage.getStr() );
#endif
        }
    }

    //--------------------------------------------------------------------
	::rtl::OUString OPropertyBag::getImplementationName_Static() throw( RuntimeException )
    {
        return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.comp.comphelper.OPropertyBag" ) );
    }

    //--------------------------------------------------------------------
	Reference< XInterface > SAL_CALL OPropertyBag::Create( const Reference< XMultiServiceFactory >& _rxORB )
    {
        return *new OPropertyBag( _rxORB );
    }

    //--------------------------------------------------------------------
    ::rtl::OUString SAL_CALL OPropertyBag::getImplementationName() throw (RuntimeException)
    {
        return getImplementationName_Static();
    }
    
    //--------------------------------------------------------------------
    ::sal_Bool SAL_CALL OPropertyBag::supportsService( const ::rtl::OUString& rServiceName ) throw (RuntimeException)
    {
        Sequence< ::rtl::OUString > aServices( getSupportedServiceNames_Static() );
        const ::rtl::OUString* pStart = aServices.getConstArray();
        const ::rtl::OUString* pEnd = aServices.getConstArray() + aServices.getLength();
        return ::std::find( pStart, pEnd, rServiceName ) != pEnd;
    }
    
    //--------------------------------------------------------------------
    Sequence< ::rtl::OUString > SAL_CALL OPropertyBag::getSupportedServiceNames(  ) throw (RuntimeException)
    {
        return getSupportedServiceNames_Static();
    }
    
    //--------------------------------------------------------------------
    Reference< XPropertySetInfo > SAL_CALL OPropertyBag::getPropertySetInfo(  ) throw(RuntimeException)
    {
        return createPropertySetInfo( getInfoHelper() );
    }

    //--------------------------------------------------------------------
    ::cppu::IPropertyArrayHelper& SAL_CALL OPropertyBag::getInfoHelper()
    {
        if ( m_bArrayHelperDirty )
        {
            Sequence< Property > aProperties;
            describeProperties( aProperties );
            m_pArrayHelper.reset( new ::cppu::OPropertyArrayHelper( aProperties ) );
            m_bArrayHelperDirty = false;
        }
        return *m_pArrayHelper;
        
    }

    //--------------------------------------------------------------------
    sal_Int32 OPropertyBag::findFreeHandle() const
    {
        const sal_Int32 nPrime = 1009;
        const sal_Int32 nSeed = 11;

        sal_Int32 nCheck = nSeed;
        while ( isRegisteredProperty( nCheck ) && ( nCheck != 1 ) )
        {
            nCheck = ( nCheck * nSeed ) % nPrime;
        }

        if ( nCheck == 1 )
        {   // uh ... we already have 1008 handles used up
            // -> simply count upwards
            while ( isRegisteredProperty( nCheck ) )
                ++nCheck;
        }

        return nCheck;
    }

    //--------------------------------------------------------------------
    void SAL_CALL OPropertyBag::addProperty( const ::rtl::OUString& _rName, ::sal_Int16 _nAttributes, const Any& _rInitialValue ) throw (PropertyExistException, IllegalTypeException, IllegalArgumentException, RuntimeException)
    {
        ::osl::MutexGuard aGuard( m_aMutex );

        //----------------------------------------------
        // check type sanity
        Type aPropertyType = _rInitialValue.getValueType();
        bool bValidType = ( aPropertyType.getTypeClass() != TypeClass_VOID );
        if ( bValidType )
        {
            if ( !m_aAllowedTypes.empty() )
                bValidType = ( m_aAllowedTypes.find( aPropertyType ) != m_aAllowedTypes.end() );
        }
            
        if ( !bValidType )
            throw IllegalTypeException( ::rtl::OUString(), *this );

        //----------------------------------------------
        // check name sanity
        if ( !_rName.getLength() )
            throw IllegalArgumentException( ::rtl::OUString(), *this, 1 );
        if ( isRegisteredProperty( _rName ) )
            throw PropertyExistException( ::rtl::OUString(), *this );

        //----------------------------------------------
        // normalize the REMOVEABLE attribute
        if ( _nAttributes & PropertyAttribute::REMOVABLE )
        {
            _nAttributes |= PropertyAttribute::REMOVEABLE;
            _nAttributes &= ~PropertyAttribute::REMOVABLE;
        }

        //----------------------------------------------
        // find a free handle
        sal_Int32 nHandle = findFreeHandle();

        //----------------------------------------------
        registerPropertyNoMember( _rName, nHandle, _nAttributes, aPropertyType,
            _rInitialValue.hasValue() ? _rInitialValue.getValue() : NULL );
        m_bArrayHelperDirty = true;

        //----------------------------------------------
        // remember the default
        m_aDefaultValues.insert( MapInt2Any::value_type( nHandle, _rInitialValue ) );
    }
    
    //--------------------------------------------------------------------
    void SAL_CALL OPropertyBag::removeProperty( const ::rtl::OUString& _rName ) throw (UnknownPropertyException, NotRemoveableException, RuntimeException)
    {
        ::osl::MutexGuard aGuard( m_aMutex );

        //----------------------------------------------
        const Property& rProp = getProperty( _rName );
            // will throw an UnknownPropertyException if necessary

        //----------------------------------------------
        if ( ( rProp.Attributes & PropertyAttribute::REMOVEABLE ) == 0 )
            throw NotRemoveableException( ::rtl::OUString(), *this );

        //----------------------------------------------
        revokeProperty( rProp.Handle );
        m_bArrayHelperDirty = true;

        //----------------------------------------------
        m_aDefaultValues.erase( rProp.Handle );
    }

    //--------------------------------------------------------------------
    namespace
    {
        struct ComparePropertyValueByName : public ::std::binary_function< PropertyValue, PropertyValue, bool >
        {
            bool operator()( const PropertyValue& _rLHS, const PropertyValue& _rRHS )
            {
                return _rLHS.Name < _rRHS.Name;
            }
        };

        template< typename CLASS >
        struct TransformPropertyToName : public ::std::unary_function< CLASS, ::rtl::OUString >
        {
            const ::rtl::OUString& operator()( const CLASS& _rProp )
            {
                return _rProp.Name;
            }
        };

        struct ExtractPropertyValue : public ::std::unary_function< PropertyValue, Any >
        {
            const Any& operator()( const PropertyValue& _rProp )
            {
                return _rProp.Value;
            }
        };
    }

    //--------------------------------------------------------------------
    Sequence< PropertyValue > SAL_CALL OPropertyBag::getPropertyValues(  ) throw (RuntimeException)
    {
        // all registered properties
        Sequence< Property > aProperties;
        describeProperties( aProperties );

        // their names
        Sequence< ::rtl::OUString > aNames( aProperties.getLength() );
        ::std::transform(
            aProperties.getConstArray(),
            aProperties.getConstArray() + aProperties.getLength(),
            aNames.getArray(),
            TransformPropertyToName< Property >()
        );

        // their values
        Sequence< Any > aValues;
        try
        {
            aValues = OPropertyBag_CBase::getPropertyValues( aNames );
        }
        catch( const Exception& )
        {
        }

        // safety: if something went wrong, go outta here with an empty sequence
        OSL_ENSURE( aValues.getLength() == aNames.getLength(),
            "OPropertyBag::getPropertyValues: inconsistence!" );
        if ( aValues.getLength() != aNames.getLength() )
            return Sequence< PropertyValue >();

        // merge names and values, and retrieve the state/handle
        ::cppu::IPropertyArrayHelper& rPropInfo = getInfoHelper();

        Sequence< PropertyValue > aPropertyValues( aNames.getLength() );
        const ::rtl::OUString* pName = aNames.getConstArray();
        const ::rtl::OUString* pNamesEnd = aNames.getConstArray() + aNames.getLength();
        const Any* pValue = aValues.getArray();
        PropertyValue* pPropertyValue = aPropertyValues.getArray();

        for ( ; pName != pNamesEnd; ++pName, ++pValue, ++pPropertyValue )
        {
            pPropertyValue->Name = *pName;
            pPropertyValue->Handle = rPropInfo.getHandleByName( *pName );
            pPropertyValue->Value = *pValue;
            pPropertyValue->State = getPropertyStateByHandle( pPropertyValue->Handle );
        }

        return aPropertyValues;
    }
    
    //--------------------------------------------------------------------
    void OPropertyBag::implSetPropertyValues( const Sequence< PropertyValue >& _rProps, bool _bTolerateUnknownProperties )
    {
        // sort (the XMultiPropertySet interface requires this)
        Sequence< PropertyValue > aProperties( _rProps );
        ::std::sort(
            aProperties.getArray(),
            aProperties.getArray() + aProperties.getLength(),
            ComparePropertyValueByName()
        );

        bool bDoAddProperties = false;
        try
        {
            // a sequence of names
            Sequence< ::rtl::OUString > aNames( aProperties.getLength() );
            ::std::transform(
                aProperties.getConstArray(),
                aProperties.getConstArray() + aProperties.getLength(),
                aNames.getArray(),
                TransformPropertyToName< PropertyValue >()
            );
            // a sequence of values
            Sequence< Any > aValues( aProperties.getLength() );
            ::std::transform(
                aProperties.getConstArray(),
                aProperties.getConstArray() + aProperties.getLength(),
                aValues.getArray(),
                ExtractPropertyValue()
            );
            // propagate
            // we cannot simply rely on the XMultiPropertySet::setPropertyValues
            // implementation of our base class, since it does not throw
            // an UnknownPropertyException. More precise, XMultiPropertySet::setPropertyValues
            // does not allow to throw this exception, while XPropertyAccess::setPropertyValues
            // requires it
            sal_Int32 nCount = aNames.getLength();
            Sequence< sal_Int32 > aHandles( nCount );
            ::cppu::IPropertyArrayHelper& rPH = getInfoHelper();
            sal_Int32 nHitCount = rPH.fillHandles( aHandles.getArray(), aNames );
            if ( nHitCount != nCount )
                throw UnknownPropertyException( ::rtl::OUString(), *this );

            if( nHitCount > 0 )
                setFastPropertyValues( nCount, aHandles.getArray(),
                    aValues.getConstArray(), nHitCount );
        }
        catch( PropertyVetoException )      { throw; }
        catch( IllegalArgumentException )   { throw; }
        catch( WrappedTargetException )     { throw; }
        catch( RuntimeException )           { throw; }
        catch( UnknownPropertyException )
        {
            if ( !_bTolerateUnknownProperties )
                throw;
            bDoAddProperties = true;
        }
        catch( Exception e )
        {
            throw WrappedTargetException( ::rtl::OUString(), *this, makeAny( e ) );
        }

        if ( bDoAddProperties )
        {
            // we had an UnknownPropertyException, and _bTolerateUnknownProperties tells us
            // we should tolerate this
            // ensure that we contain all properties specified in the sequence
            const PropertyValue* pProperties = aProperties.getConstArray();
            const PropertyValue* pPropertiesEnd = aProperties.getConstArray() + aProperties.getLength();
            for ( ; pProperties != pPropertiesEnd; ++pProperties )
            {
                if  ( !implEnsureContainsProperty( pProperties->Name, pProperties->Value ) )
                {
                    // the property could not be added. In this case, throw the UnknownPropertyException,
                    // which caused us to try this addition
                    throw UnknownPropertyException( ::rtl::OUString(), *this );
                }
            }

            // and try again
            implSetPropertyValues( aProperties, false );
                // use aProperties, this makes the sorting cheaper
                // and don't tolerate any errors this time
        }
    }

    //--------------------------------------------------------------------
    void SAL_CALL OPropertyBag::setPropertyValues( const Sequence< PropertyValue >& _rProps ) throw (UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException, RuntimeException)
    {
        implSetPropertyValues( _rProps, m_bAutoAddProperties );
    }

    //--------------------------------------------------------------------
	bool OPropertyBag::implEnsureContainsProperty( const ::rtl::OUString& _rName, const Any& _rValue )
    {
        if ( isRegisteredProperty( _rName ) )
            // nothing to do
            return true;

        if ( !_rValue.hasValue() )
            // if we cannot determine an initial type, we cannot add this property
            return false;

        try
        {
            sal_Int16 nAttributes = PropertyAttribute::BOUND | PropertyAttribute::REMOVEABLE | PropertyAttribute::MAYBEDEFAULT;
            addProperty( _rName, nAttributes, _rValue );
            return true;
        }
        catch( const IllegalTypeException& e )
        {
            throw WrappedTargetException( ::rtl::OUString(), *this, makeAny( e ) );
        }
        catch( const PropertyExistException& )
        {
        	OSL_ENSURE( sal_False, "OPropertyBag::implEnsureContainsProperty: PropertyExistException - how this?" );
        }
        return false;
    }

    //--------------------------------------------------------------------
	void OPropertyBag::getPropertyDefaultByHandle( sal_Int32 _nHandle, Any& _rDefault ) const
    {
        MapInt2Any::const_iterator aPos = m_aDefaultValues.find( _nHandle );
        OSL_PRECOND( aPos != m_aDefaultValues.end(), "OPropertyBag::getPropertyDefaultByHandle: precondition not met!" );
        _rDefault = aPos->second;
    }

//........................................................................
}   // namespace dba
//........................................................................

