/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: schdrgmt.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: ihi $ $Date: 2006/11/14 14:51:48 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SCH_SCHDRGMT_HXX
#define _SCH_SCHDRGMT_HXX

// header for SdrDragMethod
#ifndef _SVDDRGMT_HXX
#include <svx/svddrgmt.hxx>
#endif

#ifndef _BGFX_VECTOR_B2DVECTOR_HXX
#include <basegfx/vector/b2dvector.hxx>
#endif

class String;

//************************************************************
//   SchDragConstrainedToVector
//************************************************************

class SchDragConstrainedToVector : public SdrDragMethod
{
	::basegfx::B2DVector		aConstraintVector;
	::basegfx::B2DVector		aTranslationVector;
	double						fConstraintVecScalar;
	double						fStartShift;
	double						fRadiusPercent;

public:
	TYPEINFO();
	SchDragConstrainedToVector( SdrDragView& rNewView, ::basegfx::B2DVector aConstraint, double fCurrPercent );

	virtual void TakeComment( String& rStr ) const;
	virtual FASTBOOL Beg();
	virtual void Mov( const Point& rPnt );
	virtual FASTBOOL End( FASTBOOL bCopy );
	virtual FASTBOOL IsMoveOnly() const;
	virtual Pointer GetPointer() const;

	double GetNewPercent() { return fRadiusPercent; }
};

#endif	// _SCH_SCHDRGMT_HXX

