/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: AccAxis.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 19:57:41 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"
#include "AccAxis.hxx"

// for SolarMutex
#ifndef _SV_SVAPP_HXX 
#include <vcl/svapp.hxx>
#endif

#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif

#include "chaxis.hxx"

using ::rtl::OUString;

namespace accessibility
{

Axis::Axis( AccessibleBase * pParent, AxisType eType ) :
        AccessibleChartElement( AccessibleUniqueId( static_cast< sal_uInt16 >( eType ) ),
                                pParent,
                                false /* has no children */,
                                true  /* always transparent */ ),
    m_eType( eType )
{
    ChartModel * pModel = GetChartModel();
    OSL_ASSERT( pModel );

    // /-- solar
    ::vos::OGuard aSolarGuard( Application::GetSolarMutex() );
    SetItemSet( * pModel->GetAxis( static_cast< sal_uInt16 >( eType ) )->GetItemSet() );
    // \-- solar
}

Axis::~Axis()
{}

// OUString SAL_CALL Axis::getAccessibleName()
//     throw (::com::sun::star::uno::RuntimeException)
// {
//     return getToolTipText();
// }

// OUString SAL_CALL Axis::getAccessibleDescription()
//     throw (::com::sun::star::uno::RuntimeException)
// {
// }

OUString SAL_CALL Axis::getImplementationName() 
    throw (::com::sun::star::uno::RuntimeException)
{
    return OUString( RTL_CONSTASCII_USTRINGPARAM( "AccAxis" ));
}

}  // namespace accessibility
