/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: AccDataSeries.cxx,v $
 *
 *  $Revision: 1.17 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 19:58:09 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"
#include "AccDataSeries.hxx"
#include "AccStatisticsObject.hxx"

#ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLESTATETYPE_HPP_
#include <com/sun/star/accessibility/AccessibleStateType.hpp>
#endif

// for SolarMutex
#ifndef _SV_SVAPP_HXX 
#include <vcl/svapp.hxx>
#endif
#ifndef _SVDITER_HXX
#include <svx/svditer.hxx>
#endif
#ifndef _SV_GEN_HXX
#include <tools/gen.hxx>
#endif

#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#ifndef _SCH_SDWINDOW_HXX
#include "chwindow.hxx"
#endif
#ifndef _SCH_OBJID_HXX
#include "objid.hxx"
#endif
#ifndef _SCH_DATAROW_HXX
#include "datarow.hxx"
#endif

#include "schattr.hxx"

using ::rtl::OUString;
using ::com::sun::star::uno::RuntimeException;

using namespace ::com::sun::star;
using namespace ::com::sun::star::accessibility;

namespace accessibility
{

bool lcl_SupportsDataPoints( const SvxChartStyle & rStyle )
{
    switch( rStyle )
    {
        case CHSTYLE_2D_LINE:
        case CHSTYLE_2D_STACKEDLINE:
        case CHSTYLE_2D_PERCENTLINE:
        case CHSTYLE_2D_AREA:
        case CHSTYLE_2D_STACKEDAREA:
        case CHSTYLE_2D_PERCENTAREA:
        case CHSTYLE_3D_STRIPE:
        case CHSTYLE_3D_AREA:
        case CHSTYLE_3D_STACKEDAREA:
        case CHSTYLE_3D_PERCENTAREA:
        case CHSTYLE_2D_NET:
        case CHSTYLE_2D_NET_STACK:
        case CHSTYLE_2D_NET_PERCENT:
        case CHSTYLE_2D_CUBIC_SPLINE:
        case CHSTYLE_2D_B_SPLINE:
        case CHSTYLE_2D_CUBIC_SPLINE_XY:
        case CHSTYLE_2D_B_SPLINE_XY:
        case CHSTYLE_2D_XY_LINE:
            return false;

//         case CHSTYLE_2D_PIE:
//         case CHSTYLE_3D_PIE:
//         case CHSTYLE_2D_PIE_SEGOF1:
//         case CHSTYLE_2D_PIE_SEGOFALL:
        default:
            return true;
    }
}

DataSeries::DataSeries( AccessibleBase * pParent, sal_uInt16 nIndex ) :
        AccessibleChartElement( AccessibleUniqueId( CHOBJID_DIAGRAM_ROWGROUP, nIndex ),
                                pParent,
                                lcl_SupportsDataPoints( pParent->GetChartModel()->ChartStyle()) ),

    m_nIndex( nIndex ),
    m_nEntries( 0 ),
    m_bHasMeanValueLine( false ),
    m_bHasErrorBars( false ),
    m_bHasRegressionCurve( false )
{
    ChartModel * pModel = GetChartModel();
    OSL_ASSERT( pModel );

    // /-- solar
    ::vos::OGuard aSolarGuard( Application::GetSolarMutex() );
    SetItemSet( pModel->GetDataRowAttr( nIndex ) );
    // \-- solar

    if( pModel && pModel->IsDonutChart() )
    {
        RemoveState( AccessibleStateType::SELECTABLE );
        RemoveState( AccessibleStateType::FOCUSABLE );
    }
}

DataSeries::~DataSeries()
{
}

// ________ AccessibleBase::XAccessibleContext ________
OUString SAL_CALL DataSeries::getAccessibleName()
    throw (RuntimeException)
{
    return ( OUString( RTL_CONSTASCII_USTRINGPARAM( "Series " ) ) +
             OUString::valueOf( static_cast< sal_Int32 >( m_nIndex + 1 )) );
}

sal_Int32 SAL_CALL DataSeries::getAccessibleChildCount() 
    throw (RuntimeException)
{
    CheckDisposeState();

    sal_uInt16 nEntries = 0;
    ChartModel * pModel = GetChartModel();

    if( pModel )
    {
        // /-- solar
        ::vos::OGuard aGuard( Application::GetSolarMutex() );
        if( lcl_SupportsDataPoints( pModel->ChartStyle()))
        {
            nEntries = static_cast< sal_uInt16 >( pModel->GetColCount() );
        }
        // \-- solar
    }

    bool bHasErrorBars;
    bool bHasMeanValueLine;
    bool bHasRegressionCurve;
    if( HasStatistics( bHasErrorBars, bHasMeanValueLine, bHasRegressionCurve ) )
    {
        if( bHasErrorBars )
            ++nEntries;
        if( bHasMeanValueLine )
            ++nEntries;
        if( bHasRegressionCurve )
            ++nEntries;
    }

    return nEntries;
}

// ________ XAccessibleComponent ________
awt::Rectangle SAL_CALL DataSeries::getBounds()
    throw (RuntimeException)
{
    CheckDisposeState();
    awt::Point aOffset;

    SdrObject * pObj = GetDrawObject();
    OSL_ASSERT( pObj );

    Rectangle aRect( pObj->GetCurrentBoundRect());
    aRect.Union( GetStatisticsBounds());

    // change into pixel coordinates
    Window * pWin = GetWindow();
    if( pWin != NULL )
    {
        // /-- solar
        ::vos::OGuard aSolarGuard( Application::GetSolarMutex() );
        aRect = pWin->LogicToPixel( aRect );
        // \-- solar
    }

    // SdrObject::GetBoundRect() ist relative to the page, but we need a value
    // relative to the parent object
    awt::Point aParentLocOnScreen;
    uno::Reference< XAccessible > xParent( getAccessibleParent());
    if( xParent.is())
    {
        uno::Reference< XAccessibleComponent > xParentComp( xParent->getAccessibleContext(), uno::UNO_QUERY );
        if( xParentComp.is() )
            aParentLocOnScreen = xParentComp->getLocationOnScreen();
    }

    // aOffset = aParentLocOnScreen - GetUpperLeftOnScreen()
    awt::Point aULOnScreen = GetUpperLeftOnScreen();
    aOffset.X = aParentLocOnScreen.X - aULOnScreen.X;
    aOffset.Y = aParentLocOnScreen.Y - aULOnScreen.Y;

    return awt::Rectangle( aRect.Left() - aOffset.X, aRect.Top() - aOffset.Y,
                           aRect.GetWidth(), aRect.GetHeight());
}

// ________ XAccessibleExtendedComponent ________
OUString SAL_CALL DataSeries::getToolTipText()
    throw (RuntimeException)
{
    CheckDisposeState();

    ChartModel* pModel = NULL;
    SchWindow * pWin   = NULL;
    sal_uInt16 nIndex = 0;
    
    {
        // /--
        ::osl::MutexGuard aGuard( GetMutex());

        pModel = GetChartModel();
        pWin = GetWindow();
        nIndex = m_nIndex;
        // \--
    }
    
    if( pModel != NULL &&
        pWin != NULL )
    {
        // /-- solar
        ::vos::OGuard aGuard( Application::GetSolarMutex() );
        return OUString( pWin->GetQuickHelpText( CHOBJID_DIAGRAM_ROWGROUP, pModel, TRUE, nIndex ));
        // \-- solar
    }
    else
        return OUString();
}

// ________ XServiceInfo ________
OUString SAL_CALL DataSeries::getImplementationName() 
    throw (RuntimeException)
{
    return OUString( RTL_CONSTASCII_USTRINGPARAM( "AccDataSeries" ));
}

// ____________ protected ____________
bool DataSeries::UpdateChildren()
{
    ChartModel * pModel = GetChartModel();

    sal_uInt16 nEntries = 0;
    
    if( pModel != NULL )
    {
        // /-- solar
        ::vos::OGuard aGuard( Application::GetSolarMutex() );
        nEntries = static_cast< sal_uInt16 >( pModel->GetColCount() );
        // \-- solar
    }

    sal_uInt16 nMemberEntries = 0;
    bool       bMemberHasErrorBars = false;
    bool       bMemberHasMeanValueLine = false;
    bool       bMemberHasRegressionCurve = false;    
    {
        // /--
        ::osl::MutexGuard aGuard( GetMutex());
        nMemberEntries = m_nEntries;

        bMemberHasErrorBars = m_bHasErrorBars;
        bMemberHasMeanValueLine = m_bHasMeanValueLine;
        bMemberHasRegressionCurve = m_bHasRegressionCurve;
        // \--
    }
    
    // statistics
    bool bHasErrorBars;
    bool bHasMeanValueLine;
    bool bHasRegressionCurve;
    HasStatistics( bHasErrorBars, bHasMeanValueLine, bHasRegressionCurve );

    bHasErrorBars        = UpdateChild(
        AccessibleUniqueId( StatisticsObject::ERROR_BARS, m_nIndex ),
        bMemberHasErrorBars,
        bHasErrorBars );
    bHasMeanValueLine    = UpdateChild(
        AccessibleUniqueId( StatisticsObject::MEAN_VAL_LINE, m_nIndex ),
        bMemberHasMeanValueLine,
        bHasMeanValueLine );
    bHasRegressionCurve  = UpdateChild(
        AccessibleUniqueId( StatisticsObject::REGRESSION, m_nIndex ),
        bMemberHasRegressionCurve,
        bHasRegressionCurve );

    sal_uInt16 nDataPointNum = 0;

    // remove data points
    for( nDataPointNum = nEntries; nDataPointNum < nMemberEntries; ++nDataPointNum )
    {
        // note m_nIndex is const
        UpdateChild( AccessibleUniqueId( CHOBJID_DIAGRAM_DATA, m_nIndex, nDataPointNum ),
                     true, false );
    }

    // add data points
    for( nDataPointNum = nMemberEntries; nDataPointNum < nEntries; ++nDataPointNum )
    {
        // note m_nIndex is const
        UpdateChild( AccessibleUniqueId( CHOBJID_DIAGRAM_DATA, m_nIndex, nDataPointNum ),
                     false, true );
    }

    // /--
    ::osl::MutexGuard aGuard( GetMutex());
    m_nEntries = nEntries;

    m_bHasMeanValueLine   = bHasMeanValueLine;
    m_bHasErrorBars       = bHasErrorBars;
    m_bHasRegressionCurve = bHasRegressionCurve;

    return true;
    // \--
}

SdrObject * DataSeries::GetDrawObject() const
{
    return ImplGetDrawObject( CHOBJID_DIAGRAM_ROWGROUP );
}

Rectangle DataSeries::GetStatisticsBounds() const
{
    Rectangle aResult;
    SdrObject * pObj = NULL;

    bool bError, bMean, bRegr;
    HasStatistics( bError, bMean, bRegr );

    if( bError )
    {
        pObj = ImplGetDrawObject( CHOBJID_DIAGRAM_STATISTICS_GROUP );
        if( pObj )
            aResult.Union( pObj->GetCurrentBoundRect());
    }

    if( bMean )
    {
        pObj = ImplGetDrawObject( CHOBJID_DIAGRAM_AVERAGEVALUE );
        if( pObj )
            aResult.Union( pObj->GetCurrentBoundRect());
    }

    if( bRegr )
    {
        pObj = ImplGetDrawObject( CHOBJID_DIAGRAM_REGRESSION );
        if( pObj )
            aResult.Union( pObj->GetCurrentBoundRect());
    }

    return aResult;
}

SdrObject * DataSeries::ImplGetDrawObject( UINT16 nObjId ) const
{
    SdrObject * pShape = NULL;
    SdrObject * pResult = NULL;

    ChartModel * pModel = GetChartModel();
    if( pModel != NULL )
    {
        // /-- solar
        ::vos::OGuard aGuard( Application::GetSolarMutex());
        // the diagram is treated as series for donut charts, because there
        // exist no groups for series in these.
        bool bNoSeries = ( pModel->IsPieChart() || pModel->IsDonutChart());
        const SdrObjList & rObjList = *(pModel->GetPage( 0 ));

        // first search the diagram
        SdrObjListIter aIterator( rObjList, IM_FLAT );
        while( aIterator.IsMore())
        {
            pShape = aIterator.Next();
            if( pShape->IsGroupObject())
            {
                if( GetObjectIdNum( *pShape ) == CHOBJID_DIAGRAM )
                {
                    if( bNoSeries && nObjId == CHOBJID_DIAGRAM_ROWGROUP )
                    {
                        // for a pie chart the diagram is treated as only series
                        pResult = pShape;
                        break;
                    }
                    // search in diagram
                    SdrObjListIter aIter2( *(pShape->GetSubList()), IM_FLAT );
                    while( aIter2.IsMore())
                    {
                        pShape = aIter2.Next();
                        if( GetObjectIdNum( *pShape ) == nObjId )
                        {
                            SchDataRow *pDataRow = GetDataRow( *pShape );
                            if( pDataRow &&
                                pDataRow->GetRow() == m_nIndex )
                            {
                                pResult = pShape;
                                break;
                            }
                        }
                    }
                }
            }
        }
        // \-- solar
    }

    return pResult;
}

// ____________ private ____________
bool DataSeries::HasStatistics(
    bool & rOutHasErrorBars,
    bool & rOutHasMeanValueLine,
    bool & rOutHasRegressionCurve ) const
{
    const SfxItemSet * pItemSet = GetItemSet();
    OSL_ENSURE( pItemSet, "ItemSet has not been set for series" );
    const SfxPoolItem * pItem = NULL;

    rOutHasErrorBars       = ( ( pItemSet->GetItemState( SCHATTR_STAT_KIND_ERROR, FALSE, & pItem ) == SFX_ITEM_SET )
                               && ( static_cast< const SfxInt32Item * >( pItem )->GetValue() != CHERROR_NONE ));
    rOutHasMeanValueLine   = ( ( pItemSet->GetItemState( SCHATTR_STAT_AVERAGE, FALSE, & pItem ) == SFX_ITEM_SET )
                               && ( static_cast< const SfxBoolItem * >( pItem )->GetValue() ));
    rOutHasRegressionCurve = ( ( pItemSet->GetItemState( SCHATTR_STAT_REGRESSTYPE, FALSE, & pItem ) == SFX_ITEM_SET )
                               && ( static_cast< const SfxInt32Item * >( pItem )->GetValue() != CHREGRESS_NONE ));

    return ( rOutHasErrorBars || rOutHasMeanValueLine || rOutHasRegressionCurve );
}

}  // namespace accessibility
