/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: globopt.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 20:01:46 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"
#include "globopt.hxx"

#include <stdio.h>

#ifndef INCLUDED_SVTOOLS_SYSLOCALE_HXX
#include <svtools/syslocale.hxx>
#endif
#ifndef _UTL_CONFIGITEM_HXX_
#include <unotools/configitem.hxx>
#endif

// ================================================================================

namespace
{

bool IsMetric()
{
    SvtSysLocale aSysLocale;
    const LocaleDataWrapper* pLocWrapper = aSysLocale.GetLocaleDataPtr();
    MeasurementSystem eSys = pLocWrapper->getMeasurementSystemEnum();

    return ( eSys == MEASURE_METRIC );
}

// ----------------------------------------

class CalcConfigItem : public ::utl::ConfigItem
{
public:
    CalcConfigItem() :
            ConfigItem( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "Office.Calc/Layout" )))
    {}

    FieldUnit GetMeasureUnit();
};

FieldUnit CalcConfigItem::GetMeasureUnit()
{
    FieldUnit eResult( FUNIT_CM );

    ::com::sun::star::uno::Sequence< ::rtl::OUString > aNames( 1 );
    if( IsMetric() )
        aNames[ 0 ] = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "Other/MeasureUnit/Metric" ));
    else
        aNames[ 0 ] = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "Other/MeasureUnit/NonMetric" ));

    ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Any > aResult(
        GetProperties( aNames ));

    if( aResult[ 0 ].hasValue() )
    {
        sal_Int32 nValue;
        aResult[ 0 ] >>= nValue;
        eResult = static_cast< FieldUnit >( nValue );
    }

    return eResult;
}


}  // anonymous namespace

// ================================================================================

namespace sch
{

namespace util
{

FieldUnit GetMeasureUnit()
{
    static CalcConfigItem aCfgItem;
    FieldUnit aUnit( aCfgItem.GetMeasureUnit() );

    return aCfgItem.GetMeasureUnit();
}
 
}  // namespace util
}  // namespace sch
