/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sdpage.cxx,v $
 *
 *  $Revision: 1.58 $
 *
 *  last change: $Author: kz $ $Date: 2006/12/12 16:33:13 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sd.hxx"

#include <algorithm>

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#include "eetext.hxx"       // definiert ITEMID_... fuer frmitems und textitem
#ifndef _EEITEM_HXX //autogen
#include <svx/eeitem.hxx>
#endif
#ifndef _SVDOUTL_HXX //autogen
#include <svx/svdoutl.hxx>
#endif
#include <svx/editdata.hxx>
#include <svx/pageitem.hxx>
#include <svx/lrspitem.hxx>
#include <svx/bulitem.hxx>
#include <svx/xoutx.hxx>
#ifndef _SVDPAGV_HXX //autogen
#include <svx/svdpagv.hxx>
#endif
#ifndef _SVX_FHGTITEM_HXX //autogen
#include <svx/fhgtitem.hxx>
#endif
#ifndef _OUTLOBJ_HXX //autogen
#include <svx/outlobj.hxx>
#endif
#ifndef _SVDOOLE2_HXX //autogen
#include <svx/svdoole2.hxx>
#endif
#ifndef _SVDOGRAF_HXX //autogen
#include <svx/svdograf.hxx>
#endif
#ifndef _SVDOPAGE_HXX //autogen
#include <svx/svdopage.hxx>
#endif
#ifndef _SVDOPAGE_HXX //autogen
#include <svx/svdopage.hxx>
#endif
#ifndef _SFX_PRINTER_HXX //autogen
#include <sfx2/printer.hxx>
#endif
#ifndef _BASMGR_HXX //autogen
#include <basic/basmgr.hxx>
#endif
#ifndef _SVX_PBINITEM_HXX //autogen
#include <svx/pbinitem.hxx>
#endif
#ifndef _SVDUNDO_HXX //autogen
#include <svx/svdundo.hxx>
#endif
#ifndef _SFXSMPLHINT_HXX //autogen
#include <svtools/smplhint.hxx>
#endif
#ifndef _SVX_ADJITEM_HXX
#include <svx/adjitem.hxx>
#endif
#ifndef _EDITOBJ_HXX
#include <svx/editobj.hxx>
#endif
#ifndef _SVX_SRIPTTYPEITEM_HXX
#include <svx/scripttypeitem.hxx>
#endif
#ifndef _SVX_UNOWPAGE_HXX
#include <svx/unopage.hxx>
#endif

#ifndef _SVX_FLDITEM_HXX
#define ITEMID_FIELD    EE_FEATURE_FIELD
#include <svx/flditem.hxx>
#endif

#ifndef _SDR_CONTACT_DISPLAYINFO_HXX
#include <svx/sdr/contact/displayinfo.hxx>
#endif

#define ITEMID_ADJUST EE_PARA_JUST
#include <svx/adjitem.hxx>


#ifndef SD_DRAW_DOC_SHELL_HXX
#ifdef MAC
#include "::ui:inc:DrawDocShell.hxx"
#else
#ifdef UNX
#include "../ui/inc/DrawDocShell.hxx"
#else
#include "..\ui\inc\DrawDocShell.hxx"
#endif
#endif
#endif

#ifndef SD_OUTLINER_HXX
#include "Outliner.hxx"
#endif

#include "misc.hxx"
#include "eetext.hxx"
#include "drawdoc.hxx"
#include "sdpage.hxx"
#include "pglink.hxx"
#include "sdresid.hxx"
#include "stlsheet.hxx"
#include "glob.hrc"
#include "glob.hxx"
#include "helpids.h"
#include "anminfo.hxx"
#include "undo/undomanager.hxx"
#include "undo/undoobjects.hxx"

#ifndef _SDR_CONTACT_DISPLAYINFO_HXX
#include <svx/sdr/contact/displayinfo.hxx>
#endif

#ifndef _SDR_CONTACT_VIEWOBJECTCONTACT_HXX
#include <svx/sdr/contact/viewobjectcontact.hxx>
#endif

#ifndef _SDR_CONTACT_VIEWCONTACT_HXX
#include <svx/sdr/contact/viewcontact.hxx>
#endif

#include <set>

using namespace ::sd;
using namespace ::com::sun::star;

TYPEINIT2( SdPage, FmFormPage, SdrObjUserCall );

/*************************************************************************
|*
|*		Ctor
|*
\************************************************************************/

SdPage::SdPage(SdDrawDocument& rNewDoc, StarBASIC* pBasic, BOOL bMasterPage)
:	FmFormPage(rNewDoc, pBasic, bMasterPage)
,	SdrObjUserCall()
,	mePageKind(PK_STANDARD)
,	meAutoLayout(AUTOLAYOUT_NONE)
,	mbSelected(FALSE)
,	mePresChange(PRESCHANGE_MANUAL)
,	mnTime(1)
,	mbSoundOn(FALSE)
,	mbExcluded(FALSE)
,	mbScaleObjects(TRUE)
,	mbBackgroundFullSize( FALSE )
,	meCharSet(gsl_getSystemTextEncoding())
,	mnPaperBin(PAPERBIN_PRINTER_SETTINGS)
,	mpPageLink(NULL)
,	mpItems(NULL)
,	mnTransitionType(0)
,	mnTransitionSubtype(0)
,	mbTransitionDirection(sal_True)
,	mnTransitionFadeColor(0)
,	mfTransitionDuration(2.0)
{
	// Der Layoutname der Seite wird von SVDRAW benutzt, um die Praesentations-
	// vorlagen der Gliederungsobjekte zu ermitteln. Darum enthaelt er bereits
	// den Bezeichner fuer die Gliederung (STR_LAYOUT_OUTLINE).
	maLayoutName  = String(SdResId(STR_LAYOUT_DEFAULT_NAME));
	maLayoutName.AppendAscii( RTL_CONSTASCII_STRINGPARAM( SD_LT_SEPARATOR ));
	maLayoutName += String(SdResId(STR_LAYOUT_OUTLINE));

	Size aPageSize(GetSize());

	if (aPageSize.Width() > aPageSize.Height())
	{
		meOrientation = ORIENTATION_LANDSCAPE;
	}
	else
	{
		meOrientation = ORIENTATION_PORTRAIT;
	}
}

/*************************************************************************
|*
|* Dtor
|*
\************************************************************************/

SdPage::~SdPage()
{
	DisconnectLink();

	EndListenOutlineText();

	if( mpItems )
		delete mpItems;
}

/** returns the nIndex'th object from the given PresObjKind, index starts with 1 */
SdrObject* SdPage::GetPresObj(PresObjKind eObjKind, int nIndex )
{
	int nObjFound = 0;          // index of the searched object
	SdrObject* pObj = 0;
	while( (pObj = maPresentationShapeList.getNextShape(pObj)) != 0 )
	{
		SdAnimationInfo* pInfo = SdDrawDocument::GetShapeUserData(*pObj);
		if( pInfo && (pInfo->mePresObjKind == eObjKind) )
		{
			nObjFound++;	// found one
			if( nObjFound == nIndex )
				return pObj;
		}
	}

	return 0;
}

/** creates a presentation object with the given PresObjKind on this page. A user call will be set
*/
SdrObject* SdPage::CreatePresObj(PresObjKind eObjKind, BOOL bVertical, const Rectangle& rRect, BOOL /* bInsert */ )
{
	sd::UndoManager* pUndoManager = pModel ? static_cast<SdDrawDocument*>(pModel)->GetUndoManager() : 0;
	const bool bUndo = pUndoManager && pUndoManager->isInListAction() && IsInserted();

	SdrObject* pSdrObj = NULL;

	bool bForceText = false;	// forces the shape text to be set even if its empty
	bool bEmptyPresObj = true;

	switch( eObjKind )
	{
		case PRESOBJ_TITLE:
		{
			pSdrObj = new SdrRectObj(OBJ_TITLETEXT);

			if (bMaster)
			{
				pSdrObj->SetNotVisibleAsMaster(TRUE);
			}
		}
		break;

		case PRESOBJ_OUTLINE:
		{
			pSdrObj = new SdrRectObj(OBJ_OUTLINETEXT);

			if (bMaster)
			{
				pSdrObj->SetNotVisibleAsMaster(TRUE);
			}
		}
		break;

		case PRESOBJ_NOTES:
		{
			pSdrObj = new SdrRectObj(OBJ_TEXT);

			if (bMaster)
			{
				pSdrObj->SetNotVisibleAsMaster(TRUE);
			}
		}
		break;

		case PRESOBJ_TEXT:
		{
			pSdrObj = new SdrRectObj(OBJ_TEXT);
		}
		break;

		case PRESOBJ_GRAPHIC:
		{
			BitmapEx aBmpEx( SdResId( BMP_PRESOBJ_GRAPHIC ) );
			Graphic  aGraphic( aBmpEx );
			OutputDevice &aOutDev = *Application::GetDefaultDevice();
			aOutDev.Push();

			aOutDev.SetMapMode( aGraphic.GetPrefMapMode() );
			Size aSizePix = aOutDev.LogicToPixel( aGraphic.GetPrefSize() );
			aOutDev.SetMapMode(MAP_100TH_MM);

			Size aSize = aOutDev.PixelToLogic(aSizePix);
			Point aPnt (0, 0);
			Rectangle aRect (aPnt, aSize);
			pSdrObj = new SdrGrafObj(aGraphic, aRect);
			aOutDev.Pop();
		}
		break;

		case PRESOBJ_OBJECT:
		{
			pSdrObj = new SdrOle2Obj();
			BitmapEx aBmpEx( SdResId( BMP_PRESOBJ_OBJECT ) );
			Graphic aGraphic( aBmpEx );
			( (SdrOle2Obj*) pSdrObj)->SetGraphic(&aGraphic);
		}
		break;

		case PRESOBJ_CHART:
		{
			pSdrObj = new SdrOle2Obj();
			( (SdrOle2Obj*) pSdrObj)->SetProgName( String( RTL_CONSTASCII_USTRINGPARAM( "StarChart" )));
			BitmapEx aBmpEx( SdResId( BMP_PRESOBJ_CHART ) );
			Graphic aGraphic( aBmpEx );
			( (SdrOle2Obj*) pSdrObj)->SetGraphic(&aGraphic);
		}
		break;

		case PRESOBJ_ORGCHART:
		{
			pSdrObj = new SdrOle2Obj();
			( (SdrOle2Obj*) pSdrObj)->SetProgName( String( RTL_CONSTASCII_USTRINGPARAM( "StarOrg" )));
			BitmapEx aBmpEx( SdResId( BMP_PRESOBJ_ORGCHART ) );
			Graphic aGraphic( aBmpEx );
			( (SdrOle2Obj*) pSdrObj)->SetGraphic(&aGraphic);
		}

		case PRESOBJ_TABLE:
		{
			pSdrObj = new SdrOle2Obj();
			( (SdrOle2Obj*) pSdrObj)->SetProgName( String( RTL_CONSTASCII_USTRINGPARAM( "StarCalc" )));
			BitmapEx aBmpEx( SdResId( BMP_PRESOBJ_TABLE ) );
			Graphic aGraphic( aBmpEx );
			( (SdrOle2Obj*) pSdrObj)->SetGraphic(&aGraphic);
		}
		break;

		case PRESOBJ_BACKGROUND:
		{
			pSdrObj = new SdrRectObj();
			pSdrObj->SetMoveProtect(TRUE);
			pSdrObj->SetResizeProtect(TRUE);
			pSdrObj->SetMarkProtect(TRUE);
		}
		break;

		case PRESOBJ_HANDOUT:
		{
			//Erste Standardseite am SdrPageObj vermerken
			SdrPage* pFirstPage = ( (SdDrawDocument*) pModel )->GetSdPage(0, PK_STANDARD);
			pSdrObj = new SdrPageObj( pFirstPage );
			pSdrObj->SetResizeProtect(TRUE);
		}
		break;

		case PRESOBJ_PAGE:
		{
			//Notizseite am SdrPageObj vermerken
			sal_uInt16 nDestPageNum(GetPageNum());

			if(nDestPageNum)
			{
				// decrement only when != 0, else we get a 0xffff
				nDestPageNum -= 1;
			}

			if(nDestPageNum < pModel->GetPageCount())
			{
				pSdrObj = new SdrPageObj(pModel->GetPage(nDestPageNum));
			}
			else
			{
				pSdrObj = new SdrPageObj();
			}

			pSdrObj->SetResizeProtect(TRUE);
		}
		break;

		case PRESOBJ_HEADER:
		case PRESOBJ_FOOTER:
		case PRESOBJ_DATETIME:
		case PRESOBJ_SLIDENUMBER:
		{
			pSdrObj = new SdrRectObj(OBJ_TEXT);
			bEmptyPresObj = false;
			bForceText = true;
		}
		break;
		default:
			break;
	}

	if (pSdrObj)
	{
		pSdrObj->SetEmptyPresObj(bEmptyPresObj);
		pSdrObj->SetLogicRect(rRect);	
		
		InsertObject(pSdrObj);

		if ( pSdrObj->ISA(SdrTextObj) )
		{
			// #96243# Tell the object EARLY that it is vertical to have the
			// defaults for AutoGrowWidth/Height reversed
			if(bVertical)
				((SdrTextObj*)pSdrObj)->SetVerticalWriting(TRUE);

			SfxItemSet aTempAttr( ((SdDrawDocument*) pModel)->GetPool() );
			if( bVertical )
				aTempAttr.Put( SdrTextMinFrameWidthItem( rRect.GetSize().Width() ) );
			else
				aTempAttr.Put( SdrTextMinFrameHeightItem( rRect.GetSize().Height() ) );

			if (bMaster)
			{
				// Bei Praesentationsobjekten auf der MasterPage soll die
				// Groesse vom Benutzwer frei waehlbar sein

				// #96243# potential problem: This action was still NOT
				// adapted for vertical text. This sure needs to be done.
				if(bVertical)
					aTempAttr.Put(SdrTextAutoGrowWidthItem(FALSE));
				else
					aTempAttr.Put(SdrTextAutoGrowHeightItem(FALSE));
			}

			// check if we need another vertical adjustement than the default
			SdrTextVertAdjust eV = SDRTEXTVERTADJUST_TOP;

			if( (eObjKind == PRESOBJ_FOOTER) && (mePageKind != PK_STANDARD) )
			{
				eV = SDRTEXTVERTADJUST_BOTTOM;
			}
			else if( (eObjKind == PRESOBJ_SLIDENUMBER) && (mePageKind != PK_STANDARD) )
			{
				eV = SDRTEXTVERTADJUST_BOTTOM;
			}

			if( eV != SDRTEXTVERTADJUST_TOP )
				aTempAttr.Put(SdrTextVertAdjustItem(eV));

			pSdrObj->SetMergedItemSet(aTempAttr);

			pSdrObj->SetLogicRect(rRect);	
		}

		String aString = GetPresObjText(eObjKind);
		if( (aString.Len() || bForceText) && pSdrObj->ISA(SdrTextObj) )
		{
			SdrOutliner* pOutliner = ( (SdDrawDocument*) GetModel() )->GetInternalOutliner();

			USHORT nOutlMode = pOutliner->GetMode();
			pOutliner->Init( OUTLINERMODE_TEXTOBJECT );
			pOutliner->SetMinDepth(0);
			pOutliner->SetStyleSheet( 0, NULL );
			pOutliner->SetVertical( bVertical );

			String aEmptyStr;
			SetObjText( (SdrTextObj*) pSdrObj, (SdrOutliner*)pOutliner, eObjKind, aString );

			pOutliner->Init( nOutlMode );
			pOutliner->SetStyleSheet( 0, NULL );
		}

		if( (eObjKind == PRESOBJ_HEADER) || (eObjKind == PRESOBJ_FOOTER) || (eObjKind == PRESOBJ_SLIDENUMBER) || (eObjKind == PRESOBJ_DATETIME) )
		{
			SfxItemSet aTempAttr( ((SdDrawDocument*) pModel)->GetPool() );
			aTempAttr.Put( SvxFontHeightItem( 493, 100, EE_CHAR_FONTHEIGHT ) );
			aTempAttr.Put( SvxFontHeightItem( 493, 100, EE_CHAR_FONTHEIGHT_CTL ) );
			aTempAttr.Put( SvxFontHeightItem( 493, 100, EE_CHAR_FONTHEIGHT_CJK ) );

			SvxAdjust eH = SVX_ADJUST_LEFT;

			if( (eObjKind == PRESOBJ_DATETIME) && (mePageKind != PK_STANDARD ) )
			{
				eH = SVX_ADJUST_RIGHT;
			}
			else if( (eObjKind == PRESOBJ_FOOTER) && (mePageKind == PK_STANDARD ) )
			{
				eH = SVX_ADJUST_CENTER;
			}
			else if( eObjKind == PRESOBJ_SLIDENUMBER )
			{
				eH = SVX_ADJUST_RIGHT;
			}

			if( eH != SVX_ADJUST_LEFT )
				aTempAttr.Put(SvxAdjustItem(eH));

			pSdrObj->SetMergedItemSet(aTempAttr);
		}

		if (bMaster)
		{
			SdrLayerAdmin& rLayerAdmin = pModel->GetLayerAdmin();

			if (eObjKind == PRESOBJ_BACKGROUND)
			{
				// Hintergrund der MasterPage
				pSdrObj->SetLayer( rLayerAdmin.
					GetLayerID(String(SdResId(STR_LAYER_BCKGRND)), FALSE) );
			}
			else
			{
				// Hintergrundobjekte der MasterPage
				pSdrObj->SetLayer( rLayerAdmin.
					GetLayerID(String(SdResId(STR_LAYER_BCKGRNDOBJ)), FALSE) );
			}
		}

		// Objekt am StyleSheet anmelden
		// #95114# Set style only when one was found (as in 5.2)
		// pSdrObj->NbcSetStyleSheet( GetStyleSheetForPresObj(eObjKind), FALSE );
		if( mePageKind != PK_HANDOUT )
		{
			SfxStyleSheet* pSheetForPresObj = GetStyleSheetForPresObj(eObjKind);
			if(pSheetForPresObj)
				pSdrObj->SetStyleSheet(pSheetForPresObj, FALSE);
		}

		if (eObjKind == PRESOBJ_OUTLINE)
		{
			for (USHORT nLevel = 1; nLevel < 10; nLevel++)
			{
				String aName(maLayoutName);
				aName += sal_Unicode( ' ' );
				aName += String::CreateFromInt32( nLevel );
				SfxStyleSheet* pSheet = (SfxStyleSheet*)pModel->GetStyleSheetPool()->
							Find(aName, SD_LT_FAMILY);
				DBG_ASSERT(pSheet, "Vorlage fuer Gliederungsobjekt nicht gefunden");
				if (pSheet)
					pSdrObj->StartListening(*pSheet);
			}
		}

		if ( eObjKind == PRESOBJ_OBJECT   ||
			 eObjKind == PRESOBJ_CHART    ||
			 eObjKind == PRESOBJ_ORGCHART ||
			 eObjKind == PRESOBJ_TABLE    ||
			 eObjKind == PRESOBJ_GRAPHIC )
		{
			SfxItemSet aSet( ((SdDrawDocument*) pModel)->GetPool() );
			aSet.Put( SdrTextContourFrameItem( TRUE ) );
			aSet.Put( SvxAdjustItem( SVX_ADJUST_CENTER ) );

			pSdrObj->SetMergedItemSet(aSet);
		}

		if( bUndo )
		{
			pUndoManager->AddUndoAction(pModel->GetSdrUndoFactory().CreateUndoNewObject(*pSdrObj));
		}

		if( bUndo )
		{
			pUndoManager->AddUndoAction( new UndoObjectPresentationKind( *pSdrObj ) );
			pUndoManager->AddUndoAction( new UndoObjectUserCall(*pSdrObj) );
		}

		InsertPresObj(pSdrObj, eObjKind);
		pSdrObj->SetUserCall(this);

		pSdrObj->RecalcBoundRect();
	}

	return(pSdrObj);
}

/*************************************************************************
|*
|* Es werden Praesentationsobjekte auf der Page erzeugt.
|* Alle Praesentationsobjekte erhalten einen UserCall auf die Page.
|*
\************************************************************************/

SfxStyleSheet* SdPage::GetStyleSheetForPresObj(PresObjKind eObjKind) const
{
	String aName(GetLayoutName());
	String aSep( RTL_CONSTASCII_USTRINGPARAM( SD_LT_SEPARATOR ));
	USHORT nPos = aName.Search(aSep);
	if (nPos != STRING_NOTFOUND)
	{
		nPos = nPos + aSep.Len();
		aName.Erase(nPos);
	}

	SfxStyleFamily eFamily = SD_LT_FAMILY;

	switch (eObjKind)
	{
		case PRESOBJ_OUTLINE:
		{
			aName = GetLayoutName();
			aName += sal_Unicode( ' ' );
			aName += String::CreateFromInt32( 1 );
		}
		break;

		case PRESOBJ_TITLE:
			aName += String(SdResId(STR_LAYOUT_TITLE));
			break;

		case PRESOBJ_BACKGROUND:
			aName += String(SdResId(STR_LAYOUT_BACKGROUND));
			break;

		case PRESOBJ_NOTES:
			aName += String(SdResId(STR_LAYOUT_NOTES));
			break;

		case PRESOBJ_TEXT:
			aName += String(SdResId(STR_LAYOUT_SUBTITLE));
			break;

		case PRESOBJ_HEADER:
		case PRESOBJ_FOOTER:
		case PRESOBJ_DATETIME:
		case PRESOBJ_SLIDENUMBER:
			aName += String(SdResId(STR_LAYOUT_BACKGROUNDOBJECTS));
			break;

		default:
			break;
	}

	SfxStyleSheetBasePool* pStShPool = pModel->GetStyleSheetPool();
	SfxStyleSheetBase*	   pResult	 = pStShPool->Find(aName, eFamily);
	return (SfxStyleSheet*)pResult;
}

/** returns the presentation style with the given helpid from this masterpage or this
	slides masterpage */
SdStyleSheet* SdPage::getPresentationStyle( sal_uInt32 nHelpId ) const
{
	String aStyleName( pPage->GetLayoutName() );
	const String aSep( RTL_CONSTASCII_USTRINGPARAM( SD_LT_SEPARATOR ));
	aStyleName.Erase(aStyleName.Search(aSep) + aSep.Len());

	sal_uInt16 nNameId;
	switch( nHelpId )
	{
	case HID_PSEUDOSHEET_TITLE:				nNameId = STR_LAYOUT_TITLE; 			break;
	case HID_PSEUDOSHEET_SUBTITLE:	 		nNameId = STR_LAYOUT_SUBTITLE; 			break;
	case HID_PSEUDOSHEET_OUTLINE1:
	case HID_PSEUDOSHEET_OUTLINE2:
	case HID_PSEUDOSHEET_OUTLINE3:
	case HID_PSEUDOSHEET_OUTLINE4:
	case HID_PSEUDOSHEET_OUTLINE5:
	case HID_PSEUDOSHEET_OUTLINE6:
	case HID_PSEUDOSHEET_OUTLINE7:
	case HID_PSEUDOSHEET_OUTLINE8:
	case HID_PSEUDOSHEET_OUTLINE9:			nNameId = STR_LAYOUT_OUTLINE; 			break;
	case HID_PSEUDOSHEET_BACKGROUNDOBJECTS:	nNameId = STR_LAYOUT_BACKGROUNDOBJECTS; break;
	case HID_PSEUDOSHEET_BACKGROUND:		nNameId = STR_LAYOUT_BACKGROUND; 		break;
	case HID_PSEUDOSHEET_NOTES:				nNameId = STR_LAYOUT_NOTES; 			break;

	default:
		DBG_ERROR( "SdPage::getPresentationStyle(), illegal argument!" );
		return 0;
	}
	aStyleName.Append( String( SdResId( nNameId ) ) );
	if( nNameId == STR_LAYOUT_OUTLINE )
	{
		aStyleName.Append( sal_Unicode( ' ' ));
		aStyleName.Append( String::CreateFromInt32( sal_Int32( nHelpId - HID_PSEUDOSHEET_OUTLINE )));
	}

	SfxStyleSheetBasePool* pStShPool = pModel->GetStyleSheetPool();
	SfxStyleSheetBase*	   pResult	 = pStShPool->Find(aStyleName, SD_LT_FAMILY);
	return dynamic_cast<SdStyleSheet*>(pResult);
}

/*************************************************************************
|*
|* Das Praesentationsobjekt rObj hat sich geaendert und wird nicht mehr
|* durch das Praesentationsobjekt der MasterPage referenziert.
|* Der UserCall wird geloescht.
|*
\************************************************************************/

void SdPage::Changed(const SdrObject& rObj, SdrUserCallType eType, const Rectangle& )
{
	if (!maLockAutoLayoutArrangement.isLocked())
	{
		switch (eType)
		{
			case SDRUSERCALL_MOVEONLY:
			case SDRUSERCALL_RESIZE:
			{
				if( pModel->isLocked() )
					break;

				SdrObject* pObj = (SdrObject*) &rObj;

				if (pObj)
				{
					if (!bMaster)
					{
						if( pObj->GetUserCall() )
						{
							sd::UndoManager* pUndoManager = pModel ? static_cast<SdDrawDocument*>(pModel)->GetUndoManager() : 0;
							const bool bUndo = pUndoManager && pUndoManager->isInListAction() && IsInserted();
/*
							DBG_ASSERT( bUndo || (pUndoManager && pUndoManager->isInUndo()),
											"SdPage::Changed(), model change without undo!?" );
*/
							if( bUndo )
								pUndoManager->AddUndoAction( new UndoObjectUserCall(*pObj) );

							// Objekt was resized by user and does not listen to its slide anymore
							pObj->SetUserCall(0);
						}
					}
					else if (pModel)
					{
						// MasterPage-Objekt wurde veraendert, daher
						// Objekte auf allen Seiten anpassen
						USHORT nPageCount = ((SdDrawDocument*) pModel)->GetSdPageCount(mePageKind);

						for (USHORT i = 0; i < nPageCount; i++)
						{
							SdPage* pLoopPage = ((SdDrawDocument*) pModel)->GetSdPage(i, mePageKind);

							if (pLoopPage && this == &(pLoopPage->TRG_GetMasterPage()))
							{
								// Seite hoert auf diese MasterPage, daher
								// AutoLayout anpassen
								pLoopPage->SetAutoLayout(pLoopPage->GetAutoLayout());
							}
						}
					}
				}
			}
			break;

			case SDRUSERCALL_DELETE:
			case SDRUSERCALL_REMOVED:
			default:
				break;
		}
	}
}

/*************************************************************************
|*
|* Erzeugt auf einer MasterPage Hintergrund, Titel- und Layout-Bereich
|*
\************************************************************************/

void SdPage::CreateTitleAndLayout(BOOL bInit, BOOL bCreate )
{
	sd::UndoManager* pUndoManager = pModel ? static_cast<SdDrawDocument*>(pModel)->GetUndoManager() : 0;
	const bool bUndo = pUndoManager && pUndoManager->isInListAction() && IsInserted();

	SdPage* pMasterPage = this;

	if (!bMaster)
	{
		pMasterPage = (SdPage*)(&(TRG_GetMasterPage()));
	}

	if (!pMasterPage)
	{
		return;
	}

	/**************************************************************************
	* Hintergrund, Titel- und Layout-Bereich werden angelegt
	**************************************************************************/
	if( mePageKind == PK_STANDARD )
	{
		SdrObject* pMasterBackground = pMasterPage->GetPresObj( PRESOBJ_BACKGROUND );
		if( pMasterBackground == NULL )
			pMasterPage->CreateDefaultPresObj(PRESOBJ_BACKGROUND, true);
	}

	if( ( (SdDrawDocument*) GetModel() )->GetDocumentType() == DOCUMENT_TYPE_IMPRESS )
	{
		if( mePageKind == PK_HANDOUT && bInit )
		{
			// handout template

			// delete all available handout presentation objects
			SdrObject* pObj;
			while( (pObj = pMasterPage->GetPresObj(PRESOBJ_HANDOUT)) != 0 )
			{
				if( bUndo )
					pUndoManager->AddUndoAction(pModel->GetSdrUndoFactory().CreateUndoDeleteObject(*pObj));

				pMasterPage->RemoveObject(pObj->GetOrdNum());
			}
	
			Size    aArea = GetSize();
			long    nX = GetLftBorder();
			long    nY = GetUppBorder();
			long    nGapW = (nX + GetRgtBorder()) / 2;
			long    nGapH = (nY + GetLwrBorder()) / 2;
			USHORT  nColCnt, nRowCnt;

			const int NOTES_HEADER_FOOTER_HEIGHT = long((aArea.Height() - GetUppBorder() - GetLwrBorder()) * 0.05);

			aArea.Height() -= 2 * NOTES_HEADER_FOOTER_HEIGHT;

			if ( !nGapW )
			{
				nGapW = aArea.Width() / 10;
				nX = nGapW;
			}
			if ( !nGapH )
			{
				nGapH = aArea.Height() / 10;
				nY = nGapH;
			}

			switch ( pMasterPage->GetAutoLayout() )
			{
				case AUTOLAYOUT_HANDOUT1: nColCnt = 1; nRowCnt = 1; break;
				case AUTOLAYOUT_HANDOUT2: nColCnt = 1; nRowCnt = 2; break;
				case AUTOLAYOUT_HANDOUT3: nColCnt = 1; nRowCnt = 3; break;
				case AUTOLAYOUT_HANDOUT4: nColCnt = 2; nRowCnt = 2; break;
				case AUTOLAYOUT_HANDOUT6: nColCnt = 2; nRowCnt = 3; break;
				default: nColCnt = 1; nRowCnt = 1; break;
			}
			aArea.Width() -= nGapW * 2;
			aArea.Height() -= nGapH * 2;

			if ( nGapW < aArea.Width() / 10 )
				nGapW = aArea.Width() / 10;
			if ( nGapH < aArea.Height() / 10 )
				nGapH = aArea.Height() / 10;

			// bei Querformat Reihen und Spalten vertauschen
			if ( aArea.Width() > aArea.Height() )
			{
				USHORT nTmp = nRowCnt;
				nRowCnt = nColCnt;
				nColCnt = nTmp;
			}

			Size aPartArea, aSize;
			aPartArea.Width()  = ((aArea.Width()  + nGapW) / nColCnt) - nGapW;
			aPartArea.Height() = ((aArea.Height() + nGapH) / nRowCnt) - nGapH;

			SdrPage* pFirstPage = ((SdDrawDocument*) pModel)->GetSdPage(0, PK_STANDARD);
			if ( pFirstPage )
			{   // tatsaechliche Seitengroesse in das Handout-Rechteck skalieren
				double fH = (double) aPartArea.Width()  / pFirstPage->GetWdt();
				double fV = (double) aPartArea.Height() / pFirstPage->GetHgt();

				if ( fH > fV )
					fH = fV;
				aSize.Width()  = (long) (fH * pFirstPage->GetWdt());
				aSize.Height() = (long) (fH * pFirstPage->GetHgt());

				nX += (aPartArea.Width() - aSize.Width()) / 2;
				nY += (aPartArea.Height()- aSize.Height())/ 2;
			}
			else
				aSize = aPartArea;

			Point aPos(nX, nY + NOTES_HEADER_FOOTER_HEIGHT);
			USHORT nPgNum = 0;

			for (USHORT nRow = 0; nRow < nRowCnt; nRow++)
			{
				aPos.X() = nX;

				for (USHORT nCol = 0; nCol < nColCnt; nCol++)
				{
					Rectangle aRect(aPos, aSize);
					SdrPageObj* pPageObj = (SdrPageObj*) pMasterPage->CreatePresObj(PRESOBJ_HANDOUT, FALSE, aRect, TRUE);

					const sal_uInt16 nDestinationPageNum(2 * nPgNum + 1);
					
					if(nDestinationPageNum < pModel->GetPageCount())
					{
						pPageObj->SetReferencedPage(pModel->GetPage(nDestinationPageNum));
					}
					else
					{
						pPageObj->SetReferencedPage(0L);
					}

					nPgNum++;
					aPos.X() += aPartArea.Width() + nGapW;
				}
				aPos.Y() += aPartArea.Height() + nGapH;
			}
		}

		if( mePageKind != PK_HANDOUT )
		{
			SdrObject* pMasterTitle = pMasterPage->GetPresObj( PRESOBJ_TITLE );
			if( pMasterTitle == NULL )
				pMasterPage->CreateDefaultPresObj(PRESOBJ_TITLE, true);

			SdrObject* pMasterOutline = pMasterPage->GetPresObj( mePageKind==PK_NOTES ? PRESOBJ_NOTES : PRESOBJ_OUTLINE );
			if( pMasterOutline == NULL )
				pMasterPage->CreateDefaultPresObj( mePageKind == PK_STANDARD ? PRESOBJ_OUTLINE : PRESOBJ_NOTES, true );
		}

		// create header&footer objects 

		if( bCreate )
		{
			if( mePageKind != PK_STANDARD )
			{
				SdrObject* pHeader = pMasterPage->GetPresObj( PRESOBJ_HEADER );
				if( pHeader == NULL )
					pMasterPage->CreateDefaultPresObj( PRESOBJ_HEADER, true );
			}

			SdrObject* pDate   = pMasterPage->GetPresObj( PRESOBJ_DATETIME );
			if( pDate == NULL )
				pMasterPage->CreateDefaultPresObj( PRESOBJ_DATETIME, true );

			SdrObject* pFooter = pMasterPage->GetPresObj( PRESOBJ_FOOTER );
			if( pFooter == NULL )
				pMasterPage->CreateDefaultPresObj( PRESOBJ_FOOTER, true );

			SdrObject* pNumber = pMasterPage->GetPresObj( PRESOBJ_SLIDENUMBER );
			if( pNumber == NULL )
				pMasterPage->CreateDefaultPresObj( PRESOBJ_SLIDENUMBER, true );
		}
	}
}

SdrObject* SdPage::CreateDefaultPresObj(PresObjKind eObjKind, bool bInsert)
{
	if( eObjKind == PRESOBJ_TITLE )
	{
		Rectangle aTitleRect( GetTitleRect() );
		return CreatePresObj(PRESOBJ_TITLE, FALSE, aTitleRect, bInsert);
	}
	else if( eObjKind == PRESOBJ_OUTLINE )
	{
		Rectangle aLayoutRect( GetLayoutRect() );
		return CreatePresObj( PRESOBJ_OUTLINE, FALSE, aLayoutRect, bInsert);
	}
	else if( eObjKind == PRESOBJ_NOTES )
	{
		Rectangle aLayoutRect( GetLayoutRect() );
		return CreatePresObj( PRESOBJ_NOTES, FALSE, aLayoutRect, bInsert);
	}
	else if( (eObjKind == PRESOBJ_FOOTER) || (eObjKind == PRESOBJ_DATETIME) || (eObjKind == PRESOBJ_SLIDENUMBER) || (eObjKind == PRESOBJ_HEADER ) )
	{
		// create footer objects for standard master page
		if( mePageKind == PK_STANDARD )
		{
			const long nLftBorder = GetLftBorder();
			const long nUppBorder = GetUppBorder();

			Point aTitlePos ( nLftBorder, nUppBorder );
			Size aPageSize ( GetSize() );
			aPageSize.Width()  -= nLftBorder + GetRgtBorder();
			aPageSize.Height() -= nUppBorder + GetLwrBorder();

			const int Y = long(nUppBorder + aPageSize.Height() * 0.911);
			const int W1 = long(aPageSize.Width() * 0.233);
			const int W2 = long(aPageSize.Width() * 0.317);
			const int H = long(aPageSize.Height() * 0.069);

			if( eObjKind == PRESOBJ_DATETIME )
			{
				Point aPos( long(nLftBorder+(aPageSize.Width()*0.05)), Y );
				Size aSize( W1, H );
				Rectangle aRect( aPos, aSize );
				return CreatePresObj( PRESOBJ_DATETIME, FALSE, aRect, bInsert );
			}
			else if( eObjKind == PRESOBJ_FOOTER )
			{
				Point aPos( long(nLftBorder+ aPageSize.Width() * 0.342), Y );
				Size aSize( W2, H );
				Rectangle aRect( aPos, aSize );
				return CreatePresObj( PRESOBJ_FOOTER, FALSE, aRect, bInsert );
			}
			else if( eObjKind == PRESOBJ_SLIDENUMBER )
			{
				Point aPos( long(nLftBorder+(aPageSize.Width()*0.717)), Y );
				Size aSize( W1, H );
				Rectangle aRect( aPos, aSize );
				return CreatePresObj( PRESOBJ_SLIDENUMBER, FALSE, aRect, bInsert );
			}
			else
			{
				DBG_ERROR( "SdPage::CreateDefaultPresObj() - can't create a header placeholder for a slide master" );
				return NULL;
			}
		}
		else
		{
			// create header&footer objects for handout and notes master		
			Point aTitlePos ( GetLftBorder(), GetUppBorder() );
			Size aPageSize ( GetSize() );
			aPageSize.Width()  -= GetLftBorder() + GetRgtBorder();
			aPageSize.Height() -= GetUppBorder() + GetLwrBorder();


			const int NOTES_HEADER_FOOTER_WIDTH = long(aPageSize.Width() * 0.434);
			const int NOTES_HEADER_FOOTER_HEIGHT = long(aPageSize.Height() * 0.05);

			Size aSize( NOTES_HEADER_FOOTER_WIDTH, NOTES_HEADER_FOOTER_HEIGHT );

			const int X1 = GetLftBorder();
			const int X2 = GetLftBorder() + long(aPageSize.Width() - NOTES_HEADER_FOOTER_WIDTH);
			const int Y1 = GetUppBorder();
			const int Y2 = GetUppBorder() + long(aPageSize.Height() - NOTES_HEADER_FOOTER_HEIGHT );

			if( eObjKind == PRESOBJ_HEADER )
			{
				Point aPos( X1, Y1 );
				Rectangle aRect( aPos, aSize );
				return CreatePresObj( PRESOBJ_HEADER, FALSE, aRect, bInsert );
			}
			else if( eObjKind == PRESOBJ_DATETIME )
			{
				Point aPos( X2, Y1 );
				Rectangle aRect( aPos, aSize );
				return CreatePresObj( PRESOBJ_DATETIME, FALSE, aRect, bInsert );
			}
			else if( eObjKind == PRESOBJ_FOOTER )
			{
				Point aPos( X1, Y2 );
				Rectangle aRect( aPos, aSize );
				return CreatePresObj( PRESOBJ_FOOTER, FALSE, aRect, bInsert );
			}
			else if( eObjKind == PRESOBJ_SLIDENUMBER )
			{
				Point aPos( X2, Y2 );
				Rectangle aRect( aPos, aSize );
				return CreatePresObj( PRESOBJ_SLIDENUMBER, FALSE, aRect, bInsert );
			}

			DBG_ERROR("SdPage::CreateDefaultPresObj() - this should not happen!");
			return NULL;
		}
	}
	else if( eObjKind == PRESOBJ_BACKGROUND )
	{
		Point aBackgroundPos ( GetLftBorder(), GetUppBorder() );
		Size aBackgroundSize ( GetSize() );
		aBackgroundSize.Width()  -= GetLftBorder() + GetRgtBorder() - 1;
		aBackgroundSize.Height() -= GetUppBorder() + GetLwrBorder() - 1;
		Rectangle aBackgroundRect(aBackgroundPos, aBackgroundSize);
		return CreatePresObj( PRESOBJ_BACKGROUND, FALSE, aBackgroundRect, bInsert );
	}
	else
	{
		DBG_ERROR("SdPage::CreateDefaultPresObj() - unknown PRESOBJ kind" );
		return NULL;
	}
}

/*************************************************************************
|*
|* Titelbereich zurueckgeben
|*
\************************************************************************/

Rectangle SdPage::GetTitleRect() const
{
	Rectangle aTitleRect;

	if (mePageKind != PK_HANDOUT)
	{
		/******************************************************************
		* Standard- oder Notiz-Seite: Titelbereich
		******************************************************************/
		Point aTitlePos ( GetLftBorder(), GetUppBorder() );
		Size aTitleSize ( GetSize() );
		aTitleSize.Width()  -= GetLftBorder() + GetRgtBorder();
		aTitleSize.Height() -= GetUppBorder() + GetLwrBorder();

		if (mePageKind == PK_STANDARD)
		{
			aTitlePos.X() += long( aTitleSize.Width() * 0.05 );
			aTitlePos.Y() += long( aTitleSize.Height() * 0.0399 );
			aTitleSize.Width() = long( aTitleSize.Width() * 0.9 );
			aTitleSize.Height() = long( aTitleSize.Height() * 0.167 );
		}
		else if (mePageKind == PK_NOTES)
		{
			Point aPos = aTitlePos;
			aPos.Y() += long( aTitleSize.Height() * 0.076 );

			// Hoehe beschraenken
			aTitleSize.Height() = (long) (aTitleSize.Height() * 0.375);

			Size aPartArea = aTitleSize;
			Size aSize;
			sal_uInt16 nDestPageNum(GetPageNum());
			SdrPage* pRefPage = 0L;

			if(nDestPageNum)
			{
				// only decrement if != 0, else we get 0xffff
				nDestPageNum -= 1;
			}

			if(nDestPageNum < pModel->GetPageCount())
			{
				pRefPage = pModel->GetPage(nDestPageNum);
			}

			if ( pRefPage )
			{
				// tatsaechliche Seitengroesse in das Handout-Rechteck skalieren
				double fH = (double) aPartArea.Width()  / pRefPage->GetWdt();
				double fV = (double) aPartArea.Height() / pRefPage->GetHgt();

				if ( fH > fV )
					fH = fV;
				aSize.Width()  = (long) (fH * pRefPage->GetWdt());
				aSize.Height() = (long) (fH * pRefPage->GetHgt());

				aPos.X() += (aPartArea.Width() - aSize.Width()) / 2;
				aPos.Y() += (aPartArea.Height()- aSize.Height())/ 2;
			}

			aTitlePos = aPos;
			aTitleSize = aSize;
		}

		aTitleRect.SetPos(aTitlePos);
		aTitleRect.SetSize(aTitleSize);
	}

	return aTitleRect;
}


/*************************************************************************
|*
|* Gliederungsbereich zurueckgeben
|*
\************************************************************************/

Rectangle SdPage::GetLayoutRect() const
{
	Rectangle aLayoutRect;

	if (mePageKind != PK_HANDOUT)
	{
		Point aLayoutPos ( GetLftBorder(), GetUppBorder() );
		Size aLayoutSize ( GetSize() );
		aLayoutSize.Width()  -= GetLftBorder() + GetRgtBorder();
		aLayoutSize.Height() -= GetUppBorder() + GetLwrBorder();

		if (mePageKind == PK_STANDARD)
		{
			aLayoutPos.X() += long( aLayoutSize.Width() * 0.05 );
			aLayoutPos.Y() += long( aLayoutSize.Height() * 0.234 );
			aLayoutSize.Width() = long( aLayoutSize.Width() * 0.9 );
			aLayoutSize.Height() = long( aLayoutSize.Height() * 0.66 );
			aLayoutRect.SetPos(aLayoutPos);
			aLayoutRect.SetSize(aLayoutSize);
		}
		else if (mePageKind == PK_NOTES)
		{
			aLayoutPos.X() += long( aLayoutSize.Width() * 0.1 );
			aLayoutPos.Y() += long( aLayoutSize.Height() * 0.475 );
			aLayoutSize.Width() = long( aLayoutSize.Width() * 0.8 );
			aLayoutSize.Height() = long( aLayoutSize.Height() * 0.45 );
			aLayoutRect.SetPos(aLayoutPos);
			aLayoutRect.SetSize(aLayoutSize);
		}
	}

	return aLayoutRect;
}


/**************************************************************************
|*
|* Diese Methode weist ein AutoLayout zu
|*
\*************************************************************************/

const int MAX_PRESOBJS = 5;	// maximum number of presentation objects per layout
const int VERTICAL = 0x8000;

struct LayoutDescriptor
{
	int mnLayout;
	PresObjKind meKind[MAX_PRESOBJS];
	bool mbVertical[MAX_PRESOBJS];

	LayoutDescriptor( int nLayout, int k0 = 0, int k1 = 0, int k2 = 0, int k3 = 0, int k4 = 0 );
};

LayoutDescriptor::LayoutDescriptor( int nLayout, int k0, int k1, int k2, int k3, int k4 )
: mnLayout( nLayout )
{
	meKind[0] = static_cast<PresObjKind>(k0 & (~VERTICAL)); mbVertical[0] = (k0 & VERTICAL) == VERTICAL;
	meKind[1] = static_cast<PresObjKind>(k1 & (~VERTICAL)); mbVertical[1] = (k1 & VERTICAL) == VERTICAL;
	meKind[2] = static_cast<PresObjKind>(k2 & (~VERTICAL)); mbVertical[2] = (k2 & VERTICAL) == VERTICAL;
	meKind[3] = static_cast<PresObjKind>(k3 & (~VERTICAL)); mbVertical[3] = (k3 & VERTICAL) == VERTICAL;
	meKind[4] = static_cast<PresObjKind>(k4 & (~VERTICAL)); mbVertical[4] = (k4 & VERTICAL) == VERTICAL;
}

static const LayoutDescriptor& GetLayoutDescriptor( AutoLayout eLayout )
{
	static LayoutDescriptor aLayouts[AUTOLAYOUT__END-AUTOLAYOUT__START] =
	{
		LayoutDescriptor( 0, PRESOBJ_TITLE, PRESOBJ_TEXT ),									// AUTOLAYOUT_TITLE
		LayoutDescriptor( 0, PRESOBJ_TITLE, PRESOBJ_OUTLINE ),								// AUTOLAYOUT_ENUM
		LayoutDescriptor( 0, PRESOBJ_TITLE, PRESOBJ_CHART ),								// AUTOLAYOUT_CHART
		LayoutDescriptor( 1, PRESOBJ_TITLE, PRESOBJ_OUTLINE, PRESOBJ_OUTLINE ),				// AUTOLAYOUT_2TEXT
		LayoutDescriptor( 1, PRESOBJ_TITLE, PRESOBJ_OUTLINE, PRESOBJ_CHART ),				// AUTOLAYOUT_TEXTCHART
		LayoutDescriptor( 0, PRESOBJ_TITLE, PRESOBJ_ORGCHART ),								// AUTOLAYOUT_ORG
		LayoutDescriptor( 1, PRESOBJ_TITLE, PRESOBJ_OUTLINE, PRESOBJ_GRAPHIC ),				// AUTOLAYOUT_TEXTCLIP
		LayoutDescriptor( 1, PRESOBJ_TITLE, PRESOBJ_CHART, PRESOBJ_OUTLINE ),				// AUTOLAYOUT_CHARTTEXT
		LayoutDescriptor( 0, PRESOBJ_TITLE, PRESOBJ_TABLE ),								// AUTOLAYOUT_TAB
		LayoutDescriptor( 1, PRESOBJ_TITLE, PRESOBJ_GRAPHIC, PRESOBJ_OUTLINE ),				// AUTOLAYOUT_CLIPTEXT
		LayoutDescriptor( 1, PRESOBJ_TITLE, PRESOBJ_OUTLINE, PRESOBJ_OBJECT ),				// AUTOLAYOUT_TEXTOBJ
		LayoutDescriptor( 0, PRESOBJ_TITLE, PRESOBJ_OBJECT ),								// AUTOLAYOUT_OBJ
		LayoutDescriptor( 2, PRESOBJ_TITLE, PRESOBJ_OUTLINE, PRESOBJ_OBJECT, PRESOBJ_OBJECT ),	// AUTOLAYOUT_TEXT2OBJ
		LayoutDescriptor( 1, PRESOBJ_TITLE, PRESOBJ_OBJECT, PRESOBJ_OUTLINE ),				// AUTOLAYOUT_TEXTOBJ
		LayoutDescriptor( 4, PRESOBJ_TITLE, PRESOBJ_OBJECT, PRESOBJ_OUTLINE ),				// AUTOLAYOUT_OBJOVERTEXT
		LayoutDescriptor( 3, PRESOBJ_TITLE, PRESOBJ_OBJECT, PRESOBJ_OBJECT, PRESOBJ_OUTLINE ),	// AUTOLAYOUT_2OBJTEXT
		LayoutDescriptor( 5, PRESOBJ_TITLE, PRESOBJ_OBJECT, PRESOBJ_OBJECT, PRESOBJ_OUTLINE ),	// AUTOLAYOUT_2OBJOVERTEXT	
		LayoutDescriptor( 4, PRESOBJ_TITLE, PRESOBJ_OUTLINE, PRESOBJ_OBJECT ),				// AUTOLAYOUT_TEXTOVEROBJ
		LayoutDescriptor( 6, PRESOBJ_TITLE, PRESOBJ_OBJECT, PRESOBJ_OBJECT,					// AUTOLAYOUT_4OBJ
			PRESOBJ_OBJECT, PRESOBJ_OBJECT ),
		LayoutDescriptor( 0, PRESOBJ_TITLE, PRESOBJ_NONE ),									// AUTOLAYOUT_ONLY_TITLE
		LayoutDescriptor( 0, PRESOBJ_NONE ),												// AUTOLAYOUT_NONE
		LayoutDescriptor( 0, PRESOBJ_PAGE, PRESOBJ_NOTES ),									// AUTOLAYOUT_NOTES
		LayoutDescriptor( 0 ),																// AUTOLAYOUT_HANDOUT1
		LayoutDescriptor( 0 ),																// AUTOLAYOUT_HANDOUT2
		LayoutDescriptor( 0 ),																// AUTOLAYOUT_HANDOUT3
		LayoutDescriptor( 0 ),																// AUTOLAYOUT_HANDOUT4
		LayoutDescriptor( 0 ),																// AUTOLAYOUT_HANDOUT6
		LayoutDescriptor( 7, PRESOBJ_TITLE|VERTICAL, PRESOBJ_OUTLINE|VERTICAL, PRESOBJ_CHART ),// AUTOLAYOUT_VERTICAL_TITLE_TEXT_CHART
		LayoutDescriptor( 8, PRESOBJ_TITLE|VERTICAL, PRESOBJ_OUTLINE|VERTICAL ),			// AUTOLAYOUT_VERTICAL_TITLE_VERTICAL_OUTLINE
		LayoutDescriptor( 0, PRESOBJ_TITLE, PRESOBJ_OUTLINE|VERTICAL ),						// AUTOLAYOUT_TITLE_VERTICAL_OUTLINE
		LayoutDescriptor( 9, PRESOBJ_TITLE, PRESOBJ_GRAPHIC, PRESOBJ_OUTLINE|VERTICAL )		// AUTOLAYOUT_TITLE_VERTICAL_OUTLINE_CLIPART
	};

	if( (eLayout < AUTOLAYOUT__START) || (eLayout >= AUTOLAYOUT__END) )
		eLayout = AUTOLAYOUT_NONE;

	return aLayouts[ eLayout - AUTOLAYOUT__START ];
}

static void CalcAutoLayoutRectangles( SdPage& rPage, int nLayout, Rectangle* rRectangle )
{
	Rectangle aTitleRect;
	Rectangle aLayoutRect;

	if( rPage.GetPageKind() != PK_HANDOUT )
	{
		SdPage& rMasterPage = static_cast<SdPage&>(rPage.TRG_GetMasterPage());
		SdrObject* pMasterTitle = rMasterPage.GetPresObj( PRESOBJ_TITLE );
		SdrObject* pMasterOutline = rMasterPage.GetPresObj( rPage.GetPageKind()==PK_NOTES ? PRESOBJ_NOTES : PRESOBJ_OUTLINE );

		if( pMasterTitle )
			aTitleRect = pMasterTitle->GetLogicRect();

		if (aTitleRect.IsEmpty() )
			aTitleRect = rPage.GetTitleRect();

		if( pMasterOutline )
			aLayoutRect = pMasterOutline->GetLogicRect();

		if (aLayoutRect.IsEmpty() )
			aLayoutRect = rPage.GetLayoutRect();
	}

	rRectangle[0] = aTitleRect;

	int i;
	for( i = 1; i < MAX_PRESOBJS; i++ )
		rRectangle[i] = aLayoutRect;

	Size        aTitleSize( aTitleRect.GetSize() );
	Point       aTitlePos( aTitleRect.TopLeft() );
	Size        aLayoutSize( aLayoutRect.GetSize() );
	Point       aLayoutPos( aLayoutRect.TopLeft() );
	Size        aTempSize;
	Point       aTempPnt;

    sal_Bool    bRightToLeft = ( rPage.GetModel() && static_cast< SdDrawDocument* >( rPage.GetModel() )->GetDefaultWritingMode() == ::com::sun::star::text::WritingMode_RL_TB );

	switch( nLayout )
	{
	case 0: // default layout using only the title and layout area
		break; // do nothing
	case 1: // title, 2 shapes
	case 9: // title, 2 vertical shapes
		aLayoutSize.Width()  = long (aLayoutSize.Width() * 0.488);
		rRectangle[1] = Rectangle (aLayoutPos, aLayoutSize);

		aLayoutPos.X() = long (aLayoutPos.X() + aLayoutSize.Width() * 1.05);
		rRectangle[2] = Rectangle (aLayoutPos, aLayoutSize);

        if( bRightToLeft && (nLayout != 9) )
            ::std::swap< Rectangle >( rRectangle[1], rRectangle[2] );
		break;
	case 2: // title, shape, 2 shapes
		aTempPnt = aLayoutPos;
		aTempSize = aLayoutSize;
		aLayoutSize.Height() = long (aLayoutSize.Height() * 0.477);
		aLayoutSize.Width() = long (aLayoutSize.Width() * 0.488);
		aLayoutPos.X() = long (aLayoutPos.X() + aLayoutSize.Width() * 1.05);
		rRectangle[2] = Rectangle (aLayoutPos, aLayoutSize);

		aLayoutPos.Y() = long (aLayoutPos.Y() + aLayoutSize.Height() * 1.095);
		rRectangle[3] = Rectangle (aLayoutPos, aLayoutSize);

		aLayoutPos = aTempPnt;
		aLayoutSize = aTempSize;
		aLayoutSize.Width() = long (aLayoutSize.Width() * 0.488);
		rRectangle[1] = Rectangle (aLayoutPos, aLayoutSize);

		if( bRightToLeft )
		{
			::std::swap< long >( rRectangle[1].Left(), rRectangle[2].Left() );
			rRectangle[3].Left() = rRectangle[2].Left();
		}
		break;
	case 3: // title, 2 shapes, shape
		aTempPnt = aLayoutPos;
		aTempSize = aLayoutSize;
		aLayoutSize.Height() = long (aLayoutSize.Height() * 0.477);
		aLayoutSize.Width() = long (aLayoutSize.Width() * 0.488);
		rRectangle[1] = Rectangle (aLayoutPos, aLayoutSize);

		aLayoutPos.Y() = long (aLayoutPos.Y() + aLayoutSize.Height() * 1.095);
		rRectangle[2] = Rectangle (aLayoutPos, aLayoutSize);

		aLayoutPos = aTempPnt;
		aLayoutSize = aTempSize;
		aLayoutSize.Width() = long (aLayoutSize.Width() * 0.488);
		aLayoutPos.X() = long (aLayoutPos.X() + aLayoutSize.Width() * 1.05);
		rRectangle[3] = Rectangle (aLayoutPos, aLayoutSize);

        if( bRightToLeft )
        {
            ::std::swap< long >( rRectangle[1].Left(), rRectangle[2].Left() );
            rRectangle[3].Left() = rRectangle[2].Left();
        }
		break;
	case 4: // title, shape above shape
		aLayoutSize.Height() = long (aLayoutSize.Height() * 0.477);
		rRectangle[1] = Rectangle (aLayoutPos, aLayoutSize);

		aLayoutPos.Y() = long (aLayoutPos.Y() + aLayoutSize.Height() * 1.095);
		rRectangle[2] = Rectangle (aLayoutPos, aLayoutSize);
		break;		

	case 5: // title, 2 shapes above shape
		aLayoutSize.Height() = long (aLayoutSize.Height() * 0.477);
		aLayoutSize.Width() = long (aLayoutSize.Width() * 0.488);
		rRectangle[1] = Rectangle (aLayoutPos, aLayoutSize);

		aTempPnt = aLayoutPos;
		aLayoutPos.X() = long (aLayoutPos.X() + aLayoutSize.Width() * 1.05);
		rRectangle[2] = Rectangle (aLayoutPos, aLayoutSize);

		aLayoutPos.X() = aTempPnt.X();
		aLayoutPos.Y() = long (aLayoutPos.Y() + aLayoutSize.Height() * 1.095);
		aLayoutSize.Width() = long (aLayoutSize.Width() / 0.488);
		rRectangle[3] = Rectangle (aLayoutPos, aLayoutSize);
		break;
	case 6: // title, 4 shapes
	{
		ULONG nX = long (aLayoutPos.X());

		aLayoutSize.Height() = long (aLayoutSize.Height() * 0.477);
		aLayoutSize.Width()  = long (aLayoutSize.Width() * 0.488);
		rRectangle[1] = Rectangle (aLayoutPos, aLayoutSize);

		aLayoutPos.X() = long (nX + aLayoutSize.Width() * 1.05);
		rRectangle[2] = Rectangle (aLayoutPos, aLayoutSize);

		aLayoutPos.Y() = long (aLayoutPos.Y() + aLayoutSize.Height() * 1.095);
		rRectangle[3] = Rectangle (aLayoutPos, aLayoutSize);

		aLayoutPos.X() = nX;
		rRectangle[4] = Rectangle (aLayoutPos, aLayoutSize);
		break;
	}
	case 7: // vertical title, shape above shape
	{
		Size aSize( rRectangle[0].GetSize().Height(), rRectangle[1].BottomLeft().Y() - rRectangle[0].TopLeft().Y() );
		rRectangle[0].SetSize( aSize );
		rRectangle[0].SetPos( aTitleRect.TopRight() - Point( aSize.Width(), 0 ) );

		Size aPageSize ( rPage.GetSize() );
		aPageSize.Height() -= rPage.GetUppBorder() + rPage.GetLwrBorder();
		aSize.Height() = long ( rRectangle[0].GetSize().Height() * 0.47 );
		aSize.Width() = long( aPageSize.Width() * 0.7 );
		rRectangle[1].SetPos( aTitleRect.TopLeft() );
		rRectangle[1].SetSize( aSize );

		aSize.Height() = rRectangle[0].GetSize().Height();
		Point aPos( aTitleRect.TopLeft() );
		aPos.Y() += long ( aSize.Height() * 0.53 );
		rRectangle[2].SetPos( aPos );
		aSize.Height() = long ( rRectangle[0].GetSize().Height() * 0.47 );
		rRectangle[2].SetSize( aSize );
		break;
	}
	case 8: // vertical title, shape
	{
		Size aSize( rRectangle[0].GetSize().Height(), rRectangle[1].BottomLeft().Y() - rRectangle[0].TopLeft().Y() );
		rRectangle[0].SetSize( aSize );
		rRectangle[0].SetPos( aTitleRect.TopRight() - Point( aSize.Width(), 0 ) );

		Size aPageSize ( rPage.GetSize() );
		aPageSize.Height() -= rPage.GetUppBorder() + rPage.GetLwrBorder();
		aSize.Height() = rRectangle[0].GetSize().Height();
		aSize.Width() = long( aPageSize.Width() * 0.7 );
		rRectangle[1].SetPos( aTitleRect.TopLeft() );
		rRectangle[1].SetSize( aSize );
		break;
	}
	}
}


void findAutoLayoutShapesImpl( SdPage& rPage, const LayoutDescriptor& rDescriptor, std::vector< SdrObject* >& rShapes, bool bInit )
{
	int i;

	// init list of indexes for each presentation shape kind
	// this is used to find subsequent shapes with the same presentation shape kind
	int PresObjIndex[PRESOBJ_MAX];
	for( i = 0; i < PRESOBJ_MAX; i++ ) PresObjIndex[i] = 1;

	bool bMissing = false;

	// for each entry in the layoutdescriptor, arrange a presentation shape
	for( i = 0; (i < PRESOBJ_MAX) && (rDescriptor.meKind[i] != PRESOBJ_NONE); i++ )
	{
		PresObjKind eKind = rDescriptor.meKind[i];
		SdrObject* pObj = rPage.GetPresObj( eKind, PresObjIndex[eKind] );
		if( pObj )
		{
			PresObjIndex[eKind]++; // on next search for eKind, find next shape with same eKind
			rShapes[i] = pObj;
		}
		else
		{
			bMissing = true;
		}
	}

	if( bMissing && bInit )
	{
		// for each entry in the layoutdescriptor, look for an alternative shape
		for( i = 0; (i < PRESOBJ_MAX) && (rDescriptor.meKind[i] != PRESOBJ_NONE); i++ )
		{
			if( rShapes[i] )
				continue;

			PresObjKind eKind = rDescriptor.meKind[i];

			SdrObject* pObj = 0;
			bool bFound = false;

			const int nShapeCount = rPage.GetObjCount();
			int nShapeIndex = 0;
			while((nShapeIndex < nShapeCount) && !bFound )
			{
				pObj = rPage.GetObj(nShapeIndex++);

				if( pObj->IsEmptyPresObj() )
					continue;

				if( pObj->GetObjInventor() != SdrInventor )
					continue;

				// do not reuse shapes that are already part of the layout
				if( std::find( rShapes.begin(), rShapes.end(), pObj ) != rShapes.end() )
					continue;

				bool bPresStyle = pObj->GetStyleSheet() && (pObj->GetStyleSheet()->GetFamily() == SD_LT_FAMILY);
				SdrObjKind eSdrObjKind = static_cast< SdrObjKind >( pObj->GetObjIdentifier() );

				switch( eKind )
				{
				case PRESOBJ_TITLE:
					bFound = eSdrObjKind == OBJ_TITLETEXT;
					break;
				case PRESOBJ_OUTLINE:
					bFound = (eSdrObjKind == OBJ_OUTLINETEXT) || ((eSdrObjKind == OBJ_TEXT) && bPresStyle);
					break;
				case PRESOBJ_GRAPHIC:
					bFound = eSdrObjKind == OBJ_GRAF;
					break;
				case PRESOBJ_OBJECT:
					bFound = eSdrObjKind == OBJ_OLE2;
					break;
				case PRESOBJ_CHART:
				case PRESOBJ_TABLE:
					if( eSdrObjKind == OBJ_OLE2 )
					{
						SdrOle2Obj* pOle2 = dynamic_cast< SdrOle2Obj* >( pObj );
						if( pOle2 )
						{
							if(
								((eKind == PRESOBJ_CHART) && 
									( pOle2->GetProgName().EqualsAscii( "StarChart" ) || pOle2->IsChart() ) )
								||
								((eKind == PRESOBJ_TABLE) &&
									( pOle2->GetProgName().EqualsAscii( "StarCalc" ) || pOle2->IsCalc() ) ) )
							{
								bFound = true;
							}
						}
						break;
					}
					break;
				case PRESOBJ_PAGE:
				case PRESOBJ_HANDOUT:
					bFound = eSdrObjKind == OBJ_PAGE;
					break;
				case PRESOBJ_NOTES:
				case PRESOBJ_TEXT:
					bFound = (bPresStyle && (eSdrObjKind == OBJ_TEXT)) || (eSdrObjKind == OBJ_OUTLINETEXT);
					break;
				default:
					break;
				}
			}
	
			if( bFound )
				rShapes[i] = pObj;
		}
	}
}

void SdPage::SetAutoLayout(AutoLayout eLayout, BOOL bInit, BOOL bCreate )
{
	sd::ScopeLockGuard aGuard( maLockAutoLayoutArrangement );

	sd::UndoManager* pUndoManager = pModel ? static_cast<SdDrawDocument*>(pModel)->GetUndoManager() : 0;
	const bool bUndo = pUndoManager && pUndoManager->isInListAction() && IsInserted();

	meAutoLayout = eLayout;

	// if needed, creates and initialises the presentation shapes on this slides master page
	CreateTitleAndLayout(bInit, bCreate);

	if((meAutoLayout == AUTOLAYOUT_NONE && maPresentationShapeList.isEmpty()) || bMaster)
	{
		// MasterPage or no layout and no presentation shapes available, noting to do
		return;
	}

	Rectangle aRectangle[MAX_PRESOBJS];
	const LayoutDescriptor& aDescriptor = GetLayoutDescriptor( meAutoLayout );
	CalcAutoLayoutRectangles( *this, aDescriptor.mnLayout, aRectangle );

	std::set< SdrObject* > aUsedPresentationObjects;


	std::vector< SdrObject* > aLayoutShapes(PRESOBJ_MAX, 0);
	findAutoLayoutShapesImpl( *this, aDescriptor, aLayoutShapes, bInit );

	int i;

	// for each entry in the layoutdescriptor, arrange a presentation shape
	for( i = 0; (i < PRESOBJ_MAX) && (aDescriptor.meKind[i] != PRESOBJ_NONE); i++ )
	{
		PresObjKind eKind = aDescriptor.meKind[i];
		SdrObject* pObj = InsertAutoLayoutShape( aLayoutShapes[i], eKind, aDescriptor.mbVertical[i], aRectangle[i], bInit );
		if( pObj )
			aUsedPresentationObjects.insert(pObj); // remember that we used this empty shape
	}

	// now delete all empty presentation objects that are no longer used by the new layout
	if( bInit )
	{
		SdrObject* pObj = maPresentationShapeList.getNextShape(0);

		while( pObj )
		{
			SdrObject* pNext = maPresentationShapeList.getNextShape(pObj);
			if( aUsedPresentationObjects.count(pObj) == 0 )
			{
				
				if( pObj->IsEmptyPresObj() )
				{
					if( bUndo )
						pUndoManager->AddUndoAction(pModel->GetSdrUndoFactory().CreateUndoDeleteObject(*pObj));

					RemoveObject( pObj->GetOrdNum() );
			
					if( !bUndo )
						delete pObj;
				}
				else
				{
					if( bUndo )
					{
						pUndoManager->AddUndoAction( new UndoObjectPresentationKind( *pObj ) );
						if( pObj->GetUserCall() )
							pUndoManager->AddUndoAction( new UndoObjectUserCall( *pObj ) );
					}
					maPresentationShapeList.removeShape( *pObj );
					pObj->SetUserCall(0);
				}
			}
			pObj = pNext;
		}
	}
}

/*************************************************************************
|*
|* Objekt einfuegen
|*
\************************************************************************/

void SdPage::NbcInsertObject(SdrObject* pObj, ULONG nPos, const SdrInsertReason* pReason)
{
	FmFormPage::NbcInsertObject(pObj, nPos, pReason);

	((SdDrawDocument*) pModel)->InsertObject(pObj, this);

	SdrLayerID nId = pObj->GetLayer();
	if( bMaster )
	{
		if( nId == 0 )
			pObj->NbcSetLayer( 2 );     // wrong layer. corrected to BackgroundObj layer
	}
	else
	{
		if( nId == 2 )
			pObj->NbcSetLayer( 0 );     // wrong layer. corrected to layout layer
	}
}

/*************************************************************************
|*
|* Objekt loeschen
|*
\************************************************************************/

SdrObject* SdPage::RemoveObject(ULONG nObjNum)
{
	onRemoveObject(GetObj( nObjNum ));
	return FmFormPage::RemoveObject(nObjNum);
}

/*************************************************************************
|*
|* Objekt loeschen, ohne Broadcast
|*
\************************************************************************/

SdrObject* SdPage::NbcRemoveObject(ULONG nObjNum)
{
	onRemoveObject(GetObj( nObjNum ));
	return FmFormPage::NbcRemoveObject(nObjNum);
}

// #95876# Also overload ReplaceObject methods to realize when
// objects are removed with this mechanism instead of RemoveObject
SdrObject* SdPage::NbcReplaceObject(SdrObject* pNewObj, ULONG nObjNum)
{
	onRemoveObject(GetObj( nObjNum ));
	return FmFormPage::NbcReplaceObject(pNewObj, nObjNum);
}

// #95876# Also overload ReplaceObject methods to realize when
// objects are removed with this mechanism instead of RemoveObject
SdrObject* SdPage::ReplaceObject(SdrObject* pNewObj, ULONG nObjNum)
{
	onRemoveObject(GetObj( nObjNum ));
	return FmFormPage::ReplaceObject(pNewObj, nObjNum);
}

// -------------------------------------------------------------------------

// called after a shape is removed or replaced from this slide

void SdPage::onRemoveObject( SdrObject* pObject )
{
	if( pObject )
	{
		RemovePresObj(pObject);

		if( pModel )
			static_cast<SdDrawDocument*>(pModel)->RemoveObject(pObject, this);

		removeAnimations( pObject );
	}
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SdPage::SetSize(const Size& aSize)
{
	Size aOldSize = GetSize();

	if (aSize != aOldSize)
	{
		FmFormPage::SetSize(aSize);
		AdjustBackgroundSize();

		if (aOldSize.Height() == 10 && aOldSize.Width() == 10)
		{
			// Die Seite bekommt erstmalig eine gueltige Groesse gesetzt,
			// daher wird nun die Orientation initialisiert
			if (aSize.Width() > aSize.Height())
			{
				meOrientation = ORIENTATION_LANDSCAPE;
			}
			else
			{
				meOrientation = ORIENTATION_PORTRAIT;
			}
		}
	}
}


/*************************************************************************
|*
|*
|*
\************************************************************************/

void SdPage::SetBorder(INT32 nLft, INT32 nUpp, INT32 nRgt, INT32 nLwr)
{
	if (nLft != GetLftBorder() || nUpp != GetUppBorder() ||
		nRgt != GetRgtBorder() || nLwr != GetLwrBorder() )
	{
		FmFormPage::SetBorder(nLft, nUpp, nRgt, nLwr);
		AdjustBackgroundSize();
	}
}


/*************************************************************************
|*
|*
|*
\************************************************************************/

void SdPage::SetLftBorder(INT32 nBorder)
{
	if (nBorder != GetLftBorder() )
	{
		FmFormPage::SetLftBorder(nBorder);
		AdjustBackgroundSize();
	}
}


/*************************************************************************
|*
|*
|*
\************************************************************************/

void SdPage::SetRgtBorder(INT32 nBorder)
{
	if (nBorder != GetRgtBorder() )
	{
		FmFormPage::SetRgtBorder(nBorder);
		AdjustBackgroundSize();
	}
}


/*************************************************************************
|*
|*
|*
\************************************************************************/

void SdPage::SetUppBorder(INT32 nBorder)
{
	if (nBorder != GetUppBorder() )
	{
		FmFormPage::SetUppBorder(nBorder);
		AdjustBackgroundSize();
	}
}


/*************************************************************************
|*
|*
|*
\************************************************************************/

void SdPage::SetLwrBorder(INT32 nBorder)
{
	if (nBorder != GetLwrBorder() )
	{
		FmFormPage::SetLwrBorder(nBorder);
		AdjustBackgroundSize();
	}
}

/*************************************************************************
|*
|* Setzt BackgroundFullSize und ruft dann AdjustBackground auf
|*
\************************************************************************/

void SdPage::SetBackgroundFullSize( BOOL bIn )
{
	if( bIn != mbBackgroundFullSize )
	{
		mbBackgroundFullSize = bIn;
		AdjustBackgroundSize();
	}
}

/*************************************************************************
|*
|* Alle Objekte an neue Seitengroesse anpassen
|*
|* bScaleAllObj: Alle Objekte werden in die neue Flaeche innerhalb der
|* Seitenraender skaliert. Dabei werden die Position, Groesse und bei
|* Praesentationsobjekten auf der MasterPage auch die Schrifthoehe der
|* Praesentationsvorlagen skaliert.
|*
\************************************************************************/

void SdPage::ScaleObjects(const Size& rNewPageSize, const Rectangle& rNewBorderRect, BOOL bScaleAllObj)
{
	sd::ScopeLockGuard aGuard( maLockAutoLayoutArrangement );

	mbScaleObjects = bScaleAllObj;
	SdrObject* pObj = NULL;
	Point aRefPnt(0, 0);
	Size aNewPageSize(rNewPageSize);
	INT32 nLeft  = rNewBorderRect.Left();
	INT32 nRight = rNewBorderRect.Right();
	INT32 nUpper = rNewBorderRect.Top();
	INT32 nLower = rNewBorderRect.Bottom();

	// Negative Werte stehen fuer nicht zu aendernde Werte
	// -> aktuelle Werte verwenden
	if (aNewPageSize.Width() < 0)
	{
		aNewPageSize.Width() = GetWdt();
	}
	if (aNewPageSize.Height() < 0)
	{
		aNewPageSize.Height() = GetHgt();
	}
	if (nLeft < 0)
	{
		nLeft = GetLftBorder();
	}
	if (nRight < 0)
	{
		nRight = GetRgtBorder();
	}
	if (nUpper < 0)
	{
		nUpper = GetUppBorder();
	}
	if (nLower < 0)
	{
		nLower = GetLwrBorder();
	}

	Point aBackgroundPos(nLeft, nUpper);
	Size aBackgroundSize(aNewPageSize);
	Rectangle aBorderRect (aBackgroundPos, aBackgroundSize);

	if (mbScaleObjects)
	{
		aBackgroundSize.Width()  -= nLeft  + nRight;
		aBackgroundSize.Height() -= nUpper + nLower;
		aBorderRect.SetSize(aBackgroundSize);
		aNewPageSize = aBackgroundSize;
	}

	long nOldWidth  = GetWdt() - GetLftBorder() - GetRgtBorder();
	long nOldHeight = GetHgt() - GetUppBorder() - GetLwrBorder();

	Fraction aFractX = Fraction(aNewPageSize.Width(), nOldWidth);
	Fraction aFractY = Fraction(aNewPageSize.Height(), nOldHeight);

	ULONG nObjCnt = (mbScaleObjects ? GetObjCount() : 0);

	for (ULONG nObj = 0; nObj < nObjCnt; nObj++)
	{
		BOOL bIsPresObjOnMaster = FALSE;

		// Alle Objekte
		pObj = GetObj(nObj);

		if (bMaster && IsPresObj(pObj))
		{
			// Es ist ein Praesentationsobjekt auf der MasterPage
			bIsPresObjOnMaster = TRUE;
		}

		if (pObj)
		{
			USHORT nIndexBackground = 0;
			// #88084# remember aTopLeft as original TopLeft
			Point aTopLeft(pObj->GetCurrentBoundRect().TopLeft());

			if (bIsPresObjOnMaster &&
				(mePageKind == PK_HANDOUT ||
				 pObj == GetPresObj(PRESOBJ_BACKGROUND, nIndexBackground)))
			{
				/**************************************************************
				* 1. Praesentationsobjekte auf Handzettelseite sollen nur positioniert werden
				* 2. Hintergrundobjekt wird nicht skaliert
				**************************************************************/
			}
			else if (!pObj->IsEdgeObj())
			{
				/**************************************************************
				* Objekt skalieren
				**************************************************************/
				if (mbScaleObjects)
				{
					// #88084# use aTopLeft as original TopLeft
					aRefPnt = aTopLeft;
				}

				pObj->Resize(aRefPnt, aFractX, aFractY);

				if (mbScaleObjects)
				{
					SdrObjKind eObjKind = (SdrObjKind) pObj->GetObjIdentifier();

					if (bIsPresObjOnMaster)
					{
						/**********************************************************
						* Praesentationsvorlage: Texthoehe anpassen
						**********************************************************/
						USHORT nIndexTitle = 0;
						USHORT nIndexOutline = 0;
						USHORT nIndexNotes = 0;

						if (pObj == GetPresObj(PRESOBJ_TITLE, nIndexTitle))
						{
							SfxStyleSheet* pTitleSheet = GetStyleSheetForPresObj(PRESOBJ_TITLE);

							if (pTitleSheet)
							{
								SfxItemSet& rSet = pTitleSheet->GetItemSet();

								SvxFontHeightItem& rOldHgt = (SvxFontHeightItem&) rSet.Get(EE_CHAR_FONTHEIGHT);
								ULONG nFontHeight = rOldHgt.GetHeight();
								nFontHeight = long(nFontHeight * (double) aFractY);
								rSet.Put(SvxFontHeightItem(nFontHeight, 100, EE_CHAR_FONTHEIGHT));

								if( SFX_ITEM_AVAILABLE == rSet.GetItemState( EE_CHAR_FONTHEIGHT_CJK ) )
								{
									rOldHgt = (SvxFontHeightItem&) rSet.Get(EE_CHAR_FONTHEIGHT_CJK);
									nFontHeight = rOldHgt.GetHeight();
									nFontHeight = long(nFontHeight * (double) aFractY);
									rSet.Put(SvxFontHeightItem(nFontHeight, 100, EE_CHAR_FONTHEIGHT_CJK));
								}

								if( SFX_ITEM_AVAILABLE == rSet.GetItemState( EE_CHAR_FONTHEIGHT_CTL ) )
								{
									rOldHgt = (SvxFontHeightItem&) rSet.Get(EE_CHAR_FONTHEIGHT_CTL);
									nFontHeight = rOldHgt.GetHeight();
									nFontHeight = long(nFontHeight * (double) aFractY);
									rSet.Put(SvxFontHeightItem(nFontHeight, 100, EE_CHAR_FONTHEIGHT_CTL));
								}

								pTitleSheet->Broadcast(SfxSimpleHint(SFX_HINT_DATACHANGED));
							}
						}
						else if (pObj == GetPresObj(PRESOBJ_OUTLINE, nIndexOutline))
						{
							String aName(GetLayoutName());
							aName += sal_Unicode( ' ' );

							for (USHORT i=1; i<=9; i++)
							{
								String sLayoutName(aName);
								sLayoutName += String::CreateFromInt32( (sal_Int32)i );
								SfxStyleSheet* pOutlineSheet = (SfxStyleSheet*)
								((SdDrawDocument*) pModel)->GetStyleSheetPool()->
								Find(sLayoutName, SD_LT_FAMILY);

								if (pOutlineSheet)
								{
									// Neue Fonthoehe berechnen
									SfxItemSet aTempSet(pOutlineSheet->GetItemSet());

									SvxFontHeightItem& rOldHgt = (SvxFontHeightItem&) aTempSet.Get(EE_CHAR_FONTHEIGHT);
									ULONG nFontHeight = rOldHgt.GetHeight();
									nFontHeight = long(nFontHeight * (double) aFractY);
									aTempSet.Put(SvxFontHeightItem(nFontHeight, 100, EE_CHAR_FONTHEIGHT));

									if( SFX_ITEM_AVAILABLE == aTempSet.GetItemState( EE_CHAR_FONTHEIGHT_CJK ) )
									{
										rOldHgt = (SvxFontHeightItem&) aTempSet.Get(EE_CHAR_FONTHEIGHT_CJK);
										nFontHeight = rOldHgt.GetHeight();
										nFontHeight = long(nFontHeight * (double) aFractY);
										aTempSet.Put(SvxFontHeightItem(nFontHeight, 100, EE_CHAR_FONTHEIGHT_CJK));
									}

									if( SFX_ITEM_AVAILABLE == aTempSet.GetItemState( EE_CHAR_FONTHEIGHT_CTL ) )
									{
										rOldHgt = (SvxFontHeightItem&) aTempSet.Get(EE_CHAR_FONTHEIGHT_CTL);
										nFontHeight = rOldHgt.GetHeight();
										nFontHeight = long(nFontHeight * (double) aFractY);
										aTempSet.Put(SvxFontHeightItem(nFontHeight, 100, EE_CHAR_FONTHEIGHT_CTL));
									}

									// Bullet anpassen
									((SdStyleSheet*) pOutlineSheet)->AdjustToFontHeight(aTempSet, FALSE);

									// Sonderbehandlung: die INVALIDS auf NULL-Pointer
									// zurueckgesetzen (sonst landen INVALIDs oder
									// Pointer auf die DefaultItems in der Vorlage;
									// beides wuerde die Attribut-Vererbung unterbinden)
									aTempSet.ClearInvalidItems();

									// Sonderbehandlung: nur die gueltigen Anteile des
									// BulletItems
									if (aTempSet.GetItemState(EE_PARA_BULLET) == SFX_ITEM_AVAILABLE)
									{
										SvxBulletItem aOldBulItem((SvxBulletItem&) pOutlineSheet->GetItemSet().Get(EE_PARA_BULLET));
										SvxBulletItem& rNewBulItem = (SvxBulletItem&) aTempSet.Get(EE_PARA_BULLET);
										aOldBulItem.CopyValidProperties(rNewBulItem);
										aTempSet.Put(aOldBulItem);
									}

									pOutlineSheet->GetItemSet().Put(aTempSet);

									pOutlineSheet->Broadcast(SfxSimpleHint(SFX_HINT_DATACHANGED));
								}
							}
						}
						else if (pObj == GetPresObj(PRESOBJ_NOTES, nIndexNotes))
						{
							SfxStyleSheet* pNotesSheet = GetStyleSheetForPresObj(PRESOBJ_NOTES);

							if (pNotesSheet)
							{
								ULONG nHeight = pObj->GetLogicRect().GetSize().Height();
								ULONG nFontHeight = (ULONG) (nHeight * 0.0741);
								SfxItemSet& rSet = pNotesSheet->GetItemSet();
								rSet.Put( SvxFontHeightItem(nFontHeight, EE_CHAR_FONTHEIGHT ));
								rSet.Put( SvxFontHeightItem(nFontHeight, EE_CHAR_FONTHEIGHT_CJK ));
								rSet.Put( SvxFontHeightItem(nFontHeight, EE_CHAR_FONTHEIGHT_CTL ));
								pNotesSheet->Broadcast(SfxSimpleHint(SFX_HINT_DATACHANGED));
							}
						}
					}
					else if ( eObjKind != OBJ_TITLETEXT   &&
							  eObjKind != OBJ_OUTLINETEXT &&
							  pObj->ISA(SdrTextObj)       &&
							  pObj->GetOutlinerParaObject() )
					{
						/******************************************************
						* Normales Textobjekt: Texthoehe anpassen
						******************************************************/
						ULONG nScriptType = pObj->GetOutlinerParaObject()->GetTextObject().GetScriptType();
						USHORT nWhich = EE_CHAR_FONTHEIGHT;
						if ( nScriptType == SCRIPTTYPE_ASIAN )
							nWhich = EE_CHAR_FONTHEIGHT_CJK;
						else if ( nScriptType == SCRIPTTYPE_COMPLEX )
							nWhich = EE_CHAR_FONTHEIGHT_CTL;

						// #88084# use more modern method to scale the text height
						sal_uInt32 nFontHeight = ((SvxFontHeightItem&)pObj->GetMergedItem(nWhich)).GetHeight();
						sal_uInt32 nNewFontHeight = sal_uInt32((double)nFontHeight * (double)aFractY);
						
						pObj->SetMergedItem(SvxFontHeightItem(nNewFontHeight, 100, nWhich));
					}
				}
			}

			if (mbScaleObjects && !pObj->IsEdgeObj())
			{
				/**************************************************************
				* Objektposition skalieren
				**************************************************************/
				Point aNewPos;

				// #76447# corrected scaling; only distances may be scaled
				// #88084# use aTopLeft as original TopLeft
				aNewPos.X() = long((aTopLeft.X() - GetLftBorder()) * (double)aFractX) + nLeft;
				aNewPos.Y() = long((aTopLeft.Y() - GetUppBorder()) * (double)aFractY) + nUpper;

				Size aVec(aNewPos.X() - aTopLeft.X(), aNewPos.Y() - aTopLeft.Y());

				if (aVec.Height() != 0 || aVec.Width() != 0)
				{
					pObj->NbcMove(aVec);
				}

				Rectangle aBoundRect = pObj->GetCurrentBoundRect();

				if (!aBorderRect.IsInside(aBoundRect))
				{
					/**********************************************************
					* Objekt liegt nicht vollstaendig innerhalb der Raender
					* -> Position korrigieren
					**********************************************************/
					Point aOldPos(aBoundRect.TopLeft());
					aNewPos = aOldPos;

					// Position links oben ggf. korrigieren
					aNewPos.X() = Max(aNewPos.X(), aBorderRect.Left());
					aNewPos.Y() = Max(aNewPos.Y(), aBorderRect.Top());
					aVec = Size(aNewPos.X() - aOldPos.X(), aNewPos.Y() - aOldPos.Y());

					if (aVec.Height() != 0 || aVec.Width() != 0)
					{
						pObj->NbcMove(aVec);
					}

					// Position rechts unten ggf. korrigieren
					aOldPos = aBoundRect.BottomRight();
					aNewPos = aOldPos;
					aNewPos.X() = Min(aNewPos.X(), aBorderRect.Right());
					aNewPos.Y() = Min(aNewPos.Y(), aBorderRect.Bottom());
					aVec = Size(aNewPos.X() - aOldPos.X(), aNewPos.Y() - aOldPos.Y());

					if (aVec.Height() != 0 || aVec.Width() != 0)
					{
						pObj->NbcMove(aVec);
					}
				}

				pObj->SetChanged();
				pObj->BroadcastObjectChange();
			}
		}
	}
}

SdrObject* convertPresentationObjectImpl( SdPage& rPage, SdrObject* pSourceObj, PresObjKind eObjKind, bool bVertical, Rectangle aRect )
{
	SdDrawDocument* pModel = static_cast< SdDrawDocument* >( rPage.GetModel() );
	DBG_ASSERT( pModel, "sd::convertPresentationObjectImpl(), no model on page!" );
	if( !pModel || !pSourceObj )
		return pSourceObj;

	sd::UndoManager* pUndoManager = pModel ? static_cast<SdDrawDocument*>(pModel)->GetUndoManager() : 0;
	const bool bUndo = pUndoManager && pUndoManager->isInListAction() && rPage.IsInserted();

	SdrObject* pNewObj = pSourceObj;
	if((eObjKind == PRESOBJ_OUTLINE) && (pSourceObj->GetObjIdentifier() != OBJ_OUTLINETEXT) )
	{
		pNewObj = rPage.CreatePresObj(PRESOBJ_OUTLINE, bVertical, aRect);

		// Text des Untertitels in das PRESOBJ_OUTLINE setzen
		OutlinerParaObject* pOutlParaObj = pSourceObj->GetOutlinerParaObject();

		if(pOutlParaObj)
		{
			// Text umsetzen
			::sd::Outliner* pOutl = pModel->GetInternalOutliner( TRUE );
			pOutl->Clear();
			pOutl->SetText( *pOutlParaObj );
			pOutl->SetMinDepth(1, TRUE);
			pOutlParaObj = pOutl->CreateParaObject();
			pNewObj->SetOutlinerParaObject( pOutlParaObj );
			pOutl->Clear();
			pNewObj->SetEmptyPresObj(FALSE);

			for (USHORT nLevel = 1; nLevel < 10; nLevel++)
			{
				// Neue Vorlage zuweisen
				String aName(rPage.GetLayoutName());
				aName += sal_Unicode( ' ' );
				aName += String::CreateFromInt32( nLevel );
				SfxStyleSheet* pSheet = static_cast<SfxStyleSheet*>( pModel->GetStyleSheetPool()->Find(aName, SD_LT_FAMILY) );

				if (pSheet)
				{
					if (nLevel == 1)
					{
						SfxStyleSheet* pSubtitleSheet = rPage.GetStyleSheetForPresObj(PRESOBJ_TEXT);

						if (pSubtitleSheet)
							pOutlParaObj->ChangeStyleSheetName(SD_LT_FAMILY, pSubtitleSheet->GetName(),
																			pSheet->GetName());
					}

					pNewObj->StartListening(*pSheet);
				}
			}

			// LRSpace-Item loeschen
			SfxItemSet aSet(pModel->GetPool(), EE_PARA_LRSPACE, EE_PARA_LRSPACE );

			aSet.Put(pNewObj->GetMergedItemSet());

			aSet.ClearItem(EE_PARA_LRSPACE);

			pNewObj->SetMergedItemSet(aSet);

			if( bUndo )
				pUndoManager->AddUndoAction( pModel->GetSdrUndoFactory().CreateUndoDeleteObject(*pSourceObj) );

			// Remove outline shape from page
			rPage.RemoveObject( pSourceObj->GetOrdNum() );

			if( !bUndo )
				delete pSourceObj;
		}
	}
	else if((eObjKind == PRESOBJ_TEXT) && (pSourceObj->GetObjIdentifier() != OBJ_TEXT) )
	{
		// is there an outline shape we can use to replace empty subtitle shape?
		pNewObj = rPage.CreatePresObj(PRESOBJ_TEXT, bVertical, aRect);

		// Text des Gliederungsobjekts in das PRESOBJ_TITLE setzen
		OutlinerParaObject* pOutlParaObj = pSourceObj->GetOutlinerParaObject();

		if(pOutlParaObj)
		{
			// Text umsetzen
			::sd::Outliner* pOutl = pModel->GetInternalOutliner();
			pOutl->Clear();
			pOutl->SetText( *pOutlParaObj );
			pOutl->SetMinDepth(0, TRUE);
			pOutlParaObj = pOutl->CreateParaObject();
			pNewObj->SetOutlinerParaObject( pOutlParaObj );
			pOutl->Clear();
			pNewObj->SetEmptyPresObj(FALSE);

			// Linken Einzug zuruecksetzen
			SfxItemSet aSet(pModel->GetPool(), EE_PARA_LRSPACE, EE_PARA_LRSPACE );

			aSet.Put(pNewObj->GetMergedItemSet());

			const SvxLRSpaceItem& rLRItem = (const SvxLRSpaceItem&) aSet.Get(EE_PARA_LRSPACE);
			SvxLRSpaceItem aNewLRItem(rLRItem);
			aNewLRItem.SetTxtLeft(0);
			aSet.Put(aNewLRItem);

			pNewObj->SetMergedItemSet(aSet);

			SfxStyleSheet* pSheet = rPage.GetStyleSheetForPresObj(PRESOBJ_TEXT);
			if (pSheet)
				pNewObj->SetStyleSheet(pSheet, TRUE);

			// Remove subtitle shape from page
			if( bUndo )
				pUndoManager->AddUndoAction(pModel->GetSdrUndoFactory().CreateUndoDeleteObject(*pSourceObj));

			rPage.RemoveObject( pSourceObj->GetOrdNum() );

			if( !bUndo )
				delete pSourceObj;
		}
	}

	return pNewObj;
}

/** reuses or creates a presentation shape for an auto layout that fits the given parameter

	@param	eObjKind
		The kind of presentation shape we like to have
	@param	nIndex
		If > 1 we skip the first nIndex-1 shapes with the presentation shape kind eObjKind while
		looking for an existing presentation shape
	@param	bVertical
		If true, the shape is created vertical if bInit is true
	@param	aRect
		The rectangle that should be used to transform the shape
	@param	bInit
		If true the shape is created if not found
	@returns
		A presentation shape that was either found or created with the given parameters
*/
SdrObject* SdPage::InsertAutoLayoutShape( SdrObject* pObj, PresObjKind eObjKind, bool bVertical, Rectangle aRect, bool bInit )
{
	sd::UndoManager* pUndoManager = pModel ? static_cast<SdDrawDocument*>(pModel)->GetUndoManager() : 0;
	const bool bUndo = pUndoManager && pUndoManager->isInListAction() && IsInserted();

	if (!pObj && bInit)
	{
		pObj = CreatePresObj(eObjKind, bVertical, aRect);
	}
	else if ( pObj && (pObj->GetUserCall() || bInit) )
	{
		// convert object if shape type does not match kind (f.e. converting outline text to subtitle text)
		if( bInit )
			pObj = convertPresentationObjectImpl( *this, pObj, eObjKind, bVertical, aRect );

		if( bUndo )
		{
			pUndoManager->AddUndoAction( pModel->GetSdrUndoFactory().CreateUndoGeoObject( *pObj ) );
			pUndoManager->AddUndoAction( pModel->GetSdrUndoFactory().CreateUndoAttrObject( *pObj, TRUE, TRUE ) );
			pUndoManager->AddUndoAction( new UndoObjectUserCall( *pObj ) );
		}

		if ( pObj->ISA(SdrGrafObj) && !pObj->IsEmptyPresObj() )
			( (SdrGrafObj*) pObj)->AdjustToMaxRect( aRect, FALSE );
		else
			pObj->SetLogicRect(aRect);

		pObj->SetUserCall(this);

		SdrTextObj* pTextObject = dynamic_cast< SdrTextObj* >(pObj);
		if( pTextObject )
		{
			if( pTextObject->IsVerticalWriting() != (bVertical ? sal_True : sal_False) )
			{
				pTextObject->SetVerticalWriting( bVertical );

				// #94826# here make sure the correct anchoring is used when the object
				// is re-used but orientation is changed
				if(PRESOBJ_OUTLINE == eObjKind)
					pTextObject->SetMergedItem(SdrTextHorzAdjustItem( bVertical ? SDRTEXTHORZADJUST_RIGHT : SDRTEXTHORZADJUST_BLOCK ));
			}

			if( !bMaster )
			{
				if ( pTextObject->IsAutoGrowHeight() )
				{
					// switch off AutoGrowHeight, set new MinHeight
					SfxItemSet aTempAttr( ((SdDrawDocument*) pModel)->GetPool() );
					SdrTextMinFrameHeightItem aMinHeight( aRect.GetSize().Height() );
					aTempAttr.Put( aMinHeight );
					aTempAttr.Put( SdrTextAutoGrowHeightItem(FALSE) );
					pTextObject->SetMergedItemSet(aTempAttr);
					pTextObject->SetLogicRect(aRect);

					// switch on AutoGrowHeight
					SfxItemSet aAttr( ((SdDrawDocument*) pModel)->GetPool() );
					aAttr.Put( SdrTextAutoGrowHeightItem(TRUE) );

					pTextObject->SetMergedItemSet(aAttr);
				}

				if ( pTextObject->IsAutoGrowWidth() )
				{
					// switch off AutoGrowWidth , set new MinWidth
					SfxItemSet aTempAttr( ((SdDrawDocument*) pModel)->GetPool() );
					SdrTextMinFrameWidthItem aMinWidth( aRect.GetSize().Width() );
					aTempAttr.Put( aMinWidth );
					aTempAttr.Put( SdrTextAutoGrowWidthItem(FALSE) );
					pTextObject->SetMergedItemSet(aTempAttr);
					pTextObject->SetLogicRect(aRect);

					// switch on AutoGrowWidth
					SfxItemSet aAttr( ((SdDrawDocument*) pModel)->GetPool() );
					aAttr.Put( SdrTextAutoGrowWidthItem(TRUE) );
					pTextObject->SetMergedItemSet(aAttr);
				}
			}
		}
	}

	if(pObj && bInit )
	{
		if( !IsPresObj( pObj ) )
		{
			if( bUndo )
				pUndoManager->AddUndoAction( new UndoObjectPresentationKind( *pObj ) );

			InsertPresObj( pObj, eObjKind );
		}

		// make adjustments for vertical title and outline shapes
		if( bVertical && (( eObjKind == PRESOBJ_TITLE) || (eObjKind == PRESOBJ_OUTLINE)))
		{
			SfxItemSet aNewSet(pObj->GetMergedItemSet());
			aNewSet.Put( SdrTextAutoGrowWidthItem(TRUE) );
			aNewSet.Put( SdrTextAutoGrowHeightItem(FALSE) );
			if( eObjKind == PRESOBJ_OUTLINE )
			{
				aNewSet.Put( SdrTextVertAdjustItem(SDRTEXTVERTADJUST_TOP) );
				aNewSet.Put( SdrTextHorzAdjustItem(SDRTEXTHORZADJUST_RIGHT) );
			}
			pObj->SetMergedItemSet(aNewSet);
		}
	}

	return pObj;
}


/*************************************************************************
|*
|* Liefert den PresObjKind eines Objektes zurueck
|*
\************************************************************************/

PresObjKind SdPage::GetPresObjKind(SdrObject* pObj) const
{
	PresObjKind eKind = PRESOBJ_NONE;
	if( (pObj != 0) && (maPresentationShapeList.hasShape(*pObj)) )
	{
		SdAnimationInfo* pInfo = SdDrawDocument::GetShapeUserData(*pObj);
		if( pInfo )
			eKind = pInfo->mePresObjKind;
	}

	return eKind;
}

bool SdPage::IsPresObj(const SdrObject* pObj)
{
	return pObj && maPresentationShapeList.hasShape( const_cast<SdrObject&>(*pObj) );
}

void SdPage::RemovePresObj(const SdrObject* pObj)
{
	if( pObj && maPresentationShapeList.hasShape(const_cast<SdrObject&>(*pObj)) )
	{
		SdAnimationInfo* pInfo = SdDrawDocument::GetShapeUserData(const_cast<SdrObject&>(*pObj));
		if( pInfo )
			pInfo->mePresObjKind = PRESOBJ_NONE;
		maPresentationShapeList.removeShape(const_cast<SdrObject&>(*pObj));
	}
}

void SdPage::InsertPresObj(SdrObject* pObj, PresObjKind eKind )
{
	DBG_ASSERT( pObj, "sd::SdPage::InsertPresObj(), invalid presentation object inserted!" );
	DBG_ASSERT( !IsPresObj(pObj), "sd::SdPage::InsertPresObj(), presentation object inserted twice!" );
	if( pObj )
	{
		SdAnimationInfo* pInfo = SdDrawDocument::GetShapeUserData(*pObj, true);
		if( pInfo )
			pInfo->mePresObjKind = eKind;
		maPresentationShapeList.addShape(*pObj);
	}
}

/*************************************************************************
|*
|* Text des Objektes setzen
|*
\************************************************************************/

void SdPage::SetObjText(SdrTextObj* pObj, SdrOutliner* pOutliner, PresObjKind eObjKind,	const String& rString )
{
	if ( pObj )
	{
		DBG_ASSERT( pObj->ISA(SdrTextObj), "SetObjText: Kein SdrTextObj!" );
		::Outliner* pOutl = pOutliner;

		if (!pOutliner)
		{
			SfxItemPool* pPool = ((SdDrawDocument*) GetModel())->GetDrawOutliner().GetEmptyItemSet().GetPool();
			pOutl = new ::Outliner( pPool, OUTLINERMODE_OUTLINEOBJECT );
			pOutl->SetRefDevice( SD_MOD()->GetRefDevice( *( (SdDrawDocument*) GetModel() )->GetDocSh() ) );
			pOutl->SetEditTextObjectPool(pPool);
			pOutl->SetStyleSheetPool((SfxStyleSheetPool*)GetModel()->GetStyleSheetPool());
			pOutl->SetMinDepth(0);
			pOutl->EnableUndo(FALSE);
			pOutl->SetUpdateMode( FALSE );
		}

		USHORT nOutlMode = pOutl->GetMode();
		USHORT nMinDepth = pOutl->GetMinDepth();
		Size aPaperSize = pOutl->GetPaperSize();
		BOOL bUpdateMode = pOutl->GetUpdateMode();
		pOutl->SetUpdateMode(FALSE);
		pOutl->SetParaAttribs( 0, pOutl->GetEmptyItemSet() );

		// #95114# Always set the object's StyleSheet at the Outliner to
		// use the current objects StyleSheet. Thus it's the same as in
		// SetText(...).
		// #95114# Moved this implementation from where SetObjText(...) was called
		// to inside this method to work even when outliner is fetched here.
		pOutl->SetStyleSheet(0, pObj->GetStyleSheet());

		String aString;

		switch( eObjKind )
		{
			case PRESOBJ_OUTLINE:
			{
				pOutl->Init( OUTLINERMODE_OUTLINEOBJECT );
				pOutl->SetMinDepth(1);

				aString += sal_Unicode( '\t' );
				aString += rString;

				if (bMaster)
				{
					pOutl->SetStyleSheet( 0, GetStyleSheetForPresObj(eObjKind) );
					aString += String::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "\n\t\t" ));
					aString += String ( SdResId( STR_PRESOBJ_MPOUTLLAYER2 ) );

					aString += String::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "\n\t\t\t" ));
					aString += String ( SdResId( STR_PRESOBJ_MPOUTLLAYER3 ) );

					aString += String::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "\n\t\t\t\t" ));
					aString += String ( SdResId( STR_PRESOBJ_MPOUTLLAYER4 ) );

					aString += String::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "\n\t\t\t\t\t" ));
					aString += String ( SdResId( STR_PRESOBJ_MPOUTLLAYER5 ) );

					aString += String::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "\n\t\t\t\t\t\t" ));
					aString += String ( SdResId( STR_PRESOBJ_MPOUTLLAYER6 ) );

					aString += String::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "\n\t\t\t\t\t\t\t" ));
					aString += String ( SdResId( STR_PRESOBJ_MPOUTLLAYER7 ) );

					aString += String::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "\n\t\t\t\t\t\t\t\t" ));
					aString += String ( SdResId( STR_PRESOBJ_MPOUTLLAYER8 ) );

					aString += String::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "\n\t\t\t\t\t\t\t\t\t" ));
					aString += String ( SdResId( STR_PRESOBJ_MPOUTLLAYER9 ) );
				}
			}
			break;

			case PRESOBJ_TITLE:
			{
				pOutl->Init( OUTLINERMODE_TITLEOBJECT );
				pOutl->SetMinDepth(0);
				aString += rString;
			}
			break;

			default:
			{
				pOutl->Init( OUTLINERMODE_TEXTOBJECT );
				pOutl->SetMinDepth(0);
				aString += rString;

				// check if we need to add a text field
				SvxFieldData* pData = NULL;

				switch( eObjKind )
				{
				case PRESOBJ_HEADER:
					pData = new SvxHeaderField();
					break;
				case PRESOBJ_FOOTER:
					pData = new SvxFooterField();
					break;
				case PRESOBJ_SLIDENUMBER:
					pData = new SvxPageField();
					break;
				case PRESOBJ_DATETIME:
					pData = new SvxDateTimeField();
					break;
				default:
					break;
				}

				if( pData )
				{
					ESelection e;
					SvxFieldItem aField( *pData );
					pOutl->QuickInsertField(aField,e);
					delete pData;
				}
			}
			break;
		}

		pOutl->SetPaperSize( pObj->GetLogicRect().GetSize() );

		if( aString.Len() )
			pOutl->SetText( aString, pOutl->GetParagraph( 0 ) );

		// MT: Wird nicht gebraucht...
		// pOutl->SetUpdateMode(TRUE);

		( (SdrTextObj*) pObj)->SetOutlinerParaObject( pOutl->CreateParaObject() );

		if (!pOutliner)
		{
			delete pOutl;
			pOutl = NULL;
		}
		else
		{
			// Outliner restaurieren
			pOutl->Init( nOutlMode );
			pOutl->SetParaAttribs( 0, pOutl->GetEmptyItemSet() );
			pOutl->SetUpdateMode( bUpdateMode );
			pOutl->SetMinDepth( nMinDepth );
			pOutl->SetPaperSize( aPaperSize );
		}
	}
}

/*************************************************************************
|*
|* Link & Daten von einem VControl empfangen
|*
\************************************************************************/

void SdPage::SetLinkData(const String&, const String& )
{
}

/*************************************************************************
|*
|* Layoutname setzen
|*
\************************************************************************/
void SdPage::SetLayoutName(String aName)
{
	maLayoutName = aName;

	if( bMaster )
	{
		String aSep( RTL_CONSTASCII_USTRINGPARAM(SD_LT_SEPARATOR) );
		USHORT nPos = maLayoutName.Search( aSep );
		if ( nPos != STRING_NOTFOUND )
		{
            FmFormPage::SetName(maLayoutName.Copy(0, nPos));
		}
	}
}


/*************************************************************************
|*
|* Seitenname zurueckgeben und ggf. generieren
|*
\************************************************************************/

const String& SdPage::GetName() const
{
	String aCreatedPageName( maCreatedPageName );
	if (GetRealName().Len() == 0)
	{
		if ((mePageKind == PK_STANDARD || mePageKind == PK_NOTES) && !bMaster)
		{
			// default name for handout pages
			USHORT	nNum = (GetPageNum() + 1) / 2;

			aCreatedPageName = String(SdResId(STR_PAGE));
			aCreatedPageName += sal_Unicode( ' ' );
			if( GetModel()->GetPageNumType() == SVX_NUMBER_NONE )
			{
				// if the document has number none as a formating
				// for page numbers we still default to arabic numbering
				// to keep the default page names unique
				aCreatedPageName += String::CreateFromInt32( (sal_Int32)nNum );
			}
			else
			{
				aCreatedPageName += ((SdDrawDocument*) GetModel())->CreatePageNumValue(nNum);
			}
		}
		else
		{
			/******************************************************************
			* Defaultname fuer Handzettelseiten
			******************************************************************/
			aCreatedPageName = String(SdResId(STR_LAYOUT_DEFAULT_NAME));
		}
	}
	else
	{
		aCreatedPageName = GetRealName();
	}

	if (mePageKind == PK_NOTES)
	{
		aCreatedPageName += sal_Unicode( ' ' );
		aCreatedPageName += String(SdResId(STR_NOTES));
	}
	else if (mePageKind == PK_HANDOUT && bMaster)
	{
		aCreatedPageName += String::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( " (" ));
		aCreatedPageName += String(SdResId(STR_HANDOUT));
		aCreatedPageName += sal_Unicode( ')' );
	}

	const_cast< SdPage* >(this)->maCreatedPageName = aCreatedPageName;
	return maCreatedPageName;
}


/*************************************************************************
|*
|*
|*
\************************************************************************/

void SdPage::AdjustBackgroundSize()
{
	SdrObject* pObj = GetPresObj(PRESOBJ_BACKGROUND);

	if (pObj)
	{
		// Hintergrund-Objekt verschieben
		pObj->SetMoveProtect(FALSE);
		pObj->SetResizeProtect(FALSE);

		{
			sd::ScopeLockGuard aGuard( maLockAutoLayoutArrangement );

			Point aBackgroundPos;
			Size aBackgroundSize( GetSize() );

			if( !mbBackgroundFullSize )
			{
				aBackgroundPos = Point( GetLftBorder(), GetUppBorder() );
				aBackgroundSize.Width()  -= GetLftBorder() + GetRgtBorder() - 1;
				aBackgroundSize.Height() -= GetUppBorder() + GetLwrBorder() - 1;
			}
			Rectangle aBackgroundRect (aBackgroundPos, aBackgroundSize);
			pObj->SetLogicRect(aBackgroundRect);
		}
		pObj->SetMoveProtect(TRUE);
		pObj->SetResizeProtect(TRUE);
	}
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SdPage::SetOrientation( Orientation eOrient)
{
	meOrientation = eOrient;
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

Orientation SdPage::GetOrientation() const
{
	return meOrientation;
}

/*************************************************************************
|*
|* Liefert den Default-Text eines PresObjektes zurueck
|*
\************************************************************************/

String SdPage::GetPresObjText(PresObjKind eObjKind) const
{
	String aString;

	if (eObjKind == PRESOBJ_TITLE)
	{
		if (bMaster)
		{
			if (mePageKind != PK_NOTES)
			{
				aString = String ( SdResId( STR_PRESOBJ_MPTITLE ) );
			}
			else
			{
				aString = String ( SdResId( STR_PRESOBJ_MPNOTESTITLE ) );
			}
		}
		else
		{
			aString = String ( SdResId( STR_PRESOBJ_TITLE ) );
		}
	}
	else if (eObjKind == PRESOBJ_OUTLINE)
	{
		if (bMaster)
		{
			aString = String ( SdResId( STR_PRESOBJ_MPOUTLINE ) );
		}
		else
		{
			aString = String ( SdResId( STR_PRESOBJ_OUTLINE ) );
		}
	}
	else if (eObjKind == PRESOBJ_NOTES)
	{
		if (bMaster)
		{
			aString = String ( SdResId( STR_PRESOBJ_MPNOTESTEXT ) );
		}
		else
		{
			aString = String ( SdResId( STR_PRESOBJ_NOTESTEXT ) );
		}
	}
	else if (eObjKind == PRESOBJ_TEXT)
	{
		aString = String ( SdResId( STR_PRESOBJ_TEXT ) );
	}
	else if (eObjKind == PRESOBJ_GRAPHIC)
	{
		aString = String ( SdResId( STR_PRESOBJ_GRAPHIC ) );
	}
	else if (eObjKind == PRESOBJ_OBJECT)
	{
		aString = String ( SdResId( STR_PRESOBJ_OBJECT ) );
	}
	else if (eObjKind == PRESOBJ_CHART)
	{
		aString = String ( SdResId( STR_PRESOBJ_CHART ) );
	}
	else if (eObjKind == PRESOBJ_ORGCHART)
	{
		aString = String ( SdResId( STR_PRESOBJ_ORGCHART ) );
	}
	else if (eObjKind == PRESOBJ_TABLE)
	{
		aString = String ( SdResId( STR_PRESOBJ_TABLE ) );
	}

	return(aString);
}

extern uno::Reference< uno::XInterface > createUnoPageImpl( SdPage* pPage );

uno::Reference< uno::XInterface > SdPage::createUnoPage()
{
	return createUnoPageImpl( this );
}

/** returns the SdPage implementation for the given XDrawPage or 0 if not available */
SdPage* SdPage::getImplementation( const ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XDrawPage >& xPage )
{
	try
	{
	    ::com::sun::star::uno::Reference< ::com::sun::star::lang::XUnoTunnel > xUnoTunnel( xPage, ::com::sun::star::uno::UNO_QUERY );
		if( xUnoTunnel.is() )
		{
			SvxDrawPage* pUnoPage = reinterpret_cast<SvxDrawPage*>(sal::static_int_cast<sal_uIntPtr>(xUnoTunnel->getSomething( SvxDrawPage::getUnoTunnelId()) ) );
			if( pUnoPage )
				return static_cast< SdPage* >( pUnoPage->GetSdrPage() );
		}
	}
	catch( ::com::sun::star::uno::Exception& e )
	{
		(void)e;
		DBG_ERROR("sd::SdPage::getImplementation(), exception cathced!" );
	}

	return 0;
}

void SdPage::SetName (const String& rName)
{
    FmFormPage::SetName (rName);
    ActionChanged();
}

const HeaderFooterSettings& SdPage::getHeaderFooterSettings() const
{
	if( mePageKind == PK_HANDOUT && !bMaster )
	{
		return (((SdPage&)TRG_GetMasterPage()).maHeaderFooterSettings);
	}
	else
	{
		return maHeaderFooterSettings;
	}
}

void SdPage::setHeaderFooterSettings( const sd::HeaderFooterSettings& rNewSettings )
{
	if( mePageKind == PK_HANDOUT && !bMaster )
	{
		(((SdPage&)TRG_GetMasterPage()).maHeaderFooterSettings) = rNewSettings;
	}
	else
	{
		maHeaderFooterSettings = rNewSettings;
	}

	SetChanged();
	if(TRG_HasMasterPage())
	{
		TRG_GetMasterPageDescriptorViewContact().ActionChanged();
	}
}

bool SdPage::checkVisibility(
	::sdr::contact::ViewObjectContact& rOriginal, 
	::sdr::contact::DisplayInfo& rDisplayInfo, 
	bool bEdit )
{
	if( !FmFormPage::checkVisibility( rOriginal, rDisplayInfo, bEdit ) )
		return false;

	SdrObject* pObj = rOriginal.GetViewContact().TryToGetSdrObject();
	if( pObj == NULL )
		return false;

	const bool bIsPrinting(rDisplayInfo.OutputToPrinter());
	const SdrPageView* pPageView = rDisplayInfo.GetPageView();
	const bool bIsInsidePageObj(pPageView && pPageView->GetPage() != rDisplayInfo.GetProcessedPage());

	// empty presentation objects only visible during edit mode
	if( (bIsPrinting || !bEdit || bIsInsidePageObj ) && pObj->IsEmptyPresObj() )
	{
		if( (pObj->GetObjInventor() != SdrInventor) || ( (pObj->GetObjIdentifier() != OBJ_RECT) && (pObj->GetObjIdentifier() != OBJ_PAGE) ) )
			return false;
	}

	if( ( pObj->GetObjInventor() == SdrInventor ) && ( pObj->GetObjIdentifier() == OBJ_TEXT ) )
	{
		SdPage* pCheckPage = (SdPage*)pObj->GetPage();
		if( pCheckPage )
		{
			PresObjKind eKind = pCheckPage->GetPresObjKind(pObj);

			if((eKind == PRESOBJ_FOOTER) || (eKind == PRESOBJ_HEADER) || (eKind == PRESOBJ_DATETIME) || (eKind == PRESOBJ_SLIDENUMBER) )
			{
				const bool bMasterObj(rDisplayInfo.GetMasterPagePainting());
				if( bMasterObj || ( pCheckPage->GetPageKind() == PK_HANDOUT && bIsPrinting ) )
				{
					// get the page that is currently painted
					SdPage* pPaintPage = (SdPage*)rDisplayInfo.GetProcessedPage();

					if( pPaintPage )
					{
						// if we are not on a masterpage, see if we have to draw this header&footer object at all
						const sd::HeaderFooterSettings& rSettings = pPaintPage->getHeaderFooterSettings();

						switch( eKind )
						{
						case PRESOBJ_FOOTER:
							return rSettings.mbFooterVisible;
						case PRESOBJ_HEADER:
							return rSettings.mbHeaderVisible;
						case PRESOBJ_DATETIME:
							return rSettings.mbDateTimeVisible;
						case PRESOBJ_SLIDENUMBER:
							return rSettings.mbSlideNumberVisible;
						default:
							break;
						}
					}
				}
			}
		}
	}
	return true;
}

bool SdPage::RestoreDefaultText( SdrObject* pObj )
{
	bool bRet = false;

	SdrTextObj* pTextObj = dynamic_cast< SdrTextObj* >( pObj );

	if( pTextObj )
	{
		PresObjKind ePresObjKind = GetPresObjKind(pTextObj);

		if (ePresObjKind == PRESOBJ_TITLE   ||
			ePresObjKind == PRESOBJ_OUTLINE ||
			ePresObjKind == PRESOBJ_NOTES   ||
			ePresObjKind == PRESOBJ_TEXT)
		{
			String aString( GetPresObjText(ePresObjKind) );

			if (aString.Len())
			{
				BOOL bVertical = FALSE;
				OutlinerParaObject* pOldPara = pTextObj->GetOutlinerParaObject();
				if( pOldPara )
					bVertical = pOldPara->IsVertical();  // is old para object vertical?

				SetObjText( pTextObj, 0, ePresObjKind, aString );

				if( pOldPara )
				{
					//pTextObj->SetVerticalWriting( bVertical );
					//
					// #94826# Here, only the vertical flag for the
					// OutlinerParaObjects needs to be changed. The
					// AutoGrowWidth/Height items still exist in the
					// not changed object.
					if(pTextObj
						&& pTextObj->GetOutlinerParaObject()
						&& pTextObj->GetOutlinerParaObject()->IsVertical() != bVertical)
					{
						Rectangle aObjectRect = pTextObj->GetSnapRect();
						pTextObj->GetOutlinerParaObject()->SetVertical(bVertical);
						pTextObj->SetSnapRect(aObjectRect);
					}
				}

				pTextObj->SetTextEditOutliner( NULL );  // to make stylesheet settings work
				pTextObj->NbcSetStyleSheet( GetStyleSheetForPresObj(ePresObjKind), TRUE );
				pTextObj->SetEmptyPresObj(TRUE);
				bRet = true;
			}
		}
	}
	return bRet;
}

HeaderFooterSettings::HeaderFooterSettings()
{
	mbHeaderVisible = true;
	mbFooterVisible = true;
	mbSlideNumberVisible = false;
	mbDateTimeVisible = true;
	mbDateTimeIsFixed = true;
	meDateTimeFormat = SVXDATEFORMAT_A;
}

bool HeaderFooterSettings::operator==( const HeaderFooterSettings& rSettings ) const
{
	return (mbHeaderVisible == rSettings.mbHeaderVisible) &&
		   (maHeaderText == rSettings.maHeaderText) &&
		   (mbFooterVisible == rSettings.mbFooterVisible) &&
		   (maFooterText == rSettings.maFooterText) &&
		   (mbSlideNumberVisible == rSettings.mbSlideNumberVisible) &&
		   (mbDateTimeVisible == rSettings.mbDateTimeVisible) &&
		   (mbDateTimeIsFixed == rSettings.mbDateTimeIsFixed) &&
		   (meDateTimeFormat == rSettings.meDateTimeFormat) &&
		   (maDateTimeText == rSettings.maDateTimeText);
}

