/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: offmgr_fontsubstconfig.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 14:10:40 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

#ifndef _OFA_FONTSUBSTCONFIG_HXX
#include <fontsubstconfig.hxx>
#endif
#ifndef _SVARRAY_HXX //autogen
#include <svtools/svarray.hxx>
#endif

#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
namespace binfilter {

using namespace utl;
using namespace rtl;
using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;

#define C2U(cChar) OUString::createFromAscii(cChar)

const sal_Char cReplacement[] = "Replacement";
const sal_Char cFontPairs[] = "FontPairs";

const sal_Char cReplaceFont[] 	= "ReplaceFont";
const sal_Char cSubstituteFont[]= "SubstituteFont";
const sal_Char cOnScreenOnly[] 	= "OnScreenOnly";
const sal_Char cAlways[] 		= "Always";

//-----------------------------------------------------------------------------
typedef SubstitutionStruct* SubstitutionStructPtr;
/*N*/ SV_DECL_PTRARR_DEL(SubstitutionStructArr, SubstitutionStructPtr, 2, 2)//STRIP008 ;
/*N*/ SV_IMPL_PTRARR(SubstitutionStructArr, SubstitutionStructPtr);
//-----------------------------------------------------------------------------
/*N*/ struct OfaFontSubstConfig_Impl
/*N*/ {
/*N*/ 	SubstitutionStructArr	aSubstArr;
/*N*/ };
/* -----------------------------18.01.01 12:04--------------------------------

 ---------------------------------------------------------------------------*/
/*N*/ OfaFontSubstConfig::OfaFontSubstConfig() :
/*N*/ 	ConfigItem(C2U("Office.Common/Font/Substitution")),
/*N*/ 	bIsEnabled(sal_False),
/*N*/ 	pImpl(new OfaFontSubstConfig_Impl)
/*N*/ {
/*N*/ 	Sequence<OUString> aNames(1);
/*N*/ 	aNames.getArray()[0] = C2U(cReplacement);
/*N*/ 	Sequence<Any> aValues = GetProperties(aNames);
/*N*/ 	DBG_ASSERT(aValues.getConstArray()[0].hasValue(), "no value available");
/*N*/ 	if(aValues.getConstArray()[0].hasValue())
/*N*/ 		bIsEnabled = *(sal_Bool*)aValues.getConstArray()[0].getValue();
/*N*/ 
/*N*/ 	OUString sPropPrefix(C2U(cFontPairs));
/*N*/ 	Sequence<OUString> aNodeNames = GetNodeNames(sPropPrefix);
/*N*/ 	const OUString* pNodeNames = aNodeNames.getConstArray();
/*N*/ 	Sequence<OUString> aPropNames(aNodeNames.getLength() * 4);
/*N*/ 	OUString* pNames = aPropNames.getArray();
/*N*/ 	sal_Int32 nName = 0;
/*N*/ 	sPropPrefix += C2U("/");
/*N*/ 	sal_Int32 nNode;
/*N*/ 	for(nNode = 0; nNode < aNodeNames.getLength(); nNode++)
/*N*/ 	{
/*?*/ 		OUString sStart(sPropPrefix);
/*?*/ 		sStart += pNodeNames[nNode];
/*?*/ 		sStart += C2U("/");
/*?*/ 		pNames[nName] = sStart; 	pNames[nName++] += C2U(cReplaceFont);
/*?*/ 		pNames[nName] = sStart; 	pNames[nName++] += C2U(cSubstituteFont);
/*?*/ 		pNames[nName] = sStart; 	pNames[nName++] += C2U(cAlways);
/*?*/ 		pNames[nName] = sStart; 	pNames[nName++] += C2U(cOnScreenOnly);
/*N*/ 	}
/*N*/ 	Sequence<Any> aNodeValues = GetProperties(aPropNames);
/*N*/ 	const Any* pNodeValues = aNodeValues.getConstArray();
/*N*/ 	nName = 0;
/*N*/ 	for(nNode = 0; nNode < aNodeNames.getLength(); nNode++)
/*N*/ 	{
/*?*/ 		SubstitutionStructPtr pInsert = new SubstitutionStruct;
/*?*/ 		pNodeValues[nName++] >>= pInsert->sFont;
/*?*/ 		pNodeValues[nName++] >>= pInsert->sReplaceBy;
/*?*/ 		pInsert->bReplaceAlways = *(sal_Bool*)pNodeValues[nName++].getValue();
/*?*/ 		pInsert->bReplaceOnScreenOnly = *(sal_Bool*)pNodeValues[nName++].getValue();
/*?*/ 		pImpl->aSubstArr.Insert(pInsert, pImpl->aSubstArr.Count());
/*N*/ 	}
/*N*/ }
/* -----------------------------18.01.01 12:06--------------------------------

 ---------------------------------------------------------------------------*/
/*N*/ OfaFontSubstConfig::~OfaFontSubstConfig()
/*N*/ {
/*N*/ 	delete pImpl;
/*N*/ }
/*-- 18.01.01 12:08:00---------------------------------------------------

  -----------------------------------------------------------------------*/
/*-- 18.01.01 12:08:00---------------------------------------------------

  -----------------------------------------------------------------------*/
/*N*/sal_Int32 OfaFontSubstConfig::SubstitutionCount() const
/*N*/{
/*N*/	return pImpl->aSubstArr.Count();
/*N*/}
/*-- 18.01.01 12:08:00---------------------------------------------------

  -----------------------------------------------------------------------*/
/*-- 18.01.01 12:08:00---------------------------------------------------

  -----------------------------------------------------------------------*/
/*-- 18.01.01 12:08:01---------------------------------------------------

  -----------------------------------------------------------------------*/


}
