/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_undobase.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 16:58:26 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------


#include "undobase.hxx"
#include "docsh.hxx"
#include "undoolk.hxx"
#include "undodraw.hxx"
namespace binfilter {

// STATIC DATA -----------------------------------------------------------


// -----------------------------------------------------------------------

/*N*/ ScSimpleUndo::ScSimpleUndo( ScDocShell* pDocSh ) :
/*N*/ 	pDocShell( pDocSh ),
/*N*/ 	pDetectiveUndo( NULL )
/*N*/ {
/*N*/ }

/*N*/ __EXPORT ScSimpleUndo::~ScSimpleUndo()
/*N*/ {
/*N*/ 	delete pDetectiveUndo;
/*N*/ }

/*N*/ BOOL __EXPORT ScSimpleUndo::Merge( SfxUndoAction *pNextAction )
/*N*/ {
/*N*/ 	//	Zu jeder Undo-Action kann eine SdrUndoGroup fuer das Aktualisieren
/*N*/ 	//	der Detektiv-Pfeile gehoeren.
/*N*/ 	//	DetectiveRefresh kommt immer hinterher, die SdrUndoGroup ist in
/*N*/ 	//	eine ScUndoDraw Action verpackt.
/*N*/ 	//	Nur beim automatischen Aktualisieren wird AddUndoAction mit
/*N*/ 	//	bTryMerg=TRUE gerufen.
/*N*/ 
/*N*/ 	if ( !pDetectiveUndo && pNextAction->ISA(ScUndoDraw) )
/*N*/ 	{
/*N*/ 		//	SdrUndoAction aus der ScUndoDraw Action uebernehmen,
/*N*/ 		//	ScUndoDraw wird dann vom UndoManager geloescht
/*N*/ 
/*N*/ 		ScUndoDraw* pCalcUndo = (ScUndoDraw*)pNextAction;
/*N*/ 		pDetectiveUndo = pCalcUndo->GetDrawUndo();
/*N*/ 		pCalcUndo->ForgetDrawUndo();
/*N*/ 		return TRUE;
/*N*/ 	}
/*N*/ 
/*N*/ 	return FALSE;
/*N*/ }








// -----------------------------------------------------------------------

/*N*/ ScBlockUndo::ScBlockUndo( ScDocShell* pDocSh, const ScRange& rRange,
/*N*/ 											ScBlockUndoMode eBlockMode ) :
/*N*/ 	ScSimpleUndo( pDocSh ),
/*N*/ 	aBlockRange( rRange ),
/*N*/ 	eMode( eBlockMode )
/*N*/ {
/*N*/ 	pDrawUndo = GetSdrUndoAction( pDocShell->GetDocument() );
/*N*/ }

/*N*/ __EXPORT ScBlockUndo::~ScBlockUndo()
/*N*/ {
/*N*/ 	DeleteSdrUndoAction( pDrawUndo );
/*N*/ }



/*
void ScBlockUndo::BeginRedo()
{
	ScSimpleUndo::BeginRedo();
}
*/





// -----------------------------------------------------------------------






/*
void ScMoveUndo::BeginRedo()
{
	ScSimpleUndo::BeginRedo();
}
*/

/*
void ScMoveUndo::EndRedo()
{
	ScSimpleUndo::EndRedo();
}
*/

// -----------------------------------------------------------------------















}
