/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_gridwin.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 17:10:41 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#endif

#pragma hdrstop

//------------------------------------------------------------------

//SV
//#define _CLIP_HXX
#define _CONFIG_HXX
#define _CURSOR_HXX
#define _FONTDLG_HXX
#define _PRVWIN_HXX

//svdraw.hxx
#define _SDR_NOITEMS
#define _SDR_NOTOUCH
#define _SDR_NOTRANSFORM
//#define _SDR_NOOBJECTS
//#define _SDR_NOVIEWS


// INCLUDE ---------------------------------------------------------------

#include "scitems.hxx"
#define ITEMID_FIELD EE_FEATURE_FIELD

#include <bf_svx/adjitem.hxx>
#include <bf_svx/dbexch.hrc>



#ifndef _SVX_ITEMDATA_HXX
#include <bf_svx/itemdata.hxx>
#endif

#ifndef _DATE_HXX
#include <tools/date.hxx>
#endif

#ifndef _TOOLS_TIME_HXX
#include <tools/time.hxx>
#endif

#include <svtools/svtabbx.hxx>
//#include <vcl/system.hxx>



#include "gridwin.hxx"
#include "tabvwsh.hxx"
#include "scmod.hxx"
#include "document.hxx"
#include "bf_sc.hrc"
#include "globstr.hrc"
#include <vcl/floatwin.hxx>
#include "notemark.hxx"
#ifdef AUTOFILTER_POPUP
#endif
namespace binfilter {

using namespace ::com::sun::star;

#define SC_AUTOFILTER_ALL		0
#define	SC_AUTOFILTER_CUSTOM	1
#define	SC_AUTOFILTER_TOP10		2

//	Modi fuer die FilterListBox
enum ScFilterBoxMode
{
	SC_FILTERBOX_FILTER,
	SC_FILTERBOX_DATASELECT,
	SC_FILTERBOX_SCENARIO
};

extern SfxViewShell* pScActiveViewShell;			// global.cxx
extern USHORT nScClickMouseModifier;				// global.cxx
extern USHORT nScFillModeMouseModifier;				// global.cxx

#define SC_FILTERLISTBOX_LINES	12

// STATIC DATA -----------------------------------------------------------

static long nFilterBoxTabs[] =
	{ 	1, // Number of Tabs
		0
	};

//==================================================================

/*
 * Der Autofilter wird auf dem Mac per AutoFilterPopup realisiert.
 * Die AutoFilterListBox wird trotzdem fuer die Auswahlliste gebraucht.
 */

//==================================================================
class ScFilterListBox : public SvTabListBox
{

public:
				ScFilterListBox( Window* pParent, ScGridWindow* pGrid,
					USHORT nNewCol, USHORT nNewRow, ScFilterBoxMode eNewMode );
};

//-------------------------------------------------------------------

//	ListBox in einem FloatingWindow (pParent)
ScFilterListBox::ScFilterListBox( Window* pParent, ScGridWindow* pGrid,
									USHORT nNewCol, USHORT nNewRow, ScFilterBoxMode eNewMode ) :
	SvTabListBox( pParent, WinBits(0) )//STRIP001 	SvTabListBox( pParent, WinBits(0) ),	// ohne Border
{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
}





// use a System floating window for the above filter listbox
   


#ifdef AUTOFILTER_POPUP

//==================================================================
class AutoFilterPopup : public PopupMenu
{
public:
		AutoFilterPopup( ScGridWindow* _pWin, USHORT _nCol, USHORT _nRow, BOOL bDatSel )
			:	pWin( _pWin ),
				nCol( _nCol ),
				nRow( _nRow ),
				bIsDataSelect( bDatSel ),
				bSelected( FALSE )			{DBG_BF_ASSERT(0, "STRIP");}

};

//-------------------------------------------------------------------



#endif // #ifdef AUTOFILTER_POPUP

//==================================================================


//==================================================================

//	WB_DIALOGCONTROL noetig fuer UNO-Controls
/*N*/ ScGridWindow::ScGridWindow( Window* pParent, ScViewData* pData, ScSplitPos eWhichPos ) :
/*N*/ 			Window( pParent, WB_CLIPCHILDREN | WB_DIALOGCONTROL ),
/*N*/ 			DropTargetHelper( this ),
/*N*/ 			DragSourceHelper( this ),
/*N*/ 			pViewData( pData ),
/*N*/ 			eWhich( eWhichPos ),
/*N*/ 			pNoteMarker( NULL ),
/*N*/ 			nCursorHideCount( 0 ),
/*N*/ 			bMarking( FALSE ),
/*N*/ 			bEEMouse( FALSE ),
/*N*/ 			nButtonDown( 0 ),
/*N*/ 			nMouseStatus( SC_GM_NONE ),
/*N*/ 			bPivotMouse( FALSE ),
/*N*/ 			bDPMouse( FALSE ),
/*N*/ 			bRFMouse( FALSE ),
/*N*/ 			nPagebreakMouse( SC_PD_NONE ),
/*N*/ 			nPageScript( 0 ),
/*N*/ 			bDragRect( FALSE ),
/*N*/ 			pFilterBox( NULL ),
/*N*/ 			pFilterFloat( NULL ),
/*N*/ 			nCurrentPointer( 0 ),
/*N*/ 			bIsInScroll( FALSE ),
/*N*/ 			bIsInPaint( FALSE ),
/*N*/ 			aComboButton( this ),
/*N*/ 			aCurMousePos( 0,0 ),
/*N*/ 			nPaintCount( 0 ),
/*N*/ 			bNeedsRepaint( FALSE ),
/*N*/ 			bAutoMarkVisible( FALSE )
/*N*/ {
/*N*/ 	switch(eWhich)
/*N*/ 	{
/*N*/ 		case SC_SPLIT_TOPLEFT:
/*N*/ 			eHWhich = SC_SPLIT_LEFT;
/*N*/ 			eVWhich = SC_SPLIT_TOP;
/*N*/ 			break;
/*N*/ 		case SC_SPLIT_TOPRIGHT:
/*N*/ 			eHWhich = SC_SPLIT_RIGHT;
/*N*/ 			eVWhich = SC_SPLIT_TOP;
/*N*/ 			break;
/*N*/ 		case SC_SPLIT_BOTTOMLEFT:
/*N*/ 			eHWhich = SC_SPLIT_LEFT;
/*N*/ 			eVWhich = SC_SPLIT_BOTTOM;
/*N*/ 			break;
/*N*/ 		case SC_SPLIT_BOTTOMRIGHT:
/*N*/ 			eHWhich = SC_SPLIT_RIGHT;
/*N*/ 			eVWhich = SC_SPLIT_BOTTOM;
/*N*/ 			break;
/*N*/ 		default:
/*N*/ 			DBG_ERROR("GridWindow: falsche Position");
/*N*/ 	}
/*N*/ 
/*N*/ 	SetBackground();
/*N*/ 
/*N*/ 	SetMapMode(pViewData->GetLogicMode(eWhich));
/*N*/ //	EnableDrop();
/*N*/ 	EnableChildTransparentMode();
/*N*/ 	SetDialogControlFlags( WINDOW_DLGCTRL_RETURN | WINDOW_DLGCTRL_WANTFOCUS );
/*N*/ 
/*N*/ 	SetHelpId( HID_SC_WIN_GRIDWIN );
/*N*/ 	SetUniqueId( HID_SC_WIN_GRIDWIN );
/*N*/ 
/*N*/ 	SetDigitLanguage( SC_MOD()->GetOptDigitLanguage() );
/*N*/ }

/*N*/ __EXPORT ScGridWindow::~ScGridWindow()
/*N*/ {
/*N*/ 	delete pFilterBox;
/*N*/ 	if (pFilterFloat)
/*?*/ 		pFilterFloat->EndPopupMode();
/*N*/ 	delete pFilterFloat;
/*N*/ 	delete pNoteMarker;
/*N*/ }


/*N*/ void ScGridWindow::ClickExtern()
/*N*/ {
/*N*/ 	DELETEZ(pFilterBox);
/*N*/ 	if (pFilterFloat)
/*?*/ 		pFilterFloat->EndPopupMode();
/*N*/ 	DELETEZ(pFilterFloat);
/*N*/ }




	/*
	 * Standard-Variante mit TreeListBox
	 */


#ifdef AUTOFILTER_POPUP

	/*
	 * Macintosh-Variante mit Popup-Menue
	 */


#endif // #ifdef AUTOFILTER_POPUP
















/*N*/ void ScGridWindow::StopMarking()
/*N*/ {
/*N*/ 	DrawEndAction();				// Markieren/Verschieben auf Drawing-Layer abbrechen
/*N*/ 
/*N*/ 	if (nButtonDown)
/*N*/ 	{
/*?*/ 		pViewData->GetMarkData().SetMarking(FALSE);
/*?*/ 		nMouseStatus = SC_GM_IGNORE;
/*N*/ 	}
/*N*/ }


//--------------------------------------------------------

								// sensitiver Bereich (Pixel)
#define SCROLL_SENSITIVE 20

/*	doch auch auf nicht aktiven Views...
	if ( !pViewData->IsActive() )
		return FALSE;
*/



//--------------------------------------------------------

extern BOOL bPasteIsDrop;		// viewfun4 -> move to header
extern BOOL bPasteIsMove;		// viewfun7 -> move to header

//--------------------------------------------------------









//--------------------------------------------------------


//--------------------------------------------------------



// 	Formeln neu zeichnen -------------------------------------------------

/*N*/ void ScGridWindow::UpdateFormulas()
/*N*/ {
/*N*/ 	if (pViewData->GetView()->IsMinimized())
/*N*/ 		return;
/*N*/ 
/*N*/ 	if ( nPaintCount )
/*N*/ 	{
/*?*/ 		//	nicht anfangen, verschachtelt zu painten
/*?*/ 		//	(dann wuerde zumindest der MapMode nicht mehr stimmen)
/*?*/ 
/*?*/ 		bNeedsRepaint = TRUE;			// -> am Ende vom Paint nochmal Invalidate auf alles
/*?*/ 		aRepaintPixel = Rectangle();	// alles
/*?*/ 		return;
/*N*/ 	}
/*N*/ 
/*N*/ 	USHORT	nX1 = pViewData->GetPosX( eHWhich );
/*N*/ 	USHORT	nY1 = pViewData->GetPosY( eVWhich );
/*N*/ 	USHORT	nX2 = nX1 + pViewData->VisibleCellsX( eHWhich );
/*N*/ 	USHORT	nY2 = nY1 + pViewData->VisibleCellsY( eVWhich );
/*N*/ 
/*N*/ 	if (nX2 > MAXCOL) nX2 = MAXCOL;
/*N*/ 	if (nY2 > MAXROW) nY2 = MAXROW;
/*N*/ 
/*N*/ 	Draw( nX1, nY1, nX2, nY2, SC_UPDATE_CHANGED );
/*N*/ }

/*N*/ void ScGridWindow::UpdateAutoFillMark(BOOL bMarked, const ScRange& rMarkRange)
/*N*/ {
/*N*/ 	if ( bMarked != bAutoMarkVisible || ( bMarked && rMarkRange.aEnd != aAutoMarkPos ) )
/*N*/ 	{
/*N*/ 		HideCursor();
/*N*/ 		bAutoMarkVisible = bMarked;
/*N*/ 		if ( bMarked )
/*N*/ 			aAutoMarkPos = rMarkRange.aEnd;
/*N*/ 		ShowCursor();
/*N*/ 	}
/*N*/ }

/*N*/ void ScGridWindow::HideCursor()
/*N*/ {
/*N*/ 	++nCursorHideCount;
/*N*/ 	if (nCursorHideCount==1)
/*N*/ 	{
/*N*/ 		BOOL bDrawCursor = TRUE;
/*N*/ 		BOOL bDrawAuto   = TRUE;
/*N*/ 
/*N*/ 		//!	irgendwie erkennen, ob wirklich neu gepainted werden muss
/*N*/ 		//!	immer flackert zu viel, weil ein Control sich immer komplett zeichnet
/*N*/ 
/*N*/ 		if (!bIsInPaint)
/*N*/ 		{
/*N*/ 			//	Controls unter dem Cursor ?
/*N*/ 
/*N*/ 			ScMarkData& rMark = pViewData->GetMarkData();
/*N*/ 			BOOL bMarked = ( rMark.IsMarked() || rMark.IsMultiMarked() );
/*N*/ 
/*N*/ 			ScDocument* pDoc = pViewData->GetDocument();
/*N*/ 			USHORT nTab = pViewData->GetTabNo();
/*N*/ 			USHORT nX = pViewData->GetCurX();
/*N*/ 			USHORT nY = pViewData->GetCurY();
/*N*/ 
/*N*/ 			Point aScrPos = pViewData->GetScrPos( nX, nY, eWhich );
/*N*/ 			long nSizeXPix;
/*N*/ 			long nSizeYPix;
/*N*/ 			pViewData->GetMergeSizePixel( nX, nY, nSizeXPix, nSizeYPix );
/*N*/ 			aScrPos.X() -= 2;
/*N*/ 			aScrPos.Y() -= 2;
/*N*/ 			Rectangle aPixRect( aScrPos, Size( nSizeXPix+4,nSizeYPix+4 ) );
/*N*/ 
/*N*/ 			if ( bAutoMarkVisible && aAutoMarkPos == ScAddress(nX,nY,nTab) )
/*N*/ 			{
/*N*/ 				aPixRect.Right() += 2;		// Anfasser mit einschliessen
/*N*/ 				aPixRect.Bottom() += 2;
/*N*/ 			}
/*N*/ 
/*N*/ 			MapMode aDrawMode = GetDrawMapMode();
/*N*/ 			Rectangle aLogicRect = PixelToLogic( aPixRect, aDrawMode );
/*N*/ 
/*N*/ 			if (pDoc->HasControl( nTab, aLogicRect ))
/*N*/ 			{
/*?*/ 				Invalidate( PixelToLogic( aPixRect ) );
/*?*/ 				if (bMarked)
/*?*/ 					{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pDoc->InvalidateControls( this, nTab, aLogicRect );
/*?*/ 
/*?*/ 				Update();
/*?*/ 				bDrawCursor = FALSE;		// nicht per XOR malen
/*N*/ 			}
/*N*/ 
/*N*/ 			//	Controls unter dem AutoFill-Anfasser ?
/*N*/ 
/*N*/ 			if ( bAutoMarkVisible && aAutoMarkPos.Tab() == nTab )
/*N*/ 			{
/*N*/ 				if ( aAutoMarkPos == ScAddress(nX,nY,nTab) )
/*N*/ 					bDrawAuto = bDrawCursor;						// schon erledigt
/*N*/ 				else
/*N*/ 				{
/*?*/ 					USHORT nAutoX = aAutoMarkPos.Col();
/*?*/ 					USHORT nAutoY = aAutoMarkPos.Row();
/*?*/ 					Point aFillPos = pViewData->GetScrPos( nAutoX, nAutoY, eWhich, TRUE );
/*?*/ 					long nSizeXPix;
/*?*/ 					long nSizeYPix;
/*?*/ 					pViewData->GetMergeSizePixel( nAutoX, nAutoY, nSizeXPix, nSizeYPix );
/*?*/ 					aFillPos.X() += nSizeXPix;
/*?*/ 					aFillPos.Y() += nSizeYPix;
/*?*/ 
/*?*/ 					aFillPos.X() -= 2;
/*?*/ 					aFillPos.Y() -= 2;
/*?*/ 					Rectangle aFillRect( aFillPos, Size(6,6) );
/*?*/ 
/*?*/ 					Rectangle aLogicFill = PixelToLogic( aFillRect, aDrawMode );
/*?*/ 					if (pDoc->HasControl( nTab, aLogicFill ))
/*?*/ 					{
/*?*/ 						Invalidate( PixelToLogic( aFillRect ) );
/*?*/ 						if (bMarked)
/*?*/ 							{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pDoc->InvalidateControls( this, nTab, aLogicFill );
/*?*/ 
/*?*/ 						Update();
/*?*/ 						bDrawAuto = FALSE;
/*?*/ 					}
/*N*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		if (bDrawCursor)
/*N*/ 			DrawCursor();
/*N*/ 		if (bDrawAuto)
/*N*/ 			DrawAutoFillMark();
/*N*/ 	}
/*N*/ }

/*N*/ void ScGridWindow::ShowCursor()
/*N*/ {
/*N*/ 	if (nCursorHideCount==0)
/*N*/ 	{
/*N*/ 		DBG_ERROR("zuviel ShowCursor");
/*N*/ 		return;
/*N*/ 	}
/*N*/ 
/*N*/ 	--nCursorHideCount;
/*N*/ 	if (nCursorHideCount==0)
/*N*/ 	{
/*N*/ 		DrawAutoFillMark();
/*N*/ 		DrawCursor();
/*N*/ 	}
/*N*/ }




//------------------------------------------------------------------------


#define SCE_TOP		1
#define SCE_BOTTOM	2
#define SCE_LEFT	4
#define SCE_RIGHT	8
#define SCE_ALL		15




//------------------------------------------------------------------------







}
