/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_viewutil.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 17:19:56 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------
#include "scitems.hxx"
#include <bf_svx/scripttypeitem.hxx>
#include <svtools/itempool.hxx>
#include <svtools/itemset.hxx>


#include "viewutil.hxx"
namespace binfilter {

// STATIC DATA -----------------------------------------------------------

//==================================================================

//	static
/*N*/ void ScViewUtil::PutItemScript( SfxItemSet& rShellSet, const SfxItemSet& rCoreSet,
/*N*/ 								USHORT nWhichId, USHORT nScript )
/*N*/ {
/*N*/ 	//	take the effective item from rCoreSet according to nScript
/*N*/ 	//	and put in rShellSet under the (base) nWhichId
/*N*/ 
/*N*/ 	SfxItemPool& rPool = *rShellSet.GetPool();
/*N*/ 	SvxScriptSetItem aSetItem( rPool.GetSlotId(nWhichId), rPool );
/*N*/ 	//	use PutExtended with eDefaultAs = SFX_ITEM_SET, so defaults from rCoreSet
/*N*/ 	//	(document pool) are read and put into rShellSet (MessagePool)
/*N*/ 	aSetItem.GetItemSet().PutExtended( rCoreSet, SFX_ITEM_DONTCARE, SFX_ITEM_SET );
/*N*/ 	const SfxPoolItem* pI = aSetItem.GetItemOfScript( nScript );
/*N*/ 	if (pI)
/*N*/ 		rShellSet.Put( *pI, nWhichId );
/*N*/ 	else
/*?*/ 		rShellSet.InvalidateItem( nWhichId );
/*N*/ }

//	static

//	static

//	static

//==================================================================


//------------------------------------------------------------------







}
