/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sch_schview.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: hr $ $Date: 2007/01/02 17:10:07 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _ZFORLIST_HXX //autogen
#ifndef _ZFORLIST_DECLARE_TABLE
#define _ZFORLIST_DECLARE_TABLE
#endif
#endif
// header for class INetURLObject
// header for class Svx3DChildWindow

#include "schattr.hxx"
#define ITEMID_CHARTLEGENDPOS	SCHATTR_LEGEND_POS

#include "schview.hxx"
#include "schmod.hxx"
#include "schresid.hxx"
#include "chwindow.hxx"
#include "objid.hxx"
#include "datarow.hxx"
#include "datapoin.hxx"
#include "strings.hrc"
#include "glob.hrc"
#include "viewshel.hxx"
#include "memchrt.hxx"
#include "SchTransferable.hxx"
namespace binfilter {

using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;

/*************************************************************************
|*
|* Konstruktor 1
|*
\************************************************************************/

/*N*/ SchView::SchView(SchChartDocShell* pDocShell,
/*N*/ 				 OutputDevice* pOutDev,
/*N*/ 				 SchViewShell* pViewShell)
/*N*/   : E3dView(&pDocShell->GetDoc(), pOutDev),
/*N*/ 	pDoc(&pDocShell->GetDoc()),
/*N*/ 	pDocSh(pDocShell),
/*N*/ 	pViewSh(pViewShell),
/*N*/ 	bDragActive (FALSE),
/*N*/ 	nLogicalMarked(FALSE),
/*N*/ 	nLogicalEntered(FALSE)
/*N*/ {
/*N*/ 	Construct();
/*N*/ }

/*************************************************************************
|*
|* Konstruktor 2
|*
\************************************************************************/


/*************************************************************************
|*
|* Construct
|*
\************************************************************************/

/*N*/ void SchView::Construct()
/*N*/ {
/*N*/ 	SetUseIncompatiblePathCreateInterface(TRUE);
/*N*/ 
/*N*/ 	OutputDevice* pOut = GetWin(0);
/*N*/ 
/*N*/ 	if( pOut )
/*N*/ 		SetMinMoveDistancePixel( (USHORT)pOut->PixelToLogic( Size( 2, 0 )).Width());
/*N*/ 
/*N*/ 	SetHitTolerancePixel (2);
/*N*/ 	EnableExtendedKeyInputDispatcher (FALSE);
/*N*/ 	EnableExtendedMouseEventDispatcher (FALSE);
/*N*/ 	EnableExtendedCommandEventDispatcher (FALSE);
/*N*/ 	bBordVisible = FALSE;
/*N*/ 
/*N*/ 	if (pDocSh && pDocSh->GetCreateMode() != SFX_CREATE_MODE_EMBEDDED)
/*N*/ 		bPageVisible = FALSE;
/*N*/ 
/*N*/ 	bGlueVisible  =
/*N*/ 	bGlueVisible2 =
/*N*/ 	bGlueVisible3 = TRUE;
/*N*/ 	SetCurrentObj(OBJ_RECT, SdrInventor);
/*N*/ 
/*N*/ 	if (pDoc->GetPageCount() == 0L)
/*N*/ 	{
/*N*/ 		// Seite einfuegen
/*?*/ 		BOOL bChanged = pDoc->IsChanged();
/*?*/ 		SdrPage* pPage = pDoc->AllocPage(FALSE);
/*?*/ 
/*?*/ 		if (pDocSh)
/*?*/ 			pPage->SetSize(pDocSh->GetVisArea(ASPECT_CONTENT).GetSize());
/*?*/ 
/*?*/ 		pDoc->InsertPage(pPage);
/*?*/ 		pDoc->BuildChart(FALSE);
/*?*/ 		pDoc->SetChanged(bChanged);
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

/*N*/ SchView::~SchView()
/*N*/ {
/*N*/     // release content of selection clipboard, if we own the content
/*N*/     UpdateSelectionClipboard( TRUE );
/*N*/ 
/*N*/ 	aTimer.Stop();
/*N*/ 	for (USHORT nWin = 0; nWin < GetWinCount(); nWin++)
/*N*/ 	{
/*N*/ 		OutputDevice* pOutDev = GetWin(nWin);
/*N*/ 
/*N*/ 		if (pOutDev->GetOutDevType() == OUTDEV_WINDOW)
/*N*/ 			DelWin((SchWindow*)pOutDev);
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* virtuelle Methode von SdrView, der die anfallenden Undo-Aktionen
|* uebergeben werden
|*
\************************************************************************/


/*************************************************************************
|*
|* virtuelle Methode von SdrView, wird bei Selektionsaenderung gerufen
|*
\************************************************************************/

/*N*/ void SchView::MarkListHasChanged()
/*N*/ {
/*N*/ 	E3dView::MarkListHasChanged();
/*N*/ 	if ( pViewSh )
/*N*/ 		pViewSh->SelectionHasChanged();
/*N*/ 
/*N*/ 	aTimer.SetTimeoutHdl( LINK( this, SchView, NotifySelection) );
/*N*/ 	// Timer reset
/*N*/ 	aTimer.SetTimeout(100);
/*N*/ 	aTimer.Start();
/*N*/ }

/*************************************************************************
|*
|* Markierungs-Handles setzen, ggf. logische 3D-Gruppen beruecksichtigen
|*
\************************************************************************/

/*N*/ void SchView::SetMarkHandles()
/*N*/ {
/*N*/ 	SdrView::SetMarkHandles();
/*N*/ 
/*N*/ 	SdrMark* pMark = aMark.GetMark(0);
/*N*/ 	if( pMark )
/*N*/ 	{
/*?*/ 		SdrPageView* pPageView = pMark->GetPageView();
/*?*/ 		if( pPageView )
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SdrObject* pObj = pMark->GetObj();
/*?*/ 		}
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* logische Gruppe betreten
|*
\************************************************************************/


/*************************************************************************
|*
|* logische Gruppe verlassen
|*
\************************************************************************/


/*************************************************************************
|*
|* alle Gruppen verlassen
|*
\************************************************************************/



/*************************************************************************
|*
|* logische Gruppe markieren
|*
\************************************************************************/


/*************************************************************************
|*
|* Objekt an Position vorhanden?
|*
\************************************************************************/


/*************************************************************************
|*
|* markiertes Objekt (auch von logischer Gruppe) getroffen?
|*
\************************************************************************/


/*************************************************************************
|*
|* Liste der markierten Objekte einer logischen Gruppe zurueckgeben
|*
\************************************************************************/


/*N*/ IMPL_LINK(SchView,NotifySelection ,void*, EMPTYARG)
/*N*/ //void ::NotifySelection()
/*N*/ {
/*N*/ 	SchMemChart* pMemChart = (SchMemChart*)pDoc->GetMemChart();
/*N*/ 	if( pMemChart == NULL )
/*?*/ 		return 0;
/*N*/ 
/*N*/ 	ChartSelectionInfo aInfo;
/*N*/ 
/*N*/ 	SdrObject	 *pObj  = NULL;
/*N*/ 	SchDataRow	 *pRow  = NULL;
/*N*/ 	SchDataPoint *pPoint= NULL;
/*N*/ 
/*N*/ 	aInfo.nSelection=CHART_SEL_NONE;
/*N*/ 
/*N*/ 	if (HasMarkedObj())
/*N*/ 	{
/*?*/ 		ULONG nCount = aMark.GetMarkCount();
/*?*/ 		if (nCount == 1)
/*?*/ 		{
/*?*/ 			pObj=aMark.GetMark(0)->GetObj();
/*?*/ 			SchObjectId* pId = GetObjectId(*pObj);
/*?*/ 			if (pId)
/*?*/ 			{
/*?*/ 				switch (pId->GetObjId())
/*?*/ 				{
/*?*/ 					case CHOBJID_DIAGRAM_AREA:
/*?*/ 					case CHOBJID_DIAGRAM:
/*?*/ 						aInfo.nSelection=CHART_SEL_NONE | CHART_SEL_ALL;
/*?*/ 						break;
/*?*/ 
/*?*/ 					case CHOBJID_LEGEND_SYMBOL_ROW:
/*?*/ 					case CHOBJID_DIAGRAM_ROWGROUP:
/*?*/ 					case CHOBJID_DIAGRAM_ROWS:
/*?*/ 					case CHOBJID_DIAGRAM_ROWSLINE:
/*?*/ 					case CHOBJID_DIAGRAM_SPECIAL_GROUP:
/*?*/ 						{
/*?*/ 							pRow=GetDataRow(*pObj);
/*?*/ 							if(pRow)
/*?*/ 							{
/*?*/ 								if(!pDoc->IsDataSwitched())
/*?*/ 								{
/*?*/ 									aInfo.nSelection=CHART_SEL_NONE | CHART_SEL_ROW;
/*?*/ 									aInfo.nRow=pRow->GetRow();
/*?*/ 								}
/*?*/ 								else
/*?*/ 								{
/*?*/ 									aInfo.nSelection=CHART_SEL_NONE | CHART_SEL_COL;
/*?*/ 									aInfo.nCol=pRow->GetRow();
/*?*/ 								}
/*?*/ 							}
/*?*/ 						}
/*?*/ 						break;
/*?*/ 					case CHOBJID_LEGEND_SYMBOL_COL:
/*?*/ 					case CHOBJID_DIAGRAM_DATA:
/*?*/ 						{
/*?*/ 							pPoint=GetDataPoint(*pObj);
/*?*/ 							if(pPoint)
/*?*/ 							{
							/*	SfxItemSet aAttr=pDoc->GetDataRowAttr(pPoint->GetRow());
								aAttr.Put(pDoc->GetDataPointAttr(pPoint->GetCol(),pPoint->GetRow()));	*/
/*?*/ 								if(!pDoc->IsDataSwitched())
/*?*/ 								{
/*?*/ 									aInfo.nSelection=CHART_SEL_NONE | CHART_SEL_POINT;
/*?*/ 									aInfo.nCol=pPoint->GetCol();
/*?*/ 									aInfo.nRow=pPoint->GetRow();
/*?*/ 								}
/*?*/ 								else
/*?*/ 								{
/*?*/ 									aInfo.nSelection=CHART_SEL_NONE | CHART_SEL_POINT;
/*?*/ 									aInfo.nCol=pPoint->GetRow();
/*?*/ 									aInfo.nRow=pPoint->GetCol();
/*?*/ 								}
/*?*/ 							}
/*?*/ 						}
/*?*/ 						break;
/*?*/ 
/*					case CHOBJID_DIAGRAM_DESCRGROUP:
					case CHOBJID_DIAGRAM_DESCR_ROW:
					case CHOBJID_DIAGRAM_DESCR_COL:
					case CHOBJID_LEGEND:

					case CHOBJID_TITLE_MAIN:
					case CHOBJID_TITLE_SUB:
					case CHOBJID_DIAGRAM_WALL:
					case CHOBJID_DIAGRAM_FLOOR:
					case CHOBJID_DIAGRAM_TITLE_X_AXIS:
					case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
					case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
					case CHOBJID_DIAGRAM_X_AXIS:
					case CHOBJID_DIAGRAM_Y_AXIS:       sowie auch A,B,C:
					case CHOBJID_DIAGRAM_Z_AXIS:
					case CHOBJID_DIAGRAM_X_GRID_MAIN:
					case CHOBJID_DIAGRAM_Y_GRID_MAIN:
					case CHOBJID_DIAGRAM_Z_GRID_MAIN:
					case CHOBJID_DIAGRAM_X_GRID_HELP:
					case CHOBJID_DIAGRAM_Y_GRID_HELP:
					case CHOBJID_DIAGRAM_Z_GRID_HELP:*/
/*?*/ 					default:
/*?*/ 						break;
/*?*/ 				}
/*?*/ 			}
/*?*/ 		}
/*N*/ 	}
/*N*/ 	pMemChart->SubmitSelection(aInfo);
/*N*/ 	return 0;
/*N*/ }


// ********************************************************************************
//
//  Drag and Drop / Clipboard
//
// ********************************************************************************

// ========================================
// create transferable for drag&drop
// ========================================


// ========================================
// create transferable for clipboard
// ========================================


// ========================================
// create transferable for selection clipboard
// ========================================


/*N*/ void SchView::UpdateSelectionClipboard( BOOL bForceDeselect )
/*N*/ {
/*N*/     if( pViewSh && pViewSh->GetWindow() )
/*N*/     {
/*N*/         if( ! bForceDeselect && GetMarkList().GetMarkCount() )
/*?*/ 				{DBG_BF_ASSERT(0, "STRIP");} //STRIP001             CreateSelectionDataObject( this, *pViewSh->GetWindow() );
/*N*/         else if( SCH_MOD1()->GetSelectionClipboardTransferable() &&
/*N*/ 				 ( SCH_MOD1()->GetSelectionClipboardTransferable()->GetView() == this ) )
/*N*/         {
/*?*/             TransferableHelper::ClearSelection( pViewSh->GetWindow() );
/*?*/             SCH_MOD1()->SetSelectionClipboardTransferable( NULL );
/*N*/         }
/*N*/     }
/*N*/ }

// ========================================
// drag action requested for this view
// ========================================


// ========================================
// drop an object into this view
// ========================================


// ========================================
// insert object into document
// ========================================



/// SfxListener::Notify
/*N*/ void SchView::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
/*N*/ {
/*N*/     if( rHint.ISA( SfxSimpleHint ) &&
/*N*/         SAL_STATIC_CAST( const SfxSimpleHint&, rHint ).GetId() == SFX_HINT_MODECHANGED &&
/*N*/         rBC.ISA( ChartModel ))
/*N*/     {
/*N*/         if( pViewSh )
/*N*/             pViewSh->UIFeatureChanged();
/*N*/     }
/*N*/     else
/*N*/         E3dView::Notify( rBC, rHint );
/*N*/ }
}
