/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_drviewsc.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 18:43:10 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#ifndef _SVXIDS_HRC
#include <bf_svx/svxids.hrc>
#endif
#ifndef _SFXREQUEST_HXX //autogen
#include <bf_sfx2/request.hxx>
#endif
//#ifndef _BINDING_HXX //autogen
//#include <bf_sfx2/binding.hxx>
//#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
#include <bf_svx/grafctrl.hxx>


#include "app.hrc"
#include "strings.hrc"
#include "helpids.h"
#include "drviewsh.hxx"
#include "docshell.hxx"
#include "drawview.hxx"
namespace binfilter {

#define	MIN_ACTIONS_FOR_DIALOG	5000	// bei mehr als 1600 Metaobjekten
										// wird beim Aufbrechen ein Dialog
										// angezeigt.
/*************************************************************************
|*
|* SfxRequests fuer temporaere Funktionen
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::FuTemp03(SfxRequest& rReq)
/*N*/ {
/*N*/ 	USHORT nSId = rReq.GetSlot();
/*N*/ 	switch( nSId )
/*N*/ 	{
/*?*/ 		case SID_GROUP:  // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( pDrView->IsPresObjSelected( TRUE, TRUE, TRUE ) )
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_UNGROUP:  // BASIC
/*?*/ 		{
/*?*/ 			pDrView->UnGroupMarked();
/*?*/ 			Cancel();
/*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_NAME_GROUP:
/*?*/ 		{
/*?*/ 			// Jetzt nur noch fuer ein Objekt moeglich (28.10.96)
/*?*/ 			const SdrMarkList& rMarkList = pDrView->GetMarkList();
/*?*/ 			SdrObject* pObj = NULL;
/*?*/ 			ULONG nMarkCount = rMarkList.GetMarkCount();
/*?*/ 
/*?*/ 			if( nMarkCount == 1 )
/*?*/ 			{
/*?*/ 			    DBG_BF_ASSERT(0, "STRIP"); //STRIP001 String aName;
/*?*/ 			}
/*?*/ 
/*?*/ 			SfxBindings& rBindings = GetViewFrame()->GetBindings();
/*?*/ 			rBindings.Invalidate( SID_NAVIGATOR_STATE, TRUE, FALSE );
/*?*/ 			rBindings.Invalidate( SID_CONTEXT );
/*?*/ 
/*?*/ 			Cancel();
/*?*/ 			rReq.Ignore ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_ENTER_GROUP:  // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->EnterMarkedGroup();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_LEAVE_GROUP:  // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->LeaveOneGroup();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_LEAVE_ALL_GROUPS:  // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->LeaveAllGroup();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ //		{
/*?*/ //			// Versuchen, die betretene Gruppe zu bekommen
/*?*/ //			SdrObject* pGroup = NULL;
/*?*/ //			SdrPageView* pPV = pDrView->GetPageViewPvNum(0);
/*?*/ //			if(pPV)
/*?*/ //				pGroup = pPV->GetAktGroup();
/*?*/ //
/*?*/ //			if(nSId == SID_LEAVE_ALL_GROUPS)
/*?*/ //			{
/*?*/ //				// Alle Gruppen verlassen
/*?*/ //				pDrView->LeaveAllGroup();
/*?*/ //
/*?*/ //				// Objekt bis zur obersten Gruppe zurueckverfolgen
/*?*/ //				while(pGroup && pGroup->GetObjList() && pGroup->GetObjList()->GetOwnerObj())
/*?*/ //					pGroup = pGroup->GetObjList()->GetOwnerObj();
/*?*/ //			}
/*?*/ //			else
/*?*/ //			{
/*?*/ //				// Eine Gruppe verlassen
/*?*/ //				pDrView->LeaveOneGroup();
/*?*/ //			}
/*?*/ //
/*?*/ //			pDrView->UnmarkAll();
/*?*/ //			Cancel();
/*?*/ //			rReq.Done ();
/*?*/ //
/*?*/ //			// Falls die Gruppe geholt werden konnte, selektiere diese
/*?*/ //			if(pGroup)
/*?*/ //			{
/*?*/ //				for (USHORT nv=0; nv<pDrView->GetPageViewCount(); nv++)
/*?*/ //				{
/*?*/ //					SdrPageView* pPV = pDrView->GetPageViewPvNum(nv);
/*?*/ //					pDrView->MarkObj(pGroup, pPV);
/*?*/ //				}
/*?*/ //			}
/*?*/ //		}
/*?*/ //		break;
/*?*/ 
/*?*/ 		case SID_COMBINE:  // BASIC
/*?*/ 		{
/*?*/ 			// #88224# End text edit to avoid conflicts
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if(pDrView->IsTextEdit())
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_DISTRIBUTE_DLG:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( pDrView->IsPresObjSelected() )
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/         case SID_POLY_MERGE:
/*?*/ 		{
/*?*/ 			// #88224# End text edit to avoid conflicts
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if(pDrView->IsTextEdit())
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/         case SID_POLY_SUBSTRACT:
/*?*/ 		{
/*?*/ 			// #88224# End text edit to avoid conflicts
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if(pDrView->IsTextEdit())
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/         case SID_POLY_INTERSECT:
/*?*/ 		{
/*?*/ 			// #88224# End text edit to avoid conflicts
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if(pDrView->IsTextEdit())
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_DISMANTLE:  // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( pDrView->IsDismantlePossible(FALSE) )
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_CONNECT:  // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( pDrView->IsPresObjSelected() )
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_BREAK:  // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( pDrView->IsTextEdit() )
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_CONVERT_TO_3D:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( pDrView->IsPresObjSelected() )
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_FRAME_TO_TOP:	// BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->PutMarkedToTop();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_MOREFRONT:  // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->MovMarkedToTop();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_MOREBACK:	// BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->MovMarkedToBtm();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_FRAME_TO_BOTTOM:	// BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->PutMarkedToBtm();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_HORIZONTAL:  // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->MirrorAllMarkedHorizontal();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_VERTICAL:	// BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->MirrorAllMarkedVertical();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_OBJECT_ALIGN_LEFT:  // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->AlignMarkedObjects(SDRHALIGN_LEFT, SDRVALIGN_NONE);
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_OBJECT_ALIGN_CENTER:  // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->AlignMarkedObjects(SDRHALIGN_CENTER, SDRVALIGN_NONE);
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_OBJECT_ALIGN_RIGHT:  // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->AlignMarkedObjects(SDRHALIGN_RIGHT, SDRVALIGN_NONE);
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_OBJECT_ALIGN_UP:  // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->AlignMarkedObjects(SDRHALIGN_NONE, SDRVALIGN_TOP);
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_OBJECT_ALIGN_MIDDLE:  // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->AlignMarkedObjects(SDRHALIGN_NONE, SDRVALIGN_CENTER);
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_OBJECT_ALIGN_DOWN:  // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->AlignMarkedObjects(SDRHALIGN_NONE, SDRVALIGN_BOTTOM);
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_SELECTALL:  // BASIC
/*?*/ 		{
/*?*/             DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if (pFuOld && pFuOld->ISA(FuSelection) &&
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_STYLE_NEW:	// BASIC ???
/*?*/ 		case SID_STYLE_APPLY:
/*?*/ 		case SID_STYLE_EDIT:
/*?*/ 		case SID_STYLE_DELETE:
/*?*/ 		case SID_STYLE_FAMILY:
/*?*/ 		case SID_STYLE_WATERCAN:
/*?*/ 		case SID_STYLE_UPDATE_BY_EXAMPLE:
/*?*/ 		case SID_STYLE_NEW_BY_EXAMPLE:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if( rReq.GetSlot() == SID_STYLE_EDIT && !rReq.GetArgs() )
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_IMAP:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SvxIMapDlg* pDlg;
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_GRID_FRONT:
/*?*/ 		{
/*?*/ 			pDrView->SetGridFront( !pDrView->IsGridFront() );
/*?*/ 			Cancel();
/*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_HELPLINES_FRONT:
/*?*/ 		{
/*?*/ 			pDrView->SetHlplFront( !pDrView->IsHlplFront() );
/*?*/ 			Cancel();
/*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*N*/ 		default:
/*N*/ 			FuTemp04(rReq);
/*N*/ 		break;
/*N*/ 	};
/*N*/ };

/*************************************************************************
|*
|* Liefert die globale/Haupt-ID zurueck, also die ID, ueber die die
|* Toolbox ausgeloest wird
|*
\************************************************************************/

/*N*/ USHORT SdDrawViewShell::GetIdBySubId( USHORT nSId )
/*N*/ {
/*N*/ 	USHORT nMappedSId = 0;
/*N*/ 	switch( nSId )
/*N*/ 	{
/*N*/ 		case SID_OBJECT_ROTATE:
/*N*/ 		case SID_OBJECT_MIRROR:
/*N*/ 		case SID_OBJECT_TRANSPARENCE:
/*N*/ 		case SID_OBJECT_GRADIENT:
/*N*/ 		case SID_OBJECT_SHEAR:
/*N*/ 		case SID_OBJECT_CROOK_ROTATE:
/*N*/ 		case SID_OBJECT_CROOK_SLANT:
/*N*/ 		case SID_OBJECT_CROOK_STRETCH:
/*N*/         case SID_CONVERT_TO_3D_LATHE:
/*N*/ 		{
/*N*/ 			nMappedSId = SID_OBJECT_CHOOSE_MODE;
/*N*/ 		}
/*N*/ 		break;
/*N*/ 
/*N*/ 		case SID_OBJECT_ALIGN_LEFT:
/*N*/ 		case SID_OBJECT_ALIGN_CENTER:
/*N*/ 		case SID_OBJECT_ALIGN_RIGHT:
/*N*/ 		case SID_OBJECT_ALIGN_UP:
/*N*/ 		case SID_OBJECT_ALIGN_MIDDLE:
/*N*/ 		case SID_OBJECT_ALIGN_DOWN:
/*N*/ 		{
/*N*/ 			nMappedSId = SID_OBJECT_ALIGN;
/*N*/ 		}
/*N*/ 		break;
/*N*/ 
/*N*/ 		case SID_FRAME_TO_TOP:
/*N*/ 		case SID_MOREFRONT:
/*N*/ 		case SID_MOREBACK:
/*N*/ 		case SID_FRAME_TO_BOTTOM:
/*N*/ 		case SID_BEFORE_OBJ:
/*N*/ 		case SID_BEHIND_OBJ:
/*N*/ 		case SID_REVERSE_ORDER:
/*N*/ 		{
/*N*/ 			nMappedSId = SID_POSITION;
/*N*/ 		}
/*N*/ 		break;
/*N*/ 
/*N*/ 		case SID_ZOOM_OUT:
/*N*/ 		case SID_ZOOM_IN:
/*N*/ 		case SID_SIZE_REAL:
/*N*/ 		case SID_ZOOM_PANNING:
/*N*/ 		case SID_SIZE_PAGE:
/*N*/ 		case SID_SIZE_PAGE_WIDTH:
/*N*/ 		case SID_SIZE_ALL:
/*N*/ 		case SID_SIZE_OPTIMAL:
/*N*/ 		case SID_ZOOM_NEXT:
/*N*/ 		case SID_ZOOM_PREV:
/*N*/ 		{
/*N*/ 			nMappedSId = SID_ZOOM_TOOLBOX;
/*N*/ 		}
/*N*/ 		break;
/*N*/ 
/*N*/ 		case SID_ATTR_CHAR:
/*N*/ 		case SID_TEXT_FITTOSIZE:
/*N*/ 		case SID_DRAW_CAPTION:
/*N*/ 		{
/*N*/ 			nMappedSId = SID_DRAWTBX_TEXT;
/*N*/ 		}
/*N*/ 		break;
/*N*/ 
/*N*/ 		case SID_DRAW_RECT:
/*N*/ 		case SID_DRAW_SQUARE:
/*N*/ 		case SID_DRAW_RECT_ROUND:
/*N*/ 		case SID_DRAW_SQUARE_ROUND:
/*N*/ 		case SID_DRAW_RECT_NOFILL:
/*N*/ 		case SID_DRAW_SQUARE_NOFILL:
/*N*/ 		case SID_DRAW_RECT_ROUND_NOFILL:
/*N*/ 		case SID_DRAW_SQUARE_ROUND_NOFILL:
/*N*/ 		{
/*N*/ 			nMappedSId = SID_DRAWTBX_RECTANGLES;
/*N*/ 		}
/*N*/ 		break;
/*N*/ 
/*N*/ 		case SID_DRAW_ELLIPSE:
/*N*/ 		case SID_DRAW_CIRCLE:
/*N*/ 		case SID_DRAW_PIE:
/*N*/ 		case SID_DRAW_CIRCLEPIE:
/*N*/ 		case SID_DRAW_ELLIPSECUT:
/*N*/ 		case SID_DRAW_CIRCLECUT:
/*N*/ 		case SID_DRAW_ARC:
/*N*/ 		case SID_DRAW_CIRCLEARC:
/*N*/ 		case SID_DRAW_ELLIPSE_NOFILL:
/*N*/ 		case SID_DRAW_CIRCLE_NOFILL:
/*N*/ 		case SID_DRAW_PIE_NOFILL:
/*N*/ 		case SID_DRAW_CIRCLEPIE_NOFILL:
/*N*/ 		case SID_DRAW_ELLIPSECUT_NOFILL:
/*N*/ 		case SID_DRAW_CIRCLECUT_NOFILL:
/*N*/ 		{
/*N*/ 			nMappedSId = SID_DRAWTBX_ELLIPSES;
/*N*/ 		}
/*N*/ 		break;
/*N*/ 
/*N*/         case SID_DRAW_BEZIER_NOFILL:
/*N*/ 		case SID_DRAW_POLYGON_NOFILL:
/*N*/ 		case SID_DRAW_XPOLYGON_NOFILL:
/*N*/         case SID_DRAW_FREELINE_NOFILL:
/*N*/         case SID_DRAW_BEZIER_FILL:
/*N*/ 		case SID_DRAW_POLYGON:
/*N*/ 		case SID_DRAW_XPOLYGON:
/*N*/         case SID_DRAW_FREELINE:
/*N*/ 		{
/*N*/ 			nMappedSId = SID_DRAWTBX_LINES;
/*N*/ 		}
/*N*/ 		break;
/*N*/ 
/*N*/ 		case SID_DRAW_LINE:
/*N*/ 		case SID_DRAW_XLINE:
/*N*/ 		case SID_DRAW_MEASURELINE:
/*N*/ 		case SID_LINE_ARROW_START:
/*N*/ 		case SID_LINE_ARROW_END:
/*N*/ 		case SID_LINE_ARROWS:
/*N*/ 		case SID_LINE_ARROW_CIRCLE:
/*N*/ 		case SID_LINE_CIRCLE_ARROW:
/*N*/ 		case SID_LINE_ARROW_SQUARE:
/*N*/ 		case SID_LINE_SQUARE_ARROW:
/*N*/ 		{
/*N*/ 			nMappedSId = SID_DRAWTBX_ARROWS;
/*N*/ 		}
/*N*/ 		break;
/*N*/ 
/*N*/ 		case SID_3D_CUBE:
/*N*/ 		case SID_3D_TORUS:
/*N*/ 		case SID_3D_SPHERE:
/*N*/ 		case SID_3D_SHELL:
/*N*/ 		case SID_3D_HALF_SPHERE:
/*N*/ 		case SID_3D_CYLINDER:
/*N*/ 		case SID_3D_CONE:
/*N*/ 		case SID_3D_PYRAMID:
/*N*/ 		{
/*N*/ 			nMappedSId = SID_DRAWTBX_3D_OBJECTS;
/*N*/ 		}
/*N*/ 		break;
/*N*/ 
/*N*/ 		case SID_INSERT_DIAGRAM:
/*N*/ #ifdef STARIMAGE_AVAILABLE
/*N*/ 		case SID_INSERT_IMAGE:
/*N*/ #endif
/*N*/ 		case SID_ATTR_TABLE:
/*N*/ 		case SID_INSERTFILE:
/*N*/ 		case SID_INSERT_GRAPHIC:
/*N*/ 		case SID_INSERTPAGE:
/*N*/ 	    case SID_INSERT_MATH:
/*N*/ 	    case SID_INSERT_FLOATINGFRAME:
/*N*/ 	    case SID_INSERT_OBJECT:
/*N*/         case SID_INSERT_PLUGIN:
/*N*/ 		case SID_INSERT_SOUND:
/*N*/ 		case SID_INSERT_VIDEO:
/*N*/         case SID_INSERT_APPLET:
/*N*/ 		{
/*N*/ 			nMappedSId = SID_DRAWTBX_INSERT;
/*N*/ 		}
/*N*/ 		break;
/*N*/ 
/*N*/         case SID_TOOL_CONNECTOR:
/*N*/         case SID_CONNECTOR_ARROW_START:
/*N*/         case SID_CONNECTOR_ARROW_END:
/*N*/         case SID_CONNECTOR_ARROWS:
/*N*/         case SID_CONNECTOR_CIRCLE_START:
/*N*/         case SID_CONNECTOR_CIRCLE_END:
/*N*/         case SID_CONNECTOR_CIRCLES:
/*N*/         case SID_CONNECTOR_LINE:
/*N*/         case SID_CONNECTOR_LINE_ARROW_START:
/*N*/         case SID_CONNECTOR_LINE_ARROW_END:
/*N*/         case SID_CONNECTOR_LINE_ARROWS:
/*N*/         case SID_CONNECTOR_LINE_CIRCLE_START:
/*N*/         case SID_CONNECTOR_LINE_CIRCLE_END:
/*N*/         case SID_CONNECTOR_LINE_CIRCLES:
/*N*/         case SID_CONNECTOR_CURVE:
/*N*/         case SID_CONNECTOR_CURVE_ARROW_START:
/*N*/         case SID_CONNECTOR_CURVE_ARROW_END:
/*N*/         case SID_CONNECTOR_CURVE_ARROWS:
/*N*/         case SID_CONNECTOR_CURVE_CIRCLE_START:
/*N*/         case SID_CONNECTOR_CURVE_CIRCLE_END:
/*N*/         case SID_CONNECTOR_CURVE_CIRCLES:
/*N*/         case SID_CONNECTOR_LINES:
/*N*/         case SID_CONNECTOR_LINES_ARROW_START:
/*N*/         case SID_CONNECTOR_LINES_ARROW_END:
/*N*/         case SID_CONNECTOR_LINES_ARROWS:
/*N*/         case SID_CONNECTOR_LINES_CIRCLE_START:
/*N*/         case SID_CONNECTOR_LINES_CIRCLE_END:
/*N*/         case SID_CONNECTOR_LINES_CIRCLES:
/*N*/         {
/*N*/             nMappedSId = SID_DRAWTBX_CONNECTORS;
/*N*/         }
/*N*/ 	}
/*N*/ 	return( nMappedSId );
/*N*/ }

/*************************************************************************
|*
|* Fuellt das SlotArray, um das aktuelle Mapping des ToolboxSlots zu
|* bekommen
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::MapSlot( USHORT nSId )
/*N*/ {
/*N*/ 	USHORT nMappedSId = GetIdBySubId( nSId );
/*N*/ 
/*N*/ 	if( nMappedSId > 0 )
/*N*/ 	{
/*N*/ 		USHORT nID = GetArrayId( nMappedSId ) + 1;
/*N*/ 		pSlotArray[ nID ] = nSId;
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* Ermoeglicht ueber das SlotArray ein ImageMapping
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::UpdateToolboxImages( SfxItemSet &rSet, BOOL bPermanent )
/*N*/ {
/*N*/ 	if( !bPermanent )
/*N*/ 	{
/*N*/ 		USHORT nId = GetArrayId( SID_ZOOM_TOOLBOX ) + 1;
/*N*/ 		rSet.Put( TbxImageItem( SID_ZOOM_TOOLBOX, pSlotArray[nId] ) );
/*N*/ 
/*N*/ 		nId = GetArrayId( SID_DRAWTBX_INSERT ) + 1;
/*N*/ 		rSet.Put( TbxImageItem( SID_DRAWTBX_INSERT, pSlotArray[nId] ) );
/*N*/ 
/*N*/ 		nId = GetArrayId( SID_POSITION ) + 1;
/*N*/ 		rSet.Put( TbxImageItem( SID_POSITION, pSlotArray[nId] ) );
/*N*/ 
/*N*/ 		nId = GetArrayId( SID_OBJECT_ALIGN ) + 1;
/*N*/ 		rSet.Put( TbxImageItem( SID_OBJECT_ALIGN, pSlotArray[nId] ) );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		for( USHORT nId = 0; nId < SLOTARRAY_COUNT; nId += 2 )
/*N*/ 		{
/*N*/ 			rSet.Put( TbxImageItem( pSlotArray[nId], pSlotArray[nId+1] ) );
/*N*/ 		}
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* Gibt den gemappten Slot zurueck
|*
\************************************************************************/


/*************************************************************************
|*
|* Gibt die Nummer des HauptSlots im SlotArray zurueck
|*
\************************************************************************/

/*N*/ USHORT SdDrawViewShell::GetArrayId( USHORT nSId )
/*N*/ {
/*N*/ 	for( int i = 0; i < SLOTARRAY_COUNT; i += 2 )
/*N*/ 	{
/*N*/ 		if( pSlotArray[ i ] == nSId )
/*N*/ 			return( i );
/*N*/ 	}
/*N*/ 	DBG_ERROR( "Slot im Array nicht gefunden!" );
/*N*/ 	return( USHRT_MAX );
/*N*/ }


/*************************************************************************
|*
|* IMap-Dlg updaten
|*
\************************************************************************/


// -----------------------------------------------------------------------------

}
