/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_drviewsf.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 18:43:33 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#ifndef _SVXIDS_HRC
#include <bf_svx/svxids.hrc>
#endif
#ifndef _EEITEM_HXX //autogen
#include <bf_svx/eeitem.hxx>
#endif


#ifndef _SFXPOOLITEM_HXX
#include <svtools/poolitem.hxx>
#endif

#ifndef _SVX_ITEMDATA_HXX
#include <bf_svx/itemdata.hxx>
#endif

#ifndef _DATE_HXX
#include <tools/date.hxx>
#endif

#ifndef _TOOLS_TIME_HXX
#include <tools/time.hxx>
#endif

#ifndef _FLDITEM_HXX
#define ITEMID_FIELD    EE_FEATURE_FIELD
#endif
#ifndef _SFX_TOPFRM_HXX //autogen wg. SfxTopViewFrame
#include <bf_sfx2/topfrm.hxx>
#endif
#ifndef _SVTOOLS_CJKOPTIONS_HXX
#include <svtools/cjkoptions.hxx>
#endif

#include "app.hrc"

#include "drviewsh.hxx"
#include "drawview.hxx"

#include "sdwindow.hxx"
#include "prevchld.hxx"
namespace binfilter {

using namespace ::rtl;
using namespace ::com::sun::star;


/*************************************************************************
|*
|* Status von Controller-SfxSlots setzen
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::GetCtrlState(SfxItemSet &rSet)
/*N*/ {
/*N*/ //	rSet.Put(SfxUInt16Item(SID_SWITCHPAGE, aTabControl.GetCurPageId()));
/*N*/ //	rSet.Put(SfxUInt16Item(SID_SWITCHLAYER, aLayerTab.GetCurPageId()));
/*N*/ 
/*N*/ 	if (rSet.GetItemState(SID_RELOAD) != SFX_ITEM_UNKNOWN)
/*N*/ 	{
		// "Letzte Version" vom SFx en/disablen lassen
/*?*/ 		SfxViewFrame* pViewFrame = GetViewFrame();
/*?*/ 		DBG_ASSERT(pViewFrame, "ViewFrame nicht gefunden");
/*?*/ 		if (pViewFrame->ISA(SfxTopViewFrame))
/*?*/ 		{
/*?*/ 			pViewFrame->GetSlotState (SID_RELOAD, NULL, &rSet);
/*?*/ 		}
/*?*/ 		else		// MI sagt: kein MDIFrame --> disablen
/*?*/ 		{
/*?*/ 			rSet.DisableItem(SID_RELOAD);
/*?*/ 		}
/*?*/ 	}

/*N*/ 	if (SFX_ITEM_AVAILABLE == rSet.GetItemState(SID_HYPERLINK_GETLINK))
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SvxHyperlinkItem aHLinkItem;
/*N*/ 	}
/*N*/ 	rSet.Put( SfxBoolItem( SID_READONLY_MODE, bReadOnly ) );

	// Ausgabequalitaet
/*N*/ 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_OUTPUT_QUALITY_COLOR ) ||
/*N*/ 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_OUTPUT_QUALITY_GRAYSCALE ) ||
/*N*/ 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_OUTPUT_QUALITY_BLACKWHITE ) ||
/*N*/         SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_OUTPUT_QUALITY_CONTRAST ) )
/*N*/ 	{
/*?*/ 		ULONG   nMode = pWindow->GetDrawMode();
/*?*/ 		UINT16  nQuality = 0;
/*?*/ 		
/*?*/         if( OUTPUT_DRAWMODE_COLOR == nMode )
/*?*/ 			nQuality = 0;
/*?*/ 		else if( OUTPUT_DRAWMODE_GRAYSCALE == nMode )
/*?*/ 			nQuality = 1;
/*?*/ 		else if( OUTPUT_DRAWMODE_BLACKWHITE == nMode )
/*?*/ 			nQuality = 2;
/*?*/         else if( OUTPUT_DRAWMODE_CONTRAST == nMode )
/*?*/             nQuality = 3;
/*?*/ 
/*?*/ 		rSet.Put( SfxBoolItem( SID_OUTPUT_QUALITY_COLOR, (BOOL)(nQuality == 0) ) );
/*?*/ 		rSet.Put( SfxBoolItem( SID_OUTPUT_QUALITY_GRAYSCALE, (BOOL)(nQuality == 1) ) );
/*?*/ 		rSet.Put( SfxBoolItem( SID_OUTPUT_QUALITY_BLACKWHITE, (BOOL)(nQuality == 2) ) );
/*?*/ 		rSet.Put( SfxBoolItem( SID_OUTPUT_QUALITY_CONTRAST, (BOOL)(nQuality == 3) ) );
/*?*/ 	}

	// Preview-Fenster
/*N*/ 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_PREVIEW_QUALITY_COLOR ) ||
/*N*/ 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_PREVIEW_QUALITY_GRAYSCALE ) ||
/*N*/ 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_PREVIEW_QUALITY_BLACKWHITE ) ||
/*N*/         SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_PREVIEW_QUALITY_CONTRAST ) )
/*N*/ 	{
/*N*/ 		USHORT nId = SdPreviewChildWindow::GetChildWindowId();
/*N*/ 		
/*N*/         if( GetViewFrame()->GetChildWindow( nId ) )
		{
			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 ULONG nMode = pFrameView->GetPreviewDrawMode();
		}
/*N*/ 		else
/*N*/ 		{
/*N*/ 			rSet.DisableItem( SID_PREVIEW_QUALITY_COLOR );
/*N*/ 			rSet.DisableItem( SID_PREVIEW_QUALITY_GRAYSCALE );
/*N*/ 			rSet.DisableItem( SID_PREVIEW_QUALITY_BLACKWHITE );
/*N*/ 			rSet.DisableItem( SID_PREVIEW_QUALITY_CONTRAST );
/*N*/ 		}
/*N*/ 	}

/*N*/ 	if ( SFX_ITEM_AVAILABLE == rSet.GetItemState(SID_MAIL_SCROLLBODY_PAGEDOWN) )
/*N*/ 	{
/*?*/ 		rSet.Put( SfxBoolItem( SID_MAIL_SCROLLBODY_PAGEDOWN, TRUE ) );
/*?*/ 	}

/*N*/ 	if ( SFX_ITEM_AVAILABLE == rSet.GetItemState(SID_ATTR_YEAR2000) )
/*N*/ 	{

/*?*/ 		FmFormShell* pShell = (FmFormShell*) aShellTable.Get(RID_FORMLAYER_TOOLBOX);
/*?*/ 		if( pShell )
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 UINT16 nState = 0;
/*?*/ 		}
/*?*/ 	}

/*N*/ 	if ( !pView->GetTextEditOutliner() )
/*N*/ 	{
/*N*/ 		rSet.DisableItem( SID_TRANSLITERATE_UPPER );
/*N*/ 		rSet.DisableItem( SID_TRANSLITERATE_LOWER );
/*N*/ 		rSet.DisableItem( SID_TRANSLITERATE_HALFWIDTH );
/*N*/ 		rSet.DisableItem( SID_TRANSLITERATE_FULLWIDTH );
/*N*/ 		rSet.DisableItem( SID_TRANSLITERATE_HIRAGANA );
/*N*/ 		rSet.DisableItem( SID_TRANSLITERATE_KATAGANA );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*?*/         SvtCJKOptions aCJKOptions;
/*?*/ 		if( !aCJKOptions.IsChangeCaseMapEnabled() )
/*?*/ 		{
/*?*/ 			rSet.DisableItem( SID_TRANSLITERATE_HALFWIDTH );
/*?*/ 			rSet.DisableItem( SID_TRANSLITERATE_FULLWIDTH );
/*?*/ 			rSet.DisableItem( SID_TRANSLITERATE_HIRAGANA );
/*?*/ 			rSet.DisableItem( SID_TRANSLITERATE_KATAGANA );
/*?*/ 		}
/*N*/ 	}
/*N*/ }


/*************************************************************************
|*
|* Status der Attribut-Items
|*
\************************************************************************/



/*************************************************************************
|*
|* Text der Selektion zurueckgeben
|*
\************************************************************************/


/*************************************************************************
|*
|* Ist etwas selektiert?
|*
\************************************************************************/



}
