/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_viewshe2.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 18:48:00 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SVXIDS_HRC

#include <bf_svx/svxids.hrc>
#endif
#ifndef _SCRBAR_HXX //autogen
#include <vcl/scrbar.hxx>
#endif
#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif


#ifdef STARIMAGE_AVAILABLE
#endif

#include "strings.hrc"
#include "app.hrc"

#ifndef _SD_UNOKYWDS_HXX_
#include "unokywds.hxx"
#endif

#include "frmview.hxx"
#include "sdview.hxx"
#include "docshell.hxx"
#include "fusearch.hxx"
#include "fuslshow.hxx"
#include "drviewsh.hxx"

#ifndef _SD_SDWINDOW_HXX
#include "sdwindow.hxx"
#endif

namespace binfilter {

#ifndef SO2_DECL_SVINPLACEOBJECT_DEFINED
#define SO2_DECL_SVINPLACEOBJECT_DEFINED
SO2_DECL_REF(SvInPlaceObject)
#endif
#ifndef SO2_DECL_SVSTORAGE_DEFINED
#define SO2_DECL_SVSTORAGE_DEFINED
SO2_DECL_REF(SvStorage)
#endif

#ifdef WNT
#pragma optimize ( "", off )
#endif

using namespace ::com::sun::star;

/*************************************************************************
|*
|* Scrollbar-Update: Thumbpos und VisibleSize anpassen
|*
\************************************************************************/

/*N*/ void SdViewShell::UpdateScrollBars()
/*N*/ {
/*N*/ 	short i;
/*N*/ 
/*N*/ 	for (i = 0; i < MAX_HSPLIT_CNT && pHScrlArray[i]; i++)
/*N*/ 	{
/*N*/ 		long nW = (long)(pWinArray[i][0]->GetVisibleWidth() * 32000);
/*N*/ 		long nX = (long)(pWinArray[i][0]->GetVisibleX() * 32000);
/*N*/ 		pHScrlArray[i]->SetVisibleSize(nW);
/*N*/ 		pHScrlArray[i]->SetThumbPos(nX);
/*N*/ 		nW = 32000 - nW;
/*N*/ 		long nLine = (long) (pWinArray[i][0]->GetScrlLineWidth() * nW);
/*N*/ 		long nPage = (long) (pWinArray[i][0]->GetScrlPageWidth() * nW);
/*N*/ 		pHScrlArray[i]->SetLineSize(nLine);
/*N*/ 		pHScrlArray[i]->SetPageSize(nPage);
/*N*/ 	}
/*N*/ 
/*N*/ 	for (i = 0; i < MAX_VSPLIT_CNT && pVScrlArray[i]; i++)
/*N*/ 	{
/*N*/ 		long nH = (long)(pWinArray[0][i]->GetVisibleHeight() * 32000);
/*N*/ 		long nY = (long)(pWinArray[0][i]->GetVisibleY() * 32000);
/*N*/ 		pVScrlArray[i]->SetVisibleSize(nH);
/*N*/ 		pVScrlArray[i]->SetThumbPos(nY);
/*N*/ 		nH = 32000 - nH;
/*N*/ 		long nLine = (long) (pWinArray[0][i]->GetScrlLineHeight() * nH);
/*N*/ 		long nPage = (long) (pWinArray[0][i]->GetScrlPageHeight() * nH);
/*N*/ 		pVScrlArray[i]->SetLineSize(nLine);
/*N*/ 		pVScrlArray[i]->SetPageSize(nPage);
/*N*/ 	}
/*N*/ 	if ( bHasRuler )
/*N*/ 	{
/*N*/ 		UpdateHRuler();
/*N*/ 		UpdateVRuler();
/*N*/ 	}
/*N*/ 
/*N*/ }
/*************************************************************************
|*
|* Handling fuer horizontale Scrollbars
|*
\************************************************************************/

IMPL_LINK_INLINE_START( SdViewShell, HScrollHdl, ScrollBar *, pHScroll )
{
	DBG_BF_ASSERT(0, "STRIP"); return 0; //STRIP001 return VirtHScrollHdl(pHScroll);
}
IMPL_LINK_INLINE_END( SdViewShell, HScrollHdl, ScrollBar *, pHScroll )

/*************************************************************************
|*
|* virtueller Scroll-Handler fuer horizontale Scrollbars
|*
\************************************************************************/


/*************************************************************************
|*
|* Handling fuer vertikale Scrollbars
|*
\************************************************************************/

IMPL_LINK_INLINE_START( SdViewShell, VScrollHdl, ScrollBar *, pVScroll )
{
	DBG_BF_ASSERT(0, "STRIP"); return 0; //STRIP001 return VirtVScrollHdl(pVScroll);
}
IMPL_LINK_INLINE_END( SdViewShell, VScrollHdl, ScrollBar *, pVScroll )

/*************************************************************************
|*
|* Handling fuer vertikale Scrollbars
|*
\************************************************************************/


/*************************************************************************
|*
|* Eine bestimmte Anzahl von Zeilen scrollen (wird beim automatischen
|* Scrollen (Zeichen/Draggen) verwendet)
|*
\************************************************************************/


/*************************************************************************
|*
|* Window um nScrollX, nScrollY scrollen
|*
\************************************************************************/


/*************************************************************************
|*
|* Den Zoomfaktor fuer alle Split-Windows setzen
|*
\************************************************************************/


/*************************************************************************
|*
|* Zoomrechteck fuer aktives Fenster einstellen und alle Split-Windows
|* auf den gleichen Zoomfaktor setzen
|*
\************************************************************************/


/*************************************************************************
|*
|* Abbildungsparameter fuer alle Split-Windows initialisieren
|*
\************************************************************************/

/*N*/ void SdViewShell::InitWindows(const Point& rViewOrigin, const Size& rViewSize,
/*N*/ 							  const Point& rWinPos, BOOL bUpdate)
/*N*/ {
/*N*/ 	for (short nX = 0; nX < MAX_HSPLIT_CNT; nX++)
/*N*/ 	{
/*N*/ 		for (short nY = 0; nY < MAX_VSPLIT_CNT; nY++)
/*N*/ 		{
/*N*/ 			if ( pWinArray[nX][nY] )
/*N*/ 			{
/*N*/ 				pWinArray[nX][nY]->SetViewOrigin(rViewOrigin);
/*N*/ 				pWinArray[nX][nY]->SetViewSize(rViewSize);
/*N*/ 				pWinArray[nX][nY]->SetWinViewPos(rWinPos);
/*N*/ 
/*N*/ 				if ( bUpdate )
/*N*/ 				{
/*N*/ 					pWinArray[nX][nY]->UpdateMapOrigin();
/*N*/ 					pWinArray[nX][nY]->Invalidate();
/*N*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	Size aVisSizePixel = pWindow->GetOutputSizePixel();
/*N*/ 	Rectangle aVisAreaWin = pWindow->PixelToLogic( Rectangle( Point(0,0), aVisSizePixel) );
/*N*/ 	VisAreaChanged(aVisAreaWin);
/*N*/ 
/*N*/ 	SdView* pView = GetView();
/*N*/ 	if (pView)
/*N*/ 	{
/*N*/ 		pView->VisAreaChanged(pWindow);
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* Alle Split-Windows unter dem uebergebenen Rechteck invalidieren
|*
\************************************************************************/

/*N*/ void SdViewShell::InvalidateWindows()
/*N*/ {
/*N*/ 	for (short nX = 0; nX < MAX_HSPLIT_CNT; nX++)
/*N*/ 		for (short nY = 0; nY < MAX_VSPLIT_CNT; nY++)
/*N*/ 			if ( pWinArray[nX][nY] )
/*N*/ 				pWinArray[nX][nY]->Invalidate();
/*N*/ }

/*************************************************************************
|*
|* ObjectBar umschalten, ResourceID der alten ObjectBar-ID zurueckgeben
|*
\************************************************************************/

/*N*/ USHORT SdViewShell::SwitchObjectBar(USHORT nSdResId)
/*N*/ {
/*N*/ 	USHORT nReturn = nCurrentObjectBar;
/*N*/ 
/*N*/ 	if (nCurrentObjectBar != nSdResId && bObjectBarSwitchEnabled)
/*N*/ 	{
/*N*/ 		nCurrentObjectBar = nSdResId;
/*N*/ 
/*N*/ 		if (nCurrentObjectBar)
/*N*/ 		{
/*N*/ 			//  SfxDispatcher* pDispatcher = GetViewFrame()->GetDispatcher();
/*N*/ 			//pDispatcher->Push(*(SfxShell*)aShellTable.Get(nCurrentObjectBar));
/*N*/ 			RemoveSubShell();
/*N*/ 
/*N*/ 			if ( ISA(SdDrawViewShell) )
/*N*/ 			{
/*N*/ 				AddSubShell( *(SfxShell*) aShellTable.Get( RID_FORMLAYER_TOOLBOX ) );
/*N*/ 
/*N*/  				if ( nCurrentObjectBar == RID_DRAW_TEXT_TOOLBOX )
/*?*/  					AddSubShell( *(SfxShell*) aShellTable.Get( RID_DRAW_OBJ_TOOLBOX ) );
/*N*/  			}
/*N*/ 
/*N*/ 			AddSubShell( *(SfxShell*) aShellTable.Get( nCurrentObjectBar ) );
/*N*/ 		}
/*N*/ 	}
/*N*/ 	return nReturn;
/*N*/ }

/*************************************************************************
|*
|* Auf allen Split-Windows ein Markierungsrechteck mit dem
|* uebergebenen Pen zeichnen
|*
\************************************************************************/



/*************************************************************************
|*
|* Auf allen Split-Windows ein Rechteck zeichnen. Fuer den Rahmen wird der
|* uebergebene Pen, zum Fuellen die uebergebene Brush benutzt.
|*
\************************************************************************/


/*************************************************************************
|*
|* Modus-Umschaltung (Draw, Slide, Outline)
|*
\************************************************************************/

IMPL_LINK( SdViewShell, ModeBtnHdl, Button *, pButton )
{
	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if	( !((ImageButton*) pButton)->IsChecked() )
	return 0;
}

/*************************************************************************
|*
|* Groesse und Raender aller Seiten setzen
|*
\************************************************************************/


/*************************************************************************
|*
|* Zoom-Faktor fuer InPlace einstellen
|*
\************************************************************************/



/*************************************************************************
|*
|* Aktives Fenster setzen
|*
\************************************************************************/

/*N*/ void SdViewShell::SetActiveWindow(SdWindow* pWin)
/*N*/ {
/*N*/ 	if (GetWindow() != pWin)
/*N*/ 	{
/*N*/ 		if (pWin)
/*N*/ 		{
/*N*/ 			pWin->EnableChildTransparentMode();
/*N*/ 		}
/*N*/ 
/*N*/ 		SetWindow(pWin);
/*N*/ 	}
/*N*/ 
/*N*/ 	if (pWindow != pWin)
/*N*/ 	{
/*N*/ 		pWindow = pWin;
/*N*/ 
/*N*/ 		SdView* pView = GetView();
/*N*/ 
/*N*/ 		if (pView)
/*N*/ 		{
/*?*/ 			pView->SetActualWin(pWin);
/*N*/ 		}
/*N*/ 		if (pFuSlideShow)
/*N*/ 		{
/*?*/ 			pFuSlideShow->SetWindow(pWin);
/*N*/ 		}
/*N*/ 		if (pFuActual)
/*N*/ 		{
/*?*/ 			pFuActual->SetWindow(pWin);
/*N*/ 		}
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* RequestHelp event
|*
\************************************************************************/




/*************************************************************************
|*
|* Read FrameViews data and set actual views data
|*
\************************************************************************/




/*************************************************************************
|*
|* Write actual views data to FrameView
|*
\************************************************************************/

/*N*/ void SdViewShell::WriteFrameViewData()
/*N*/ {
/*N*/ }

/*************************************************************************
|*
|* Auf allen Split-Windows ein Update erzwingen.
|*
\************************************************************************/


/*************************************************************************
|*
|* OLE-Object aktivieren
|*
\************************************************************************/

			/******************************************************
			* OLE-Objekt ist nicht mehr leer
			******************************************************/

			/******************************************************
			* Das leere OLE-Objekt bekommt ein neues IPObj
			******************************************************/

/*************************************************************************
|*
|* umschliessendes Rechteck aller (Split-)Fenster zurueckgeben.
|*
\************************************************************************/



/*************************************************************************
|*
|*
|*
\************************************************************************/

/*N*/ void SdViewShell::CancelSearching()
/*N*/ {
/*N*/ 	delete pFuSearch;
/*N*/ 	pFuSearch = NULL;
/*N*/ }

/*************************************************************************
|*
|* Read user data
|*
\************************************************************************/


/*************************************************************************
|*
|* Write user data
|*
\************************************************************************/



/*************************************************************************
|*
|* Lineale ein- / ausschalten
|*
\************************************************************************/


/*************************************************************************
|*
|* AcceptDrop
|*
\************************************************************************/


/*************************************************************************
|*
|* ExecuteDrop
|*
\************************************************************************/


#ifdef WNT
#pragma optimize ( "", on )
#endif

/*N*/ void SdViewShell::WriteUserDataSequence ( ::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue >& rSequence, sal_Bool bBrowse )
/*N*/ {
/*N*/ 	const sal_Int32 nIndex = rSequence.getLength();
/*N*/ 	rSequence.realloc( nIndex + 1 );
/*N*/ 
/*N*/     sal_uInt16 nViewID( GetViewFrame()->GetCurViewId());
/*N*/ 	rSequence[nIndex].Name = ::rtl::OUString ( RTL_CONSTASCII_USTRINGPARAM( sUNO_View_ViewId ) );
/*N*/ 	::rtl::OUStringBuffer sBuffer ( ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM( "view" ) ) );
/*N*/ 	sBuffer.append( static_cast<sal_Int32>(nViewID));
/*N*/ 	rSequence[nIndex].Value <<= sBuffer.makeStringAndClear();
/*N*/ 
/*N*/ 	pFrameView->WriteUserDataSequence( rSequence, bBrowse );
/*N*/ }


/*N*/ void SdViewShell::VisAreaChanged(const Rectangle& rRect)
/*N*/ {
/*N*/ 	SfxViewShell::VisAreaChanged(rRect);
/*N*/ }



}
