/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_doctemplates.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 19:28:10 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#include "doctemplates.hxx"

#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif

#ifndef  _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _SV_RESARY_HXX
#include <tools/resary.hxx>
#endif
#ifndef _SV_SETTINGS_HXX
#include <vcl/settings.hxx>
#endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _SV_WRKWIN_HXX
#include <vcl/wrkwin.hxx>
#endif

#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include <svtools/pathoptions.hxx>
#endif

#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif

#ifndef  _COM_SUN_STAR_BEANS_PROPERTYATTRIBUTE_HPP_
#include <com/sun/star/beans/PropertyAttribute.hpp>
#endif
#ifndef  _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif
#ifndef  _COM_SUN_STAR_BEANS_XPROPERTYSETINFO_HPP_
#include <com/sun/star/beans/XPropertySetInfo.hpp>
#endif
#ifndef  _COM_SUN_STAR_BEANS_XPROPERTYCONTAINER_HPP_
#include <com/sun/star/beans/XPropertyContainer.hpp>
#endif

#ifndef  _COM_SUN_STAR_DOCUMENT_XTYPEDETECTION_HPP_
#include <com/sun/star/document/XTypeDetection.hpp>
#endif

#ifndef  _COM_SUN_STAR_IO_XPERSIST_HPP_
#include <com/sun/star/io/XPersist.hpp>
#endif

#ifndef  _COM_SUN_STAR_SDBC_XRESULTSET_HPP_
#include <com/sun/star/sdbc/XResultSet.hpp>
#endif
#ifndef  _COM_SUN_STAR_SDBC_XROW_HPP_
#include <com/sun/star/sdbc/XRow.hpp>
#endif

#ifndef  _COM_SUN_STAR_UCB_NAMECLASH_HPP_
#include <com/sun/star/ucb/NameClash.hpp>
#endif
#ifndef  _COM_SUN_STAR_UCB_TRANSFERINFO_HPP_
#include <com/sun/star/ucb/TransferInfo.hpp>
#endif
#ifndef  _COM_SUN_STAR_UCB_XCOMMANDENVIRONMENT_HPP_
#include <com/sun/star/ucb/XCommandEnvironment.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTACCESS_HPP_
#include <com/sun/star/ucb/XContentAccess.hpp>
#endif

#ifndef  _COM_SUN_STAR_UNO_EXCEPTION_HPP_
#include <com/sun/star/uno/Exception.hpp>
#endif


#include "sfxresid.hxx"
#include "doc.hrc"

//-----------------------------------------------------------------------------

//=============================================================================

#define TEMPLATE_SERVICE_NAME				"com.sun.star.frame.DocumentTemplates"
#define TEMPLATE_IMPLEMENTATION_NAME		"com.sun.star.comp.sfx2.DocumentTemplates"

#define SERVICENAME_TYPEDETECTION			"com.sun.star.document.TypeDetection"
#define SERVICENAME_DOCINFO					"com.sun.star.document.DocumentProperties"

#define TEMPLATE_ROOT_URL		"vnd.sun.star.hier:/templates"
#define TITLE					"Title"
#define IS_FOLDER				"IsFolder"
#define TARGET_URL				"TargetURL"
#define TYPE_FOLDER				"application/vnd.sun.star.hier-folder"
#define TYPE_LINK				"application/vnd.sun.star.hier-link"
#define TYPE_FSYS_FOLDER		"application/vnd.sun.staroffice.fsys-folder"

#define PROPERTY_DIRLIST		"DirectoryList"
#define PROPERTY_NEEDSUPDATE	"NeedsUpdate"
#define PROPERTY_TYPE			"TypeDescription"

#define TARGET_DIR_URL			"TargetDirURL"
#define COMMAND_DELETE			"delete"
#define COMMAND_TRANSFER		"transfer"

#define STANDARD_FOLDER			"standard"

#define	C_DELIM					';'

//=============================================================================

using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::document;
using namespace ::com::sun::star::io;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::ucb;
using namespace ::com::sun::star::uno;

using namespace rtl;
using namespace ucb;
#ifndef _LEGACYBINFILTERMGR_HXX
#include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
#endif
//=============================================================================
namespace binfilter {

class WaitWindow_Impl : public WorkWindow
{
    Rectangle   _aRect;
    USHORT      _nTextStyle;
    String      _aText;

    public:
                     WaitWindow_Impl();
                    ~WaitWindow_Impl();
    virtual void     Paint( const Rectangle& rRect );
};

#define X_OFFSET 15
#define Y_OFFSET 15

//=============================================================================

struct NamePair_Impl
{
    OUString maShortName;
    OUString maLongName;
};

DECLARE_LIST( NameList_Impl, NamePair_Impl* )//STRIP008 ;

class Updater_Impl;
class GroupList_Impl;
class EntryData_Impl;
class GroupData_Impl;

//=============================================================================

/*N*/ class SfxDocTplService_Impl
/*N*/ {
/*N*/ 	Reference< XMultiServiceFactory >	mxFactory;
/*N*/ 	Reference< XCommandEnvironment >	maCmdEnv;
/*N*/ 	Reference< XPersist >				mxInfo;
/*N*/ 	Reference< XTypeDetection >			mxType;
/*N*/ 
/*N*/ 	::osl::Mutex				maMutex;
/*N*/ 	Sequence< OUString >		maTemplateDirs;
/*N*/ 	OUString					maRootURL;
/*N*/ 	NameList_Impl				maNames;
/*N*/ 	Locale						maLocale;
/*N*/ 	Content						maRootContent;
/*N*/ 	Updater_Impl*				mpUpdater;
/*N*/ 	sal_Bool					mbIsInitialized : 1;
/*N*/ 	sal_Bool					mbLocaleSet		: 1;
/*N*/ 
/*N*/ 
/*N*/ 	void						init_Impl();
/*N*/ 	void						getDefaultLocale();
/*N*/ 	void						getDirList();
/*N*/ 	void						readFolderList();
/*N*/     sal_Bool                    needsUpdate();
/*N*/ 	OUString					getLongName( const OUString& rShortName );
/*N*/ 	sal_Bool					getTitleFromURL( const OUString& rURL, OUString& aTitle, OUString& aType );
/*N*/ 
/*N*/ 	sal_Bool					addEntry( Content& rParentFolder,
/*N*/                                           const OUString& rTitle,
/*N*/                                           const OUString& rTargetURL,
/*N*/                                           const OUString& rType );
/*N*/ 
/*N*/     sal_Bool                    createFolder( const OUString& rNewFolderURL,
/*N*/                                               sal_Bool  bCreateParent,
/*N*/                                               sal_Bool  bFsysFolder,
/*N*/                                               Content   &rNewFolder );
/*N*/     sal_Bool                    removeContent( Content& rContent );
/*N*/     sal_Bool                    removeContent( const OUString& rContentURL );
/*N*/ 
/*N*/     sal_Bool                    setProperty( Content& rContent,
/*N*/                                              const OUString& rPropName,
/*N*/                                              const Any& rPropValue );
/*N*/     sal_Bool                    getProperty( Content& rContent,
/*N*/                                              const OUString& rPropName,
/*N*/                                              Any& rPropValue );
/*N*/ 
/*N*/     void                        createFromContent( GroupList_Impl& rList,
/*N*/                                                    Content &rContent,
/*N*/                                                    sal_Bool bHierarchy );
/*N*/     void                        addHierGroup( GroupList_Impl& rList,
/*N*/                                               const OUString& rTitle,
/*N*/                                               const OUString& rOwnURL );
/*N*/     void                        addFsysGroup( GroupList_Impl& rList,
/*N*/                                               const OUString& rTitle,
/*N*/                                               const OUString& rOwnURL );
/*N*/     void                        removeFromHierarchy( EntryData_Impl *pData );
/*N*/     void                        addToHierarchy( GroupData_Impl *pGroup,
/*N*/                                                 EntryData_Impl *pData );
/*N*/ 
/*N*/     void                        removeFromHierarchy( GroupData_Impl *pGroup );
/*N*/     void                        addGroupToHierarchy( GroupData_Impl *pGroup );
/*N*/ 
/*N*/     void                        updateData( EntryData_Impl *pData );
/*N*/ 
/*N*/ public:
/*N*/                                  SfxDocTplService_Impl( Reference< XMultiServiceFactory > xFactory );
/*N*/                                 ~SfxDocTplService_Impl();
/*N*/ 
/*N*/     sal_Bool                    init() { if ( !mbIsInitialized ) init_Impl(); return mbIsInitialized; }
/*N*/     Content                     getContent() { return maRootContent; }
/*N*/ 
/*N*/     void                        setLocale( const LOCALE & rLocale );
/*N*/     Locale                      getLocale();
/*N*/ 
/*N*/ 	sal_Bool 					storeTemplate( const OUString& rGroupName,
/*N*/                                                const OUString& rTemplateName,
/*N*/                                                const Reference< XSTORABLE >& rStorable );
/*N*/ 
/*N*/     sal_Bool                    addTemplate( const OUString& rGroupName,
/*N*/                                              const OUString& rTemplateName,
/*N*/                                              const OUString& rSourceURL );
/*N*/     sal_Bool                    removeTemplate( const OUString& rGroupName,
/*N*/                                                 const OUString& rTemplateName );
/*N*/     sal_Bool                    renameTemplate( const OUString& rGroupName,
/*N*/                                                 const OUString& rOldName,
/*N*/                                                 const OUString& rNewName );
/*N*/ 
/*N*/     sal_Bool                    addGroup( const OUString& rGroupName );
/*N*/     sal_Bool                    removeGroup( const OUString& rGroupName );
/*N*/     sal_Bool                    renameGroup( const OUString& rOldName,
/*N*/                                              const OUString& rNewName );
/*N*/ 
/*N*/     void                        update( sal_Bool bUpdateNow );
/*N*/     void                        doUpdate();
/*N*/     void                        finished() { mpUpdater = NULL; }
/*N*/ };

//=============================================================================

/*N*/ class Updater_Impl : public ::vos::OThread
/*N*/ {
/*N*/ private:
/*N*/     SfxDocTplService_Impl   *mpDocTemplates;
/*N*/ 
/*N*/ public:
/*N*/                              Updater_Impl( SfxDocTplService_Impl* pTemplates );
/*N*/                             ~Updater_Impl();

/*N*/     virtual void SAL_CALL   run();
/*N*/     virtual void SAL_CALL   onTerminated();
/*N*/ };

//=============================================================================

/*N*/ class EntryData_Impl
/*N*/ {
/*N*/     OUString            maTitle;
/*N*/     OUString            maType;
/*N*/     OUString            maTargetURL;
/*N*/     OUString            maHierarchyURL;
/*N*/ 
/*N*/     sal_Bool            mbInHierarchy   : 1;
/*N*/     sal_Bool            mbInUse         : 1;
/*N*/     sal_Bool            mbUpdateType    : 1;
/*N*/     sal_Bool            mbUpdateLink    : 1;
/*N*/ 
/*N*/ public:
/*N*/                         EntryData_Impl( const OUString& rTitle );
/*N*/ 
/*N*/     void                setInUse() { mbInUse = sal_True; }
/*N*/     void                setHierarchy( sal_Bool bInHierarchy ) { mbInHierarchy = bInHierarchy; }
/*N*/     void                setUpdateLink( sal_Bool bUpdateLink ) { mbUpdateLink = bUpdateLink; }
/*N*/     void                setUpdateType( sal_Bool bUpdateType ) { mbUpdateType = bUpdateType; }
/*N*/ 
/*N*/     sal_Bool            getInUse() const { return mbInUse; }
/*N*/     sal_Bool            getInHierarchy() const { return mbInHierarchy; }
/*N*/     sal_Bool            getUpdateLink() const { return mbUpdateLink; }
/*N*/     sal_Bool            getUpdateType() const { return mbUpdateType; }
/*N*/ 
/*N*/     const OUString&     getHierarchyURL() const { return maHierarchyURL; }
/*N*/     const OUString&     getTargetURL() const { return maTargetURL; }
/*N*/     const OUString&     getTitle() const { return maTitle; }
/*N*/     const OUString&     getType() const { return maType; }
/*N*/ 
/*N*/     void                setHierarchyURL( const OUString& rURL ) { maHierarchyURL = rURL; }
/*N*/     void                setTargetURL( const OUString& rURL ) { maTargetURL = rURL; }
/*N*/     void                setType( const OUString& rType ) { maType = rType; }
/*N*/ };
/*N*/ 
/*N*/ DECLARE_LIST( EntryList_Impl, EntryData_Impl* )//STRIP008 ;

//=============================================================================

/*N*/ class GroupData_Impl
/*N*/ {
/*N*/     EntryList_Impl      maEntries;
/*N*/     OUString            maTitle;
/*N*/     OUString            maHierarchyURL;
/*N*/     OUString            maTargetURL;
/*N*/     sal_Bool            mbInUse         : 1;
/*N*/     sal_Bool            mbInHierarchy   : 1;
/*N*/ 
/*N*/ public:
/*N*/                         GroupData_Impl( const OUString& rTitle );
/*N*/                         ~GroupData_Impl();
/*N*/ 
/*N*/     void                setInUse() { mbInUse = sal_True; }
/*N*/     void                setHierarchy( sal_Bool bInHierarchy ) { mbInHierarchy = bInHierarchy; }
/*N*/     void                setHierarchyURL( const OUString& rURL ) { maHierarchyURL = rURL; }
/*N*/     void                setTargetURL( const OUString& rURL ) { maTargetURL = rURL; }
/*N*/ 
/*N*/     sal_Bool            getInUse() { return mbInUse; }
/*N*/     sal_Bool            getInHierarchy() { return mbInHierarchy; }
/*N*/     const OUString&     getHierarchyURL() const { return maHierarchyURL; }
/*N*/     const OUString&     getTargetURL() const { return maTargetURL; }
/*N*/     const OUString&     getTitle() const { return maTitle; }
/*N*/ 
/*N*/     EntryData_Impl*     addEntry( const OUString& rTitle,
/*N*/                                   const OUString& rTargetURL,
/*N*/                                   const OUString& rType,
/*N*/                                   const OUString& rHierURL );
/*N*/     ULONG               count() { return maEntries.Count(); }
/*N*/     EntryData_Impl*     getEntry( ULONG nPos ) { return maEntries.GetObject( nPos ); }
/*N*/ };
/*N*/ 
/*N*/ DECLARE_LIST( GroupList_Impl, GroupData_Impl* )//STRIP008 ;

//=============================================================================
//=============================================================================
//=============================================================================

//-----------------------------------------------------------------------------
// private SfxDocTplService_Impl
//-----------------------------------------------------------------------------
/*N*/ void SfxDocTplService_Impl::init_Impl()
/*N*/ {
/*N*/     ::osl::ClearableMutexGuard aGuard( maMutex );
/*N*/ 	sal_Bool bIsInitialized = sal_False;
/*N*/ 	sal_Bool bNeedsUpdate   = sal_False;
/*N*/ 
/*N*/     if ( !mbLocaleSet )
/*?*/         getDefaultLocale();
/*N*/ 
/*N*/     // convert locale to string
/*N*/     OUString aLang = maLocale.Language;
/*N*/     aLang += OUString( '-' );
/*N*/     aLang += maLocale.Country;
/*N*/ 
/*N*/     // set maRootContent to the root of the templates hierarchy. Create the
/*N*/     // entry if necessary
/*N*/ 
/*N*/     maRootURL = OUString( RTL_CONSTASCII_USTRINGPARAM( TEMPLATE_ROOT_URL ) );
/*N*/     maRootURL += OUString( '/' );
/*N*/     maRootURL += aLang;
/*N*/ 
/*N*/     if ( Content::create( maRootURL, maCmdEnv, maRootContent ) )
/*N*/ 		bIsInitialized = sal_True;
/*N*/ 	else
/*N*/     {
/*N*/ 		bIsInitialized = createFolder( maRootURL, sal_True, sal_False, maRootContent );
/*N*/         bNeedsUpdate = sal_True;
/*N*/     }
/*N*/ 
/*N*/ 	if ( bIsInitialized )
/*N*/     {
/*N*/         OUString aService( RTL_CONSTASCII_USTRINGPARAM( SERVICENAME_DOCINFO ) );
/*N*/         mxInfo = Reference< XPersist > ( mxFactory->createInstance( aService ), UNO_QUERY );
/*N*/ 
/*N*/         aService = OUString( RTL_CONSTASCII_USTRINGPARAM( SERVICENAME_TYPEDETECTION ) );
/*N*/         mxType = Reference< XTypeDetection > ( mxFactory->createInstance( aService ), UNO_QUERY );
/*N*/ 
/*N*/         getDirList();
/*N*/         readFolderList();
/*N*/ 
/*N*/ 		if ( bNeedsUpdate || needsUpdate() )
/*N*/ 		{
/*N*/             aGuard.clear();
/*N*/             ::vos::OClearableGuard aSolarGuard( Application::GetSolarMutex() );
/*N*/ 
/*N*/             WaitWindow_Impl* pWin = new WaitWindow_Impl();
/*N*/ 
/*N*/             aSolarGuard.clear();
/*N*/             ::osl::ClearableMutexGuard anotherGuard( maMutex );
/*N*/ 
/*N*/ 			update( sal_True );
/*N*/ 
/*N*/             anotherGuard.clear();
/*N*/             ::vos::OGuard aSecondSolarGuard( Application::GetSolarMutex() );
/*N*/ 
/*N*/             delete pWin;
/*N*/         }
/*N*/     }
/*N*/     else
/*N*/     {
/*N*/         DBG_ERRORFILE( "init_Impl(): Could not create root" );
/*N*/     }
/*N*/ 
/*N*/     mbIsInitialized = bIsInitialized;
/*N*/ }

//-----------------------------------------------------------------------------
/*?*/ void SfxDocTplService_Impl::getDefaultLocale()
/*?*/ {
/*?*/     AllSettings aSettings;
/*?*/ 
/*?*/     maLocale    = aSettings.GetLocale();
/*?*/     mbLocaleSet = sal_True;
/*?*/ }

// -----------------------------------------------------------------------
/*N*/ void SfxDocTplService_Impl::readFolderList()
/*N*/ {
/*N*/     ::vos::OGuard aGuard( Application::GetSolarMutex() );
/*N*/ 
/*N*/     ResStringArray  aShortNames( SfxResId( TEMPLATE_SHORT_NAMES_ARY ) );
/*N*/     ResStringArray  aLongNames( SfxResId( TEMPLATE_LONG_NAMES_ARY ) );
/*N*/ 
/*N*/     NamePair_Impl*  pPair;
/*N*/ 
/*N*/     USHORT nCount = Min( aShortNames.Count(), aLongNames.Count() );
/*N*/ 
/*N*/     for ( USHORT i=0; i<nCount; i++ )
/*N*/     {
/*N*/         pPair = new NamePair_Impl;
/*N*/         pPair->maShortName  = aShortNames.GetString( i );
/*N*/         pPair->maLongName   = aLongNames.GetString( i );
/*N*/ 
/*N*/         maNames.Insert( pPair, LIST_APPEND );
/*N*/     }
/*N*/ }

// -----------------------------------------------------------------------
/*N*/ OUString SfxDocTplService_Impl::getLongName( const OUString& rShortName )
/*N*/ {
/*N*/     OUString         aRet;
/*N*/     NamePair_Impl   *pPair = maNames.First();
/*N*/ 
/*N*/     while ( pPair )
/*N*/     {
/*N*/         if ( pPair->maShortName == rShortName )
/*N*/         {
/*N*/             aRet = pPair->maLongName;
/*N*/             break;
/*N*/         }
/*N*/         else
/*N*/             pPair = maNames.Next();
/*N*/     }
/*N*/ 
/*N*/     if ( !aRet.getLength() )
/*N*/         aRet = rShortName;
/*N*/ 
/*N*/     return aRet;
/*N*/ }

//-----------------------------------------------------------------------------
/*N*/ void SfxDocTplService_Impl::getDirList()
/*N*/ {
/*N*/     OUString aPropName( RTL_CONSTASCII_USTRINGPARAM( PROPERTY_DIRLIST ) );
/*N*/     Any      aValue;
/*N*/ 
/*N*/     // Get the template dir list
/*N*/     INetURLObject   aURL;
/*N*/     String          aDirs = SvtPathOptions().GetTemplatePath();
/*N*/     USHORT          nCount = aDirs.GetTokenCount( C_DELIM );
/*N*/ 
/*N*/     maTemplateDirs = Sequence< OUString >( nCount );
/*N*/ 
/*N*/     for ( USHORT i=0; i<nCount; i++ )
/*N*/     {
/*N*/         aURL.SetSmartProtocol( INET_PROT_FILE );
/*N*/         aURL.SetURL( aDirs.GetToken( i, C_DELIM ) );
/*N*/         maTemplateDirs[i] = aURL.GetMainURL( INetURLObject::NO_DECODE );
/*N*/     }
/*N*/ 
/*N*/     aValue <<= maTemplateDirs;
/*N*/ 
/*N*/     // Store the template dir list
/*N*/     setProperty( maRootContent, aPropName, aValue );
/*N*/ }

//-----------------------------------------------------------------------------
/*N*/ sal_Bool SfxDocTplService_Impl::needsUpdate()
/*N*/ {
/*N*/ 	OUString aPropName( RTL_CONSTASCII_USTRINGPARAM( PROPERTY_NEEDSUPDATE ) );
/*N*/ 	sal_Bool bHasProperty = sal_False;
/*N*/     sal_Bool bNeedsUpdate = sal_True;
/*N*/ 	Any		 aValue;
/*N*/ 
/*N*/ 	// Get the template dir list
/*N*/ 	bHasProperty = getProperty( maRootContent, aPropName, aValue );
/*N*/ 
/*N*/ 	if ( bHasProperty )
/*N*/ 		aValue >>= bNeedsUpdate;
/*N*/ 
/*N*/     return bNeedsUpdate;
/*N*/ }

// -----------------------------------------------------------------------
/*N*/ sal_Bool SfxDocTplService_Impl::getTitleFromURL( const OUString& rURL, OUString& aTitle, OUString& aType )
/*N*/ {
/*N*/     if ( mxInfo.is() )
/*N*/     {
/*N*/         try
/*N*/         {
/*N*/             mxInfo->read( rURL );
/*N*/ 		}
/*N*/         catch ( Exception& ) 
/*N*/ 		{
/*N*/ 			// the document is not a StarOffice document
/*N*/ 			return sal_False;
/*N*/ 		}
/*N*/ 
/*N*/         try
/*N*/ 		{
/*N*/             Reference< XPropertySet > aPropSet( mxInfo, UNO_QUERY );
/*N*/             if ( aPropSet.is() )
/*N*/             {
/*N*/                 OUString aPropName( RTL_CONSTASCII_USTRINGPARAM( TITLE ) );
/*N*/                 Any aValue = aPropSet->getPropertyValue( aPropName );
/*N*/                 aValue >>= aTitle;
/*N*/ 
/*N*/                 aPropName = OUString( RTL_CONSTASCII_USTRINGPARAM( "MIMEType" ) );
/*N*/                 aValue = aPropSet->getPropertyValue( aPropName );
/*N*/                 aValue >>= aType;
/*N*/             }
/*N*/         }
/*N*/         catch ( UnknownPropertyException& ) {}
/*N*/         catch ( Exception& ) {}
/*N*/     }
/*N*/ 
/*N*/     if ( ! aType.getLength() && mxType.is() )
/*N*/     {
/*N*/         aType = mxType->queryTypeByURL( rURL );
/*N*/     }
/*N*/ 
/*N*/     if ( ! aTitle.getLength() )
/*N*/     {
/*N*/         INetURLObject aURL( rURL );
/*N*/         aURL.CutExtension();
/*N*/         aTitle = aURL.getName( INetURLObject::LAST_SEGMENT, true,
/*N*/                                INetURLObject::DECODE_WITH_CHARSET );
/*N*/     }
/*N*/ 
/*N*/ 	return sal_True;
/*N*/ }

// -----------------------------------------------------------------------
/*N*/ sal_Bool SfxDocTplService_Impl::addEntry( Content& rParentFolder,
/*N*/                                           const OUString& rTitle,
/*N*/                                           const OUString& rTargetURL,
/*N*/                                           const OUString& rType )
/*N*/ {
/*N*/     sal_Bool bAddedEntry = sal_False;
/*N*/ 
/*N*/     INetURLObject aLinkObj( rParentFolder.getURL() );
/*N*/     aLinkObj.insertName( rTitle, false,
/*N*/                       INetURLObject::LAST_SEGMENT, true,
/*N*/                       INetURLObject::ENCODE_ALL );
/*N*/     OUString aLinkURL = aLinkObj.GetMainURL( INetURLObject::NO_DECODE );
/*N*/ 
/*N*/     Content aLink;
/*N*/ 
/*N*/     if ( ! Content::create( aLinkURL, maCmdEnv, aLink ) )
/*N*/     {
/*N*/         Sequence< OUString > aNames(3);
/*N*/         aNames[0] = OUString( RTL_CONSTASCII_USTRINGPARAM( TITLE ) );
/*N*/         aNames[1] = OUString( RTL_CONSTASCII_USTRINGPARAM( IS_FOLDER ) );
/*N*/         aNames[2] = OUString( RTL_CONSTASCII_USTRINGPARAM( TARGET_URL ) );
/*N*/ 
/*N*/         Sequence< Any > aValues(3);
/*N*/         aValues[0] = makeAny( rTitle );
/*N*/         aValues[1] = makeAny( sal_Bool( sal_False ) );
/*N*/         aValues[2] = makeAny( rTargetURL );
/*N*/ 
/*N*/         OUString aType( RTL_CONSTASCII_USTRINGPARAM( TYPE_LINK ) );
/*N*/         OUString aAdditionalProp( RTL_CONSTASCII_USTRINGPARAM( PROPERTY_TYPE ) );
/*N*/ 
/*N*/         try
/*N*/         {
/*N*/             rParentFolder.insertNewContent( aType, aNames, aValues, aLink );
/*N*/             setProperty( aLink, aAdditionalProp, makeAny( rType ) );
/*N*/             bAddedEntry = sal_True;
/*N*/         }
/*N*/         catch( Exception& )
/*N*/         {}
/*N*/     }
/*N*/     return bAddedEntry;
/*N*/ }

// -----------------------------------------------------------------------
/*N*/ sal_Bool SfxDocTplService_Impl::createFolder( const OUString& rNewFolderURL,
/*N*/                                               sal_Bool  bCreateParent,
/*N*/                                               sal_Bool  bFsysFolder,
/*N*/                                               Content   &rNewFolder )
/*N*/ {
/*N*/     Content         aParent;
/*N*/     sal_Bool        bCreatedFolder = sal_False;
/*N*/     INetURLObject   aParentURL( rNewFolderURL );
/*N*/     OUString        aFolderName = aParentURL.getName( INetURLObject::LAST_SEGMENT, true,
/*N*/                                                       INetURLObject::DECODE_WITH_CHARSET );
/*N*/ 
/*N*/     // compute the parent folder url from the new folder url
/*N*/     // and remove the final slash, because Content::create doesn't
/*N*/     // like it
/*N*/     aParentURL.removeSegment();
/*N*/     if ( aParentURL.getSegmentCount() >= 1 )
/*N*/         aParentURL.removeFinalSlash();
/*N*/ 
/*N*/     // if the parent exists, we can continue with the creation of the
/*N*/     // new folder, we have to create the parent otherwise ( as long as
/*N*/     // bCreateParent is set to true )
/*N*/     if ( Content::create( aParentURL.GetMainURL( INetURLObject::NO_DECODE ), maCmdEnv, aParent ) )
/*N*/     {
/*N*/         try
/*N*/         {
/*N*/             Sequence< OUString > aNames(2);
/*N*/             aNames[0] = OUString( RTL_CONSTASCII_USTRINGPARAM( TITLE ) );
/*N*/             aNames[1] = OUString( RTL_CONSTASCII_USTRINGPARAM( IS_FOLDER ) );
/*N*/ 
/*N*/             Sequence< Any > aValues(2);
/*N*/             aValues[0] = makeAny( aFolderName );
/*N*/             aValues[1] = makeAny( sal_Bool( sal_True ) );
/*N*/ 
/*N*/             OUString aType;
/*N*/ 
/*N*/             if ( bFsysFolder )
/*N*/                 aType = OUString( RTL_CONSTASCII_USTRINGPARAM( TYPE_FSYS_FOLDER ) );
/*N*/             else
/*N*/                 aType = OUString( RTL_CONSTASCII_USTRINGPARAM( TYPE_FOLDER ) );
/*N*/ 
/*N*/             aParent.insertNewContent( aType, aNames, aValues, rNewFolder );
/*N*/             bCreatedFolder = sal_True;
/*N*/         }
/*N*/         catch( RuntimeException& )
/*N*/         {
/*N*/             DBG_ERRORFILE( "createFolder(): got runtime exception" );
/*N*/         }
/*N*/         catch( Exception& )
/*N*/         {
/*N*/             DBG_ERRORFILE( "createFolder(): Could not create new folder" );
/*N*/         }
/*N*/     }
/*N*/     else if ( bCreateParent )
/*N*/     {
/*N*/         // if the parent doesn't exists and bCreateParent is set to true,
/*N*/         // we try to create the parent and if this was successful, we
/*N*/         // try to create the new folder again ( but this time, we set
/*N*/         // bCreateParent to false to avoid endless recusions )
/*N*/         if ( ( aParentURL.getSegmentCount() >= 1 ) &&
/*N*/                createFolder( aParentURL.GetMainURL( INetURLObject::NO_DECODE ), bCreateParent, bFsysFolder, aParent ) )
/*N*/         {
/*N*/             bCreatedFolder = createFolder( rNewFolderURL, sal_False, bFsysFolder, rNewFolder );
/*N*/         }
/*N*/     }
/*N*/ 
/*N*/     return bCreatedFolder;
/*N*/ }

// -----------------------------------------------------------------------
/*?*/ sal_Bool SfxDocTplService_Impl::removeContent( Content& rContent )
/*?*/ {DBG_BF_ASSERT(0, "STRIP");return  sal_False;//STRIP001 
/*?*/ }

// -----------------------------------------------------------------------
/*?*/ sal_Bool SfxDocTplService_Impl::removeContent( const OUString& rContentURL )
/*?*/ {DBG_BF_ASSERT(0, "STRIP");return sal_False; //STRIP001 
/*?*/ }

// -----------------------------------------------------------------------
/*N*/ sal_Bool SfxDocTplService_Impl::setProperty( Content& rContent,
/*N*/                                              const OUString& rPropName,
/*N*/                                              const Any& rPropValue )
/*N*/ {
/*N*/     sal_Bool bPropertySet = sal_False;
/*N*/ 
/*N*/     // Store the property
/*N*/     try
/*N*/     {
/*N*/         Reference< XPropertySetInfo > aPropInfo = rContent.getProperties();
/*N*/ 
/*N*/         // check, wether or not the property exists, create it, when not
/*N*/         if ( !aPropInfo.is() || !aPropInfo->hasPropertyByName( rPropName ) )
/*N*/         {
/*N*/             Reference< XPropertyContainer > xProperties( rContent.get(), UNO_QUERY );
/*N*/             if ( xProperties.is() )
/*N*/             {
/*N*/                 try
/*N*/                 {
/*N*/                     xProperties->addProperty( rPropName, PropertyAttribute::MAYBEVOID, rPropValue );
/*N*/                 }
/*N*/                 catch( PropertyExistException& ) {}
/*N*/                 catch( IllegalTypeException& ) { DBG_ERRORFILE( "IllegalTypeException" ); }
/*N*/                 catch( IllegalArgumentException& ) { DBG_ERRORFILE( "IllegalArgumentException" ); }
/*N*/             }
/*N*/         }
/*N*/ 
/*N*/         // now set the property
/*N*/ 
/*N*/         rContent.setPropertyValue( rPropName, rPropValue );
/*N*/         bPropertySet = sal_True;
/*N*/     }
/*N*/     catch ( RuntimeException& ) {}
/*N*/     catch ( Exception& ) {}
/*N*/ 
/*N*/     return bPropertySet;
/*N*/ }

// -----------------------------------------------------------------------
/*N*/ sal_Bool SfxDocTplService_Impl::getProperty( Content& rContent,
/*N*/                                              const OUString& rPropName,
/*N*/                                              Any& rPropValue )
/*N*/ {
/*N*/     sal_Bool bGotProperty = sal_False;
/*N*/ 
/*N*/     // Get the property
/*N*/     try
/*N*/     {
/*N*/         Reference< XPropertySetInfo > aPropInfo = rContent.getProperties();
/*N*/ 
/*N*/         // check, wether or not the property exists
/*N*/         if ( !aPropInfo.is() || !aPropInfo->hasPropertyByName( rPropName ) )
/*N*/         {
/*N*/             return sal_False;
/*N*/         }
/*N*/ 
/*N*/         // now get the property
/*N*/ 
/*N*/         rPropValue = rContent.getPropertyValue( rPropName );
/*N*/         bGotProperty = sal_True;
/*N*/     }
/*N*/     catch ( RuntimeException& ) {}
/*N*/     catch ( Exception& ) {}
/*N*/ 
/*N*/     return bGotProperty;
/*N*/ }

//-----------------------------------------------------------------------------
// public SfxDocTplService_Impl
//-----------------------------------------------------------------------------

/*N*/ SfxDocTplService_Impl::SfxDocTplService_Impl( Reference< XMultiServiceFactory > xFactory )
/*N*/ {
/*N*/     mxFactory       = xFactory;
/*N*/     mpUpdater       = NULL;
/*N*/     mbIsInitialized = sal_False;
/*N*/     mbLocaleSet     = sal_False;
/*N*/ }

//-----------------------------------------------------------------------------
/*N*/ SfxDocTplService_Impl::~SfxDocTplService_Impl()
/*N*/ {
/*N*/ 	::osl::MutexGuard aGuard( maMutex );
/*N*/ 
/*N*/     if ( mpUpdater )
/*N*/     {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/     }
/*N*/ }

//-----------------------------------------------------------------------------
/*?*/ Locale SfxDocTplService_Impl::getLocale()
/*?*/ {
/*?*/     ::osl::MutexGuard aGuard( maMutex );
/*?*/ 
/*?*/     if ( !mbLocaleSet )
/*?*/         getDefaultLocale();
/*?*/ 
/*?*/     return maLocale;
/*?*/ }

//-----------------------------------------------------------------------------
/*N*/ void SfxDocTplService_Impl::setLocale( const Locale &rLocale )
/*N*/ {
/*N*/     ::osl::MutexGuard aGuard( maMutex );
/*N*/ 
/*N*/     if ( mbLocaleSet &&
/*N*/          ( maLocale.Language != rLocale.Language ) &&
/*N*/          ( maLocale.Country != rLocale.Country ) )
/*N*/         mbIsInitialized = sal_False;
/*N*/ 
/*N*/     maLocale    = rLocale;
/*N*/     mbLocaleSet = sal_True;
/*N*/ }

//-----------------------------------------------------------------------------
/*N*/ void SfxDocTplService_Impl::update( sal_Bool bUpdateNow )
/*N*/ {
/*N*/     ::osl::MutexGuard aGuard( maMutex );
/*N*/ 
/*N*/     if ( bUpdateNow )
/*N*/         doUpdate();
/*N*/     else
/*N*/     {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/     }
/*N*/ }

//-----------------------------------------------------------------------------
/*N*/ void SfxDocTplService_Impl::doUpdate()
/*N*/ {
/*N*/     ::osl::MutexGuard aGuard( maMutex );
/*N*/ 
/*N*/ 	OUString aPropName( RTL_CONSTASCII_USTRINGPARAM( PROPERTY_NEEDSUPDATE ) );
/*N*/ 	Any		 aValue;
/*N*/ 
/*N*/ 	aValue <<= sal_True;
/*N*/     setProperty( maRootContent, aPropName, aValue );
/*N*/ 
/*N*/     GroupList_Impl	aGroupList;
/*N*/ 
/*N*/     // get the entries from the hierarchy
/*N*/     createFromContent( aGroupList, maRootContent, sal_True );
/*N*/ 
/*N*/     // get the entries from the template directories
/*N*/     sal_Int32   nCount = maTemplateDirs.getLength();
/*N*/     OUString*   pDirs = maTemplateDirs.getArray();
/*N*/     Content     aDirContent;
/*N*/ 
/*N*/     while ( nCount )
/*N*/     {
/*N*/         nCount--;
/*N*/         if ( Content::create( pDirs[ nCount ], maCmdEnv, aDirContent ) )
/*N*/         {
/*N*/             createFromContent( aGroupList, aDirContent, sal_False );
/*N*/         }
/*N*/     }
/*N*/ 
/*N*/     // now check the list
/*N*/     GroupData_Impl *pGroup = aGroupList.First();
/*N*/     while ( pGroup )
/*N*/     {
/*N*/         if ( pGroup->getInUse() )
/*N*/         {
/*?*/             if ( pGroup->getInHierarchy() )
/*?*/             {
/*?*/                 ULONG nCount = pGroup->count();
/*?*/                 for ( ULONG i=0; i<nCount; i++ )
/*?*/                 {
/*?*/                     EntryData_Impl *pData = pGroup->getEntry( i );
/*?*/                     if ( ! pData->getInUse() )
/*?*/                     {
/*?*/                         if ( pData->getInHierarchy() )
/*?*/                             removeFromHierarchy( pData ); // delete entry in hierarchy
/*?*/                         else
/*?*/                             addToHierarchy( pGroup, pData ); // add entry to hierarchy
/*?*/                     }
/*?*/                     else if ( pData->getUpdateType() ||
/*?*/                               pData->getUpdateLink() )
/*?*/                     {
/*?*/                         updateData( pData );
/*?*/                     }
/*?*/                 }
/*?*/             }
/*?*/             else
/*?*/             {
/*?*/                 addGroupToHierarchy( pGroup ); // add group to hierarchy
/*?*/             }
/*N*/         }
/*N*/         else
/*?*/             removeFromHierarchy( pGroup ); // delete group from hierarchy
/*N*/ 
/*N*/         delete pGroup;
/*N*/         pGroup = aGroupList.Next();
/*N*/     }
/*N*/ 
/*N*/    	aValue <<= sal_False;
/*N*/     setProperty( maRootContent, aPropName, aValue );
/*N*/ }

//-----------------------------------------------------------------------------
/*?*/ sal_Bool SfxDocTplService_Impl::addGroup( const OUString& rGroupName )
/*?*/ {
/*?*/     ::osl::MutexGuard aGuard( maMutex );
/*?*/ 
/*?*/     // Check, wether or not there is a group with this name
/*?*/     Content         aNewGroup;
/*?*/     OUString        aNewGroupURL;
/*?*/     INetURLObject   aNewGroupObj( maRootURL );
/*?*/ 
/*?*/     aNewGroupObj.insertName( rGroupName, false,
/*?*/                       INetURLObject::LAST_SEGMENT, true,
/*?*/                       INetURLObject::ENCODE_ALL );
/*?*/ 
/*?*/     aNewGroupURL = aNewGroupObj.GetMainURL( INetURLObject::NO_DECODE );
/*?*/ 
/*?*/     if ( Content::create( aNewGroupURL, maCmdEnv, aNewGroup ) ||
/*?*/          ! createFolder( aNewGroupURL, sal_False, sal_False, aNewGroup ) )
/*?*/     {
/*?*/         // if there already was a group with this name or the new group
/*?*/         // could not be created, we return here
/*?*/         return sal_False;
/*?*/     }
/*?*/ 
/*?*/     // Get the user template path entry ( new group will always
/*?*/     // be added in the user template path )
/*?*/     sal_Int32   nIndex;
/*?*/     OUString    aUserPath;
/*?*/ 
/*?*/     nIndex = maTemplateDirs.getLength();
/*?*/     if ( nIndex )
/*?*/         nIndex--;
/*?*/     else
/*?*/         return sal_False;   // We don't know where to add the group
/*?*/ 
/*?*/     aUserPath = maTemplateDirs[ nIndex ];
/*?*/ 
/*?*/     // create a new folder with the given name
/*?*/     Content         aNewFolder;
/*?*/     OUString        aNewFolderURL;
/*?*/     INetURLObject   aNewFolderObj( aUserPath );
/*?*/ 
/*?*/     aNewFolderObj.insertName( rGroupName, false,
/*?*/                       INetURLObject::LAST_SEGMENT, true,
/*?*/                       INetURLObject::ENCODE_ALL );
/*?*/ 
/*?*/     aNewFolderURL = aNewFolderObj.GetMainURL( INetURLObject::NO_DECODE );
/*?*/ 
/*?*/     if ( ! createFolder( aNewFolderURL, sal_False, sal_True, aNewFolder ) )
/*?*/     {
/*?*/         // we could not create the folder, so we delete the group in the
/*?*/         // hierarchy and return
/*?*/         removeContent( aNewGroup );
/*?*/         return sal_False;
/*?*/     }
/*?*/ 
/*?*/     // Now set the target url for this group and we are done
/*?*/     OUString aPropName( RTL_CONSTASCII_USTRINGPARAM( TARGET_DIR_URL ) );
/*?*/     Any aValue = makeAny( aNewFolderURL );
/*?*/ 
/*?*/     if ( ! setProperty( aNewGroup, aPropName, aValue ) )
/*?*/     {
/*?*/         removeContent( aNewGroup );
/*?*/         removeContent( aNewFolder );
/*?*/         return sal_False;
/*?*/     }
/*?*/ 
/*?*/     return sal_True;
/*?*/ }

//-----------------------------------------------------------------------------
/*?*/ sal_Bool SfxDocTplService_Impl::removeGroup( const OUString& rGroupName )
/*?*/ {
/*?*/     ::osl::MutexGuard aGuard( maMutex );
/*?*/ 
/*?*/     // create the group url
/*?*/     INetURLObject aGroupObj( maRootURL );
/*?*/     aGroupObj.insertName( rGroupName, false,
/*?*/                       INetURLObject::LAST_SEGMENT, true,
/*?*/                       INetURLObject::ENCODE_ALL );
/*?*/ 
/*?*/     // Get the target url
/*?*/     Content     aGroup;
/*?*/     OUString    aGroupURL = aGroupObj.GetMainURL( INetURLObject::NO_DECODE );
/*?*/     OUString    aTargetURL;
/*?*/ 
/*?*/     if ( Content::create( aGroupURL, maCmdEnv, aGroup ) )
/*?*/     {
/*?*/         OUString    aPropName( RTL_CONSTASCII_USTRINGPARAM( TARGET_DIR_URL ) );
/*?*/         Any         aValue;
/*?*/ 
/*?*/         if ( getProperty( aGroup, aPropName, aValue ) )
/*?*/             aValue >>= aTargetURL;
/*?*/     }
/*?*/     else
/*?*/     {
/*?*/         // could not create a content, so probably the group doesn't exist
/*?*/         return sal_False;
/*?*/     }
/*?*/ 
/*?*/     // delete the group in the hierarchy
/*?*/     if ( removeContent( aGroup ) && aTargetURL.getLength() )
/*?*/     {
/*?*/         // delete the folder associated with the group
/*?*/         return removeContent( aTargetURL );
/*?*/     }
/*?*/     else
/*?*/         return sal_False;
/*?*/ }

//-----------------------------------------------------------------------------
/*N*/ sal_Bool SfxDocTplService_Impl::renameGroup( const OUString& rOldName,
/*N*/                                              const OUString& rNewName )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/         return sal_False;
/*N*/ }

//-----------------------------------------------------------------------------
/*?*/ sal_Bool SfxDocTplService_Impl::storeTemplate( const OUString& rGroupName,
/*?*/                                                const OUString& rTemplateName,
/*?*/                                                const Reference< XSTORABLE >& rStorable )
/*?*/ {
/*?*/ 	int ind = 0;
/*?*/     ::osl::MutexGuard aGuard( maMutex );
/*?*/ 
/*?*/     // Check, wether or not there is a group with this name
/*?*/     // Return false, if there is no group with the given name
/*?*/     Content         aGroup, aTemplate, aTargetGroup;
/*?*/     OUString        aGroupURL, aTemplateURL;
/*?*/     INetURLObject   aGroupObj( maRootURL );
/*?*/ 
/*?*/     aGroupObj.insertName( rGroupName, false,
/*?*/                       INetURLObject::LAST_SEGMENT, true,
/*?*/                       INetURLObject::ENCODE_ALL );
/*?*/     aGroupURL = aGroupObj.GetMainURL( INetURLObject::NO_DECODE );
/*?*/ 
/*?*/     if ( ! Content::create( aGroupURL, maCmdEnv, aGroup ) )
/*?*/         return sal_False;
/*?*/ 
/*?*/     // Check, if there's a template with the given name in this group
/*?*/     // Return false, if there already is a template
/*?*/     aGroupObj.insertName( rTemplateName, false,
/*?*/                       INetURLObject::LAST_SEGMENT, true,
/*?*/                       INetURLObject::ENCODE_ALL );
/*?*/     aTemplateURL = aGroupObj.GetMainURL( INetURLObject::NO_DECODE );
/*?*/ 
/*?*/     if ( Content::create( aTemplateURL, maCmdEnv, aTemplate ) )
/*?*/         return sal_False;
/*?*/ 
/*?*/ 	// The object provided with XStorable interface must
/*?*/ 	// support one of the listed below services
/*?*/ 
/*?*/ 	// Find service name of the document
/*?*/ 	// and construct a query for it
/*?*/ 	OUString aQueryForFilter;
/*?*/ 
/*?*/ 	Reference< XSERVICEINFO > rServiceInfo( rStorable, UNO_QUERY );
/*?*/ 	if( !rServiceInfo.is() )
/*?*/ 		return sal_False;
/*?*/ 
/*?*/ 	if( rServiceInfo->supportsService( OUString::createFromAscii( "com.sun.star.text.TextDocument" ) ) )
/*?*/ 	{
/*?*/ 		aQueryForFilter = OUString::createFromAscii( "_query_writer" );
/*?*/ 	}
/*?*/ 	else if( rServiceInfo->supportsService( OUString::createFromAscii( "com.sun.star.formula.FormulaProperties" ) ) )
/*?*/ 	{
/*?*/ 		aQueryForFilter = OUString::createFromAscii( "_query_math" );
/*?*/ 	}
/*?*/ 	else if( rServiceInfo->supportsService( OUString::createFromAscii( "com.sun.star.presentation.PresentationDocument" ) ) )
/*?*/ 	{
/*?*/ 		aQueryForFilter = OUString::createFromAscii( "_query_impress" );
/*?*/ 	}
/*?*/ 	else if( rServiceInfo->supportsService( OUString::createFromAscii( "com.sun.star.drawing.DrawingDocument" ) ) )
/*?*/ 	{
/*?*/ 		aQueryForFilter = OUString::createFromAscii( "_query_draw" );
/*?*/ 	}
/*?*/ 	else if( rServiceInfo->supportsService( OUString::createFromAscii( "com.sun.star.sheet.SpreadsheetDocument" ) ) )
/*?*/ 	{
/*?*/ 		aQueryForFilter = OUString::createFromAscii( "_query_calc" );
/*?*/ 	}
/*?*/ 	else if( rServiceInfo->supportsService( OUString::createFromAscii( "com.sun.star.text.WebDocument" ) ) )
/*?*/ 	{
/*?*/ 		aQueryForFilter = OUString::createFromAscii( "_query_web" );
/*?*/ 	}
/*?*/ 	else if( rServiceInfo->supportsService( OUString::createFromAscii( "com.sun.star.text.GlobalDocument" ) ) )
/*?*/ 	{
/*?*/ 		aQueryForFilter = OUString::createFromAscii( "_query_global" );
/*?*/ 	}
/*?*/ 	else
/*?*/ 		return sal_False;
/*?*/ 
/*?*/ 	aQueryForFilter += OUString::createFromAscii( ":iflags=54:eflags=64:default_first" ); // template export filter
/*?*/ 
/*?*/ 	// Find a template filter for the document type
/*?*/ 	Reference< XMULTISERVICEFACTORY > rServiceManager = ::legacy_binfilters::getLegacyProcessServiceFactory();
/*?*/ 	if( !rServiceManager.is() )
/*?*/ 		return sal_False;
/*?*/ 
/*?*/ 	Reference< XNAMEACCESS > rFilterCFG(
/*?*/ 		rServiceManager->createInstance( OUString::createFromAscii( "com.sun.star.document.FilterFactory" ) ),
/*?*/ 		UNO_QUERY );
/*?*/ 
/*?*/ 	if( !rFilterCFG.is() )
/*?*/ 		return sal_False;
/*?*/ 
/*?*/ 	OUString aFilterName;
/*?*/ 	Sequence< OUString > aFoundFilterNames;
/*?*/ 	Any aFilterNameAny = rFilterCFG->getByName( aQueryForFilter );
/*?*/ 	aFilterNameAny >>= aFoundFilterNames;
/*?*/ 	if( aFoundFilterNames.getLength() )
/*?*/ 		aFilterName = aFoundFilterNames[0];
/*?*/ 
/*?*/ 	if( !aFilterName.getLength() ) // no filter - no template
/*?*/ 		return sal_False;
/*?*/ 
/*?*/ 	// find a type
/*?*/ 	OUString aTypeName;
/*?*/ 	Sequence< PROPERTYVALUE > aFilterProps;
/*?*/ 	Any aPropSeqAny = rFilterCFG->getByName( aFilterName );
/*?*/ 	aPropSeqAny >>= aFilterProps;
/*?*/ 
/*?*/ 	for( ind = 0; !aTypeName.getLength() && ind < aFilterProps.getLength(); ind++ )
/*?*/ 		if( aFilterProps[ind].Name.equals( OUString::createFromAscii( "Type" ) ) )
/*?*/ 			aFilterProps[ind].Value >>= aTypeName;
/*?*/ 
/*?*/ 	if( !aTypeName.getLength() )
/*?*/ 		return sal_False;
/*?*/ 
/*?*/ 	// Find an extention and a mime-type for the type
/*?*/ 	OUString aExt;
/*?*/ 	OUString aMimeType;
/*?*/ 	Reference< XNAMEACCESS > rTypeDetection(
/*?*/ 		rServiceManager->createInstance( OUString::createFromAscii( "com.sun.star.document.TypeDetection" ) ),
/*?*/ 		UNO_QUERY );
/*?*/ 
/*?*/ 	if( !rTypeDetection.is() )
/*?*/ 		return sal_False;
/*?*/ 
/*?*/ 	Sequence< PROPERTYVALUE > aTypeProps;
/*?*/ 	Any aTypePropsAny = rTypeDetection->getByName( aTypeName );
/*?*/ 	aTypePropsAny >>= aTypeProps;
/*?*/ 
/*?*/ 	for( ind = 0; ( !aMimeType.getLength() || !aExt.getLength() ) && ind < aTypeProps.getLength(); ind++ )
/*?*/ 		if( aTypeProps[ind].Name.equals( OUString::createFromAscii( "Extensions" ) ) )
/*?*/ 		{
/*?*/ 			Sequence< OUString > aExts;
/*?*/ 			aTypeProps[ind].Value >>= aExts;
/*?*/ 			if( aExts.getLength() )
/*?*/ 				aExt = aExts[0];
/*?*/ 		}
/*?*/ 		else if( aTypeProps[ind].Name.equals( OUString::createFromAscii( "MediaType" ) ) )
/*?*/ 			aTypeProps[ind].Value >>= aMimeType;
/*?*/ 
/*?*/ 	if( !aExt.getLength() )
/*?*/ 		return sal_False;
/*?*/ 
/*?*/ 	// construct destination url
/*?*/     OUString    aTargetURL;
/*?*/     OUString    aPropName( RTL_CONSTASCII_USTRINGPARAM( TARGET_DIR_URL ) );
/*?*/     Any         aValue;
/*?*/     if ( getProperty( aGroup, aPropName, aValue ) )
/*?*/         aValue >>= aTargetURL;
/*?*/     if ( !aTargetURL.getLength() )
/*?*/         return sal_False;
/*?*/ 
/*?*/     INetURLObject   aTargetObj( aTargetURL );
/*?*/     aTargetObj.insertName( rTemplateName, false,
/*?*/                       INetURLObject::LAST_SEGMENT, true,
/*?*/                       INetURLObject::ENCODE_ALL );
/*?*/     aTargetObj.setExtension( aExt );
/*?*/     OUString aTargetURL2 = aTargetObj.GetMainURL( INetURLObject::NO_DECODE );
/*?*/ 
/*?*/ 	// store template
/*?*/ 	Sequence< PropertyValue > aArgs(1);
/*?*/ 	aArgs[0].Name = OUString::createFromAscii( "FilterName" );
/*?*/ 	aArgs[0].Value <<= aFilterName;
/*?*/ 
/*?*/ 	try {
/*?*/ 		rStorable->storeToURL( aTargetURL2, aArgs );
/*?*/ 	}
/*?*/ 	catch( Exception& )
/*?*/ 	{
/*?*/ 		// the template was not stored
/*?*/ 		return sal_False;
/*?*/ 	}
/*?*/ 
/*?*/ 	// add the template to hierarchy
/*?*/     return addEntry( aGroup, rTemplateName, aTargetURL2, aMimeType );
/*?*/ }

//-----------------------------------------------------------------------------
/*?*/ sal_Bool SfxDocTplService_Impl::addTemplate( const OUString& rGroupName,
/*?*/                                              const OUString& rTemplateName,
/*?*/                                              const OUString& rSourceURL )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return sal_False;//STRIP001 
/*?*/ }

//-----------------------------------------------------------------------------
/*?*/ sal_Bool SfxDocTplService_Impl::removeTemplate( const OUString& rGroupName,
/*?*/                                                 const OUString& rTemplateName )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return sal_False;//STRIP001 
/*?*/ }

//-----------------------------------------------------------------------------
/*?*/ sal_Bool SfxDocTplService_Impl::renameTemplate( const OUString& rGroupName,
/*?*/                                                 const OUString& rOldName,
/*?*/                                                 const OUString& rNewName )
/*?*/ {DBG_BF_ASSERT(0, "STRIP");return sal_False; //STRIP001 
/*?*/ }

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------

/*N*/ SFX_IMPL_XSERVICEINFO( SfxDocTplService, TEMPLATE_SERVICE_NAME, TEMPLATE_IMPLEMENTATION_NAME )
/*N*/ SFX_IMPL_SINGLEFACTORY( SfxDocTplService )

//-----------------------------------------------------------------------------
/*N*/ SfxDocTplService::SfxDocTplService( const Reference< XMultiServiceFactory >& xFactory )
/*N*/ {
/*N*/     pImp = new SfxDocTplService_Impl( xFactory );
/*N*/ }

//-----------------------------------------------------------------------------

/*N*/ SfxDocTplService::~SfxDocTplService()
/*N*/ {
/*N*/     delete pImp;
/*N*/ }

//-----------------------------------------------------------------------------
//--- XLocalizable ---
//-----------------------------------------------------------------------------

/*?*/ LOCALE SAL_CALL SfxDocTplService::getLocale()
/*?*/     throw( RUNTIMEEXCEPTION )
/*?*/ {
/*?*/     return pImp->getLocale();
/*?*/ }

//-----------------------------------------------------------------------------

/*N*/ void SAL_CALL SfxDocTplService::setLocale( const LOCALE & rLocale )
/*N*/     throw( RUNTIMEEXCEPTION )
/*N*/ {
/*N*/     pImp->setLocale( rLocale );
/*N*/ }

//-----------------------------------------------------------------------------
//--- XDocumentTemplates ---
//-----------------------------------------------------------------------------
/*N*/ Reference< XCONTENT > SAL_CALL SfxDocTplService::getContent()
/*N*/     throw( RUNTIMEEXCEPTION )
/*N*/ {
/*N*/     if ( pImp->init() )
/*N*/         return pImp->getContent().get();
/*N*/     else
/*N*/         return NULL;
/*N*/ }

//-----------------------------------------------------------------------------
/*?*/ sal_Bool SAL_CALL SfxDocTplService::storeTemplate( const OUString& GroupName,
/*?*/                                                    const OUString& TemplateName,
/*?*/                                                    const Reference< XSTORABLE >& Storable )
/*?*/     throw( RUNTIMEEXCEPTION )
/*?*/ {
/*?*/ 	if ( pImp->init() )
/*?*/ 		return pImp->storeTemplate( GroupName, TemplateName, Storable );
/*?*/ 	else
/*?*/     	return sal_False;
/*?*/ }

//-----------------------------------------------------------------------------
/*?*/ sal_Bool SAL_CALL SfxDocTplService::addTemplate( const OUString& rGroupName,
/*?*/                                                  const OUString& rTemplateName,
/*?*/                                                  const OUString& rSourceURL )
/*?*/     throw( RUNTIMEEXCEPTION )
/*?*/ {
/*?*/     if ( pImp->init() )
/*?*/         return pImp->addTemplate( rGroupName, rTemplateName, rSourceURL );
/*?*/     else
/*?*/         return sal_False;
/*?*/ }

//-----------------------------------------------------------------------------
/*?*/ sal_Bool SAL_CALL SfxDocTplService::removeTemplate( const OUString& rGroupName,
/*?*/                                                     const OUString& rTemplateName )
/*?*/     throw( RUNTIMEEXCEPTION )
/*?*/ {
/*?*/     if ( pImp->init() )
/*?*/         return pImp->removeTemplate( rGroupName, rTemplateName );
/*?*/     else
/*?*/         return sal_False;
/*?*/ }

//-----------------------------------------------------------------------------
/*N*/ sal_Bool SAL_CALL SfxDocTplService::renameTemplate( const OUString& rGroupName,
/*N*/                                                     const OUString& rOldName,
/*N*/                                                     const OUString& rNewName )
/*N*/     throw( RUNTIMEEXCEPTION )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/         return sal_False;
/*N*/ }

//-----------------------------------------------------------------------------
/*?*/ sal_Bool SAL_CALL SfxDocTplService::addGroup( const OUString& rGroupName )
/*?*/     throw( RUNTIMEEXCEPTION )
/*?*/ {
/*?*/     if ( pImp->init() )
/*?*/         return pImp->addGroup( rGroupName );
/*?*/     else
/*?*/         return sal_False;
/*?*/ }

//-----------------------------------------------------------------------------
/*?*/ sal_Bool SAL_CALL SfxDocTplService::removeGroup( const OUString& rGroupName )
/*?*/     throw( RUNTIMEEXCEPTION )
/*?*/ {
/*?*/     if ( pImp->init() )
/*?*/         return pImp->removeGroup( rGroupName );
/*?*/     else
/*?*/         return sal_False;
/*?*/ }

//-----------------------------------------------------------------------------
/*N*/ sal_Bool SAL_CALL SfxDocTplService::renameGroup( const OUString& rOldName,
/*N*/                                                  const OUString& rNewName )
/*N*/     throw( RUNTIMEEXCEPTION )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/         return sal_False;
/*N*/ }

//-----------------------------------------------------------------------------
/*?*/ void SAL_CALL SfxDocTplService::update()
/*?*/     throw( RUNTIMEEXCEPTION )
/*?*/ {
/*?*/     if ( pImp->init() )
/*?*/         pImp->update( sal_True );
/*?*/ }

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//------------------------------------------------------------------------

/*?*/ Updater_Impl::Updater_Impl( SfxDocTplService_Impl* pTemplates )
/*?*/ {
/*?*/     mpDocTemplates = pTemplates;
/*?*/ }

//------------------------------------------------------------------------
/*?*/ Updater_Impl::~Updater_Impl()
/*?*/ {
/*?*/ }
/*?*/ 
//------------------------------------------------------------------------
/*?*/ void SAL_CALL Updater_Impl::run()
/*?*/ {
/*?*/     DBG_BF_ASSERT(0, "STRIP"); //STRIP001 mpDocTemplates->doUpdate();
/*?*/ }

//------------------------------------------------------------------------
/*?*/ void SAL_CALL Updater_Impl::onTerminated()
/*?*/ {
/*?*/    DBG_BF_ASSERT(0, "STRIP"); //STRIP001  mpDocTemplates->finished();
/*?*/ }

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/*N*/ WaitWindow_Impl::WaitWindow_Impl()
/*N*/     : WorkWindow( NULL, WB_BORDER | WB_3DLOOK )
/*N*/ {
/*N*/     Rectangle aRect = Rectangle( 0, 0, 300, 30000 );
/*N*/     _nTextStyle = TEXT_DRAW_CENTER | TEXT_DRAW_VCENTER | TEXT_DRAW_WORDBREAK | TEXT_DRAW_MULTILINE;
/*N*/     _aText = String( SfxResId( RID_CNT_STR_WAITING ) );
/*N*/     _aRect = GetTextRect( aRect, _aText, _nTextStyle );
/*N*/     aRect = _aRect;
/*N*/     aRect.Right() += 2*X_OFFSET;
/*N*/     aRect.Bottom() += 2*Y_OFFSET;
/*N*/     _aRect.SetPos( Point( X_OFFSET, Y_OFFSET ) );
/*N*/     SetOutputSizePixel( aRect.GetSize() );
/*N*/     Show();
/*N*/     Update();
/*N*/     Flush();
/*N*/ }

//-----------------------------------------------------------------------------
/*N*/ WaitWindow_Impl::~WaitWindow_Impl()
/*N*/ {
/*N*/     Hide();
/*N*/ }

//-----------------------------------------------------------------------------
/*N*/ void WaitWindow_Impl::Paint( const Rectangle& rRect )
/*N*/ {
/*N*/     DrawText( _aRect, _aText, _nTextStyle );
/*N*/ }

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/*?*/ void SfxDocTplService_Impl::addHierGroup( GroupList_Impl& rList,
/*?*/                                           const OUString& rTitle,
/*?*/                                           const OUString& rOwnURL )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

//-----------------------------------------------------------------------------
/*N*/ void SfxDocTplService_Impl::addFsysGroup( GroupList_Impl& rList,
/*N*/                                           const OUString& rTitle,
/*N*/                                           const OUString& rOwnURL )
/*N*/ {
/*N*/     if ( rTitle.compareToAscii( "wizard" ) == 0 )
/*N*/         return;
/*N*/     else if ( rTitle.compareToAscii( "internal" ) == 0 )
/*N*/         return;
/*N*/ 
/*N*/     // First, get the long name of the group
/*N*/     OUString        aTitle = getLongName( rTitle );
/*N*/     GroupData_Impl *pGroup = rList.First();
/*N*/ 
/*N*/     while ( pGroup && pGroup->getTitle() != aTitle )
/*N*/         pGroup = rList.Next();
/*N*/ 
/*N*/     if ( !pGroup )
/*N*/     {
/*N*/         pGroup = new GroupData_Impl( aTitle );
/*N*/         pGroup->setTargetURL( rOwnURL );
/*N*/         rList.Insert( pGroup );
/*N*/     }
/*N*/ 
/*N*/     pGroup->setInUse();
/*N*/ 
/*N*/     // now get the content of the Group
/*N*/     Content                 aContent;
/*N*/     Reference< XResultSet > xResultSet;
/*N*/     Sequence< OUString >    aProps(1);
/*N*/     aProps[0] = OUString::createFromAscii( TITLE );
/*N*/ 
/*N*/     try
/*N*/     {
/*N*/         aContent = Content( rOwnURL, maCmdEnv );
/*N*/         ResultSetInclude eInclude = INCLUDE_DOCUMENTS_ONLY;
/*N*/         xResultSet = aContent.createCursor( aProps, eInclude );
/*N*/     }
/*N*/     catch ( Exception& ) {}
/*N*/ 
/*N*/     if ( xResultSet.is() )
/*N*/     {
/*N*/         Reference< XContentAccess > xContentAccess( xResultSet, UNO_QUERY );
/*N*/         Reference< XRow > xRow( xResultSet, UNO_QUERY );
/*N*/ 
/*N*/         try
/*N*/         {
/*N*/             while ( xResultSet->next() )
/*N*/             {
/*N*/                 OUString aTitle( xRow->getString( 1 ) );
/*N*/                 OUString aTargetURL = xContentAccess->queryContentIdentifierString();
/*N*/                 OUString aType;
/*N*/                 OUString aHierURL;
/*N*/ 
/*N*/                 if ( aTitle.compareToAscii( "sfx.tlx" ) == 0 )
/*N*/                     continue;
/*N*/ 
/*N*/ 				// only StarOffice templates are accepted
/*N*/                 if( !getTitleFromURL( aTargetURL, aTitle, aType ) )
/*N*/ 					continue;
/*N*/ 
/*N*/                 pGroup->addEntry( aTitle, aTargetURL, aType, aHierURL );
/*N*/             }
/*N*/         }
/*N*/         catch ( Exception& ) {}
/*N*/     }
/*N*/ }

// -----------------------------------------------------------------------
/*N*/ void SfxDocTplService_Impl::createFromContent( GroupList_Impl& rList,
/*N*/                                                Content &rContent,
/*N*/                                                sal_Bool bHierarchy )
/*N*/ {
/*N*/     // when scanning the file system, we have to add the 'standard' group, too
/*N*/     if ( ! bHierarchy )
/*N*/     {
/*N*/         OUString aStdTitle = getLongName( OUString( RTL_CONSTASCII_USTRINGPARAM( STANDARD_FOLDER ) ) );
/*N*/         OUString aTargetURL = rContent.get()->getIdentifier()->getContentIdentifier();
/*N*/         addFsysGroup( rList, aStdTitle, aTargetURL );
/*N*/     }
/*N*/ 
/*N*/     Reference< XResultSet > xResultSet;
/*N*/     Sequence< OUString > aProps(1);
/*N*/     aProps[0] = OUString::createFromAscii( TITLE );
/*N*/ 
/*N*/     try
/*N*/     {
/*N*/         ResultSetInclude eInclude = INCLUDE_FOLDERS_ONLY;
/*N*/         xResultSet = rContent.createCursor( aProps, eInclude );
/*N*/     }
/*N*/     catch ( Exception& ) {}
/*N*/ 
/*N*/     if ( xResultSet.is() )
/*N*/     {
/*N*/         Reference< XContentAccess > xContentAccess( xResultSet, UNO_QUERY );
/*N*/         Reference< XRow > xRow( xResultSet, UNO_QUERY );
/*N*/ 
/*N*/         try
/*N*/         {
/*N*/             while ( xResultSet->next() )
/*N*/             {
/*N*/                 OUString aTitle( xRow->getString( 1 ) );
/*N*/                 OUString aTargetURL( xContentAccess->queryContentIdentifierString() );
/*N*/ 
/*N*/                 if ( bHierarchy )
/*?*/                     addHierGroup( rList, aTitle, aTargetURL );
/*N*/                 else
/*N*/                     addFsysGroup( rList, aTitle, aTargetURL );
/*N*/             }
/*N*/         }
/*N*/         catch ( Exception& ) {}
/*N*/     }
/*N*/ }

//-----------------------------------------------------------------------------
/*?*/ void SfxDocTplService_Impl::removeFromHierarchy( EntryData_Impl *pData )
/*?*/ {
/*?*/     Content aTemplate;
/*?*/ 
/*?*/     if ( Content::create( pData->getHierarchyURL(), maCmdEnv, aTemplate ) )
/*?*/     {
/*?*/         removeContent( aTemplate );
/*?*/     }
/*?*/ }

//-----------------------------------------------------------------------------
/*N*/ void SfxDocTplService_Impl::addToHierarchy( GroupData_Impl *pGroup,
/*N*/                                             EntryData_Impl *pData )
/*N*/ {
/*N*/     Content aGroup, aTemplate;
/*N*/ 
/*N*/     if ( ! Content::create( pGroup->getHierarchyURL(), maCmdEnv, aGroup ) )
/*N*/         return;
/*N*/ 
/*N*/     // Check, if there's a template with the given name in this group
/*N*/     // Return if there is already a template
/*N*/     INetURLObject aGroupObj( pGroup->getHierarchyURL() );
/*N*/ 
/*N*/     aGroupObj.insertName( pData->getTitle(), false,
/*N*/                       INetURLObject::LAST_SEGMENT, true,
/*N*/                       INetURLObject::ENCODE_ALL );
/*N*/ 
/*N*/     OUString aTemplateURL = aGroupObj.GetMainURL( INetURLObject::NO_DECODE );
/*N*/ 
/*N*/     if ( Content::create( aTemplateURL, maCmdEnv, aTemplate ) )
/*N*/         return;
/*N*/ 
/*N*/     addEntry( aGroup, pData->getTitle(),
/*N*/               pData->getTargetURL(),
/*N*/               pData->getType() );
/*N*/ }

//-----------------------------------------------------------------------------
/*?*/ void SfxDocTplService_Impl::updateData( EntryData_Impl *pData )
/*?*/ {
/*?*/     Content aTemplate;
/*?*/ 
/*?*/     if ( ! Content::create( pData->getHierarchyURL(), maCmdEnv, aTemplate ) )
/*?*/         return;
/*?*/ 
/*?*/     OUString aPropName;
/*?*/ 
/*?*/     if ( pData->getUpdateType() )
/*?*/     {
/*?*/         aPropName = OUString( RTL_CONSTASCII_USTRINGPARAM( PROPERTY_TYPE ) );
/*?*/         setProperty( aTemplate, aPropName, makeAny( pData->getType() ) );
/*?*/     }
/*?*/ 
/*?*/     if ( pData->getUpdateLink() )
/*?*/     {
/*?*/         aPropName = OUString( RTL_CONSTASCII_USTRINGPARAM( TARGET_URL ) );
/*?*/         setProperty( aTemplate, aPropName, makeAny( pData->getTargetURL() ) );
/*?*/     }
/*?*/ }

//-----------------------------------------------------------------------------
/*N*/ void SfxDocTplService_Impl::addGroupToHierarchy( GroupData_Impl *pGroup )
/*N*/ {
/*N*/     OUString aAdditionalProp( RTL_CONSTASCII_USTRINGPARAM( TARGET_DIR_URL ) );
/*N*/     Content aGroup;
/*N*/ 
/*N*/     INetURLObject aNewGroupObj( maRootURL );
/*N*/     aNewGroupObj.insertName( pGroup->getTitle(), false,
/*N*/           INetURLObject::LAST_SEGMENT, true,
/*N*/           INetURLObject::ENCODE_ALL );
/*N*/ 
/*N*/     OUString aNewGroupURL = aNewGroupObj.GetMainURL( INetURLObject::NO_DECODE );
/*N*/ 
/*N*/     if ( createFolder( aNewGroupURL, sal_False, sal_False, aGroup ) )
/*N*/     {
/*N*/         setProperty( aGroup, aAdditionalProp, makeAny( pGroup->getTargetURL() ) );
/*N*/         pGroup->setHierarchyURL( aNewGroupURL );
/*N*/ 
/*N*/         ULONG nCount = pGroup->count();
/*N*/         for ( ULONG i=0; i<nCount; i++ )
/*N*/         {
/*N*/             EntryData_Impl *pData = pGroup->getEntry( i );
/*N*/             addToHierarchy( pGroup, pData ); // add entry to hierarchy
/*N*/         }
/*N*/     }
/*N*/ }

//-----------------------------------------------------------------------------
/*?*/ void SfxDocTplService_Impl::removeFromHierarchy( GroupData_Impl *pGroup )
/*?*/ {
/*?*/     Content aGroup;
/*?*/ 
/*?*/     if ( Content::create( pGroup->getHierarchyURL(), maCmdEnv, aGroup ) )
/*?*/     {
/*?*/         removeContent( aGroup );
/*?*/     }
/*?*/ }

// -----------------------------------------------------------------------
// -----------------------------------------------------------------------
// -----------------------------------------------------------------------
/*N*/ GroupData_Impl::GroupData_Impl( const OUString& rTitle )
/*N*/ {
/*N*/     maTitle = rTitle;
/*N*/     mbInUse = sal_False;
/*N*/     mbInHierarchy = sal_False;
/*N*/ }

// -----------------------------------------------------------------------
/*N*/ GroupData_Impl::~GroupData_Impl()
/*N*/ {
/*N*/     EntryData_Impl *pData = maEntries.First();
/*N*/     while ( pData )
/*N*/     {
/*N*/         delete pData;
/*N*/         pData = maEntries.Next();
/*N*/     }
/*N*/ }

// -----------------------------------------------------------------------
/*N*/ EntryData_Impl* GroupData_Impl::addEntry( const OUString& rTitle,
/*N*/                                           const OUString& rTargetURL,
/*N*/                                           const OUString& rType,
/*N*/                                           const OUString& rHierURL )
/*N*/ {
/*N*/     EntryData_Impl *pData = maEntries.First();
/*N*/ 
/*N*/     while ( pData && pData->getTitle() != rTitle )
/*N*/         pData = maEntries.Next();
/*N*/ 
/*N*/     if ( !pData )
/*N*/     {
/*N*/         pData = new EntryData_Impl( rTitle );
/*N*/         pData->setTargetURL( rTargetURL );
/*N*/         pData->setType( rType );
/*N*/         if ( rHierURL.getLength() )
/*N*/         {
/*N*/             pData->setHierarchyURL( rHierURL );
/*N*/             pData->setHierarchy( sal_True );
/*N*/         }
/*N*/         maEntries.Insert( pData );
/*N*/     }
/*N*/     else
/*N*/     {
/*N*/         pData->setInUse();
/*N*/         if ( rTargetURL != pData->getTargetURL() )
/*N*/         {
/*N*/             pData->setTargetURL( rTargetURL );
/*N*/             pData->setUpdateLink( sal_True );
/*N*/         }
/*N*/     }
/*N*/ 
/*N*/     return pData;
/*N*/ }

// -----------------------------------------------------------------------
// -----------------------------------------------------------------------
// -----------------------------------------------------------------------
/*N*/ EntryData_Impl::EntryData_Impl( const OUString& rTitle )
/*N*/ {
/*N*/     maTitle         = rTitle;
/*N*/     mbInUse         = sal_False;
/*N*/     mbInHierarchy   = sal_False;
/*N*/     mbUpdateType    = sal_False;
/*N*/     mbUpdateLink    = sal_False;
/*N*/ }
}
