/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_stbitem.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 19:44:50 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
#pragma hdrstop

#include "stbitem.hxx"
#include "sfxtypes.hxx"
#include "stbmgr.hxx"
#include "arrdecl.hxx"
#include "msgpool.hxx"
#include "module.hxx"
#include "dispatch.hxx"

#include "sfx.hrc"
namespace binfilter {

//--------------------------------------------------------------------

/*N*/ SfxStatusBarControl::SfxStatusBarControl
/*N*/ (
/*N*/ 	USHORT		nId,				/* Slot-Id, mit der diese Instanz
									   verbunden wird. Wurde bei der
									   Registrierung eine Slot-Id != 0
									   angegeben, ist dies immer die dort
									   angegebene. */

/*N*/ 	StatusBar&	rBar,				/* Referenz auf die StatusBar, f"ur die
									   dieses Control erzeugt wurde. */
/*N*/ 	SfxBindings& rBindings			// Die Bindings dieses Controls
/*N*/ )

/*	[Beschreibung]

	Konstruktor der Klasse SfxStatusBarControl. Die Subclasses werden
	bei Bedarf per Factory vom SFx erzeugt.

	Instanzen dieser Basisklasse werden f"ur alle StatusBar-Felder
	erzeugt, f"ur die keine speziellen registriert wurden.
*/

/*N*/ :	SfxControllerItem(nId, rBindings),
/*N*/ 	pBar(&rBar)
/*N*/ {
/*N*/ 	DBG( CheckConfigure_Impl(SFX_SLOT_STATUSBARCONFIG) );
/*N*/ }

//--------------------------------------------------------------------

/*N*/ SfxStatusBarControl::~SfxStatusBarControl()

/*	[Beschreibung]

	Destruktor der Klasse SfxStatusBarControl. Die Instanzen dieser
	Klasse und deren Subklassen werden vom SFx zerst"ort.
*/

/*N*/ {}

//--------------------------------------------------------------------

/*N*/ void SfxStatusBarControl::StateChanged
/*N*/ (
/*N*/ 	USHORT				nSID,
/*N*/ 	SfxItemState		eState,
/*N*/ 	const SfxPoolItem* 	pState	/* Zeiger auf ein SfxPoolItem, welches nur
								   innerhalb dieses Methodenaufrufs g"ultig
								   ist. Es kann ein 0-Pointer, ein Pointer
								   auf ein SfxVoidItem oder auf den Typ, f"ur
								   den die Subclass von SfxStatusBarControl
								   registriert ist vorkommen. */
/*N*/ )

/*	[Beschreibung]

	Die Basisimplementation versteht Items vom Type SfxStringItem, bei
	denen der Text in das Status-Zeilen-Feld eingetragen wird und
	SfxVoidItem, bei denen das Feld geleert wird. Die Basisimplementierng
	sollte in "uberladenen Methoden nicht gerufen werden.
*/

/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	DBG_ASSERT( pBar != 0, "setting state to dangling StatusBar" );
/*N*/ 
/*N*/ 	const SfxStringItem* pStr = PTR_CAST( SfxStringItem, pState );
/*N*/ 	if ( eState == SFX_ITEM_AVAILABLE && pStr )
/*N*/ 		pBar->SetItemText( nSID, pStr->GetValue() );
/*N*/ 	else
/*N*/ 	{
/*N*/ 		DBG_ASSERT( eState != SFX_ITEM_AVAILABLE || pState->ISA(SfxVoidItem),
/*N*/ 					"wrong SfxPoolItem subclass in SfxStatusBarControl" );
/*N*/ 		pBar->SetItemText( nSID, String() );
/*N*/ 	}
/*N*/ }

//--------------------------------------------------------------------


//--------------------------------------------------------------------

/*N*/ SfxStatusBarControl* SfxStatusBarControl::CreateControl
/*N*/ (
/*N*/ 	USHORT			nId,
/*N*/ 	StatusBar*		pBar,
/*N*/ 	SfxBindings&	rBindings,
/*N*/ 	SfxModule*		pMod
/*N*/ )
/*N*/ {
/*N*/ 	SfxApplication *pApp = SFX_APP();
/*N*/ 	SfxSlotPool *pSlotPool;
/*N*/ 	if ( pMod )
/*N*/ 		pSlotPool = pMod->GetSlotPool();
/*N*/ 	else
/*N*/ 		pSlotPool = &pApp->GetSlotPool();
/*N*/ 	TypeId aSlotType = pSlotPool->GetSlotType(nId);
/*N*/ 	if ( aSlotType )
/*N*/ 	{
/*N*/ 		SfxDispatcher *pDisp = rBindings.GetDispatcher_Impl();
/*N*/ 		if ( pMod )
/*N*/ 		{
/*N*/ 			SfxStbCtrlFactArr_Impl *pFactories = pMod->GetStbCtrlFactories_Impl();
/*N*/ 			if ( pFactories )
/*N*/ 			{
/*N*/ 				SfxStbCtrlFactArr_Impl &rFactories = *pFactories;
/*N*/ 				for ( USHORT nFactory = 0; nFactory < rFactories.Count(); ++nFactory )
/*N*/ 				if ( rFactories[nFactory]->nTypeId == aSlotType &&
/*N*/ 					 ( ( rFactories[nFactory]->nSlotId == 0 ) ||
/*N*/ 					 ( rFactories[nFactory]->nSlotId == nId) ) )
/*N*/ 					return rFactories[nFactory]->pCtor( nId, *pBar, rBindings );
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		SfxStbCtrlFactArr_Impl &rFactories = pApp->GetStbCtrlFactories_Impl();
/*N*/ 		for ( USHORT nFactory = 0; nFactory < rFactories.Count(); ++nFactory )
/*?*/ 		if ( rFactories[nFactory]->nTypeId == aSlotType &&
/*?*/ 			 ( ( rFactories[nFactory]->nSlotId == 0 ) ||
/*?*/ 			 ( rFactories[nFactory]->nSlotId == nId) ) )
/*?*/ 			return rFactories[nFactory]->pCtor( nId, *pBar, rBindings );
/*N*/ 	}
/*N*/ 	return new SfxStatusBarControl( nId, *pBar, rBindings );
/*N*/ }
																														//--------------------------------------------------------------------

}
