/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_fmshimp.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 20:57:28 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#pragma hdrstop

#if STLPORT_VERSION>=321
#include <math.h>	// prevent conflict between exception and std::exception
#endif


#ifndef _E3D_OBJ3D_HXX
#include <obj3d.hxx>
#endif

#ifndef _SVX_FMVWIMP_HXX
#include "fmvwimp.hxx"
#endif

#ifndef _COM_SUN_STAR_SDBC_XROWSETLISTENER_HPP_
#include <com/sun/star/sdbc/XRowSetListener.hpp>
#endif


#ifndef _COM_SUN_STAR_SDB_XSQLQUERYCOMPOSERFACTORY_HPP_
#include <com/sun/star/sdb/XSQLQueryComposerFactory.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_XFRAME_HPP_
#include <com/sun/star/frame/XFrame.hpp>
#endif

#ifndef _SVX_FMSHIMP_HXX
#include "fmshimp.hxx"
#endif

#ifndef _SVDPAGV_HXX //autogen
#include "svdpagv.hxx"
#endif

#ifndef _SVX_FMPAGE_HXX
#include "fmpage.hxx"
#endif





#ifndef _SVX_FMRESIDS_HRC
#include "fmresids.hrc"
#endif // _SVX_FMRESIDS_HRC


#ifndef _SVX_FMOBJ_HXX
#include "fmobj.hxx"
#endif

#ifndef _MULTIPRO_HXX
#include "multipro.hxx"
#endif

#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif

#ifndef _COM_SUN_STAR_FORM_XLOADABLE_HPP_
#include <com/sun/star/form/XLoadable.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XCONTAINER_HPP_
#include <com/sun/star/container/XContainer.hpp>
#endif


#ifndef _COM_SUN_STAR_FORM_XRESET_HPP_
#include <com/sun/star/form/XReset.hpp>
#endif
#ifndef _SVX_FMGLOB_HXX
#include <fmglob.hxx>
#endif

#ifndef _SVDITER_HXX //autogen
#include <svditer.hxx>
#endif


#ifndef _SFXVIEWSH_HXX //autogen wg. SfxViewShell
#include <bf_sfx2/viewsh.hxx>
#endif

#ifndef _SFXVIEWFRM_HXX //autogen wg. SfxViewFrame
#include <bf_sfx2/viewfrm.hxx>
#endif




#ifndef _SVX_FMUNOPGE_HXX
#include "fmpgeimp.hxx"
#endif
#ifndef _SVX_FMPROP_HRC
#include "fmprop.hrc"
#endif
#ifndef _SVX_FMSHELL_HXX
#include "fmshell.hxx"
#endif
#ifndef _SVX_SVXIDS_HRC
#include "svxids.hrc"
#endif

#ifndef _SVX_FMMODEL_HXX
#include "fmmodel.hxx"
#endif
#ifndef _SVX_FMUNDO_HXX
#include "fmundo.hxx"
#endif

#ifndef _SVX_FMURL_HXX
#include "fmurl.hxx"
#endif


#ifndef _CONNECTIVITY_DBTOOLS_HXX_
#include <connectivity/dbtools.hxx>
#endif
#ifndef _COMPHELPER_EXTRACT_HXX_
#include <comphelper/extract.hxx>
#endif
namespace binfilter {

extern sal_Int16 ControllerSlotMap[];

extern sal_Int16 AutoSlotMap[];

// wird fuer Invalidate verwendet -> mitpflegen
extern sal_uInt16 DatabaseSlotMap[];

// wird fuer Invalidate verwendet -> mitpflegen
// aufsteigend sortieren !!!!!!
sal_Int16 DlgSlotMap[] =	// slots des Controllers
{
	SID_FM_CTL_PROPERTIES,
	SID_FM_PROPERTIES,
	SID_FM_TAB_DIALOG,
	SID_FM_ADD_FIELD,
	SID_FM_SHOW_FMEXPLORER,
	SID_FM_FIELDS_CONTROL,
	SID_FM_SHOW_PROPERTIES,
	SID_FM_PROPERTY_CONTROL,
	SID_FM_FMEXPLORER_CONTROL,
	0
};

sal_uInt16 ModifySlotMap[] =	// slots des Controllers
{
	SID_FM_RECORD_NEXT,
	SID_FM_RECORD_NEW,
	SID_FM_RECORD_SAVE,
	SID_FM_RECORD_UNDO,
	0
};

sal_Int16 SelObjectSlotMap[] =	// vom SelObject abhaengige Slots
{
	SID_FM_CONVERTTO_EDIT,
	SID_FM_CONVERTTO_BUTTON,
	SID_FM_CONVERTTO_FIXEDTEXT,
	SID_FM_CONVERTTO_LISTBOX,
	SID_FM_CONVERTTO_CHECKBOX,
	SID_FM_CONVERTTO_RADIOBUTTON,
	SID_FM_CONVERTTO_GROUPBOX,
	SID_FM_CONVERTTO_COMBOBOX,
	SID_FM_CONVERTTO_GRID,
	SID_FM_CONVERTTO_IMAGEBUTTON,
	SID_FM_CONVERTTO_FILECONTROL,
	SID_FM_CONVERTTO_DATE,
	SID_FM_CONVERTTO_TIME,
	SID_FM_CONVERTTO_NUMERIC,
	SID_FM_CONVERTTO_CURRENCY,
	SID_FM_CONVERTTO_PATTERN,
	SID_FM_CONVERTTO_IMAGECONTROL,
	SID_FM_CONVERTTO_FORMATTED,

	SID_FM_FMEXPLORER_CONTROL,

	0
};

// die folgenden Arrays muessen kosistent sein, also einander entsprechende Eintraege an der selben relativen Position
// innerhalb ihres jeweiligen Arrays stehen
sal_Int16 nConvertSlots[] =
{
	SID_FM_CONVERTTO_EDIT,
	SID_FM_CONVERTTO_BUTTON,
	SID_FM_CONVERTTO_FIXEDTEXT,
	SID_FM_CONVERTTO_LISTBOX,
	SID_FM_CONVERTTO_CHECKBOX,
	SID_FM_CONVERTTO_RADIOBUTTON,
	SID_FM_CONVERTTO_GROUPBOX,
	SID_FM_CONVERTTO_COMBOBOX,
	SID_FM_CONVERTTO_GRID,
	SID_FM_CONVERTTO_IMAGEBUTTON,
	SID_FM_CONVERTTO_FILECONTROL,
	SID_FM_CONVERTTO_DATE,
	SID_FM_CONVERTTO_TIME,
	SID_FM_CONVERTTO_NUMERIC,
	SID_FM_CONVERTTO_CURRENCY,
	SID_FM_CONVERTTO_PATTERN,
	SID_FM_CONVERTTO_IMAGECONTROL,
	SID_FM_CONVERTTO_FORMATTED
};

sal_Int16 nCreateSlots[] =
{
	SID_FM_EDIT,
	SID_FM_PUSHBUTTON,
	SID_FM_FIXEDTEXT,
	SID_FM_LISTBOX,
	SID_FM_CHECKBOX,
	SID_FM_RADIOBUTTON,
	SID_FM_GROUPBOX,
	SID_FM_COMBOBOX,
	SID_FM_DBGRID,
	SID_FM_IMAGEBUTTON,
	SID_FM_FILECONTROL,
	SID_FM_DATEFIELD,
	SID_FM_TIMEFIELD,
	SID_FM_NUMERICFIELD,
	SID_FM_CURRENCYFIELD,
	SID_FM_PATTERNFIELD,
	SID_FM_IMAGECONTROL,
	SID_FM_FORMATTEDFIELD
};

sal_Int16 nObjectTypes[] =
{
	OBJ_FM_EDIT,
	OBJ_FM_BUTTON,
	OBJ_FM_FIXEDTEXT,
	OBJ_FM_LISTBOX,
	OBJ_FM_CHECKBOX,
	OBJ_FM_RADIOBUTTON,
	OBJ_FM_GROUPBOX,
	OBJ_FM_COMBOBOX,
	OBJ_FM_GRID,
	OBJ_FM_IMAGEBUTTON,
	OBJ_FM_FILECONTROL,
	OBJ_FM_DATEFIELD,
	OBJ_FM_TIMEFIELD,
	OBJ_FM_NUMERICFIELD,
	OBJ_FM_CURRENCYFIELD,
	OBJ_FM_PATTERNFIELD,
	OBJ_FM_IMAGECONTROL,
	OBJ_FM_FORMATTEDFIELD
};

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::sdb;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::sdbcx;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::container;
using namespace ::com::sun::star::form;
using namespace ::com::sun::star::awt;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::util;
using namespace ::binfilter::svxform;//STRIP008 using namespace ::svxform;

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//==============================================================================


//------------------------------------------------------------------------------
/*N*/ sal_Bool isControlList(const SdrMarkList& rMarkList)
/*N*/ {
/*N*/ 	// enthaelt die liste nur Controls und mindestens ein control
/*N*/ 	sal_uInt32 nMarkCount = rMarkList.GetMarkCount();
/*N*/ 	sal_Bool  bControlList = nMarkCount != 0;
/*N*/ 
/*N*/ 	sal_Bool bHadAnyLeafs = sal_False;
/*N*/ 
/*N*/ 	for (sal_uInt32 i = 0; i < nMarkCount && bControlList; i++)
/*N*/ 	{
/*?*/ 		SdrObject *pObj = rMarkList.GetMark(i)->GetObj();
/*?*/ 		E3dObject* pAs3DObject = PTR_CAST(E3dObject, pObj);
/*?*/ 		// E3dObject's do not contain any 2D-objects (by definition)
/*?*/ 		// we need this extra check here : an E3dObject->IsGroupObject says "YES", but an SdrObjListIter working
/*?*/ 		// with an E3dObject doesn't give me any Nodes (E3dObject has a sub list, but no members in that list,
/*?*/ 		// cause there implementation differs from the one of "normal" SdrObject's. Unfortunally SdrObject::IsGroupObject
/*?*/ 		// doesn't check the element count of the sub list, which is simply a bug in IsGroupObject we can't fix at the moment).
/*?*/ 		// So at the end of this function bControlList would have the same value it was initialized with above : sal_True
/*?*/ 		// And this would be wrong :)
/*?*/ 		// 03.02.00 - 72529 - FS
/*?*/ 		if (!pAs3DObject)
/*?*/ 			if (pObj->IsGroupObject())
/*?*/ 			{
/*?*/ 				SdrObjListIter aIter(*pObj->GetSubList());
/*?*/ 				while (aIter.IsMore() && bControlList)
/*?*/ 				{
/*?*/ 					bControlList = FmFormInventor == aIter.Next()->GetObjInventor();
/*?*/ 					bHadAnyLeafs = sal_True;
/*?*/ 				}
/*?*/ 			}
/*?*/ 			else
/*?*/ 			{
/*?*/ 				bHadAnyLeafs = sal_True;
/*?*/ 				bControlList = FmFormInventor == pObj->GetObjInventor();
/*?*/ 			}
/*N*/ 	}
/*N*/ 
/*N*/ 	return bControlList && bHadAnyLeafs;
/*N*/ }

//------------------------------------------------------------------------

//------------------------------------------------------------------------

//------------------------------------------------------------------------
/*N*/ Reference< XForm> FmXFormShell::DetermineCurForm(const SdrMarkList& rMarkList, sal_Bool& bMixedWithFormControls)
/*N*/ {
/*N*/ 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*N*/ 	// gibt es eine aktuelle Form, wird ermittelt aus den selektierten Objekten
/*N*/ 	Reference< XForm> xReferenceForm;
/*N*/ 	bMixedWithFormControls = sal_False;
/*N*/ 	sal_uInt32 nMarkCount = rMarkList.GetMarkCount();
/*N*/ 
/*N*/ 	sal_Bool bHasFormControls = sal_False;
/*N*/ 	sal_Bool bHasForeignControls = sal_False;
/*N*/ 
/*N*/ 	Reference< XForm> xForm;
/*N*/ 	for (sal_uInt32 i=0; i<nMarkCount; i++)
/*N*/ 	{
/*?*/ 		SdrObject* pObj = rMarkList.GetMark(i)->GetObj();
/*?*/ 		if (pObj->GetObjInventor() == FmFormInventor)
/*?*/ 		{
/*?*/			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 			FmFormObj* pFormObj = PTR_CAST(FmFormObj, pObj);
/*?*/ 		}
/*?*/ 		else if (pObj->IsGroupObject())
/*?*/ 		{
/*?*/ 			SdrObjListIter aIter(*pObj->GetSubList());
/*?*/ 			while (aIter.IsMore())
/*?*/ 			{
/*?*/ 				SdrObject* pObj = aIter.Next();
/*?*/ 				if (pObj->GetObjInventor() == FmFormInventor)
/*?*/ 				{
/*?*/					DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 					FmFormObj* pFormObj = PTR_CAST(FmFormObj, pObj);
/*?*/ 				} else
/*?*/ 					// irgendein Nicht-Form-Control
/*?*/ 					bHasForeignControls = sal_True;
/*?*/ 			}
/*?*/ 		} else
/*?*/ 			bHasForeignControls = sal_True;
/*N*/ 	}
/*N*/ 
/*N*/ 	// hierher komme ich nicht mehr, wenn Controls aus mindestens zwei Forms selektiert sind, also ermittelt sich
/*N*/ 	// bMixedWithFormControls wie folgt
/*N*/ 	bMixedWithFormControls = bHasForeignControls && bHasFormControls;
/*N*/ 	return xReferenceForm;
/*N*/ }


//========================================================================
// class FmXFormShell_Base_Disambiguation
//========================================================================
/*N*/ FmXFormShell_Base_Disambiguation::FmXFormShell_Base_Disambiguation( ::osl::Mutex& _rMutex )
/*N*/ 	:FmXFormShell_BD_BASE( _rMutex )
/*N*/ {
/*N*/ }

/*N*/ void SAL_CALL FmXFormShell_Base_Disambiguation::disposing()
/*N*/ {
/*N*/ 	WeakComponentImplHelperBase::disposing();
/*N*/ 	// Note:
/*N*/ 	// This is a HACK.
/*N*/ 	// Normally it should be sufficient to call the "disposing" of our direct
/*N*/ 	// base class, but SUN PRO 5 does not like this and claims there is a conflict
/*N*/ 	// with the XEventListener::disposing(EventObject) of our various listener
/*N*/ 	// base classes.
/*N*/ }

//========================================================================
// class FmXFormShell
//========================================================================
/*N*/ DBG_NAME(FmXFormShell)
//------------------------------------------------------------------------
/*N*/ FmXFormShell::FmXFormShell( FmFormShell* _pShell, SfxViewFrame* _pViewFrame )
/*N*/ 		:FmXFormShell_BASE(m_aMutex)
/*N*/ 		,FmXFormShell_CFGBASE(::rtl::OUString::createFromAscii("Office.Common/Misc"), CONFIG_MODE_DELAYED_UPDATE)
/*N*/ 		,m_pShell(_pShell)
/*N*/ 		,m_bDatabaseBar(sal_False)
/*N*/ 		,m_eNavigate(NavigationBarMode_NONE)
/*N*/ 		,m_bActiveModified(sal_False)
/*N*/ 		,m_bTrackProperties(sal_True)
/*N*/ 		,m_bInActivate(sal_False)
/*N*/ 		,m_bSetFocus(sal_False)
/*N*/ 		,m_nLockSlotInvalidation(0)
/*N*/ 		,m_nInvalidationEvent(0)
/*N*/ 		,m_bFilterMode(sal_False)
/*N*/ 		,m_bHadPropBrw(sal_False)
/*N*/ 		,m_pMainFrameInterceptor(NULL)
/*N*/ 		,m_pExternalViewInterceptor(NULL)
/*N*/ 		,m_bChangingDesignMode(sal_False)
/*N*/ 		,m_bUseWizards(sal_True)
/*N*/ 		,m_bPreparedClose( sal_False )
/*N*/ {
/*N*/ 	DBG_CTOR(FmXFormShell,NULL);
/*N*/ 	m_aMarkTimer.SetTimeout(100);
/*N*/ 	m_aMarkTimer.SetTimeoutHdl(LINK(this,FmXFormShell,OnTimeOut));
/*N*/ 
/*N*/ 	// we are a DispatchInterceptor, so we want to be inserted into the frame's dispatch chain, thus having
/*N*/ 	// a chance for frame-spanning communication (via UNO, not slots)
/*N*/ 	SfxFrame* pFrame = _pViewFrame ? _pViewFrame->GetFrame() : NULL;
/*N*/ 	Reference< ::com::sun::star::frame::XFrame> xUnoFrame;
/*N*/ 	if( pFrame)
/*N*/ 		xUnoFrame = pFrame->GetFrameInterface();
/*N*/ 	else
/*?*/ 		xUnoFrame = Reference< ::com::sun::star::frame::XFrame>(NULL);
/*N*/ 
/*N*/ 	// to prevent deletion of this we acquire our refcounter once
/*N*/ 	::comphelper::increment(FmXFormShell_BASE::m_refCount);
/*N*/ 
/*N*/ 	// dispatch interception for the frame
/*N*/ 	Reference< ::com::sun::star::frame::XDispatchProviderInterception> xSupplier(xUnoFrame, UNO_QUERY);
/*N*/ 
/*N*/ 	::rtl::OUString sInterceptorScheme = FMURL_FORMSLOTS_PREFIX;
/*N*/ 	sInterceptorScheme += ::rtl::OUString::createFromAscii("*");
/*N*/ 	m_pMainFrameInterceptor = new FmXDispatchInterceptorImpl(xSupplier, this, 0, Sequence< ::rtl::OUString >(&sInterceptorScheme, 1));
/*N*/ 	m_pMainFrameInterceptor->acquire();
/*N*/ 
/*N*/ 	m_xAttachedFrame = xUnoFrame;
/*N*/ 
/*N*/ 	// correct the refcounter
/*N*/ 	::comphelper::decrement(FmXFormShell_BASE::m_refCount);
/*N*/ 
/*N*/ 	// cache the current configuration settings we're interested in
/*N*/ 	implAdjustConfigCache();
/*N*/ 	// and register for changes on this settings
/*N*/ 	Sequence< ::rtl::OUString > aNames(1);
/*N*/ 	aNames[0] = ::rtl::OUString::createFromAscii("FormControlPilotsEnabled");
/*N*/ 	EnableNotification(aNames);
/*N*/ }

//------------------------------------------------------------------------
/*N*/ FmXFormShell::~FmXFormShell()
/*N*/ {
/*N*/ 	DBG_DTOR(FmXFormShell,NULL);
/*N*/ }

//------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
/*N*/ Sequence< sal_Int8 > SAL_CALL FmXFormShell::getImplementationId() throw(RuntimeException)
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); Sequence< sal_Int8 > a; return a;//STRIP001 
/*N*/ }
//	EventListener
//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormShell::disposing(const EventObject& e) throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 //STRIP001 	if (m_xActiveController == e.Source)
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormShell::propertyChange(const PropertyChangeEvent& evt) throw(::com::sun::star::uno::RuntimeException)
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*?*/ }

// XModifyListener
//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormShell::modified(const EventObject& rEvent) throw(::com::sun::star::uno::RuntimeException)
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*?*/ }

//------------------------------------------------------------------------------
/*N*/ Reference< ::com::sun::star::frame::XDispatch> FmXFormShell::interceptedQueryDispatch(sal_uInt16 _nId, const URL& aURL, const ::rtl::OUString& aTargetFrameName, sal_Int32 nSearchFlags) throw( RuntimeException )
/*N*/ {
/*N*/ 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*N*/ 	::osl::MutexGuard aGuard(m_aAsyncSafety);
/*N*/ 
/*N*/ 	if (!m_pShell)
/*?*/ 		return Reference< ::com::sun::star::frame::XDispatch>();
/*N*/ 	// if we have no shell we are disposed, so we disposed all our dispatchers, too, so there is no need to supply a dispatcher
/*N*/ 	// (and no possibility : without our shell, methods like GetPageForms won't work properly)
/*N*/ 
/*N*/ 	// check if it is one of the form navigation urls
/*N*/ 	static ::rtl::OUString sFormNavUrls[] = {
/*N*/ 		FMURL_RECORD_MOVEFIRST,
/*N*/ 		FMURL_RECORD_MOVEPREV,
/*N*/ 		FMURL_RECORD_MOVENEXT,
/*N*/ 		FMURL_RECORD_MOVELAST,
/*N*/ 		FMURL_RECORD_MOVETONEW,
/*N*/ 		FMURL_RECORD_UNDO
/*N*/ 	};
/*N*/ 	static sal_Int16 nAccordingSlots[] = {
/*N*/ 		SID_FM_RECORD_FIRST,
/*N*/ 		SID_FM_RECORD_PREV,
/*N*/ 		SID_FM_RECORD_NEXT,
/*N*/ 		SID_FM_RECORD_LAST,
/*N*/ 		SID_FM_RECORD_NEW,
/*N*/ 		SID_FM_RECORD_UNDO
/*N*/ 	};
/*N*/ 	::rtl::OUString sMark;
/*N*/ 	UniString sAccessPath,sExternalCheck,sPageId;
/*N*/ 	for (sal_Int16 i=0; i<sizeof(sFormNavUrls)/sizeof(sFormNavUrls[0]); ++i)
/*N*/ 	{
/*N*/ 		if (aURL.Main.equals(sFormNavUrls[i]))
/*N*/ 		{
/*?*/			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 			sMark = aURL.Mark;
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	return Reference< ::com::sun::star::frame::XDispatch>();
/*N*/ }

//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormShell::formActivated(const EventObject& rEvent) throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormShell::formDeactivated(const EventObject& rEvent) throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*?*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormShell::disposing()
/*N*/ {
/*N*/ 	FmXFormShell_BASE::disposing();
/*N*/ 
/*N*/ 	if ( m_pShell && !m_pShell->IsDesignMode() )
/*N*/ 		setActiveController( NULL, sal_True );
/*N*/ 		// do NOT save the content of the old form (the second parameter tells this)
/*N*/ 		// if we're here, then we expect that PrepareClose has been called, and thus the user
/*N*/ 		// got a chance to commit or reject any changes. So in case we're here and the there
/*N*/ 		// are still uncommitted changes, the user explicitly wanted this.
/*N*/ 		// 2002-11-11 - 104702 - fs@openoffice.org
/*N*/ 
/*N*/ 	// dispose our interceptor helpers
/*N*/ 	if (m_pMainFrameInterceptor)
/*N*/ 	{
/*N*/ 		m_pMainFrameInterceptor->dispose();
/*N*/ 		m_pMainFrameInterceptor->release();
/*N*/ 		m_pMainFrameInterceptor = NULL;
/*N*/ 	}
/*N*/ 	if (m_pExternalViewInterceptor)
/*N*/ 	{
/*?*/ 		m_pExternalViewInterceptor->dispose();
/*?*/ 		m_pExternalViewInterceptor->release();
/*?*/ 		m_pExternalViewInterceptor = NULL;
/*N*/ 	}
/*N*/ 
/*N*/ 	m_xAttachedFrame = NULL;
/*N*/ 
/*N*/ 	CloseExternalFormViewer();
/*N*/ 
/*N*/ 	while ( m_aLoadingPages.size() )
/*N*/ 	{
/*?*/ 		Application::RemoveUserEvent( m_aLoadingPages.front().nEventId );
/*?*/ 		m_aLoadingPages.pop();
/*N*/ 	}
/*N*/ 
/*N*/ 	// dispose all our navigation dispatchers
/*N*/ 	for (	FormsDispatchersIterator aFormIter = m_aNavigationDispatcher.begin();
/*N*/ 			aFormIter != m_aNavigationDispatcher.end();
/*N*/ 			++aFormIter
/*N*/ 		)
/*N*/ 	{
/*?*/ 		for (	SingleFormDispatchersIterator aDispIter = (*aFormIter).second.begin();
/*?*/ 				aDispIter < (*aFormIter).second.end();
/*?*/ 				++aDispIter
/*?*/ 			)
/*?*/ 		{
/*?*/ 			FmFormNavigationDispatcher* pCurDispatcher = *aDispIter;
/*?*/ 			if (pCurDispatcher)
/*?*/ 			{
/*?*/ 				pCurDispatcher->dispose();
/*?*/ 				pCurDispatcher->release();
/*?*/ 				*aDispIter = NULL;
/*?*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 	m_aNavigationDispatcher.clear();
/*N*/ 
/*N*/ 	{
/*N*/ 		::osl::MutexGuard aGuard(m_aInvalidationSafety);
/*N*/ 		if (m_nInvalidationEvent)
/*N*/ 		{
/*?*/ 			Application::RemoveUserEvent(m_nInvalidationEvent);
/*?*/ 			m_nInvalidationEvent = 0;
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	{
/*N*/ 		::osl::ClearableMutexGuard aGuard(m_aAsyncSafety);
/*N*/ 		if (HasAnyPendingCursorAction())
/*?*/			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 			CancelAnyPendingCursorAction();
/*N*/ 		aGuard.clear();
/*N*/ 
/*N*/ 		DBG_ASSERT(!m_nInvalidationEvent, "FmXFormShell::~FmXFormShell : still have an invalidation event !");
/*N*/ 			// should habe been deleted while beeing disposed
/*N*/ 
/*N*/ 		m_aMarkTimer.Stop();
/*N*/ 	}
/*N*/ 
/*N*/ 	// we are disposed from within the destructor of our shell, so now the shell pointer is invalid ....
/*N*/ 	m_pShell					= NULL;
/*N*/ 	m_xActiveController 		= NULL;
/*N*/ 	m_xNavigationController 	= NULL;
/*N*/ 	m_xActiveForm				= NULL;
/*N*/ 	m_xParser					= NULL;
/*N*/ 	m_xForms					= NULL;
/*N*/ 	m_xSelObject				= NULL;
/*N*/ 	m_xCurControl				= NULL;
/*N*/ 	m_xCurForm					= NULL;
/*N*/ 	m_xLastGridFound			= NULL;
/*N*/ 	m_xAttachedFrame			= NULL;
/*N*/ 	m_xExternalViewController	= NULL;
/*N*/ 	m_xExtViewTriggerController = NULL;
/*N*/ 	m_xExternalDisplayedForm	= NULL;
/*N*/ 	m_xLastGridFound			= NULL;
/*N*/ }

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------
/*N*/ sal_Bool FmXFormShell::CommitCurrent(const Reference< XFormController>& _xController)
/*N*/ {DBG_BF_ASSERT(0, "STRIP");return FALSE;//STRIP001 
/*N*/ }

//------------------------------------------------------------------------

//------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

// XRowSetListener
//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormShell::cursorMoved(const EventObject& event) throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*?*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormShell::CloseExternalFormViewer()
/*N*/ {
/*N*/ 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*N*/ 	if (!m_xExternalViewController.is())
/*N*/ 		return;
/*N*/ 
/*?*/ 	Reference< ::com::sun::star::frame::XFrame> xExternalViewFrame( m_xExternalViewController->getFrame());
/*?*/ 	Reference< ::com::sun::star::frame::XDispatchProvider> xCommLink(xExternalViewFrame, UNO_QUERY);
/*?*/ 	if (!xCommLink.is())
/*?*/ 		return;
/*?*/ 
/*?*/ 	xExternalViewFrame->setComponent(NULL,NULL);
/*?*/ 	::comphelper::disposeComponent(xExternalViewFrame);
/*?*/ 	
/*?*/ //	URL aCloseUrl;
/*?*/ //		// tool windows (like the task local beamer used for the grid) are assumed to close when dispatching an empty URL
/*?*/ //
/*?*/ //	Reference< ::com::sun::star::frame::XDispatch> xCloser(xCommLink->queryDispatch(aCloseUrl, ::rtl::OUString::createFromAscii("_self"), 0));
/*?*/ //	DBG_ASSERT(xCloser.is(), "FmXFormShell::CloseExternalFormViewer : don't know how to close the tool frame !");
/*?*/ //	if (xCloser.is())
/*?*/ //		xCloser->dispatch(aCloseUrl, Sequence< PropertyValue>());
/*?*/ 
/*?*/ 	m_xExternalViewController	= NULL;
/*?*/ 	m_xExtViewTriggerController = NULL;
/*?*/ 	m_xExternalDisplayedForm	= NULL;
/*N*/ }

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
/*N*/ void FmXFormShell::setActiveController( const Reference< XFormController>& xController, sal_Bool _bNoSaveOldContent )
/*N*/ {
/*N*/ 	DBG_ASSERT(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*N*/ 	if (m_bChangingDesignMode)
/*N*/ 		return;
/*N*/ 	DBG_ASSERT(!m_pShell->IsDesignMode(), "nur im alive mode verwenden");
/*N*/ 
/*N*/ 	// Ist die Routine ein zweites Mal gerufen worden,
/*N*/ 	// dann sollte der Focus nicht mehr umgesetzt werden
/*N*/ 	if (m_bInActivate)
/*N*/ 	{
/*N*/ 		m_bSetFocus = xController != m_xActiveController;
/*N*/ 		return;
/*N*/ 	}
/*N*/ 
/*N*/ 	if (xController != m_xActiveController)
/*?*/ 	{{DBG_BF_ASSERT(0, "STRIP"); }//STRIP001 
/*?*/ 	}
/*?*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormShell::setCurControl( const SdrMarkList& rMarkList )
/*N*/ {
/*N*/ 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*N*/ 	if (isControlList(rMarkList))
/*N*/ 	{
/*N*/ 		// Aktuell selektiertes Objekt setzen
/*?*/ 		sal_uInt32 nMarkCount = rMarkList.GetMarkCount();
/*?*/ 		FmFormObj* pSelFormObj = NULL;
/*?*/ 		if (nMarkCount==1)
/*?*/ 		{
/*?*/ 			SdrObject *pObj=rMarkList.GetMark(0)->GetObj();
/*?*/ 
/*?*/ 			if( pObj->IsGroupObject() ) // Mehrfachselektion
/*?*/ 			{
/*?*/ 				Reference< XPropertyState> xMultiIFace(FmXMultiSet::Create( rMarkList ));
/*?*/ 				setCurControl( xMultiIFace );
/*?*/ 			}
/*?*/ 			else
/*?*/ 			{
/*?*/ 				pSelFormObj = PTR_CAST(FmFormObj, rMarkList.GetMark(0)->GetObj());
/*?*/ 
/*?*/ 				if ( pSelFormObj ) // Einfachselektion
/*?*/ 				{
/*?*/ 					Reference< XFormComponent> xFormComponent(pSelFormObj->GetUnoControlModel(), UNO_QUERY);
/*?*/ 					if (xFormComponent.is())
/*?*/ 						setCurControl(xFormComponent);
/*?*/ 					else
/*?*/ 						setCurControl( Reference< XInterface>() );
/*?*/ 				}
/*?*/ 				else
/*?*/ 					setCurControl( Reference< XInterface>() );
/*?*/ 			}
/*?*/ 		}
/*?*/ 		else if (nMarkCount > 1)			// Mehrfachselektion
/*?*/ 		{
/*?*/ 			Reference< XPropertyState> xMultiIFace(FmXMultiSet::Create( rMarkList ));
/*?*/ 			setCurControl( xMultiIFace );
/*?*/ 		}
/*N*/ 	}
/*N*/ 	else // Keine Selektion oder gemischt
/*N*/ 		setCurControl( Reference< XInterface>() );
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormShell::setCurControl(const Reference< XInterface>& xNewControl)
/*N*/ {
/*N*/ 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*N*/ 	DBG_ASSERT(m_pShell->IsDesignMode(), "nur im designmode verwenden");
/*N*/ 
/*N*/ 	if (m_xCurControl == xNewControl)
/*N*/ 		return;
/*N*/ 
/*N*/ 	// Stammen beide Objecte vom gleichen Container
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 	if (m_xCurControl.is())
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormShell::setSelObject(const Reference< XInterface>& xNewObj)
/*N*/ {
/*N*/ 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*N*/ 	DBG_ASSERT(m_pShell->IsDesignMode(), "nur im designmode verwenden");
/*N*/ 
/*N*/ 	if (m_xSelObject != xNewObj)
/*N*/ 	{
/*?*/ 		m_xSelObject = xNewObj;
/*?*/ 		for (sal_Int16 i = 0; i<sizeof(SelObjectSlotMap)/sizeof(SelObjectSlotMap[0]); ++i)
/*?*/			 {DBG_BF_ASSERT(0, "STRIP"); }//STRIP001 /*?*/ 			InvalidateSlot(SelObjectSlotMap[i]);
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

  // XContainerListener
//------------------------------------------------------------------------------
/*N*/ void FmXFormShell::elementInserted(const ContainerEvent& evt) throw(::com::sun::star::uno::RuntimeException)
/*N*/ {
/*N*/ 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*N*/ 	// neues Object zum lauschen
/*N*/ 	Reference< XInterface> xTemp;
/*N*/ 	evt.Element >>= xTemp;
/*N*/ 	AddElement(xTemp);
/*N*/ 	m_pShell->DetermineForms(sal_True);
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormShell::elementReplaced(const ContainerEvent& evt) throw(::com::sun::star::uno::RuntimeException)
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }

//------------------------------------------------------------------------------
/*?*/ void FmXFormShell::elementRemoved(const ContainerEvent& evt) throw(::com::sun::star::uno::RuntimeException)
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*?*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormShell::ResetForms(const Reference< XIndexAccess>& _xForms, sal_Bool bInvalidate)
/*N*/ {
/*N*/ 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*N*/ 	if (m_xForms != _xForms)
/*N*/ 	{
/*N*/ 		RemoveElement(m_xForms);
/*N*/ 
/*N*/ 		m_xForms = _xForms;
/*N*/ 
/*N*/ 		AddElement(m_xForms);
/*N*/ 	}
/*N*/ 	m_pShell->DetermineForms(bInvalidate);
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormShell::AddElement(const Reference< XInterface>& Element)
/*N*/ {
/*N*/ 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*N*/ 	// am Container horchen
/*N*/ 	Reference< XIndexContainer> xContainer(Element, UNO_QUERY);
/*N*/ 	if (xContainer.is())
/*N*/ 	{
/*N*/ 		sal_uInt32 nCount = xContainer->getCount();
/*N*/ 		Reference< XInterface> xElement;
/*N*/ 		for (sal_uInt32 i = 0; i < nCount; i++)
/*N*/ 		{
/*N*/ 			xContainer->getByIndex(i) >>= xElement;
/*N*/ 			AddElement(xElement);
/*N*/ 		}
/*N*/ 
/*N*/ 		Reference< XContainer> xCont(Element, UNO_QUERY);
/*N*/ 		if (xCont.is())
/*N*/ 			xCont->addContainerListener(this);
/*N*/ 	}
/*N*/ 
/*N*/ 	Reference< ::com::sun::star::view::XSelectionSupplier> xSelSupplier(Element, UNO_QUERY);
/*N*/ 	if (xSelSupplier.is())
/*?*/ 		xSelSupplier->addSelectionChangeListener(this);
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormShell::RemoveElement(const Reference< XInterface>& Element)
/*N*/ {
/*N*/ 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*N*/ 	Reference< ::com::sun::star::view::XSelectionSupplier> xSelSupplier(Element, UNO_QUERY);
/*N*/ 	if (xSelSupplier.is())
/*?*/ 		xSelSupplier->removeSelectionChangeListener(this);
/*N*/ 
/*N*/ 	// Verbindung zu Kindern aufheben
/*N*/ 	Reference< XIndexContainer> xContainer(Element, UNO_QUERY);
/*N*/ 	if (xContainer.is())
/*N*/ 	{
/*N*/ 		Reference< XContainer> xCont(Element, UNO_QUERY);
/*N*/ 		if (xCont.is())
/*N*/ 			xCont->removeContainerListener(this);
/*N*/ 
/*N*/ 		sal_uInt32 nCount = xContainer->getCount();
/*N*/ 		Reference< XInterface> xElement;
/*N*/ 		for (sal_uInt32 i = 0; i < nCount; i++)
/*N*/ 		{
/*N*/ 			xContainer->getByIndex(i) >>= xElement;
/*N*/ 			RemoveElement(xElement);
/*N*/ 		}
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------------
/*?*/ void FmXFormShell::selectionChanged(const EventObject& rEvent) throw(::com::sun::star::uno::RuntimeException)
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*?*/ }

//------------------------------------------------------------------------------
/*N*/ IMPL_LINK(FmXFormShell, OnTimeOut, void*, EMPTYTAG)
/*N*/ {
/*N*/ 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*N*/ 	if (m_pShell->IsDesignMode() && m_pShell->GetFormView())
/*N*/ 		SetSelection(m_pShell->GetFormView()->GetMarkList());
/*N*/ 
/*N*/ 	return 0;
/*N*/ }

//------------------------------------------------------------------------
/*N*/ void FmXFormShell::SetSelectionDelayed(FmFormView* pView)
/*N*/ {
/*N*/ 	if (m_pShell->IsDesignMode() && IsTrackPropertiesEnabled() && !m_aMarkTimer.IsActive())
/*N*/ 		m_aMarkTimer.Start();
/*N*/ }

//------------------------------------------------------------------------
/*N*/ void FmXFormShell::SetSelection(const SdrMarkList& rMarkList)
/*N*/ {
/*N*/ 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*N*/ 	DetermineSelection(rMarkList);
/*N*/ 	m_pShell->NotifyMarkListChanged(m_pShell->GetFormView());
/*N*/ }

//------------------------------------------------------------------------
/*N*/ void FmXFormShell::DetermineSelection(const SdrMarkList& rMarkList)
/*N*/ {
/*N*/ 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*N*/ 	// Aktuelles Objekt setzen
/*N*/ 	Reference< XInterface> xPreviousObject( m_xSelObject);
/*N*/ 	sal_Bool bMixedWithFormControls = sal_True;
/*N*/ 	Reference< XForm> xNewForm( DetermineCurForm(rMarkList, bMixedWithFormControls));
/*N*/ 
/*N*/ 	// Aktuelle Form anpassen
/*N*/ 	if (xNewForm.is() || bMixedWithFormControls)
/*N*/ 	{
/*N*/ 		// die Form wird nur angepasst, wenn eine eindeutige From gefunden wurde oder eine gemischte Selektion existiert,
/*N*/ 		// die auch FormControls enthaelt (NICHT bei einer Selektion ohne solche oder bei leerer Selektion)
/*?*/		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 		if ((XForm*)xNewForm.get() != (XForm*)m_xCurForm.get())
/*N*/ 	}
/*N*/ 
/*N*/ 	setCurControl(rMarkList);
/*N*/ 
/*N*/ 	// wurde vorher Form angezeigt, dann wieder die Form anzeigen
/*N*/ 	Reference< XForm> xOldForm(m_xSelObject, UNO_QUERY);
/*N*/ 	if (xOldForm.is())
/*?*/ 		setSelObject(xNewForm);
/*N*/ 	else
/*N*/ 		setSelObject(m_xCurControl);
/*N*/ 
/*N*/ 	// Falls ein Propertybrowser angezeigt wird, diesen invalidieren
/*N*/ 	if (IsPropBrwOpen() && xPreviousObject != m_xSelObject)
/*?*/		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 		ShowProperties(m_xSelObject, sal_True);
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ sal_Bool FmXFormShell::IsPropBrwOpen() const
/*N*/ {
/*N*/ 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*N*/ 	return( ( m_pShell->GetViewShell() && m_pShell->GetViewShell()->GetViewFrame() ) ?
/*N*/ 			m_pShell->GetViewShell()->GetViewFrame()->HasChildWindow(SID_FM_SHOW_PROPERTIES) : sal_False );
/*N*/ }

//------------------------------------------------------------------------------
class FmXFormShell::SuspendPropertyTracking
{
private:
	FmXFormShell*	m_pShell;
	sal_Bool		m_bEnabled;

public:
	SuspendPropertyTracking( FmXFormShell* _pShell )
		:m_pShell( _pShell )
		,m_bEnabled( sal_False )
	{
		if ( m_pShell && m_pShell->IsTrackPropertiesEnabled() )
		{
			m_pShell->EnableTrackProperties( sal_False );
			m_bEnabled = sal_True;
		}
	}

};

//------------------------------------------------------------------------------
/*N*/ void FmXFormShell::SetDesignMode(sal_Bool bDesign)
/*N*/ {
/*N*/ 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*N*/ 	DBG_ASSERT(m_pShell && m_pShell->GetFormView(), "FmXFormShell::SetDesignMode : invalid call (have no shell or no view) !");
/*N*/ 	m_bChangingDesignMode = sal_True;
/*N*/ 
/*N*/ 	// 67506 - 15.07.99 - FS
/*N*/ 	// if we're switching off the design mode we have to force the property browser to be closed
/*N*/ 	// so it can commit it's changes _before_ we load the forms
/*N*/ 	if (!bDesign)
/*N*/ 	{
/*N*/ 		m_bHadPropBrw = m_pShell->GetViewShell()->GetViewFrame()->HasChildWindow(SID_FM_SHOW_PROPERTIES);
/*N*/ 		if (m_bHadPropBrw)
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 m_pShell->GetViewShell()->GetViewFrame()->ToggleChildWindow(SID_FM_SHOW_PROPERTIES);
/*N*/ 	}
/*N*/ 
/*N*/ 	FmFormView* pFormView = m_pShell->GetFormView();
/*N*/ 	if (bDesign)
/*N*/ 	{
/*N*/ 		// we are currently filtering, so stop filtering
/*N*/ 		if (m_bFilterMode)
/*?*/			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 			stopFiltering(sal_False);
/*N*/ 
/*N*/ 		// an den Objekten meiner MarkList als Listener abmelden
/*N*/ 		pFormView->GetImpl()->stopMarkListWatching();
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		m_aMarkTimer.Stop();
/*N*/ 
/*N*/ 		SuspendPropertyTracking aSuspend( this );
/*N*/ 		pFormView->GetImpl()->saveMarkList( sal_True );
/*N*/ 	}
/*N*/ 
/*N*/ 	if (bDesign && m_xExternalViewController.is())
/*?*/ 		CloseExternalFormViewer();
/*N*/ 
/*N*/ 	pFormView->ChangeDesignMode(bDesign);
/*N*/ 
/*N*/ 	// Listener benachrichtigen
/*N*/ 	FmDesignModeChangedHint aChangedHint( bDesign );
/*N*/ 	m_pShell->Broadcast(aChangedHint);
/*N*/ 
/*N*/ 	FmFormPage* pPage = m_pShell->GetCurPage();
/*N*/ 	if (pPage)
/*N*/ 	{
/*N*/ 		if (bDesign)
/*N*/ 		{
/*N*/ 			Reference< XIndexAccess> xIndex(pPage->GetForms(), UNO_QUERY);
/*N*/ 			ResetForms(xIndex, sal_False);
/*N*/ 		}
/*N*/ 		else
/*N*/ 			ResetForms();
/*N*/ 	}
/*N*/ 
/*N*/ 	m_pShell->m_bDesignMode = bDesign;
/*N*/ 	if (bDesign)
/*N*/ 	{
/*N*/ 		SdrMarkList aList;
/*N*/ 		{
/*N*/ 			// during changing the mark list, don't track the selected objects in the property browser
/*N*/ 			SuspendPropertyTracking aSuspend( this );
/*N*/ 			// restore the marks
/*N*/ 			pFormView->GetImpl()->restoreMarkList( aList );
/*N*/ 		}
/*N*/ 
/*N*/ 		// synchronize with the restored mark list
/*N*/ 		if ( aList.GetMarkCount() )
/*?*/ 			SetSelection( aList );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		// am Model der View als Listener anmelden (damit ich mitbekomme, wenn jemand waehrend des Alive-Modus
/*N*/ 		// Controls loescht, die ich eigentlich mit saveMarkList gespeichert habe) (60343)
/*N*/ 		pFormView->GetImpl()->startMarkListWatching();
/*N*/ 	}
/*N*/ 
/*N*/ 	m_pShell->UIFeatureChanged();
/*N*/ 
/*N*/ 	// 67506 - 15.07.99 - FS
/*N*/ 	if (bDesign && m_bHadPropBrw)
/*N*/ 	{
/*N*/ 		// The UIFeatureChanged performes an update (a check of the available features) asynchronously.
/*N*/ 		// So we can't call ShowProperties directly as the according feature isn't enabled yet.
/*N*/ 		// That's why we use an asynchron execution on the dispatcher.
/*N*/ 		// (And that's why this has to be done AFTER the UIFeatureChanged.)
/*?*/		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 		FmInterfaceItem aInterfaceItem( SID_FM_SHOW_PROPERTY_BROWSER, getSelObject() );
/*N*/ 	}
/*N*/ 	m_bChangingDesignMode = sal_False;
/*N*/ }

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
//void FmXFormShell::SetWizardUsing(sal_Bool bUseThem)
//{
//	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//
//	m_bUseWizards = bUseThem;
//
//	// forward this to the configuration
//	Sequence< ::rtl::OUString > aNames(1);
//	aNames[0] = ::rtl::OUString::createFromAscii("FormControlPilotsEnabled");
//	Sequence< Any > aValues(1);
//	aValues[0] = bool2any(m_bUseWizards);
//	m_aWizardUsing.SetProperties(aNames, aValues);
//}

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
/*N*/ sal_Bool FmXFormShell::HasAnyPendingCursorAction() const
/*N*/ {
/*N*/ 	::osl::MutexGuard aGuard(((FmXFormShell*)this)->m_aAsyncSafety);
/*N*/ 
/*N*/ 	for (ConstCursorActionsIterator aIter = m_aCursorActions.begin(); aIter != m_aCursorActions.end(); ++aIter)
/*N*/ 	{
/*?*/ 		if (((*aIter).second.pThread != NULL) || ((*aIter).second.nFinishedEvent != 0))
/*?*/ 			return sal_True;
/*N*/ 	}
/*N*/ 	return sal_False;
/*N*/ }

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------
/*N*/ void FmXFormShell::implAdjustConfigCache()
/*N*/ {
/*N*/ 	// get (cache) the wizard usage flag
/*N*/ 	Sequence< ::rtl::OUString > aNames(1);
/*N*/ 	aNames[0] = ::rtl::OUString::createFromAscii("FormControlPilotsEnabled");
/*N*/ 	Sequence< Any > aFlags = GetProperties(aNames);
/*N*/ 	if (1 == aFlags.getLength())
/*N*/ 		m_bUseWizards = ::cppu::any2bool(aFlags[0]);
/*N*/ }

//------------------------------------------------------------------------

//------------------------------------------------------------------------

//------------------------------------------------------------------------
/*N*/ void FmXFormShell::viewDeactivated( FmFormView* _pCurrentView, sal_Bool _bDeactivateController /* = sal_True */ )
/*N*/ {
/*N*/ 	// deactivate our view if we are deactivated ourself
/*N*/ 	// FS - 30.06.99 - 67308
/*N*/ 	if ( _pCurrentView )
/*N*/ 	{
/*N*/ 		// deactivate the controls on this page
/*N*/ 		if ( _pCurrentView->GetImpl() && !_pCurrentView->IsDesignMode() )
/*N*/ 		{
/*N*/ 			_pCurrentView->GetImpl()->Deactivate( _bDeactivateController );
/*N*/ 		}
/*N*/ 
/*N*/ 		// if we have an async load operation pending for the 0-th page for this view,
/*N*/ 		// we need to cancel this
/*N*/ 		// 103727 - 2002-09-26 - fs@openoffice.org
/*N*/ 		const SdrPageView* pCurPageView = _pCurrentView->GetPageViewPvNum( 0 );
/*N*/ 		const FmFormPage* pPage = pCurPageView ? PTR_CAST( FmFormPage, pCurPageView->GetPage() ) : NULL;
/*N*/ 		if ( pPage )
/*N*/ 		{
/*N*/ 			// move all events from our queue to a new one, omit the events for the deactivated
/*N*/ 			// page
/*N*/ 			::std::queue< FmLoadAction > aNewEvents;
/*N*/ 			while ( m_aLoadingPages.size() )
/*N*/ 			{
/*N*/ 				FmLoadAction aAction = m_aLoadingPages.front();
/*N*/ 				m_aLoadingPages.pop();
/*N*/ 				if ( pPage != aAction.pPage )
/*N*/ 				{
/*?*/ 					aNewEvents.push( aAction );
/*N*/ 				}
/*N*/ 				else
/*N*/ 				{
/*N*/ 					Application::RemoveUserEvent( aAction.nEventId );
/*N*/ 				}
/*N*/ 			}
/*N*/ 			m_aLoadingPages = aNewEvents;
/*N*/ 		}
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------
/*N*/ void FmXFormShell::viewActivated( FmFormView* _pCurrentView, sal_Bool _bSyncAction /* = sal_False */ )
/*N*/ {
/*N*/ 	// activate our view if we are activated ourself
/*N*/ 	// FS - 30.06.99 - 67308
/*N*/ 	if ( _pCurrentView && _pCurrentView->GetImpl() && !_pCurrentView->IsDesignMode() )
/*N*/ 	{
/*N*/ 		// load forms for the page the current view belongs to
/*N*/ 		SdrPageView* pCurPageView = _pCurrentView->GetPageViewPvNum( 0 );
/*N*/ 		FmFormPage* pPage = pCurPageView ? PTR_CAST( FmFormPage, pCurPageView->GetPage() ) : NULL;
/*N*/ 		if ( pPage )
/*N*/ 		{
/*N*/ 			if ( !pPage->GetImpl()->hasEverBeenActivated() )
/*N*/ 				loadForms( pPage, FORMS_LOAD | ( _bSyncAction ? FORMS_SYNC : FORMS_ASYNC ) );
/*N*/ 			pPage->GetImpl()->setHasBeenActivated( );
/*N*/ 		}
/*N*/ 
/*N*/ 		// first-time initializations for the views
/*N*/ 		if ( !_pCurrentView->GetImpl()->hasEverBeenActivated( ) )
/*N*/ 		{
/*N*/ 			_pCurrentView->GetImpl()->onFirstViewActivation( PTR_CAST( FmFormModel, _pCurrentView->GetModel() ) );
/*N*/ 			_pCurrentView->GetImpl()->setHasBeenActivated( );
/*N*/ 		}
/*N*/ 
/*N*/ 		// activate the current view
/*N*/ 		_pCurrentView->GetImpl()->Activate( _bSyncAction );
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------------

//------------------------------------------------------------------------
/*N*/ IMPL_LINK( FmXFormShell, OnLoadForms, FmFormPage*, _pPage )
/*N*/ {
/*N*/ 	FmLoadAction aAction = m_aLoadingPages.front();
/*N*/ 	m_aLoadingPages.pop();
/*N*/ 
/*N*/ 	loadForms( aAction.pPage, aAction.nFlags & ~FORMS_ASYNC );
/*N*/ 	return 0L;
/*N*/ }

//------------------------------------------------------------------------
/*N*/ void FmXFormShell::loadForms( FmFormPage* _pPage, const sal_uInt16 _nBehaviour /* FORMS_LOAD | FORMS_SYNC */ )
/*N*/ {
/*N*/ 	DBG_ASSERT( ( _nBehaviour & ( FORMS_ASYNC | FORMS_UNLOAD ) )  != ( FORMS_ASYNC | FORMS_UNLOAD ),
/*N*/ 		"FmXFormShell::loadForms: async loading not supported - this will heavily fail!" );
/*N*/ 
/*N*/ 	if ( _nBehaviour & FORMS_ASYNC )
/*N*/ 	{
/*N*/ 		m_aLoadingPages.push( FmLoadAction(
/*N*/ 			_pPage,
/*N*/ 			_nBehaviour,
/*N*/ 			Application::PostUserEvent( LINK( this, FmXFormShell, OnLoadForms ), _pPage )
/*N*/ 		) );
/*N*/ 		return;
/*N*/ 	}
/*N*/ 
/*N*/ 	DBG_ASSERT( _pPage, "FmXFormShell::loadForms: invalid page!" );
/*N*/ 	if ( _pPage )
/*N*/ 	{
/*N*/ 		// lock the undo env so the forms can change non-transient properties while loading
/*N*/ 		// (without this my doc's modified flag would be set)
/*N*/ 		FmFormModel* pModel = PTR_CAST( FmFormModel, _pPage->GetModel() );
/*N*/ 		DBG_ASSERT( pModel, "FmXFormShell::loadForms: invalid model!" );
/*N*/ 		if ( pModel )
/*N*/ 			pModel->GetUndoEnv().Lock();
/*N*/ 
/*N*/ 		// load all forms
/*N*/ 		Reference< XIndexAccess >  xForms;
/*N*/ 		xForms = xForms.query( _pPage->GetForms() );
/*N*/ 		DBG_ASSERT( xForms.is(), "FmXFormShell::loadForms: invalid forms collection!" );
/*N*/ 
/*N*/ 		if ( xForms.is() )
/*N*/ 		{
/*N*/ 			Reference< XLoadable >  xForm;
/*N*/ 			for ( sal_Int32 j = 0, nCount = xForms->getCount(); j < nCount; ++j )
/*N*/ 			{
/*?*/ 				xForms->getByIndex( j ) >>= xForm;
/*?*/ 				// a database form must be loaded for
/*?*/ 				if ( 0 == ( _nBehaviour & FORMS_UNLOAD ) )
/*?*/ 				{
/*?*/					DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 					if ( ::isLoadable( xForm ) && !xForm->isLoaded() )
/*?*/ 				}
/*?*/ 				else
/*?*/ 				{
/*?*/ 					if ( xForm->isLoaded() )
/*?*/ 						xForm->unload();
/*?*/ 
/*?*/ 					if ( _nBehaviour & FORMS_RESET )
/*?*/ 					{
/*?*/ 						Reference< XReset > xReset( xForm, UNO_QUERY );
/*?*/ 						DBG_ASSERT( xReset.is(), "FmXFormShell::loadForms: the form cannot be resets!" );
/*?*/ 						if ( xReset.is() )
/*?*/ 							xReset->reset();
/*?*/ 					}
/*?*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		if ( pModel )
/*N*/ 			// unlock the environment
/*N*/ 			pModel->GetUndoEnv().UnLock();
/*N*/ 	}
/*N*/ }

//==============================================================================
//==============================================================================

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//==============================================================================
//==============================================================================
/*N*/ SV_IMPL_PTRARR(StatusForwarderArray, SfxStatusForwarder*)

/*N*/ SFX_IMPL_MENU_CONTROL(ControlConversionMenuController, SfxBoolItem);

//------------------------------------------------------------------------------
/*?*/ ControlConversionMenuController::ControlConversionMenuController(sal_uInt16 nId, Menu &rMenu, SfxBindings &rBindings)
/*?*/ 	:SfxMenuControl(nId, rBindings)
/*?*/ 	,m_pMainMenu(&rMenu)
/*?*/ 	,m_pConversionMenu(NULL)
/*?*/ {
/*?*/	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	if (nId == SID_FM_CHANGECONTROLTYPE)
/*?*/ }

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//==================================================================


//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//==============================================================================
//==============================================================================

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//==============================================================================




}
