/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fmsrcimp.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 21:09:43 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _FMSRCIMP_HXX
#define _FMSRCIMP_HXX







#ifndef _UNOTOOLS_COLLATORWRAPPER_HXX 
#include <unotools/collatorwrapper.hxx>
#endif
namespace binfilter {

// ===================================================================================================
// Hilfsstrukturen


// ===================================================================================================
// = class FmSearchThread - wie der Name schon sagt
// ===================================================================================================


// ===================================================================================================
// = struct FmSearchProgress - diese Struktur bekommt der Owner der SearchEngine fuer Status-Updates
// = (und am Ende der Suche)
// ===================================================================================================

struct FmSearchProgress
{
	enum STATE { STATE_PROGRESS, STATE_PROGRESS_COUNTING, STATE_CANCELED, STATE_SUCCESSFULL, STATE_NOTHINGFOUND, STATE_ERROR };
		// (Bewegung auf neuen Datensatz; Fortschritt beim Zaehlen von Datensaetzen; abgebrochen; Datensatz gefunden;
		// nichts gefunden, irgendein nicht zu handelnder Fehler)
	STATE	aSearchState;

	// aktueller Datensatz - immer gueltig (ist zum Beispiel bei Abbrechen auch fuer das Weitersuchen interesant)
	sal_uInt32	nCurrentRecord;
	// Ueberlauf - nur gueltig bei STATE_PROGRESS
	sal_Bool	bOverflow;

	// die Position des Such-Cursors - bei STATE_SUCCESSFULL, STATE_CANCELED und STATE_NOTHING_FOUND gueltig
	::com::sun::star::uno::Any	aBookmark;
	// das Feld, in dem der Text gefunden wurde - bei STATE_SUCCESSFULL gueltig
	sal_Int32	nFieldIndex;
};

// ===================================================================================================
// = class FmRecordCountListener - Hilfsklasse fuer FmSearchEngine, lauscht an einem Cursor und teilt
// =								Aenderungem im RecordCount mit
// ===================================================================================================


// ===================================================================================================
// = class FmSearchEngine - Impl-Klasse fuer FmSearchDialog
// ===================================================================================================

namespace svxform {
	// We have three possible control types we may search in, determined by the supported interfaces : ::com::sun::star::awt::XTextComponent, ::com::sun::star::awt::XListBox, ::com::sun::star::awt::XCheckBox.
	// While searching we don't want to do this distinction for every control in every round. So we need some helpers.
	class ControlTextWrapper
	{
		// attributes
		::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface > 	m_xControl;
		// attribute access
	public:
		::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >  getControl() const{ return m_xControl; }
	public:
		ControlTextWrapper(const ::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >& _xControl) { m_xControl = _xControl; }
		virtual ~ControlTextWrapper() { }

		virtual ::rtl::OUString getCurrentText() const = 0;
	};
}


}//end of namespace binfilter
#endif // _FMSRCIMP_HXX

