/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_insctrl.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 21:33:04 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef _SHL_HXX
#include <tools/shl.hxx>
#endif
#ifndef _STATUS_HXX //autogen
#include <vcl/status.hxx>
#endif
#ifndef _SFXENUMITEM_HXX
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
#pragma hdrstop

#define _SVX_INSCTRL_CXX

#include "dialogs.hrc"

#include "insctrl.hxx"
#include "dialmgr.hxx"
namespace binfilter {

#define PAINT_OFFSET	5

/*N*/ SFX_IMPL_STATUSBAR_CONTROL(SvxInsertStatusBarControl, SfxBoolItem);

// class SvxInsertStatusBarControl ---------------------------------------

/*N*/ SvxInsertStatusBarControl::SvxInsertStatusBarControl( USHORT nId,
/*N*/ 													  StatusBar& rStb,
/*N*/ 													  SfxBindings& rBind ) :
/*N*/ 
/*N*/ 	SfxStatusBarControl( nId, rStb, rBind ),
/*N*/ 
/*N*/ 	bInsert( TRUE )
/*N*/ {
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ SvxInsertStatusBarControl::~SvxInsertStatusBarControl()
/*N*/ {
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ void SvxInsertStatusBarControl::StateChanged( USHORT nSID, SfxItemState eState,
/*N*/ 											  const SfxPoolItem* pState )
/*N*/ {
/*N*/ 	if ( SFX_ITEM_AVAILABLE != eState )
/*N*/ 		GetStatusBar().SetItemText( GetId(), String() );
/*N*/ 	else
/*N*/ 	{
/*N*/ 		DBG_ASSERT( pState->ISA( SfxBoolItem ), "invalid item type" );
/*N*/ 		SfxBoolItem* pItem = (SfxBoolItem*)pState;
/*N*/ 		bInsert = pItem->GetValue();
/*N*/ 		DrawItemText_Impl();
/*N*/ 	}
/*N*/ }

// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------

/*N*/ void SvxInsertStatusBarControl::DrawItemText_Impl()
/*N*/ {
/*N*/ 	USHORT nId = RID_SVXSTR_OVERWRITE_TEXT;
/*N*/ 
/*N*/ 	if ( bInsert )
/*N*/ 		nId = RID_SVXSTR_INSERT_TEXT;
/*N*/ 	GetStatusBar().SetItemText( GetId(), SVX_RESSTR( nId ) );
/*N*/ }

/*N*/ ULONG SvxInsertStatusBarControl::GetDefItemWidth(const StatusBar& rStb)
/*N*/ {
/*N*/ 	long nWidth1 =  rStb.GetTextWidth(SVX_RESSTR(RID_SVXSTR_OVERWRITE_TEXT));
/*N*/ 	long nWidth2 =  rStb.GetTextWidth(SVX_RESSTR(RID_SVXSTR_INSERT_TEXT));
/*N*/ 
/*N*/ 	if(nWidth1<nWidth2)
/*N*/ 		nWidth1=nWidth2;
/*N*/ 
/*N*/ 	return nWidth1+PAINT_OFFSET;
/*N*/ }


}
