/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fillctrl.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/28 03:32:02 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _FILLCTRL_HXX
#define _FILLCTRL_HXX

#ifndef _SFXLSTNER_HXX //autogen
#include <svtools/lstner.hxx>
#endif
#ifndef _SFXTBXCTRL_HXX //autogen
#include <bf_sfx2/tbxctrl.hxx>
#endif
class ListBox;
namespace binfilter {
class XFillStyleItem;
class XFillColorItem;
class XFillGradientItem;
class XFillHatchItem;
class XFillBitmapItem;
class FillControl;
class SvxFillTypeBox;
class SvxFillAttrBox;

/*************************************************************************
|*
|* Klassen fuer Flaechenattribute (Controls und Controller)
|*
\************************************************************************/

class SvxFillToolBoxControl: public SfxToolBoxControl, public SfxListener
{
private:
	XFillStyleItem*		pStyleItem;
	XFillColorItem*		pColorItem;
	XFillGradientItem*	pGradientItem;
	XFillHatchItem*		pHatchItem;
	XFillBitmapItem*	pBitmapItem;

	SfxStatusForwarder	aColorForwarder;
	SfxStatusForwarder	aGradientForwarder;
	SfxStatusForwarder	aHatchForwarder;
	SfxStatusForwarder	aBitmapForwarder;

	FillControl*		pFillControl;
	SvxFillTypeBox*		pFillTypeLB;
	SvxFillAttrBox*		pFillAttrLB;

	BOOL				bUpdate;
	USHORT				eLastXFS;

public:
	SFX_DECL_TOOLBOX_CONTROL();

	SvxFillToolBoxControl( USHORT nId, ToolBox& rTbx, SfxBindings& rBind );
};

//========================================================================


}//end of namespace binfilter
#endif		// _FILLCTRL_HXX

