/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;

public class NodeMemberEvent
extends NodeEvent {
    private boolean add;
    private Node[] delta;
    private Node[] from;
    private int[] indices;
    static final long serialVersionUID = -3973509253579305102L;

    NodeMemberEvent(Node node, boolean bl, Node[] nodeArray, Node[] nodeArray2) {
        super(node);
        this.add = bl;
        this.delta = nodeArray;
        this.from = nodeArray2;
    }

    public final boolean isAddEvent() {
        return this.add;
    }

    public final Node[] getDelta() {
        return this.delta;
    }

    public synchronized int[] getDeltaIndices() {
        if (this.indices != null) {
            return this.indices;
        }
        if (this.from == null) {
            this.from = this.getNode().getChildren().getNodes();
        }
        List<Node> list = Arrays.asList(this.delta);
        HashSet<Node> hashSet = new HashSet<Node>(list);
        this.indices = new int[this.delta.length];
        int n = 0;
        int n2 = 0;
        while (n2 < this.from.length && n < this.indices.length) {
            if (hashSet.contains(this.from[n2])) {
                this.indices[n++] = n2;
            }
            ++n2;
        }
        if (n != this.delta.length) {
            StringBuffer stringBuffer = new StringBuffer(1000);
            stringBuffer.append("Some of a set of deleted nodes are not present in the original ones.\n");
            stringBuffer.append("See #15478; you may need to check that your Children.Keys keys are safely comparable.");
            stringBuffer.append("\ni: " + n2);
            stringBuffer.append("\nj: " + n);
            stringBuffer.append("\nThis: " + this);
            stringBuffer.append("\nCurrent state:\n");
            stringBuffer.append(Arrays.asList(this.from));
            stringBuffer.append("\nDelta:\n");
            stringBuffer.append(list);
            throw new IllegalStateException(stringBuffer.toString());
        }
        return this.indices;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("[node=");
        stringBuffer.append(this.getSource());
        stringBuffer.append(", add=");
        stringBuffer.append(this.isAddEvent());
        Node[] nodeArray = this.getDelta();
        int[] nArray = this.getDeltaIndices();
        int n = 0;
        while (n < nodeArray.length) {
            stringBuffer.append("\n  ");
            stringBuffer.append(n);
            stringBuffer.append(" at ");
            stringBuffer.append(nArray[n]);
            stringBuffer.append(" = ");
            stringBuffer.append(nodeArray[n]);
            ++n;
        }
        stringBuffer.append("\n]");
        return stringBuffer.toString();
    }
}

