/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.ImageIcon;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

class IconManager
implements Runnable {
    private static final Object NO_ICON = new Object();
    private static final HashMap map = new HashMap();
    private static final HashMap reverseMap = new HashMap();
    private static final Set extraInitialSlashes = new HashSet(200);
    private static final ReferenceQueue compositeQueue = new ReferenceQueue();
    private static RequestProcessor.Task cleaningTask;
    private static final int CACHE_CLEAN_INTERVAL = 10000;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$openide$util$IconManager;

    IconManager() {
    }

    static Image getIcon(String string) {
        Object object = map.get(string);
        if (object == NO_ICON) {
            return null;
        }
        if (object != null) {
            object = ((Reference)object).get();
        }
        if (object != null) {
            return (Image)object;
        }
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = IconManager.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
        return IconManager.getIcon(string, classLoader);
    }

    private static void startCleaner() {
        if (cleaningTask != null) {
            return;
        }
        cleaningTask = RequestProcessor.getDefault().post(new IconManager(), 10000, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Image getIcon(String string, ClassLoader classLoader) {
        Object object = map.get(string);
        if (object == NO_ICON) {
            return null;
        }
        if (object != null) {
            object = ((Reference)object).get();
        }
        if (object != null) {
            return (Image)object;
        }
        IconManager.cleanUpMap();
        HashMap hashMap = map;
        synchronized (hashMap) {
            block13: {
                String string2;
                boolean bl;
                block12: {
                    object = map.get(string);
                    if (object != null) {
                        object = ((Reference)object).get();
                    }
                    if (object == null) break block12;
                    Image image = (Image)object;
                    return image;
                }
                if (string.startsWith("/")) {
                    bl = true;
                    string2 = string.substring(1);
                } else {
                    bl = false;
                    string2 = string;
                }
                URL uRL = classLoader != null ? classLoader.getResource(string2) : (class$org$openide$util$IconManager == null ? (class$org$openide$util$IconManager = IconManager.class$("org.openide.util.IconManager")) : class$org$openide$util$IconManager).getClassLoader().getResource(string2);
                Image image = object = uRL == null ? null : Toolkit.getDefaultToolkit().createImage(uRL);
                if (object == null) break block13;
                if (bl && extraInitialSlashes.add(string)) {
                    ErrorManager.getDefault().log(16, "Initial slashes in Utilities.loadImage deprecated (cf. #20072): " + string);
                }
                Image image2 = IconManager.toBufferedImage((Image)object);
                SoftReference<Image> softReference = new SoftReference<Image>(image2);
                map.put(string, softReference);
                IconManager.startCleaner();
                Image image3 = image2;
                return image3;
            }
            map.put(string, NO_ICON);
            Image image = null;
            return image;
        }
    }

    public void run() {
        IconManager.cleanUpMap();
        cleaningTask.schedule(10000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanUpMap() {
        Reference reference;
        while ((reference = compositeQueue.poll()) != null) {
            Object v;
            HashMap hashMap = reverseMap;
            synchronized (hashMap) {
                v = reverseMap.remove(reference);
            }
            HashMap hashMap2 = map;
            synchronized (hashMap2) {
                map.remove(v);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final Image mergeImages(Image image, Image image2, int n, int n2) {
        CompositeImageKey compositeImageKey = new CompositeImageKey(image, image2, n, n2);
        IconManager.cleanUpMap();
        HashMap hashMap = map;
        synchronized (hashMap) {
            Image image3;
            SoftReference<Image> softReference;
            block4: {
                softReference = (SoftReference<Image>)map.get(compositeImageKey);
                if (softReference == null || (image3 = (Image)((Reference)softReference).get()) == null) break block4;
                Image image4 = image3;
                return image4;
            }
            image3 = IconManager.doMergeImages(image, image2, n, n2);
            softReference = new SoftReference<Image>(image3, compositeQueue);
            map.put(compositeImageKey, softReference);
            reverseMap.put(softReference, compositeImageKey);
            Image image5 = image3;
            return image5;
        }
    }

    static final Image toBufferedImage(Image image) {
        new ImageIcon(image);
        BufferedImage bufferedImage = IconManager.createBufferedImage(image.getWidth(null), image.getHeight(null));
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        image.flush();
        return bufferedImage;
    }

    private static final Image doMergeImages(Image image, Image image2, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        if (image != null) {
            n3 = image.getWidth(null);
            n4 = image.getHeight(null);
        }
        if (image2 != null) {
            n3 = image2.getWidth(null) + n > n3 ? image2.getWidth(null) + n : n3;
            int n5 = n4 = image2.getHeight(null) + n2 > n4 ? image2.getHeight(null) + n2 : n4;
        }
        if (n3 < 1) {
            n3 = 16;
        }
        if (n4 < 1) {
            n4 = 16;
        }
        ColorModel colorModel = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel(2);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(n3, n4), colorModel.isAlphaPremultiplied(), null);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (image != null) {
            graphics2D.drawImage(image, 0, 0, null);
        }
        if (image2 != null) {
            graphics2D.drawImage(image2, n, n2, null);
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    private static final BufferedImage createBufferedImage(int n, int n2) {
        ColorModel colorModel = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel(2);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(n, n2), colorModel.isAlphaPremultiplied(), null);
        return bufferedImage;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class CompositeImageKey {
        Image baseImage;
        Image overlayImage;
        int x;
        int y;

        CompositeImageKey(Image image, Image image2, int n, int n2) {
            this.x = n;
            this.y = n2;
            this.baseImage = image;
            this.overlayImage = image2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof CompositeImageKey)) {
                return false;
            }
            CompositeImageKey compositeImageKey = (CompositeImageKey)object;
            return this.x == compositeImageKey.x && this.y == compositeImageKey.y && this.baseImage == compositeImageKey.baseImage && this.overlayImage == compositeImageKey.overlayImage;
        }

        public int hashCode() {
            int n = (this.x << 3 ^ this.y) << 4;
            n = n ^ this.baseImage.hashCode() ^ this.overlayImage.hashCode();
            return n;
        }

        public String toString() {
            return "Composite key for " + this.baseImage + " + " + this.overlayImage + " at [" + this.x + ", " + this.y + "]";
        }
    }
}

