/*************************************************************************
 *
 *  $RCSfile: sbdef.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2000/12/07 14:26:49 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SB_SBDEF_HXX
#define _SB_SBDEF_HXX


#ifndef _SVARRAY_HXX
#include <svtools/svarray.hxx>
#endif

#if _SOLAR__PRIVATE
#define _BASIC_TEXTPORTIONS
#endif

enum SbTextType {					// Typ eines Textteils (Syntax Hilite)
	SB_KEYWORD = 1,					// Keywords
	SB_SYMBOL,						// Symbole
	SB_STRING,						// Strings
	SB_NUMBER,						// Zahlen
	SB_PUNCTUATION,					// Klammern, Punkte etc
	SB_COMMENT						// Kommentare
};

enum SbLanguageMode {				// Aktive Sprache
	SB_LANG_GLOBAL,					// wie in SbiGlobals-Struktur
	SB_LANG_BASIC,					// StarBasic (Default)
	SB_LANG_VBSCRIPT,				// Visual-Basic-Script
	SB_LANG_JAVASCRIPT				// Java-Script
};

#ifdef _BASIC_TEXTPORTIONS
struct SbTextPortion
{									// Syntax Hiliting: eine Text-Portion
	xub_StrLen nLine;					// Zeilennummer
	xub_StrLen nStart, nEnd;			// 1. und letzte Spalte
	SbTextType eType;				// Type der Portion
};

SV_DECL_VARARR(SbTextPortions, SbTextPortion,16,16)
#else
class SbTextPortions;
#endif


// Debug-Flags:

#define SbDEBUG_BREAK       0x0001          // Break-Callback
#define SbDEBUG_STEPINTO    0x0002          // Single Step-Callback
#define SbDEBUG_STEPOVER    0x0004          // Zusatzflag Step Over
#define	SbDEBUG_CONTINUE	0x0008			// Flags nicht aendern
#define SbDEBUG_STEPOUT		0x0010          // Aus Sub raus

#define SBXID_BASIC			0x6273			// sb: StarBASIC
#define	SBXID_BASICMOD		0x6d62			// bm: StarBASIC-Modul
#define SBXID_BASICPROP		0x7262			// pr: StarBASIC-Property
#define	SBXID_BASICMETHOD	0x6d65          // me: StarBASIC-Methode
#define	SBXID_JSCRIPTMOD	0x6a62			// jm: JavaScript-Modul
#define	SBXID_JSCRIPTMETH	0x6a64			// jm: JavaScript-Modul


#define SBX_HINT_BASICSTART		SFX_HINT_USER04
#define SBX_HINT_BASICSTOP		SFX_HINT_USER05

#endif
