/*************************************************************************
 *
 *  $RCSfile: GetLongPathName.c,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/15 17:46:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <windows.h>
#include <systools/win32/StrConvert.h>
#include <string.h>

#if OSL_DEBUG_LEVEL == 0
#define NDEBUG
#endif
#include <assert.h>

//-----------------------------------------------------------------------
// defines
//-----------------------------------------------------------------------

#define DLL_EXPORT extern

//-----------------------------------------------------------------------
// externals
//-----------------------------------------------------------------------

/*
extern DWORD ( WINAPI * lpfnGetLongPathNameA_98 ) (
  LPCSTR lpszShortPath,  // file name
  LPSTR lpszLongPath,    // path buffer
  DWORD cchBuffer        // size of path buffer
);
*/

typedef DWORD ( WINAPI * GetLongPathNameA_Proc_T ) (
  LPCSTR lpszShortPath, // file name
  LPSTR lpszLongPath,   // path buffer
  DWORD cchBuffer        // size of path buffer
);
GetLongPathNameA_Proc_T lpfnGetLongPathNameA_98 = 0;

//-----------------------------------------------------------------------
// GetCanonicalPath
//-----------------------------------------------------------------------

DLL_EXPORT DWORD WINAPI GetLongPathNameW_9x(
	LPCWSTR lpszShortPath,	// file name
	LPWSTR  lpszLongPath,	// path buffer
	DWORD   cchBuffer		// size of path buffer
)
{
	DWORD dwRet;
	DWORD dwLastError;
	int   nWCharWritten;
	LPSTR lpszShortPathA = NULL;
	LPSTR lpszLongPathA  = NULL;

	assert( wcslen( lpszShortPath ) <= MAX_PATH );

    // there is a GetLongPathName function under Win98 but only
	// a non-unicode version
	lpfnGetLongPathNameA_98 = ( GetLongPathNameA_Proc_T )GetProcAddress(
	    GetModuleHandleA( "kernel32.dll" ), "GetLongPathNameA" );

	if ( 0 != lpfnGetLongPathNameA_98 )
	{
		AllocNecessarySpaceAndCopyWStr2Str( lpszShortPath, &lpszShortPathA );

		assert( cchBuffer < 0x7FFF8 ); // see MSDN
		lpszLongPathA = (LPSTR)HeapAlloc( GetProcessHeap( ),
									      0,
									      cchBuffer * sizeof( char ) );

		dwRet = lpfnGetLongPathNameA_98( lpszShortPathA, lpszLongPathA, cchBuffer );
		dwLastError = GetLastError( );

		// copy back into wchar-buffer
		nWCharWritten = MultiByteToWideChar( CP_ACP,
											 0,
											 lpszLongPathA,
											 -1,
											 lpszLongPath,
											 cchBuffer );
		assert( dwRet == ( nWCharWritten - 1 ) );

		// garbage collection
		FreeSpaceStr( (LPSTR)lpszShortPathA );
		HeapFree( GetProcessHeap( ), 0, (LPVOID)lpszLongPathA );

		SetLastError( dwLastError );
	}
	else // Win95/WinNT
	{
		// under Win95 and WinNT 4 just return the given path
		// must be fixed later
		CopyMemory( lpszLongPath,
			        lpszShortPath,
					cchBuffer * sizeof( wchar_t ) );

		dwRet = cchBuffer;
	}

	return dwRet;
}
