/*************************************************************************
 *
 *	$RCSfile: tustring.cxx,v $
 *
 *	$Revision: 1.2 $
 *
 *	last change: $Author: th $ $Date: 2001/03/16 15:25:57 $
 *
 *	The Contents of this file are made available subject to the terms of
 *	either of the following licenses
 *
 *		   - GNU Lesser General Public License Version 2.1
 *		   - Sun Industry Standards Source License Version 1.1
 *
 *	Sun Microsystems Inc., October, 2000
 *
 *	GNU Lesser General Public License Version 2.1
 *	=============================================
 *	Copyright 2000 by Sun Microsystems, Inc.
 *	901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License version 2.1, as published by the Free Software Foundation.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *	MA	02111-1307	USA
 *
 *
 *	Sun Industry Standards Source License Version 1.1
 *	=================================================
 *	The contents of this file are subject to the Sun Industry Standards
 *	Source License Version 1.1 (the "License"); You may not use this file
 *	except in compliance with the License. You may obtain a copy of the
 *	License at http://www.openoffice.org/license.html.
 *
 *	Software provided under this License is provided on an "AS IS" basis,
 *	WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *	WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *	MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *	See the License for the specific provisions governing your rights and
 *	obligations concerning the Software.
 *
 *	The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *	Copyright: 2000 by Sun Microsystems, Inc.
 *
 *	All Rights Reserved.
 *
 *	Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <string.h>

#ifndef _OSL_INTERLCK_H
#include <osl/interlck.h>
#endif
#ifndef _RTL_ALLOC_H
#include <rtl/alloc.h>
#endif
#ifndef _RTL_MEMORY_H
#include <rtl/memory.h>
#endif
#ifndef _RTL_TENCINFO_H
#include <rtl/tencinfo.h>
#endif

#define private public
#include <string.hxx>
#undef private
#include <impstrg.hxx>

#include <debug.hxx>

// =======================================================================

DBG_NAME( UniString );
DBG_NAMEEX( ByteString );

// -----------------------------------------------------------------------

#define STRCODE 		sal_Unicode
#define STRING			UniString
#define STRINGDATA		UniStringData
#define DBGCHECKSTRING	DbgCheckUniString

// -----------------------------------------------------------------------

#include <strimp.cxx>
#include <strucvt.cxx>
#include <strascii.cxx>

// -----------------------------------------------------------------------

UniString UniString::CreateFromInt32( sal_Int32 n, sal_Int16 nRadix )
{
	sal_Unicode aBuf[RTL_USTR_MAX_VALUEOFINT32];
	return UniString( aBuf, rtl_ustr_valueOfInt32( aBuf, n, nRadix ) );
}

// -----------------------------------------------------------------------

UniString UniString::CreateFromInt64( sal_Int64 n, sal_Int16 nRadix )
{
	sal_Unicode aBuf[RTL_USTR_MAX_VALUEOFINT64];
	return UniString( aBuf, rtl_ustr_valueOfInt64( aBuf, n, nRadix ) );
}

// -----------------------------------------------------------------------

UniString UniString::CreateFromFloat( float f )
{
	sal_Unicode aBuf[RTL_USTR_MAX_VALUEOFFLOAT];
	return UniString( aBuf, rtl_ustr_valueOfFloat( aBuf, f ) );
}

// -----------------------------------------------------------------------

UniString UniString::CreateFromDouble( double d )
{
	sal_Unicode aBuf[RTL_USTR_MAX_VALUEOFDOUBLE];
	return UniString( aBuf, rtl_ustr_valueOfDouble( aBuf, d ) );
}

// -----------------------------------------------------------------------

sal_Int32 UniString::ToInt32() const
{
	DBG_CHKTHIS( UniString, DbgCheckUniString );

	return rtl_ustr_toInt32( mpData->maStr, 10 );
}

// -----------------------------------------------------------------------

sal_Int64 UniString::ToInt64() const
{
	DBG_CHKTHIS( UniString, DbgCheckUniString );

	return rtl_ustr_toInt64( mpData->maStr, 10 );
}

// -----------------------------------------------------------------------

float UniString::ToFloat() const
{
	DBG_CHKTHIS( UniString, DbgCheckUniString );

	return rtl_ustr_toFloat( mpData->maStr );
}

// -----------------------------------------------------------------------

double UniString::ToDouble() const
{
	DBG_CHKTHIS( UniString, DbgCheckUniString );

	return rtl_ustr_toDouble( mpData->maStr );
}

