/*************************************************************************
 *
 *  $RCSfile: impbmp.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2000/12/07 13:37:15 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_IMPBMP_HXX
#define _SV_IMPBMP_HXX

#ifndef _GEN_HXX
#include <tools/gen.hxx>
#endif

#ifndef _SV_SV_H
#include <sv.h>
#endif

// ---------------
// - ImpBitmap -
// ---------------

struct BitmapBuffer;
class SalBitmap;
class BitmapPalette;
class SalGraphics;
class ImplServerBitmap; 
class Bitmap;
class RMBitmap;
class OutputDevice;
class Color;
class AlphaMask;

class ImpBitmap
{
private:

    ULONG				mnRefCount;
	ULONG				mnChecksum;
	RMBitmap*			mpRMBitmap;
#ifndef REMOTE_APPSERVER
    SalBitmap*			mpSalBitmap;
#else
    ImplServerBitmap*   mpSalBitmap;
#endif

public:

						ImpBitmap();
						~ImpBitmap();

#if _SOLAR__PRIVATE

public:

#ifndef REMOTE_APPSERVER
	void				ImplSetSalBitmap( SalBitmap* pSalBitmap );
    SalBitmap*			ImplGetSalBitmap() const { return mpSalBitmap; }
#else
    void            	ImplSetSalBitmap( ImplServerBitmap* pSalBitmap );
    ImplServerBitmap*	ImplGetSalBitmap() const { return mpSalBitmap; }

	RMBitmap*			ImplGetRemoteBmp();

	void				ImplCreateRemoteBmp( const Bitmap& rBitmap );
	void				ImplCreateRemoteBmp( const Bitmap& rBitmap, 
											 OutputDevice* pOut,
											 const Point& rPt, const Size& rSz );
	
	void				ImplReleaseRemoteBmp();

	void				ImplDrawRemoteBmp( OutputDevice* pOut,
								const Point& rSrcPt, const Size& rSrcSz,
								const Point& rDestPt, const Size& rDestSz );
	void				ImplDrawRemoteBmpEx( OutputDevice* pOut,
								const Point& rSrcPt, const Size& rSrcSz,
								const Point& rDestPt, const Size& rDestSz,
								const Bitmap& rMask );
	void				ImplDrawRemoteBmpAlpha( OutputDevice* pOut,
								const Point& rSrcPt, const Size& rSrcSz,
								const Point& rDestPt, const Size& rDestSz,
								const AlphaMask& rAlpha );
	void				ImplDrawRemoteBmpMask( OutputDevice* pOut,
								const Point& rSrcPt, const Size& rSrcSz,
								const Point& rDestPt, const Size& rDestSz,
								const Color& rColor );

	BOOL				ImplIsGetPrepared() const;
	void				ImplResolveGet();
#endif

public:

    BOOL				ImplCreate( const Size& rSize, USHORT nBitCount, const BitmapPalette& rPal );
    BOOL				ImplCreate( const ImpBitmap& rImpBitmap );
    BOOL				ImplCreate( const ImpBitmap& rImpBitmap, SalGraphics* pGraphics );
    BOOL				ImplCreate( const ImpBitmap& rImpBitmap, USHORT nNewBitCount );
						
    void				ImplDestroy();
						
    Size				ImplGetSize() const;
    USHORT				ImplGetBitCount() const;
						
    BitmapBuffer*		ImplAcquireBuffer( BOOL bReadOnly );
    void				ImplReleaseBuffer( BitmapBuffer* pBuffer, BOOL bReadOnly );
						
public:					

    ULONG				ImplGetRefCount() const { return mnRefCount; }
    void				ImplIncRefCount() { mnRefCount++; }
    void				ImplDecRefCount() { mnRefCount--; }

	inline void			ImplSetChecksum( ULONG nChecksum ) { mnChecksum = nChecksum; }
	inline ULONG		ImplGetChecksum() const { return mnChecksum; }

#endif // PRIVATE
};

#endif // _SV_IMPBMP_HXX
