/*************************************************************************
 *
 *  $RCSfile: MyFont.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:05:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/



#include <svmac.h>



#define _SV_SALGDI_CXX



#ifndef _SV_SALDATA_HXX

#include <saldata.hxx>

#endif

#ifndef _SV_SALGDI_HXX

#include <salgdi.hxx>

#endif



#ifndef _SV_OUTFONT_HXX

#include <outfont.hxx>

#endif



#ifndef _MYFONT_HXX

#include <myfont.hxx>

#endif



// =======================================================================



static short pSymbolFnt[] = {symbol, 0};

static short pDecoFnt[] = {london, 0};

static short pModernFnt[] = {monaco, courier, 0};

static short pRomanFnt[] = {times, newYork, 0};

static short pScriptFnt[] = {venice, 0};

static short pSwissFnt[] = {geneva, helvetica, 0};

static short pFixedFnt[] = {monaco, courier, 0};



static short *pFontArray[] = {

						pSymbolFnt,

						pDecoFnt,

						pModernFnt,

						pRomanFnt,

						pScriptFnt,

						pSwissFnt,

						pFixedFnt,

						0L

					 };



enum eFontID {	SYMBOL_FNT, DECO_FNT, MODERN_FNT, ROMAN_FNT,

				SCRIPT_FNT, SWISS_FNT, FIXED_FNT };



static short FindFontID( const eFontID eFamily );



// =======================================================================



#define FONTNUMCACHESIZE 32



struct FontNumInfo

{

	XubString	maName;

	short		mnNum;

	FontNumInfo	*mpNext;

	FontNumInfo	*mpPrev;

};



class FontNumCache

{

	FontNumInfo		*mpStart;



	public:

					FontNumCache();

					~FontNumCache();

					

	BOOL			FindNum( XubString aName, FontNumInfo** pData );

	BOOL			FindName( short nNum, FontNumInfo** pData );

};



FontNumCache *pFontNumCache = NULL;



// -----------------------------------------------------------------------



FontNumCache::FontNumCache()

{

	mpStart = NULL;

}



// -----------------------------------------------------------------------



FontNumCache::~FontNumCache()

{

	FontNumInfo *pData = mpStart;

	

	while ( pData )

	{

		mpStart = pData->mpNext;

		delete pData;

		pData = mpStart;

	}

}



// -----------------------------------------------------------------------



BOOL FontNumCache::FindName( short nFontID, FontNumInfo** pReturn )

{

	FontNumInfo *pLast = NULL;

	FontNumInfo *pData = mpStart;

	int			nCount = 0;

	BOOL		bFound = TRUE;



	while ( pData && ( pData->mnNum != nFontID ) )

	{

		pLast = pData;

		pData = pData->mpNext;

		nCount++;

	}



	if ( !pData )

	{

		bFound = FALSE;

	

		if ( nCount == FONTNUMCACHESIZE )

		{

			pData = pLast;

			pLast = pLast->mpPrev;

			pLast->mpNext = NULL;

		}

		else

			pData = new FontNumInfo;

	

		if ( mpStart )

			mpStart->mpPrev = pData;



		pData->mpNext = mpStart;

		pData->mpPrev = NULL;

		mpStart = pData;

	}



	*pReturn = pData;

	return bFound;

}



// -----------------------------------------------------------------------



BOOL FontNumCache::FindNum( XubString aName, FontNumInfo** pReturn )

{

	FontNumInfo *pLast = NULL;

	FontNumInfo *pData = mpStart;

	int			nCount = 0;

	BOOL		bFound = TRUE;



	while ( pData && ( pData->maName != aName ) )

	{

		pLast = pData;

		pData = pData->mpNext;

		nCount++;

	}



	if ( !pData )

	{

		bFound = FALSE;

	

		if ( nCount == FONTNUMCACHESIZE )

		{

			pData = pLast;

			pLast = pLast->mpPrev;

			pLast->mpNext = NULL;

		}

		else

			pData = new FontNumInfo;

	

		if ( mpStart )

			mpStart->mpPrev = pData;



		pData->mpNext = mpStart;

		pData->mpPrev = NULL;

		mpStart = pData;

	}



	*pReturn = pData;

	return bFound;

}



// =======================================================================



/*************************************************************************

|*

|*    FindFontID()

|*

|*    Beschreibung

|*    Ersterstellung    DV 19.11.91

|*    Letzte Aenderung  DV 19.11.91

|*

*************************************************************************/

static short FindFontID( const eFontID eFamily )

{

	Str255	aFontName;

	short nID = pFontArray[ eFamily ][ 0 ];

	short i = 0;



	while ( nID ) {

		GetFontName( nID, aFontName );

		if ( aFontName[0] != 0 )

			return nID;

		nID = pFontArray[ eFamily ][ ++i ];

	}

	return 0;

}



/*************************************************************************

|*

|*    GetFamily()

|*

|*    Beschreibung

|*    Ersterstellung    DV 30.09.97

|*    Letzte Aenderung  DV 30.09.97

|*

*************************************************************************/

FontFamily ImplGetFamilyFromID( const short nFontID )

{

	short i, j, nID;



	if ( nFontID == 0 )

		return FAMILY_DONTKNOW;



	for (i=0, j=0; i < 6; i++)

	{

		nID = pFontArray[i][j++];



		while ( nID && ( nID != nFontID ) )

			nID = pFontArray[i][j++];



		if ( nID == nFontID )

			break;

	}



	switch ( i ) {

		case 0:

			return FAMILY_DONTKNOW;

		case 1:

			return FAMILY_DECORATIVE;

		case 2:

			return FAMILY_MODERN;

		case 3:

			return FAMILY_ROMAN;

		case 4:

			return FAMILY_SCRIPT;

		case 5:

			return FAMILY_SWISS;

		default:

			return FAMILY_DONTKNOW;

	}

}



/*************************************************************************

|*

|*	  SV_GetMacFontName()

|*

|*	  Beschreibung

|*

|*	  Ersterstellung	DV 27.07.95

|*	  Letzte Aenderung	DV 24.09.96

|*

*************************************************************************/

static String SV_GetMacFontName( const String &rFontName )

{

	String aRet;



	if ( COMPARE_EQUAL == rFontName.ICompare( "Times New Roman" ) )

		aRet = "Times";

	else if ( COMPARE_EQUAL == rFontName.ICompare( "Arial" ) )

		aRet = "Geneva";

	else if ( COMPARE_EQUAL == rFontName.ICompare( "Tms Rmn" ) )

		aRet = "Times";

	else if ( COMPARE_EQUAL == rFontName.ICompare( "Helv" ) )

		aRet = "Helvetica";

	else if ( COMPARE_EQUAL == rFontName.ICompare( "Courier New" ) )

		aRet = "Courier";

	else

		aRet = rFontName;



	return aRet;

}



/*************************************************************************

|*

|*    GetFontNum()

|*

|*    Beschreibung

|*    Ersterstellung    DV 23.07.91

|*    Letzte Aenderung  DV 05.11.97

|*

*************************************************************************/

short GetFontNum( ImplFontSelectData* pFont, ULONG &rStatus )

{

	XubString	aFontName;

	FontNumInfo *pData;

	BOOL		bIsSysFont = FALSE;

	short		nFontNum=0;



	rStatus = 0;



	// gibt es einen Font mit diesem Namen ?

	if ( pFont->mpFontData )

		aFontName = pFont->mpFontData->maName;

	else

		aFontName = pFont->maName;



	if ( ! aFontName.Len() )

	{

		rStatus = SAL_SETFONT_REMOVEANDMATCHNEW;

		return 0;

	}



	if ( !pFontNumCache )

		pFontNumCache = new FontNumCache();



	if ( pFontNumCache->FindNum( aFontName, &pData ) )

		return pData->mnNum;



	GetFNum( aFontName.GetPascalStr(), &nFontNum );



	if ( !nFontNum )

	{

		Str255 aSystemFont;

		GetFontName( 0, aSystemFont );

		aSystemFont[ aSystemFont[0]+1 ] = 0;

		if ( COMPARE_EQUAL == aFontName.ICompare( (char*) aSystemFont+1 ) )

			bIsSysFont = TRUE;

		else

		{

			aFontName = SV_GetMacFontName( aFontName );

			GetFNum( aFontName.GetPascalStr(), &nFontNum );

		}

	}



	if ( nFontNum || bIsSysFont )

	{

		pData->maName = aFontName;

		pData->mnNum = nFontNum;

		return nFontNum;

	}

	

	// gibt es einen Font mit dieser Family ?

	switch ( pFont->meFamily ) {

		case FAMILY_DECORATIVE:

				nFontNum = FindFontID( DECO_FNT );

				break;

		case FAMILY_MODERN:

				nFontNum = FindFontID( MODERN_FNT );

				break;

		case FAMILY_ROMAN:

				nFontNum = FindFontID( ROMAN_FNT );

				break;

		case FAMILY_SCRIPT:

				nFontNum = FindFontID( SCRIPT_FNT );

				break;

		case FAMILY_SWISS:

				nFontNum = FindFontID( SWISS_FNT );

				break;

		default:

				break;

	}



	// ist der Font nicht proportional ?

	if ( !nFontNum && ( pFont->mePitch == PITCH_FIXED ) )

		nFontNum = FindFontID( FIXED_FNT );



	pData->maName = aFontName;

	pData->mnNum = nFontNum;



	if ( !nFontNum )

		rStatus = SAL_SETFONT_REMOVEANDMATCHNEW;



	return nFontNum;

}



/*************************************************************************

|*

|*    SV_GetFontName()

|*

|*    Beschreibung

|*    Ersterstellung    DV 30.09.97

|*    Letzte Aenderung  DV 30.09.97

|*

*************************************************************************/

XubString ImplGetFontName( short nFontID )

{

	Str255		aFontName;

	FontNumInfo *pData;



	if ( !pFontNumCache )

		pFontNumCache = new FontNumCache();



	if ( ! pFontNumCache->FindName( nFontID, &pData ) )

	{

		GetFontName( nFontID, aFontName );

		pData->maName = String( (char*)&aFontName[1], aFontName[0] );

		pData->mnNum = nFontID;

	}



	return pData->maName;

}

