/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.event.EventListenerList;
import org.openide.filesystems.AbstractFileObject;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.enum.ArrayEnumeration;
import org.openide.util.enum.EmptyEnumeration;
import org.openide.util.enum.FilterEnumeration;
import org.openide.util.enum.QueueEnumeration;

abstract class AbstractFolder
extends FileObject {
    private static final AbstractFolder[] EMPTY_ARRAY = new AbstractFolder[0];
    private static final char EXT_SEP = '.';
    private static final HashMap EMPTY = new HashMap(0);
    private FileSystem system;
    protected String name;
    protected final AbstractFolder parent;
    boolean validFlag;
    private AbstractFolder validRoot = null;
    private String[] children;
    private HashMap map;
    private EventListenerList listeners;
    static /* synthetic */ Class class$org$openide$filesystems$FileChangeListener;

    public AbstractFolder(FileSystem fileSystem, AbstractFolder abstractFolder, String string) {
        this.system = fileSystem;
        this.parent = abstractFolder;
        this.name = string;
        this.validFlag = true;
        if (abstractFolder != null) {
            this.validRoot = (AbstractFolder)fileSystem.getRoot();
        }
    }

    public final String getName() {
        int n = this.name.lastIndexOf(46);
        return n <= 0 ? this.name : this.name.substring(0, n);
    }

    public final String getExt() {
        int n = this.name.lastIndexOf(46) + 1;
        return n <= 1 || n == this.name.length() ? "" : this.name.substring(n);
    }

    public final String getNameExt() {
        return this.name;
    }

    final boolean isHasExtOverride() {
        return true;
    }

    boolean hasExtOverride(String string) {
        if (string == null) {
            return false;
        }
        if (this.name.length() - string.length() <= 1) {
            return false;
        }
        boolean bl = this.name.endsWith(string);
        if (!bl) {
            return false;
        }
        return this.name.charAt(this.name.length() - string.length() - 1) == '.';
    }

    public final String getPackageNameExt(char c, char c2) {
        String[] stringArray;
        String[] stringArray2 = new String[11];
        int n = 0;
        AbstractFolder abstractFolder = this.parent;
        while (abstractFolder != null && abstractFolder.parent != null) {
            if (n >= stringArray2.length) {
                stringArray = new String[stringArray2.length * 2 + 1];
                System.arraycopy(stringArray2, 0, stringArray, 0, n);
                stringArray2 = stringArray;
            }
            stringArray2[n++] = abstractFolder.name;
            abstractFolder = abstractFolder.parent;
        }
        stringArray = new StringBuffer(150);
        if ('.' == c2) {
            int n2 = n - 1;
            while (n2 >= 0) {
                stringArray.append(stringArray2[n2]);
                stringArray.append(c);
                --n2;
            }
            stringArray.append(this.name);
        } else {
            int n3 = n - 1;
            while (n3 >= 0) {
                stringArray.append(stringArray2[n3].replace('.', c2));
                stringArray.append(c);
                --n3;
            }
            stringArray.append(this.name.replace('.', c2));
        }
        return stringArray.toString();
    }

    public final FileSystem getFileSystem() {
        return this.system;
    }

    public final boolean isRoot() {
        return this.parent == null;
    }

    public final boolean isValid() {
        if (this.parent == null) {
            return true;
        }
        boolean bl = this.getFileSystem().getRoot() == this.validRoot;
        return this.validFlag && bl;
    }

    public final FileObject getParent() {
        return this.parent;
    }

    public final synchronized FileObject[] getChildren() {
        this.check();
        if (this.children == null) {
            return new FileObject[0];
        }
        int n = this.children.length;
        FileObject[] fileObjectArray = new FileObject[n];
        int n2 = 0;
        while (n2 < n) {
            fileObjectArray[n2] = this.getChild(this.children[n2]);
            ++n2;
        }
        return fileObjectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final FileObject find(Enumeration enumeration) {
        AbstractFolder abstractFolder;
        for (abstractFolder = this; abstractFolder != null && enumeration.hasMoreElements(); abstractFolder = abstractFolder.getChild((String)enumeration.nextElement())) {
            AbstractFolder abstractFolder2 = abstractFolder;
            synchronized (abstractFolder2) {
                abstractFolder.check();
                continue;
            }
        }
        return abstractFolder;
    }

    final FileObject findIfExists(Enumeration enumeration) {
        Reference reference = this.findRefIfExists(enumeration);
        return reference == null ? null : (FileObject)reference.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Reference findRefIfExists(Enumeration enumeration) {
        String string;
        for (AbstractFolder abstractFolder = this; abstractFolder != null && enumeration.hasMoreElements(); abstractFolder = abstractFolder.getChild(string)) {
            if (abstractFolder.map == null) {
                return null;
            }
            AbstractFolder abstractFolder2 = abstractFolder;
            synchronized (abstractFolder2) {
                block7: {
                    string = (String)enumeration.nextElement();
                    if (enumeration.hasMoreElements()) {
                        break block7;
                    }
                    Reference reference = (Reference)abstractFolder.map.get(string);
                    return reference;
                }
                continue;
            }
        }
        return null;
    }

    protected final AbstractFolder getChild(String string) {
        Reference reference = (Reference)this.map.get(string);
        if (reference == null) {
            return null;
        }
        AbstractFolder abstractFolder = (AbstractFolder)reference.get();
        if (abstractFolder == null) {
            abstractFolder = this.createFile(string);
            this.map.put(string, this.createReference(abstractFolder));
        }
        return abstractFolder;
    }

    final String[] getChildrenArray() {
        return this.children;
    }

    protected Reference createReference(FileObject fileObject) {
        return new WeakReference<FileObject>(fileObject);
    }

    final synchronized AbstractFolder[] subfiles() {
        if (this.map == null) {
            return EMPTY_ARRAY;
        }
        Iterator iterator = this.map.values().iterator();
        ArrayList<AbstractFolder> arrayList = new ArrayList<AbstractFolder>(this.map.size() + 2);
        while (iterator.hasNext()) {
            AbstractFolder abstractFolder;
            Reference reference = (Reference)iterator.next();
            if (reference == null || (abstractFolder = (AbstractFolder)reference.get()) == null) continue;
            arrayList.add(abstractFolder);
        }
        return arrayList.toArray(EMPTY_ARRAY);
    }

    final boolean isInitialized() {
        return this.map != null;
    }

    final Enumeration existingSubFiles(boolean bl) {
        if (!bl) {
            return new ArrayEnumeration(this.subfiles());
        }
        QueueEnumeration queueEnumeration = new QueueEnumeration(){

            public void process(Object object) {
                AbstractFolder abstractFolder = (AbstractFolder)object;
                this.put(abstractFolder.subfiles());
            }
        };
        queueEnumeration.put(this);
        return queueEnumeration;
    }

    abstract void setAttribute(String var1, Object var2, boolean var3) throws IOException;

    public final synchronized FileObject getFileObject(String string, String string2) {
        this.check();
        if (string2 == null || string2.equals("")) {
            return this.getChild(string);
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 1 + (string2 == null ? 0 : string2.length()));
        stringBuffer.append(string).append('.').append(string2);
        return this.getChild(stringBuffer.toString());
    }

    public void refresh(boolean bl) {
        if (!this.isInitialized() && this.isFolder()) {
            return;
        }
        this.refresh(null, null, true, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addFileChangeListener(FileChangeListener fileChangeListener) {
        AbstractFolder[] abstractFolderArray = EMPTY_ARRAY;
        synchronized (abstractFolderArray) {
            if (this.listeners == null) {
                this.listeners = new EventListenerList();
            }
        }
        this.listeners.add(class$org$openide$filesystems$FileChangeListener == null ? (class$org$openide$filesystems$FileChangeListener = AbstractFolder.class$("org.openide.filesystems.FileChangeListener")) : class$org$openide$filesystems$FileChangeListener, fileChangeListener);
    }

    public final void removeFileChangeListener(FileChangeListener fileChangeListener) {
        if (this.listeners != null) {
            this.listeners.remove(class$org$openide$filesystems$FileChangeListener == null ? (class$org$openide$filesystems$FileChangeListener = AbstractFolder.class$("org.openide.filesystems.FileChangeListener")) : class$org$openide$filesystems$FileChangeListener, fileChangeListener);
        }
    }

    protected final void fileDeleted0(FileEvent fileEvent) {
        super.fireFileDeletedEvent(this.listeners(), fileEvent);
        if (fileEvent.getFile().equals(this) && this.parent != null) {
            FileEvent fileEvent2 = new FileEvent((FileObject)this.parent, fileEvent.getFile(), fileEvent.isExpected());
            this.parent.fileDeleted0(fileEvent2);
        }
    }

    protected final void fileCreated0(FileEvent fileEvent, boolean bl) {
        if (bl) {
            super.fireFileDataCreatedEvent(this.listeners(), fileEvent);
        } else {
            super.fireFileFolderCreatedEvent(this.listeners(), fileEvent);
        }
        if (fileEvent.getFile().equals(this) && this.parent != null) {
            FileEvent fileEvent2 = new FileEvent((FileObject)this.parent, fileEvent.getFile(), fileEvent.isExpected());
            this.parent.fileCreated0(fileEvent2, bl);
        }
    }

    protected final void fileCreated0(FileObject fileObject, FileObject fileObject2, boolean bl) {
        FileEvent fileEvent = new FileEvent(fileObject, fileObject2, bl);
        this.fileCreated0(fileEvent, false);
    }

    protected final void fileChanged0(FileEvent fileEvent) {
        super.fireFileChangedEvent(this.listeners(), fileEvent);
        if (fileEvent.getFile().equals(this) && this.parent != null) {
            FileEvent fileEvent2 = new FileEvent((FileObject)this.parent, fileEvent.getFile(), fileEvent.isExpected());
            this.parent.fileChanged0(fileEvent2);
        }
    }

    final void fileChanged1(FileEvent fileEvent) {
        super.fireFileChangedEvent(this.listeners(), fileEvent);
    }

    protected final void fileRenamed0(FileRenameEvent fileRenameEvent) {
        super.fireFileRenamedEvent(this.listeners(), fileRenameEvent);
        if (fileRenameEvent.getFile().equals(this) && this.parent != null) {
            FileRenameEvent fileRenameEvent2 = new FileRenameEvent(this.parent, fileRenameEvent.getFile(), fileRenameEvent.getName(), fileRenameEvent.getExt(), fileRenameEvent.isExpected());
            this.parent.fileRenamed0(fileRenameEvent2);
        }
    }

    protected final void fileAttributeChanged0(FileAttributeEvent fileAttributeEvent) {
        super.fireFileAttributeChangedEvent(this.listeners(), fileAttributeEvent);
        if (fileAttributeEvent.getFile().equals(this) && this.parent != null) {
            FileAttributeEvent fileAttributeEvent2 = new FileAttributeEvent(this.parent, fileAttributeEvent.getFile(), fileAttributeEvent.getName(), fileAttributeEvent.getOldValue(), fileAttributeEvent.getNewValue(), fileAttributeEvent.isExpected());
            this.parent.fileAttributeChanged0(fileAttributeEvent2);
        }
    }

    protected final boolean hasListeners() {
        boolean bl = this.getFileSystem().getFCLSupport().hasListeners();
        boolean bl2 = false;
        Repository repository = this.getFileSystem().getRepository();
        if (repository != null) {
            bl2 = repository.getFCLSupport().hasListeners();
        }
        return this.listeners != null && this.listeners.getListenerList().length != 0 || bl2 || bl;
    }

    protected final boolean hasAtLeastOneListeners() {
        return this.hasListeners() || this.parent != null && this.parent.hasListeners();
    }

    private final Enumeration listeners() {
        if (this.listeners == null) {
            return EmptyEnumeration.EMPTY;
        }
        return new FilterEnumeration(new ArrayEnumeration(this.listeners.getListenerList())){

            public boolean accept(Object object) {
                return object != (class$org$openide$filesystems$FileChangeListener == null ? (class$org$openide$filesystems$FileChangeListener = AbstractFolder.class$("org.openide.filesystems.FileChangeListener")) : class$org$openide$filesystems$FileChangeListener);
            }
        };
    }

    private final void check() {
        if (this.map == null) {
            this.refresh(null, null, false, false);
            if (this.map == null) {
                this.map = EMPTY;
            }
        }
    }

    protected final void refresh(String string, String string2) {
        this.refresh(string, string2, false);
    }

    protected final void refresh(String string, String string2, boolean bl) {
        if (bl && string2 != null) {
            String[] stringArray = new String[this.children.length];
            System.arraycopy(this.children, 0, stringArray, 0, this.children.length);
            int n = stringArray.length;
            while (--n >= 0) {
                if (!string2.equals(stringArray[n])) continue;
                stringArray[n] = null;
                break;
            }
            this.refresh(string, string2, true, false, stringArray);
        } else {
            this.refresh(string, string2, true, false, null);
        }
    }

    protected abstract String[] list();

    protected abstract AbstractFolder createFile(String var1);

    protected void refresh(String string, String string2, boolean bl, boolean bl2) {
        this.refresh(string, string2, bl, bl2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected final void refreshFolder(String var1_1, String var2_2, boolean var3_3, boolean var4_4, String[] var5_5) {
        try {
            this.getFileSystem().beginAtomicAction();
            var6_6 = this;
            synchronized (var6_6) {
                if (var5_5 == null) {
                    var5_5 = this.list();
                }
                if ((var7_7 = var5_5) == null && this.parent == null) {
                    var7_7 = new String[]{};
                }
                if (this.children != null || var7_7 != null) ** break block29
            }
            var19_8 = null;
            this.getFileSystem().finishAtomicAction();
            return;
            {
                var10_11 = 0;
                if (var7_7 != null) {
                    var11_12 = var7_7.length;
                    var8_14 = new HashMap<K, V>(var11_12 * 4 / 3 + 1, 0.75f);
                    var9_15 = new HashSet<String>(var11_12 * 4 / 3 + 1, 0.75f);
                    var12_16 = this.map != null ? this.map.get(var2_2) : null;
                    var13_17 = 0;
                    while (var13_17 < var11_12) {
                        var14_22 = var7_7[var13_17];
                        if (var14_22 == null) {
                            ++var10_11;
                        } else {
                            var15_26 = this.map == null ? null : (WeakReference<Object>)this.map.remove(var14_22);
                            v0 = var16_27 = var1_1 != null && var14_22.equals(var2_2) != false;
                            if (var15_26 == null || var16_27) {
                                var15_26 = new WeakReference<Object>(null);
                                var9_15.add(var14_22);
                            }
                            var8_14.put(var14_22, var15_26);
                        }
                        ++var13_17;
                    }
                    if (var1_1 != null && var12_16 != null) {
                        var8_14.put(var1_1, var12_16);
                    }
                } else {
                    var8_14 = new HashMap<String, Object>(0);
                    var9_15 = Collections.EMPTY_SET;
                }
                var11_13 = null;
                if (var3_3) {
                    if (var1_1 != null) {
                        var9_15.remove(var1_1);
                    }
                    if (this.map != null) {
                        var11_13 = this.map;
                        var12_16 = this.map.entrySet().iterator();
                        while (var12_16.hasNext()) {
                            var13_18 = (Map.Entry)var12_16.next();
                            var13_18.setValue(this.getChild((String)var13_18.getKey()));
                        }
                        if (var2_2 != null) {
                            var11_13.remove(var2_2);
                        }
                        if (var11_13.isEmpty()) {
                            var11_13 = null;
                        }
                    }
                }
                this.map = var8_14;
                if (var10_11 != 0) {
                    var12_16 = new String[var7_7.length - var10_11];
                    var13_19 = 0;
                    var14_23 = 0;
                    while (var14_23 < var7_7.length) {
                        if (var7_7[var14_23] != null) {
                            var12_16[var13_19++] = var7_7[var14_23];
                        }
                        ++var14_23;
                    }
                    this.children = var12_16;
                } else {
                    this.children = var7_7;
                }
                if (var3_3 && !var9_15.isEmpty() && this.hasAtLeastOneListeners()) {
                    var12_16 = var9_15.iterator();
                    while (var12_16.hasNext()) {
                        var13_20 = (String)var12_16.next();
                        var14_24 = this.getChild(var13_20);
                        if (var14_24 == null) continue;
                        this.fileCreated0(this, var14_24, var4_4);
                    }
                }
                if (var3_3 && var11_13 != null) {
                    var12_16 = var11_13.values().iterator();
                    while (var12_16.hasNext()) {
                        var13_21 = (AbstractFolder)var12_16.next();
                        var13_21.validFlag = false;
                        if (!this.hasAtLeastOneListeners() && !var13_21.hasAtLeastOneListeners()) continue;
                        var14_25 = new FileEvent((FileObject)var13_21, (FileObject)var13_21, var4_4);
                        var13_21.fileDeleted0(var14_25);
                    }
                }
            }
        }
        catch (Throwable var18_29) {
            var19_10 = null;
            this.getFileSystem().finishAtomicAction();
            throw var18_29;
        }
        var19_9 = null;
        this.getFileSystem().finishAtomicAction();
    }

    protected void refresh(String string, String string2, boolean bl, boolean bl2, String[] stringArray) {
        if (this.isFolder()) {
            this.refreshFolder(string, string2, bl, bl2, stringArray);
        }
    }

    protected void outputStreamClosed(boolean bl) {
        if (bl) {
            this.fileChanged0(new FileEvent(this));
        }
    }

    public final Object writeReplace() {
        return new AbstractFileObject.Replace(this.getFileSystem().getSystemName(), this.toString());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

