/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src;

import java.io.Serializable;

public final class Identifier
implements Serializable {
    public static final int NOT_YET_RESOLVED = 0;
    public static final int RESOLVED = 1;
    public static final int UNRESOLVED = 2;
    private String fullName;
    private String sourceName;
    private int namePos;
    private transient Resolver resolver;
    private int status;
    static final long serialVersionUID = -2614114568575211024L;

    private Identifier(Resolver resolver, String string) {
        this.fullName = null;
        this.sourceName = string;
        this.resolver = resolver;
        this.status = 0;
    }

    Identifier(String string, String string2, int n) {
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        this.sourceName = string2;
        this.fullName = string;
        this.status = n;
    }

    private void initNamePos() {
        this.setFullName();
        this.namePos = this.fullName.lastIndexOf(".");
        if (this.namePos != -1) {
            ++this.namePos;
        }
        if (this.fullName.startsWith(".") || this.fullName.endsWith(".")) {
            throw new IllegalArgumentException(this.fullName);
        }
    }

    private void setFullName() {
        if (this.fullName == null) {
            this.fullName = this.resolver == null ? this.sourceName : this.resolver.resolve().intern();
            this.resolver = null;
            if (this.fullName == null) {
                this.fullName = this.sourceName;
            }
        }
    }

    private Object readResolve() {
        if (this.fullName == null) {
            return Identifier.create(this.sourceName);
        }
        return Identifier.create(this.fullName, this.sourceName);
    }

    public static Identifier create(String string) {
        String string2 = string.intern();
        return new Identifier(null, string2);
    }

    public static Identifier create(String string, String string2) {
        Identifier identifier = new Identifier(null, string2.intern());
        identifier.fullName = string.intern();
        identifier.initNamePos();
        return identifier;
    }

    public static Identifier create(String string, String string2, int n) {
        Identifier identifier = Identifier.create(string, string2);
        identifier.status = n;
        return identifier;
    }

    public static Identifier create(Resolver resolver, String string) {
        return new Identifier(resolver, string.intern());
    }

    public String getName() {
        int n = this.sourceName.lastIndexOf(".");
        return n == -1 ? this.sourceName : this.sourceName.substring(n + 1);
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getQualifier() {
        if (this.fullName == null) {
            this.initNamePos();
        }
        return this.namePos == -1 ? "" : this.fullName.substring(0, this.namePos - 1);
    }

    public boolean isQualified() {
        if (this.fullName == null) {
            this.initNamePos();
        }
        return this.namePos != -1;
    }

    public String getFullName() {
        if (this.fullName == null) {
            this.initNamePos();
        }
        return this.fullName;
    }

    public int getResolutionStatus() {
        return this.status;
    }

    public String toString() {
        return this.getSourceName();
    }

    public boolean compareTo(Identifier identifier, boolean bl) {
        if (this.fullName == null) {
            this.initNamePos();
        }
        if (identifier.fullName == null) {
            identifier.initNamePos();
        }
        if (identifier.fullName == this.fullName) {
            return bl ? identifier.sourceName == this.sourceName : true;
        }
        return false;
    }

    public boolean equals(Object object) {
        return object instanceof Identifier ? this.compareTo((Identifier)object, false) : false;
    }

    public int hashCode() {
        if (this.fullName == null) {
            this.initNamePos();
        }
        return this.fullName.hashCode();
    }

    public static interface Resolver {
        public String resolve();
    }
}

