/*************************************************************************
 *
 *  $RCSfile: ce.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2003/04/15 18:44:02 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef ARY_CE_HXX
#define ARY_CE_HXX


// USED SERVICES
	// BASE CLASSES
#include <ary/re.hxx>
	// COMPONENTS
	// PARAMETERS
#include <ary/ids.hxx>

namespace ary
{
    class RepositoryEntity;



/** Represents a C++ code entity.
*/
class CodeEntity : public RepositoryEntity
{
  public:
	// LIFECYCLE
	virtual			   	~CodeEntity() {}

	// INQUIRY
	const udmstri &     LocalName() const;
	Cid                 Owner() const;
    const RepositoryEntity &
                        RE() const;
	Lid			        Location() const;
    bool                IsVisible() const;      
                              
    // ACCESS
    void                Set_InVisible()         { bIsVisible = false; }      

  protected:
                        CodeEntity() : bIsVisible(true) {}                              
                              
  private:   
    // Locals
	virtual const udmstri &
                        inq_LocalName() const = 0;
	virtual Cid         inq_Owner() const = 0;
	virtual Lid			inq_Location() const = 0;    
	
	// DATA
	mutable bool        bIsVisible;
};


// IMPLEMENTATION
inline const udmstri &
CodeEntity::LocalName() const
    { return inq_LocalName(); }
inline Cid
CodeEntity::Owner() const
    { return inq_Owner(); }
inline const RepositoryEntity &
CodeEntity::RE() const
    { return *this; }
inline Lid
CodeEntity::Location() const
    { return inq_Location(); }


}   // namespace ary


#endif



