/*************************************************************************
 *
 *  $RCSfile: dlgepbm.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: sj $ $Date: 2002/07/16 09:38:29 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop
#include <tools/ref.hxx>
#include <svtools/FilterConfigItem.hxx>
#include <vcl/msgbox.hxx>
#include "dlgepbm.hxx"
#include "dlgepbm.hrc"
#include "strings.hrc"

/*************************************************************************
|*
|* Ctor
|*
\************************************************************************/

DlgExportEPBM::DlgExportEPBM( FltCallDialogParameter& rPara ) :
				ModalDialog			( rPara.pWindow, ResId( DLG_EXPORT_EPBM, rPara.pResMgr ) ),
				aGrpFormat			( this, ResId( GRP_FORMAT ) ),
				aRBRaw				( this, ResId( RB_RAW ) ),
				aRBASCII			( this, ResId( RB_ASCII ) ),
				aBtnOK				( this, ResId( BTN_OK ) ),
				aBtnCancel			( this, ResId( BTN_CANCEL ) ),
				aBtnHelp			( this, ResId( BTN_HELP ) ),
				pMgr				( rPara.pResMgr ),
				rFltCallPara		( rPara )
{
	FreeResource();

	// Config-Parameter lesen

	String	aFilterConfigPath( RTL_CONSTASCII_USTRINGPARAM( "Office.Common/Filter/Graphic/Export/PBM" ) );
	pConfigItem = new FilterConfigItem( aFilterConfigPath, &rPara.aFilterData );
	sal_Int32	nFormat = pConfigItem->ReadInt32( String( ResId( KEY_FORMAT, pMgr ) ), 1 );

	BOOL bCheck = FALSE;
	if ( !nFormat )
		bCheck ^= TRUE;

	aRBRaw.Check( bCheck );
	bCheck ^= TRUE;
	aRBASCII.Check( bCheck );

	aBtnOK.SetClickHdl( LINK( this, DlgExportEPBM, OK ) );
}

DlgExportEPBM::~DlgExportEPBM()
{
	delete pConfigItem;
}

/*************************************************************************
|*
|* Speichert eingestellte Werte in ini-Datei
|*
\************************************************************************/

IMPL_LINK( DlgExportEPBM, OK, void *, EMPTYARG )
{

	// Config-Parameter schreiben
	sal_Int32 nFormat = 0;
	if ( aRBASCII.IsChecked() )
		nFormat++;
	pConfigItem->WriteInt32( String( ResId( KEY_FORMAT, pMgr ) ), nFormat );
	rFltCallPara.aFilterData = pConfigItem->GetFilterData();
	EndDialog( RET_OK );

	return 0;
}
