
package org.netbeans.modules.openoffice.wizard.actions.idl;

import java.util.ResourceBundle;
import org.netbeans.modules.openoffice.wizard.util.Create;
import org.netbeans.modules.openoffice.wizard.util.ModuleCreator;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public class CreateModuleAction extends NodeAction
    implements Create
{

    
        
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/actions/idl/Bundle");    
    public CreateModuleAction()
    {
    }

    protected void performAction(Node anode[])
    {
        if(enable(anode))
            ((ModuleCreator)anode[0].getCookie(ModuleCreator.class)).createModule();
    }

    protected boolean enable(Node anode[])
    {
        if(anode.length != 1)
            return false;
        if(anode[0].getCookie(ModuleCreator.class)!= null)
        {
            return true;
        }
        else
        {
            org.openide.nodes.Node.Cookie cookie = anode[0].getCookie(ModuleCreator.class);
            return false;
        }
    }

    public String getName()
    {
        return bundle.getString("TXT_CreateModule");
    }

    public String toString()
    {
        return bundle.getString("TXT_Module");
    }

    public HelpCtx getHelpCtx()
    {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isEnabled(Node anode[])
    {
        return enable(anode);
    }

    
    
}
