/*************************************************************************
 *
 *  $RCSfile: profile.c,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/15 17:41:48 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <premac.h>
#include <Files.h>
#include <Folders.h>
#include <Processes.h>
#include <postmac.h>

#include <stdio.h>
#include <string.h>

#include <osl/diagnose.h>
#include <osl/profile.h>
#include <osl/process.h>

#include "system.h"

#define LINES_INI       32
#define LINES_ADD       10
#define SECTIONS_INI    5
#define SECTIONS_ADD    3
#define ENTRIES_INI     5
#define ENTRIES_ADD     3


#define STR_INI_EXTENSION	".prefs"   /* For MAC */

#define STR_INI_BOOLYES     "yes"
#define STR_INI_BOOLON      "on"
#define STR_INI_BOOLONE     "1"
#define STR_INI_BOOLNO      "no"
#define STR_INI_BOOLOFF     "off"
#define STR_INI_BOOLZERO    "0"

#ifndef _MAX_PATH
#define _MAX_PATH			512
#endif

#pragma warn_possunwant off

typedef struct _osl_TProfileEntry
{
    sal_uInt32	m_Line;
    sal_uInt32    m_Offset;
    sal_uInt32    m_Len;
} osl_TProfileEntry;

typedef struct _osl_TProfileSection
{
    sal_uInt32			m_Line;
    sal_uInt32			m_Offset;
    sal_uInt32			m_Len;
    sal_uInt32			m_NoEntries;
    sal_uInt32			m_MaxEntries;
    osl_TProfileEntry*	m_Entries;
} osl_TProfileSection;


/*
	Profile-data structure hidden behind oslProfile:
*/
typedef struct _osl_TProfileImpl
{
	sal_Bool		m_bSaveFile;
	sal_Char        m_File[1024];
	sal_uInt32	m_NoLines;
	sal_uInt32    m_MaxLines;
	sal_uInt32    m_NoSections;
	sal_uInt32    m_MaxSections;
	sal_Char**					m_Lines;
	osl_TProfileSection*	m_Sections;
} osl_TProfileImpl;

static const sal_Char* stripBlanks(const sal_Char* String, sal_uInt32* pLen)
{
    if ( (pLen != NULL) && (*pLen != 0 ) )
    {
        while ((String[*pLen - 1] == ' ') || (String[*pLen - 1] == '\t'))
            (*pLen)--;

        while ((*String == ' ') || (*String == '\t'))
        {
            String++;
            (*pLen)--;
        }
    }
    else
        while ((*String == ' ') || (*String == '\t'))
            String++;

    return (String);
}

static const sal_Char* addLine(osl_TProfileImpl* pProfile, const sal_Char* Line)
{
    if (pProfile->m_NoLines >= pProfile->m_MaxLines)
    {
        if (pProfile->m_Lines == NULL)
        {
            pProfile->m_MaxLines = LINES_INI;
            pProfile->m_Lines = (sal_Char **)malloc(pProfile->m_MaxLines * sizeof(sal_Char *));
        }
        else
        {
            pProfile->m_MaxLines += LINES_ADD;
            pProfile->m_Lines = (sal_Char **)realloc(pProfile->m_Lines,
				                                 pProfile->m_MaxLines * sizeof(sal_Char *));
        }

        if (pProfile->m_Lines == NULL)
        {
            pProfile->m_NoLines  = 0;
            pProfile->m_MaxLines = 0;
            return (NULL);
        }

    }

    pProfile->m_Lines[pProfile->m_NoLines++] = strdup(Line);

    return (pProfile->m_Lines[pProfile->m_NoLines - 1]);
}

static const sal_Char* insertLine(osl_TProfileImpl* pProfile, const sal_Char* Line, sal_uInt32 LineNo)
{
    if (pProfile->m_NoLines >= pProfile->m_MaxLines)
    {
        if (pProfile->m_Lines == NULL)
        {
            pProfile->m_MaxLines = LINES_INI;
            pProfile->m_Lines = (sal_Char **)malloc(pProfile->m_MaxLines * sizeof(sal_Char *));
        }
        else
        {
            pProfile->m_MaxLines += LINES_ADD;
            pProfile->m_Lines = (sal_Char **)realloc(pProfile->m_Lines,
				                                 pProfile->m_MaxLines * sizeof(sal_Char *));
        }

        if (pProfile->m_Lines == NULL)
        {
            pProfile->m_NoLines  = 0;
            pProfile->m_MaxLines = 0;
            return (NULL);
        }

    }

	LineNo = LineNo > pProfile->m_NoLines ? pProfile->m_NoLines : LineNo;

	if (LineNo < pProfile->m_NoLines)
	{
		sal_uInt32 i, n;
        osl_TProfileSection* pSec;

		memmove(&pProfile->m_Lines[LineNo + 1], &pProfile->m_Lines[LineNo],
				(pProfile->m_NoLines - LineNo) * sizeof(sal_Char *));

		/* adjust line references */
		for (i = 0; i < pProfile->m_NoSections; i++)
		{
			pSec = &pProfile->m_Sections[i];

			if (pSec->m_Line >= LineNo)
				pSec->m_Line++;

			for (n = 0; n < pSec->m_NoEntries; n++)
				if (pSec->m_Entries[n].m_Line >= LineNo)
					pSec->m_Entries[n].m_Line++;
		}
	}

	pProfile->m_NoLines++;

	pProfile->m_Lines[LineNo] = strdup(Line);

    return (pProfile->m_Lines[LineNo]);
}

static void removeLine(osl_TProfileImpl* pProfile, sal_uInt32 LineNo)
{
    if (LineNo < pProfile->m_NoLines)
    {
        free(pProfile->m_Lines[LineNo]);
        if (pProfile->m_NoLines - LineNo > 1)
		{
			sal_uInt32 i, n;
			osl_TProfileSection* pSec;

            memmove(&pProfile->m_Lines[LineNo], &pProfile->m_Lines[LineNo + 1],
                    (pProfile->m_NoLines - LineNo - 1) * sizeof(sal_Char *));

			/* adjust line references */
			for (i = 0; i < pProfile->m_NoSections; i++)
			{
				pSec = &pProfile->m_Sections[i];

				if (pSec->m_Line > LineNo)
					pSec->m_Line--;

				for (n = 0; n < pSec->m_NoEntries; n++)
					if (pSec->m_Entries[n].m_Line > LineNo)
						pSec->m_Entries[n].m_Line--;
			}
		}
        pProfile->m_NoLines--;
    }

    return;
}

static void setEntry(osl_TProfileImpl* pProfile, osl_TProfileSection* pSection,
					 sal_uInt32 NoEntry, sal_uInt32 Line,
                     const sal_Char* Entry, sal_uInt32 Len)
{
    Entry = stripBlanks(Entry, &Len);
    pSection->m_Entries[NoEntry].m_Line   = Line;
    pSection->m_Entries[NoEntry].m_Offset = Entry - pProfile->m_Lines[Line];
    pSection->m_Entries[NoEntry].m_Len    = Len;

    return;
}

static sal_Bool addEntry(osl_TProfileImpl* pProfile, osl_TProfileSection *pSection,
						int Line, const sal_Char* Entry, sal_uInt32 Len)
{
    if (pSection != NULL)
    {
        if (pSection->m_NoEntries >= pSection->m_MaxEntries)
        {
            if (pSection->m_Entries == NULL)
            {
                pSection->m_MaxEntries = ENTRIES_INI;
                pSection->m_Entries = (osl_TProfileEntry *)malloc(
                                pSection->m_MaxEntries * sizeof(osl_TProfileEntry));
            }
            else
            {
                pSection->m_MaxEntries += ENTRIES_ADD;
                pSection->m_Entries = (osl_TProfileEntry *)realloc(pSection->m_Entries,
                                pSection->m_MaxEntries * sizeof(osl_TProfileEntry));
            }

            if (pSection->m_Entries == NULL)
            {
                pSection->m_NoEntries  = 0;
                pSection->m_MaxEntries = 0;
                return (sal_False);
            }
        }

        pSection->m_NoEntries++;

        Entry = stripBlanks(Entry, &Len);
        setEntry(pProfile, pSection, pSection->m_NoEntries - 1, Line,
                 Entry, Len);

        return (sal_True);
    }

    return (sal_False);
}

static void removeEntry(osl_TProfileSection *pSection, sal_uInt32 NoEntry)
{
    if (NoEntry < pSection->m_NoEntries)
    {
        if (pSection->m_NoEntries - NoEntry > 1)
            memmove(&pSection->m_Entries[NoEntry],
                    &pSection->m_Entries[NoEntry + 1],
                    (pSection->m_NoEntries - NoEntry - 1) * sizeof(osl_TProfileEntry));
        pSection->m_NoEntries--;
    }

    return;
}

static sal_Bool addSection(osl_TProfileImpl* pProfile, int Line, const sal_Char* Section, sal_uInt32 Len)
{
    if (pProfile->m_NoSections >= pProfile->m_MaxSections)
    {
        if (pProfile->m_Sections == NULL)
        {
            pProfile->m_MaxSections = SECTIONS_INI;
            pProfile->m_Sections = (osl_TProfileSection *)malloc(pProfile->m_MaxSections * sizeof(osl_TProfileSection));
        }
        else
        {
            pProfile->m_MaxSections += SECTIONS_ADD;
            pProfile->m_Sections = (osl_TProfileSection *)realloc(pProfile->m_Sections,
                                          pProfile->m_MaxSections * sizeof(osl_TProfileSection));
        }

        if (pProfile->m_Sections == NULL)
        {
            pProfile->m_NoSections = 0;
            pProfile->m_MaxSections = 0;
            return (sal_False);
        }
    }

    pProfile->m_NoSections++;

    pProfile->m_Sections[pProfile->m_NoSections - 1].m_Entries    = NULL;
    pProfile->m_Sections[pProfile->m_NoSections - 1].m_NoEntries  = 0;
    pProfile->m_Sections[pProfile->m_NoSections - 1].m_MaxEntries = 0;

    Section = (sal_Char *)stripBlanks(Section, &Len);
    pProfile->m_Sections[pProfile->m_NoSections - 1].m_Line = Line;
    pProfile->m_Sections[pProfile->m_NoSections - 1].m_Offset = Section - pProfile->m_Lines[Line];
    pProfile->m_Sections[pProfile->m_NoSections - 1].m_Len = Len;

    return (sal_True);
}

static void removeSection(osl_TProfileImpl* pProfile, osl_TProfileSection *pSection)
{
    sal_uInt32 Section;

    if ((Section = pSection - pProfile->m_Sections) < pProfile->m_NoSections)
    {
        free (pSection->m_Entries);
        if (pProfile->m_NoSections - Section > 1)
            memmove(&pProfile->m_Sections[Section], &pProfile->m_Sections[Section + 1],
                    (pProfile->m_NoSections - Section - 1) * sizeof(osl_TProfileSection));
        pProfile->m_NoSections--;
    }

    return;
}

static osl_TProfileSection* findEntry(osl_TProfileImpl* pProfile, const sal_Char* Section,
							   	      const sal_Char* Entry, sal_uInt32 *pNoEntry)
{
static  sal_uInt32    Sect = 0;
        sal_uInt32    i, n;
        sal_uInt32 Len;
        const sal_Char*	pStr;
        osl_TProfileSection* pSec;

    Len = strlen(Section);
    Section = (sal_Char *)stripBlanks(Section, &Len);

	n = Sect;

    for (i = 0; i < pProfile->m_NoSections; i++)
    {
		n %= pProfile->m_NoSections;
        pSec = &pProfile->m_Sections[n];
        if ((Len == pSec->m_Len) &&
            (strnicmp(Section, &pProfile->m_Lines[pSec->m_Line][pSec->m_Offset], pSec->m_Len)
             == 0))
            break;
        n++;
    }

	Sect = n;

    if (i < pProfile->m_NoSections)
    {
        Len = strlen(Entry);
        Entry = stripBlanks(Entry, &Len);

        *pNoEntry = pSec->m_NoEntries;

        for (i = 0; i < pSec->m_NoEntries; i++)
        {
            pStr = &pProfile->m_Lines[pSec->m_Entries[i].m_Line]
                                     [pSec->m_Entries[i].m_Offset];
            if ((Len == pSec->m_Entries[i].m_Len) &&
                (strnicmp(Entry, pStr, pSec->m_Entries[i].m_Len)
                 == 0))
            {
                *pNoEntry = i;
                break;
            }
        }
    }
    else
        pSec = NULL;

    return (pSec);
}

oslProfile SAL_CALL osl_openProfile(rtl_uString *ustrProfileName, oslProfileOption Options)
{
    sal_uInt32	i;
    sal_Char*		pStr;
	sal_Char*		pChar;
    FILE*		Stream;
	sal_Char		Line[1024];
	osl_TProfileImpl* pProfile;

	pProfile = (osl_TProfileImpl* )calloc(1, sizeof(osl_TProfileImpl));

	if (ustrProfileName == NULL)
		OSL_VERIFY(osl_getProfileName(NULL, NULL, pProfile->m_File));
    else
		strcpy(pProfile->m_File, ustrProfileName->buffer);

    if ((Stream = fopen(pProfile->m_File, "r")) == NULL)
        return (pProfile);

    pProfile->m_NoLines = 0;
    while (fgets(Line, sizeof(Line), Stream) != NULL)
    {
        if (Line[strlen(Line) - 1] == '\n')
			Line[strlen(Line) - 1] = '\0';
        if (! addLine(pProfile, Line))
		{
			free(pProfile);
            return 0;
		}
    }
    fclose(Stream);

    for (i = 0; i < pProfile->m_NoLines; i++)
    {
        pStr = (sal_Char *)stripBlanks(pProfile->m_Lines[i], NULL);

        if ((*pStr == '\0') || (*pStr == ';'))
            continue;

        if ((*pStr != '[') || ((pChar = strrchr(pStr, ']')) == NULL) ||
            ((pChar - pStr) <= 2))
        {
            /* insert entry */

            if (pProfile->m_NoSections < 1)
                continue;

            if ((pChar = strchr(pStr, '=')) == NULL)
                pChar = pStr + strlen(pStr);

            if (! addEntry(pProfile, &pProfile->m_Sections[pProfile->m_NoSections - 1],
				           i, pStr, pChar - pStr))
			{
				free(pProfile);
                return (0);
			}
        }
        else
        {
            /* new section */

            if (! addSection(pProfile, i, pStr + 1, pChar - pStr - 1))
			{
				free(pProfile);
                return (0);
			}
        }
    }

    return ((oslProfile)pProfile);
}

sal_Bool SAL_CALL osl_closeProfile(oslProfile Profile)
{
    sal_uInt32	i;
    FILE*		Stream;
	osl_TProfileImpl* pProfile = (osl_TProfileImpl*)Profile;

	if ((pProfile != 0) && (pProfile->m_Lines != NULL))
    {
        if (pProfile->m_bSaveFile)
        {
            if ((Stream = fopen(pProfile->m_File, "w+")) != NULL)
            {
				for (i = 0; i < pProfile->m_NoLines; i++)
				{
					fputs(pProfile->m_Lines[i], Stream);
	                fputc('\n', Stream);
				}

                fclose(Stream);
            }

            pProfile->m_bSaveFile = sal_False;
        }

        while (pProfile->m_NoLines > 0)
            removeLine(pProfile, pProfile->m_NoLines - 1);

        free(pProfile->m_Lines);
        pProfile->m_Lines = NULL;
        pProfile->m_MaxLines = 0;

        while (pProfile->m_NoSections > 0)
            removeSection(pProfile, &pProfile->m_Sections[pProfile->m_NoSections - 1]);

        free(pProfile->m_Sections);
        pProfile->m_Sections = NULL;
        pProfile->m_MaxSections = 0;
    }

    pProfile->m_File[0] = '\0';

	free(pProfile);

    return (sal_True);
}

sal_Bool SAL_CALL osl_readProfileString(oslProfile Profile,
                              const sal_Char* pszSection, const sal_Char* pszEntry,
                              sal_Char* pszString, sal_uInt32 MaxLen,
                              const sal_Char* pszDefault)
{
    sal_Bool		Auto;
    sal_uInt32    NoEntry;
    const sal_Char* pStr;
    osl_TProfileSection* pSec;
	osl_TProfileImpl*	 pProfile = (osl_TProfileImpl*)Profile;


    if (pProfile == 0)
    {
        Auto = sal_True;
        if ((pProfile = osl_openProfile(NULL, 0)) == NULL)
            return (sal_False);
    }
    else
        Auto = sal_False;

    if (((pSec = findEntry(pProfile, pszSection, pszEntry, &NoEntry)) != NULL) &&
        (NoEntry < pSec->m_NoEntries) &&
        ((pStr = strchr(pProfile->m_Lines[pSec->m_Entries[NoEntry].m_Line],
                        '=')) != NULL))
        pStr++;
    else
        pStr = pszDefault;

    pStr = stripBlanks(pStr, NULL);
    MaxLen = (MaxLen - 1 < strlen(pStr)) ? (MaxLen - 1) : strlen(pStr);
    pStr = stripBlanks(pStr, &MaxLen);
    strncpy(pszString, pStr, MaxLen);
    pszString[MaxLen] = '\0';

    if (Auto)
        osl_closeProfile(pProfile);

    return (sal_True);
}

sal_Bool SAL_CALL osl_readProfileBool(oslProfile Profile,
                            const sal_Char* pszSection, const sal_Char* pszEntry,
							sal_Bool Default)
{
	sal_Char Line[32];

    if (osl_readProfileString(Profile, pszSection, pszEntry, Line, sizeof(Line), ""))
    {
        if ((stricmp(Line, STR_INI_BOOLYES) == 0) ||
            (stricmp(Line, STR_INI_BOOLON)  == 0) ||
            (stricmp(Line, STR_INI_BOOLONE) == 0))
            Default = sal_True;
        else
            if ((stricmp(Line, STR_INI_BOOLNO)   == 0) ||
                (stricmp(Line, STR_INI_BOOLOFF)  == 0) ||
                (stricmp(Line, STR_INI_BOOLZERO) == 0))
                Default = sal_False;
    }

    return (Default);
}

sal_uInt32 SAL_CALL osl_readProfileIdent(oslProfile Profile,
                              const sal_Char* pszSection, const sal_Char* pszEntry,
							  sal_uInt32 FirstId, const sal_Char* Strings[],
							  sal_uInt32 Default)
{
    sal_uInt32	i;
	sal_Char		Line[256];

    if (osl_readProfileString(Profile, pszSection, pszEntry, Line, sizeof(Line), ""))
    {
        i = 0;
        while (Strings[i] != NULL)
        {
            if (stricmp(Line, Strings[i]) == 0)
            {
                Default = i + FirstId;
                break;
            }
            i++;
        }
    }

    return (Default);
}

sal_Bool SAL_CALL osl_writeProfileString(oslProfile Profile,
                               const sal_Char* pszSection, const sal_Char* pszEntry,
							   const sal_Char* pszString)
{
    sal_uInt32	i;
    sal_Bool     Auto;
    sal_uInt32    NoEntry;
    const sal_Char* pStr;
	sal_Char		Line[1024];
    osl_TProfileSection* pSec;
	osl_TProfileImpl*    pProfile = (osl_TProfileImpl*)Profile;

    if (pProfile == 0)
    {
        Auto = sal_True;
        if ((pProfile = osl_openProfile(NULL, osl_Profile_DEFAULT)) == NULL)
            return (sal_False);
    }
    else
        Auto = sal_False;

    if ((pSec = findEntry(pProfile, pszSection, pszEntry, &NoEntry)) == NULL)
    {
        Line[0] = '\0';
        addLine(pProfile, Line);

        Line[0] = '[';
        strcpy(&Line[1], pszSection);
        Line[1 + strlen(pszSection)] = ']';
        Line[2 + strlen(pszSection)] = '\0';

        if (((pStr = addLine(pProfile, Line)) == NULL) ||
            (! addSection(pProfile, pProfile->m_NoLines - 1, &pStr[1], strlen(pszSection))))
        {
			if (Auto)
				osl_closeProfile(pProfile);

            return (sal_False);
        }

        pSec = &pProfile->m_Sections[pProfile->m_NoSections - 1];
        NoEntry = pSec->m_NoEntries;
    }

    Line[0] = '\t';
    strcpy(&Line[1], pszEntry);
    Line[1 + strlen(pszEntry)] = '=';
    strcpy(&Line[2 + strlen(pszEntry)], pszString);

    if (NoEntry >= pSec->m_NoEntries)
    {
		if (pSec->m_NoEntries > 0)
			i = pSec->m_Entries[pSec->m_NoEntries - 1].m_Line + 1;
		else
			i = pSec->m_Line + 1;

        if (((pStr = insertLine(pProfile, Line, i)) == NULL) ||
            (! addEntry(pProfile, pSec, i, &pStr[1], strlen(pszEntry))))
        {
			if (Auto)
				osl_closeProfile(pProfile);

            return (sal_False);
        }

        pProfile->m_bSaveFile = sal_True;
    }
    else
    {
        i = pSec->m_Entries[NoEntry].m_Line;
        free(pProfile->m_Lines[i]);
        pProfile->m_Lines[i] = strdup(Line);
        setEntry(pProfile, pSec, NoEntry, i, &pProfile->m_Lines[i][1], strlen(pszEntry));

        pProfile->m_bSaveFile = sal_True;
    }

    if (Auto)
        osl_closeProfile(pProfile);

    return (sal_True);
}

sal_Bool SAL_CALL osl_writeProfileBool(oslProfile Profile,
                             const sal_Char* pszSection, const sal_Char* pszEntry,
							 sal_Bool Value)
{
    if (Value)
        return (osl_writeProfileString(Profile, pszSection, pszEntry, STR_INI_BOOLONE));
    else
        return (osl_writeProfileString(Profile, pszSection, pszEntry, STR_INI_BOOLZERO));
}

sal_Bool SAL_CALL osl_writeProfileIdent(oslProfile Profile,
                              const sal_Char* pszSection, const sal_Char* pszEntry,
							  sal_uInt32 FirstId, const sal_Char* Strings[],
							  sal_uInt32 Value)
{
    int i, n;

    for (n = 0; Strings[n] != NULL; n++);

    if ((i = Value - FirstId) >= n)
        return (sal_False);
    else
        return (osl_writeProfileString(Profile, pszSection, pszEntry, Strings[i]));
}

sal_Bool SAL_CALL osl_removeProfileEntry(oslProfile Profile,
                               const sal_Char *pszSection, const sal_Char *pszEntry)
{
    sal_Bool		Auto;
    sal_uInt32    NoEntry;
    osl_TProfileSection* pSec;
	osl_TProfileImpl*    pProfile = (osl_TProfileImpl*)Profile;

    if (pProfile == 0)
    {
        Auto = sal_True;
        if ((pProfile = osl_openProfile(NULL, osl_Profile_DEFAULT)) == NULL)
            return (sal_False);
    }
    else
        Auto = sal_False;

    if (((pSec = findEntry(pProfile, pszSection, pszEntry, &NoEntry)) != NULL) &&
        (NoEntry < pSec->m_NoEntries))
    {
        removeLine(pProfile, pSec->m_Entries[NoEntry].m_Line);
        removeEntry(pSec, NoEntry);
        if (pSec->m_NoEntries == 0)
        {
            removeLine(pProfile, pSec->m_Line);
            removeSection(pProfile, pSec);
        }

        pProfile->m_bSaveFile = sal_True;
    }

    if (Auto)
        osl_closeProfile(pProfile);

    return (sal_True);
}

sal_uInt32 SAL_CALL osl_getProfileSectionEntries(oslProfile Profile, const sal_Char *pszSection,
									  sal_Char* pszBuffer, sal_uInt32 MaxLen)
{
    sal_uInt32    i, n = 0;
    sal_Bool     Auto;
    sal_uInt32    NoEntry;
    osl_TProfileSection* pSec;
	osl_TProfileImpl*    pProfile = (osl_TProfileImpl*)Profile;

    if (pProfile == 0)
    {
        Auto = sal_True;
        if ((pProfile = osl_openProfile(NULL, osl_Profile_DEFAULT)) == NULL)
            return (sal_False);
    }
    else
        Auto = sal_False;

    if ((pSec = findEntry(pProfile, pszSection, "", &NoEntry)) != NULL)
	{
		if (MaxLen != 0)
		{
			for (i = 0; i < pSec->m_NoEntries; i++)
			{
				if ((n + pSec->m_Entries[i].m_Len + 1) < MaxLen)
				{
					strncpy(&pszBuffer[n], &pProfile->m_Lines[pSec->m_Entries[i].m_Line]
							[pSec->m_Entries[i].m_Offset], pSec->m_Entries[i].m_Len);
					n += pSec->m_Entries[i].m_Len;
					pszBuffer[n++] = '\0';
				}
				else
					break;

			}

			pszBuffer[n++] = '\0';
		}
		else
		{
			for (i = 0; i < pSec->m_NoEntries; i++)
				n += pSec->m_Entries[i].m_Len + 1;

			n += 1;
		}
    }
    else
        n = 0;
    if (Auto)
        osl_closeProfile(pProfile);
    return (n);
}

sal_uInt32 SAL_CALL osl_getProfileSections(oslProfile Profile, sal_Char* pszBuffer, sal_uInt32 MaxLen)
{
	sal_uInt32    i, n = 0;
#if 0 /* hier fehlt noch die neuere Implmentierung */
	osl_TProfileSection* pSec;
	osl_TProfileImpl*    pProfile = acquireProfile(Profile, sal_False);
	if (pProfile == NULL)
		return (0);
	if (! (pProfile->m_Flags & osl_Profile_SYSTEM))
	{
		if (MaxLen != 0)
		{
 			for (i = 0; i < pProfile->m_NoSections; i++)
			{
				pSec = &pProfile->m_Sections[i];
				if ((n + pSec->m_Len + 1) < MaxLen)
				{
					strncpy(&pszBuffer[n], &pProfile->m_Lines[pSec->m_Line][pSec->m_Offset],
					        pSec->m_Len);
					n += pSec->m_Len;
					pszBuffer[n++] = '\0';
				}
				else
					break;
			}
			pszBuffer[n++] = '\0';
		}
		else
		{
 			for (i = 0; i < pProfile->m_NoSections; i++)
				n += pProfile->m_Sections[i].m_Len + 1;
			n += 1;
		}
	}
	else
		n = GetPrivateProfileSectionNames(pszBuffer, MaxLen, pProfile->m_Filename);
	releaseProfile(pProfile);
#endif
	return (n);
}

static OSErr GetPathFromDirID( long DirID, short VRefNum, sal_Char *pPath )
{
	CInfoPBRec		paramBlock;
	sal_Char		dirName[256]; /* Pascal string */
	int				len;
	OSErr			err;

	*pPath = '\0';
	len = 0;

	paramBlock.dirInfo.ioNamePtr = dirName;
	paramBlock.dirInfo.ioDrParID = DirID;

	do {
		paramBlock.dirInfo.ioVRefNum = VRefNum;
		paramBlock.dirInfo.ioFDirIndex = -1;
		paramBlock.dirInfo.ioDrDirID = paramBlock.dirInfo.ioDrParID;

		err = PBGetCatInfoSync( &paramBlock );

		if (err == noErr)
		{
			if ( len + 1 + dirName[0] + 1 > _MAX_PATH )
				err = -1;
			else
			{
				memmove( pPath + dirName[0] + 1, pPath, len + 1 );
				memcpy( pPath, &dirName[1], dirName[0] );
				pPath[ dirName[0] ] = ':';
				len += dirName[0] + 1;
			}
		}
	} while ( ( err == noErr ) && ( paramBlock.dirInfo.ioDrDirID != fsRtDirID ) );

	return err;
}

static OSErr GetPrefsFolderPath(sal_Char *pszPath, sal_uInt32 MaxLen)
{
	OSErr	err;
	short	VRefNum;
	long	DirID;

	err = FindFolder(
		kOnSystemDisk,
		kPreferencesFolderType,
		kCreateFolder,
		&VRefNum,
		&DirID);

	if ( err == noErr )
		err = GetPathFromDirID( DirID, VRefNum, pszPath );

	return err;
}

static OSErr GetAppFolderPath(sal_Char *pszPath, sal_uInt32 MaxLen)
{
	FSSpec					aAppFileName;
	ProcessSerialNumber		process;
	ProcessInfoRec			procInfo;
	OSErr					err;

	process.highLongOfPSN 		= 0;
	process.lowLongOfPSN 		= kCurrentProcess;
	procInfo.processInfoLength	= sizeof(ProcessInfoRec);
	procInfo.processName		= nil;
	procInfo.processAppSpec		= &aAppFileName;

	err = GetProcessInformation( &process, &procInfo );

	if ( noErr == err )
		err = GetPathFromDirID( aAppFileName.parID,
								aAppFileName.vRefNum,
								pszPath );

	return err;
}

sal_Bool SAL_CALL osl_getProfileName(rtl_uString* ustrPath, rtl_uString* ustrName, rtl_uString** strProfileName)
{
	int   n;
	sal_Char* pStr;
	sal_Char  File[_MAX_PATH];
    rtl_uString *strBuffer = *strProfileName;

#if OSL_DEBUG_LEVEL > 1
        fprintf(stderr,"In  osl_getProfileName\n");
#endif


	/* build directory path */
	if (ustrPath)
	{
		if ( ( ustrPath->buffer[0] == ':' ) || ( ustrPath->buffer[0] == '\0' ) )
			OSL_VERIFY(GetAppFolderPath(File, _MAX_PATH) == noErr);
		else
		{
			OSL_ASSERT(strlen(ustrPath->buffer) <= _MAX_PATH);
			strcpy(File, ustrPath->buffer);
		}
	}
	else
		OSL_VERIFY(GetPrefsFolderPath(File, _MAX_PATH) == noErr);

	n = strlen(File);

	if (File[n - 1] != ':')
	{
		File[n]     = ':';
		File[n + 1] = '\0';
	}

	/* append file name */
	if (ustrName)
	{
		strcat(File, ustrName);

		/* add default extensiom */
		if (strchr(ustrName->buffer, '.') == NULL)
			strcat(File, STR_INI_EXTENSION);
	}
	else
	{
		sal_Char *pChr;
		sal_Char ProgName[_MAX_PATH];

/*		OSL_VERIFY(osl_getCommandArgs(ProgName, sizeof(ProgName)) == osl_Profile_ENONE); */

		strcpy(ProgName, "Give me a Name");
/**/

		/* remove path from filename */
		if ((pStr = strrchr(ProgName, ':')) == NULL)
			pStr = ProgName;
		else
			pStr++;

		if ((pChr = strrchr(pStr, '.')) != NULL)
			*pChr = '\0';

		strcat(File, pStr);
		strcat(File, STR_INI_EXTENSION);
	}

	/* copy filename */
        if ( strBuffer == NULL )
        {
#if OSL_DEBUG_LEVEL > 1
          fprintf(stderr,"Out osl_getProfileName, invalid argument \n");
#endif
          return (sal_False);
        }
	strncpy(strBuffer->buffer, File, strBuffer->length);
    strBuffer->buffer[strBuffer->length - 1] = '\0';

    return (strlen(File) < strBuffer->length);
}

sal_Bool SAL_CALL osl_flushProfile(oslProfile Profile)
{
	return sal_False;
}

