/*************************************************************************
 *
 *  $RCSfile: GetLogicalDriveStrings.c,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: tra $ $Date: 2000/12/12 10:58:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <windows.h>


/*
==============================================================================
GetLogicalDriveStrings
==============================================================================

	The GetLogicalDriveStrings function fills a buffer with strings that
	specify valid drives in the system. 

  
Parameters
	nBufferLength 
		[in] Specifies the maximum size, in characters, of the buffer pointed
		to by lpBuffer. This size does not include the terminating null
		character. 
	lpBuffer 
		[out] Pointer to a buffer that receives a series of null-terminated
		strings, one for each valid drive in the system, that end with a second
		null character. The following example shows the buffer contents with
		<null> representing the terminating null character. 

		c:\<null>d:\<null><null> 

Return Values
	If the function succeeds, the return value is the length, in characters,
	of the strings copied to the buffer, not including the terminating null
	character. Note that an ANSI-ASCII null character uses one byte, but a
	Unicode null character uses two bytes. 

	If the buffer is not large enough, the return value is greater than
	nBufferLength. It is the size of the buffer required to hold the drive
	strings. 

	If the function fails, the return value is zero. To get extended error
	information, use the GetLastError function. 

Remarks
	Each string in the buffer may be used wherever a root directory is
	required, such as for the GetDriveType and GetDiskFreeSpace functions. 

*/

DWORD WINAPI GetLogicalDriveStringsW_9x(
	DWORD nBufferLength,	// size of buffer
	LPWSTR lpBuffer			// drive strings buffer
)
{
	LPSTR	lpBufferA = (LPSTR)HeapAlloc( GetProcessHeap(), 0, sizeof(CHAR) * (nBufferLength + 1) );

	DWORD	dwResult = GetLogicalDriveStringsA( nBufferLength, lpBufferA );

	if ( dwResult && dwResult <= nBufferLength )
		MultiByteToWideChar( CP_ACP, 0, lpBufferA, dwResult + 1, lpBuffer, nBufferLength );

	HeapFree( GetProcessHeap(), 0, lpBufferA );

	return dwResult;
}


